// generated by diplomat-tool
import type { TimeZoneInvalidOffsetError } from "./TimeZoneInvalidOffsetError"
import type { pointer, codepoint } from "./diplomat-runtime.d.ts";


/**
 * See the [Rust documentation for `UtcOffset`](https://docs.rs/icu/latest/icu/time/zone/struct.UtcOffset.html) for more information.
 */


export class UtcOffset {
    get ffiValue(): pointer;


    /**
     * Creates an offset from seconds.
     *
     * Errors if the offset seconds are out of range.
     *
     * See the [Rust documentation for `try_from_seconds`](https://docs.rs/icu/latest/icu/time/zone/struct.UtcOffset.html#method.try_from_seconds) for more information.
     */
    static fromSeconds(seconds: number): UtcOffset;

    /**
     * Creates an offset from a string.
     *
     * See the [Rust documentation for `try_from_str`](https://docs.rs/icu/latest/icu/time/zone/struct.UtcOffset.html#method.try_from_str) for more information.
     *
     * Additional information: [1](https://docs.rs/icu/latest/icu/time/zone/struct.UtcOffset.html)
     */
    static fromString(offset: string): UtcOffset;

    /**
     * Returns the value as offset seconds.
     *
     * See the [Rust documentation for `offset`](https://docs.rs/icu/latest/icu/time/struct.TimeZoneInfo.html#method.offset) for more information.
     *
     * See the [Rust documentation for `to_seconds`](https://docs.rs/icu/latest/icu/time/zone/struct.UtcOffset.html#method.to_seconds) for more information.
     *
     * Additional information: [1](https://docs.rs/icu/latest/icu/time/zone/struct.UtcOffset.html)
     */
    get seconds(): number;

    /**
     * Returns whether the offset is positive.
     *
     * See the [Rust documentation for `is_non_negative`](https://docs.rs/icu/latest/icu/time/zone/struct.UtcOffset.html#method.is_non_negative) for more information.
     *
     * Additional information: [1](https://docs.rs/icu/latest/icu/time/zone/struct.UtcOffset.html)
     */
    get isNonNegative(): boolean;

    /**
     * Returns whether the offset is zero.
     *
     * See the [Rust documentation for `is_zero`](https://docs.rs/icu/latest/icu/time/zone/struct.UtcOffset.html#method.is_zero) for more information.
     *
     * Additional information: [1](https://docs.rs/icu/latest/icu/time/zone/struct.UtcOffset.html)
     */
    get isZero(): boolean;

    /**
     * Returns the hours part of the offset.
     *
     * See the [Rust documentation for `hours_part`](https://docs.rs/icu/latest/icu/time/zone/struct.UtcOffset.html#method.hours_part) for more information.
     *
     * Additional information: [1](https://docs.rs/icu/latest/icu/time/zone/struct.UtcOffset.html)
     */
    get hoursPart(): number;

    /**
     * Returns the minutes part of the offset.
     *
     * See the [Rust documentation for `minutes_part`](https://docs.rs/icu/latest/icu/time/zone/struct.UtcOffset.html#method.minutes_part) for more information.
     *
     * Additional information: [1](https://docs.rs/icu/latest/icu/time/zone/struct.UtcOffset.html)
     */
    get minutesPart(): number;

    /**
     * Returns the seconds part of the offset.
     *
     * See the [Rust documentation for `seconds_part`](https://docs.rs/icu/latest/icu/time/zone/struct.UtcOffset.html#method.seconds_part) for more information.
     *
     * Additional information: [1](https://docs.rs/icu/latest/icu/time/zone/struct.UtcOffset.html)
     */
    get secondsPart(): number;
}