// This file is autogenerated.
package localescompressed

import (
	"math"
	"strconv"
	"time"

	"github.com/gohugoio/locales"
	"github.com/gohugoio/locales/currency"
)

var fnLocale_5a217059c67094defae82f249f55f4c5 = func(ln *localen) string {
	return ln.locale
}

var fnPluralsCardinal_85b19cac1fab9f2c2cfb9eb41539aa0e = func(ln *localen) []locales.PluralRule {
	return ln.pluralsCardinal
}

var fnPluralsOrdinal_16a60aa09da9778fa82fe463e83076de = func(ln *localen) []locales.PluralRule {
	return ln.pluralsOrdinal
}

var fnPluralsRange_332465bda13eb808b3664fa0500f54ce = func(ln *localen) []locales.PluralRule {
	return ln.pluralsRange
}

var fnCardinalPluralRule_0758171f702b5b6024bdf47d25d8166d = func(ln *localen, num float64, v uint64) locales.PluralRule {
	n := math.Abs(num)

	if n == 1 {
		return locales.PluralRuleOne
	}

	return locales.PluralRuleOther
}

var fnOrdinalPluralRule_3355865f05dde9af2a36ba415bea85cb = func(ln *localen, num float64, v uint64) locales.PluralRule {
	return locales.PluralRuleOther
}

var fnRangePluralRule_91a918d93f773c0b7589da5ebb6c4164 = func(ln *localen, num1 float64, v1 uint64, num2 float64, v2 uint64) locales.PluralRule {
	return locales.PluralRuleOther
}

var fnMonthAbbreviated_aa9a9957cd9d056ba078b36a08b17478 = func(ln *localen, month time.Month) string {
	return ln.monthsAbbreviated[month]
}

var fnMonthsAbbreviated_181f77804b62232997fae36bd57d6cf7 = func(ln *localen) []string {
	return ln.monthsAbbreviated[1:]
}

var fnMonthNarrow_45916040ecf6fc350894d9e3e6c46dc7 = func(ln *localen, month time.Month) string {
	return ln.monthsNarrow[month]
}

var fnMonthsNarrow_75daa2ba82ae9577292175c3f52370cc = func(ln *localen) []string {
	return ln.monthsNarrow[1:]
}

var fnMonthWide_4c946a7e7581c665e7407df1841810b5 = func(ln *localen, month time.Month) string {
	return ln.monthsWide[month]
}

var fnMonthsWide_0ecf36a8b72255e2fee9467af362e989 = func(ln *localen) []string {
	return ln.monthsWide[1:]
}

var fnWeekdayAbbreviated_4ffbdfbd2be10e6bd8fb5a542a14664a = func(ln *localen, weekday time.Weekday) string {
	return ln.daysAbbreviated[weekday]
}

var fnWeekdaysAbbreviated_454a3d7d23c662520a64ae5245d404be = func(ln *localen) []string {
	return ln.daysAbbreviated
}

var fnWeekdayNarrow_e86921b3446df5ea9afe9504cfa20d1a = func(ln *localen, weekday time.Weekday) string {
	return ln.daysNarrow[weekday]
}

var fnWeekdaysNarrow_d23eb0b7a498c40ce19d1bf231cad524 = func(ln *localen) []string {
	return ln.daysNarrow
}

var fnWeekdayShort_82b231d4f504c6d71c7e495aa35cd3c2 = func(ln *localen, weekday time.Weekday) string {
	return ln.daysShort[weekday]
}

var fnWeekdaysShort_eb6ee64d01e314991432b4469790d38b = func(ln *localen) []string {
	return ln.daysShort
}

var fnWeekdayWide_ab7e026d8685cefd89c5aeb5df512a9a = func(ln *localen, weekday time.Weekday) string {
	return ln.daysWide[weekday]
}

var fnWeekdaysWide_5e2bbf75a31e730429c100e8a0bd3ebd = func(ln *localen) []string {
	return ln.daysWide
}

var fnDecimal_a78485e7dd32c95f41af4e18420793bf = func(ln *localen) string {
	return ln.decimal
}

var fnGroup_5c4b80a5ccdee81467241784ab8fcd56 = func(ln *localen) string {
	return ln.group
}

var fnMinus_8b8229905258388dc16a5e0c270b0488 = func(ln *localen) string {
	return ln.minus
}

var fnFmtNumber_0866206624669dc4f03297eb76a545b2 = func(ln *localen, num float64, v uint64) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	l := len(s) + 2 + 2*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				for j := len(ln.group) - 1; j >= 0; j-- {
					b = append(b, ln.group[j])
				}
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {
		b = append(b, ln.minus[0])
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	return string(b)
}

var fnFmtPercent_1c35b3868bf10d0e69b22b2e80c40671 = func(ln *localen, num float64, v uint64) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	l := len(s) + 3
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			continue
		}

		b = append(b, s[i])
	}

	if num < 0 {
		b = append(b, ln.minus[0])
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	b = append(b, ln.percent...)

	return string(b)
}

var fnFmtCurrency_ec1a372391d9fcdfb2e025fe6142dc3b = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 2 + 2*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				for j := len(ln.group) - 1; j >= 0; j-- {
					b = append(b, ln.group[j])
				}
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	for j := len(symbol) - 1; j >= 0; j-- {
		b = append(b, symbol[j])
	}

	if num < 0 {
		b = append(b, ln.minus[0])
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	return string(b)
}

var fnFmtAccounting_ee2956d02335482ec6b7e9a423beb0b5 = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 4 + 2*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				for j := len(ln.group) - 1; j >= 0; j-- {
					b = append(b, ln.group[j])
				}
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {

		for j := len(symbol) - 1; j >= 0; j-- {
			b = append(b, symbol[j])
		}

		b = append(b, ln.currencyNegativePrefix[0])

	} else {
		for j := len(symbol) - 1; j >= 0; j-- {
			b = append(b, symbol[j])
		}
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	if num < 0 {
		b = append(b, ln.currencyNegativeSuffix...)
	}

	return string(b)
}

var fnFmtDateShort_93e0dc80e7e3deca3036cf894d743e0e = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0x2d}...)

	if t.Month() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Month()), 10)

	b = append(b, []byte{0x2d}...)

	if t.Day() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Day()), 10)

	return string(b)
}

var fnFmtDateMedium_358c9403a9e4cad0b8974bed45e6527c = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Day() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsAbbreviated[t.Month()]...)
	b = append(b, []byte{0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtDateLong_85907dc745b1a23de90d4a44c3222404 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Day() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtDateFull_aa89072e939f6d411d6d93fa47eed117 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = append(b, ln.daysWide[t.Weekday()]...)
	b = append(b, []byte{0x20}...)

	if t.Day() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtTimeShort_8ffba4d1a2f04a0a6486853d76cf434b = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Hour() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Hour()), 10)
	b = append(b, ln.timeSeparator...)

	if t.Minute() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Minute()), 10)

	return string(b)
}

var fnFmtTimeMedium_b6f697552cd4965cd1195fe56dc87003 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Hour() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Hour()), 10)
	b = append(b, ln.timeSeparator...)

	if t.Minute() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Minute()), 10)
	b = append(b, ln.timeSeparator...)

	if t.Second() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Second()), 10)

	return string(b)
}

var fnFmtTimeLong_987bec4676d3a5de4218e415e123649d = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Hour() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Hour()), 10)
	b = append(b, ln.timeSeparator...)

	if t.Minute() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Minute()), 10)
	b = append(b, ln.timeSeparator...)

	if t.Second() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Second()), 10)
	b = append(b, []byte{0x20}...)

	tz, _ := t.Zone()
	b = append(b, tz...)

	return string(b)
}

var fnFmtTimeFull_ebdf96de1e47f9043145564c500ef7dc = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Hour() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Hour()), 10)
	b = append(b, ln.timeSeparator...)

	if t.Minute() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Minute()), 10)
	b = append(b, ln.timeSeparator...)

	if t.Second() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Second()), 10)
	b = append(b, []byte{0x20}...)

	tz, _ := t.Zone()

	if btz, ok := ln.timezones[tz]; ok {
		b = append(b, btz...)
	} else {
		b = append(b, tz...)
	}

	return string(b)
}

var fnFmtDateMedium_cb43e8c32d5cd0a27ac6db293a7981fd = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsAbbreviated[t.Month()]...)
	b = append(b, []byte{0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtDateLong_506f643cda0514f66d873a9ea99bf639 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtDateFull_e5aac3b796a648ed7f4aaa501e4e3844 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = append(b, ln.daysWide[t.Weekday()]...)
	b = append(b, []byte{0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtTimeShort_8288b817c5c0216c9815524c71c9e0b4 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	h := t.Hour()

	if h > 12 {
		h -= 12
	}

	b = strconv.AppendInt(b, int64(h), 10)
	b = append(b, ln.timeSeparator...)

	if t.Minute() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Minute()), 10)
	b = append(b, []byte{0x20}...)

	if t.Hour() < 12 {
		b = append(b, ln.periodsAbbreviated[0]...)
	} else {
		b = append(b, ln.periodsAbbreviated[1]...)
	}

	return string(b)
}

var fnFmtTimeMedium_8ef07f6477b7a4944577d4e5392ff21b = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	h := t.Hour()

	if h > 12 {
		h -= 12
	}

	b = strconv.AppendInt(b, int64(h), 10)
	b = append(b, ln.timeSeparator...)

	if t.Minute() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Minute()), 10)
	b = append(b, ln.timeSeparator...)

	if t.Second() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Second()), 10)
	b = append(b, []byte{0x20}...)

	if t.Hour() < 12 {
		b = append(b, ln.periodsAbbreviated[0]...)
	} else {
		b = append(b, ln.periodsAbbreviated[1]...)
	}

	return string(b)
}

var fnFmtTimeLong_4429ef4fb58a2a9c4d7d5132fd16ecbf = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	h := t.Hour()

	if h > 12 {
		h -= 12
	}

	b = strconv.AppendInt(b, int64(h), 10)
	b = append(b, ln.timeSeparator...)

	if t.Minute() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Minute()), 10)
	b = append(b, ln.timeSeparator...)

	if t.Second() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Second()), 10)
	b = append(b, []byte{0x20}...)

	if t.Hour() < 12 {
		b = append(b, ln.periodsAbbreviated[0]...)
	} else {
		b = append(b, ln.periodsAbbreviated[1]...)
	}

	b = append(b, []byte{0x20}...)

	tz, _ := t.Zone()
	b = append(b, tz...)

	return string(b)
}

var fnFmtTimeFull_37fe4deeee789852cc196a6a1a2f0ccc = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	h := t.Hour()

	if h > 12 {
		h -= 12
	}

	b = strconv.AppendInt(b, int64(h), 10)
	b = append(b, ln.timeSeparator...)

	if t.Minute() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Minute()), 10)
	b = append(b, ln.timeSeparator...)

	if t.Second() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Second()), 10)
	b = append(b, []byte{0x20}...)

	if t.Hour() < 12 {
		b = append(b, ln.periodsAbbreviated[0]...)
	} else {
		b = append(b, ln.periodsAbbreviated[1]...)
	}

	b = append(b, []byte{0x20}...)

	tz, _ := t.Zone()

	if btz, ok := ln.timezones[tz]; ok {
		b = append(b, btz...)
	} else {
		b = append(b, tz...)
	}

	return string(b)
}

var fnCardinalPluralRule_6d6ec1478c59480bfd820f2a0c64a497 = func(ln *localen, num float64, v uint64) locales.PluralRule {
	return locales.PluralRuleUnknown
}

var fnOrdinalPluralRule_a0e5467912a746c396065750c68e4318 = func(ln *localen, num float64, v uint64) locales.PluralRule {
	return locales.PluralRuleUnknown
}

var fnRangePluralRule_e0f62e2cf3ae7407fb4b54d084341c0b = func(ln *localen, num1 float64, v1 uint64, num2 float64, v2 uint64) locales.PluralRule {
	return locales.PluralRuleUnknown
}

var fnFmtNumber_ceab7ec754f7f75fd13d22457c77cbf9 = func(ln *localen, num float64, v uint64) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	l := len(s) + 1 + 2*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				for j := len(ln.group) - 1; j >= 0; j-- {
					b = append(b, ln.group[j])
				}
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {
		b = append(b, ln.minus[0])
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	return string(b)
}

var fnFmtPercent_a2e6b1aef5e145e790a5623d4a4e442c = func(ln *localen, num float64, v uint64) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	l := len(s) + 1
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			continue
		}

		b = append(b, s[i])
	}

	if num < 0 {
		b = append(b, ln.minus[0])
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	b = append(b, ln.percent...)

	return string(b)
}

var fnFmtCurrency_2f14500b7d52d9b6d26d90cfb96161ed = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 1 + 2*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				for j := len(ln.group) - 1; j >= 0; j-- {
					b = append(b, ln.group[j])
				}
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {
		b = append(b, ln.minus[0])
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	b = append(b, symbol...)

	return string(b)
}

var fnFmtAccounting_c53d1c28077fe8a91eda0e7a76463f6d = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 1 + 2*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				for j := len(ln.group) - 1; j >= 0; j-- {
					b = append(b, ln.group[j])
				}
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {
		b = append(b, ln.minus[0])
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	if num < 0 {
		b = append(b, symbol...)
	} else {
		b = append(b, symbol...)
	}

	return string(b)
}

var fnFmtDateShort_222c809496186523124eb16d6c474592 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2f}...)
	b = strconv.AppendInt(b, int64(t.Month()), 10)
	b = append(b, []byte{0x2f}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtDateMedium_5e450105cccbc820e4514899ef73128f = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsAbbreviated[t.Month()]...)
	b = append(b, []byte{0x2c, 0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnCardinalPluralRule_1a767992f2534d16887981ec7c7c1cfb = func(ln *localen, num float64, v uint64) locales.PluralRule {
	n := math.Abs(num)

	if n >= 0 && n <= 1 {
		return locales.PluralRuleOne
	}

	return locales.PluralRuleOther
}

var fnRangePluralRule_cb15430758f15901fa8a71a0aedc08f8 = func(ln *localen, num1 float64, v1 uint64, num2 float64, v2 uint64) locales.PluralRule {
	start := ln.CardinalPluralRule(num1, v1)
	end := ln.CardinalPluralRule(num2, v2)

	if start == locales.PluralRuleOne && end == locales.PluralRuleOne {
		return locales.PluralRuleOther
	} else if start == locales.PluralRuleOne && end == locales.PluralRuleOther {
		return locales.PluralRuleOther
	} else if start == locales.PluralRuleOther && end == locales.PluralRuleOne {
		return locales.PluralRuleOne
	}

	return locales.PluralRuleOther
}

var fnMonthsNarrow_1edc513af8c7151dc8fe1f42c7d497ba = func(ln *localen) []string {
	return nil
}

var fnFmtNumber_2816fdab36e719be095a370ff42e599f = func(ln *localen, num float64, v uint64) string {
	return strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
}

var fnFmtPercent_016773d83796aa19d80b7c33bf377883 = func(ln *localen, num float64, v uint64) string {
	return strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
}

var fnFmtCurrency_21670b336e6e64700cc7f949f05c390f = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 1 + 1*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				b = append(b, ln.group[0])
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	for j := len(symbol) - 1; j >= 0; j-- {
		b = append(b, symbol[j])
	}

	if num < 0 {
		b = append(b, ln.minus[0])
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	return string(b)
}

var fnFmtAccounting_ec9761d27ad9ead532f5f112e23983b1 = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 1 + 1*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				b = append(b, ln.group[0])
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {

		for j := len(symbol) - 1; j >= 0; j-- {
			b = append(b, symbol[j])
		}

		b = append(b, ln.minus[0])

	} else {
		for j := len(symbol) - 1; j >= 0; j-- {
			b = append(b, symbol[j])
		}
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	return string(b)
}

var fnFmtDateShort_93244c9b90b1456ed872d8fc125fd668 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Year() > 9 {
		b = append(b, strconv.Itoa(t.Year())[2:]...)
	} else {
		b = append(b, strconv.Itoa(t.Year())[1:]...)
	}

	b = append(b, []byte{0x2f}...)

	if t.Month() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Month()), 10)

	b = append(b, []byte{0x2f}...)

	if t.Day() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Day()), 10)

	return string(b)
}

var fnFmtDateMedium_596f6f3746d292714e1810c0b50dd05c = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsAbbreviated[t.Month()]...)
	b = append(b, []byte{0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)

	return string(b)
}

var fnFmtDateLong_4ff37a0cfcd7dfa30a768d81e70d334e = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)

	return string(b)
}

var fnFmtDateFull_9d575487ce5a187f6efc22e6d3f8a058 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = append(b, ln.daysWide[t.Weekday()]...)
	b = append(b, []byte{0x2c, 0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x20}...)

	if t.Day() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Day()), 10)

	return string(b)
}

var fnCardinalPluralRule_75ab0b9c6a421f5e6ca85392796c18cc = func(ln *localen, num float64, v uint64) locales.PluralRule {
	n := math.Abs(num)
	i := int64(n)

	if (i == 0) || (n == 1) {
		return locales.PluralRuleOne
	}

	return locales.PluralRuleOther
}

var fnRangePluralRule_f6915080a9290ab0c1dd0a3b010cbce8 = func(ln *localen, num1 float64, v1 uint64, num2 float64, v2 uint64) locales.PluralRule {
	start := ln.CardinalPluralRule(num1, v1)
	end := ln.CardinalPluralRule(num2, v2)

	if start == locales.PluralRuleOne && end == locales.PluralRuleOne {
		return locales.PluralRuleOne
	} else if start == locales.PluralRuleOne && end == locales.PluralRuleOther {
		return locales.PluralRuleOther
	}

	return locales.PluralRuleOther
}

var fnFmtNumber_fc1f852c40326b41ed4436818cad7bfb = func(ln *localen, num float64, v uint64) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	l := len(s) + 2 + 1*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				b = append(b, ln.group[0])
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {
		b = append(b, ln.minus[0])
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	return string(b)
}

var fnFmtCurrency_6c366a94338df615a7797e45c90cead1 = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 2 + 1*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				b = append(b, ln.group[0])
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	for j := len(symbol) - 1; j >= 0; j-- {
		b = append(b, symbol[j])
	}

	if num < 0 {
		b = append(b, ln.minus[0])
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	return string(b)
}

var fnFmtAccounting_632207f09bf5cde35a195cefb6bc8623 = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 4 + 1*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				b = append(b, ln.group[0])
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {

		for j := len(symbol) - 1; j >= 0; j-- {
			b = append(b, symbol[j])
		}

		b = append(b, ln.currencyNegativePrefix[0])

	} else {
		for j := len(symbol) - 1; j >= 0; j-- {
			b = append(b, symbol[j])
		}
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	if num < 0 {
		b = append(b, ln.currencyNegativeSuffix...)
	}

	return string(b)
}

var fnFmtDateShort_529ba7a02bedd437d0833b1afdb768c8 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Day() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2f}...)

	if t.Month() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Month()), 10)

	b = append(b, []byte{0x2f}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtDateFull_3b6427a32603f02ec4f5128c007220b3 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2c, 0x20}...)
	b = append(b, ln.daysWide[t.Weekday()]...)

	return string(b)
}

var fnCardinalPluralRule_f27514af189883ea7cd186156edfe998 = func(ln *localen, num float64, v uint64) locales.PluralRule {
	n := math.Abs(num)
	nMod100 := math.Mod(n, 100)

	if n == 0 {
		return locales.PluralRuleZero
	} else if n == 1 {
		return locales.PluralRuleOne
	} else if n == 2 {
		return locales.PluralRuleTwo
	} else if nMod100 >= 3 && nMod100 <= 10 {
		return locales.PluralRuleFew
	} else if nMod100 >= 11 && nMod100 <= 99 {
		return locales.PluralRuleMany
	}

	return locales.PluralRuleOther
}

var fnRangePluralRule_47500e2a682fd3a64da69f06f7b93c0a = func(ln *localen, num1 float64, v1 uint64, num2 float64, v2 uint64) locales.PluralRule {
	start := ln.CardinalPluralRule(num1, v1)
	end := ln.CardinalPluralRule(num2, v2)

	if start == locales.PluralRuleZero && end == locales.PluralRuleOne {
		return locales.PluralRuleZero
	} else if start == locales.PluralRuleZero && end == locales.PluralRuleTwo {
		return locales.PluralRuleZero
	} else if start == locales.PluralRuleZero && end == locales.PluralRuleFew {
		return locales.PluralRuleFew
	} else if start == locales.PluralRuleZero && end == locales.PluralRuleMany {
		return locales.PluralRuleMany
	} else if start == locales.PluralRuleZero && end == locales.PluralRuleOther {
		return locales.PluralRuleOther
	} else if start == locales.PluralRuleOne && end == locales.PluralRuleTwo {
		return locales.PluralRuleOther
	} else if start == locales.PluralRuleOne && end == locales.PluralRuleFew {
		return locales.PluralRuleFew
	} else if start == locales.PluralRuleOne && end == locales.PluralRuleMany {
		return locales.PluralRuleMany
	} else if start == locales.PluralRuleOne && end == locales.PluralRuleOther {
		return locales.PluralRuleOther
	} else if start == locales.PluralRuleTwo && end == locales.PluralRuleFew {
		return locales.PluralRuleFew
	} else if start == locales.PluralRuleTwo && end == locales.PluralRuleMany {
		return locales.PluralRuleMany
	} else if start == locales.PluralRuleTwo && end == locales.PluralRuleOther {
		return locales.PluralRuleOther
	} else if start == locales.PluralRuleFew && end == locales.PluralRuleFew {
		return locales.PluralRuleFew
	} else if start == locales.PluralRuleFew && end == locales.PluralRuleMany {
		return locales.PluralRuleMany
	} else if start == locales.PluralRuleFew && end == locales.PluralRuleOther {
		return locales.PluralRuleOther
	} else if start == locales.PluralRuleMany && end == locales.PluralRuleFew {
		return locales.PluralRuleFew
	} else if start == locales.PluralRuleMany && end == locales.PluralRuleMany {
		return locales.PluralRuleMany
	} else if start == locales.PluralRuleMany && end == locales.PluralRuleOther {
		return locales.PluralRuleOther
	} else if start == locales.PluralRuleOther && end == locales.PluralRuleOne {
		return locales.PluralRuleOther
	} else if start == locales.PluralRuleOther && end == locales.PluralRuleTwo {
		return locales.PluralRuleOther
	} else if start == locales.PluralRuleOther && end == locales.PluralRuleFew {
		return locales.PluralRuleFew
	} else if start == locales.PluralRuleOther && end == locales.PluralRuleMany {
		return locales.PluralRuleMany
	}

	return locales.PluralRuleOther
}

var fnFmtNumber_eef52ddc8fa71bd12171ac9ef3cd3328 = func(ln *localen, num float64, v uint64) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	l := len(s) + 5 + 2*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			for j := len(ln.decimal) - 1; j >= 0; j-- {
				b = append(b, ln.decimal[j])
			}
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				for j := len(ln.group) - 1; j >= 0; j-- {
					b = append(b, ln.group[j])
				}
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {
		for j := len(ln.minus) - 1; j >= 0; j-- {
			b = append(b, ln.minus[j])
		}
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	return string(b)
}

var fnFmtPercent_60ca2e9d27b8160a5fec0f6694129759 = func(ln *localen, num float64, v uint64) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	l := len(s) + 9
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			for j := len(ln.decimal) - 1; j >= 0; j-- {
				b = append(b, ln.decimal[j])
			}
			continue
		}

		b = append(b, s[i])
	}

	if num < 0 {
		for j := len(ln.minus) - 1; j >= 0; j-- {
			b = append(b, ln.minus[j])
		}
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	b = append(b, ln.percent...)

	return string(b)
}

var fnFmtCurrency_e28d302f22cf4ed4b5009e290f74e359 = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 7 + 2*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			for j := len(ln.decimal) - 1; j >= 0; j-- {
				b = append(b, ln.decimal[j])
			}
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				for j := len(ln.group) - 1; j >= 0; j-- {
					b = append(b, ln.group[j])
				}
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {
		for j := len(ln.minus) - 1; j >= 0; j-- {
			b = append(b, ln.minus[j])
		}
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	b = append(b, ln.currencyPositiveSuffix...)

	b = append(b, symbol...)

	return string(b)
}

var fnFmtAccounting_f74088692afba81682b73af3d3e7c19a = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 7 + 2*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			for j := len(ln.decimal) - 1; j >= 0; j-- {
				b = append(b, ln.decimal[j])
			}
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				for j := len(ln.group) - 1; j >= 0; j-- {
					b = append(b, ln.group[j])
				}
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {
		for j := len(ln.minus) - 1; j >= 0; j-- {
			b = append(b, ln.minus[j])
		}
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	if num < 0 {
		b = append(b, ln.currencyNegativeSuffix...)
		b = append(b, symbol...)
	} else {

		b = append(b, ln.currencyPositiveSuffix...)
		b = append(b, symbol...)
	}

	return string(b)
}

var fnFmtDateShort_05c85041b5f9b6fa224b9c4ba9be3590 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0xe2, 0x80, 0x8f, 0x2f}...)
	b = strconv.AppendInt(b, int64(t.Month()), 10)
	b = append(b, []byte{0xe2, 0x80, 0x8f, 0x2f}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtDateMedium_a55320da438aec0cfbc31bc4d718abc1 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Day() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0xe2, 0x80, 0x8f, 0x2f}...)

	if t.Month() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Month()), 10)

	b = append(b, []byte{0xe2, 0x80, 0x8f, 0x2f}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtDateFull_2d3b405215099e683568cb9c052cbd54 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = append(b, ln.daysWide[t.Weekday()]...)
	b = append(b, []byte{0xd8, 0x8c, 0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtNumber_f253fbd23af5a54db29f42f905c9e33a = func(ln *localen, num float64, v uint64) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	l := len(s) + 4 + 1*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				b = append(b, ln.group[0])
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {
		for j := len(ln.minus) - 1; j >= 0; j-- {
			b = append(b, ln.minus[j])
		}
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	return string(b)
}

var fnFmtPercent_fb7ade3a9509df0c54be19484c433a01 = func(ln *localen, num float64, v uint64) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	l := len(s) + 8
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			continue
		}

		b = append(b, s[i])
	}

	if num < 0 {
		for j := len(ln.minus) - 1; j >= 0; j-- {
			b = append(b, ln.minus[j])
		}
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	b = append(b, ln.percent...)

	return string(b)
}

var fnFmtCurrency_2c2268a7a667170346d6d4c829feb8a4 = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 6 + 1*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				b = append(b, ln.group[0])
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {
		for j := len(ln.minus) - 1; j >= 0; j-- {
			b = append(b, ln.minus[j])
		}
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	b = append(b, ln.currencyPositiveSuffix...)

	b = append(b, symbol...)

	return string(b)
}

var fnFmtAccounting_d5455f8fcf723c4be2a5a03fd41298f2 = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 6 + 1*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				b = append(b, ln.group[0])
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {
		for j := len(ln.minus) - 1; j >= 0; j-- {
			b = append(b, ln.minus[j])
		}
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	if num < 0 {
		b = append(b, ln.currencyNegativeSuffix...)
		b = append(b, symbol...)
	} else {

		b = append(b, ln.currencyPositiveSuffix...)
		b = append(b, symbol...)
	}

	return string(b)
}

var fnFmtTimeShort_d0370e7a739d1d7da91c2071fa2c12c5 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Hour()), 10)
	b = append(b, ln.timeSeparator...)

	if t.Minute() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Minute()), 10)

	return string(b)
}

var fnFmtTimeMedium_c3e2f72b9dd7b60e99ec7ed62baf96a4 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Hour()), 10)
	b = append(b, ln.timeSeparator...)

	if t.Minute() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Minute()), 10)
	b = append(b, ln.timeSeparator...)

	if t.Second() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Second()), 10)

	return string(b)
}

var fnFmtTimeLong_14ec37cb9b88b34ab642f7ee8fd2800b = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Hour()), 10)
	b = append(b, ln.timeSeparator...)

	if t.Minute() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Minute()), 10)
	b = append(b, ln.timeSeparator...)

	if t.Second() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Second()), 10)
	b = append(b, []byte{0x20}...)

	tz, _ := t.Zone()
	b = append(b, tz...)

	return string(b)
}

var fnFmtTimeFull_103caa51aab787e802d47e2174ea5313 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Hour()), 10)
	b = append(b, ln.timeSeparator...)

	if t.Minute() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Minute()), 10)
	b = append(b, ln.timeSeparator...)

	if t.Second() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Second()), 10)
	b = append(b, []byte{0x20}...)

	tz, _ := t.Zone()

	if btz, ok := ln.timezones[tz]; ok {
		b = append(b, btz...)
	} else {
		b = append(b, tz...)
	}

	return string(b)
}

var fnFmtPercent_f074e0c8dff3d1b13a6f552a71cedb58 = func(ln *localen, num float64, v uint64) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	l := len(s) + 7
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			for j := len(ln.decimal) - 1; j >= 0; j-- {
				b = append(b, ln.decimal[j])
			}
			continue
		}

		b = append(b, s[i])
	}

	if num < 0 {
		for j := len(ln.minus) - 1; j >= 0; j-- {
			b = append(b, ln.minus[j])
		}
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	b = append(b, ln.percent...)

	return string(b)
}

var fnOrdinalPluralRule_2d950970290e57f43f401dd367ad94dc = func(ln *localen, num float64, v uint64) locales.PluralRule {
	n := math.Abs(num)

	if n == 1 || n == 5 || n == 7 || n == 8 || n == 9 || n == 10 {
		return locales.PluralRuleOne
	} else if n == 2 || n == 3 {
		return locales.PluralRuleTwo
	} else if n == 4 {
		return locales.PluralRuleFew
	} else if n == 6 {
		return locales.PluralRuleMany
	}

	return locales.PluralRuleOther
}

var fnFmtNumber_d7ae7636100e1f19a61ae0ac52b51e8c = func(ln *localen, num float64, v uint64) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	l := len(s) + 2 + 1*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	inSecondary := false
	groupThreshold := 3

	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == groupThreshold {
				b = append(b, ln.group[0])
				count = 1

				if !inSecondary {
					inSecondary = true
					groupThreshold = 2
				}
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {
		b = append(b, ln.minus[0])
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	return string(b)
}

var fnFmtCurrency_9f465d9454a1702118c7b32dfb89b3d1 = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 4 + 1*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	inSecondary := false
	groupThreshold := 3

	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == groupThreshold {
				b = append(b, ln.group[0])
				count = 1

				if !inSecondary {
					inSecondary = true
					groupThreshold = 2
				}
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	for j := len(symbol) - 1; j >= 0; j-- {
		b = append(b, symbol[j])
	}

	for j := len(ln.currencyPositivePrefix) - 1; j >= 0; j-- {
		b = append(b, ln.currencyPositivePrefix[j])
	}

	if num < 0 {
		b = append(b, ln.minus[0])
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	return string(b)
}

var fnFmtAccounting_cd503abfb0c9bd938bcf20e65858f8d7 = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 4 + 1*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	inSecondary := false
	groupThreshold := 3

	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == groupThreshold {
				b = append(b, ln.group[0])
				count = 1

				if !inSecondary {
					inSecondary = true
					groupThreshold = 2
				}
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {

		for j := len(symbol) - 1; j >= 0; j-- {
			b = append(b, symbol[j])
		}

		for j := len(ln.currencyNegativePrefix) - 1; j >= 0; j-- {
			b = append(b, ln.currencyNegativePrefix[j])
		}

		b = append(b, ln.minus[0])

	} else {

		for j := len(symbol) - 1; j >= 0; j-- {
			b = append(b, symbol[j])
		}

		for j := len(ln.currencyPositivePrefix) - 1; j >= 0; j-- {
			b = append(b, ln.currencyPositivePrefix[j])
		}

	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	return string(b)
}

var fnFmtDateShort_48f6d56925de0117a6fe7b1ec232f585 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2d}...)
	b = strconv.AppendInt(b, int64(t.Month()), 10)
	b = append(b, []byte{0x2d}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtDateMedium_7b5970ebef47b6071b7a9bff570eba75 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Day() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2d}...)

	if t.Month() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Month()), 10)

	b = append(b, []byte{0x2d}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtDateLong_a234d460b585eebc392634bc08485ebd = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x2c, 0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtDateFull_bd1b45bc043b6b4e8c3b831b9263891b = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = append(b, ln.daysWide[t.Weekday()]...)
	b = append(b, []byte{0x2c, 0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x2c, 0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtTimeShort_6c9fb1bcda2b27013e9a8a47c7326805 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Hour() < 12 {
		b = append(b, ln.periodsAbbreviated[0]...)
	} else {
		b = append(b, ln.periodsAbbreviated[1]...)
	}

	b = append(b, []byte{0x20}...)

	h := t.Hour()

	if h > 12 {
		h -= 12
	}

	b = strconv.AppendInt(b, int64(h), 10)
	b = append(b, []byte{0x2e}...)

	if t.Minute() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Minute()), 10)

	return string(b)
}

var fnFmtTimeMedium_74593f8f5ae9c1a3e4637628d509c179 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Hour() < 12 {
		b = append(b, ln.periodsAbbreviated[0]...)
	} else {
		b = append(b, ln.periodsAbbreviated[1]...)
	}

	b = append(b, []byte{0x20}...)

	h := t.Hour()

	if h > 12 {
		h -= 12
	}

	b = strconv.AppendInt(b, int64(h), 10)
	b = append(b, []byte{0x2e}...)

	if t.Minute() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Minute()), 10)
	b = append(b, []byte{0x2e}...)

	if t.Second() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Second()), 10)

	return string(b)
}

var fnFmtTimeLong_b2fdf6411542ab907630622b3d42a6b0 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Hour() < 12 {
		b = append(b, ln.periodsAbbreviated[0]...)
	} else {
		b = append(b, ln.periodsAbbreviated[1]...)
	}

	b = append(b, []byte{0x20}...)

	h := t.Hour()

	if h > 12 {
		h -= 12
	}

	b = strconv.AppendInt(b, int64(h), 10)
	b = append(b, []byte{0x2e}...)

	if t.Minute() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Minute()), 10)
	b = append(b, []byte{0x2e}...)

	if t.Second() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Second()), 10)
	b = append(b, []byte{0x20}...)

	tz, _ := t.Zone()
	b = append(b, tz...)

	return string(b)
}

var fnFmtTimeFull_3ce7dc5b6b225559fd40d102900d6c81 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Hour() < 12 {
		b = append(b, ln.periodsAbbreviated[0]...)
	} else {
		b = append(b, ln.periodsAbbreviated[1]...)
	}

	b = append(b, []byte{0x20}...)

	h := t.Hour()

	if h > 12 {
		h -= 12
	}

	b = strconv.AppendInt(b, int64(h), 10)
	b = append(b, []byte{0x2e}...)

	if t.Minute() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Minute()), 10)
	b = append(b, []byte{0x2e}...)

	if t.Second() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Second()), 10)
	b = append(b, []byte{0x20}...)

	tz, _ := t.Zone()

	if btz, ok := ln.timezones[tz]; ok {
		b = append(b, btz...)
	} else {
		b = append(b, tz...)
	}

	return string(b)
}

var fnFmtCurrency_bf0b02b2ea7c6ce42329b55a6be0d7f3 = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 2
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				b = append(b, ln.group[0])
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {
		b = append(b, ln.minus[0])
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	b = append(b, ln.currencyPositiveSuffix...)

	b = append(b, symbol...)

	return string(b)
}

var fnFmtAccounting_97eb2dc886e17a0500b9446194e6f039 = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 2
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				b = append(b, ln.group[0])
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {
		b = append(b, ln.minus[0])
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	if num < 0 {
		b = append(b, ln.currencyNegativeSuffix...)
		b = append(b, symbol...)
	} else {

		b = append(b, ln.currencyPositiveSuffix...)
		b = append(b, symbol...)
	}

	return string(b)
}

var fnFmtDateFull_c568798c9683b61c27e1bae4ea10cb6b = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = append(b, ln.daysWide[t.Weekday()]...)
	b = append(b, []byte{0x2c, 0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnCardinalPluralRule_c037ba21b7495f414cf38823ca036d30 = func(ln *localen, num float64, v uint64) locales.PluralRule {
	n := math.Abs(num)
	i := int64(n)

	if i == 1 && v == 0 {
		return locales.PluralRuleOne
	}

	return locales.PluralRuleOther
}

var fnFmtCurrency_c43b1593289525b3b62af252d88e9f2d = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 4 + 1*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				b = append(b, ln.group[0])
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {
		b = append(b, ln.minus[0])
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	b = append(b, ln.currencyPositiveSuffix...)

	b = append(b, symbol...)

	return string(b)
}

var fnFmtAccounting_295d01ff3669c94717ee670511c0e25e = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 4 + 1*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				b = append(b, ln.group[0])
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {
		b = append(b, ln.minus[0])
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	if num < 0 {
		b = append(b, ln.currencyNegativeSuffix...)
		b = append(b, symbol...)
	} else {

		b = append(b, ln.currencyPositiveSuffix...)
		b = append(b, symbol...)
	}

	return string(b)
}

var fnFmtDateShort_f44877b6023a2d0fb0de41f9e2966ad0 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2f}...)
	b = strconv.AppendInt(b, int64(t.Month()), 10)
	b = append(b, []byte{0x2f}...)

	if t.Year() > 9 {
		b = append(b, strconv.Itoa(t.Year())[2:]...)
	} else {
		b = append(b, strconv.Itoa(t.Year())[1:]...)
	}

	return string(b)
}

var fnFmtDateLong_b496f47cbe02a0b60f833a85f2f19cbc = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x20, 0x64, 0x65}...)
	b = append(b, []byte{0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtDateFull_6f37ff0e733377c3c49c15d7ec4ea94b = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = append(b, ln.daysWide[t.Weekday()]...)
	b = append(b, []byte{0x2c, 0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x20, 0x64, 0x65}...)
	b = append(b, []byte{0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnOrdinalPluralRule_822e96e7fb113a3156c2e7c532855968 = func(ln *localen, num float64, v uint64) locales.PluralRule {
	n := math.Abs(num)
	i := int64(n)
	iMod10 := i % 10
	iMod100 := i % 100
	iMod1000 := i % 1000

	if (iMod10 == 1 || iMod10 == 2 || iMod10 == 5 || iMod10 == 7 || iMod10 == 8) || (iMod100 == 20 || iMod100 == 50 || iMod100 == 70 || iMod100 == 80) {
		return locales.PluralRuleOne
	} else if (iMod10 == 3 || iMod10 == 4) || (iMod1000 == 100 || iMod1000 == 200 || iMod1000 == 300 || iMod1000 == 400 || iMod1000 == 500 || iMod1000 == 600 || iMod1000 == 700 || iMod1000 == 800 || iMod1000 == 900) {
		return locales.PluralRuleFew
	} else if (i == 0) || (iMod10 == 6) || (iMod100 == 40 || iMod100 == 60 || iMod100 == 90) {
		return locales.PluralRuleMany
	}

	return locales.PluralRuleOther
}

var fnRangePluralRule_a46571fc772262a1fe652a3412eb1140 = func(ln *localen, num1 float64, v1 uint64, num2 float64, v2 uint64) locales.PluralRule {
	start := ln.CardinalPluralRule(num1, v1)
	end := ln.CardinalPluralRule(num2, v2)

	if start == locales.PluralRuleOne && end == locales.PluralRuleOther {
		return locales.PluralRuleOther
	} else if start == locales.PluralRuleOther && end == locales.PluralRuleOne {
		return locales.PluralRuleOne
	}

	return locales.PluralRuleOther
}

var fnFmtDateShort_c475a13000fd4072cf8feb7c7b40c476 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Day() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2e}...)

	if t.Month() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Month()), 10)

	b = append(b, []byte{0x2e}...)

	if t.Year() > 9 {
		b = append(b, strconv.Itoa(t.Year())[2:]...)
	} else {
		b = append(b, strconv.Itoa(t.Year())[1:]...)
	}

	return string(b)
}

var fnFmtDateFull_b94af095d9cfcd967654d0fbd68f2e98 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0x2c, 0x20}...)
	b = append(b, ln.daysWide[t.Weekday()]...)

	return string(b)
}

var fnFmtPercent_e53d7ec2cf4741b3601391772e4c83b0 = func(ln *localen, num float64, v uint64) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	l := len(s) + 3
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			continue
		}

		b = append(b, s[i])
	}

	if num < 0 {
		b = append(b, ln.minus[0])
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	b = append(b, ln.percentSuffix...)

	b = append(b, ln.percent...)

	return string(b)
}

var fnFmtCurrency_3398e8f49a5a712d32672f16a1ed2c57 = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 3 + 2*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				for j := len(ln.group) - 1; j >= 0; j-- {
					b = append(b, ln.group[j])
				}
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {
		b = append(b, ln.minus[0])
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	b = append(b, ln.currencyPositiveSuffix...)

	b = append(b, symbol...)

	return string(b)
}

var fnFmtAccounting_6dd988d8f1a3fac3718e543933915046 = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 3 + 2*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				for j := len(ln.group) - 1; j >= 0; j-- {
					b = append(b, ln.group[j])
				}
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {
		b = append(b, ln.minus[0])
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	if num < 0 {
		b = append(b, ln.currencyNegativeSuffix...)
		b = append(b, symbol...)
	} else {

		b = append(b, ln.currencyPositiveSuffix...)
		b = append(b, symbol...)
	}

	return string(b)
}

var fnCardinalPluralRule_aa3706fccbfeb0fac3cf81d326e3fe96 = func(ln *localen, num float64, v uint64) locales.PluralRule {
	n := math.Abs(num)
	nMod10 := math.Mod(n, 10)
	nMod100 := math.Mod(n, 100)

	if nMod10 == 1 && nMod100 != 11 {
		return locales.PluralRuleOne
	} else if nMod10 >= 2 && nMod10 <= 4 && (nMod100 < 12 || nMod100 > 14) {
		return locales.PluralRuleFew
	} else if (nMod10 == 0) || (nMod10 >= 5 && nMod10 <= 9) || (nMod100 >= 11 && nMod100 <= 14) {
		return locales.PluralRuleMany
	}

	return locales.PluralRuleOther
}

var fnOrdinalPluralRule_62ca292db3807cd1a19e61d6d993a0d9 = func(ln *localen, num float64, v uint64) locales.PluralRule {
	n := math.Abs(num)
	nMod10 := math.Mod(n, 10)
	nMod100 := math.Mod(n, 100)

	if (nMod10 == 2 || nMod10 == 3) && (nMod100 != 12 && nMod100 != 13) {
		return locales.PluralRuleFew
	}

	return locales.PluralRuleOther
}

var fnRangePluralRule_52e3998ab91a02eab3b89e4e5a856fb5 = func(ln *localen, num1 float64, v1 uint64, num2 float64, v2 uint64) locales.PluralRule {
	start := ln.CardinalPluralRule(num1, v1)
	end := ln.CardinalPluralRule(num2, v2)

	if start == locales.PluralRuleOne && end == locales.PluralRuleOne {
		return locales.PluralRuleOne
	} else if start == locales.PluralRuleOne && end == locales.PluralRuleFew {
		return locales.PluralRuleFew
	} else if start == locales.PluralRuleOne && end == locales.PluralRuleMany {
		return locales.PluralRuleMany
	} else if start == locales.PluralRuleOne && end == locales.PluralRuleOther {
		return locales.PluralRuleOther
	} else if start == locales.PluralRuleFew && end == locales.PluralRuleOne {
		return locales.PluralRuleOne
	} else if start == locales.PluralRuleFew && end == locales.PluralRuleFew {
		return locales.PluralRuleFew
	} else if start == locales.PluralRuleFew && end == locales.PluralRuleMany {
		return locales.PluralRuleMany
	} else if start == locales.PluralRuleFew && end == locales.PluralRuleOther {
		return locales.PluralRuleOther
	} else if start == locales.PluralRuleMany && end == locales.PluralRuleOne {
		return locales.PluralRuleOne
	} else if start == locales.PluralRuleMany && end == locales.PluralRuleFew {
		return locales.PluralRuleFew
	} else if start == locales.PluralRuleMany && end == locales.PluralRuleMany {
		return locales.PluralRuleMany
	} else if start == locales.PluralRuleMany && end == locales.PluralRuleOther {
		return locales.PluralRuleOther
	} else if start == locales.PluralRuleOther && end == locales.PluralRuleOne {
		return locales.PluralRuleOne
	} else if start == locales.PluralRuleOther && end == locales.PluralRuleFew {
		return locales.PluralRuleFew
	} else if start == locales.PluralRuleOther && end == locales.PluralRuleMany {
		return locales.PluralRuleMany
	}

	return locales.PluralRuleOther
}

var fnFmtPercent_fcc1fa1bb5725d058e89da9d97be1c70 = func(ln *localen, num float64, v uint64) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	l := len(s) + 5
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			continue
		}

		b = append(b, s[i])
	}

	if num < 0 {
		b = append(b, ln.minus[0])
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	b = append(b, ln.percentSuffix...)

	b = append(b, ln.percent...)

	return string(b)
}

var fnFmtCurrency_04d2836e8ee5922750958599d99ccc13 = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 4 + 2*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				for j := len(ln.group) - 1; j >= 0; j-- {
					b = append(b, ln.group[j])
				}
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {
		b = append(b, ln.minus[0])
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	b = append(b, ln.currencyPositiveSuffix...)

	b = append(b, symbol...)

	return string(b)
}

var fnFmtAccounting_a62648328d65f4275e2e521198233607 = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 4 + 2*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				for j := len(ln.group) - 1; j >= 0; j-- {
					b = append(b, ln.group[j])
				}
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {
		b = append(b, ln.minus[0])
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	if num < 0 {
		b = append(b, ln.currencyNegativeSuffix...)
		b = append(b, symbol...)
	} else {

		b = append(b, ln.currencyPositiveSuffix...)
		b = append(b, symbol...)
	}

	return string(b)
}

var fnFmtDateShort_cbdb981782261e5a8b8cc19702400c64 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2e}...)

	if t.Month() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Month()), 10)

	b = append(b, []byte{0x2e}...)

	if t.Year() > 9 {
		b = append(b, strconv.Itoa(t.Year())[2:]...)
	} else {
		b = append(b, strconv.Itoa(t.Year())[1:]...)
	}

	return string(b)
}

var fnFmtDateMedium_73098a578f62c763b1a46cfb742142e3 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2e}...)

	if t.Month() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Month()), 10)

	b = append(b, []byte{0x2e}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtDateLong_b673377c923e43f185728d5b63716bee = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0x20, 0xd0, 0xb3}...)
	b = append(b, []byte{0x2e}...)

	return string(b)
}

var fnFmtDateFull_3bb9a5fb6d982f44bb197fafb3f68087 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = append(b, ln.daysWide[t.Weekday()]...)
	b = append(b, []byte{0x2c, 0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0x20, 0xd0, 0xb3}...)
	b = append(b, []byte{0x2e}...)

	return string(b)
}

var fnFmtTimeFull_d302f6108a9d3f4bb461f3a5111143e5 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Hour() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Hour()), 10)
	b = append(b, ln.timeSeparator...)

	if t.Minute() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Minute()), 10)
	b = append(b, ln.timeSeparator...)

	if t.Second() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Second()), 10)
	b = append(b, []byte{0x2c, 0x20}...)

	tz, _ := t.Zone()

	if btz, ok := ln.timezones[tz]; ok {
		b = append(b, btz...)
	} else {
		b = append(b, tz...)
	}

	return string(b)
}

var fnFmtCurrency_12d8afad3eb872da9d80fb14637f7f61 = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 0
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				b = append(b, ln.group[0])
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	for j := len(symbol) - 1; j >= 0; j-- {
		b = append(b, symbol[j])
	}

	if num < 0 {
		b = append(b, ln.minus[0])
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	return string(b)
}

var fnFmtAccounting_60b3ba42c7301cf18f0e7795b3eeaa75 = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 2
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				b = append(b, ln.group[0])
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {

		for j := len(symbol) - 1; j >= 0; j-- {
			b = append(b, symbol[j])
		}

		b = append(b, ln.currencyNegativePrefix[0])

	} else {
		for j := len(symbol) - 1; j >= 0; j-- {
			b = append(b, symbol[j])
		}
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	if num < 0 {
		b = append(b, ln.currencyNegativeSuffix...)
	}

	return string(b)
}

var fnFmtCurrency_022949044632e54ed5ae02ba82626546 = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 0
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				b = append(b, ln.group[0])
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {
		b = append(b, ln.minus[0])
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	b = append(b, symbol...)

	return string(b)
}

var fnFmtAccounting_b4b66bcaf750a9b7b42ab51bff8c0e19 = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 0
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				b = append(b, ln.group[0])
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {
		b = append(b, ln.minus[0])
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	if num < 0 {
		b = append(b, symbol...)
	} else {
		b = append(b, symbol...)
	}

	return string(b)
}

var fnFmtCurrency_88fd8698aec1fdcde88908d426b01f78 = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 4

	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			continue
		}

		b = append(b, s[i])
	}

	if num < 0 {
		b = append(b, ln.minus[0])
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	b = append(b, ln.currencyPositiveSuffix...)

	b = append(b, symbol...)

	return string(b)
}

var fnFmtAccounting_895833c14256127b155b25fc552f5180 = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 6

	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			continue
		}

		b = append(b, s[i])
	}

	if num < 0 {
		b = append(b, ln.currencyNegativePrefix[0])
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	if num < 0 {
		b = append(b, ln.currencyNegativeSuffix...)
		b = append(b, symbol...)
	} else {

		b = append(b, ln.currencyPositiveSuffix...)
		b = append(b, symbol...)
	}

	return string(b)
}

var fnFmtDateShort_724096485badda99a595db97f2fdcc96 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2e}...)

	if t.Month() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Month()), 10)

	b = append(b, []byte{0x2e}...)

	if t.Year() > 9 {
		b = append(b, strconv.Itoa(t.Year())[2:]...)
	} else {
		b = append(b, strconv.Itoa(t.Year())[1:]...)
	}

	b = append(b, []byte{0x20, 0xd0, 0xb3}...)
	b = append(b, []byte{0x2e}...)

	return string(b)
}

var fnFmtDateMedium_387f50f821f8034478c23ca141a1b991 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2e}...)

	if t.Month() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Month()), 10)

	b = append(b, []byte{0x2e}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0x20, 0xd0, 0xb3}...)
	b = append(b, []byte{0x2e}...)

	return string(b)
}

var fnCardinalPluralRule_18b4522c3f6126d1e01414d5e423288b = func(ln *localen, num float64, v uint64) locales.PluralRule {
	return locales.PluralRuleOther
}

var fnFmtCurrency_ac4758b65e3186b6295da12d015494cf = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 2 + 1*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	inSecondary := false
	groupThreshold := 3

	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == groupThreshold {
				b = append(b, ln.group[0])
				count = 1

				if !inSecondary {
					inSecondary = true
					groupThreshold = 2
				}
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {
		b = append(b, ln.minus[0])
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	b = append(b, symbol...)

	return string(b)
}

var fnFmtAccounting_1df869b66b1bebb824de5401f039b55a = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 2 + 1*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	inSecondary := false
	groupThreshold := 3

	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == groupThreshold {
				b = append(b, ln.group[0])
				count = 1

				if !inSecondary {
					inSecondary = true
					groupThreshold = 2
				}
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {
		b = append(b, ln.minus[0])
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	if num < 0 {
		b = append(b, symbol...)
	} else {
		b = append(b, symbol...)
	}

	return string(b)
}

var fnFmtNumber_74395470c4c29cb378d864498139a946 = func(ln *localen, num float64, v uint64) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	l := len(s) + 1 + 1*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				b = append(b, ln.group[0])
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {
		b = append(b, ln.minus[0])
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	return string(b)
}

var fnFmtCurrency_53723702774dedd2122c38a68dcef3da = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 3 + 1*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				b = append(b, ln.group[0])
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	for j := len(symbol) - 1; j >= 0; j-- {
		b = append(b, symbol[j])
	}

	for j := len(ln.currencyPositivePrefix) - 1; j >= 0; j-- {
		b = append(b, ln.currencyPositivePrefix[j])
	}

	if num < 0 {
		b = append(b, ln.minus[0])
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	return string(b)
}

var fnFmtAccounting_44f743dae0936af6184f1cad1624e543 = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 3 + 1*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				b = append(b, ln.group[0])
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {

		for j := len(symbol) - 1; j >= 0; j-- {
			b = append(b, symbol[j])
		}

		for j := len(ln.currencyNegativePrefix) - 1; j >= 0; j-- {
			b = append(b, ln.currencyNegativePrefix[j])
		}

		b = append(b, ln.minus[0])

	} else {

		for j := len(symbol) - 1; j >= 0; j-- {
			b = append(b, symbol[j])
		}

		for j := len(ln.currencyPositivePrefix) - 1; j >= 0; j-- {
			b = append(b, ln.currencyPositivePrefix[j])
		}

	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	return string(b)
}

var fnFmtDateMedium_6eb6d3d989d88a86345ec9bd5152286a = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0x20, 0xe0, 0xbd, 0xa3, 0xe0, 0xbd, 0xbc, 0xe0, 0xbd, 0xa0, 0xe0, 0xbd, 0xb2, 0xe0, 0xbc, 0x8b}...)
	b = append(b, ln.monthsAbbreviated[t.Month()]...)
	b = append(b, []byte{0xe0, 0xbd, 0x9a, 0xe0, 0xbd, 0xba, 0xe0, 0xbd, 0xa6, 0xe0, 0xbc, 0x8b}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)

	return string(b)
}

var fnFmtDateLong_7a6cbc22eb124572fde0cc182fbd1d3d = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = append(b, []byte{0xe0, 0xbd, 0xa6, 0xe0, 0xbe, 0xa4, 0xe0, 0xbe, 0xb1, 0xe0, 0xbd, 0xb2, 0xe0, 0xbc, 0x8b, 0xe0, 0xbd, 0xa3, 0xe0, 0xbd, 0xbc, 0xe0, 0xbc, 0x8b}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0xe0, 0xbd, 0xa0, 0xe0, 0xbd, 0xb2, 0xe0, 0xbc, 0x8b, 0xe0, 0xbd, 0x9a, 0xe0, 0xbd, 0xba, 0xe0, 0xbd, 0xa6, 0xe0, 0xbc, 0x8b}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)

	return string(b)
}

var fnFmtDateFull_753ec22cf63aa959d868252cf9690e9d = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0xe0, 0xbd, 0xa0, 0xe0, 0xbd, 0xb2, 0xe0, 0xbc, 0x8b, 0xe0, 0xbd, 0x9a, 0xe0, 0xbd, 0xba, 0xe0, 0xbd, 0xa6, 0xe0, 0xbc, 0x8b}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2c, 0x20}...)
	b = append(b, ln.daysWide[t.Weekday()]...)

	return string(b)
}

var fnCardinalPluralRule_3fb30797479a030a43141dadf528c83c = func(ln *localen, num float64, v uint64) locales.PluralRule {
	n := math.Abs(num)
	nMod100 := math.Mod(n, 100)
	nMod1000000 := math.Mod(n, 1000000)
	nMod10 := math.Mod(n, 10)

	if nMod10 == 1 && (nMod100 != 11 && nMod100 != 71 && nMod100 != 91) {
		return locales.PluralRuleOne
	} else if nMod10 == 2 && (nMod100 != 12 && nMod100 != 72 && nMod100 != 92) {
		return locales.PluralRuleTwo
	} else if nMod10 >= 3 && nMod10 <= 4 && (nMod10 == 9) && (nMod100 < 10 || nMod100 > 19) || (nMod100 < 70 || nMod100 > 79) || (nMod100 < 90 || nMod100 > 99) {
		return locales.PluralRuleFew
	} else if n != 0 && nMod1000000 == 0 {
		return locales.PluralRuleMany
	}

	return locales.PluralRuleOther
}

var fnMonthsAbbreviated_fe5c5e0e26e170f84f3661fae0335729 = func(ln *localen) []string {
	return nil
}

var fnFmtDateShort_1cd909a8714b4f1989f9f3479488b0ad = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Month()), 10)
	b = append(b, []byte{0x2f}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2f}...)

	if t.Year() > 9 {
		b = append(b, strconv.Itoa(t.Year())[2:]...)
	} else {
		b = append(b, strconv.Itoa(t.Year())[1:]...)
	}

	return string(b)
}

var fnFmtDateMedium_41fae806abc2b79c1a1d2ac50b3fd4dc = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = append(b, ln.monthsAbbreviated[t.Month()]...)
	b = append(b, []byte{0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2c, 0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtDateLong_ea5b1048b05196ddfdf5985a09a1d219 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2c, 0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtDateFull_5b5e153ac164177593d63740c82296b3 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = append(b, ln.daysWide[t.Weekday()]...)
	b = append(b, []byte{0x2c, 0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2c, 0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnCardinalPluralRule_d76954adbbec5c02f9aae79b8f9d4067 = func(ln *localen, num float64, v uint64) locales.PluralRule {
	n := math.Abs(num)
	i := int64(n)
	f := locales.F(n, v)
	iMod10 := i % 10
	iMod100 := i % 100
	fMod10 := f % 10
	fMod100 := f % 100

	if (v == 0 && iMod10 == 1 && iMod100 != 11) || (fMod10 == 1 && fMod100 != 11) {
		return locales.PluralRuleOne
	} else if (v == 0 && iMod10 >= 2 && iMod10 <= 4 && (iMod100 < 12 || iMod100 > 14)) || (fMod10 >= 2 && fMod10 <= 4 && (fMod100 < 12 || fMod100 > 14)) {
		return locales.PluralRuleFew
	}

	return locales.PluralRuleOther
}

var fnRangePluralRule_b9d3512264e082d2fa10f438237ce3cc = func(ln *localen, num1 float64, v1 uint64, num2 float64, v2 uint64) locales.PluralRule {
	start := ln.CardinalPluralRule(num1, v1)
	end := ln.CardinalPluralRule(num2, v2)

	if start == locales.PluralRuleOne && end == locales.PluralRuleOne {
		return locales.PluralRuleOne
	} else if start == locales.PluralRuleOne && end == locales.PluralRuleFew {
		return locales.PluralRuleFew
	} else if start == locales.PluralRuleOne && end == locales.PluralRuleOther {
		return locales.PluralRuleOther
	} else if start == locales.PluralRuleFew && end == locales.PluralRuleOne {
		return locales.PluralRuleOne
	} else if start == locales.PluralRuleFew && end == locales.PluralRuleFew {
		return locales.PluralRuleFew
	} else if start == locales.PluralRuleFew && end == locales.PluralRuleOther {
		return locales.PluralRuleOther
	} else if start == locales.PluralRuleOther && end == locales.PluralRuleOne {
		return locales.PluralRuleOne
	} else if start == locales.PluralRuleOther && end == locales.PluralRuleFew {
		return locales.PluralRuleFew
	}

	return locales.PluralRuleOther
}

var fnFmtDateShort_aa123c99f95c3c4073e2b02fd117f0c8 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2e, 0x20}...)
	b = strconv.AppendInt(b, int64(t.Month()), 10)
	b = append(b, []byte{0x2e, 0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0x2e}...)

	return string(b)
}

var fnFmtDateMedium_a05abc83947bad9ca5156c8f2aa83cdc = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2e, 0x20}...)
	b = append(b, ln.monthsAbbreviated[t.Month()]...)
	b = append(b, []byte{0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0x2e}...)

	return string(b)
}

var fnFmtDateLong_65f6b60e7b56b6fcb221b95f5d7324ae = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2e, 0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0x2e}...)

	return string(b)
}

var fnFmtDateFull_5aef9dacdb26bf87063b666a034b424e = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = append(b, ln.daysWide[t.Weekday()]...)
	b = append(b, []byte{0x2c, 0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2e, 0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0x2e}...)

	return string(b)
}

var fnCardinalPluralRule_7b6df98bb7a40cd3e9c67c7c7f464286 = func(ln *localen, num float64, v uint64) locales.PluralRule {
	n := math.Abs(num)
	i := int64(n)
	f := locales.F(n, v)
	iMod100 := i % 100
	iMod10 := i % 10
	fMod10 := f % 10
	fMod100 := f % 100

	if (v == 0 && iMod10 == 1 && iMod100 != 11) || (fMod10 == 1 && fMod100 != 11) {
		return locales.PluralRuleOne
	} else if (v == 0 && iMod10 >= 2 && iMod10 <= 4 && (iMod100 < 12 || iMod100 > 14)) || (fMod10 >= 2 && fMod10 <= 4 && (fMod100 < 12 || fMod100 > 14)) {
		return locales.PluralRuleFew
	}

	return locales.PluralRuleOther
}

var fnFmtDateShort_93d8b8c715a1811ebc94777fc3aa4672 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2e}...)
	b = strconv.AppendInt(b, int64(t.Month()), 10)
	b = append(b, []byte{0x2e}...)

	if t.Year() > 9 {
		b = append(b, strconv.Itoa(t.Year())[2:]...)
	} else {
		b = append(b, strconv.Itoa(t.Year())[1:]...)
	}

	b = append(b, []byte{0x2e}...)

	return string(b)
}

var fnFmtDateMedium_61defeac982d2749785dbfe5e166419f = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Day() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2e}...)

	if t.Month() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Month()), 10)

	b = append(b, []byte{0x2e}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0x2e}...)

	return string(b)
}

var fnFmtDateLong_d042ff2f76eb964a2a614f1d2926f4a7 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Day() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2e, 0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0x2e}...)

	return string(b)
}

var fnFmtDateFull_94801bd77ea8c5746f4486dd265a9d5e = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = append(b, ln.daysWide[t.Weekday()]...)
	b = append(b, []byte{0x2c, 0x20}...)

	if t.Day() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2e, 0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0x2e}...)

	return string(b)
}

var fnCardinalPluralRule_2fd16cba9f129ab3317e08638d736342 = func(ln *localen, num float64, v uint64) locales.PluralRule {
	n := math.Abs(num)
	i := int64(n)
	f := locales.F(n, v)
	iMod100 := i % 100
	iMod10 := i % 10
	fMod100 := f % 100
	fMod10 := f % 10

	if (v == 0 && iMod10 == 1 && iMod100 != 11) || (fMod10 == 1 && fMod100 != 11) {
		return locales.PluralRuleOne
	} else if (v == 0 && iMod10 >= 2 && iMod10 <= 4 && (iMod100 < 12 || iMod100 > 14)) || (fMod10 >= 2 && fMod10 <= 4 && (fMod100 < 12 || fMod100 > 14)) {
		return locales.PluralRuleFew
	}

	return locales.PluralRuleOther
}

var fnOrdinalPluralRule_535d124951e9b710ee661bfe8ca4c345 = func(ln *localen, num float64, v uint64) locales.PluralRule {
	n := math.Abs(num)

	if n == 1 || n == 3 {
		return locales.PluralRuleOne
	} else if n == 2 {
		return locales.PluralRuleTwo
	} else if n == 4 {
		return locales.PluralRuleFew
	}

	return locales.PluralRuleOther
}

var fnFmtAccounting_64449162f5ca02bf56f475bc8fb0f4a7 = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 6 + 1*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				b = append(b, ln.group[0])
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {
		b = append(b, ln.currencyNegativePrefix[0])
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	if num < 0 {
		b = append(b, ln.currencyNegativeSuffix...)
		b = append(b, symbol...)
	} else {

		b = append(b, ln.currencyPositiveSuffix...)
		b = append(b, symbol...)
	}

	return string(b)
}

var fnFmtNumber_81c5002a93b06b7f91045a20d95f77c9 = func(ln *localen, num float64, v uint64) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	l := len(s) + 1
	count := 0
	inWhole := v == 0
	inSecondary := false
	groupThreshold := 3

	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == groupThreshold {
				b = append(b, ln.group[0])
				count = 1

				if !inSecondary {
					inSecondary = true
					groupThreshold = 2
				}
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {
		b = append(b, ln.minus[0])
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	return string(b)
}

var fnFmtPercent_52501d1a8eef906b405639f3c42aa47d = func(ln *localen, num float64, v uint64) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	l := len(s) + 2
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			continue
		}

		b = append(b, s[i])
	}

	if num < 0 {
		b = append(b, ln.minus[0])
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	b = append(b, ln.percent...)

	return string(b)
}

var fnFmtCurrency_4d9675c6ee668a70f27c2127d8acae4e = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 1
	count := 0
	inWhole := v == 0
	inSecondary := false
	groupThreshold := 3

	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == groupThreshold {
				b = append(b, ln.group[0])
				count = 1

				if !inSecondary {
					inSecondary = true
					groupThreshold = 2
				}
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {
		b = append(b, ln.minus[0])
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	b = append(b, symbol...)

	return string(b)
}

var fnFmtAccounting_b870df2d704ca52917b45adf78d139de = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 1
	count := 0
	inWhole := v == 0
	inSecondary := false
	groupThreshold := 3

	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == groupThreshold {
				b = append(b, ln.group[0])
				count = 1

				if !inSecondary {
					inSecondary = true
					groupThreshold = 2
				}
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {
		b = append(b, ln.minus[0])
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	if num < 0 {
		b = append(b, symbol...)
	} else {
		b = append(b, symbol...)
	}

	return string(b)
}

var fnFmtDateShort_09f1761f0b60aead9f5012476a47c814 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	return string(b)
}

var fnFmtDateMedium_9f7a8e1d4465e6a8ede358df4b71943e = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	return string(b)
}

var fnFmtDateLong_bfdb64849bf0a513d30bbef60108376d = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	return string(b)
}

var fnFmtDateFull_89e5603fd6c03ae17109c6eb729a3e18 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	return string(b)
}

var fnFmtTimeShort_47b79a38ecd6bac156085539ad031c2d = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	return string(b)
}

var fnFmtTimeMedium_8ab08b2a5e55b0d5b394d3d185e15d98 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	return string(b)
}

var fnFmtTimeLong_1a9373b60bc45e855b1c9aec2182a594 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	return string(b)
}

var fnFmtTimeFull_956780e9690f19a57988254ac2a6eb35 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	return string(b)
}

var fnCardinalPluralRule_c1a7400a6209ae7e8eb28592c58f6657 = func(ln *localen, num float64, v uint64) locales.PluralRule {
	n := math.Abs(num)
	i := int64(n)
	f := locales.F(n, v)
	iMod10 := i % 10
	fMod10 := f % 10

	if (v == 0 && (i == 1 || i == 2 || i == 3)) || (v == 0 && (iMod10 != 4 && iMod10 != 6 && iMod10 != 9)) || (v != 0 && (fMod10 != 4 && fMod10 != 6 && fMod10 != 9)) {
		return locales.PluralRuleOne
	}

	return locales.PluralRuleOther
}

var fnFmtAccounting_3d79231c973b635e0adc0ac3279907d3 = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 0
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				b = append(b, ln.group[0])
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {

		for j := len(symbol) - 1; j >= 0; j-- {
			b = append(b, symbol[j])
		}

		b = append(b, ln.minus[0])

	} else {
		for j := len(symbol) - 1; j >= 0; j-- {
			b = append(b, symbol[j])
		}
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	return string(b)
}

var fnFmtNumber_96d7d1823041a48b887e3e929259dbdf = func(ln *localen, num float64, v uint64) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	l := len(s) + 6 + 2*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			for j := len(ln.decimal) - 1; j >= 0; j-- {
				b = append(b, ln.decimal[j])
			}
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				for j := len(ln.group) - 1; j >= 0; j-- {
					b = append(b, ln.group[j])
				}
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {
		for j := len(ln.minus) - 1; j >= 0; j-- {
			b = append(b, ln.minus[j])
		}
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	return string(b)
}

var fnFmtPercent_f5e1c0d5e27b0e309f9e016c63b96767 = func(ln *localen, num float64, v uint64) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	l := len(s) + 10
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			for j := len(ln.decimal) - 1; j >= 0; j-- {
				b = append(b, ln.decimal[j])
			}
			continue
		}

		b = append(b, s[i])
	}

	if num < 0 {
		for j := len(ln.minus) - 1; j >= 0; j-- {
			b = append(b, ln.minus[j])
		}
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	b = append(b, ln.percentSuffix...)

	b = append(b, ln.percent...)

	return string(b)
}

var fnFmtCurrency_d61f2036c9f7cc7a15c2d51b90ffbef9 = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 8 + 2*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			for j := len(ln.decimal) - 1; j >= 0; j-- {
				b = append(b, ln.decimal[j])
			}
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				for j := len(ln.group) - 1; j >= 0; j-- {
					b = append(b, ln.group[j])
				}
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {
		for j := len(ln.minus) - 1; j >= 0; j-- {
			b = append(b, ln.minus[j])
		}
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	b = append(b, ln.currencyPositiveSuffix...)

	b = append(b, symbol...)

	return string(b)
}

var fnFmtAccounting_f7223149b88d711e36c711437b51fa28 = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 8 + 2*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			for j := len(ln.decimal) - 1; j >= 0; j-- {
				b = append(b, ln.decimal[j])
			}
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				for j := len(ln.group) - 1; j >= 0; j-- {
					b = append(b, ln.group[j])
				}
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {
		for j := len(ln.minus) - 1; j >= 0; j-- {
			b = append(b, ln.minus[j])
		}
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	if num < 0 {
		b = append(b, ln.currencyNegativeSuffix...)
		b = append(b, symbol...)
	} else {

		b = append(b, ln.currencyPositiveSuffix...)
		b = append(b, symbol...)
	}

	return string(b)
}

var fnFmtDateLong_335b03b04c77445aeb9ba732c8cd38ef = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0xdb, 0x8c, 0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0xdb, 0x8c, 0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnCardinalPluralRule_935abbc817a75b933eeb5ecc41e85d90 = func(ln *localen, num float64, v uint64) locales.PluralRule {
	n := math.Abs(num)
	i := int64(n)

	if i == 1 && v == 0 {
		return locales.PluralRuleOne
	} else if i >= 2 && i <= 4 && v == 0 {
		return locales.PluralRuleFew
	} else if v != 0 {
		return locales.PluralRuleMany
	}

	return locales.PluralRuleOther
}

var fnRangePluralRule_00245e8cddd4df2ec4e382e386a724dd = func(ln *localen, num1 float64, v1 uint64, num2 float64, v2 uint64) locales.PluralRule {
	start := ln.CardinalPluralRule(num1, v1)
	end := ln.CardinalPluralRule(num2, v2)

	if start == locales.PluralRuleOne && end == locales.PluralRuleFew {
		return locales.PluralRuleFew
	} else if start == locales.PluralRuleOne && end == locales.PluralRuleMany {
		return locales.PluralRuleMany
	} else if start == locales.PluralRuleOne && end == locales.PluralRuleOther {
		return locales.PluralRuleOther
	} else if start == locales.PluralRuleFew && end == locales.PluralRuleFew {
		return locales.PluralRuleFew
	} else if start == locales.PluralRuleFew && end == locales.PluralRuleMany {
		return locales.PluralRuleMany
	} else if start == locales.PluralRuleFew && end == locales.PluralRuleOther {
		return locales.PluralRuleOther
	} else if start == locales.PluralRuleMany && end == locales.PluralRuleOne {
		return locales.PluralRuleOne
	} else if start == locales.PluralRuleMany && end == locales.PluralRuleFew {
		return locales.PluralRuleFew
	} else if start == locales.PluralRuleMany && end == locales.PluralRuleMany {
		return locales.PluralRuleMany
	} else if start == locales.PluralRuleMany && end == locales.PluralRuleOther {
		return locales.PluralRuleOther
	} else if start == locales.PluralRuleOther && end == locales.PluralRuleOne {
		return locales.PluralRuleOne
	} else if start == locales.PluralRuleOther && end == locales.PluralRuleFew {
		return locales.PluralRuleFew
	} else if start == locales.PluralRuleOther && end == locales.PluralRuleMany {
		return locales.PluralRuleMany
	}

	return locales.PluralRuleOther
}

var fnFmtDateMedium_15dd2e1fe33af45e98be7d9f9b1b6b93 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2e, 0x20}...)
	b = strconv.AppendInt(b, int64(t.Month()), 10)
	b = append(b, []byte{0x2e, 0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtDateLong_6ddead36eb66c5c353fc1725254f1035 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2e, 0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtDateFull_23f49589a10a043b9966b4062e75298c = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = append(b, ln.daysWide[t.Weekday()]...)
	b = append(b, []byte{0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2e, 0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtDateShort_cc33621dc8ea4b3f7e42320aa653cbdf = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0x2e}...)

	if t.Month() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Month()), 10)

	b = append(b, []byte{0x2e}...)

	if t.Day() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Day()), 10)

	return string(b)
}

var fnFmtDateFull_7d9a7daab943102fabd3a368958b52aa = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = append(b, ln.daysWide[t.Weekday()]...)
	b = append(b, []byte{0x2c, 0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x20, 0xd0, 0xbb}...)
	b = append(b, []byte{0x2e, 0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0x2e}...)

	return string(b)
}

var fnCardinalPluralRule_6ce82b971f5322e99200abf4c11a0dbe = func(ln *localen, num float64, v uint64) locales.PluralRule {
	n := math.Abs(num)

	if n == 0 {
		return locales.PluralRuleZero
	} else if n == 1 {
		return locales.PluralRuleOne
	} else if n == 2 {
		return locales.PluralRuleTwo
	} else if n == 3 {
		return locales.PluralRuleFew
	} else if n == 6 {
		return locales.PluralRuleMany
	}

	return locales.PluralRuleOther
}

var fnOrdinalPluralRule_01e534b5c587a0b20e565363a8f2673c = func(ln *localen, num float64, v uint64) locales.PluralRule {
	n := math.Abs(num)

	if n == 0 || n == 7 || n == 8 || n == 9 {
		return locales.PluralRuleZero
	} else if n == 1 {
		return locales.PluralRuleOne
	} else if n == 2 {
		return locales.PluralRuleTwo
	} else if n == 3 || n == 4 {
		return locales.PluralRuleFew
	} else if n == 5 || n == 6 {
		return locales.PluralRuleMany
	}

	return locales.PluralRuleOther
}

var fnRangePluralRule_36aaa84f53bfb88e0054a81c3abba2a4 = func(ln *localen, num1 float64, v1 uint64, num2 float64, v2 uint64) locales.PluralRule {
	start := ln.CardinalPluralRule(num1, v1)
	end := ln.CardinalPluralRule(num2, v2)

	if start == locales.PluralRuleZero && end == locales.PluralRuleOne {
		return locales.PluralRuleOne
	} else if start == locales.PluralRuleZero && end == locales.PluralRuleTwo {
		return locales.PluralRuleTwo
	} else if start == locales.PluralRuleZero && end == locales.PluralRuleFew {
		return locales.PluralRuleFew
	} else if start == locales.PluralRuleZero && end == locales.PluralRuleMany {
		return locales.PluralRuleMany
	} else if start == locales.PluralRuleZero && end == locales.PluralRuleOther {
		return locales.PluralRuleOther
	} else if start == locales.PluralRuleOne && end == locales.PluralRuleTwo {
		return locales.PluralRuleTwo
	} else if start == locales.PluralRuleOne && end == locales.PluralRuleFew {
		return locales.PluralRuleFew
	} else if start == locales.PluralRuleOne && end == locales.PluralRuleMany {
		return locales.PluralRuleMany
	} else if start == locales.PluralRuleOne && end == locales.PluralRuleOther {
		return locales.PluralRuleOther
	} else if start == locales.PluralRuleTwo && end == locales.PluralRuleFew {
		return locales.PluralRuleFew
	} else if start == locales.PluralRuleTwo && end == locales.PluralRuleMany {
		return locales.PluralRuleMany
	} else if start == locales.PluralRuleTwo && end == locales.PluralRuleOther {
		return locales.PluralRuleOther
	} else if start == locales.PluralRuleFew && end == locales.PluralRuleMany {
		return locales.PluralRuleMany
	} else if start == locales.PluralRuleFew && end == locales.PluralRuleOther {
		return locales.PluralRuleOther
	} else if start == locales.PluralRuleMany && end == locales.PluralRuleOther {
		return locales.PluralRuleOther
	} else if start == locales.PluralRuleOther && end == locales.PluralRuleOne {
		return locales.PluralRuleOne
	} else if start == locales.PluralRuleOther && end == locales.PluralRuleTwo {
		return locales.PluralRuleTwo
	} else if start == locales.PluralRuleOther && end == locales.PluralRuleFew {
		return locales.PluralRuleFew
	} else if start == locales.PluralRuleOther && end == locales.PluralRuleMany {
		return locales.PluralRuleMany
	}

	return locales.PluralRuleOther
}

var fnFmtDateShort_ebdf8e52512129a89eac95e40839ea8d = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Day() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2f}...)

	if t.Month() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Month()), 10)

	b = append(b, []byte{0x2f}...)

	if t.Year() > 9 {
		b = append(b, strconv.Itoa(t.Year())[2:]...)
	} else {
		b = append(b, strconv.Itoa(t.Year())[1:]...)
	}

	return string(b)
}

var fnCardinalPluralRule_79907f4d6e752731d2282b8c488dfb0e = func(ln *localen, num float64, v uint64) locales.PluralRule {
	n := math.Abs(num)
	i := int64(n)
	t := locales.T(n, v)

	if (n == 1) || (t != 0 && (i == 0 || i == 1)) {
		return locales.PluralRuleOne
	}

	return locales.PluralRuleOther
}

var fnRangePluralRule_6ac6faa53655f798bb439bf2ef50aa19 = func(ln *localen, num1 float64, v1 uint64, num2 float64, v2 uint64) locales.PluralRule {
	start := ln.CardinalPluralRule(num1, v1)
	end := ln.CardinalPluralRule(num2, v2)

	if start == locales.PluralRuleOne && end == locales.PluralRuleOne {
		return locales.PluralRuleOne
	} else if start == locales.PluralRuleOne && end == locales.PluralRuleOther {
		return locales.PluralRuleOther
	} else if start == locales.PluralRuleOther && end == locales.PluralRuleOne {
		return locales.PluralRuleOne
	}

	return locales.PluralRuleOther
}

var fnFmtDateShort_b5a69de69141b720b05f1dca7542e7e5 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Day() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2e}...)

	if t.Month() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Month()), 10)

	b = append(b, []byte{0x2e}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtDateMedium_55a922eee312039812d989655f290012 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2e, 0x20}...)
	b = append(b, ln.monthsAbbreviated[t.Month()]...)
	b = append(b, []byte{0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtDateFull_8ce43d140d292ed841f0f368561bdb8e = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = append(b, ln.daysWide[t.Weekday()]...)
	b = append(b, []byte{0x20, 0x64, 0x65, 0x6e}...)
	b = append(b, []byte{0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2e, 0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtTimeShort_f122edf9136fadb0288a3d0e77450a50 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Hour() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Hour()), 10)
	b = append(b, []byte{0x2e}...)

	if t.Minute() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Minute()), 10)

	return string(b)
}

var fnFmtTimeMedium_c9ed57159952e0c7f4ac96091e48d9ad = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Hour() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Hour()), 10)
	b = append(b, []byte{0x2e}...)

	if t.Minute() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Minute()), 10)
	b = append(b, []byte{0x2e}...)

	if t.Second() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Second()), 10)

	return string(b)
}

var fnFmtTimeLong_25847504d894858ff8768557462c84d0 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Hour() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Hour()), 10)
	b = append(b, []byte{0x2e}...)

	if t.Minute() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Minute()), 10)
	b = append(b, []byte{0x2e}...)

	if t.Second() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Second()), 10)
	b = append(b, []byte{0x20}...)

	tz, _ := t.Zone()
	b = append(b, tz...)

	return string(b)
}

var fnFmtTimeFull_391789992db94778b51fb64c1b45a71a = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Hour() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Hour()), 10)
	b = append(b, []byte{0x2e}...)

	if t.Minute() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Minute()), 10)
	b = append(b, []byte{0x2e}...)

	if t.Second() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Second()), 10)
	b = append(b, []byte{0x20}...)

	tz, _ := t.Zone()

	if btz, ok := ln.timezones[tz]; ok {
		b = append(b, btz...)
	} else {
		b = append(b, tz...)
	}

	return string(b)
}

var fnFmtDateMedium_13bf223568676db2ecc2cdf26633b243 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Day() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2e}...)

	if t.Month() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Month()), 10)

	b = append(b, []byte{0x2e}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtDateFull_7f49a254f89defd9dde5b1348abc8f6a = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = append(b, ln.daysWide[t.Weekday()]...)
	b = append(b, []byte{0x2c, 0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2e, 0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtCurrency_7b65395a77761388c242d97c0d4bfe5b = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 4 + 2*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				for j := len(ln.group) - 1; j >= 0; j-- {
					b = append(b, ln.group[j])
				}
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	for j := len(symbol) - 1; j >= 0; j-- {
		b = append(b, symbol[j])
	}

	for j := len(ln.currencyPositivePrefix) - 1; j >= 0; j-- {
		b = append(b, ln.currencyPositivePrefix[j])
	}

	if num < 0 {
		b = append(b, ln.minus[0])
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	return string(b)
}

var fnFmtAccounting_204cc4159c06830dc072d7ffc4471b59 = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 4 + 2*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				for j := len(ln.group) - 1; j >= 0; j-- {
					b = append(b, ln.group[j])
				}
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {

		for j := len(symbol) - 1; j >= 0; j-- {
			b = append(b, symbol[j])
		}

		for j := len(ln.currencyNegativePrefix) - 1; j >= 0; j-- {
			b = append(b, ln.currencyNegativePrefix[j])
		}

		b = append(b, ln.minus[0])

	} else {

		for j := len(symbol) - 1; j >= 0; j-- {
			b = append(b, symbol[j])
		}

		for j := len(ln.currencyPositivePrefix) - 1; j >= 0; j-- {
			b = append(b, ln.currencyPositivePrefix[j])
		}

	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	return string(b)
}

var fnFmtNumber_86454cdda5e540e71bc886ed08f9c66b = func(ln *localen, num float64, v uint64) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	l := len(s) + 2 + 3*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				for j := len(ln.group) - 1; j >= 0; j-- {
					b = append(b, ln.group[j])
				}
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {
		b = append(b, ln.minus[0])
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	return string(b)
}

var fnFmtCurrency_4924273cdfaa6d993990fdf2a2bad453 = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 4 + 3*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				for j := len(ln.group) - 1; j >= 0; j-- {
					b = append(b, ln.group[j])
				}
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	for j := len(symbol) - 1; j >= 0; j-- {
		b = append(b, symbol[j])
	}

	for j := len(ln.currencyPositivePrefix) - 1; j >= 0; j-- {
		b = append(b, ln.currencyPositivePrefix[j])
	}

	if num < 0 {
		b = append(b, ln.minus[0])
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	return string(b)
}

var fnFmtAccounting_a6430b96a17c400006d20ebabdf05e4c = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 4 + 3*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				for j := len(ln.group) - 1; j >= 0; j-- {
					b = append(b, ln.group[j])
				}
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {

		for j := len(symbol) - 1; j >= 0; j-- {
			b = append(b, symbol[j])
		}

		for j := len(ln.currencyNegativePrefix) - 1; j >= 0; j-- {
			b = append(b, ln.currencyNegativePrefix[j])
		}

		b = append(b, ln.minus[0])

	} else {

		for j := len(symbol) - 1; j >= 0; j-- {
			b = append(b, symbol[j])
		}

		for j := len(ln.currencyPositivePrefix) - 1; j >= 0; j-- {
			b = append(b, ln.currencyPositivePrefix[j])
		}

	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	return string(b)
}

var fnCardinalPluralRule_283d29635c231a3ca301081bab098305 = func(ln *localen, num float64, v uint64) locales.PluralRule {
	n := math.Abs(num)
	i := int64(n)
	f := locales.F(n, v)
	iMod100 := i % 100
	fMod100 := f % 100

	if (v == 0 && iMod100 == 1) || (fMod100 == 1) {
		return locales.PluralRuleOne
	} else if (v == 0 && iMod100 == 2) || (fMod100 == 2) {
		return locales.PluralRuleTwo
	} else if (v == 0 && iMod100 >= 3 && iMod100 <= 4) || (fMod100 >= 3 && fMod100 <= 4) {
		return locales.PluralRuleFew
	}

	return locales.PluralRuleOther
}

var fnFmtDateShort_e2379225f63633cef88f4847394352a7 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2e}...)
	b = strconv.AppendInt(b, int64(t.Month()), 10)
	b = append(b, []byte{0x2e}...)

	if t.Year() > 9 {
		b = append(b, strconv.Itoa(t.Year())[2:]...)
	} else {
		b = append(b, strconv.Itoa(t.Year())[1:]...)
	}

	return string(b)
}

var fnFmtDateMedium_ef6a0d569c19898d4747be489ddaa092 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2e}...)
	b = strconv.AppendInt(b, int64(t.Month()), 10)
	b = append(b, []byte{0x2e}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtCurrency_aef7b1a5f0fa6e5e0b90141eafbbc2bc = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 2 + 1*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	inSecondary := false
	groupThreshold := 3

	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == groupThreshold {
				b = append(b, ln.group[0])
				count = 1

				if !inSecondary {
					inSecondary = true
					groupThreshold = 2
				}
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	for j := len(symbol) - 1; j >= 0; j-- {
		b = append(b, symbol[j])
	}

	if num < 0 {
		b = append(b, ln.minus[0])
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	return string(b)
}

var fnFmtAccounting_802721cab60b1e4dbb9ad232ecdbf1f8 = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 2 + 1*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	inSecondary := false
	groupThreshold := 3

	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == groupThreshold {
				b = append(b, ln.group[0])
				count = 1

				if !inSecondary {
					inSecondary = true
					groupThreshold = 2
				}
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {

		for j := len(symbol) - 1; j >= 0; j-- {
			b = append(b, symbol[j])
		}

		b = append(b, ln.minus[0])

	} else {
		for j := len(symbol) - 1; j >= 0; j-- {
			b = append(b, symbol[j])
		}
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	return string(b)
}

var fnFmtDateMedium_cea69a8f4293bc29e07e966b34b3ea95 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = append(b, []byte{0xe0, 0xbd, 0xa6, 0xe0, 0xbe, 0xa4, 0xe0, 0xbe, 0xb1, 0xe0, 0xbd, 0xb2, 0xe0, 0xbc, 0x8b, 0xe0, 0xbd, 0xa3, 0xe0, 0xbd, 0xbc, 0xe0, 0xbc, 0x8b}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0x20, 0xe0, 0xbd, 0x9f, 0xe0, 0xbe, 0xb3, 0xe0, 0xbc, 0x8b}...)
	b = append(b, ln.monthsAbbreviated[t.Month()]...)
	b = append(b, []byte{0x20, 0xe0, 0xbd, 0x9a, 0xe0, 0xbd, 0xba, 0xe0, 0xbd, 0xa6, 0xe0, 0xbc, 0x8b}...)

	if t.Day() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Day()), 10)

	return string(b)
}

var fnFmtDateLong_86c295425cafc585c7a23c6ee82c54e5 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = append(b, []byte{0xe0, 0xbd, 0xa6, 0xe0, 0xbe, 0xa4, 0xe0, 0xbe, 0xb1, 0xe0, 0xbd, 0xb2, 0xe0, 0xbc, 0x8b, 0xe0, 0xbd, 0xa3, 0xe0, 0xbd, 0xbc, 0xe0, 0xbc, 0x8b}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x20, 0xe0, 0xbd, 0x9a, 0xe0, 0xbd, 0xba, 0xe0, 0xbd, 0xa6, 0xe0, 0xbc, 0x8b, 0x20}...)

	if t.Day() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Day()), 10)

	return string(b)
}

var fnFmtDateFull_c1263930de470ad716d47d79ffa18067 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = append(b, ln.daysWide[t.Weekday()]...)
	b = append(b, []byte{0x2c, 0x20, 0xe0, 0xbd, 0xa6, 0xe0, 0xbe, 0xa4, 0xe0, 0xbe, 0xb1, 0xe0, 0xbd, 0xb2, 0xe0, 0xbc, 0x8b, 0xe0, 0xbd, 0xa3, 0xe0, 0xbd, 0xbc, 0xe0, 0xbc, 0x8b}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x20, 0xe0, 0xbd, 0x9a, 0xe0, 0xbd, 0xba, 0xe0, 0xbd, 0xa6, 0xe0, 0xbc, 0x8b}...)

	if t.Day() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Day()), 10)

	return string(b)
}

var fnFmtTimeShort_f47f2039d4428f5cb43433a9d8952827 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = append(b, []byte{0xe0, 0xbd, 0x86, 0xe0, 0xbd, 0xb4, 0xe0, 0xbc, 0x8b, 0xe0, 0xbd, 0x9a, 0xe0, 0xbd, 0xbc, 0xe0, 0xbd, 0x91, 0xe0, 0xbc, 0x8b, 0x20}...)

	h := t.Hour()

	if h > 12 {
		h -= 12
	}

	b = strconv.AppendInt(b, int64(h), 10)
	b = append(b, []byte{0x20, 0xe0, 0xbd, 0xa6, 0xe0, 0xbe, 0x90, 0xe0, 0xbd, 0xa2, 0xe0, 0xbc, 0x8b, 0xe0, 0xbd, 0x98, 0xe0, 0xbc, 0x8b, 0x20}...)

	if t.Minute() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Minute()), 10)
	b = append(b, []byte{0x20}...)

	if t.Hour() < 12 {
		b = append(b, ln.periodsAbbreviated[0]...)
	} else {
		b = append(b, ln.periodsAbbreviated[1]...)
	}

	return string(b)
}

var fnFmtTimeMedium_9e0f9c064fe3f07e66fe8fd5bfc4b612 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = append(b, []byte{0xe0, 0xbd, 0x86, 0xe0, 0xbd, 0xb4, 0xe0, 0xbc, 0x8b, 0xe0, 0xbd, 0x9a, 0xe0, 0xbd, 0xbc, 0xe0, 0xbd, 0x91, 0xe0, 0xbc, 0x8b}...)

	h := t.Hour()

	if h > 12 {
		h -= 12
	}

	b = strconv.AppendInt(b, int64(h), 10)
	b = append(b, ln.timeSeparator...)

	if t.Minute() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Minute()), 10)
	b = append(b, ln.timeSeparator...)

	if t.Second() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Second()), 10)
	b = append(b, []byte{0x20}...)

	if t.Hour() < 12 {
		b = append(b, ln.periodsAbbreviated[0]...)
	} else {
		b = append(b, ln.periodsAbbreviated[1]...)
	}

	return string(b)
}

var fnFmtTimeLong_f3348bf1c6f276c7b95877da6ebb7ee0 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = append(b, []byte{0xe0, 0xbd, 0x86, 0xe0, 0xbd, 0xb4, 0xe0, 0xbc, 0x8b, 0xe0, 0xbd, 0x9a, 0xe0, 0xbd, 0xbc, 0xe0, 0xbd, 0x91, 0xe0, 0xbc, 0x8b, 0x20}...)

	h := t.Hour()

	if h > 12 {
		h -= 12
	}

	b = strconv.AppendInt(b, int64(h), 10)
	b = append(b, []byte{0x20, 0xe0, 0xbd, 0xa6, 0xe0, 0xbe, 0x90, 0xe0, 0xbd, 0xa2, 0xe0, 0xbc, 0x8b, 0xe0, 0xbd, 0x98, 0xe0, 0xbc, 0x8b, 0x20}...)

	if t.Minute() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Minute()), 10)
	b = append(b, ln.timeSeparator...)

	if t.Second() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Second()), 10)
	b = append(b, []byte{0x20}...)

	if t.Hour() < 12 {
		b = append(b, ln.periodsAbbreviated[0]...)
	} else {
		b = append(b, ln.periodsAbbreviated[1]...)
	}

	b = append(b, []byte{0x20}...)

	tz, _ := t.Zone()
	b = append(b, tz...)

	return string(b)
}

var fnFmtTimeFull_a9a2519152d6f243a597cc4bd6b266cc = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = append(b, []byte{0xe0, 0xbd, 0x86, 0xe0, 0xbd, 0xb4, 0xe0, 0xbc, 0x8b, 0xe0, 0xbd, 0x9a, 0xe0, 0xbd, 0xbc, 0xe0, 0xbd, 0x91, 0xe0, 0xbc, 0x8b, 0x20}...)

	h := t.Hour()

	if h > 12 {
		h -= 12
	}

	b = strconv.AppendInt(b, int64(h), 10)
	b = append(b, []byte{0x20, 0xe0, 0xbd, 0xa6, 0xe0, 0xbe, 0x90, 0xe0, 0xbd, 0xa2, 0xe0, 0xbc, 0x8b, 0xe0, 0xbd, 0x98, 0xe0, 0xbc, 0x8b, 0x20}...)

	if t.Minute() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Minute()), 10)
	b = append(b, ln.timeSeparator...)

	if t.Second() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Second()), 10)
	b = append(b, []byte{0x20}...)

	if t.Hour() < 12 {
		b = append(b, ln.periodsAbbreviated[0]...)
	} else {
		b = append(b, ln.periodsAbbreviated[1]...)
	}

	b = append(b, []byte{0x20}...)

	tz, _ := t.Zone()

	if btz, ok := ln.timezones[tz]; ok {
		b = append(b, btz...)
	} else {
		b = append(b, tz...)
	}

	return string(b)
}

var fnFmtDateMedium_ab00ad983b60af2ef2a78b1bbda56e5b = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = append(b, ln.monthsAbbreviated[t.Month()]...)
	b = append(b, []byte{0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x20, 0x6c, 0x69, 0x61}...)
	b = append(b, []byte{0x2c, 0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtDateLong_e44be20ec70caf75cec942e788bd6c7e = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x20, 0x6c, 0x69, 0x61}...)
	b = append(b, []byte{0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtDateFull_e5728fd357bcbdd2617427e16f6e55d2 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = append(b, ln.daysWide[t.Weekday()]...)
	b = append(b, []byte{0x2c, 0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x20, 0x6c, 0x69, 0x61}...)
	b = append(b, []byte{0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtTimeShort_8eb7cfdc1e992030ede9a1abfea545be = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Hour() < 12 {
		b = append(b, ln.periodsAbbreviated[0]...)
	} else {
		b = append(b, ln.periodsAbbreviated[1]...)
	}

	b = append(b, []byte{0x20, 0x67, 0x61}...)
	b = append(b, []byte{0x20}...)

	h := t.Hour()

	if h > 12 {
		h -= 12
	}

	b = strconv.AppendInt(b, int64(h), 10)
	b = append(b, ln.timeSeparator...)

	if t.Minute() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Minute()), 10)

	return string(b)
}

var fnFmtTimeMedium_aa77d70e448fa95de06962cfa9baf918 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Hour() < 12 {
		b = append(b, ln.periodsAbbreviated[0]...)
	} else {
		b = append(b, ln.periodsAbbreviated[1]...)
	}

	b = append(b, []byte{0x20, 0x67, 0x61}...)
	b = append(b, []byte{0x20}...)

	h := t.Hour()

	if h > 12 {
		h -= 12
	}

	b = strconv.AppendInt(b, int64(h), 10)
	b = append(b, ln.timeSeparator...)

	if t.Minute() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Minute()), 10)
	b = append(b, ln.timeSeparator...)

	if t.Second() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Second()), 10)

	return string(b)
}

var fnFmtTimeLong_eac3fe1ec156df0f86227350e36ea607 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Hour() < 12 {
		b = append(b, ln.periodsAbbreviated[0]...)
	} else {
		b = append(b, ln.periodsAbbreviated[1]...)
	}

	b = append(b, []byte{0x20, 0x67, 0x61}...)
	b = append(b, []byte{0x20}...)

	h := t.Hour()

	if h > 12 {
		h -= 12
	}

	b = strconv.AppendInt(b, int64(h), 10)
	b = append(b, ln.timeSeparator...)

	if t.Minute() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Minute()), 10)
	b = append(b, ln.timeSeparator...)

	if t.Second() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Second()), 10)
	b = append(b, []byte{0x20}...)

	tz, _ := t.Zone()
	b = append(b, tz...)

	return string(b)
}

var fnFmtTimeFull_93b0a8ad8fd85d3e1c5363d7419c3c1f = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Hour() < 12 {
		b = append(b, ln.periodsAbbreviated[0]...)
	} else {
		b = append(b, ln.periodsAbbreviated[1]...)
	}

	b = append(b, []byte{0x20, 0x67, 0x61}...)
	b = append(b, []byte{0x20}...)

	h := t.Hour()

	if h > 12 {
		h -= 12
	}

	b = strconv.AppendInt(b, int64(h), 10)
	b = append(b, ln.timeSeparator...)

	if t.Minute() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Minute()), 10)
	b = append(b, ln.timeSeparator...)

	if t.Second() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Second()), 10)
	b = append(b, []byte{0x20}...)

	tz, _ := t.Zone()

	if btz, ok := ln.timezones[tz]; ok {
		b = append(b, btz...)
	} else {
		b = append(b, tz...)
	}

	return string(b)
}

var fnOrdinalPluralRule_cd651b8fbb843044a30f45f56d776cdd = func(ln *localen, num float64, v uint64) locales.PluralRule {
	n := math.Abs(num)
	nMod100 := math.Mod(n, 100)
	nMod10 := math.Mod(n, 10)

	if nMod10 == 1 && nMod100 != 11 {
		return locales.PluralRuleOne
	} else if nMod10 == 2 && nMod100 != 12 {
		return locales.PluralRuleTwo
	} else if nMod10 == 3 && nMod100 != 13 {
		return locales.PluralRuleFew
	}

	return locales.PluralRuleOther
}

var fnOrdinalPluralRule_cffd7bd3da07e13d4f77ebcac21d7f1e = func(ln *localen, num float64, v uint64) locales.PluralRule {
	n := math.Abs(num)
	nMod10 := math.Mod(n, 10)
	nMod100 := math.Mod(n, 100)

	if nMod10 == 1 && nMod100 != 11 {
		return locales.PluralRuleOne
	} else if nMod10 == 2 && nMod100 != 12 {
		return locales.PluralRuleTwo
	} else if nMod10 == 3 && nMod100 != 13 {
		return locales.PluralRuleFew
	}

	return locales.PluralRuleOther
}

var fnFmtCurrency_39c53385a3c471ef586d2be3ae8b60b5 = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 4 + 1*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				b = append(b, ln.group[0])
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	for j := len(symbol) - 1; j >= 0; j-- {
		b = append(b, symbol[j])
	}

	for j := len(ln.currencyPositivePrefix) - 1; j >= 0; j-- {
		b = append(b, ln.currencyPositivePrefix[j])
	}

	if num < 0 {
		b = append(b, ln.minus[0])
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	return string(b)
}

var fnFmtAccounting_91234edbb271d7bc5c1a0b9f346174d7 = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 4 + 1*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				b = append(b, ln.group[0])
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {

		for j := len(symbol) - 1; j >= 0; j-- {
			b = append(b, symbol[j])
		}

		for j := len(ln.currencyNegativePrefix) - 1; j >= 0; j-- {
			b = append(b, ln.currencyNegativePrefix[j])
		}

		b = append(b, ln.minus[0])

	} else {

		for j := len(symbol) - 1; j >= 0; j-- {
			b = append(b, symbol[j])
		}

		for j := len(ln.currencyPositivePrefix) - 1; j >= 0; j-- {
			b = append(b, ln.currencyPositivePrefix[j])
		}

	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	return string(b)
}

var fnFmtDateFull_588a96656cc1da10a40d88dd26ead028 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = append(b, ln.daysWide[t.Weekday()]...)
	b = append(b, []byte{0x2c, 0x20}...)

	if t.Day() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtDateMedium_4691817e98b7c85cafc185bbd5485130 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Day() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2d}...)
	b = append(b, ln.monthsAbbreviated[t.Month()]...)
	b = append(b, []byte{0x2d}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtAccounting_1cec81a7ffd91500b29d60f1aa496f40 = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 3 + 3*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				for j := len(ln.group) - 1; j >= 0; j-- {
					b = append(b, ln.group[j])
				}
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {

		for j := len(symbol) - 1; j >= 0; j-- {
			b = append(b, symbol[j])
		}

		b = append(b, ln.currencyNegativePrefix[0])

	} else {

		for j := len(symbol) - 1; j >= 0; j-- {
			b = append(b, symbol[j])
		}

		for j := len(ln.currencyPositivePrefix) - 1; j >= 0; j-- {
			b = append(b, ln.currencyPositivePrefix[j])
		}

	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	return string(b)
}

var fnFmtTimeShort_7341725c8ebd7a50d221ac00ecc6aa99 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Hour()), 10)
	b = append(b, []byte{0x2e}...)

	if t.Minute() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Minute()), 10)

	return string(b)
}

var fnFmtTimeMedium_ceaaad7cbbdab7b4a378fe8eff296f4f = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Hour()), 10)
	b = append(b, []byte{0x2e}...)

	if t.Minute() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Minute()), 10)
	b = append(b, []byte{0x2e}...)

	if t.Second() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Second()), 10)

	return string(b)
}

var fnFmtTimeLong_ed4e4ed1e2c01c9ce9c9f6344a272944 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Hour()), 10)
	b = append(b, []byte{0x2e}...)

	if t.Minute() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Minute()), 10)
	b = append(b, []byte{0x2e}...)

	if t.Second() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Second()), 10)
	b = append(b, []byte{0x20}...)

	tz, _ := t.Zone()
	b = append(b, tz...)

	return string(b)
}

var fnFmtTimeFull_105c4fe53621c460d37a501cec666cf0 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Hour()), 10)
	b = append(b, []byte{0x2e}...)

	if t.Minute() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Minute()), 10)
	b = append(b, []byte{0x2e}...)

	if t.Second() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Second()), 10)
	b = append(b, []byte{0x20}...)

	tz, _ := t.Zone()

	if btz, ok := ln.timezones[tz]; ok {
		b = append(b, btz...)
	} else {
		b = append(b, tz...)
	}

	return string(b)
}

var fnFmtAccounting_343c016939c767f482f0f2a41239f465 = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 6 + 1*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				b = append(b, ln.group[0])
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {

		for j := len(symbol) - 1; j >= 0; j-- {
			b = append(b, symbol[j])
		}

		for j := len(ln.currencyNegativePrefix) - 1; j >= 0; j-- {
			b = append(b, ln.currencyNegativePrefix[j])
		}

	} else {

		for j := len(symbol) - 1; j >= 0; j-- {
			b = append(b, symbol[j])
		}

		for j := len(ln.currencyPositivePrefix) - 1; j >= 0; j-- {
			b = append(b, ln.currencyPositivePrefix[j])
		}

	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	if num < 0 {
		b = append(b, ln.currencyNegativeSuffix...)
	}

	return string(b)
}

var fnFmtDateShort_fed047b78adc0ecb9a1387099de9feec = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2f}...)

	if t.Month() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Month()), 10)

	b = append(b, []byte{0x2f}...)

	if t.Year() > 9 {
		b = append(b, strconv.Itoa(t.Year())[2:]...)
	} else {
		b = append(b, strconv.Itoa(t.Year())[1:]...)
	}

	return string(b)
}

var fnFmtDateMedium_d9e5c72d9a18dbee96ce40275bf098d9 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2f}...)

	if t.Month() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Month()), 10)

	b = append(b, []byte{0x2f}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtCurrency_07bed080e46342275478260b22396b2d = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 5 + 1*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				b = append(b, ln.group[0])
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {
		b = append(b, ln.minus[0])
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	b = append(b, ln.currencyPositiveSuffix...)

	b = append(b, symbol...)

	return string(b)
}

var fnFmtAccounting_d9ac2a39e70db1e3f296933e6431fc50 = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 5 + 1*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				b = append(b, ln.group[0])
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {
		b = append(b, ln.minus[0])
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	if num < 0 {
		b = append(b, ln.currencyNegativeSuffix...)
		b = append(b, symbol...)
	} else {

		b = append(b, ln.currencyPositiveSuffix...)
		b = append(b, symbol...)
	}

	return string(b)
}

var fnFmtNumber_af287e772ea3855f073fceb6afe2a3de = func(ln *localen, num float64, v uint64) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	l := len(s) + 2

	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			continue
		}

		b = append(b, s[i])
	}

	if num < 0 {
		b = append(b, ln.minus[0])
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	return string(b)
}

var fnFmtCurrency_5fa862915ab8be0ffdb30cbcbd4dcadc = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 4

	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			continue
		}

		b = append(b, s[i])
	}

	for j := len(symbol) - 1; j >= 0; j-- {
		b = append(b, symbol[j])
	}

	for j := len(ln.currencyPositivePrefix) - 1; j >= 0; j-- {
		b = append(b, ln.currencyPositivePrefix[j])
	}

	if num < 0 {
		b = append(b, ln.minus[0])
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	return string(b)
}

var fnFmtAccounting_a127ece36a88f91b941483802dde95a0 = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 4

	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			continue
		}

		b = append(b, s[i])
	}

	if num < 0 {

		for j := len(symbol) - 1; j >= 0; j-- {
			b = append(b, symbol[j])
		}

		for j := len(ln.currencyNegativePrefix) - 1; j >= 0; j-- {
			b = append(b, ln.currencyNegativePrefix[j])
		}

		b = append(b, ln.minus[0])

	} else {

		for j := len(symbol) - 1; j >= 0; j-- {
			b = append(b, symbol[j])
		}

		for j := len(ln.currencyPositivePrefix) - 1; j >= 0; j-- {
			b = append(b, ln.currencyPositivePrefix[j])
		}

	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	return string(b)
}

var fnFmtDateShort_933fcf2387ca32382dae956e0bc893a7 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0x2f}...)

	if t.Month() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Month()), 10)

	b = append(b, []byte{0x2f}...)

	if t.Day() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Day()), 10)

	return string(b)
}

var fnFmtDateMedium_03498001dbf6972dcc828c46e13ec4d2 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Day() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsAbbreviated[t.Month()]...)
	b = append(b, []byte{0x2c}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtNumber_4752830681b621a14386608b6d45d3fb = func(ln *localen, num float64, v uint64) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	l := len(s) + 4 + 2*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				for j := len(ln.group) - 1; j >= 0; j-- {
					b = append(b, ln.group[j])
				}
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {
		for j := len(ln.minus) - 1; j >= 0; j-- {
			b = append(b, ln.minus[j])
		}
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	return string(b)
}

var fnFmtPercent_efbfbc738b43a1167c92b076dba0ef50 = func(ln *localen, num float64, v uint64) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	l := len(s) + 5
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			continue
		}

		b = append(b, s[i])
	}

	if num < 0 {
		for j := len(ln.minus) - 1; j >= 0; j-- {
			b = append(b, ln.minus[j])
		}
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	b = append(b, ln.percent...)

	return string(b)
}

var fnFmtCurrency_f487e5cbe1d950a699f4afb3c0267309 = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 7

	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			continue
		}

		b = append(b, s[i])
	}

	for j := len(symbol) - 1; j >= 0; j-- {
		b = append(b, symbol[j])
	}

	for j := len(ln.currencyPositivePrefix) - 1; j >= 0; j-- {
		b = append(b, ln.currencyPositivePrefix[j])
	}

	if num < 0 {
		for j := len(ln.minus) - 1; j >= 0; j-- {
			b = append(b, ln.minus[j])
		}
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	b = append(b, ln.currencyPositiveSuffix...)

	return string(b)
}

var fnFmtAccounting_1faa91947b5020e2fec6143cbb8a4554 = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 7

	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			continue
		}

		b = append(b, s[i])
	}

	if num < 0 {

		for j := len(symbol) - 1; j >= 0; j-- {
			b = append(b, symbol[j])
		}

		for j := len(ln.currencyNegativePrefix) - 1; j >= 0; j-- {
			b = append(b, ln.currencyNegativePrefix[j])
		}

		for j := len(ln.minus) - 1; j >= 0; j-- {
			b = append(b, ln.minus[j])
		}

	} else {

		for j := len(symbol) - 1; j >= 0; j-- {
			b = append(b, symbol[j])
		}

		for j := len(ln.currencyPositivePrefix) - 1; j >= 0; j-- {
			b = append(b, ln.currencyPositivePrefix[j])
		}

	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if num < 0 {
		b = append(b, ln.currencyNegativeSuffix...)
	} else {
		b = append(b, ln.currencyPositiveSuffix...)
	}

	return string(b)
}

var fnFmtDateShort_f3b37aea35b3c974130a62cb3d9b1580 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Year() > 9 {
		b = append(b, strconv.Itoa(t.Year())[2:]...)
	} else {
		b = append(b, strconv.Itoa(t.Year())[1:]...)
	}

	b = append(b, []byte{0x2d}...)

	if t.Month() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Month()), 10)

	b = append(b, []byte{0x2d}...)

	if t.Day() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Day()), 10)

	return string(b)
}

var fnFmtDateMedium_438f654701b049881de419adc50805ae = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0x2d}...)
	b = append(b, ln.monthsAbbreviated[t.Month()]...)
	b = append(b, []byte{0x2d}...)

	if t.Day() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Day()), 10)

	return string(b)
}

var fnFmtDateLong_29470171f6adaadee5f349206b90e4b3 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0x2d}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x2d}...)

	if t.Day() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Day()), 10)

	return string(b)
}

var fnFmtDateFull_3d08635fa599fe67dc92007b3dff4e42 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = append(b, ln.daysWide[t.Weekday()]...)
	b = append(b, []byte{0x2c, 0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2d, 0x61}...)
	b = append(b, []byte{0x20, 0x64, 0x65}...)
	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtTimeFull_8592fa74ce11c45fadae8071a016331d = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Hour()), 10)
	b = append(b, []byte{0x2d, 0x61}...)
	b = append(b, []byte{0x20, 0x68, 0x6f, 0x72, 0x6f}...)
	b = append(b, []byte{0x20, 0x6b, 0x61, 0x6a}...)
	b = append(b, []byte{0x20}...)
	b = strconv.AppendInt(b, int64(t.Minute()), 10)
	b = append(b, ln.timeSeparator...)

	if t.Second() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Second()), 10)
	b = append(b, []byte{0x20}...)

	tz, _ := t.Zone()

	if btz, ok := ln.timezones[tz]; ok {
		b = append(b, btz...)
	} else {
		b = append(b, tz...)
	}

	return string(b)
}

var fnFmtDateLong_ca69f3b8d3dd39b3093791ebf34437bc = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x20, 0x64, 0x65}...)
	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x20, 0x64, 0x65}...)
	b = append(b, []byte{0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtDateFull_884dee6d35c0b3a152fe300562570c35 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = append(b, ln.daysWide[t.Weekday()]...)
	b = append(b, []byte{0x2c, 0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x20, 0x64, 0x65}...)
	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x20, 0x64, 0x65}...)
	b = append(b, []byte{0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtTimeFull_e678928158d95fb12912f844eab5a4da = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Hour()), 10)
	b = append(b, ln.timeSeparator...)

	if t.Minute() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Minute()), 10)
	b = append(b, ln.timeSeparator...)

	if t.Second() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Second()), 10)
	b = append(b, []byte{0x20, 0x28}...)

	tz, _ := t.Zone()

	if btz, ok := ln.timezones[tz]; ok {
		b = append(b, btz...)
	} else {
		b = append(b, tz...)
	}

	b = append(b, []byte{0x29}...)

	return string(b)
}

var fnFmtAccounting_7dee7e59ce6d2bee18c8d020e66feda7 = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 2 + 1*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				b = append(b, ln.group[0])
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {

		for j := len(symbol) - 1; j >= 0; j-- {
			b = append(b, symbol[j])
		}

		b = append(b, ln.minus[0])

	} else {
		for j := len(symbol) - 1; j >= 0; j-- {
			b = append(b, symbol[j])
		}
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	return string(b)
}

var fnFmtDateMedium_0d7c652de418db235f2b6e6504ac834b = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsAbbreviated[t.Month()]...)
	b = append(b, []byte{0x20, 0x64, 0x65}...)
	b = append(b, []byte{0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtDateShort_2ad99bf760d4b47854009ea5a8878148 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Day() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2d}...)

	if t.Month() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Month()), 10)

	b = append(b, []byte{0x2d}...)

	if t.Year() > 9 {
		b = append(b, strconv.Itoa(t.Year())[2:]...)
	} else {
		b = append(b, strconv.Itoa(t.Year())[1:]...)
	}

	return string(b)
}

var fnFmtAccounting_faa0f0273050790b69e9c65ef1bb23a5 = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 2 + 2*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				for j := len(ln.group) - 1; j >= 0; j-- {
					b = append(b, ln.group[j])
				}
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {

		for j := len(symbol) - 1; j >= 0; j-- {
			b = append(b, symbol[j])
		}

		b = append(b, ln.minus[0])

	} else {
		for j := len(symbol) - 1; j >= 0; j-- {
			b = append(b, symbol[j])
		}
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	return string(b)
}

var fnFmtCurrency_07151969777dd3bbde27b10b4452a66e = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 3 + 1*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				b = append(b, ln.group[0])
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	for j := len(symbol) - 1; j >= 0; j-- {
		b = append(b, symbol[j])
	}

	if num < 0 {
		b = append(b, ln.minus[0])
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	b = append(b, ln.currencyPositiveSuffix...)

	return string(b)
}

var fnFmtAccounting_2a94e5a57391565d92034abc27eaffd6 = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 3 + 1*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				b = append(b, ln.group[0])
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {

		for j := len(symbol) - 1; j >= 0; j-- {
			b = append(b, symbol[j])
		}

		b = append(b, ln.minus[0])

	} else {
		for j := len(symbol) - 1; j >= 0; j-- {
			b = append(b, symbol[j])
		}
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	if num < 0 {
		b = append(b, ln.currencyNegativeSuffix...)
	} else {
		b = append(b, ln.currencyPositiveSuffix...)
	}

	return string(b)
}

var fnFmtCurrency_881a0ebc0b06ab2865571a388b8bfc08 = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 3

	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			continue
		}

		b = append(b, s[i])
	}

	for j := len(symbol) - 1; j >= 0; j-- {
		b = append(b, symbol[j])
	}

	if num < 0 {
		b = append(b, ln.minus[0])
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	b = append(b, ln.currencyPositiveSuffix...)

	return string(b)
}

var fnFmtAccounting_be7b974f27e584be73758ded6170b27f = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 3

	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			continue
		}

		b = append(b, s[i])
	}

	if num < 0 {

		for j := len(symbol) - 1; j >= 0; j-- {
			b = append(b, symbol[j])
		}

		b = append(b, ln.minus[0])

	} else {
		for j := len(symbol) - 1; j >= 0; j-- {
			b = append(b, symbol[j])
		}
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if num < 0 {
		b = append(b, ln.currencyNegativeSuffix...)
	} else {
		b = append(b, ln.currencyPositiveSuffix...)
	}

	return string(b)
}

var fnFmtDateLong_536b20d0ef96110ea200943add1efbd4 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Day() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x20, 0x64, 0x65}...)
	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x20, 0x64, 0x65}...)
	b = append(b, []byte{0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtDateFull_dfeece500544d4aac4424f7155ba90ca = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = append(b, ln.daysWide[t.Weekday()]...)
	b = append(b, []byte{0x20}...)

	if t.Day() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x20, 0x64, 0x65}...)
	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x20, 0x64, 0x65}...)
	b = append(b, []byte{0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtCurrency_e4c5476e381e260e6a551a757542b603 = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 5

	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			continue
		}

		b = append(b, s[i])
	}

	if num < 0 {
		b = append(b, ln.minus[0])
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	b = append(b, ln.currencyPositiveSuffix...)

	b = append(b, symbol...)

	return string(b)
}

var fnFmtAccounting_7fb5040dc04d16c016c545b9369751e6 = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 5

	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			continue
		}

		b = append(b, s[i])
	}

	if num < 0 {
		b = append(b, ln.minus[0])
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if num < 0 {
		b = append(b, ln.currencyNegativeSuffix...)
		b = append(b, symbol...)
	} else {

		b = append(b, ln.currencyPositiveSuffix...)
		b = append(b, symbol...)
	}

	return string(b)
}

var fnFmtDateShort_2aa2afdcdd2a2fb3ad7fdbe2b097c54b = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Month() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Month()), 10)

	b = append(b, []byte{0x2f}...)

	if t.Day() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2f}...)

	if t.Year() > 9 {
		b = append(b, strconv.Itoa(t.Year())[2:]...)
	} else {
		b = append(b, strconv.Itoa(t.Year())[1:]...)
	}

	return string(b)
}

var fnFmtDateMedium_85a85042ebcb9523c624cbf546fcb94d = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Month() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Month()), 10)

	b = append(b, []byte{0x2f}...)

	if t.Day() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2f}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtCurrency_3b8812d78208fcdb8a36c9b00e4a7784 = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 7

	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			continue
		}

		b = append(b, s[i])
	}

	if num < 0 {
		b = append(b, ln.minus[0])
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	b = append(b, ln.currencyPositiveSuffix...)

	b = append(b, symbol...)

	return string(b)
}

var fnFmtAccounting_34acd29c5979a61e92f53e9eaa5dcb93 = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 7

	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			continue
		}

		b = append(b, s[i])
	}

	if num < 0 {
		b = append(b, ln.minus[0])
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if num < 0 {
		b = append(b, ln.currencyNegativeSuffix...)
		b = append(b, symbol...)
	} else {

		b = append(b, ln.currencyPositiveSuffix...)
		b = append(b, symbol...)
	}

	return string(b)
}

var fnFmtCurrency_83ba1db7b672d5fc5d43b771b7b38f5a = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 6 + 2*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				for j := len(ln.group) - 1; j >= 0; j-- {
					b = append(b, ln.group[j])
				}
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {
		for j := len(ln.minus) - 1; j >= 0; j-- {
			b = append(b, ln.minus[j])
		}
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	b = append(b, ln.currencyPositiveSuffix...)

	b = append(b, symbol...)

	return string(b)
}

var fnFmtAccounting_a8f4207331b08e428b5c3f7d5c7887ea = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 8 + 2*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				for j := len(ln.group) - 1; j >= 0; j-- {
					b = append(b, ln.group[j])
				}
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {
		b = append(b, ln.currencyNegativePrefix[0])
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	if num < 0 {
		b = append(b, ln.currencyNegativeSuffix...)
		b = append(b, symbol...)
	} else {

		b = append(b, ln.currencyPositiveSuffix...)
		b = append(b, symbol...)
	}

	return string(b)
}

var fnFmtPercent_7e5d64b2fa6162d30c9f7af69791fb63 = func(ln *localen, num float64, v uint64) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	l := len(s) + 7 + 1*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true

			continue
		}

		if inWhole {
			if count == 3 {
				b = append(b, ln.group[0])
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {
		for j := len(ln.minus) - 1; j >= 0; j-- {
			b = append(b, ln.minus[j])
		}
	}

	for j := len(ln.percentPrefix) - 1; j >= 0; j-- {
		b = append(b, ln.percentPrefix[j])
	}

	b = append(b, ln.percent[0])

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	return string(b)
}

var fnFmtAccounting_d5329ec1e9c68656688f5fd3b4fa22fc = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 8 + 1*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				b = append(b, ln.group[0])
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {
		b = append(b, ln.currencyNegativePrefix[0])
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	if num < 0 {
		b = append(b, ln.currencyNegativeSuffix...)
		b = append(b, symbol...)
	} else {

		b = append(b, ln.currencyPositiveSuffix...)
		b = append(b, symbol...)
	}

	return string(b)
}

var fnFmtDateShort_28a99d53f2aae59a12f8564b98a20b86 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Year() > 9 {
		b = append(b, strconv.Itoa(t.Year())[2:]...)
	} else {
		b = append(b, strconv.Itoa(t.Year())[1:]...)
	}

	b = append(b, []byte{0x2f}...)
	b = strconv.AppendInt(b, int64(t.Month()), 10)
	b = append(b, []byte{0x2f}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)

	return string(b)
}

var fnFmtDateMedium_b224450320ab0608c36fa5f823a8ec71 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0x28, 0x65}...)
	b = append(b, []byte{0x29, 0x6b, 0x6f}...)
	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsAbbreviated[t.Month()]...)
	b = append(b, []byte{0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x28, 0x61}...)
	b = append(b, []byte{0x29}...)

	return string(b)
}

var fnFmtDateLong_d0f2638a27c1f5c6700933f0a0be8242 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0x28, 0x65}...)
	b = append(b, []byte{0x29, 0x6b, 0x6f}...)
	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x72, 0x65, 0x6e}...)
	b = append(b, []byte{0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x28, 0x61}...)
	b = append(b, []byte{0x29}...)

	return string(b)
}

var fnFmtDateFull_f8187d99975235abc8e4a8d4e7b75463 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0x28, 0x65}...)
	b = append(b, []byte{0x29, 0x6b, 0x6f}...)
	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x72, 0x65, 0x6e}...)
	b = append(b, []byte{0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x28, 0x61}...)
	b = append(b, []byte{0x29, 0x2c, 0x20}...)
	b = append(b, ln.daysWide[t.Weekday()]...)

	return string(b)
}

var fnFmtTimeLong_30191015e11c1c183d8d41d8e0e78b42 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Hour() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Hour()), 10)
	b = append(b, ln.timeSeparator...)

	if t.Minute() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Minute()), 10)
	b = append(b, ln.timeSeparator...)

	if t.Second() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Second()), 10)
	b = append(b, []byte{0x20, 0x28}...)

	tz, _ := t.Zone()
	b = append(b, tz...)

	b = append(b, []byte{0x29}...)

	return string(b)
}

var fnFmtTimeFull_faed166f66bf2512306c6e70b367cf67 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Hour() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Hour()), 10)
	b = append(b, ln.timeSeparator...)

	if t.Minute() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Minute()), 10)
	b = append(b, ln.timeSeparator...)

	if t.Second() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Second()), 10)
	b = append(b, []byte{0x20, 0x28}...)

	tz, _ := t.Zone()

	if btz, ok := ln.timezones[tz]; ok {
		b = append(b, btz...)
	} else {
		b = append(b, tz...)
	}

	b = append(b, []byte{0x29}...)

	return string(b)
}

var fnFmtPercent_ae9cd15ae8cd02228932d7cfc0262f2b = func(ln *localen, num float64, v uint64) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	l := len(s) + 10
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			for j := len(ln.decimal) - 1; j >= 0; j-- {
				b = append(b, ln.decimal[j])
			}
			continue
		}

		b = append(b, s[i])
	}

	if num < 0 {
		for j := len(ln.minus) - 1; j >= 0; j-- {
			b = append(b, ln.minus[j])
		}
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	b = append(b, ln.percent...)

	return string(b)
}

var fnFmtCurrency_1ccdf5c54785959abd27ce458030d981 = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 11 + 2*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			for j := len(ln.decimal) - 1; j >= 0; j-- {
				b = append(b, ln.decimal[j])
			}
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				for j := len(ln.group) - 1; j >= 0; j-- {
					b = append(b, ln.group[j])
				}
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	for j := len(symbol) - 1; j >= 0; j-- {
		b = append(b, symbol[j])
	}

	for j := len(ln.currencyPositivePrefix) - 1; j >= 0; j-- {
		b = append(b, ln.currencyPositivePrefix[j])
	}

	if num < 0 {
		for j := len(ln.minus) - 1; j >= 0; j-- {
			b = append(b, ln.minus[j])
		}
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	return string(b)
}

var fnFmtAccounting_980dd7146e58d4f3ce6aa6637bc1f3bc = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 11 + 2*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			for j := len(ln.decimal) - 1; j >= 0; j-- {
				b = append(b, ln.decimal[j])
			}
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				for j := len(ln.group) - 1; j >= 0; j-- {
					b = append(b, ln.group[j])
				}
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {

		for j := len(symbol) - 1; j >= 0; j-- {
			b = append(b, symbol[j])
		}

		for j := len(ln.currencyNegativePrefix) - 1; j >= 0; j-- {
			b = append(b, ln.currencyNegativePrefix[j])
		}

		for j := len(ln.minus) - 1; j >= 0; j-- {
			b = append(b, ln.minus[j])
		}

	} else {

		for j := len(symbol) - 1; j >= 0; j-- {
			b = append(b, symbol[j])
		}

		for j := len(ln.currencyPositivePrefix) - 1; j >= 0; j-- {
			b = append(b, ln.currencyPositivePrefix[j])
		}

	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	return string(b)
}

var fnFmtDateShort_bbd1b73cfd7bfe3839238c39758a7dfc = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0x2f}...)
	b = strconv.AppendInt(b, int64(t.Month()), 10)
	b = append(b, []byte{0x2f}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)

	return string(b)
}

var fnFmtTimeLong_e098bb5b410cb647ab1fb51d60e8416c = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Hour()), 10)
	b = append(b, ln.timeSeparator...)

	if t.Minute() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Minute()), 10)
	b = append(b, ln.timeSeparator...)

	if t.Second() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Second()), 10)
	b = append(b, []byte{0x20, 0x28}...)

	tz, _ := t.Zone()
	b = append(b, tz...)

	b = append(b, []byte{0x29}...)

	return string(b)
}

var fnFmtCurrency_8a07279a530bf4495d0582798587f7c0 = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 10 + 2*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			for j := len(ln.decimal) - 1; j >= 0; j-- {
				b = append(b, ln.decimal[j])
			}
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				for j := len(ln.group) - 1; j >= 0; j-- {
					b = append(b, ln.group[j])
				}
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	for j := len(symbol) - 1; j >= 0; j-- {
		b = append(b, symbol[j])
	}

	for j := len(ln.currencyPositivePrefix) - 1; j >= 0; j-- {
		b = append(b, ln.currencyPositivePrefix[j])
	}

	if num < 0 {
		for j := len(ln.minus) - 1; j >= 0; j-- {
			b = append(b, ln.minus[j])
		}
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	return string(b)
}

var fnFmtAccounting_15b09dc3a083df3b5892baf7c777f025 = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 10 + 2*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			for j := len(ln.decimal) - 1; j >= 0; j-- {
				b = append(b, ln.decimal[j])
			}
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				for j := len(ln.group) - 1; j >= 0; j-- {
					b = append(b, ln.group[j])
				}
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {

		for j := len(symbol) - 1; j >= 0; j-- {
			b = append(b, symbol[j])
		}

		for j := len(ln.currencyNegativePrefix) - 1; j >= 0; j-- {
			b = append(b, ln.currencyNegativePrefix[j])
		}

		for j := len(ln.minus) - 1; j >= 0; j-- {
			b = append(b, ln.minus[j])
		}

	} else {

		for j := len(symbol) - 1; j >= 0; j-- {
			b = append(b, symbol[j])
		}

		for j := len(ln.currencyPositivePrefix) - 1; j >= 0; j-- {
			b = append(b, ln.currencyPositivePrefix[j])
		}

	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	return string(b)
}

var fnCardinalPluralRule_1412ead9823f992d32fe783f7305e41f = func(ln *localen, num float64, v uint64) locales.PluralRule {
	n := math.Abs(num)
	i := int64(n)

	if i == 0 || i == 1 {
		return locales.PluralRuleOne
	}

	return locales.PluralRuleOther
}

var fnFmtPercent_08e428b6d93eff202ec014fb83b395cf = func(ln *localen, num float64, v uint64) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	l := len(s) + 7
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			continue
		}

		b = append(b, s[i])
	}

	if num < 0 {
		for j := len(ln.minus) - 1; j >= 0; j-- {
			b = append(b, ln.minus[j])
		}
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	b = append(b, ln.percentSuffix...)

	b = append(b, ln.percent...)

	return string(b)
}

var fnFmtAccounting_b212f316e9ff6f3259af6a85a9984d08 = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 6 + 2*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				for j := len(ln.group) - 1; j >= 0; j-- {
					b = append(b, ln.group[j])
				}
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {
		for j := len(ln.minus) - 1; j >= 0; j-- {
			b = append(b, ln.minus[j])
		}
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	if num < 0 {
		b = append(b, ln.currencyNegativeSuffix...)
		b = append(b, symbol...)
	} else {

		b = append(b, ln.currencyPositiveSuffix...)
		b = append(b, symbol...)
	}

	return string(b)
}

var fnFmtDateShort_3d7a5686ec224df77035cb4531629cfa = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2e}...)
	b = strconv.AppendInt(b, int64(t.Month()), 10)
	b = append(b, []byte{0x2e}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtDateFull_d1d28b42f6cc00a3a8fb2b3af29b2b99 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = append(b, []byte{0x63, 0x63, 0x63, 0x63, 0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2e, 0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnOrdinalPluralRule_89b8067afb87364ac493104461523e40 = func(ln *localen, num float64, v uint64) locales.PluralRule {
	n := math.Abs(num)

	if n == 1 {
		return locales.PluralRuleOne
	}

	return locales.PluralRuleOther
}

var fnFmtCurrency_781a083ba875d0db385fcba596c8fe2f = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 4 + 3*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				for j := len(ln.group) - 1; j >= 0; j-- {
					b = append(b, ln.group[j])
				}
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {
		b = append(b, ln.minus[0])
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	b = append(b, ln.currencyPositiveSuffix...)

	b = append(b, symbol...)

	return string(b)
}

var fnFmtAccounting_cf57cb3d1c6f3cc11c398367995ecf75 = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 6 + 3*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				for j := len(ln.group) - 1; j >= 0; j-- {
					b = append(b, ln.group[j])
				}
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {
		b = append(b, ln.currencyNegativePrefix[0])
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	if num < 0 {
		b = append(b, ln.currencyNegativeSuffix...)
		b = append(b, symbol...)
	} else {

		b = append(b, ln.currencyPositiveSuffix...)
		b = append(b, symbol...)
	}

	return string(b)
}

var fnFmtTimeFull_3604e9a5c6e536d483b9ceb5e0908b94 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Hour()), 10)
	b = append(b, []byte{0x20, 0x68}...)
	b = append(b, []byte{0x20}...)

	if t.Minute() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Minute()), 10)
	b = append(b, []byte{0x20, 0x6d, 0x69, 0x6e}...)
	b = append(b, []byte{0x20}...)

	if t.Second() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Second()), 10)
	b = append(b, []byte{0x20, 0x73}...)
	b = append(b, []byte{0x20}...)

	tz, _ := t.Zone()

	if btz, ok := ln.timezones[tz]; ok {
		b = append(b, btz...)
	} else {
		b = append(b, tz...)
	}

	return string(b)
}

var fnFmtTimeShort_77616a5d5285f57c035b3599c557be3f = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Hour() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Hour()), 10)
	b = append(b, []byte{0x20, 0x68}...)
	b = append(b, []byte{0x20}...)

	if t.Minute() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Minute()), 10)

	return string(b)
}

var fnFmtTimeMedium_5ee755e4617064423cc20f8812f3f20e = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Hour() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Hour()), 10)
	b = append(b, []byte{0x20, 0x68}...)
	b = append(b, []byte{0x20}...)

	if t.Minute() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Minute()), 10)
	b = append(b, []byte{0x20, 0x6d, 0x69, 0x6e}...)
	b = append(b, []byte{0x20}...)

	if t.Second() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Second()), 10)
	b = append(b, []byte{0x20, 0x73}...)

	return string(b)
}

var fnFmtTimeLong_890d4627ee8be38589c6184a42b5e739 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Hour() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Hour()), 10)
	b = append(b, []byte{0x20, 0x68}...)
	b = append(b, []byte{0x20}...)

	if t.Minute() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Minute()), 10)
	b = append(b, []byte{0x20, 0x6d, 0x69, 0x6e}...)
	b = append(b, []byte{0x20}...)

	if t.Second() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Second()), 10)
	b = append(b, []byte{0x20, 0x73}...)
	b = append(b, []byte{0x20}...)

	tz, _ := t.Zone()
	b = append(b, tz...)

	return string(b)
}

var fnFmtTimeFull_08768b0816a0563c1bdec56e3a7c7227 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Hour() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Hour()), 10)
	b = append(b, []byte{0x20, 0x68}...)
	b = append(b, []byte{0x20}...)

	if t.Minute() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Minute()), 10)
	b = append(b, []byte{0x20, 0x6d, 0x69, 0x6e}...)
	b = append(b, []byte{0x20}...)

	if t.Second() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Second()), 10)
	b = append(b, []byte{0x20, 0x73}...)
	b = append(b, []byte{0x20}...)

	tz, _ := t.Zone()

	if btz, ok := ln.timezones[tz]; ok {
		b = append(b, btz...)
	} else {
		b = append(b, tz...)
	}

	return string(b)
}

var fnFmtTimeFull_7190bcf20785aafef3dd5520b994587a = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Hour() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Hour()), 10)
	b = append(b, []byte{0x2e}...)

	if t.Minute() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Minute()), 10)
	b = append(b, ln.timeSeparator...)

	if t.Second() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Second()), 10)
	b = append(b, []byte{0x20, 0x68}...)
	b = append(b, []byte{0x20}...)

	tz, _ := t.Zone()

	if btz, ok := ln.timezones[tz]; ok {
		b = append(b, btz...)
	} else {
		b = append(b, tz...)
	}

	return string(b)
}

var fnFmtDateMedium_259dde974c52d4b5dc45a53d5ed154c6 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Day() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2f}...)

	if t.Month() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Month()), 10)

	b = append(b, []byte{0x2f}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtDateLong_35ef415790b91229102369fdc2485b80 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x20, 0x64, 0x69}...)
	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x20, 0x64, 0x61, 0x6c}...)
	b = append(b, []byte{0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtDateFull_0987fcfde5397e392daea76f23ab1c65 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = append(b, ln.daysWide[t.Weekday()]...)
	b = append(b, []byte{0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x20, 0x64, 0x69}...)
	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x20, 0x64, 0x61, 0x6c}...)
	b = append(b, []byte{0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnCardinalPluralRule_5424a4808e45b44daf4dd95a868534c9 = func(ln *localen, num float64, v uint64) locales.PluralRule {
	n := math.Abs(num)

	if n == 1 {
		return locales.PluralRuleOne
	} else if n == 2 {
		return locales.PluralRuleTwo
	} else if n >= 3 && n <= 6 {
		return locales.PluralRuleFew
	} else if n >= 7 && n <= 10 {
		return locales.PluralRuleMany
	}

	return locales.PluralRuleOther
}

var fnRangePluralRule_ba2eea4558b51a6ab55725541be07d3f = func(ln *localen, num1 float64, v1 uint64, num2 float64, v2 uint64) locales.PluralRule {
	start := ln.CardinalPluralRule(num1, v1)
	end := ln.CardinalPluralRule(num2, v2)

	if start == locales.PluralRuleOne && end == locales.PluralRuleTwo {
		return locales.PluralRuleTwo
	} else if start == locales.PluralRuleOne && end == locales.PluralRuleFew {
		return locales.PluralRuleFew
	} else if start == locales.PluralRuleOne && end == locales.PluralRuleMany {
		return locales.PluralRuleMany
	} else if start == locales.PluralRuleOne && end == locales.PluralRuleOther {
		return locales.PluralRuleOther
	} else if start == locales.PluralRuleTwo && end == locales.PluralRuleFew {
		return locales.PluralRuleFew
	} else if start == locales.PluralRuleTwo && end == locales.PluralRuleMany {
		return locales.PluralRuleMany
	} else if start == locales.PluralRuleTwo && end == locales.PluralRuleOther {
		return locales.PluralRuleOther
	} else if start == locales.PluralRuleFew && end == locales.PluralRuleFew {
		return locales.PluralRuleFew
	} else if start == locales.PluralRuleFew && end == locales.PluralRuleMany {
		return locales.PluralRuleMany
	} else if start == locales.PluralRuleFew && end == locales.PluralRuleOther {
		return locales.PluralRuleOther
	} else if start == locales.PluralRuleMany && end == locales.PluralRuleMany {
		return locales.PluralRuleMany
	} else if start == locales.PluralRuleMany && end == locales.PluralRuleOther {
		return locales.PluralRuleOther
	} else if start == locales.PluralRuleOther && end == locales.PluralRuleOne {
		return locales.PluralRuleOne
	} else if start == locales.PluralRuleOther && end == locales.PluralRuleTwo {
		return locales.PluralRuleTwo
	} else if start == locales.PluralRuleOther && end == locales.PluralRuleFew {
		return locales.PluralRuleFew
	} else if start == locales.PluralRuleOther && end == locales.PluralRuleMany {
		return locales.PluralRuleMany
	}

	return locales.PluralRuleOther
}

var fnFmtCurrency_ad2ba7087d8f6e468ec280be01359ba1 = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 0 + 1*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				b = append(b, ln.group[0])
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	for j := len(symbol) - 1; j >= 0; j-- {
		b = append(b, symbol[j])
	}

	if num < 0 {
		b = append(b, ln.minus[0])
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	return string(b)
}

var fnFmtAccounting_20afe596297e5df40957d72da7798243 = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 2 + 1*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				b = append(b, ln.group[0])
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {

		for j := len(symbol) - 1; j >= 0; j-- {
			b = append(b, symbol[j])
		}

		b = append(b, ln.currencyNegativePrefix[0])

	} else {
		for j := len(symbol) - 1; j >= 0; j-- {
			b = append(b, symbol[j])
		}
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	if num < 0 {
		b = append(b, ln.currencyNegativeSuffix...)
	}

	return string(b)
}

var fnCardinalPluralRule_5232ad4c13ce5aa918e9c5bcfff748c4 = func(ln *localen, num float64, v uint64) locales.PluralRule {
	n := math.Abs(num)

	if n == 1 || n == 11 {
		return locales.PluralRuleOne
	} else if n == 2 || n == 12 {
		return locales.PluralRuleTwo
	} else if (n >= 3 && n <= 10) || (n >= 13 && n <= 19) {
		return locales.PluralRuleFew
	}

	return locales.PluralRuleOther
}

var fnOrdinalPluralRule_f828d7a9eaca874285f7573c8823d785 = func(ln *localen, num float64, v uint64) locales.PluralRule {
	n := math.Abs(num)

	if n == 1 || n == 11 {
		return locales.PluralRuleOne
	} else if n == 2 || n == 12 {
		return locales.PluralRuleTwo
	} else if n == 3 || n == 13 {
		return locales.PluralRuleFew
	}

	return locales.PluralRuleOther
}

var fnFmtDateLong_1b477f18b273c0ada89ad664b7a114af = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x6d, 0x68}...)
	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtDateFull_127dcd8df9ddb869d241194c5acabeea = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = append(b, ln.daysWide[t.Weekday()]...)
	b = append(b, []byte{0x2c, 0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x6d, 0x68}...)
	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtDateMedium_1bc79335f4a6998f27c6e8a29a9b778e = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x20, 0x64, 0x65}...)
	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsAbbreviated[t.Month()]...)
	b = append(b, []byte{0x20, 0x64, 0x65}...)
	b = append(b, []byte{0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtNumber_0a6b715b13c31edcb79152f44bd8401c = func(ln *localen, num float64, v uint64) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	l := len(s) + 4 + 3*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				for j := len(ln.group) - 1; j >= 0; j-- {
					b = append(b, ln.group[j])
				}
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {
		for j := len(ln.minus) - 1; j >= 0; j-- {
			b = append(b, ln.minus[j])
		}
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	return string(b)
}

var fnFmtCurrency_a81f72a39548e95f8f6af89799fb3204 = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 6 + 3*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				for j := len(ln.group) - 1; j >= 0; j-- {
					b = append(b, ln.group[j])
				}
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {
		for j := len(ln.minus) - 1; j >= 0; j-- {
			b = append(b, ln.minus[j])
		}
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	b = append(b, ln.currencyPositiveSuffix...)

	b = append(b, symbol...)

	return string(b)
}

var fnFmtAccounting_54cd50d7a0db8f91c56e54eeea38fa74 = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 6 + 3*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				for j := len(ln.group) - 1; j >= 0; j-- {
					b = append(b, ln.group[j])
				}
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {
		for j := len(ln.minus) - 1; j >= 0; j-- {
			b = append(b, ln.minus[j])
		}
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	if num < 0 {
		b = append(b, ln.currencyNegativeSuffix...)
		b = append(b, symbol...)
	} else {

		b = append(b, ln.currencyPositiveSuffix...)
		b = append(b, symbol...)
	}

	return string(b)
}

var fnOrdinalPluralRule_a9f120c4a8c40112dec183cd65a8b424 = func(ln *localen, num float64, v uint64) locales.PluralRule {
	n := math.Abs(num)

	if n == 1 {
		return locales.PluralRuleOne
	} else if n == 2 || n == 3 {
		return locales.PluralRuleTwo
	} else if n == 4 {
		return locales.PluralRuleFew
	} else if n == 6 {
		return locales.PluralRuleMany
	}

	return locales.PluralRuleOther
}

var fnFmtTimeShort_11febbd269414b302ab4045dd63f47b7 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	h := t.Hour()

	if h > 12 {
		h -= 12
	}

	if h < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(h), 10)
	b = append(b, ln.timeSeparator...)

	if t.Minute() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Minute()), 10)
	b = append(b, []byte{0x20}...)

	if t.Hour() < 12 {
		b = append(b, ln.periodsAbbreviated[0]...)
	} else {
		b = append(b, ln.periodsAbbreviated[1]...)
	}

	return string(b)
}

var fnFmtTimeMedium_9efd56b286449b21c42b6b2ea8c1f34c = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	h := t.Hour()

	if h > 12 {
		h -= 12
	}

	if h < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(h), 10)
	b = append(b, ln.timeSeparator...)

	if t.Minute() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Minute()), 10)
	b = append(b, ln.timeSeparator...)

	if t.Second() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Second()), 10)
	b = append(b, []byte{0x20}...)

	if t.Hour() < 12 {
		b = append(b, ln.periodsAbbreviated[0]...)
	} else {
		b = append(b, ln.periodsAbbreviated[1]...)
	}

	return string(b)
}

var fnFmtTimeLong_28302cc672efd8ad015891c59efdc448 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	h := t.Hour()

	if h > 12 {
		h -= 12
	}

	if h < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(h), 10)
	b = append(b, ln.timeSeparator...)

	if t.Minute() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Minute()), 10)
	b = append(b, ln.timeSeparator...)

	if t.Second() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Second()), 10)
	b = append(b, []byte{0x20}...)

	if t.Hour() < 12 {
		b = append(b, ln.periodsAbbreviated[0]...)
	} else {
		b = append(b, ln.periodsAbbreviated[1]...)
	}

	b = append(b, []byte{0x20}...)

	tz, _ := t.Zone()
	b = append(b, tz...)

	return string(b)
}

var fnFmtTimeFull_abd60cef530beeba744de08bba2ad540 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	h := t.Hour()

	if h > 12 {
		h -= 12
	}

	if h < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(h), 10)
	b = append(b, ln.timeSeparator...)

	if t.Minute() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Minute()), 10)
	b = append(b, ln.timeSeparator...)

	if t.Second() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Second()), 10)
	b = append(b, []byte{0x20}...)

	if t.Hour() < 12 {
		b = append(b, ln.periodsAbbreviated[0]...)
	} else {
		b = append(b, ln.periodsAbbreviated[1]...)
	}

	b = append(b, []byte{0x20}...)

	tz, _ := t.Zone()

	if btz, ok := ln.timezones[tz]; ok {
		b = append(b, btz...)
	} else {
		b = append(b, tz...)
	}

	return string(b)
}

var fnCardinalPluralRule_e63270f01497e6cdf2ee8385ca8e8db3 = func(ln *localen, num float64, v uint64) locales.PluralRule {
	n := math.Abs(num)
	i := int64(n)
	iMod10 := i % 10
	iMod100 := i % 100

	if v == 0 && iMod10 == 1 {
		return locales.PluralRuleOne
	} else if v == 0 && iMod10 == 2 {
		return locales.PluralRuleTwo
	} else if v == 0 && (iMod100 == 0 || iMod100 == 20 || iMod100 == 40 || iMod100 == 60 || iMod100 == 80) {
		return locales.PluralRuleFew
	} else if v != 0 {
		return locales.PluralRuleMany
	}

	return locales.PluralRuleOther
}

var fnFmtDateMedium_d8430d5f441fe322a704e04df73f1229 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = append(b, ln.monthsAbbreviated[t.Month()]...)
	b = append(b, []byte{0x20}...)

	if t.Day() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2c, 0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtCurrency_10729cc1c61d4b51865a5b0ad149a301 = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 3

	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			continue
		}

		b = append(b, s[i])
	}

	for j := len(symbol) - 1; j >= 0; j-- {
		b = append(b, symbol[j])
	}

	for j := len(ln.currencyPositivePrefix) - 1; j >= 0; j-- {
		b = append(b, ln.currencyPositivePrefix[j])
	}

	if num < 0 {
		b = append(b, ln.minus[0])
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	b = append(b, ln.currencyPositiveSuffix...)

	return string(b)
}

var fnFmtAccounting_997e5abdc6c3d9acf1269cf6ebc154e1 = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 3

	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			continue
		}

		b = append(b, s[i])
	}

	if num < 0 {

		for j := len(symbol) - 1; j >= 0; j-- {
			b = append(b, symbol[j])
		}

		for j := len(ln.currencyNegativePrefix) - 1; j >= 0; j-- {
			b = append(b, ln.currencyNegativePrefix[j])
		}

		b = append(b, ln.minus[0])

	} else {

		for j := len(symbol) - 1; j >= 0; j-- {
			b = append(b, symbol[j])
		}

		for j := len(ln.currencyPositivePrefix) - 1; j >= 0; j-- {
			b = append(b, ln.currencyPositivePrefix[j])
		}

	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if num < 0 {
		b = append(b, ln.currencyNegativeSuffix...)
	} else {
		b = append(b, ln.currencyPositiveSuffix...)
	}

	return string(b)
}

var fnFmtDateFull_4f1a5e5b794a77b5b18293f768464f0a = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = append(b, ln.daysWide[t.Weekday()]...)
	b = append(b, []byte{0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x2c, 0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnCardinalPluralRule_cf4ba4e3714ec1726c70da66a7b66698 = func(ln *localen, num float64, v uint64) locales.PluralRule {
	n := math.Abs(num)
	i := int64(n)
	nMod10 := math.Mod(n, 10)

	if i == 1 && v == 0 {
		return locales.PluralRuleOne
	} else if i == 2 && v == 0 {
		return locales.PluralRuleTwo
	} else if v == 0 && (n < 0 || n > 10) && nMod10 == 0 {
		return locales.PluralRuleMany
	}

	return locales.PluralRuleOther
}

var fnRangePluralRule_11b8a4f474d210e1d71b265f1f8e62d0 = func(ln *localen, num1 float64, v1 uint64, num2 float64, v2 uint64) locales.PluralRule {
	start := ln.CardinalPluralRule(num1, v1)
	end := ln.CardinalPluralRule(num2, v2)

	if start == locales.PluralRuleOne && end == locales.PluralRuleTwo {
		return locales.PluralRuleOther
	} else if start == locales.PluralRuleOne && end == locales.PluralRuleMany {
		return locales.PluralRuleMany
	} else if start == locales.PluralRuleOne && end == locales.PluralRuleOther {
		return locales.PluralRuleOther
	} else if start == locales.PluralRuleTwo && end == locales.PluralRuleMany {
		return locales.PluralRuleOther
	} else if start == locales.PluralRuleTwo && end == locales.PluralRuleOther {
		return locales.PluralRuleOther
	} else if start == locales.PluralRuleMany && end == locales.PluralRuleMany {
		return locales.PluralRuleMany
	} else if start == locales.PluralRuleMany && end == locales.PluralRuleOther {
		return locales.PluralRuleMany
	} else if start == locales.PluralRuleOther && end == locales.PluralRuleOne {
		return locales.PluralRuleOther
	} else if start == locales.PluralRuleOther && end == locales.PluralRuleTwo {
		return locales.PluralRuleOther
	} else if start == locales.PluralRuleOther && end == locales.PluralRuleMany {
		return locales.PluralRuleMany
	}

	return locales.PluralRuleOther
}

var fnFmtNumber_8a34c21e88caccc3a8728bf464f33cbd = func(ln *localen, num float64, v uint64) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	l := len(s) + 5 + 1*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				b = append(b, ln.group[0])
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {
		for j := len(ln.minus) - 1; j >= 0; j-- {
			b = append(b, ln.minus[j])
		}
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	return string(b)
}

var fnFmtPercent_d2f2a59417e049449b3bb6986a239e7b = func(ln *localen, num float64, v uint64) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	l := len(s) + 6
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			continue
		}

		b = append(b, s[i])
	}

	if num < 0 {
		for j := len(ln.minus) - 1; j >= 0; j-- {
			b = append(b, ln.minus[j])
		}
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	b = append(b, ln.percent...)

	return string(b)
}

var fnFmtCurrency_dcd95366ecd0baffaf3fa998dfd8ecbc = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 7 + 1*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				b = append(b, ln.group[0])
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {
		for j := len(ln.minus) - 1; j >= 0; j-- {
			b = append(b, ln.minus[j])
		}
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	b = append(b, ln.currencyPositiveSuffix...)

	b = append(b, symbol...)

	return string(b)
}

var fnFmtAccounting_ac8c216759a27ae9294265517cfd4549 = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 7 + 1*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				b = append(b, ln.group[0])
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {
		for j := len(ln.minus) - 1; j >= 0; j-- {
			b = append(b, ln.minus[j])
		}
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	if num < 0 {
		b = append(b, ln.currencyNegativeSuffix...)
		b = append(b, symbol...)
	} else {

		b = append(b, ln.currencyPositiveSuffix...)
		b = append(b, symbol...)
	}

	return string(b)
}

var fnFmtDateMedium_2a623cab0baa2e039b73232b6b2d515a = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x20, 0xd7, 0x91}...)
	b = append(b, ln.monthsAbbreviated[t.Month()]...)
	b = append(b, []byte{0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtDateLong_e3113833817389f6b233e285c24e687d = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x20, 0xd7, 0x91}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtDateFull_61caddbcb5db4de051fdc4ba779a33da = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = append(b, ln.daysWide[t.Weekday()]...)
	b = append(b, []byte{0x2c, 0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x20, 0xd7, 0x91}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtDateShort_682acc4ae60b52f9983d14c85913c784 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Day() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2e, 0x20}...)

	if t.Month() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Month()), 10)

	b = append(b, []byte{0x2e, 0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0x2e}...)

	return string(b)
}

var fnFmtDateShort_474bf8d71d0392f03d943b2085e8e536 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2e, 0x20}...)
	b = strconv.AppendInt(b, int64(t.Month()), 10)
	b = append(b, []byte{0x2e, 0x20}...)

	if t.Year() > 9 {
		b = append(b, strconv.Itoa(t.Year())[2:]...)
	} else {
		b = append(b, strconv.Itoa(t.Year())[1:]...)
	}

	b = append(b, []byte{0x2e}...)

	return string(b)
}

var fnFmtTimeShort_5d630ed3a6aab7e460d3797e87a803d8 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Hour()), 10)
	b = append(b, ln.timeSeparator...)

	if t.Minute() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Minute()), 10)
	b = append(b, []byte{0x20, 0x68, 0x6f, 0x64, 0xc5, 0xba}...)
	b = append(b, []byte{0x2e}...)

	return string(b)
}

var fnOrdinalPluralRule_ddb6ad1d52dc3051d9aca40302fc33cb = func(ln *localen, num float64, v uint64) locales.PluralRule {
	n := math.Abs(num)

	if n == 1 || n == 5 {
		return locales.PluralRuleOne
	}

	return locales.PluralRuleOther
}

var fnFmtDateShort_6955160c4014108c44f154550c94bf4a = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0x2e, 0x20}...)

	if t.Month() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Month()), 10)

	b = append(b, []byte{0x2e, 0x20}...)

	if t.Day() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2e}...)

	return string(b)
}

var fnFmtDateMedium_7234e1a0f15c9c77f42b9ce48acda9a9 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0x2e, 0x20}...)
	b = append(b, ln.monthsAbbreviated[t.Month()]...)
	b = append(b, []byte{0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2e}...)

	return string(b)
}

var fnFmtDateLong_d54b619c689771a59ca2c2bc98c286ad = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0x2e, 0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2e}...)

	return string(b)
}

var fnFmtDateFull_96142c8f0234c0bee88b2aec42a20ee0 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0x2e, 0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2e, 0x2c, 0x20}...)
	b = append(b, ln.daysWide[t.Weekday()]...)

	return string(b)
}

var fnFmtDateMedium_227513acca176d2921237a4d2e01beae = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Day() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsAbbreviated[t.Month()]...)
	b = append(b, []byte{0x2c, 0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0x20, 0xd5, 0xa9, 0x2e}...)

	return string(b)
}

var fnFmtDateLong_569998488d00a7529115ca67accb195e = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Day() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x2c, 0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0x20, 0xd5, 0xa9, 0x2e}...)

	return string(b)
}

var fnFmtDateFull_f88f4a85fdaf35c0c7b8106f2f509933 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0x20, 0xd5, 0xa9, 0x2e, 0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2c, 0x20}...)
	b = append(b, ln.daysWide[t.Weekday()]...)

	return string(b)
}

var fnFmtDateShort_6e3914bf40627aa17064661ef056b7d6 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Day() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2d}...)

	if t.Month() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Month()), 10)

	b = append(b, []byte{0x2d}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtDateLong_cef970679517ca70c9c659b02d9823d9 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x20, 0x64, 0x65}...)
	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtDateFull_5a51da803052c6679cb1ae79edfb44b5 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = append(b, ln.daysWide[t.Weekday()]...)
	b = append(b, []byte{0x20, 0x6c, 0x65}...)
	b = append(b, []byte{0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x20, 0x64, 0x65}...)
	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtPercent_867dc730c8139deaf3b7a764768ab63b = func(ln *localen, num float64, v uint64) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	l := len(s) + 13
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			for j := len(ln.decimal) - 1; j >= 0; j-- {
				b = append(b, ln.decimal[j])
			}
			continue
		}

		b = append(b, s[i])
	}

	if num < 0 {
		for j := len(ln.minus) - 1; j >= 0; j-- {
			b = append(b, ln.minus[j])
		}
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	b = append(b, ln.percentSuffix...)

	b = append(b, ln.percent...)

	return string(b)
}

var fnFmtCurrency_190e2886d7df91874dc7265208b76611 = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 6 + 2*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			for j := len(ln.decimal) - 1; j >= 0; j-- {
				b = append(b, ln.decimal[j])
			}
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				for j := len(ln.group) - 1; j >= 0; j-- {
					b = append(b, ln.group[j])
				}
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	for j := len(symbol) - 1; j >= 0; j-- {
		b = append(b, symbol[j])
	}

	if num < 0 {
		for j := len(ln.minus) - 1; j >= 0; j-- {
			b = append(b, ln.minus[j])
		}
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	return string(b)
}

var fnFmtAccounting_1284b8838aa00e9c05dfab59723d425b = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 6 + 2*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			for j := len(ln.decimal) - 1; j >= 0; j-- {
				b = append(b, ln.decimal[j])
			}
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				for j := len(ln.group) - 1; j >= 0; j-- {
					b = append(b, ln.group[j])
				}
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {

		for j := len(symbol) - 1; j >= 0; j-- {
			b = append(b, symbol[j])
		}

		for j := len(ln.minus) - 1; j >= 0; j-- {
			b = append(b, ln.minus[j])
		}

	} else {
		for j := len(symbol) - 1; j >= 0; j-- {
			b = append(b, symbol[j])
		}
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	return string(b)
}

var fnCardinalPluralRule_aee42f293f8724ca3ca1ad3bf1a57537 = func(ln *localen, num float64, v uint64) locales.PluralRule {
	n := math.Abs(num)
	i := int64(n)
	t := locales.T(n, v)
	iMod100 := i % 100
	iMod10 := i % 10

	if (t == 0 && iMod10 == 1 && iMod100 != 11) || (t != 0) {
		return locales.PluralRuleOne
	}

	return locales.PluralRuleOther
}

var fnCardinalPluralRule_e217c4f51dda8c076116bf492a837691 = func(ln *localen, num float64, v uint64) locales.PluralRule {
	n := math.Abs(num)
	i := int64(n)
	t := locales.T(n, v)
	iMod10 := i % 10
	iMod100 := i % 100

	if (t == 0 && iMod10 == 1 && iMod100 != 11) || (t != 0) {
		return locales.PluralRuleOne
	}

	return locales.PluralRuleOther
}

var fnOrdinalPluralRule_b8b63d0d886b70a436900cf618138a9f = func(ln *localen, num float64, v uint64) locales.PluralRule {
	n := math.Abs(num)

	if n == 11 || n == 8 || n == 80 || n == 800 {
		return locales.PluralRuleMany
	}

	return locales.PluralRuleOther
}

var fnFmtDateMedium_30a6b80fc168a8b0808040051491fc26 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0x2f}...)

	if t.Month() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Month()), 10)

	b = append(b, []byte{0x2f}...)

	if t.Day() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Day()), 10)

	return string(b)
}

var fnFmtDateLong_ac97917fe1928d8ea60357f5e7024872 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0xe5, 0xb9, 0xb4}...)
	b = strconv.AppendInt(b, int64(t.Month()), 10)
	b = append(b, []byte{0xe6, 0x9c, 0x88}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0xe6, 0x97, 0xa5}...)

	return string(b)
}

var fnFmtDateFull_6b9d7416ea4bfdc5f1566cfcd686ec9d = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0xe5, 0xb9, 0xb4}...)
	b = strconv.AppendInt(b, int64(t.Month()), 10)
	b = append(b, []byte{0xe6, 0x9c, 0x88}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0xe6, 0x97, 0xa5}...)
	b = append(b, ln.daysWide[t.Weekday()]...)

	return string(b)
}

var fnFmtTimeFull_5f445481e576332f9f6276f28f4cc61a = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Hour()), 10)
	b = append(b, []byte{0xe6, 0x99, 0x82}...)

	if t.Minute() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Minute()), 10)
	b = append(b, []byte{0xe5, 0x88, 0x86}...)

	if t.Second() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Second()), 10)
	b = append(b, []byte{0xe7, 0xa7, 0x92, 0x20}...)

	tz, _ := t.Zone()

	if btz, ok := ln.timezones[tz]; ok {
		b = append(b, btz...)
	} else {
		b = append(b, tz...)
	}

	return string(b)
}

var fnOrdinalPluralRule_d9d734a5db809617a5116023efed1940 = func(ln *localen, num float64, v uint64) locales.PluralRule {
	n := math.Abs(num)
	i := int64(n)
	iMod100 := i % 100

	if i == 1 {
		return locales.PluralRuleOne
	} else if (i == 0) || (iMod100 >= 2 && iMod100 <= 20 && (iMod100 == 40 || iMod100 == 60 || iMod100 == 80)) {
		return locales.PluralRuleMany
	}

	return locales.PluralRuleOther
}

var fnRangePluralRule_e975bcc2318a5d1ed3b85b6356649a29 = func(ln *localen, num1 float64, v1 uint64, num2 float64, v2 uint64) locales.PluralRule {
	start := ln.CardinalPluralRule(num1, v1)
	end := ln.CardinalPluralRule(num2, v2)

	if start == locales.PluralRuleOne && end == locales.PluralRuleOther {
		return locales.PluralRuleOne
	} else if start == locales.PluralRuleOther && end == locales.PluralRuleOne {
		return locales.PluralRuleOther
	}

	return locales.PluralRuleOther
}

var fnFmtDateMedium_8f50deadc7a225aae72abf7135535a4e = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsAbbreviated[t.Month()]...)
	b = append(b, []byte{0x2e, 0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtDateFull_4edbf4e11f17243cbd3f53cf42390fdf = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = append(b, ln.daysWide[t.Weekday()]...)
	b = append(b, []byte{0x2c, 0x20}...)

	if t.Day() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x2c, 0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtCurrency_adf14415bc63ac7fa5223315bd231add = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 2 + 2*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				for j := len(ln.group) - 1; j >= 0; j-- {
					b = append(b, ln.group[j])
				}
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {
		b = append(b, ln.minus[0])
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	b = append(b, symbol...)

	return string(b)
}

var fnFmtAccounting_a352e45549d51689f730b62d4fd819bf = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 2 + 2*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				for j := len(ln.group) - 1; j >= 0; j-- {
					b = append(b, ln.group[j])
				}
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {
		b = append(b, ln.minus[0])
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	if num < 0 {
		b = append(b, symbol...)
	} else {
		b = append(b, symbol...)
	}

	return string(b)
}

var fnFmtAccounting_368d18aec5667a40e744175ddb192235 = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 6 + 2*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				for j := len(ln.group) - 1; j >= 0; j-- {
					b = append(b, ln.group[j])
				}
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {
		b = append(b, ln.currencyNegativePrefix[0])
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	if num < 0 {
		b = append(b, ln.currencyNegativeSuffix...)
		b = append(b, symbol...)
	} else {

		b = append(b, ln.currencyPositiveSuffix...)
		b = append(b, symbol...)
	}

	return string(b)
}

var fnFmtDateLong_56933fd536cdccf5e7a0f57849436ee6 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x20, 0x64, 0x69}...)
	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x20, 0x64, 0x69}...)
	b = append(b, []byte{0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtDateFull_6df4b160cd1730b200782b7d4e4cd069 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = append(b, ln.daysWide[t.Weekday()]...)
	b = append(b, []byte{0x2c, 0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x20, 0x64, 0x69}...)
	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x20, 0x64, 0x69}...)
	b = append(b, []byte{0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtCurrency_f27eb78b129904a4d98d49f647da3164 = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 0 + 2*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				for j := len(ln.group) - 1; j >= 0; j-- {
					b = append(b, ln.group[j])
				}
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {
		b = append(b, ln.minus[0])
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	b = append(b, symbol...)

	return string(b)
}

var fnFmtAccounting_dd5c984fc6201988feed2698382f9150 = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 0 + 2*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				for j := len(ln.group) - 1; j >= 0; j-- {
					b = append(b, ln.group[j])
				}
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {
		b = append(b, ln.minus[0])
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	if num < 0 {
		b = append(b, symbol...)
	} else {
		b = append(b, symbol...)
	}

	return string(b)
}

var fnOrdinalPluralRule_b14713cd1b1f920531a88cd35823e9c6 = func(ln *localen, num float64, v uint64) locales.PluralRule {
	n := math.Abs(num)
	nMod10 := math.Mod(n, 10)

	if (nMod10 == 6) || (nMod10 == 9) || (nMod10 == 0 && n != 0) {
		return locales.PluralRuleMany
	}

	return locales.PluralRuleOther
}

var fnFmtDateMedium_615c694e243fa2fa6c571f5fc2c9d718 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0x20, 0xd0, 0xb6}...)
	b = append(b, []byte{0x2e, 0x20}...)

	if t.Day() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsAbbreviated[t.Month()]...)

	return string(b)
}

var fnFmtDateLong_c224d2682917532885a5e8179ac7c5c2 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0x20, 0xd0, 0xb6}...)
	b = append(b, []byte{0x2e, 0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)

	return string(b)
}

var fnFmtDateFull_4d0973d19d04f6373346e3410c0d7cff = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0x20, 0xd0, 0xb6}...)
	b = append(b, []byte{0x2e, 0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x2c, 0x20}...)
	b = append(b, ln.daysWide[t.Weekday()]...)

	return string(b)
}

var fnFmtCurrency_1c327a5182399c63873a891da808a068 = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 4

	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			continue
		}

		b = append(b, s[i])
	}

	for j := len(symbol) - 1; j >= 0; j-- {
		b = append(b, symbol[j])
	}

	for j := len(ln.currencyPositivePrefix) - 1; j >= 0; j-- {
		b = append(b, ln.currencyPositivePrefix[j])
	}

	if num < 0 {
		b = append(b, ln.minus[0])
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	b = append(b, ln.currencyPositiveSuffix...)

	return string(b)
}

var fnFmtAccounting_25be2d04484c3c25e10aab41bfa66a06 = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 4

	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			continue
		}

		b = append(b, s[i])
	}

	if num < 0 {

		for j := len(symbol) - 1; j >= 0; j-- {
			b = append(b, symbol[j])
		}

		for j := len(ln.currencyNegativePrefix) - 1; j >= 0; j-- {
			b = append(b, ln.currencyNegativePrefix[j])
		}

		b = append(b, ln.minus[0])

	} else {

		for j := len(symbol) - 1; j >= 0; j-- {
			b = append(b, symbol[j])
		}

		for j := len(ln.currencyPositivePrefix) - 1; j >= 0; j-- {
			b = append(b, ln.currencyPositivePrefix[j])
		}

	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if num < 0 {
		b = append(b, ln.currencyNegativeSuffix...)
	} else {
		b = append(b, ln.currencyPositiveSuffix...)
	}

	return string(b)
}

var fnFmtDateShort_d82f27051c9ad611e3ef0bbd19df221b = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Day() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2f}...)

	if t.Month() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Month()), 10)

	b = append(b, []byte{0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtCurrency_311268549b3ecbf935e9311c16ee9a54 = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 4 + 1*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				b = append(b, ln.group[0])
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	for j := len(symbol) - 1; j >= 0; j-- {
		b = append(b, symbol[j])
	}

	if num < 0 {
		for j := len(ln.minus) - 1; j >= 0; j-- {
			b = append(b, ln.minus[j])
		}
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	return string(b)
}

var fnFmtAccounting_2ebcd49fb93d5f5e0574b122053067c2 = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 4 + 1*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				b = append(b, ln.group[0])
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {

		for j := len(symbol) - 1; j >= 0; j-- {
			b = append(b, symbol[j])
		}

		for j := len(ln.minus) - 1; j >= 0; j-- {
			b = append(b, ln.minus[j])
		}

	} else {
		for j := len(symbol) - 1; j >= 0; j-- {
			b = append(b, symbol[j])
		}
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	return string(b)
}

var fnFmtCurrency_ef0590f3c464dc40ad41a959adae57e7 = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 2 + 1*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				b = append(b, ln.group[0])
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {
		b = append(b, ln.minus[0])
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	b = append(b, symbol...)

	return string(b)
}

var fnFmtAccounting_0722fc77da098723d3a7bcc9b8145055 = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 4 + 1*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				b = append(b, ln.group[0])
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {
		b = append(b, ln.currencyNegativePrefix[0])
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	if num < 0 {
		b = append(b, ln.currencyNegativeSuffix...)
		b = append(b, symbol...)
	} else {
		b = append(b, symbol...)
	}

	return string(b)
}

var fnFmtDateShort_d881b9f1f4fd8f22e57a48f28a75e30a = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Year() > 9 {
		b = append(b, strconv.Itoa(t.Year())[2:]...)
	} else {
		b = append(b, strconv.Itoa(t.Year())[1:]...)
	}

	b = append(b, []byte{0x2e, 0x20}...)
	b = strconv.AppendInt(b, int64(t.Month()), 10)
	b = append(b, []byte{0x2e, 0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2e}...)

	return string(b)
}

var fnFmtDateMedium_f69e9157403c463ade0395f3ff9240fe = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0x2e, 0x20}...)
	b = strconv.AppendInt(b, int64(t.Month()), 10)
	b = append(b, []byte{0x2e, 0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2e}...)

	return string(b)
}

var fnFmtDateLong_17c2343e73783fd11c1ad64b6b231979 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0xeb, 0x85, 0x84, 0x20}...)
	b = strconv.AppendInt(b, int64(t.Month()), 10)
	b = append(b, []byte{0xec, 0x9b, 0x94, 0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0xec, 0x9d, 0xbc}...)

	return string(b)
}

var fnFmtDateFull_c611a5e966ec03dbdacdf654df3799f0 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0xeb, 0x85, 0x84, 0x20}...)
	b = strconv.AppendInt(b, int64(t.Month()), 10)
	b = append(b, []byte{0xec, 0x9b, 0x94, 0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0xec, 0x9d, 0xbc, 0x20}...)
	b = append(b, ln.daysWide[t.Weekday()]...)

	return string(b)
}

var fnFmtTimeShort_c7eeb539163b08e3ba7211630cad2b4b = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Hour() < 12 {
		b = append(b, ln.periodsAbbreviated[0]...)
	} else {
		b = append(b, ln.periodsAbbreviated[1]...)
	}

	b = append(b, []byte{0x20}...)

	h := t.Hour()

	if h > 12 {
		h -= 12
	}

	b = strconv.AppendInt(b, int64(h), 10)
	b = append(b, ln.timeSeparator...)

	if t.Minute() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Minute()), 10)

	return string(b)
}

var fnFmtTimeMedium_2116a9d777445f659bcbbe24b3c994ee = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Hour() < 12 {
		b = append(b, ln.periodsAbbreviated[0]...)
	} else {
		b = append(b, ln.periodsAbbreviated[1]...)
	}

	b = append(b, []byte{0x20}...)

	h := t.Hour()

	if h > 12 {
		h -= 12
	}

	b = strconv.AppendInt(b, int64(h), 10)
	b = append(b, ln.timeSeparator...)

	if t.Minute() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Minute()), 10)
	b = append(b, ln.timeSeparator...)

	if t.Second() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Second()), 10)

	return string(b)
}

var fnFmtTimeLong_a4e3f96b4a6b77d07b6c318bbc1c74ac = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Hour() < 12 {
		b = append(b, ln.periodsAbbreviated[0]...)
	} else {
		b = append(b, ln.periodsAbbreviated[1]...)
	}

	b = append(b, []byte{0x20}...)

	h := t.Hour()

	if h > 12 {
		h -= 12
	}

	b = strconv.AppendInt(b, int64(h), 10)
	b = append(b, []byte{0xec, 0x8b, 0x9c, 0x20}...)
	b = strconv.AppendInt(b, int64(t.Minute()), 10)
	b = append(b, []byte{0xeb, 0xb6, 0x84, 0x20}...)
	b = strconv.AppendInt(b, int64(t.Second()), 10)
	b = append(b, []byte{0xec, 0xb4, 0x88, 0x20}...)

	tz, _ := t.Zone()
	b = append(b, tz...)

	return string(b)
}

var fnFmtTimeFull_bfbb513b6692ade43eb8d3cf5179818c = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Hour() < 12 {
		b = append(b, ln.periodsAbbreviated[0]...)
	} else {
		b = append(b, ln.periodsAbbreviated[1]...)
	}

	b = append(b, []byte{0x20}...)

	h := t.Hour()

	if h > 12 {
		h -= 12
	}

	b = strconv.AppendInt(b, int64(h), 10)
	b = append(b, []byte{0xec, 0x8b, 0x9c, 0x20}...)
	b = strconv.AppendInt(b, int64(t.Minute()), 10)
	b = append(b, []byte{0xeb, 0xb6, 0x84, 0x20}...)
	b = strconv.AppendInt(b, int64(t.Second()), 10)
	b = append(b, []byte{0xec, 0xb4, 0x88, 0x20}...)

	tz, _ := t.Zone()

	if btz, ok := ln.timezones[tz]; ok {
		b = append(b, btz...)
	} else {
		b = append(b, tz...)
	}

	return string(b)
}

var fnFmtDateShort_20b00d66ebb3cefd65ec76fba139eaf9 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2d}...)
	b = strconv.AppendInt(b, int64(t.Month()), 10)
	b = append(b, []byte{0x2d}...)

	if t.Year() > 9 {
		b = append(b, strconv.Itoa(t.Year())[2:]...)
	} else {
		b = append(b, strconv.Itoa(t.Year())[1:]...)
	}

	return string(b)
}

var fnFmtNumber_b796bfb92dd260d7d0890a75e953e03c = func(ln *localen, num float64, v uint64) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	l := len(s) + 0
	count := 0
	inWhole := v == 0
	inSecondary := false
	groupThreshold := 3

	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == groupThreshold {
				b = append(b, ln.group[0])
				count = 1

				if !inSecondary {
					inSecondary = true
					groupThreshold = 2
				}
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {
		b = append(b, ln.minus[0])
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	return string(b)
}

var fnFmtPercent_aa714d39dff020dd613d3cb5622ff940 = func(ln *localen, num float64, v uint64) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	l := len(s) + 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			continue
		}

		b = append(b, s[i])
	}

	if num < 0 {
		b = append(b, ln.minus[0])
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	b = append(b, ln.percent...)

	return string(b)
}

var fnFmtCurrency_b96d5354a212ba0fb9e6fdc6738a84f8 = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 2
	count := 0
	inWhole := v == 0
	inSecondary := false
	groupThreshold := 3

	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == groupThreshold {
				b = append(b, ln.group[0])
				count = 1

				if !inSecondary {
					inSecondary = true
					groupThreshold = 2
				}
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	for j := len(symbol) - 1; j >= 0; j-- {
		b = append(b, symbol[j])
	}

	for j := len(ln.currencyPositivePrefix) - 1; j >= 0; j-- {
		b = append(b, ln.currencyPositivePrefix[j])
	}

	if num < 0 {
		b = append(b, ln.minus[0])
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	return string(b)
}

var fnFmtAccounting_d34cde82a90714ae7e620d04971d2faf = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 2
	count := 0
	inWhole := v == 0
	inSecondary := false
	groupThreshold := 3

	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == groupThreshold {
				b = append(b, ln.group[0])
				count = 1

				if !inSecondary {
					inSecondary = true
					groupThreshold = 2
				}
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {

		for j := len(symbol) - 1; j >= 0; j-- {
			b = append(b, symbol[j])
		}

		for j := len(ln.currencyNegativePrefix) - 1; j >= 0; j-- {
			b = append(b, ln.currencyNegativePrefix[j])
		}

		b = append(b, ln.minus[0])

	} else {

		for j := len(symbol) - 1; j >= 0; j-- {
			b = append(b, symbol[j])
		}

		for j := len(ln.currencyPositivePrefix) - 1; j >= 0; j-- {
			b = append(b, ln.currencyPositivePrefix[j])
		}

	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	return string(b)
}

var fnCardinalPluralRule_fed1c76cd90b8905708121045ba1b87c = func(ln *localen, num float64, v uint64) locales.PluralRule {
	n := math.Abs(num)

	if n == 0 {
		return locales.PluralRuleZero
	} else if n == 1 {
		return locales.PluralRuleOne
	}

	return locales.PluralRuleOther
}

var fnFmtDateShort_7666e72292ce611269924033db7087d6 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2e, 0x20}...)
	b = strconv.AppendInt(b, int64(t.Month()), 10)
	b = append(b, []byte{0x2e, 0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtDateMedium_e96355a5ea41d1e8a56ddce8cbb58393 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2e, 0x20}...)
	b = append(b, ln.monthsAbbreviated[t.Month()]...)
	b = append(b, []byte{0x2e, 0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtDateFull_694de915ae18d4ba6d1ade6e9c08daac = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = append(b, ln.daysWide[t.Weekday()]...)
	b = append(b, []byte{0x2c, 0x20, 0x64, 0xc3, 0xa4}...)
	b = append(b, []byte{0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2e, 0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtPercent_1842fa1c80e067ee20bb9d4acb93d0eb = func(ln *localen, num float64, v uint64) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	l := len(s) + 3 + 1*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true

			continue
		}

		if inWhole {
			if count == 3 {
				b = append(b, ln.group[0])
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {
		b = append(b, ln.minus[0])
	}

	b = append(b, ln.percent[0])

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	return string(b)
}

var fnCardinalPluralRule_d9471d7d7c171fa2f8441e898fb73597 = func(ln *localen, num float64, v uint64) locales.PluralRule {
	n := math.Abs(num)
	nMod100 := math.Mod(n, 100)
	nMod1000 := math.Mod(n, 1000)
	nMod100000 := math.Mod(n, 100000)
	nMod1000000 := math.Mod(n, 1000000)

	if n == 0 {
		return locales.PluralRuleZero
	} else if n == 1 {
		return locales.PluralRuleOne
	} else if (nMod100 == 2 || nMod100 == 22 || nMod100 == 42 || nMod100 == 62 || nMod100 == 82) || (nMod1000 == 0 && nMod100000 >= 1000 && nMod100000 <= 20000 && (nMod100000 == 40000 || nMod100000 == 60000 || nMod100000 == 80000)) || (n != 0 && nMod1000000 == 100000) {
		return locales.PluralRuleTwo
	} else if nMod100 == 3 || nMod100 == 23 || nMod100 == 43 || nMod100 == 63 || nMod100 == 83 {
		return locales.PluralRuleFew
	} else if n != 1 && (nMod100 == 1 || nMod100 == 21 || nMod100 == 41 || nMod100 == 61 || nMod100 == 81) {
		return locales.PluralRuleMany
	}

	return locales.PluralRuleOther
}

var fnOrdinalPluralRule_80a3a34cd3bb2c41e809f9ce9e28ce2a = func(ln *localen, num float64, v uint64) locales.PluralRule {
	n := math.Abs(num)
	nMod100 := math.Mod(n, 100)

	if (n >= 1 && n <= 4) || ((nMod100 >= 1 && nMod100 <= 4) || (nMod100 >= 21 && nMod100 <= 24) || (nMod100 >= 41 && nMod100 <= 44) || (nMod100 >= 61 && nMod100 <= 64) || (nMod100 >= 81 && nMod100 <= 84)) {
		return locales.PluralRuleOne
	} else if (n == 5) || (nMod100 == 5) {
		return locales.PluralRuleMany
	}

	return locales.PluralRuleOther
}

var fnFmtDateMedium_3f222d37600871207c139eeba9ae1a98 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0x2d, 0xd0, 0xb6}...)
	b = append(b, []byte{0x2e, 0x2c, 0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2d}...)
	b = append(b, ln.monthsAbbreviated[t.Month()]...)

	return string(b)
}

var fnFmtDateLong_07de017bbe01706764e3fbed80282c3a = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0x2d, 0xd0, 0xb6}...)
	b = append(b, []byte{0x2e, 0x2c, 0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2d}...)
	b = append(b, ln.monthsWide[t.Month()]...)

	return string(b)
}

var fnFmtDateFull_2b8291eec4b5351a149455e035ae0af2 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0x2d, 0xd0, 0xb6}...)
	b = append(b, []byte{0x2e, 0x2c, 0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2d}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x2c, 0x20}...)
	b = append(b, ln.daysWide[t.Weekday()]...)

	return string(b)
}

var fnCardinalPluralRule_7664ec40507fc37b05985577fc0c7d99 = func(ln *localen, num float64, v uint64) locales.PluralRule {
	n := math.Abs(num)
	i := int64(n)

	if n == 0 {
		return locales.PluralRuleZero
	} else if (i == 0 || i == 1) && n != 0 {
		return locales.PluralRuleOne
	}

	return locales.PluralRuleOther
}

var fnFmtCurrency_9b06328888547fc535e862da8ee049d8 = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 5

	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			continue
		}

		b = append(b, s[i])
	}

	for j := len(symbol) - 1; j >= 0; j-- {
		b = append(b, symbol[j])
	}

	for j := len(ln.currencyPositivePrefix) - 1; j >= 0; j-- {
		b = append(b, ln.currencyPositivePrefix[j])
	}

	if num < 0 {
		b = append(b, ln.minus[0])
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	b = append(b, ln.currencyPositiveSuffix...)

	return string(b)
}

var fnFmtAccounting_d0ef2c4a76852adc59df517a99a6000f = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 5

	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			continue
		}

		b = append(b, s[i])
	}

	if num < 0 {

		for j := len(symbol) - 1; j >= 0; j-- {
			b = append(b, symbol[j])
		}

		for j := len(ln.currencyNegativePrefix) - 1; j >= 0; j-- {
			b = append(b, ln.currencyNegativePrefix[j])
		}

		b = append(b, ln.minus[0])

	} else {

		for j := len(symbol) - 1; j >= 0; j-- {
			b = append(b, symbol[j])
		}

		for j := len(ln.currencyPositivePrefix) - 1; j >= 0; j-- {
			b = append(b, ln.currencyPositivePrefix[j])
		}

	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if num < 0 {
		b = append(b, ln.currencyNegativeSuffix...)
	} else {
		b = append(b, ln.currencyPositiveSuffix...)
	}

	return string(b)
}

var fnFmtAccounting_0174068e708e390eda0b53f8a0ef057e = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 2 + 1*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				b = append(b, ln.group[0])
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {

		for j := len(symbol) - 1; j >= 0; j-- {
			b = append(b, symbol[j])
		}

		b = append(b, ln.currencyNegativePrefix[0])

	} else {
		for j := len(symbol) - 1; j >= 0; j-- {
			b = append(b, symbol[j])
		}
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	return string(b)
}

var fnFmtDateFull_afb42e88482f5f1e5a494bb738650f23 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = append(b, ln.daysWide[t.Weekday()]...)
	b = append(b, []byte{0x20, 0xe0, 0xba, 0x97, 0xe0, 0xba, 0xb5, 0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x20}...)

	if t.Year() < 0 {
		b = append(b, ln.erasWide[0]...)
	} else {
		b = append(b, ln.erasWide[1]...)
	}

	b = append(b, []byte{0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtTimeLong_2be9d9219c97d619bb809b28233eb70f = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Hour()), 10)
	b = append(b, []byte{0x20, 0xe0, 0xbb, 0x82, 0xe0, 0xba, 0xa1, 0xe0, 0xba, 0x87, 0x20}...)
	b = strconv.AppendInt(b, int64(t.Minute()), 10)
	b = append(b, []byte{0x20, 0xe0, 0xba, 0x99, 0xe0, 0xba, 0xb2, 0xe0, 0xba, 0x97, 0xe0, 0xba, 0xb5, 0x20}...)

	if t.Second() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Second()), 10)
	b = append(b, []byte{0x20, 0xe0, 0xba, 0xa7, 0xe0, 0xba, 0xb4, 0xe0, 0xba, 0x99, 0xe0, 0xba, 0xb2, 0xe0, 0xba, 0x97, 0xe0, 0xba, 0xb5, 0x20}...)

	tz, _ := t.Zone()
	b = append(b, tz...)

	return string(b)
}

var fnFmtTimeFull_dafe47a99f691cddd99c295dd3a80472 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Hour()), 10)
	b = append(b, []byte{0x20, 0xe0, 0xbb, 0x82, 0xe0, 0xba, 0xa1, 0xe0, 0xba, 0x87, 0x20}...)
	b = strconv.AppendInt(b, int64(t.Minute()), 10)
	b = append(b, []byte{0x20, 0xe0, 0xba, 0x99, 0xe0, 0xba, 0xb2, 0xe0, 0xba, 0x97, 0xe0, 0xba, 0xb5, 0x20}...)

	if t.Second() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Second()), 10)
	b = append(b, []byte{0x20, 0xe0, 0xba, 0xa7, 0xe0, 0xba, 0xb4, 0xe0, 0xba, 0x99, 0xe0, 0xba, 0xb2, 0xe0, 0xba, 0x97, 0xe0, 0xba, 0xb5, 0x20}...)

	tz, _ := t.Zone()

	if btz, ok := ln.timezones[tz]; ok {
		b = append(b, btz...)
	} else {
		b = append(b, tz...)
	}

	return string(b)
}

var fnFmtNumber_529d4d803e923e8eb15440c678f6c7b8 = func(ln *localen, num float64, v uint64) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	l := len(s) + 0
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				b = append(b, ln.group[0])
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {
		b = append(b, ln.minus[0])
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	return string(b)
}

var fnFmtCurrency_bc1dd05937d2f9e1e78f0e1e26de2ce0 = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 2
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				b = append(b, ln.group[0])
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	for j := len(symbol) - 1; j >= 0; j-- {
		b = append(b, symbol[j])
	}

	for j := len(ln.currencyPositivePrefix) - 1; j >= 0; j-- {
		b = append(b, ln.currencyPositivePrefix[j])
	}

	if num < 0 {
		b = append(b, ln.minus[0])
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	return string(b)
}

var fnFmtAccounting_c1338c4c0c9820a635090f5e89a65c4b = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 2
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				b = append(b, ln.group[0])
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {

		for j := len(symbol) - 1; j >= 0; j-- {
			b = append(b, symbol[j])
		}

		for j := len(ln.currencyNegativePrefix) - 1; j >= 0; j-- {
			b = append(b, ln.currencyNegativePrefix[j])
		}

		b = append(b, ln.minus[0])

	} else {

		for j := len(symbol) - 1; j >= 0; j-- {
			b = append(b, symbol[j])
		}

		for j := len(ln.currencyPositivePrefix) - 1; j >= 0; j-- {
			b = append(b, ln.currencyPositivePrefix[j])
		}

	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	return string(b)
}

var fnCardinalPluralRule_1a8ed4aac1cf13bc0d4f980cb943bb5f = func(ln *localen, num float64, v uint64) locales.PluralRule {
	n := math.Abs(num)
	f := locales.F(n, v)
	nMod100 := math.Mod(n, 100)
	nMod10 := math.Mod(n, 10)

	if nMod10 == 1 && (nMod100 < 11 || nMod100 > 19) {
		return locales.PluralRuleOne
	} else if nMod10 >= 2 && nMod10 <= 9 && (nMod100 < 11 || nMod100 > 19) {
		return locales.PluralRuleFew
	} else if f != 0 {
		return locales.PluralRuleMany
	}

	return locales.PluralRuleOther
}

var fnFmtDateMedium_a3f984963a38c1972f5ae182cb000f06 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0x2d}...)

	if t.Month() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Month()), 10)

	b = append(b, []byte{0x2d}...)

	if t.Day() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Day()), 10)

	return string(b)
}

var fnFmtDateLong_6af034e83fbef5852ab70b5e01d66101 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0x20, 0x6d}...)
	b = append(b, []byte{0x2e, 0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x20, 0x64}...)
	b = append(b, []byte{0x2e}...)

	return string(b)
}

var fnFmtDateFull_a6a7cb3b48a46ecca7801bbef267e737 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0x20, 0x6d}...)
	b = append(b, []byte{0x2e, 0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x20, 0x64}...)
	b = append(b, []byte{0x2e, 0x2c, 0x20}...)
	b = append(b, ln.daysWide[t.Weekday()]...)

	return string(b)
}

var fnCardinalPluralRule_c9ff0d41f0522116859535aa9029ca16 = func(ln *localen, num float64, v uint64) locales.PluralRule {
	n := math.Abs(num)
	f := locales.F(n, v)
	nMod10 := math.Mod(n, 10)
	nMod100 := math.Mod(n, 100)

	if nMod10 == 1 && (nMod100 < 11 || nMod100 > 19) {
		return locales.PluralRuleOne
	} else if nMod10 >= 2 && nMod10 <= 9 && (nMod100 < 11 || nMod100 > 19) {
		return locales.PluralRuleFew
	} else if f != 0 {
		return locales.PluralRuleMany
	}

	return locales.PluralRuleOther
}

var fnFmtCurrency_0519d76434d5fdd728586e7a31a5a755 = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 1 + 1*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				b = append(b, ln.group[0])
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {
		b = append(b, ln.minus[0])
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	b = append(b, symbol...)

	return string(b)
}

var fnFmtAccounting_1693594b7292f66cfb0a4a6405e5914e = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 1 + 1*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				b = append(b, ln.group[0])
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {
		b = append(b, ln.minus[0])
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	if num < 0 {
		b = append(b, symbol...)
	} else {
		b = append(b, symbol...)
	}

	return string(b)
}

var fnCardinalPluralRule_35d374490f3e32fac8828ad5843b9d6e = func(ln *localen, num float64, v uint64) locales.PluralRule {
	n := math.Abs(num)
	f := locales.F(n, v)
	nMod10 := math.Mod(n, 10)
	nMod100 := math.Mod(n, 100)
	fMod100 := f % 100
	fMod10 := f % 10

	if (nMod10 == 0) || (nMod100 >= 11 && nMod100 <= 19) || (v == 2 && fMod100 >= 11 && fMod100 <= 19) {
		return locales.PluralRuleZero
	} else if (nMod10 == 1 && nMod100 != 11) || (v == 2 && fMod10 == 1 && fMod100 != 11) || (v != 2 && fMod10 == 1) {
		return locales.PluralRuleOne
	}

	return locales.PluralRuleOther
}

var fnRangePluralRule_52f7b7c1971a0689c24fe53cd3a6bf1d = func(ln *localen, num1 float64, v1 uint64, num2 float64, v2 uint64) locales.PluralRule {
	start := ln.CardinalPluralRule(num1, v1)
	end := ln.CardinalPluralRule(num2, v2)

	if start == locales.PluralRuleZero && end == locales.PluralRuleZero {
		return locales.PluralRuleOther
	} else if start == locales.PluralRuleZero && end == locales.PluralRuleOne {
		return locales.PluralRuleOne
	} else if start == locales.PluralRuleZero && end == locales.PluralRuleOther {
		return locales.PluralRuleOther
	} else if start == locales.PluralRuleOne && end == locales.PluralRuleZero {
		return locales.PluralRuleOther
	} else if start == locales.PluralRuleOne && end == locales.PluralRuleOne {
		return locales.PluralRuleOne
	} else if start == locales.PluralRuleOne && end == locales.PluralRuleOther {
		return locales.PluralRuleOther
	} else if start == locales.PluralRuleOther && end == locales.PluralRuleZero {
		return locales.PluralRuleOther
	} else if start == locales.PluralRuleOther && end == locales.PluralRuleOne {
		return locales.PluralRuleOne
	}

	return locales.PluralRuleOther
}

var fnFmtDateMedium_cefeb908e03bbb483b089e5f8a7e3bb5 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0x2e, 0x20, 0x67, 0x61, 0x64, 0x61}...)
	b = append(b, []byte{0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2e, 0x20}...)
	b = append(b, ln.monthsAbbreviated[t.Month()]...)

	return string(b)
}

var fnFmtDateLong_b7e0e3e1d7c2a12e272d025e98a6facc = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0x2e, 0x20, 0x67, 0x61, 0x64, 0x61}...)
	b = append(b, []byte{0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2e, 0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)

	return string(b)
}

var fnFmtDateFull_c68531efc0310a76517a9616064247e7 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = append(b, ln.daysWide[t.Weekday()]...)
	b = append(b, []byte{0x2c, 0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0x2e, 0x20, 0x67, 0x61, 0x64, 0x61}...)
	b = append(b, []byte{0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2e, 0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)

	return string(b)
}

var fnCardinalPluralRule_073a4fc904d56c3f55fe9007d4416cce = func(ln *localen, num float64, v uint64) locales.PluralRule {
	n := math.Abs(num)
	f := locales.F(n, v)
	nMod10 := math.Mod(n, 10)
	nMod100 := math.Mod(n, 100)
	fMod10 := f % 10
	fMod100 := f % 100

	if (nMod10 == 0) || (nMod100 >= 11 && nMod100 <= 19) || (v == 2 && fMod100 >= 11 && fMod100 <= 19) {
		return locales.PluralRuleZero
	} else if (nMod10 == 1 && nMod100 != 11) || (v == 2 && fMod10 == 1 && fMod100 != 11) || (v != 2 && fMod10 == 1) {
		return locales.PluralRuleOne
	}

	return locales.PluralRuleOther
}

var fnCardinalPluralRule_b96558b039ca4fc63138671b418a67f5 = func(ln *localen, num float64, v uint64) locales.PluralRule {
	n := math.Abs(num)
	i := int64(n)
	f := locales.F(n, v)
	iMod10 := i % 10
	iMod100 := i % 100
	fMod10 := f % 10
	fMod100 := f % 100

	if (v == 0 && iMod10 == 1 && iMod100 != 11) || (fMod10 == 1 && fMod100 != 11) {
		return locales.PluralRuleOne
	}

	return locales.PluralRuleOther
}

var fnOrdinalPluralRule_885e23e22aae7e14ea3420fe83f75ccf = func(ln *localen, num float64, v uint64) locales.PluralRule {
	n := math.Abs(num)
	i := int64(n)
	iMod10 := i % 10
	iMod100 := i % 100

	if iMod10 == 1 && iMod100 != 11 {
		return locales.PluralRuleOne
	} else if iMod10 == 2 && iMod100 != 12 {
		return locales.PluralRuleTwo
	} else if (iMod10 == 7 || iMod10 == 8) && (iMod100 != 17 && iMod100 != 18) {
		return locales.PluralRuleMany
	}

	return locales.PluralRuleOther
}

var fnFmtDateMedium_fdbcfd5a321e6370f61bce682fe65b6e = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0x2c, 0x20}...)
	b = append(b, ln.monthsAbbreviated[t.Month()]...)
	b = append(b, []byte{0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)

	return string(b)
}

var fnFmtDateLong_ab2127ffd2f4043ae38d2f998ae282a6 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0x2c, 0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)

	return string(b)
}

var fnFmtDateFull_74d5e00c4bf6ea6ef8db9baad7610c73 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0x2c, 0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2c, 0x20}...)
	b = append(b, ln.daysWide[t.Weekday()]...)

	return string(b)
}

var fnFmtDateMedium_34dcbbdacb45f505155cca4c18ec48c0 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0x20, 0xd0, 0xbe, 0xd0, 0xbd, 0xd1, 0x8b}...)
	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsAbbreviated[t.Month()]...)
	b = append(b, []byte{0xd1, 0x8b, 0xd0, 0xbd}...)
	b = append(b, []byte{0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)

	return string(b)
}

var fnFmtDateLong_7545f2e6128dde4c84d462009151629b = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0x20, 0xd0, 0xbe, 0xd0, 0xbd, 0xd1, 0x8b}...)
	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0xd1, 0x8b, 0xd0, 0xbd}...)
	b = append(b, []byte{0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)

	return string(b)
}

var fnFmtDateFull_4052efc783402567c61ad2003f35b9bf = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0x20, 0xd0, 0xbe, 0xd0, 0xbd, 0xd1, 0x8b}...)
	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0xd1, 0x8b, 0xd0, 0xbd}...)
	b = append(b, []byte{0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2c, 0x20}...)
	b = append(b, ln.daysWide[t.Weekday()]...)
	b = append(b, []byte{0x20, 0xd0, 0xb3, 0xd0, 0xb0, 0xd1, 0x80, 0xd0, 0xb0, 0xd0, 0xb3}...)

	return string(b)
}

var fnOrdinalPluralRule_a2a4fea44e28d3286f808ebd85af3bc6 = func(ln *localen, num float64, v uint64) locales.PluralRule {
	n := math.Abs(num)

	if n == 1 {
		return locales.PluralRuleOne
	} else if n == 2 || n == 3 {
		return locales.PluralRuleTwo
	} else if n == 4 {
		return locales.PluralRuleFew
	}

	return locales.PluralRuleOther
}

var fnFmtDateFull_3c8ce40063641c68bcd08d693c6fa8e8 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Day() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnCardinalPluralRule_e05d2968783cc0de88c2d1b2682d3007 = func(ln *localen, num float64, v uint64) locales.PluralRule {
	n := math.Abs(num)
	nMod100 := math.Mod(n, 100)

	if n == 1 {
		return locales.PluralRuleOne
	} else if (n == 0) || (nMod100 >= 2 && nMod100 <= 10) {
		return locales.PluralRuleFew
	} else if nMod100 >= 11 && nMod100 <= 19 {
		return locales.PluralRuleMany
	}

	return locales.PluralRuleOther
}

var fnFmtDateLong_e370bf773fe0548c5c154f2e1cb30b9f = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x20, 0x74, 0x61}...)
	b = append(b, []byte{0xe2, 0x80, 0x99, 0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtDateFull_03998ac4c6437ee7c96bd6694bf576fb = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = append(b, ln.daysWide[t.Weekday()]...)
	b = append(b, []byte{0x2c, 0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x20, 0x74, 0x61}...)
	b = append(b, []byte{0xe2, 0x80, 0x99, 0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtAccounting_9a4ade24195ddf3fbcd889601bdb31fd = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 3 + 1*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				b = append(b, ln.group[0])
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {

		for j := len(symbol) - 1; j >= 0; j-- {
			b = append(b, symbol[j])
		}

		b = append(b, ln.currencyNegativePrefix[0])

	} else {
		for j := len(symbol) - 1; j >= 0; j-- {
			b = append(b, symbol[j])
		}
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	if num < 0 {
		b = append(b, ln.currencyNegativeSuffix...)
	}

	return string(b)
}

var fnFmtDateMedium_4d2c8f906ead2ec2a8ed4de52aa273cb = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0xe1, 0x81, 0x8a, 0x20}...)
	b = append(b, ln.monthsAbbreviated[t.Month()]...)
	b = append(b, []byte{0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)

	return string(b)
}

var fnFmtDateLong_26f464d351da53af35ea071506237a9d = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0xe1, 0x81, 0x8a, 0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)

	return string(b)
}

var fnFmtDateFull_b91fecf4568a8483e671bad76f4d4425 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0xe1, 0x81, 0x8a, 0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0xe1, 0x81, 0x8a, 0x20}...)
	b = append(b, ln.daysWide[t.Weekday()]...)

	return string(b)
}

var fnFmtTimeShort_3636d5dfdda3e0b6ca17aef52abf5eb3 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = append(b, []byte{0x42, 0x20}...)
	b = strconv.AppendInt(b, int64(t.Hour()), 10)
	b = append(b, ln.timeSeparator...)

	if t.Minute() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Minute()), 10)

	return string(b)
}

var fnFmtTimeMedium_5d9a472a4327911b01200af597bf5908 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = append(b, []byte{0x42, 0x20}...)

	if t.Hour() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Hour()), 10)
	b = append(b, ln.timeSeparator...)

	if t.Minute() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Minute()), 10)
	b = append(b, ln.timeSeparator...)

	if t.Second() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Second()), 10)

	return string(b)
}

var fnFmtTimeLong_c108ef0052564f5ac9b30fa59af63081 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	tz, _ := t.Zone()
	b = append(b, tz...)

	b = append(b, []byte{0x20}...)

	if t.Hour() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Hour()), 10)
	b = append(b, ln.timeSeparator...)

	if t.Minute() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Minute()), 10)
	b = append(b, ln.timeSeparator...)

	if t.Second() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Second()), 10)

	return string(b)
}

var fnFmtTimeFull_9d22f7542356e9fc28813c7e9ca3671d = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	tz, _ := t.Zone()

	if btz, ok := ln.timezones[tz]; ok {
		b = append(b, btz...)
	} else {
		b = append(b, tz...)
	}

	b = append(b, []byte{0x20}...)

	if t.Hour() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Hour()), 10)
	b = append(b, ln.timeSeparator...)

	if t.Minute() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Minute()), 10)
	b = append(b, ln.timeSeparator...)

	if t.Second() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Second()), 10)

	return string(b)
}

var fnFmtCurrency_8bfebaacbf71a9a4bab2a3bb99e52529 = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	return string(append(append([]byte{}, symbol...), s...))
}

var fnFmtAccounting_411c735c7aafad814d0db05f621af17c = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	return string(append(append([]byte{}, symbol...), s...))
}

var fnCardinalPluralRule_9b7082aa8f8da3ef64f6e2c0bf7bc90a = func(ln *localen, num float64, v uint64) locales.PluralRule {
	n := math.Abs(num)

	if n == 1 {
		return locales.PluralRuleOne
	} else if n == 2 {
		return locales.PluralRuleTwo
	}

	return locales.PluralRuleOther
}

var fnFmtCurrency_52160a421770c8d84e356e1637ce196a = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 6 + 2*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				for j := len(ln.group) - 1; j >= 0; j-- {
					b = append(b, ln.group[j])
				}
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	for j := len(symbol) - 1; j >= 0; j-- {
		b = append(b, symbol[j])
	}

	for j := len(ln.currencyPositivePrefix) - 1; j >= 0; j-- {
		b = append(b, ln.currencyPositivePrefix[j])
	}

	if num < 0 {
		for j := len(ln.minus) - 1; j >= 0; j-- {
			b = append(b, ln.minus[j])
		}
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	return string(b)
}

var fnFmtAccounting_6501a20bdcbb382f1e5e59af6d704f28 = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 6 + 2*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				for j := len(ln.group) - 1; j >= 0; j-- {
					b = append(b, ln.group[j])
				}
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {

		for j := len(symbol) - 1; j >= 0; j-- {
			b = append(b, symbol[j])
		}

		for j := len(ln.currencyNegativePrefix) - 1; j >= 0; j-- {
			b = append(b, ln.currencyNegativePrefix[j])
		}

		for j := len(ln.minus) - 1; j >= 0; j-- {
			b = append(b, ln.minus[j])
		}

	} else {

		for j := len(symbol) - 1; j >= 0; j-- {
			b = append(b, symbol[j])
		}

		for j := len(ln.currencyPositivePrefix) - 1; j >= 0; j-- {
			b = append(b, ln.currencyPositivePrefix[j])
		}

	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	return string(b)
}

var fnFmtDateFull_91904f1c4adbb925999bdba7f5796de8 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = append(b, ln.daysWide[t.Weekday()]...)
	b = append(b, []byte{0x2c, 0x20, 0x64, 0x65}...)
	b = append(b, []byte{0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2e, 0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtTimeShort_e50f14b6d2405eade89d9149a1efaee9 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = append(b, []byte{0x4b, 0x6c}...)
	b = append(b, []byte{0x2e, 0x20}...)
	b = strconv.AppendInt(b, int64(t.Hour()), 10)
	b = append(b, []byte{0x2e}...)

	if t.Minute() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Minute()), 10)

	return string(b)
}

var fnFmtTimeMedium_d09a7c8ab2ed333a37b86babd4139677 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = append(b, []byte{0x4b, 0x6c, 0x6f, 0x63, 0x6b}...)
	b = append(b, []byte{0x20}...)
	b = strconv.AppendInt(b, int64(t.Hour()), 10)
	b = append(b, []byte{0x2e}...)

	if t.Minute() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Minute()), 10)
	b = append(b, ln.timeSeparator...)

	if t.Second() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Second()), 10)

	return string(b)
}

var fnFmtTimeLong_1dc6a22a036902eb11698fc0a589743d = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = append(b, []byte{0x4b, 0x6c, 0x6f, 0x63, 0x6b}...)
	b = append(b, []byte{0x20}...)
	b = strconv.AppendInt(b, int64(t.Hour()), 10)
	b = append(b, []byte{0x2e}...)

	if t.Minute() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Minute()), 10)
	b = append(b, ln.timeSeparator...)

	if t.Second() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Second()), 10)
	b = append(b, []byte{0x20, 0x28}...)

	tz, _ := t.Zone()
	b = append(b, tz...)

	b = append(b, []byte{0x29}...)

	return string(b)
}

var fnFmtTimeFull_e61d6b84b00325a0cc262f834ec42619 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = append(b, []byte{0x4b, 0x6c, 0x6f, 0x63, 0x6b}...)
	b = append(b, []byte{0x20}...)
	b = strconv.AppendInt(b, int64(t.Hour()), 10)
	b = append(b, []byte{0x2e}...)

	if t.Minute() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Minute()), 10)
	b = append(b, ln.timeSeparator...)

	if t.Second() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Second()), 10)
	b = append(b, []byte{0x20, 0x28}...)

	tz, _ := t.Zone()

	if btz, ok := ln.timezones[tz]; ok {
		b = append(b, btz...)
	} else {
		b = append(b, tz...)
	}

	b = append(b, []byte{0x29}...)

	return string(b)
}

var fnOrdinalPluralRule_7e0820ce2c902179e061cbae21c795d7 = func(ln *localen, num float64, v uint64) locales.PluralRule {
	n := math.Abs(num)

	if n >= 1 && n <= 4 {
		return locales.PluralRuleOne
	}

	return locales.PluralRuleOther
}

var fnFmtDateShort_c2e9326f17b4ceaeb5497266d0765dd7 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2f}...)

	if t.Month() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Month()), 10)

	b = append(b, []byte{0x2f}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtTimeFull_702261155c59dd873e83848c0fe82a23 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = append(b, []byte{0x6b, 0x6c}...)
	b = append(b, []byte{0x2e, 0x20}...)

	if t.Hour() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Hour()), 10)
	b = append(b, ln.timeSeparator...)

	if t.Minute() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Minute()), 10)
	b = append(b, ln.timeSeparator...)

	if t.Second() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Second()), 10)
	b = append(b, []byte{0x20}...)

	tz, _ := t.Zone()

	if btz, ok := ln.timezones[tz]; ok {
		b = append(b, btz...)
	} else {
		b = append(b, tz...)
	}

	return string(b)
}

var fnFmtDateLong_53ac6ba1bddae8f8da33e7321fa48492 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = append(b, []byte{0x6c, 0x79, 0xc9, 0x9b}...)
	b = append(b, []byte{0xcc, 0x8c, 0xca, 0xbc, 0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x20, 0x6e, 0x61}...)
	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x2c, 0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtDateFull_1d5a2ee3108dbf80d60a1f3c5c0aaf8d = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = append(b, ln.daysWide[t.Weekday()]...)
	b = append(b, []byte{0x20, 0x2c, 0x20, 0x6c, 0x79, 0xc9, 0x9b}...)
	b = append(b, []byte{0xcc, 0x8c, 0xca, 0xbc, 0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x20, 0x6e, 0x61}...)
	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x2c, 0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtTimeLong_5643f7e25a7c963d538012968ff836de = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	tz, _ := t.Zone()
	b = append(b, tz...)

	b = append(b, []byte{0x20}...)

	h := t.Hour()

	if h > 12 {
		h -= 12
	}

	b = strconv.AppendInt(b, int64(h), 10)
	b = append(b, ln.timeSeparator...)

	if t.Minute() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Minute()), 10)
	b = append(b, ln.timeSeparator...)

	if t.Second() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Second()), 10)
	b = append(b, []byte{0x20}...)

	if t.Hour() < 12 {
		b = append(b, ln.periodsAbbreviated[0]...)
	} else {
		b = append(b, ln.periodsAbbreviated[1]...)
	}

	return string(b)
}

var fnFmtTimeFull_fb1e9e6f7242212344122d3c0e63f9d6 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	tz, _ := t.Zone()

	if btz, ok := ln.timezones[tz]; ok {
		b = append(b, btz...)
	} else {
		b = append(b, tz...)
	}

	b = append(b, []byte{0x20}...)

	h := t.Hour()

	if h > 12 {
		h -= 12
	}

	b = strconv.AppendInt(b, int64(h), 10)
	b = append(b, ln.timeSeparator...)

	if t.Minute() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Minute()), 10)
	b = append(b, ln.timeSeparator...)

	if t.Second() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Second()), 10)
	b = append(b, []byte{0x20}...)

	if t.Hour() < 12 {
		b = append(b, ln.periodsAbbreviated[0]...)
	} else {
		b = append(b, ln.periodsAbbreviated[1]...)
	}

	return string(b)
}

var fnOrdinalPluralRule_f7f41a6ef5c99a912fc7e7451c5c3029 = func(ln *localen, num float64, v uint64) locales.PluralRule {
	n := math.Abs(num)

	if n == 1 || n == 5 || n >= 7 && n <= 9 {
		return locales.PluralRuleOne
	} else if n == 2 || n == 3 {
		return locales.PluralRuleTwo
	} else if n == 4 {
		return locales.PluralRuleFew
	} else if n == 6 {
		return locales.PluralRuleMany
	}

	return locales.PluralRuleOther
}

var fnFmtDateMedium_5a5202b511779ecb07983ce846c85742 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Day() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsAbbreviated[t.Month()]...)
	b = append(b, []byte{0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0x20, 0xd0, 0xb0, 0xd0, 0xb7}...)

	return string(b)
}

var fnFmtDateLong_4874c47573ec41408036722eb0d2c6a6 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x2c, 0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0x20, 0xd0, 0xb0, 0xd0, 0xb7}...)

	return string(b)
}

var fnFmtDateFull_a7dc1bab86baf3ec90633b4422fb9cba = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = append(b, ln.daysWide[t.Weekday()]...)
	b = append(b, []byte{0x2c, 0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x2c, 0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0x20, 0xd0, 0xb0, 0xd0, 0xb7}...)

	return string(b)
}

var fnCardinalPluralRule_4e031e59a33d2df374391ed7199b0c7f = func(ln *localen, num float64, v uint64) locales.PluralRule {
	n := math.Abs(num)
	i := int64(n)
	iMod100 := i % 100
	iMod10 := i % 10

	if i == 1 && v == 0 {
		return locales.PluralRuleOne
	} else if v == 0 && iMod10 >= 2 && iMod10 <= 4 && (iMod100 < 12 || iMod100 > 14) {
		return locales.PluralRuleFew
	} else if (v == 0 && i != 1 && iMod10 >= 0 && iMod10 <= 1) || (v == 0 && iMod10 >= 5 && iMod10 <= 9) || (v == 0 && iMod100 >= 12 && iMod100 <= 14) {
		return locales.PluralRuleMany
	}

	return locales.PluralRuleOther
}

var fnCardinalPluralRule_3c2302f5244a65cb0b21db084f77f61b = func(ln *localen, num float64, v uint64) locales.PluralRule {
	n := math.Abs(num)
	i := int64(n)
	iMod10 := i % 10
	iMod100 := i % 100

	if i == 1 && v == 0 {
		return locales.PluralRuleOne
	} else if v == 0 && iMod10 >= 2 && iMod10 <= 4 && (iMod100 < 12 || iMod100 > 14) {
		return locales.PluralRuleFew
	} else if (v == 0 && i != 1 && iMod10 >= 0 && iMod10 <= 1) || (v == 0 && iMod10 >= 5 && iMod10 <= 9) || (v == 0 && iMod100 >= 12 && iMod100 <= 14) {
		return locales.PluralRuleMany
	}

	return locales.PluralRuleOther
}

var fnFmtDateMedium_657e1e9a61de200098381fee1994c99c = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Day() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2e}...)

	if t.Month() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Month()), 10)

	b = append(b, []byte{0x20, 0x73, 0x74}...)
	b = append(b, []byte{0x2e, 0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtDateLong_bce1be6f532fe054bea1dce83a0ecd58 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0x20, 0x6d, 0x65, 0x74, 0x74, 0x61, 0x73}...)
	b = append(b, []byte{0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2e, 0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)

	return string(b)
}

var fnFmtDateFull_8f18dd0a7a346f349e234c4eb438c7ba = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = append(b, ln.daysWide[t.Weekday()]...)
	b = append(b, []byte{0x2c, 0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0x20, 0x6d, 0x65, 0x74, 0x74, 0x61, 0x73}...)
	b = append(b, []byte{0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2e, 0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)

	return string(b)
}

var fnFmtDateLong_03b64668e0972b02e0a12fe5cd4b5829 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = append(b, []byte{0xd8, 0xaf, 0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0x20, 0xd8, 0xaf, 0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)

	return string(b)
}

var fnFmtDateFull_7ea895699a09e2a46b34e71ca5ff6068 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = append(b, ln.daysWide[t.Weekday()]...)
	b = append(b, []byte{0x20, 0xd8, 0xaf, 0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0x20, 0xd8, 0xaf, 0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)

	return string(b)
}

var fnCardinalPluralRule_72e0d02c4132f59ce64c852514edc801 = func(ln *localen, num float64, v uint64) locales.PluralRule {
	n := math.Abs(num)
	i := int64(n)

	if i >= 0 && i <= 1 {
		return locales.PluralRuleOne
	}

	return locales.PluralRuleOther
}

var fnFmtDateFull_4c2ead12910ff721f96d3aca986ca749 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = append(b, ln.daysWide[t.Weekday()]...)
	b = append(b, []byte{0x2c, 0x20, 0x69, 0x6c, 0x73}...)
	b = append(b, []byte{0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnCardinalPluralRule_a60b3f7c6ddcf0678df3df0fe274201a = func(ln *localen, num float64, v uint64) locales.PluralRule {
	n := math.Abs(num)
	i := int64(n)
	nMod100 := math.Mod(n, 100)

	if i == 1 && v == 0 {
		return locales.PluralRuleOne
	} else if (v != 0) || (n == 0) || (nMod100 >= 2 && nMod100 <= 19) {
		return locales.PluralRuleFew
	}

	return locales.PluralRuleOther
}

var fnRangePluralRule_6db355e32f98d7cf05b06cd4b38d6c63 = func(ln *localen, num1 float64, v1 uint64, num2 float64, v2 uint64) locales.PluralRule {
	start := ln.CardinalPluralRule(num1, v1)
	end := ln.CardinalPluralRule(num2, v2)

	if start == locales.PluralRuleOne && end == locales.PluralRuleFew {
		return locales.PluralRuleFew
	} else if start == locales.PluralRuleOne && end == locales.PluralRuleOther {
		return locales.PluralRuleOther
	} else if start == locales.PluralRuleFew && end == locales.PluralRuleOne {
		return locales.PluralRuleFew
	} else if start == locales.PluralRuleFew && end == locales.PluralRuleFew {
		return locales.PluralRuleFew
	} else if start == locales.PluralRuleFew && end == locales.PluralRuleOther {
		return locales.PluralRuleOther
	} else if start == locales.PluralRuleOther && end == locales.PluralRuleFew {
		return locales.PluralRuleFew
	}

	return locales.PluralRuleOther
}

var fnCardinalPluralRule_97e86d6fc0c03aeac1441d5d07580fac = func(ln *localen, num float64, v uint64) locales.PluralRule {
	n := math.Abs(num)
	i := int64(n)
	iMod10 := i % 10
	iMod100 := i % 100

	if v == 0 && iMod10 == 1 && iMod100 != 11 {
		return locales.PluralRuleOne
	} else if v == 0 && iMod10 >= 2 && iMod10 <= 4 && (iMod100 < 12 || iMod100 > 14) {
		return locales.PluralRuleFew
	} else if (v == 0 && iMod10 == 0) || (v == 0 && iMod10 >= 5 && iMod10 <= 9) || (v == 0 && iMod100 >= 11 && iMod100 <= 14) {
		return locales.PluralRuleMany
	}

	return locales.PluralRuleOther
}

var fnFmtDateMedium_5b31a18861b34639769a2dc612a70a3b = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsAbbreviated[t.Month()]...)
	b = append(b, []byte{0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0x20, 0xd0, 0xb3}...)
	b = append(b, []byte{0x2e}...)

	return string(b)
}

var fnFmtDateFull_57a372adfbe798d29526efd47816e07a = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0x20, 0xd1, 0x81, 0xd1, 0x8b, 0xd0, 0xbb}...)
	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x20, 0xd0, 0xba, 0xd2, 0xaf, 0xd0, 0xbd, 0xd1, 0x8d}...)
	b = append(b, []byte{0x2c, 0x20}...)
	b = append(b, ln.daysWide[t.Weekday()]...)

	return string(b)
}

var fnCardinalPluralRule_c6f27f6f1d6b31d66116bd13f68bb112 = func(ln *localen, num float64, v uint64) locales.PluralRule {
	n := math.Abs(num)
	i := int64(n)

	if (i == 0) || (n == 1) {
		return locales.PluralRuleOne
	} else if n >= 2 && n <= 10 {
		return locales.PluralRuleFew
	}

	return locales.PluralRuleOther
}

var fnCardinalPluralRule_780c1153d0b26cb9e6da19f93ef34fac = func(ln *localen, num float64, v uint64) locales.PluralRule {
	n := math.Abs(num)
	i := int64(n)
	f := locales.F(n, v)

	if (n == 0 || n == 1) || (i == 0 && f == 1) {
		return locales.PluralRuleOne
	}

	return locales.PluralRuleOther
}

var fnRangePluralRule_088ba095b00c7f7ec73fa5b6bd628417 = func(ln *localen, num1 float64, v1 uint64, num2 float64, v2 uint64) locales.PluralRule {
	start := ln.CardinalPluralRule(num1, v1)
	end := ln.CardinalPluralRule(num2, v2)

	if start == locales.PluralRuleOne && end == locales.PluralRuleOne {
		return locales.PluralRuleOne
	} else if start == locales.PluralRuleOne && end == locales.PluralRuleOther {
		return locales.PluralRuleOther
	} else if start == locales.PluralRuleOther && end == locales.PluralRuleOne {
		return locales.PluralRuleOther
	}

	return locales.PluralRuleOther
}

var fnCardinalPluralRule_0fef1d0e24fa8383f72b5cbddf29c5f9 = func(ln *localen, num float64, v uint64) locales.PluralRule {
	n := math.Abs(num)
	i := int64(n)
	iMod100 := i % 100

	if v == 0 && iMod100 == 1 {
		return locales.PluralRuleOne
	} else if v == 0 && iMod100 == 2 {
		return locales.PluralRuleTwo
	} else if (v == 0 && iMod100 >= 3 && iMod100 <= 4) || (v != 0) {
		return locales.PluralRuleFew
	}

	return locales.PluralRuleOther
}

var fnRangePluralRule_c14bd9bed5ef22ead1e026671990212f = func(ln *localen, num1 float64, v1 uint64, num2 float64, v2 uint64) locales.PluralRule {
	start := ln.CardinalPluralRule(num1, v1)
	end := ln.CardinalPluralRule(num2, v2)

	if start == locales.PluralRuleOne && end == locales.PluralRuleOne {
		return locales.PluralRuleFew
	} else if start == locales.PluralRuleOne && end == locales.PluralRuleTwo {
		return locales.PluralRuleTwo
	} else if start == locales.PluralRuleOne && end == locales.PluralRuleFew {
		return locales.PluralRuleFew
	} else if start == locales.PluralRuleOne && end == locales.PluralRuleOther {
		return locales.PluralRuleOther
	} else if start == locales.PluralRuleTwo && end == locales.PluralRuleOne {
		return locales.PluralRuleFew
	} else if start == locales.PluralRuleTwo && end == locales.PluralRuleTwo {
		return locales.PluralRuleTwo
	} else if start == locales.PluralRuleTwo && end == locales.PluralRuleFew {
		return locales.PluralRuleFew
	} else if start == locales.PluralRuleTwo && end == locales.PluralRuleOther {
		return locales.PluralRuleOther
	} else if start == locales.PluralRuleFew && end == locales.PluralRuleOne {
		return locales.PluralRuleFew
	} else if start == locales.PluralRuleFew && end == locales.PluralRuleTwo {
		return locales.PluralRuleTwo
	} else if start == locales.PluralRuleFew && end == locales.PluralRuleFew {
		return locales.PluralRuleFew
	} else if start == locales.PluralRuleFew && end == locales.PluralRuleOther {
		return locales.PluralRuleOther
	} else if start == locales.PluralRuleOther && end == locales.PluralRuleOne {
		return locales.PluralRuleFew
	} else if start == locales.PluralRuleOther && end == locales.PluralRuleTwo {
		return locales.PluralRuleTwo
	} else if start == locales.PluralRuleOther && end == locales.PluralRuleFew {
		return locales.PluralRuleFew
	}

	return locales.PluralRuleOther
}

var fnFmtDateShort_6782bf6cd88b90ec3c33a5cf6ab98fd7 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2e, 0x20}...)

	if t.Month() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Month()), 10)

	b = append(b, []byte{0x2e, 0x20}...)

	if t.Year() > 9 {
		b = append(b, strconv.Itoa(t.Year())[2:]...)
	} else {
		b = append(b, strconv.Itoa(t.Year())[1:]...)
	}

	return string(b)
}

var fnFmtDateLong_7394f5b140d96d3ada830127b6b00a5f = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Day() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2e, 0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtDateFull_8c8c1dc47cf6203ce4b51ec99ff21181 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = append(b, ln.daysWide[t.Weekday()]...)
	b = append(b, []byte{0x2c, 0x20}...)

	if t.Day() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2e, 0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtDateMedium_56894f892061c70a16fdf4ad41cd67e9 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = append(b, ln.monthsAbbreviated[t.Month()]...)
	b = append(b, []byte{0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2e, 0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtDateLong_bc6f92d2d84d639433127ff63687d178 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2e, 0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtDateFull_789e11f07c8b1dffd2bd03da43d0ea66 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = append(b, []byte{0x63, 0x63, 0x63, 0x63, 0x2c, 0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2e, 0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtDateFull_3c1131a653a5e918c3e9381647860bcf = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = append(b, ln.daysWide[t.Weekday()]...)
	b = append(b, []byte{0x2c, 0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x20}...)

	if t.Day() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2c, 0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnOrdinalPluralRule_8b495a08240ebf51a9ad31ffd7bf6c66 = func(ln *localen, num float64, v uint64) locales.PluralRule {
	n := math.Abs(num)
	nMod10 := math.Mod(n, 10)
	nMod100 := math.Mod(n, 100)

	if n == 1 {
		return locales.PluralRuleOne
	} else if nMod10 == 4 && nMod100 != 14 {
		return locales.PluralRuleMany
	}

	return locales.PluralRuleOther
}

var fnFmtTimeLong_880840264062db9197a5f9820877cc61 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	h := t.Hour()

	if h > 12 {
		h -= 12
	}

	b = strconv.AppendInt(b, int64(h), 10)
	b = append(b, ln.timeSeparator...)

	if t.Minute() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Minute()), 10)
	b = append(b, ln.timeSeparator...)

	if t.Second() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Second()), 10)
	b = append(b, []byte{0x20}...)

	if t.Hour() < 12 {
		b = append(b, ln.periodsAbbreviated[0]...)
	} else {
		b = append(b, ln.periodsAbbreviated[1]...)
	}

	b = append(b, []byte{0x2c, 0x20}...)

	tz, _ := t.Zone()
	b = append(b, tz...)

	return string(b)
}

var fnFmtTimeFull_922dbe895fd3d466f77caf876ca0d4af = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	h := t.Hour()

	if h > 12 {
		h -= 12
	}

	b = strconv.AppendInt(b, int64(h), 10)
	b = append(b, ln.timeSeparator...)

	if t.Minute() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Minute()), 10)
	b = append(b, ln.timeSeparator...)

	if t.Second() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Second()), 10)
	b = append(b, []byte{0x20}...)

	if t.Hour() < 12 {
		b = append(b, ln.periodsAbbreviated[0]...)
	} else {
		b = append(b, ln.periodsAbbreviated[1]...)
	}

	b = append(b, []byte{0x2c, 0x20}...)

	tz, _ := t.Zone()

	if btz, ok := ln.timezones[tz]; ok {
		b = append(b, btz...)
	} else {
		b = append(b, tz...)
	}

	return string(b)
}

var fnOrdinalPluralRule_1456aec41e57e34cc80a524a2035cc1f = func(ln *localen, num float64, v uint64) locales.PluralRule {
	n := math.Abs(num)
	nMod100 := math.Mod(n, 100)
	nMod10 := math.Mod(n, 10)

	if (nMod10 == 1 || nMod10 == 2) && (nMod100 != 11 && nMod100 != 12) {
		return locales.PluralRuleOne
	}

	return locales.PluralRuleOther
}

var fnOrdinalPluralRule_89ff89febaf8ab083f938260d29e96d0 = func(ln *localen, num float64, v uint64) locales.PluralRule {
	n := math.Abs(num)
	nMod10 := math.Mod(n, 10)
	nMod100 := math.Mod(n, 100)

	if (nMod10 == 1 || nMod10 == 2) && (nMod100 != 11 && nMod100 != 12) {
		return locales.PluralRuleOne
	}

	return locales.PluralRuleOther
}

var fnFmtCurrency_2a7c939a96723e34c09bd13cdb6d28d7 = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 5

	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			continue
		}

		b = append(b, s[i])
	}

	for j := len(symbol) - 1; j >= 0; j-- {
		b = append(b, symbol[j])
	}

	for j := len(ln.currencyPositivePrefix) - 1; j >= 0; j-- {
		b = append(b, ln.currencyPositivePrefix[j])
	}

	if num < 0 {
		b = append(b, ln.minus[0])
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	return string(b)
}

var fnFmtAccounting_0a9258144dfcd2f61bc1eaaba53bee40 = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 5

	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			continue
		}

		b = append(b, s[i])
	}

	if num < 0 {

		for j := len(symbol) - 1; j >= 0; j-- {
			b = append(b, symbol[j])
		}

		for j := len(ln.currencyNegativePrefix) - 1; j >= 0; j-- {
			b = append(b, ln.currencyNegativePrefix[j])
		}

		b = append(b, ln.minus[0])

	} else {

		for j := len(symbol) - 1; j >= 0; j-- {
			b = append(b, symbol[j])
		}

		for j := len(ln.currencyPositivePrefix) - 1; j >= 0; j-- {
			b = append(b, ln.currencyPositivePrefix[j])
		}

	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	return string(b)
}

var fnFmtTimeLong_473cd7451fd2b0582dbc76fa50f0465a = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Hour() < 12 {
		b = append(b, ln.periodsAbbreviated[0]...)
	} else {
		b = append(b, ln.periodsAbbreviated[1]...)
	}

	b = append(b, []byte{0x20}...)

	h := t.Hour()

	if h > 12 {
		h -= 12
	}

	b = strconv.AppendInt(b, int64(h), 10)
	b = append(b, ln.timeSeparator...)

	if t.Minute() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Minute()), 10)
	b = append(b, ln.timeSeparator...)

	if t.Second() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Second()), 10)
	b = append(b, []byte{0x20}...)

	tz, _ := t.Zone()
	b = append(b, tz...)

	return string(b)
}

var fnFmtTimeFull_6fab0d5c33d51b8c50c1ff9de8d0ca73 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Hour() < 12 {
		b = append(b, ln.periodsAbbreviated[0]...)
	} else {
		b = append(b, ln.periodsAbbreviated[1]...)
	}

	b = append(b, []byte{0x20}...)

	h := t.Hour()

	if h > 12 {
		h -= 12
	}

	b = strconv.AppendInt(b, int64(h), 10)
	b = append(b, ln.timeSeparator...)

	if t.Minute() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Minute()), 10)
	b = append(b, ln.timeSeparator...)

	if t.Second() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Second()), 10)
	b = append(b, []byte{0x20}...)

	tz, _ := t.Zone()

	if btz, ok := ln.timezones[tz]; ok {
		b = append(b, btz...)
	} else {
		b = append(b, tz...)
	}

	return string(b)
}

var fnFmtDateFull_c892ba68b5e8cfe388377f706293ec57 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2c, 0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0x2c, 0x20}...)
	b = append(b, ln.daysWide[t.Weekday()]...)

	return string(b)
}

var fnFmtDateLong_4ba622cfb6604f92efa67396648b01e1 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x20}...)

	if t.Year() < 0 {
		b = append(b, ln.erasAbbreviated[0]...)
	} else {
		b = append(b, ln.erasAbbreviated[1]...)
	}

	b = append(b, []byte{0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtDateFull_2a2625729a79b75f22677ae0545a3802 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = append(b, ln.daysWide[t.Weekday()]...)
	b = append(b, []byte{0xe0, 0xb8, 0x97, 0xe0, 0xb8, 0xb5, 0xe0, 0xb9, 0x88, 0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x20}...)

	if t.Year() < 0 {
		b = append(b, ln.erasWide[0]...)
	} else {
		b = append(b, ln.erasWide[1]...)
	}

	b = append(b, []byte{0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtTimeLong_9d4d0f53074023f50ec443e7d6cc145e = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Hour()), 10)
	b = append(b, []byte{0x20, 0xe0, 0xb8, 0x99, 0xe0, 0xb8, 0xb2, 0xe0, 0xb8, 0xac, 0xe0, 0xb8, 0xb4, 0xe0, 0xb8, 0x81, 0xe0, 0xb8, 0xb2, 0x20}...)

	if t.Minute() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Minute()), 10)
	b = append(b, []byte{0x20, 0xe0, 0xb8, 0x99, 0xe0, 0xb8, 0xb2, 0xe0, 0xb8, 0x97, 0xe0, 0xb8, 0xb5, 0x20}...)

	if t.Second() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Second()), 10)
	b = append(b, []byte{0x20, 0xe0, 0xb8, 0xa7, 0xe0, 0xb8, 0xb4, 0xe0, 0xb8, 0x99, 0xe0, 0xb8, 0xb2, 0xe0, 0xb8, 0x97, 0xe0, 0xb8, 0xb5, 0x20}...)

	tz, _ := t.Zone()
	b = append(b, tz...)

	return string(b)
}

var fnFmtTimeFull_54a1d4bd08c970be76504a2aa980af91 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Hour()), 10)
	b = append(b, []byte{0x20, 0xe0, 0xb8, 0x99, 0xe0, 0xb8, 0xb2, 0xe0, 0xb8, 0xac, 0xe0, 0xb8, 0xb4, 0xe0, 0xb8, 0x81, 0xe0, 0xb8, 0xb2, 0x20}...)

	if t.Minute() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Minute()), 10)
	b = append(b, []byte{0x20, 0xe0, 0xb8, 0x99, 0xe0, 0xb8, 0xb2, 0xe0, 0xb8, 0x97, 0xe0, 0xb8, 0xb5, 0x20}...)

	if t.Second() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Second()), 10)
	b = append(b, []byte{0x20, 0xe0, 0xb8, 0xa7, 0xe0, 0xb8, 0xb4, 0xe0, 0xb8, 0x99, 0xe0, 0xb8, 0xb2, 0xe0, 0xb8, 0x97, 0xe0, 0xb8, 0xb5, 0x20}...)

	tz, _ := t.Zone()

	if btz, ok := ln.timezones[tz]; ok {
		b = append(b, btz...)
	} else {
		b = append(b, tz...)
	}

	return string(b)
}

var fnFmtDateFull_b145a441f04d612c2b6631b673b83d20 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = append(b, ln.daysWide[t.Weekday()]...)
	b = append(b, []byte{0xe1, 0x8d, 0xa3, 0x20}...)

	if t.Day() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x20, 0xe1, 0x88, 0x98, 0xe1, 0x8b, 0x93, 0xe1, 0x88, 0x8d, 0xe1, 0x89, 0xb2, 0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0x20}...)

	if t.Year() < 0 {
		b = append(b, ln.erasWide[0]...)
	} else {
		b = append(b, ln.erasWide[1]...)
	}

	return string(b)
}

var fnOrdinalPluralRule_96a5502b4d80e3468da0c2115685c65f = func(ln *localen, num float64, v uint64) locales.PluralRule {
	n := math.Abs(num)
	nMod10 := math.Mod(n, 10)

	if (nMod10 == 6 || nMod10 == 9) || (n == 10) {
		return locales.PluralRuleFew
	}

	return locales.PluralRuleOther
}

var fnFmtDateFull_8c251b28aa9de80970be20b481b38b9b = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0x20}...)
	b = append(b, ln.daysWide[t.Weekday()]...)

	return string(b)
}

var fnFmtPercent_5bdc6fa582de100c13fd696db4607f17 = func(ln *localen, num float64, v uint64) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	l := len(s) + 12
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			for j := len(ln.decimal) - 1; j >= 0; j-- {
				b = append(b, ln.decimal[j])
			}
			continue
		}

		b = append(b, s[i])
	}

	if num < 0 {
		for j := len(ln.minus) - 1; j >= 0; j-- {
			b = append(b, ln.minus[j])
		}
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	b = append(b, ln.percentSuffix...)

	b = append(b, ln.percent...)

	return string(b)
}

var fnFmtDateShort_c0764a5a895e1bd677cbe99232a5e159 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2e}...)

	if t.Month() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Month()), 10)

	b = append(b, []byte{0x2e}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtDateMedium_d6c733b45a5fc6c4b67eabb17c635dfe = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsAbbreviated[t.Month()]...)
	b = append(b, []byte{0x2c, 0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0x20, 0xd0, 0xb5, 0xd0, 0xbb}...)

	return string(b)
}

var fnFmtDateLong_6384cc06509d395705e5eb2161388671 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x2c, 0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0x20, 0xd0, 0xb5, 0xd0, 0xbb}...)

	return string(b)
}

var fnFmtDateFull_a5f5cc8ae427c1221f50697b6908f7a5 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x2c, 0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0x20, 0xd0, 0xb5, 0xd0, 0xbb}...)
	b = append(b, []byte{0x2c, 0x20}...)
	b = append(b, ln.daysWide[t.Weekday()]...)

	return string(b)
}

var fnCardinalPluralRule_92e733a5c3e2c8f5728268e0f4b7afd0 = func(ln *localen, num float64, v uint64) locales.PluralRule {
	n := math.Abs(num)

	if (n >= 0 && n <= 1) || (n >= 11 && n <= 99) {
		return locales.PluralRuleOne
	}

	return locales.PluralRuleOther
}

var fnFmtDateMedium_bdd5fb2012d879143590e275c7d8ebb5 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2d}...)
	b = append(b, ln.monthsAbbreviated[t.Month()]...)
	b = append(b, []byte{0xd8, 0x8c, 0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtDateLong_c5ff4169cfa62bfc0e853fa211ecf219 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2d}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0xd8, 0x8c, 0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtDateFull_4e14db85a2854023613be0580e048527 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2d}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0xd8, 0x8c, 0x20}...)
	b = append(b, ln.daysWide[t.Weekday()]...)

	return string(b)
}

var fnCardinalPluralRule_a9860e48306c4532a134648f71c7ec2b = func(ln *localen, num float64, v uint64) locales.PluralRule {
	n := math.Abs(num)
	i := int64(n)
	iMod100 := i % 100
	iMod10 := i % 10

	if v == 0 && iMod10 == 1 && iMod100 != 11 {
		return locales.PluralRuleOne
	} else if v == 0 && iMod10 >= 2 && iMod10 <= 4 && (iMod100 < 12 || iMod100 > 14) {
		return locales.PluralRuleFew
	} else if (v == 0 && iMod10 == 0) || (v == 0 && iMod10 >= 5 && iMod10 <= 9) || (v == 0 && iMod100 >= 11 && iMod100 <= 14) {
		return locales.PluralRuleMany
	}

	return locales.PluralRuleOther
}

var fnOrdinalPluralRule_d372f132a14400bf15cec11e0608103a = func(ln *localen, num float64, v uint64) locales.PluralRule {
	n := math.Abs(num)
	nMod10 := math.Mod(n, 10)
	nMod100 := math.Mod(n, 100)

	if nMod10 == 3 && nMod100 != 13 {
		return locales.PluralRuleFew
	}

	return locales.PluralRuleOther
}

var fnFmtDateMedium_eab28cd2ee8d9db4a9df96d1f7b01551 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsAbbreviated[t.Month()]...)
	b = append(b, []byte{0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0x20, 0xd1, 0x80}...)
	b = append(b, []byte{0x2e}...)

	return string(b)
}

var fnFmtDateLong_a29e6b3227718d09eae068aaf8d4873a = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0x20, 0xd1, 0x80}...)
	b = append(b, []byte{0x2e}...)

	return string(b)
}

var fnFmtDateFull_0b6f60c7e7c9a2b75087215c987e94eb = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = append(b, ln.daysWide[t.Weekday()]...)
	b = append(b, []byte{0x2c, 0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0x20, 0xd1, 0x80}...)
	b = append(b, []byte{0x2e}...)

	return string(b)
}

var fnFmtCurrency_a6249ceef016228ba91ed7bf933a5843 = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 5 + 1*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				b = append(b, ln.group[0])
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	for j := len(symbol) - 1; j >= 0; j-- {
		b = append(b, symbol[j])
	}

	if num < 0 {
		for j := len(ln.minus) - 1; j >= 0; j-- {
			b = append(b, ln.minus[j])
		}
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	return string(b)
}

var fnFmtAccounting_ae41296c273457c904bdda366fe75145 = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 5 + 1*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				b = append(b, ln.group[0])
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {

		for j := len(symbol) - 1; j >= 0; j-- {
			b = append(b, symbol[j])
		}

		for j := len(ln.minus) - 1; j >= 0; j-- {
			b = append(b, ln.minus[j])
		}

	} else {
		for j := len(symbol) - 1; j >= 0; j-- {
			b = append(b, symbol[j])
		}
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	return string(b)
}

var fnFmtDateMedium_82c71fd71a19831d2abc525aff9a3a0e = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsAbbreviated[t.Month()]...)
	b = append(b, []byte{0xd8, 0x8c, 0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtDateLong_39d6f2c09ffa1cac410fe4d18df66a7c = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0xd8, 0x8c, 0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtDateFull_4d9460f3dccf0c21118fbf081ee2fe75 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = append(b, ln.daysWide[t.Weekday()]...)
	b = append(b, []byte{0xd8, 0x8c, 0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0xd8, 0x8c, 0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtCurrency_c079b862a25ea3e09b2b82e454b35d84 = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 7 + 1*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	inSecondary := false
	groupThreshold := 3

	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == groupThreshold {
				b = append(b, ln.group[0])
				count = 1

				if !inSecondary {
					inSecondary = true
					groupThreshold = 2
				}
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	for j := len(symbol) - 1; j >= 0; j-- {
		b = append(b, symbol[j])
	}

	for j := len(ln.currencyPositivePrefix) - 1; j >= 0; j-- {
		b = append(b, ln.currencyPositivePrefix[j])
	}

	if num < 0 {
		for j := len(ln.minus) - 1; j >= 0; j-- {
			b = append(b, ln.minus[j])
		}
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	return string(b)
}

var fnFmtAccounting_838c6cb50ab0f7d4efc4d33ce55bccb5 = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 7 + 1*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	inSecondary := false
	groupThreshold := 3

	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == groupThreshold {
				b = append(b, ln.group[0])
				count = 1

				if !inSecondary {
					inSecondary = true
					groupThreshold = 2
				}
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {

		for j := len(symbol) - 1; j >= 0; j-- {
			b = append(b, symbol[j])
		}

		for j := len(ln.currencyNegativePrefix) - 1; j >= 0; j-- {
			b = append(b, ln.currencyNegativePrefix[j])
		}

		for j := len(ln.minus) - 1; j >= 0; j-- {
			b = append(b, ln.minus[j])
		}

	} else {

		for j := len(symbol) - 1; j >= 0; j-- {
			b = append(b, symbol[j])
		}

		for j := len(ln.currencyPositivePrefix) - 1; j >= 0; j-- {
			b = append(b, ln.currencyPositivePrefix[j])
		}

	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	return string(b)
}

var fnFmtDateMedium_8ff89c88bdb727333d4c7b42f495646e = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2d}...)
	b = append(b, ln.monthsAbbreviated[t.Month()]...)
	b = append(b, []byte{0x2c, 0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtDateLong_af1ab393e97e5cd9bd5342a65130666d = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2d}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x2c, 0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtDateFull_ae39dfe33f097d30e514b77409da8997 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = append(b, ln.daysWide[t.Weekday()]...)
	b = append(b, []byte{0x2c, 0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x2d}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x2c, 0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtNumber_91f44359c32923b2c2a980df8ee6ab86 = func(ln *localen, num float64, v uint64) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	l := len(s) + 3 + 2*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			for j := len(ln.decimal) - 1; j >= 0; j-- {
				b = append(b, ln.decimal[j])
			}
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				for j := len(ln.group) - 1; j >= 0; j-- {
					b = append(b, ln.group[j])
				}
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {
		b = append(b, ln.minus[0])
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	return string(b)
}

var fnFmtPercent_141d2f250af9b9f46295bf60380ce0b2 = func(ln *localen, num float64, v uint64) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	l := len(s) + 5
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			for j := len(ln.decimal) - 1; j >= 0; j-- {
				b = append(b, ln.decimal[j])
			}
			continue
		}

		b = append(b, s[i])
	}

	if num < 0 {
		b = append(b, ln.minus[0])
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	b = append(b, ln.percent...)

	return string(b)
}

var fnFmtCurrency_ae69fea052716ee7e5be5d84e205ff0c = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 5 + 2*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			for j := len(ln.decimal) - 1; j >= 0; j-- {
				b = append(b, ln.decimal[j])
			}
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				for j := len(ln.group) - 1; j >= 0; j-- {
					b = append(b, ln.group[j])
				}
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {
		b = append(b, ln.minus[0])
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	b = append(b, ln.currencyPositiveSuffix...)

	b = append(b, symbol...)

	return string(b)
}

var fnFmtAccounting_c2fb1e60c1c0fac4b7a6ab96cbc4f79e = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 5 + 2*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			for j := len(ln.decimal) - 1; j >= 0; j-- {
				b = append(b, ln.decimal[j])
			}
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				for j := len(ln.group) - 1; j >= 0; j-- {
					b = append(b, ln.group[j])
				}
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {
		b = append(b, ln.minus[0])
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	if num < 0 {
		b = append(b, ln.currencyNegativeSuffix...)
		b = append(b, symbol...)
	} else {

		b = append(b, ln.currencyPositiveSuffix...)
		b = append(b, symbol...)
	}

	return string(b)
}

var fnFmtDateLong_3097d2288f3d500e25f72a56af6d0f39 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x20, 0xd9, 0x86, 0xda, 0x86, 0xdb, 0x8c, 0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtDateFull_64ae09e94f136aa33d4d0e5627a29872 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0x20, 0xd9, 0x86, 0xda, 0x86, 0xdb, 0x8c, 0x20, 0xdb, 0x8c, 0xdb, 0x8c, 0xd9, 0x84, 0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x20, 0xd9, 0x86, 0xda, 0x86, 0xdb, 0x8c, 0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x20}...)
	b = append(b, ln.daysWide[t.Weekday()]...)
	b = append(b, []byte{0x20, 0xda, 0xa9, 0xd9, 0x88, 0xd9, 0x86, 0xdb, 0x8c}...)

	return string(b)
}

var fnFmtDateMedium_c010b271f06248ba07bbc009fc58011a = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsAbbreviated[t.Month()]...)
	b = append(b, []byte{0x2e, 0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)

	return string(b)
}

var fnFmtDateFull_c73645256fa9ec42586084cc4fafc6f6 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x61}...)
	b = append(b, []byte{0x20, 0x64}...)
	b = append(b, []byte{0x2e, 0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x69, 0x64}...)

	return string(b)
}

var fnFmtDateFull_4f155c5d948146549d2721e09ed6c3a5 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = append(b, ln.daysWide[t.Weekday()]...)
	b = append(b, []byte{0x2c, 0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsAbbreviated[t.Month()]...)
	b = append(b, []byte{0x2c, 0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtAccounting_1942e97ed17a8864331f347260c0e63c = func(ln *localen, num float64, v uint64, currency currency.Type) string {
	s := strconv.FormatFloat(math.Abs(num), 'f', int(v), 64)
	symbol := ln.currencies[currency]
	l := len(s) + len(symbol) + 5 + 2*len(s[:len(s)-int(v)-1])/3
	count := 0
	inWhole := v == 0
	b := make([]byte, 0, l)

	for i := len(s) - 1; i >= 0; i-- {

		if s[i] == '.' {
			b = append(b, ln.decimal[0])
			inWhole = true
			continue
		}

		if inWhole {
			if count == 3 {
				for j := len(ln.group) - 1; j >= 0; j-- {
					b = append(b, ln.group[j])
				}
				count = 1
			} else {
				count++
			}
		}

		b = append(b, s[i])
	}

	if num < 0 {
		b = append(b, ln.currencyNegativePrefix[0])
	}

	// reverse
	for i, j := 0, len(b)-1; i < j; i, j = i+1, j-1 {
		b[i], b[j] = b[j], b[i]
	}

	if int(v) < 2 {

		if v == 0 {
			b = append(b, ln.decimal...)
		}

		for i := 0; i < 2-int(v); i++ {
			b = append(b, '0')
		}
	}

	if num < 0 {
		b = append(b, ln.currencyNegativeSuffix...)
		b = append(b, symbol...)
	} else {

		b = append(b, ln.currencyPositiveSuffix...)
		b = append(b, symbol...)
	}

	return string(b)
}

var fnFmtDateMedium_49f81df3f568828be8ec7cbfdfca6c87 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0xd7, 0x98, 0xd7, 0x9f, 0x20}...)
	b = append(b, ln.monthsAbbreviated[t.Month()]...)
	b = append(b, []byte{0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtDateLong_ed7a2ed783c0a089bae0b26415cf1eec = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0xd7, 0x98, 0xd7, 0x9f, 0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtDateFull_533def3ea33c7c5e7121653c4a4fcdfb = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = append(b, ln.daysWide[t.Weekday()]...)
	b = append(b, []byte{0x2c, 0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0xd7, 0x98, 0xd7, 0x9f, 0x20}...)
	b = append(b, ln.monthsWide[t.Month()]...)
	b = append(b, []byte{0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtDateMedium_5ee989ce4f98a493eab4c7b536fc1c06 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x20}...)

	if t.Month() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Month()), 10)

	b = append(b, []byte{0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtDateLong_39c28d689b0bc45d7cd36c6f85c85cd7 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsAbbreviated[t.Month()]...)
	b = append(b, []byte{0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtDateFull_ea32054fb13476ec6d17746ec03afe87 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = append(b, ln.daysWide[t.Weekday()]...)
	b = append(b, []byte{0x2c, 0x20}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0x20}...)
	b = append(b, ln.monthsAbbreviated[t.Month()]...)
	b = append(b, []byte{0x20}...)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	return string(b)
}

var fnFmtTimeShort_e9e37e884fba601b3fce4f8400a30c6f = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Hour()), 10)
	b = append(b, ln.timeSeparator...)
	b = strconv.AppendInt(b, int64(t.Minute()), 10)

	return string(b)
}

var fnFmtTimeMedium_f393bba636806dbcfe262f3337c404b9 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	b = strconv.AppendInt(b, int64(t.Hour()), 10)
	b = append(b, ln.timeSeparator...)
	b = strconv.AppendInt(b, int64(t.Minute()), 10)
	b = append(b, ln.timeSeparator...)
	b = strconv.AppendInt(b, int64(t.Second()), 10)

	return string(b)
}

var fnFmtDateMedium_e83a3603c198d93a096d54a7bede682f = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0xe5, 0xb9, 0xb4}...)
	b = strconv.AppendInt(b, int64(t.Month()), 10)
	b = append(b, []byte{0xe6, 0x9c, 0x88}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0xe6, 0x97, 0xa5}...)

	return string(b)
}

var fnFmtDateFull_6d25552b54ab93154d7e7cda033add2e = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Year() > 0 {
		b = strconv.AppendInt(b, int64(t.Year()), 10)
	} else {
		b = strconv.AppendInt(b, int64(-t.Year()), 10)
	}

	b = append(b, []byte{0xe5, 0xb9, 0xb4}...)
	b = strconv.AppendInt(b, int64(t.Month()), 10)
	b = append(b, []byte{0xe6, 0x9c, 0x88}...)
	b = strconv.AppendInt(b, int64(t.Day()), 10)
	b = append(b, []byte{0xe6, 0x97, 0xa5, 0x20}...)
	b = append(b, ln.daysWide[t.Weekday()]...)

	return string(b)
}

var fnFmtTimeShort_9f509c771840c0382f2405c11cafea81 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Hour() < 12 {
		b = append(b, ln.periodsAbbreviated[0]...)
	} else {
		b = append(b, ln.periodsAbbreviated[1]...)
	}

	h := t.Hour()

	if h > 12 {
		h -= 12
	}

	b = strconv.AppendInt(b, int64(h), 10)
	b = append(b, ln.timeSeparator...)

	if t.Minute() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Minute()), 10)

	return string(b)
}

var fnFmtTimeMedium_579c5023c7d020b1a788cc6150e20837 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Hour() < 12 {
		b = append(b, ln.periodsAbbreviated[0]...)
	} else {
		b = append(b, ln.periodsAbbreviated[1]...)
	}

	h := t.Hour()

	if h > 12 {
		h -= 12
	}

	b = strconv.AppendInt(b, int64(h), 10)
	b = append(b, ln.timeSeparator...)

	if t.Minute() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Minute()), 10)
	b = append(b, ln.timeSeparator...)

	if t.Second() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Second()), 10)

	return string(b)
}

var fnFmtTimeLong_066f4a7ef090319bead51e861a2409ee = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Hour() < 12 {
		b = append(b, ln.periodsAbbreviated[0]...)
	} else {
		b = append(b, ln.periodsAbbreviated[1]...)
	}

	h := t.Hour()

	if h > 12 {
		h -= 12
	}

	b = strconv.AppendInt(b, int64(h), 10)
	b = append(b, ln.timeSeparator...)

	if t.Minute() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Minute()), 10)
	b = append(b, ln.timeSeparator...)

	if t.Second() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Second()), 10)
	b = append(b, []byte{0x20, 0x5b}...)

	tz, _ := t.Zone()
	b = append(b, tz...)

	b = append(b, []byte{0x5d}...)

	return string(b)
}

var fnFmtTimeFull_955bae3e8c2964b403b90a298b7811eb = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	if t.Hour() < 12 {
		b = append(b, ln.periodsAbbreviated[0]...)
	} else {
		b = append(b, ln.periodsAbbreviated[1]...)
	}

	h := t.Hour()

	if h > 12 {
		h -= 12
	}

	b = strconv.AppendInt(b, int64(h), 10)
	b = append(b, ln.timeSeparator...)

	if t.Minute() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Minute()), 10)
	b = append(b, ln.timeSeparator...)

	if t.Second() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Second()), 10)
	b = append(b, []byte{0x20, 0x5b}...)

	tz, _ := t.Zone()

	if btz, ok := ln.timezones[tz]; ok {
		b = append(b, btz...)
	} else {
		b = append(b, tz...)
	}

	b = append(b, []byte{0x5d}...)

	return string(b)
}

var fnFmtTimeLong_f6f1bc554d362da062ec4bd6342712a8 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	tz, _ := t.Zone()
	b = append(b, tz...)

	b = append(b, []byte{0x20}...)

	if t.Hour() < 12 {
		b = append(b, ln.periodsAbbreviated[0]...)
	} else {
		b = append(b, ln.periodsAbbreviated[1]...)
	}

	h := t.Hour()

	if h > 12 {
		h -= 12
	}

	b = strconv.AppendInt(b, int64(h), 10)
	b = append(b, ln.timeSeparator...)

	if t.Minute() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Minute()), 10)
	b = append(b, ln.timeSeparator...)

	if t.Second() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Second()), 10)

	return string(b)
}

var fnFmtTimeFull_5fa5cff63ea7e227b81649a7dbc0a657 = func(ln *localen, t time.Time) string {
	b := make([]byte, 0, 32)

	tz, _ := t.Zone()

	if btz, ok := ln.timezones[tz]; ok {
		b = append(b, btz...)
	} else {
		b = append(b, tz...)
	}

	b = append(b, []byte{0x20}...)

	if t.Hour() < 12 {
		b = append(b, ln.periodsAbbreviated[0]...)
	} else {
		b = append(b, ln.periodsAbbreviated[1]...)
	}

	h := t.Hour()

	if h > 12 {
		h -= 12
	}

	b = strconv.AppendInt(b, int64(h), 10)
	b = append(b, ln.timeSeparator...)

	if t.Minute() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Minute()), 10)
	b = append(b, ln.timeSeparator...)

	if t.Second() < 10 {
		b = append(b, '0')
	}

	b = strconv.AppendInt(b, int64(t.Second()), 10)

	return string(b)
}

type localen struct {
	currencies             []string
	currencyNegativePrefix string
	currencyNegativeSuffix string
	currencyPositivePrefix string
	currencyPositiveSuffix string
	daysAbbreviated        []string
	daysNarrow             []string
	daysShort              []string
	daysWide               []string
	decimal                string
	erasAbbreviated        []string
	erasNarrow             []string
	erasWide               []string
	fnCardinalPluralRule   func(ln *localen, num float64, v uint64) locales.PluralRule
	fnDecimal              func(ln *localen) string
	fnFmtAccounting        func(ln *localen, num float64, v uint64, currency currency.Type) string
	fnFmtCurrency          func(ln *localen, num float64, v uint64, currency currency.Type) string
	fnFmtDateFull          func(ln *localen, t time.Time) string
	fnFmtDateLong          func(ln *localen, t time.Time) string
	fnFmtDateMedium        func(ln *localen, t time.Time) string
	fnFmtDateShort         func(ln *localen, t time.Time) string
	fnFmtNumber            func(ln *localen, num float64, v uint64) string
	fnFmtPercent           func(ln *localen, num float64, v uint64) string
	fnFmtTimeFull          func(ln *localen, t time.Time) string
	fnFmtTimeLong          func(ln *localen, t time.Time) string
	fnFmtTimeMedium        func(ln *localen, t time.Time) string
	fnFmtTimeShort         func(ln *localen, t time.Time) string
	fnGroup                func(ln *localen) string
	fnLocale               func(ln *localen) string
	fnMinus                func(ln *localen) string
	fnMonthAbbreviated     func(ln *localen, month time.Month) string
	fnMonthNarrow          func(ln *localen, month time.Month) string
	fnMonthWide            func(ln *localen, month time.Month) string
	fnMonthsAbbreviated    func(ln *localen) []string
	fnMonthsNarrow         func(ln *localen) []string
	fnMonthsWide           func(ln *localen) []string
	fnOrdinalPluralRule    func(ln *localen, num float64, v uint64) locales.PluralRule
	fnPluralsCardinal      func(ln *localen) []locales.PluralRule
	fnPluralsOrdinal       func(ln *localen) []locales.PluralRule
	fnPluralsRange         func(ln *localen) []locales.PluralRule
	fnRangePluralRule      func(ln *localen, num1 float64, v1 uint64, num2 float64, v2 uint64) locales.PluralRule
	fnWeekdayAbbreviated   func(ln *localen, weekday time.Weekday) string
	fnWeekdayNarrow        func(ln *localen, weekday time.Weekday) string
	fnWeekdayShort         func(ln *localen, weekday time.Weekday) string
	fnWeekdayWide          func(ln *localen, weekday time.Weekday) string
	fnWeekdaysAbbreviated  func(ln *localen) []string
	fnWeekdaysNarrow       func(ln *localen) []string
	fnWeekdaysShort        func(ln *localen) []string
	fnWeekdaysWide         func(ln *localen) []string
	group                  string
	inifinity              string
	locale                 string
	minus                  string
	monthsAbbreviated      []string
	monthsNarrow           []string
	monthsWide             []string
	perMille               string
	percent                string
	percentPrefix          string
	percentSuffix          string
	periodsAbbreviated     []string
	periodsNarrow          []string
	periodsShort           []string
	periodsWide            []string
	pluralsCardinal        []locales.PluralRule
	pluralsOrdinal         []locales.PluralRule
	pluralsRange           []locales.PluralRule
	timeSeparator          string
	timezones              map[string]string
}

func init() {
	translatorFuncs["af"] = func() locales.Translator {
		return &localen{

			locale:                 "af",
			pluralsCardinal:        []locales.PluralRule{2, 6},
			pluralsOrdinal:         []locales.PluralRule{6},
			pluralsRange:           []locales.PluralRule{6},
			decimal:                ",",
			group:                  " ",
			minus:                  "-",
			percent:                "%",
			perMille:               "‰",
			timeSeparator:          ":",
			inifinity:              "∞",
			currencies:             []string{"ADP", "AED", "AFA", "AFN", "ALK", "ALL", "AMD", "ANG", "AOA", "AOK", "AON", "AOR", "ARA", "ARL", "ARM", "ARP", "ARS", "ATS", "A$", "AWG", "AZM", "AZN", "BAD", "BAM", "BAN", "BBD", "BDT", "BEC", "BEF", "BEL", "BGL", "BGM", "BGN", "BGO", "BHD", "BIF", "BMD", "BND", "BOB", "BOL", "BOP", "BOV", "BRB", "BRC", "BRE", "R$", "BRN", "BRR", "BRZ", "BSD", "BTN", "BUK", "BWP", "BYB", "BYN", "BYR", "BZD", "CAD", "CDF", "CHE", "CHF", "CHW", "CLE", "CLF", "CLP", "CNH", "CNX", "CN¥", "COP", "COU", "CRC", "CSD", "CSK", "CUC", "CUP", "CVE", "CYP", "CZK", "DDM", "DEM", "DJF", "DKK", "DOP", "DZD", "ECS", "ECV", "EEK", "EGP", "ERN", "ESA", "ESB", "ESP", "ETB", "€", "FIM", "FJD", "FKP", "FRF", "£", "GEK", "GEL", "GHC", "GHS", "GIP", "GMD", "GNF", "GNS", "GQE", "GRD", "GTQ", "GWE", "GWP", "GYD", "HK$", "HNL", "HRD", "HRK", "HTG", "HUF", "IDR", "IEP", "ILP", "ILR", "₪", "₹", "IQD", "IRR", "ISJ", "ISK", "ITL", "JMD", "JOD", "JP¥", "KES", "KGS", "KHR", "KMF", "KPW", "KRH", "KRO", "₩", "KWD", "KYD", "KZT", "LAK", "LBP", "LKR", "LRD", "LSL", "LTL", "LTT", "LUC", "LUF", "LUL", "LVL", "LVR", "LYD", "MAD", "MAF", "MCF", "MDC", "MDL", "MGA", "MGF", "MKD", "MKN", "MLF", "MMK", "MNT", "MOP", "MRO", "MRU", "MTL", "MTP", "MUR", "MVP", "MVR", "MWK", "MXN", "MXP", "MXV", "MYR", "MZE", "MZM", "MZN", "NAD", "NGN", "NIC", "NIO", "NLG", "NOK", "NPR", "NZ$", "OMR", "PAB", "PEI", "PEN", "PES", "PGK", "PHP", "PKR", "PLN", "PLZ", "PTE", "PYG", "QAR", "RHD", "ROL", "RON", "RSD", "RUB", "RUR", "RWF", "SAR", "SBD", "SCR", "SDD", "SDG", "SDP", "SEK", "SGD", "SHP", "SIT", "SKK", "SLL", "SOS", "SRD", "SRG", "SSP", "STD", "STN", "SUR", "SVC", "SYP", "SZL", "฿", "TJR", "TJS", "TMM", "TMT", "TND", "TOP", "TPE", "TRL", "TRY", "TTD", "NT$", "TZS", "UAH", "UAK", "UGS", "UGX", "USD", "USN", "USS", "UYI", "UYP", "UYU", "UYW", "UZS", "VEB", "VEF", "VES", "₫", "VNN", "VUV", "WST", "FCFA", "XAG", "XAU", "XBA", "XBB", "XBC", "XBD", "EC$", "XDR", "XEU", "XFO", "XFU", "CFA", "XPD", "CFPF", "XPT", "XRE", "XSU", "XTS", "XUA", "XXX", "YDD", "YER", "YUD", "YUM", "YUN", "YUR", "ZAL", "R", "ZMK", "ZMW", "ZRN", "ZRZ", "ZWD", "ZWL", "ZWR"},
			currencyNegativePrefix: "(",
			currencyNegativeSuffix: ")",
			monthsAbbreviated:      []string{"", "Jan.", "Feb.", "Mrt.", "Apr.", "Mei", "Jun.", "Jul.", "Aug.", "Sep.", "Okt.", "Nov.", "Des."},
			monthsNarrow:           []string{"", "J", "F", "M", "A", "M", "J", "J", "A", "S", "O", "N", "D"},
			monthsWide:             []string{"", "Januarie", "Februarie", "Maart", "April", "Mei", "Junie", "Julie", "Augustus", "September", "Oktober", "November", "Desember"},
			daysAbbreviated:        []string{"So.", "Ma.", "Di.", "Wo.", "Do.", "Vr.", "Sa."},
			daysNarrow:             []string{"S", "M", "D", "W", "D", "V", "S"},
			daysShort:              []string{"So.", "Ma.", "Di.", "Wo.", "Do.", "Vr.", "Sa."},
			daysWide:               []string{"Sondag", "Maandag", "Dinsdag", "Woensdag", "Donderdag", "Vrydag", "Saterdag"},
			periodsAbbreviated:     []string{"vm.", "nm."},
			periodsNarrow:          []string{"v", "n"},
			periodsWide:            []string{"vm.", "nm."},
			erasAbbreviated:        []string{"v.C.", "n.C."},
			erasNarrow:             []string{"v.C.", "n.C."},
			erasWide:               []string{"voor Christus", "na Christus"},
			timezones:              map[string]string{"ACDT": "Sentraal-Australiese dagligtyd", "ACST": "Sentraal-Australiese standaardtyd", "ACWDT": "Sentraal-westelike Australiese dagligtyd", "ACWST": "Sentraal-westelike Australiese standaard-tyd", "ADT": "Atlantiese dagligtyd", "AEDT": "Oostelike Australiese dagligtyd", "AEST": "Oostelike Australiese standaardtyd", "AKDT": "Alaska-dagligtyd", "AKST": "Alaska-standaardtyd", "ARST": "Argentinië-somertyd", "ART": "Argentinië-standaardtyd", "AST": "Atlantiese standaardtyd", "AWDT": "Westelike Australiese dagligtyd", "AWST": "Westelike Australiese standaardtyd", "BOT": "Bolivia-tyd", "BT": "Bhoetan-tyd", "CAT": "Sentraal-Afrika-tyd", "CDT": "Noord-Amerikaanse sentrale dagligtyd", "CHADT": "Chatham-dagligtyd", "CHAST": "Chatham-standaardtyd", "CLST": "Chili-somertyd", "CLT": "Chili-standaardtyd", "COST": "Colombia-somertyd", "COT": "Colombië-standaardtyd", "CST": "Noord-Amerikaanse sentrale standaardtyd", "ChST": "Chamorro-standaardtyd", "EAT": "Oos-Afrika-tyd", "ECT": "Ecuador-tyd", "EDT": "Noord-Amerikaanse oostelike dagligtyd", "EST": "Noord-Amerikaanse oostelike standaardtyd", "GFT": "Frans-Guiana-tyd", "GMT": "Greenwich-tyd", "GST": "Persiese Golf-standaardtyd", "GYT": "Guyana-tyd", "HADT": "Hawaii-Aleoete-dagligtyd", "HAST": "Hawaii-Aleoete-standaardtyd", "HAT": "Newfoundland-dagligtyd", "HECU": "Kuba-dagligtyd", "HEEG": "Oos-Groenland-somertyd", "HENOMX": "Noordwes-Meksiko-dagligtyd", "HEOG": "Wes-Groenland-somertyd", "HEPM": "Sint-Pierre en Miquelon-dagligtyd", "HEPMX": "Meksikaanse Pasifiese dagligtyd", "HKST": "Hongkong-somertyd", "HKT": "Hongkong-standaardtyd", "HNCU": "Kuba-standaardtyd", "HNEG": "Oos-Groenland-standaardtyd", "HNNOMX": "Noordwes-Meksiko-standaardtyd", "HNOG": "Wes-Groenland-standaardtyd", "HNPM": "Sint-Pierre en Miquelon-standaardtyd", "HNPMX": "Meksikaanse Pasifiese standaardtyd", "HNT": "Newfoundland-standaardtyd", "IST": "Indië-standaardtyd", "JDT": "Japan-dagligtyd", "JST": "Japan-standaardtyd", "LHDT": "Lord Howe-dagligtyd", "LHST": "Lord Howe-standaardtyd", "MDT": "Noord-Amerikaanse berg-dagligtyd", "MESZ": "Sentraal-Europese somertyd", "MEZ": "Sentraal-Europese standaardtyd", "MST": "Noord-Amerikaanse berg-standaardtyd", "MYT": "Maleisië-tyd", "NZDT": "Nieu-Seeland-dagligtyd", "NZST": "Nieu-Seeland-standaardtyd", "OESZ": "Oos-Europese somertyd", "OEZ": "Oos-Europese standaardtyd", "PDT": "Pasifiese dagligtyd", "PST": "Pasifiese standaardtyd", "SAST": "Suid-Afrika-standaardtyd", "SGT": "Singapoer-standaardtyd", "SRT": "Suriname-tyd", "TMST": "Turkmenistan-somertyd", "TMT": "Turkmenistan-standaardtyd", "UYST": "Uruguay-somertyd", "UYT": "Uruguay-standaardtyd", "VET": "Venezuela-tyd", "WARST": "Wes-Argentinië-somertyd", "WART": "Wes-Argentinië-standaardtyd", "WAST": "Wes-Afrika-somertyd", "WAT": "Wes-Afrika-standaardtyd", "WESZ": "Wes-Europese somertyd", "WEZ": "Wes-Europese standaardtyd", "WIB": "Wes-Indonesië-tyd", "WIT": "Oos-Indonesië-tyd", "WITA": "Sentraal-Indonesiese tyd", "∅∅∅": "Brasilia-somertyd"},

			fnCardinalPluralRule:  fnCardinalPluralRule_0758171f702b5b6024bdf47d25d8166d,
			fnDecimal:             fnDecimal_a78485e7dd32c95f41af4e18420793bf,
			fnFmtAccounting:       fnFmtAccounting_ee2956d02335482ec6b7e9a423beb0b5,
			fnFmtCurrency:         fnFmtCurrency_ec1a372391d9fcdfb2e025fe6142dc3b,
			fnFmtDateFull:         fnFmtDateFull_aa89072e939f6d411d6d93fa47eed117,
			fnFmtDateLong:         fnFmtDateLong_85907dc745b1a23de90d4a44c3222404,
			fnFmtDateMedium:       fnFmtDateMedium_358c9403a9e4cad0b8974bed45e6527c,
			fnFmtDateShort:        fnFmtDateShort_93e0dc80e7e3deca3036cf894d743e0e,
			fnFmtNumber:           fnFmtNumber_0866206624669dc4f03297eb76a545b2,
			fnFmtPercent:          fnFmtPercent_1c35b3868bf10d0e69b22b2e80c40671,
			fnFmtTimeFull:         fnFmtTimeFull_ebdf96de1e47f9043145564c500ef7dc,
			fnFmtTimeLong:         fnFmtTimeLong_987bec4676d3a5de4218e415e123649d,
			fnFmtTimeMedium:       fnFmtTimeMedium_b6f697552cd4965cd1195fe56dc87003,
			fnFmtTimeShort:        fnFmtTimeShort_8ffba4d1a2f04a0a6486853d76cf434b,
			fnGroup:               fnGroup_5c4b80a5ccdee81467241784ab8fcd56,
			fnLocale:              fnLocale_5a217059c67094defae82f249f55f4c5,
			fnMinus:               fnMinus_8b8229905258388dc16a5e0c270b0488,
			fnMonthAbbreviated:    fnMonthAbbreviated_aa9a9957cd9d056ba078b36a08b17478,
			fnMonthNarrow:         fnMonthNarrow_45916040ecf6fc350894d9e3e6c46dc7,
			fnMonthWide:           fnMonthWide_4c946a7e7581c665e7407df1841810b5,
			fnMonthsAbbreviated:   fnMonthsAbbreviated_181f77804b62232997fae36bd57d6cf7,
			fnMonthsNarrow:        fnMonthsNarrow_75daa2ba82ae9577292175c3f52370cc,
			fnMonthsWide:          fnMonthsWide_0ecf36a8b72255e2fee9467af362e989,
			fnOrdinalPluralRule:   fnOrdinalPluralRule_3355865f05dde9af2a36ba415bea85cb,
			fnPluralsCardinal:     fnPluralsCardinal_85b19cac1fab9f2c2cfb9eb41539aa0e,
			fnPluralsOrdinal:      fnPluralsOrdinal_16a60aa09da9778fa82fe463e83076de,
			fnPluralsRange:        fnPluralsRange_332465bda13eb808b3664fa0500f54ce,
			fnRangePluralRule:     fnRangePluralRule_91a918d93f773c0b7589da5ebb6c4164,
			fnWeekdayAbbreviated:  fnWeekdayAbbreviated_4ffbdfbd2be10e6bd8fb5a542a14664a,
			fnWeekdayNarrow:       fnWeekdayNarrow_e86921b3446df5ea9afe9504cfa20d1a,
			fnWeekdayShort:        fnWeekdayShort_82b231d4f504c6d71c7e495aa35cd3c2,
			fnWeekdayWide:         fnWeekdayWide_ab7e026d8685cefd89c5aeb5df512a9a,
			fnWeekdaysAbbreviated: fnWeekdaysAbbreviated_454a3d7d23c662520a64ae5245d404be,
			fnWeekdaysNarrow:      fnWeekdaysNarrow_d23eb0b7a498c40ce19d1bf231cad524,
			fnWeekdaysShort:       fnWeekdaysShort_eb6ee64d01e314991432b4469790d38b,
			fnWeekdaysWide:        fnWeekdaysWide_5e2bbf75a31e730429c100e8a0bd3ebd,
		}
	}
	translatorFuncs["af_na"] = func() locales.Translator {
		return &localen{

			locale:                 "af_NA",
			pluralsCardinal:        []locales.PluralRule{2, 6},
			pluralsOrdinal:         []locales.PluralRule{6},
			pluralsRange:           []locales.PluralRule{6},
			decimal:                ",",
			group:                  " ",
			minus:                  "-",
			percent:                "%",
			perMille:               "‰",
			timeSeparator:          ":",
			inifinity:              "∞",
			currencies:             []string{"ADP", "AED", "AFA", "AFN", "ALK", "ALL", "AMD", "ANG", "AOA", "AOK", "AON", "AOR", "ARA", "ARL", "ARM", "ARP", "ARS", "ATS", "AUD", "AWG", "AZM", "AZN", "BAD", "BAM", "BAN", "BBD", "BDT", "BEC", "BEF", "BEL", "BGL", "BGM", "BGN", "BGO", "BHD", "BIF", "BMD", "BND", "BOB", "BOL", "BOP", "BOV", "BRB", "BRC", "BRE", "BRL", "BRN", "BRR", "BRZ", "BSD", "BTN", "BUK", "BWP", "BYB", "BYN", "BYR", "BZD", "CAD", "CDF", "CHE", "CHF", "CHW", "CLE", "CLF", "CLP", "CNH", "CNX", "CNY", "COP", "COU", "CRC", "CSD", "CSK", "CUC", "CUP", "CVE", "CYP", "CZK", "DDM", "DEM", "DJF", "DKK", "DOP", "DZD", "ECS", "ECV", "EEK", "EGP", "ERN", "ESA", "ESB", "ESP", "ETB", "EUR", "FIM", "FJD", "FKP", "FRF", "GBP", "GEK", "GEL", "GHC", "GHS", "GIP", "GMD", "GNF", "GNS", "GQE", "GRD", "GTQ", "GWE", "GWP", "GYD", "HKD", "HNL", "HRD", "HRK", "HTG", "HUF", "IDR", "IEP", "ILP", "ILR", "ILS", "INR", "IQD", "IRR", "ISJ", "ISK", "ITL", "JMD", "JOD", "JPY", "KES", "KGS", "KHR", "KMF", "KPW", "KRH", "KRO", "KRW", "KWD", "KYD", "KZT", "LAK", "LBP", "LKR", "LRD", "LSL", "LTL", "LTT", "LUC", "LUF", "LUL", "LVL", "LVR", "LYD", "MAD", "MAF", "MCF", "MDC", "MDL", "MGA", "MGF", "MKD", "MKN", "MLF", "MMK", "MNT", "MOP", "MRO", "MRU", "MTL", "MTP", "MUR", "MVP", "MVR", "MWK", "MXN", "MXP", "MXV", "MYR", "MZE", "MZM", "MZN", "$", "NGN", "NIC", "NIO", "NLG", "NOK", "NPR", "NZD", "OMR", "PAB", "PEI", "PEN", "PES", "PGK", "PHP", "PKR", "PLN", "PLZ", "PTE", "PYG", "QAR", "RHD", "ROL", "RON", "RSD", "RUB", "RUR", "RWF", "SAR", "SBD", "SCR", "SDD", "SDG", "SDP", "SEK", "SGD", "SHP", "SIT", "SKK", "SLL", "SOS", "SRD", "SRG", "SSP", "STD", "STN", "SUR", "SVC", "SYP", "SZL", "THB", "TJR", "TJS", "TMM", "TMT", "TND", "TOP", "TPE", "TRL", "TRY", "TTD", "TWD", "TZS", "UAH", "UAK", "UGS", "UGX", "USD", "USN", "USS", "UYI", "UYP", "UYU", "UYW", "UZS", "VEB", "VEF", "VES", "VND", "VNN", "VUV", "WST", "XAF", "XAG", "XAU", "XBA", "XBB", "XBC", "XBD", "XCD", "XDR", "XEU", "XFO", "XFU", "XOF", "XPD", "XPF", "XPT", "XRE", "XSU", "XTS", "XUA", "XXX", "YDD", "YER", "YUD", "YUM", "YUN", "YUR", "ZAL", "ZAR", "ZMK", "ZMW", "ZRN", "ZRZ", "ZWD", "ZWL", "ZWR"},
			currencyNegativePrefix: "(",
			currencyNegativeSuffix: ")",
			monthsAbbreviated:      []string{"", "Jan.", "Feb.", "Mrt.", "Apr.", "Mei", "Jun.", "Jul.", "Aug.", "Sep.", "Okt.", "Nov.", "Des."},
			monthsNarrow:           []string{"", "J", "F", "M", "A", "M", "J", "J", "A", "S", "O", "N", "D"},
			monthsWide:             []string{"", "Januarie", "Februarie", "Maart", "April", "Mei", "Junie", "Julie", "Augustus", "September", "Oktober", "November", "Desember"},
			daysAbbreviated:        []string{"So.", "Ma.", "Di.", "Wo.", "Do.", "Vr.", "Sa."},
			daysNarrow:             []string{"S", "M", "D", "W", "D", "V", "S"},
			daysShort:              []string{"So.", "Ma.", "Di.", "Wo.", "Do.", "Vr.", "Sa."},
			daysWide:               []string{"Sondag", "Maandag", "Dinsdag", "Woensdag", "Donderdag", "Vrydag", "Saterdag"},
			periodsAbbreviated:     []string{"vm.", "nm."},
			periodsNarrow:          []string{"v", "n"},
			periodsWide:            []string{"vm.", "nm."},
			erasAbbreviated:        []string{"v.C.", "n.C."},
			erasNarrow:             []string{"v.C.", "n.C."},
			erasWide:               []string{"voor Christus", "na Christus"},
			timezones:              map[string]string{"ACDT": "Sentraal-Australiese dagligtyd", "ACST": "Sentraal-Australiese standaardtyd", "ACWDT": "Sentraal-westelike Australiese dagligtyd", "ACWST": "Sentraal-westelike Australiese standaard-tyd", "ADT": "Atlantiese dagligtyd", "AEDT": "Oostelike Australiese dagligtyd", "AEST": "Oostelike Australiese standaardtyd", "AKDT": "Alaska-dagligtyd", "AKST": "Alaska-standaardtyd", "ARST": "Argentinië-somertyd", "ART": "Argentinië-standaardtyd", "AST": "Atlantiese standaardtyd", "AWDT": "Westelike Australiese dagligtyd", "AWST": "Westelike Australiese standaardtyd", "BOT": "Bolivia-tyd", "BT": "Bhoetan-tyd", "CAT": "Sentraal-Afrika-tyd", "CDT": "Noord-Amerikaanse sentrale dagligtyd", "CHADT": "Chatham-dagligtyd", "CHAST": "Chatham-standaardtyd", "CLST": "Chili-somertyd", "CLT": "Chili-standaardtyd", "COST": "Colombia-somertyd", "COT": "Colombië-standaardtyd", "CST": "Noord-Amerikaanse sentrale standaardtyd", "ChST": "Chamorro-standaardtyd", "EAT": "Oos-Afrika-tyd", "ECT": "Ecuador-tyd", "EDT": "Noord-Amerikaanse oostelike dagligtyd", "EST": "Noord-Amerikaanse oostelike standaardtyd", "GFT": "Frans-Guiana-tyd", "GMT": "Greenwich-tyd", "GST": "Persiese Golf-standaardtyd", "GYT": "Guyana-tyd", "HADT": "Hawaii-Aleoete-dagligtyd", "HAST": "Hawaii-Aleoete-standaardtyd", "HAT": "Newfoundland-dagligtyd", "HECU": "Kuba-dagligtyd", "HEEG": "Oos-Groenland-somertyd", "HENOMX": "Noordwes-Meksiko-dagligtyd", "HEOG": "Wes-Groenland-somertyd", "HEPM": "Sint-Pierre en Miquelon-dagligtyd", "HEPMX": "Meksikaanse Pasifiese dagligtyd", "HKST": "Hongkong-somertyd", "HKT": "Hongkong-standaardtyd", "HNCU": "Kuba-standaardtyd", "HNEG": "Oos-Groenland-standaardtyd", "HNNOMX": "Noordwes-Meksiko-standaardtyd", "HNOG": "Wes-Groenland-standaardtyd", "HNPM": "Sint-Pierre en Miquelon-standaardtyd", "HNPMX": "Meksikaanse Pasifiese standaardtyd", "HNT": "Newfoundland-standaardtyd", "IST": "Indië-standaardtyd", "JDT": "Japan-dagligtyd", "JST": "Japan-standaardtyd", "LHDT": "Lord Howe-dagligtyd", "LHST": "Lord Howe-standaardtyd", "MDT": "Noord-Amerikaanse berg-dagligtyd", "MESZ": "Sentraal-Europese somertyd", "MEZ": "Sentraal-Europese standaardtyd", "MST": "Noord-Amerikaanse berg-standaardtyd", "MYT": "Maleisië-tyd", "NZDT": "Nieu-Seeland-dagligtyd", "NZST": "Nieu-Seeland-standaardtyd", "OESZ": "Oos-Europese somertyd", "OEZ": "Oos-Europese standaardtyd", "PDT": "Pasifiese dagligtyd", "PST": "Pasifiese standaardtyd", "SAST": "Suid-Afrika-standaardtyd", "SGT": "Singapoer-standaardtyd", "SRT": "Suriname-tyd", "TMST": "Turkmenistan-somertyd", "TMT": "Turkmenistan-standaardtyd", "UYST": "Uruguay-somertyd", "UYT": "Uruguay-standaardtyd", "VET": "Venezuela-tyd", "WARST": "Wes-Argentinië-somertyd", "WART": "Wes-Argentinië-standaardtyd", "WAST": "Wes-Afrika-somertyd", "WAT": "Wes-Afrika-standaardtyd", "WESZ": "Wes-Europese somertyd", "WEZ": "Wes-Europese standaardtyd", "WIB": "Wes-Indonesië-tyd", "WIT": "Oos-Indonesië-tyd", "WITA": "Sentraal-Indonesiese tyd", "∅∅∅": "Asore-somertyd"},

			fnCardinalPluralRule:  fnCardinalPluralRule_0758171f702b5b6024bdf47d25d8166d,
			fnDecimal:             fnDecimal_a78485e7dd32c95f41af4e18420793bf,
			fnFmtAccounting:       fnFmtAccounting_ee2956d02335482ec6b7e9a423beb0b5,
			fnFmtCurrency:         fnFmtCurrency_ec1a372391d9fcdfb2e025fe6142dc3b,
			fnFmtDateFull:         fnFmtDateFull_e5aac3b796a648ed7f4aaa501e4e3844,
			fnFmtDateLong:         fnFmtDateLong_506f643cda0514f66d873a9ea99bf639,
			fnFmtDateMedium:       fnFmtDateMedium_cb43e8c32d5cd0a27ac6db293a7981fd,
			fnFmtDateShort:        fnFmtDateShort_93e0dc80e7e3deca3036cf894d743e0e,
			fnFmtNumber:           fnFmtNumber_0866206624669dc4f03297eb76a545b2,
			fnFmtPercent:          fnFmtPercent_1c35b3868bf10d0e69b22b2e80c40671,
			fnFmtTimeFull:         fnFmtTimeFull_37fe4deeee789852cc196a6a1a2f0ccc,
			fnFmtTimeLong:         fnFmtTimeLong_4429ef4fb58a2a9c4d7d5132fd16ecbf,
			fnFmtTimeMedium:       fnFmtTimeMedium_8ef07f6477b7a4944577d4e5392ff21b,
			fnFmtTimeShort:        fnFmtTimeShort_8288b817c5c0216c9815524c71c9e0b4,
			fnGroup:               fnGroup_5c4b80a5ccdee81467241784ab8fcd56,
			fnLocale:              fnLocale_5a217059c67094defae82f249f55f4c5,
			fnMinus:               fnMinus_8b8229905258388dc16a5e0c270b0488,
			fnMonthAbbreviated:    fnMonthAbbreviated_aa9a9957cd9d056ba078b36a08b17478,
			fnMonthNarrow:         fnMonthNarrow_45916040ecf6fc350894d9e3e6c46dc7,
			fnMonthWide:           fnMonthWide_4c946a7e7581c665e7407df1841810b5,
			fnMonthsAbbreviated:   fnMonthsAbbreviated_181f77804b62232997fae36bd57d6cf7,
			fnMonthsNarrow:        fnMonthsNarrow_75daa2ba82ae9577292175c3f52370cc,
			fnMonthsWide:          fnMonthsWide_0ecf36a8b72255e2fee9467af362e989,
			fnOrdinalPluralRule:   fnOrdinalPluralRule_3355865f05dde9af2a36ba415bea85cb,
			fnPluralsCardinal:     fnPluralsCardinal_85b19cac1fab9f2c2cfb9eb41539aa0e,
			fnPluralsOrdinal:      fnPluralsOrdinal_16a60aa09da9778fa82fe463e83076de,
			fnPluralsRange:        fnPluralsRange_332465bda13eb808b3664fa0500f54ce,
			fnRangePluralRule:     fnRangePluralRule_91a918d93f773c0b7589da5ebb6c4164,
			fnWeekdayAbbreviated:  fnWeekdayAbbreviated_4ffbdfbd2be10e6bd8fb5a542a14664a,
			fnWeekdayNarrow:       fnWeekdayNarrow_e86921b3446df5ea9afe9504cfa20d1a,
			fnWeekdayShort:        fnWeekdayShort_82b231d4f504c6d71c7e495aa35cd3c2,
			fnWeekdayWide:         fnWeekdayWide_ab7e026d8685cefd89c5aeb5df512a9a,
			fnWeekdaysAbbreviated: fnWeekdaysAbbreviated_454a3d7d23c662520a64ae5245d404be,
			fnWeekdaysNarrow:      fnWeekdaysNarrow_d23eb0b7a498c40ce19d1bf231cad524,
			fnWeekdaysShort:       fnWeekdaysShort_eb6ee64d01e314991432b4469790d38b,
			fnWeekdaysWide:        fnWeekdaysWide_5e2bbf75a31e730429c100e8a0bd3ebd,
		}
	}
	translatorFuncs["af_za"] = func() locales.Translator {
		return &localen{

			locale:                 "af_ZA",
			pluralsCardinal:        []locales.PluralRule{2, 6},
			pluralsOrdinal:         []locales.PluralRule{6},
			pluralsRange:           []locales.PluralRule{6},
			decimal:                ",",
			group:                  " ",
			minus:                  "-",
			percent:                "%",
			perMille:               "‰",
			timeSeparator:          ":",
			inifinity:              "∞",
			currencies:             []string{"ADP", "AED", "AFA", "AFN", "ALK", "ALL", "AMD", "ANG", "AOA", "AOK", "AON", "AOR", "ARA", "ARL", "ARM", "ARP", "ARS", "ATS", "AUD", "AWG", "AZM", "AZN", "BAD", "BAM", "BAN", "BBD", "BDT", "BEC", "BEF", "BEL", "BGL", "BGM", "BGN", "BGO", "BHD", "BIF", "BMD", "BND", "BOB", "BOL", "BOP", "BOV", "BRB", "BRC", "BRE", "BRL", "BRN", "BRR", "BRZ", "BSD", "BTN", "BUK", "BWP", "BYB", "BYN", "BYR", "BZD", "CAD", "CDF", "CHE", "CHF", "CHW", "CLE", "CLF", "CLP", "CNH", "CNX", "CNY", "COP", "COU", "CRC", "CSD", "CSK", "CUC", "CUP", "CVE", "CYP", "CZK", "DDM", "DEM", "DJF", "DKK", "DOP", "DZD", "ECS", "ECV", "EEK", "EGP", "ERN", "ESA", "ESB", "ESP", "ETB", "EUR", "FIM", "FJD", "FKP", "FRF", "GBP", "GEK", "GEL", "GHC", "GHS", "GIP", "GMD", "GNF", "GNS", "GQE", "GRD", "GTQ", "GWE", "GWP", "GYD", "HKD", "HNL", "HRD", "HRK", "HTG", "HUF", "IDR", "IEP", "ILP", "ILR", "ILS", "INR", "IQD", "IRR", "ISJ", "ISK", "ITL", "JMD", "JOD", "JPY", "KES", "KGS", "KHR", "KMF", "KPW", "KRH", "KRO", "KRW", "KWD", "KYD", "KZT", "LAK", "LBP", "LKR", "LRD", "LSL", "LTL", "LTT", "LUC", "LUF", "LUL", "LVL", "LVR", "LYD", "MAD", "MAF", "MCF", "MDC", "MDL", "MGA", "MGF", "MKD", "MKN", "MLF", "MMK", "MNT", "MOP", "MRO", "MRU", "MTL", "MTP", "MUR", "MVP", "MVR", "MWK", "MXN", "MXP", "MXV", "MYR", "MZE", "MZM", "MZN", "NAD", "NGN", "NIC", "NIO", "NLG", "NOK", "NPR", "NZD", "OMR", "PAB", "PEI", "PEN", "PES", "PGK", "PHP", "PKR", "PLN", "PLZ", "PTE", "PYG", "QAR", "RHD", "ROL", "RON", "RSD", "RUB", "RUR", "RWF", "SAR", "SBD", "SCR", "SDD", "SDG", "SDP", "SEK", "SGD", "SHP", "SIT", "SKK", "SLL", "SOS", "SRD", "SRG", "SSP", "STD", "STN", "SUR", "SVC", "SYP", "SZL", "THB", "TJR", "TJS", "TMM", "TMT", "TND", "TOP", "TPE", "TRL", "TRY", "TTD", "TWD", "TZS", "UAH", "UAK", "UGS", "UGX", "USD", "USN", "USS", "UYI", "UYP", "UYU", "UYW", "UZS", "VEB", "VEF", "VES", "VND", "VNN", "VUV", "WST", "XAF", "XAG", "XAU", "XBA", "XBB", "XBC", "XBD", "XCD", "XDR", "XEU", "XFO", "XFU", "XOF", "XPD", "XPF", "XPT", "XRE", "XSU", "XTS", "XUA", "XXX", "YDD", "YER", "YUD", "YUM", "YUN", "YUR", "ZAL", "ZAR", "ZMK", "ZMW", "ZRN", "ZRZ", "ZWD", "ZWL", "ZWR"},
			currencyNegativePrefix: "(",
			currencyNegativeSuffix: ")",
			monthsAbbreviated:      []string{"", "Jan.", "Feb.", "Mrt.", "Apr.", "Mei", "Jun.", "Jul.", "Aug.", "Sep.", "Okt.", "Nov.", "Des."},
			monthsNarrow:           []string{"", "J", "F", "M", "A", "M", "J", "J", "A", "S", "O", "N", "D"},
			monthsWide:             []string{"", "Januarie", "Februarie", "Maart", "April", "Mei", "Junie", "Julie", "Augustus", "September", "Oktober", "November", "Desember"},
			daysAbbreviated:        []string{"So.", "Ma.", "Di.", "Wo.", "Do.", "Vr.", "Sa."},
			daysNarrow:             []string{"S", "M", "D", "W", "D", "V", "S"},
			daysShort:              []string{"So.", "Ma.", "Di.", "Wo.", "Do.", "Vr.", "Sa."},
			daysWide:               []string{"Sondag", "Maandag", "Dinsdag", "Woensdag", "Donderdag", "Vrydag", "Saterdag"},
			periodsAbbreviated:     []string{"vm.", "nm."},
			periodsNarrow:          []string{"v", "n"},
			periodsWide:            []string{"vm.", "nm."},
			erasAbbreviated:        []string{"v.C.", "n.C."},
			erasNarrow:             []string{"v.C.", "n.C."},
			erasWide:               []string{"voor Christus", "na Christus"},
			timezones:              map[string]string{"ACDT": "Sentraal-Australiese dagligtyd", "ACST": "Sentraal-Australiese standaardtyd", "ACWDT": "Sentraal-westelike Australiese dagligtyd", "ACWST": "Sentraal-westelike Australiese standaard-tyd", "ADT": "Atlantiese dagligtyd", "AEDT": "Oostelike Australiese dagligtyd", "AEST": "Oostelike Australiese standaardtyd", "AKDT": "Alaska-dagligtyd", "AKST": "Alaska-standaardtyd", "ARST": "Argentinië-somertyd", "ART": "Argentinië-standaardtyd", "AST": "Atlantiese standaardtyd", "AWDT": "Westelike Australiese dagligtyd", "AWST": "Westelike Australiese standaardtyd", "BOT": "Bolivia-tyd", "BT": "Bhoetan-tyd", "CAT": "Sentraal-Afrika-tyd", "CDT": "Noord-Amerikaanse sentrale dagligtyd", "CHADT": "Chatham-dagligtyd", "CHAST": "Chatham-standaardtyd", "CLST": "Chili-somertyd", "CLT": "Chili-standaardtyd", "COST": "Colombia-somertyd", "COT": "Colombië-standaardtyd", "CST": "Noord-Amerikaanse sentrale standaardtyd", "ChST": "Chamorro-standaardtyd", "EAT": "Oos-Afrika-tyd", "ECT": "Ecuador-tyd", "EDT": "Noord-Amerikaanse oostelike dagligtyd", "EST": "Noord-Amerikaanse oostelike standaardtyd", "GFT": "Frans-Guiana-tyd", "GMT": "Greenwich-tyd", "GST": "Persiese Golf-standaardtyd", "GYT": "Guyana-tyd", "HADT": "Hawaii-Aleoete-dagligtyd", "HAST": "Hawaii-Aleoete-standaardtyd", "HAT": "Newfoundland-dagligtyd", "HECU": "Kuba-dagligtyd", "HEEG": "Oos-Groenland-somertyd", "HENOMX": "Noordwes-Meksiko-dagligtyd", "HEOG": "Wes-Groenland-somertyd", "HEPM": "Sint-Pierre en Miquelon-dagligtyd", "HEPMX": "Meksikaanse Pasifiese dagligtyd", "HKST": "Hongkong-somertyd", "HKT": "Hongkong-standaardtyd", "HNCU": "Kuba-standaardtyd", "HNEG": "Oos-Groenland-standaardtyd", "HNNOMX": "Noordwes-Meksiko-standaardtyd", "HNOG": "Wes-Groenland-standaardtyd", "HNPM": "Sint-Pierre en Miquelon-standaardtyd", "HNPMX": "Meksikaanse Pasifiese standaardtyd", "HNT": "Newfoundland-standaardtyd", "IST": "Indië-standaardtyd", "JDT": "Japan-dagligtyd", "JST": "Japan-standaardtyd", "LHDT": "Lord Howe-dagligtyd", "LHST": "Lord Howe-standaardtyd", "MDT": "MDT", "MESZ": "Sentraal-Europese somertyd", "MEZ": "Sentraal-Europese standaardtyd", "MST": "MST", "MYT": "Maleisië-tyd", "NZDT": "Nieu-Seeland-dagligtyd", "NZST": "Nieu-Seeland-standaardtyd", "OESZ": "Oos-Europese somertyd", "OEZ": "Oos-Europese standaardtyd", "PDT": "Pasifiese dagligtyd", "PST": "Pasifiese standaardtyd", "SAST": "Suid-Afrika-standaardtyd", "SGT": "Singapoer-standaardtyd", "SRT": "Suriname-tyd", "TMST": "Turkmenistan-somertyd", "TMT": "Turkmenistan-standaardtyd", "UYST": "Uruguay-somertyd", "UYT": "Uruguay-standaardtyd", "VET": "Venezuela-tyd", "WARST": "Wes-Argentinië-somertyd", "WART": "Wes-Argentinië-standaardtyd", "WAST": "Wes-Afrika-somertyd", "WAT": "Wes-Afrika-standaardtyd", "WESZ": "Wes-Europese somertyd", "WEZ": "Wes-Europese standaardtyd", "WIB": "Wes-Indonesië-tyd", "WIT": "Oos-Indonesië-tyd", "WITA": "Sentraal-Indonesiese tyd", "∅∅∅": "Peru-somertyd"},

			fnCardinalPluralRule:  fnCardinalPluralRule_0758171f702b5b6024bdf47d25d8166d,
			fnDecimal:             fnDecimal_a78485e7dd32c95f41af4e18420793bf,
			fnFmtAccounting:       fnFmtAccounting_ee2956d02335482ec6b7e9a423beb0b5,
			fnFmtCurrency:         fnFmtCurrency_ec1a372391d9fcdfb2e025fe6142dc3b,
			fnFmtDateFull:         fnFmtDateFull_aa89072e939f6d411d6d93fa47eed117,
			fnFmtDateLong:         fnFmtDateLong_85907dc745b1a23de90d4a44c3222404,
			fnFmtDateMedium:       fnFmtDateMedium_358c9403a9e4cad0b8974bed45e6527c,
			fnFmtDateShort:        fnFmtDateShort_93e0dc80e7e3deca3036cf894d743e0e,
			fnFmtNumber:           fnFmtNumber_0866206624669dc4f03297eb76a545b2,
			fnFmtPercent:          fnFmtPercent_1c35b3868bf10d0e69b22b2e80c40671,
			fnFmtTimeFull:         fnFmtTimeFull_ebdf96de1e47f9043145564c500ef7dc,
			fnFmtTimeLong:         fnFmtTimeLong_987bec4676d3a5de4218e415e123649d,
			fnFmtTimeMedium:       fnFmtTimeMedium_b6f697552cd4965cd1195fe56dc87003,
			fnFmtTimeShort:        fnFmtTimeShort_8ffba4d1a2f04a0a6486853d76cf434b,
			fnGroup:               fnGroup_5c4b80a5ccdee81467241784ab8fcd56,
			fnLocale:              fnLocale_5a217059c67094defae82f249f55f4c5,
			fnMinus:               fnMinus_8b8229905258388dc16a5e0c270b0488,
			fnMonthAbbreviated:    fnMonthAbbreviated_aa9a9957cd9d056ba078b36a08b17478,
			fnMonthNarrow:         fnMonthNarrow_45916040ecf6fc350894d9e3e6c46dc7,
			fnMonthWide:           fnMonthWide_4c946a7e7581c665e7407df1841810b5,
			fnMonthsAbbreviated:   fnMonthsAbbreviated_181f77804b62232997fae36bd57d6cf7,
			fnMonthsNarrow:        fnMonthsNarrow_75daa2ba82ae9577292175c3f52370cc,
			fnMonthsWide:          fnMonthsWide_0ecf36a8b72255e2fee9467af362e989,
			fnOrdinalPluralRule:   fnOrdinalPluralRule_3355865f05dde9af2a36ba415bea85cb,
			fnPluralsCardinal:     fnPluralsCardinal_85b19cac1fab9f2c2cfb9eb41539aa0e,
			fnPluralsOrdinal:      fnPluralsOrdinal_16a60aa09da9778fa82fe463e83076de,
			fnPluralsRange:        fnPluralsRange_332465bda13eb808b3664fa0500f54ce,
			fnRangePluralRule:     fnRangePluralRule_91a918d93f773c0b7589da5ebb6c4164,
			fnWeekdayAbbreviated:  fnWeekdayAbbreviated_4ffbdfbd2be10e6bd8fb5a542a14664a,
			fnWeekdayNarrow:       fnWeekdayNarrow_e86921b3446df5ea9afe9504cfa20d1a,
			fnWeekdayShort:        fnWeekdayShort_82b231d4f504c6d71c7e495aa35cd3c2,
			fnWeekdayWide:         fnWeekdayWide_ab7e026d8685cefd89c5aeb5df512a9a,
			fnWeekdaysAbbreviated: fnWeekdaysAbbreviated_454a3d7d23c662520a64ae5245d404be,
			fnWeekdaysNarrow:      fnWeekdaysNarrow_d23eb0b7a498c40ce19d1bf231cad524,
			fnWeekdaysShort:       fnWeekdaysShort_eb6ee64d01e314991432b4469790d38b,
			fnWeekdaysWide:        fnWeekdaysWide_5e2bbf75a31e730429c100e8a0bd3ebd,
		}
	}
	translatorFuncs["agq"] = func() locales.Translator {
		return &localen{

			locale:             "agq",
			pluralsCardinal:    nil,
			pluralsOrdinal:     nil,
			pluralsRange:       nil,
			decimal:            ",",
			group:              " ",
			timeSeparator:      ":",
			currencies:         []string{"ADP", "AED", "AFA", "AFN", "ALK", "ALL", "AMD", "ANG", "AOA", "AOK", "AON", "AOR", "ARA", "ARL", "ARM", "ARP", "ARS", "ATS", "AUD", "AWG", "AZM", "AZN", "BAD", "BAM", "BAN", "BBD", "BDT", "BEC", "BEF", "BEL", "BGL", "BGM", "BGN", "BGO", "BHD", "BIF", "BMD", "BND", "BOB", "BOL", "BOP", "BOV", "BRB", "BRC", "BRE", "BRL", "BRN", "BRR", "BRZ", "BSD", "BTN", "BUK", "BWP", "BYB", "BYN", "BYR", "BZD", "CAD", "CDF", "CHE", "CHF", "CHW", "CLE", "CLF", "CLP", "CNH", "CNX", "CNY", "COP", "COU", "CRC", "CSD", "CSK", "CUC", "CUP", "CVE", "CYP", "CZK", "DDM", "DEM", "DJF", "DKK", "DOP", "DZD", "ECS", "ECV", "EEK", "EGP", "ERN", "ESA", "ESB", "ESP", "ETB", "EUR", "FIM", "FJD", "FKP", "FRF", "GBP", "GEK", "GEL", "GHC", "GHS", "GIP", "GMD", "GNF", "GNS", "GQE", "GRD", "GTQ", "GWE", "GWP", "GYD", "HKD", "HNL", "HRD", "HRK", "HTG", "HUF", "IDR", "IEP", "ILP", "ILR", "ILS", "INR", "IQD", "IRR", "ISJ", "ISK", "ITL", "JMD", "JOD", "JPY", "KES", "KGS", "KHR", "KMF", "KPW", "KRH", "KRO", "KRW", "KWD", "KYD", "KZT", "LAK", "LBP", "LKR", "LRD", "LSL", "LTL", "LTT", "LUC", "LUF", "LUL", "LVL", "LVR", "LYD", "MAD", "MAF", "MCF", "MDC", "MDL", "MGA", "MGF", "MKD", "MKN", "MLF", "MMK", "MNT", "MOP", "MRO", "MRU", "MTL", "MTP", "MUR", "MVP", "MVR", "MWK", "MXN", "MXP", "MXV", "MYR", "MZE", "MZM", "MZN", "NAD", "NGN", "NIC", "NIO", "NLG", "NOK", "NPR", "NZD", "OMR", "PAB", "PEI", "PEN", "PES", "PGK", "PHP", "PKR", "PLN", "PLZ", "PTE", "PYG", "QAR", "RHD", "ROL", "RON", "RSD", "RUB", "RUR", "RWF", "SAR", "SBD", "SCR", "SDD", "SDG", "SDP", "SEK", "SGD", "SHP", "SIT", "SKK", "SLL", "SOS", "SRD", "SRG", "SSP", "STD", "STN", "SUR", "SVC", "SYP", "SZL", "THB", "TJR", "TJS", "TMM", "TMT", "TND", "TOP", "TPE", "TRL", "TRY", "TTD", "TWD", "TZS", "UAH", "UAK", "UGS", "UGX", "USD", "USN", "USS", "UYI", "UYP", "UYU", "UYW", "UZS", "VEB", "VEF", "VES", "VND", "VNN", "VUV", "WST", "XAF", "XAG", "XAU", "XBA", "XBB", "XBC", "XBD", "XCD", "XDR", "XEU", "XFO", "XFU", "XOF", "XPD", "XPF", "XPT", "XRE", "XSU", "XTS", "XUA", "XXX", "YDD", "YER", "YUD", "YUM", "YUN", "YUR", "ZAL", "ZAR", "ZMK", "ZMW", "ZRN", "ZRZ", "ZWD", "ZWL", "ZWR"},
			monthsAbbreviated:  []string{"", "nùm", "kɨz", "tɨd", "taa", "see", "nzu", "dum", "fɔe", "dzu", "lɔm", "kaa", "fwo"},
			monthsNarrow:       []string{"", "n", "k", "t", "t", "s", "z", "k", "f", "d", "l", "c", "f"},
			monthsWide:         []string{"", "ndzɔ̀ŋɔ̀nùm", "ndzɔ̀ŋɔ̀kƗ̀zùʔ", "ndzɔ̀ŋɔ̀tƗ̀dʉ̀ghà", "ndzɔ̀ŋɔ̀tǎafʉ̄ghā", "ndzɔ̀ŋèsèe", "ndzɔ̀ŋɔ̀nzùghò", "ndzɔ̀ŋɔ̀dùmlo", "ndzɔ̀ŋɔ̀kwîfɔ̀e", "ndzɔ̀ŋɔ̀tƗ̀fʉ̀ghàdzughù", "ndzɔ̀ŋɔ̀ghǔuwelɔ̀m", "ndzɔ̀ŋɔ̀chwaʔàkaa wo", "ndzɔ̀ŋèfwòo"},
			daysAbbreviated:    []string{"nts", "kpa", "ghɔ", "tɔm", "ume", "ghɨ", "dzk"},
			daysNarrow:         []string{"n", "k", "g", "t", "u", "g", "d"},
			daysWide:           []string{"tsuʔntsɨ", "tsuʔukpà", "tsuʔughɔe", "tsuʔutɔ̀mlò", "tsuʔumè", "tsuʔughɨ̂m", "tsuʔndzɨkɔʔɔ"},
			periodsAbbreviated: []string{"a.g", "a.k"},
			periodsWide:        []string{"a.g", "a.k"},
			erasAbbreviated:    []string{"SK", "BK"},
			erasNarrow:         []string{"", ""},
			erasWide:           []string{"Sěe Kɨ̀lesto", "Bǎa Kɨ̀lesto"},
			timezones:          map[string]string{"ACDT": "ACDT", "ACST": "ACST", "ACWDT": "ACWDT", "ACWST": "ACWST", "ADT": "ADT", "AEDT": "AEDT", "AEST": "AEST", "AKDT": "AKDT", "AKST": "AKST", "ARST": "ARST", "ART": "ART", "AST": "AST", "AWDT": "AWDT", "AWST": "AWST", "BOT": "BOT", "BT": "BT", "CAT": "CAT", "CDT": "CDT", "CHADT": "CHADT", "CHAST": "CHAST", "CLST": "CLST", "CLT": "CLT", "COST": "COST", "COT": "COT", "CST": "CST", "ChST": "ChST", "EAT": "EAT", "ECT": "ECT", "EDT": "EDT", "EST": "EST", "GFT": "GFT", "GMT": "GMT", "GST": "GST", "GYT": "GYT", "HADT": "HADT", "HAST": "HAST", "HAT": "HAT", "HECU": "HECU", "HEEG": "HEEG", "HENOMX": "HENOMX", "HEOG": "HEOG", "HEPM": "HEPM", "HEPMX": "HEPMX", "HKST": "HKST", "HKT": "HKT", "HNCU": "HNCU", "HNEG": "HNEG", "HNNOMX": "HNNOMX", "HNOG": "HNOG", "HNPM": "HNPM", "HNPMX": "HNPMX", "HNT": "HNT", "IST": "IST", "JDT": "JDT", "JST": "JST", "LHDT": "LHDT", "LHST": "LHST", "MDT": "MDT", "MESZ": "MESZ", "MEZ": "MEZ", "MST": "MST", "MYT": "MYT", "NZDT": "NZDT", "NZST": "NZST", "OESZ": "OESZ", "OEZ": "OEZ", "PDT": "PDT", "PST": "PST", "SAST": "SAST", "SGT": "SGT", "SRT": "SRT", "TMST": "TMST", "TMT": "TMT", "UYST": "UYST", "UYT": "UYT", "VET": "VET", "WARST": "WARST", "WART": "WART", "WAST": "WAST", "WAT": "WAT", "WESZ": "WESZ", "WEZ": "WEZ", "WIB": "WIB", "WIT": "WIT", "WITA": "WITA", "∅∅∅": "∅∅∅"},

			fnCardinalPluralRule:  fnCardinalPluralRule_6d6ec1478c59480bfd820f2a0c64a497,
			fnDecimal:             fnDecimal_a78485e7dd32c95f41af4e18420793bf,
			fnFmtAccounting:       fnFmtAccounting_c53d1c28077fe8a91eda0e7a76463f6d,
			fnFmtCurrency:         fnFmtCurrency_2f14500b7d52d9b6d26d90cfb96161ed,
			fnFmtDateFull:         fnFmtDateFull_e5aac3b796a648ed7f4aaa501e4e3844,
			fnFmtDateLong:         fnFmtDateLong_506f643cda0514f66d873a9ea99bf639,
			fnFmtDateMedium:       fnFmtDateMedium_5e450105cccbc820e4514899ef73128f,
			fnFmtDateShort:        fnFmtDateShort_222c809496186523124eb16d6c474592,
			fnFmtNumber:           fnFmtNumber_ceab7ec754f7f75fd13d22457c77cbf9,
			fnFmtPercent:          fnFmtPercent_a2e6b1aef5e145e790a5623d4a4e442c,
			fnFmtTimeFull:         fnFmtTimeFull_ebdf96de1e47f9043145564c500ef7dc,
			fnFmtTimeLong:         fnFmtTimeLong_987bec4676d3a5de4218e415e123649d,
			fnFmtTimeMedium:       fnFmtTimeMedium_b6f697552cd4965cd1195fe56dc87003,
			fnFmtTimeShort:        fnFmtTimeShort_8ffba4d1a2f04a0a6486853d76cf434b,
			fnGroup:               fnGroup_5c4b80a5ccdee81467241784ab8fcd56,
			fnLocale:              fnLocale_5a217059c67094defae82f249f55f4c5,
			fnMinus:               fnMinus_8b8229905258388dc16a5e0c270b0488,
			fnMonthAbbreviated:    fnMonthAbbreviated_aa9a9957cd9d056ba078b36a08b17478,
			fnMonthNarrow:         fnMonthNarrow_45916040ecf6fc350894d9e3e6c46dc7,
			fnMonthWide:           fnMonthWide_4c946a7e7581c665e7407df1841810b5,
			fnMonthsAbbreviated:   fnMonthsAbbreviated_181f77804b62232997fae36bd57d6cf7,
			fnMonthsNarrow:        fnMonthsNarrow_75daa2ba82ae9577292175c3f52370cc,
			fnMonthsWide:          fnMonthsWide_0ecf36a8b72255e2fee9467af362e989,
			fnOrdinalPluralRule:   fnOrdinalPluralRule_a0e5467912a746c396065750c68e4318,
			fnPluralsCardinal:     fnPluralsCardinal_85b19cac1fab9f2c2cfb9eb41539aa0e,
			fnPluralsOrdinal:      fnPluralsOrdinal_16a60aa09da9778fa82fe463e83076de,
			fnPluralsRange:        fnPluralsRange_332465bda13eb808b3664fa0500f54ce,
			fnRangePluralRule:     fnRangePluralRule_e0f62e2cf3ae7407fb4b54d084341c0b,
			fnWeekdayAbbreviated:  fnWeekdayAbbreviated_4ffbdfbd2be10e6bd8fb5a542a14664a,
			fnWeekdayNarrow:       fnWeekdayNarrow_e86921b3446df5ea9afe9504cfa20d1a,
			fnWeekdayShort:        fnWeekdayShort_82b231d4f504c6d71c7e495aa35cd3c2,
			fnWeekdayWide:         fnWeekdayWide_ab7e026d8685cefd89c5aeb5df512a9a,
			fnWeekdaysAbbreviated: fnWeekdaysAbbreviated_454a3d7d23c662520a64ae5245d404be,
			fnWeekdaysNarrow:      fnWeekdaysNarrow_d23eb0b7a498c40ce19d1bf231cad524,
			fnWeekdaysShort:       fnWeekdaysShort_eb6ee64d01e314991432b4469790d38b,
			fnWeekdaysWide:        fnWeekdaysWide_5e2bbf75a31e730429c100e8a0bd3ebd,
		}
	}
	translatorFuncs["agq_cm"] = func() locales.Translator {
		return &localen{

			locale:             "agq_CM",
			pluralsCardinal:    nil,
			pluralsOrdinal:     nil,
			pluralsRange:       nil,
			decimal:            ",",
			group:              " ",
			timeSeparator:      ":",
			currencies:         []string{"ADP", "AED", "AFA", "AFN", "ALK", "ALL", "AMD", "ANG", "AOA", "AOK", "AON", "AOR", "ARA", "ARL", "ARM", "ARP", "ARS", "ATS", "AUD", "AWG", "AZM", "AZN", "BAD", "BAM", "BAN", "BBD", "BDT", "BEC", "BEF", "BEL", "BGL", "BGM", "BGN", "BGO", "BHD", "BIF", "BMD", "BND", "BOB", "BOL", "BOP", "BOV", "BRB", "BRC", "BRE", "BRL", "BRN", "BRR", "BRZ", "BSD", "BTN", "BUK", "BWP", "BYB", "BYN", "BYR", "BZD", "CAD", "CDF", "CHE", "CHF", "CHW", "CLE", "CLF", "CLP", "CNH", "CNX", "CNY", "COP", "COU", "CRC", "CSD", "CSK", "CUC", "CUP", "CVE", "CYP", "CZK", "DDM", "DEM", "DJF", "DKK", "DOP", "DZD", "ECS", "ECV", "EEK", "EGP", "ERN", "ESA", "ESB", "ESP", "ETB", "EUR", "FIM", "FJD", "FKP", "FRF", "GBP", "GEK", "GEL", "GHC", "GHS", "GIP", "GMD", "GNF", "GNS", "GQE", "GRD", "GTQ", "GWE", "GWP", "GYD", "HKD", "HNL", "HRD", "HRK", "HTG", "HUF", "IDR", "IEP", "ILP", "ILR", "ILS", "INR", "IQD", "IRR", "ISJ", "ISK", "ITL", "JMD", "JOD", "JPY", "KES", "KGS", "KHR", "KMF", "KPW", "KRH", "KRO", "KRW", "KWD", "KYD", "KZT", "LAK", "LBP", "LKR", "LRD", "LSL", "LTL", "LTT", "LUC", "LUF", "LUL", "LVL", "LVR", "LYD", "MAD", "MAF", "MCF", "MDC", "MDL", "MGA", "MGF", "MKD", "MKN", "MLF", "MMK", "MNT", "MOP", "MRO", "MRU", "MTL", "MTP", "MUR", "MVP", "MVR", "MWK", "MXN", "MXP", "MXV", "MYR", "MZE", "MZM", "MZN", "NAD", "NGN", "NIC", "NIO", "NLG", "NOK", "NPR", "NZD", "OMR", "PAB", "PEI", "PEN", "PES", "PGK", "PHP", "PKR", "PLN", "PLZ", "PTE", "PYG", "QAR", "RHD", "ROL", "RON", "RSD", "RUB", "RUR", "RWF", "SAR", "SBD", "SCR", "SDD", "SDG", "SDP", "SEK", "SGD", "SHP", "SIT", "SKK", "SLL", "SOS", "SRD", "SRG", "SSP", "STD", "STN", "SUR", "SVC", "SYP", "SZL", "THB", "TJR", "TJS", "TMM", "TMT", "TND", "TOP", "TPE", "TRL", "TRY", "TTD", "TWD", "TZS", "UAH", "UAK", "UGS", "UGX", "USD", "USN", "USS", "UYI", "UYP", "UYU", "UYW", "UZS", "VEB", "VEF", "VES", "VND", "VNN", "VUV", "WST", "XAF", "XAG", "XAU", "XBA", "XBB", "XBC", "XBD", "XCD", "XDR", "XEU", "XFO", "XFU", "XOF", "XPD", "XPF", "XPT", "XRE", "XSU", "XTS", "XUA", "XXX", "YDD", "YER", "YUD", "YUM", "YUN", "YUR", "ZAL", "ZAR", "ZMK", "ZMW", "ZRN", "ZRZ", "ZWD", "ZWL", "ZWR"},
			monthsAbbreviated:  []string{"", "nùm", "kɨz", "tɨd", "taa", "see", "nzu", "dum", "fɔe", "dzu", "lɔm", "kaa", "fwo"},
			monthsNarrow:       []string{"", "n", "k", "t", "t", "s", "z", "k", "f", "d", "l", "c", "f"},
			monthsWide:         []string{"", "ndzɔ̀ŋɔ̀nùm", "ndzɔ̀ŋɔ̀kƗ̀zùʔ", "ndzɔ̀ŋɔ̀tƗ̀dʉ̀ghà", "ndzɔ̀ŋɔ̀tǎafʉ̄ghā", "ndzɔ̀ŋèsèe", "ndzɔ̀ŋɔ̀nzùghò", "ndzɔ̀ŋɔ̀dùmlo", "ndzɔ̀ŋɔ̀kwîfɔ̀e", "ndzɔ̀ŋɔ̀tƗ̀fʉ̀ghàdzughù", "ndzɔ̀ŋɔ̀ghǔuwelɔ̀m", "ndzɔ̀ŋɔ̀chwaʔàkaa wo", "ndzɔ̀ŋèfwòo"},
			daysAbbreviated:    []string{"nts", "kpa", "ghɔ", "tɔm", "ume", "ghɨ", "dzk"},
			daysNarrow:         []string{"n", "k", "g", "t", "u", "g", "d"},
			daysWide:           []string{"tsuʔntsɨ", "tsuʔukpà", "tsuʔughɔe", "tsuʔutɔ̀mlò", "tsuʔumè", "tsuʔughɨ̂m", "tsuʔndzɨkɔʔɔ"},
			periodsAbbreviated: []string{"a.g", "a.k"},
			periodsWide:        []string{"a.g", "a.k"},
			erasAbbreviated:    []string{"SK", "BK"},
			erasNarrow:         []string{"", ""},
			erasWide:           []string{"Sěe Kɨ̀lesto", "Bǎa Kɨ̀lesto"},
			timezones:          map[string]string{"ACDT": "ACDT", "ACST": "ACST", "ACWDT": "ACWDT", "ACWST": "ACWST", "ADT": "ADT", "AEDT": "AEDT", "AEST": "AEST", "AKDT": "AKDT", "AKST": "AKST", "ARST": "ARST", "ART": "ART", "AST": "AST", "AWDT": "AWDT", "AWST": "AWST", "BOT": "BOT", "BT": "BT", "CAT": "CAT", "CDT": "CDT", "CHADT": "CHADT", "CHAST": "CHAST", "CLST": "CLST", "CLT": "CLT", "COST": "COST", "COT": "COT", "CST": "CST", "ChST": "ChST", "EAT": "EAT", "ECT": "ECT", "EDT": "EDT", "EST": "EST", "GFT": "GFT", "GMT": "GMT", "GST": "GST", "GYT": "GYT", "HADT": "HADT", "HAST": "HAST", "HAT": "HAT", "HECU": "HECU", "HEEG": "HEEG", "HENOMX": "HENOMX", "HEOG": "HEOG", "HEPM": "HEPM", "HEPMX": "HEPMX", "HKST": "HKST", "HKT": "HKT", "HNCU": "HNCU", "HNEG": "HNEG", "HNNOMX": "HNNOMX", "HNOG": "HNOG", "HNPM": "HNPM", "HNPMX": "HNPMX", "HNT": "HNT", "IST": "IST", "JDT": "JDT", "JST": "JST", "LHDT": "LHDT", "LHST": "LHST", "MDT": "MDT", "MESZ": "MESZ", "MEZ": "MEZ", "MST": "MST", "MYT": "MYT", "NZDT": "NZDT", "NZST": "NZST", "OESZ": "OESZ", "OEZ": "OEZ", "PDT": "PDT", "PST": "PST", "SAST": "SAST", "SGT": "SGT", "SRT": "SRT", "TMST": "TMST", "TMT": "TMT", "UYST": "UYST", "UYT": "UYT", "VET": "VET", "WARST": "WARST", "WART": "WART", "WAST": "WAST", "WAT": "WAT", "WESZ": "WESZ", "WEZ": "WEZ", "WIB": "WIB", "WIT": "WIT", "WITA": "WITA", "∅∅∅": "∅∅∅"},

			fnCardinalPluralRule:  fnCardinalPluralRule_6d6ec1478c59480bfd820f2a0c64a497,
			fnDecimal:             fnDecimal_a78485e7dd32c95f41af4e18420793bf,
			fnFmtAccounting:       fnFmtAccounting_c53d1c28077fe8a91eda0e7a76463f6d,
			fnFmtCurrency:         fnFmtCurrency_2f14500b7d52d9b6d26d90cfb96161ed,
			fnFmtDateFull:         fnFmtDateFull_e5aac3b796a648ed7f4aaa501e4e3844,
			fnFmtDateLong:         fnFmtDateLong_506f643cda0514f66d873a9ea99bf639,
			fnFmtDateMedium:       fnFmtDateMedium_5e450105cccbc820e4514899ef73128f,
			fnFmtDateShort:        fnFmtDateShort_222c809496186523124eb16d6c474592,
			fnFmtNumber:           fnFmtNumber_ceab7ec754f7f75fd13d22457c77cbf9,
			fnFmtPercent:          fnFmtPercent_a2e6b1aef5e145e790a5623d4a4e442c,
			fnFmtTimeFull:         fnFmtTimeFull_ebdf96de1e47f9043145564c500ef7dc,
			fnFmtTimeLong:         fnFmtTimeLong_987bec4676d3a5de4218e415e123649d,
			fnFmtTimeMedium:       fnFmtTimeMedium_b6f697552cd4965cd1195fe56dc87003,
			fnFmtTimeShort:        fnFmtTimeShort_8ffba4d1a2f04a0a6486853d76cf434b,
			fnGroup:               fnGroup_5c4b80a5ccdee81467241784ab8fcd56,
			fnLocale:              fnLocale_5a217059c67094defae82f249f55f4c5,
			fnMinus:               fnMinus_8b8229905258388dc16a5e0c270b0488,
			fnMonthAbbreviated:    fnMonthAbbreviated_aa9a9957cd9d056ba078b36a08b17478,
			fnMonthNarrow:         fnMonthNarrow_45916040ecf6fc350894d9e3e6c46dc7,
			fnMonthWide:           fnMonthWide_4c946a7e7581c665e7407df1841810b5,
			fnMonthsAbbreviated:   fnMonthsAbbreviated_181f77804b62232997fae36bd57d6cf7,
			fnMonthsNarrow:        fnMonthsNarrow_75daa2ba82ae9577292175c3f52370cc,
			fnMonthsWide:          fnMonthsWide_0ecf36a8b72255e2fee9467af362e989,
			fnOrdinalPluralRule:   fnOrdinalPluralRule_a0e5467912a746c396065750c68e4318,
			fnPluralsCardinal:     fnPluralsCardinal_85b19cac1fab9f2c2cfb9eb41539aa0e,
			fnPluralsOrdinal:      fnPluralsOrdinal_16a60aa09da9778fa82fe463e83076de,
			fnPluralsRange:        fnPluralsRange_332465bda13eb808b3664fa0500f54ce,
			fnRangePluralRule:     fnRangePluralRule_e0f62e2cf3ae7407fb4b54d084341c0b,
			fnWeekdayAbbreviated:  fnWeekdayAbbreviated_4ffbdfbd2be10e6bd8fb5a542a14664a,
			fnWeekdayNarrow:       fnWeekdayNarrow_e86921b3446df5ea9afe9504cfa20d1a,
			fnWeekdayShort:        fnWeekdayShort_82b231d4f504c6d71c7e495aa35cd3c2,
			fnWeekdayWide:         fnWeekdayWide_ab7e026d8685cefd89c5aeb5df512a9a,
			fnWeekdaysAbbreviated: fnWeekdaysAbbreviated_454a3d7d23c662520a64ae5245d404be,
			fnWeekdaysNarrow:      fnWeekdaysNarrow_d23eb0b7a498c40ce19d1bf231cad524,
			fnWeekdaysShort:       fnWeekdaysShort_eb6ee64d01e314991432b4469790d38b,
			fnWeekdaysWide:        fnWeekdaysWide_5e2bbf75a31e730429c100e8a0bd3ebd,
		}
	}
	translatorFuncs["ak"] = func() locales.Translator {
		return &localen{

			locale:             "ak",
			pluralsCardinal:    []locales.PluralRule{2, 6},
			pluralsOrdinal:     nil,
			pluralsRange:       []locales.PluralRule{2, 6},
			decimal:            ".",
			group:              ",",
			timeSeparator:      ":",
			currencies:         []string{"ADP", "AED", "AFA", "AFN", "ALK", "ALL", "AMD", "ANG", "AOA", "AOK", "AON", "AOR", "ARA", "ARL", "ARM", "ARP", "ARS", "ATS", "AUD", "AWG", "AZM", "AZN", "BAD", "BAM", "BAN", "BBD", "BDT", "BEC", "BEF", "BEL", "BGL", "BGM", "BGN", "BGO", "BHD", "BIF", "BMD", "BND", "BOB", "BOL", "BOP", "BOV", "BRB", "BRC", "BRE", "BRL", "BRN", "BRR", "BRZ", "BSD", "BTN", "BUK", "BWP", "BYB", "BYN", "BYR", "BZD", "CAD", "CDF", "CHE", "CHF", "CHW", "CLE", "CLF", "CLP", "CNH", "CNX", "CNY", "COP", "COU", "CRC", "CSD", "CSK", "CUC", "CUP", "CVE", "CYP", "CZK", "DDM", "DEM", "DJF", "DKK", "DOP", "DZD", "ECS", "ECV", "EEK", "EGP", "ERN", "ESA", "ESB", "ESP", "ETB", "EUR", "FIM", "FJD", "FKP", "FRF", "GBP", "GEK", "GEL", "GHC", "GH₵", "GIP", "GMD", "GNF", "GNS", "GQE", "GRD", "GTQ", "GWE", "GWP", "GYD", "HKD", "HNL", "HRD", "HRK", "HTG", "HUF", "IDR", "IEP", "ILP", "ILR", "ILS", "INR", "IQD", "IRR", "ISJ", "ISK", "ITL", "JMD", "JOD", "JPY", "KES", "KGS", "KHR", "KMF", "KPW", "KRH", "KRO", "KRW", "KWD", "KYD", "KZT", "LAK", "LBP", "LKR", "LRD", "LSL", "LTL", "LTT", "LUC", "LUF", "LUL", "LVL", "LVR", "LYD", "MAD", "MAF", "MCF", "MDC", "MDL", "MGA", "MGF", "MKD", "MKN", "MLF", "MMK", "MNT", "MOP", "MRO", "MRU", "MTL", "MTP", "MUR", "MVP", "MVR", "MWK", "MXN", "MXP", "MXV", "MYR", "MZE", "MZM", "MZN", "NAD", "NGN", "NIC", "NIO", "NLG", "NOK", "NPR", "NZD", "OMR", "PAB", "PEI", "PEN", "PES", "PGK", "PHP", "PKR", "PLN", "PLZ", "PTE", "PYG", "QAR", "RHD", "ROL", "RON", "RSD", "RUB", "RUR", "RWF", "SAR", "SBD", "SCR", "SDD", "SDG", "SDP", "SEK", "SGD", "SHP", "SIT", "SKK", "SLL", "SOS", "SRD", "SRG", "SSP", "STD", "STN", "SUR", "SVC", "SYP", "SZL", "THB", "TJR", "TJS", "TMM", "TMT", "TND", "TOP", "TPE", "TRL", "TRY", "TTD", "TWD", "TZS", "UAH", "UAK", "UGS", "UGX", "USD", "USN", "USS", "UYI", "UYP", "UYU", "UYW", "UZS", "VEB", "VEF", "VES", "VND", "VNN", "VUV", "WST", "XAF", "XAG", "XAU", "XBA", "XBB", "XBC", "XBD", "XCD", "XDR", "XEU", "XFO", "XFU", "XOF", "XPD", "XPF", "XPT", "XRE", "XSU", "XTS", "XUA", "XXX", "YDD", "YER", "YUD", "YUM", "YUN", "YUR", "ZAL", "ZAR", "ZMK", "ZMW", "ZRN", "ZRZ", "ZWD", "ZWL", "ZWR"},
			monthsAbbreviated:  []string{"", "S-Ɔ", "K-Ɔ", "E-Ɔ", "E-O", "E-K", "O-A", "A-K", "D-Ɔ", "F-Ɛ", "Ɔ-A", "Ɔ-O", "M-Ɔ"},
			monthsWide:         []string{"", "Sanda-Ɔpɛpɔn", "Kwakwar-Ɔgyefuo", "Ebɔw-Ɔbenem", "Ebɔbira-Oforisuo", "Esusow Aketseaba-Kɔtɔnimba", "Obirade-Ayɛwohomumu", "Ayɛwoho-Kitawonsa", "Difuu-Ɔsandaa", "Fankwa-Ɛbɔ", "Ɔbɛsɛ-Ahinime", "Ɔberɛfɛw-Obubuo", "Mumu-Ɔpɛnimba"},
			daysAbbreviated:    []string{"Kwe", "Dwo", "Ben", "Wuk", "Yaw", "Fia", "Mem"},
			daysNarrow:         []string{"K", "D", "B", "W", "Y", "F", "M"},
			daysWide:           []string{"Kwesida", "Dwowda", "Benada", "Wukuda", "Yawda", "Fida", "Memeneda"},
			periodsAbbreviated: []string{"AN", "EW"},
			periodsWide:        []string{"AN", "EW"},
			erasAbbreviated:    []string{"AK", "KE"},
			erasNarrow:         []string{"", ""},
			erasWide:           []string{"Ansa Kristo", "Kristo Ekyiri"},
			timezones:          map[string]string{"ACDT": "ACDT", "ACST": "ACST", "ACWDT": "ACWDT", "ACWST": "ACWST", "ADT": "ADT", "AEDT": "AEDT", "AEST": "AEST", "AKDT": "AKDT", "AKST": "AKST", "ARST": "ARST", "ART": "ART", "AST": "AST", "AWDT": "AWDT", "AWST": "AWST", "BOT": "BOT", "BT": "BT", "CAT": "CAT", "CDT": "CDT", "CHADT": "CHADT", "CHAST": "CHAST", "CLST": "CLST", "CLT": "CLT", "COST": "COST", "COT": "COT", "CST": "CST", "ChST": "ChST", "EAT": "EAT", "ECT": "ECT", "EDT": "EDT", "EST": "EST", "GFT": "GFT", "GMT": "GMT", "GST": "GST", "GYT": "GYT", "HADT": "HADT", "HAST": "HAST", "HAT": "HAT", "HECU": "HECU", "HEEG": "HEEG", "HENOMX": "HENOMX", "HEOG": "HEOG", "HEPM": "HEPM", "HEPMX": "HEPMX", "HKST": "HKST", "HKT": "HKT", "HNCU": "HNCU", "HNEG": "HNEG", "HNNOMX": "HNNOMX", "HNOG": "HNOG", "HNPM": "HNPM", "HNPMX": "HNPMX", "HNT": "HNT", "IST": "IST", "JDT": "JDT", "JST": "JST", "LHDT": "LHDT", "LHST": "LHST", "MDT": "MDT", "MESZ": "MESZ", "MEZ": "MEZ", "MST": "MST", "MYT": "MYT", "NZDT": "NZDT", "NZST": "NZST", "OESZ": "OESZ", "OEZ": "OEZ", "PDT": "PDT", "PST": "PST", "SAST": "SAST", "SGT": "SGT", "SRT": "SRT", "TMST": "TMST", "TMT": "TMT", "UYST": "UYST", "UYT": "UYT", "VET": "VET", "WARST": "WARST", "WART": "WART", "WAST": "WAST", "WAT": "WAT", "WESZ": "WESZ", "WEZ": "WEZ", "WIB": "WIB", "WIT": "WIT", "WITA": "WITA", "∅∅∅": "∅∅∅"},

			fnCardinalPluralRule:  fnCardinalPluralRule_1a767992f2534d16887981ec7c7c1cfb,
			fnDecimal:             fnDecimal_a78485e7dd32c95f41af4e18420793bf,
			fnFmtAccounting:       fnFmtAccounting_ec9761d27ad9ead532f5f112e23983b1,
			fnFmtCurrency:         fnFmtCurrency_21670b336e6e64700cc7f949f05c390f,
			fnFmtDateFull:         fnFmtDateFull_9d575487ce5a187f6efc22e6d3f8a058,
			fnFmtDateLong:         fnFmtDateLong_4ff37a0cfcd7dfa30a768d81e70d334e,
			fnFmtDateMedium:       fnFmtDateMedium_596f6f3746d292714e1810c0b50dd05c,
			fnFmtDateShort:        fnFmtDateShort_93244c9b90b1456ed872d8fc125fd668,
			fnFmtNumber:           fnFmtNumber_2816fdab36e719be095a370ff42e599f,
			fnFmtPercent:          fnFmtPercent_016773d83796aa19d80b7c33bf377883,
			fnFmtTimeFull:         fnFmtTimeFull_37fe4deeee789852cc196a6a1a2f0ccc,
			fnFmtTimeLong:         fnFmtTimeLong_4429ef4fb58a2a9c4d7d5132fd16ecbf,
			fnFmtTimeMedium:       fnFmtTimeMedium_8ef07f6477b7a4944577d4e5392ff21b,
			fnFmtTimeShort:        fnFmtTimeShort_8288b817c5c0216c9815524c71c9e0b4,
			fnGroup:               fnGroup_5c4b80a5ccdee81467241784ab8fcd56,
			fnLocale:              fnLocale_5a217059c67094defae82f249f55f4c5,
			fnMinus:               fnMinus_8b8229905258388dc16a5e0c270b0488,
			fnMonthAbbreviated:    fnMonthAbbreviated_aa9a9957cd9d056ba078b36a08b17478,
			fnMonthNarrow:         fnMonthNarrow_45916040ecf6fc350894d9e3e6c46dc7,
			fnMonthWide:           fnMonthWide_4c946a7e7581c665e7407df1841810b5,
			fnMonthsAbbreviated:   fnMonthsAbbreviated_181f77804b62232997fae36bd57d6cf7,
			fnMonthsNarrow:        fnMonthsNarrow_1edc513af8c7151dc8fe1f42c7d497ba,
			fnMonthsWide:          fnMonthsWide_0ecf36a8b72255e2fee9467af362e989,
			fnOrdinalPluralRule:   fnOrdinalPluralRule_a0e5467912a746c396065750c68e4318,
			fnPluralsCardinal:     fnPluralsCardinal_85b19cac1fab9f2c2cfb9eb41539aa0e,
			fnPluralsOrdinal:      fnPluralsOrdinal_16a60aa09da9778fa82fe463e83076de,
			fnPluralsRange:        fnPluralsRange_332465bda13eb808b3664fa0500f54ce,
			fnRangePluralRule:     fnRangePluralRule_cb15430758f15901fa8a71a0aedc08f8,
			fnWeekdayAbbreviated:  fnWeekdayAbbreviated_4ffbdfbd2be10e6bd8fb5a542a14664a,
			fnWeekdayNarrow:       fnWeekdayNarrow_e86921b3446df5ea9afe9504cfa20d1a,
			fnWeekdayShort:        fnWeekdayShort_82b231d4f504c6d71c7e495aa35cd3c2,
			fnWeekdayWide:         fnWeekdayWide_ab7e026d8685cefd89c5aeb5df512a9a,
			fnWeekdaysAbbreviated: fnWeekdaysAbbreviated_454a3d7d23c662520a64ae5245d404be,
			fnWeekdaysNarrow:      fnWeekdaysNarrow_d23eb0b7a498c40ce19d1bf231cad524,
			fnWeekdaysShort:       fnWeekdaysShort_eb6ee64d01e314991432b4469790d38b,
			fnWeekdaysWide:        fnWeekdaysWide_5e2bbf75a31e730429c100e8a0bd3ebd,
		}
	}
	translatorFuncs["ak_gh"] = func() locales.Translator {
		return &localen{

			locale:             "ak_GH",
			pluralsCardinal:    []locales.PluralRule{2, 6},
			pluralsOrdinal:     nil,
			pluralsRange:       []locales.PluralRule{2, 6},
			decimal:            ".",
			group:              ",",
			timeSeparator:      ":",
			currencies:         []string{"ADP", "AED", "AFA", "AFN", "ALK", "ALL", "AMD", "ANG", "AOA", "AOK", "AON", "AOR", "ARA", "ARL", "ARM", "ARP", "ARS", "ATS", "AUD", "AWG", "AZM", "AZN", "BAD", "BAM", "BAN", "BBD", "BDT", "BEC", "BEF", "BEL", "BGL", "BGM", "BGN", "BGO", "BHD", "BIF", "BMD", "BND", "BOB", "BOL", "BOP", "BOV", "BRB", "BRC", "BRE", "BRL", "BRN", "BRR", "BRZ", "BSD", "BTN", "BUK", "BWP", "BYB", "BYN", "BYR", "BZD", "CAD", "CDF", "CHE", "CHF", "CHW", "CLE", "CLF", "CLP", "CNH", "CNX", "CNY", "COP", "COU", "CRC", "CSD", "CSK", "CUC", "CUP", "CVE", "CYP", "CZK", "DDM", "DEM", "DJF", "DKK", "DOP", "DZD", "ECS", "ECV", "EEK", "EGP", "ERN", "ESA", "ESB", "ESP", "ETB", "EUR", "FIM", "FJD", "FKP", "FRF", "GBP", "GEK", "GEL", "GHC", "GHS", "GIP", "GMD", "GNF", "GNS", "GQE", "GRD", "GTQ", "GWE", "GWP", "GYD", "HKD", "HNL", "HRD", "HRK", "HTG", "HUF", "IDR", "IEP", "ILP", "ILR", "ILS", "INR", "IQD", "IRR", "ISJ", "ISK", "ITL", "JMD", "JOD", "JPY", "KES", "KGS", "KHR", "KMF", "KPW", "KRH", "KRO", "KRW", "KWD", "KYD", "KZT", "LAK", "LBP", "LKR", "LRD", "LSL", "LTL", "LTT", "LUC", "LUF", "LUL", "LVL", "LVR", "LYD", "MAD", "MAF", "MCF", "MDC", "MDL", "MGA", "MGF", "MKD", "MKN", "MLF", "MMK", "MNT", "MOP", "MRO", "MRU", "MTL", "MTP", "MUR", "MVP", "MVR", "MWK", "MXN", "MXP", "MXV", "MYR", "MZE", "MZM", "MZN", "NAD", "NGN", "NIC", "NIO", "NLG", "NOK", "NPR", "NZD", "OMR", "PAB", "PEI", "PEN", "PES", "PGK", "PHP", "PKR", "PLN", "PLZ", "PTE", "PYG", "QAR", "RHD", "ROL", "RON", "RSD", "RUB", "RUR", "RWF", "SAR", "SBD", "SCR", "SDD", "SDG", "SDP", "SEK", "SGD", "SHP", "SIT", "SKK", "SLL", "SOS", "SRD", "SRG", "SSP", "STD", "STN", "SUR", "SVC", "SYP", "SZL", "THB", "TJR", "TJS", "TMM", "TMT", "TND", "TOP", "TPE", "TRL", "TRY", "TTD", "TWD", "TZS", "UAH", "UAK", "UGS", "UGX", "USD", "USN", "USS", "UYI", "UYP", "UYU", "UYW", "UZS", "VEB", "VEF", "VES", "VND", "VNN", "VUV", "WST", "XAF", "XAG", "XAU", "XBA", "XBB", "XBC", "XBD", "XCD", "XDR", "XEU", "XFO", "XFU", "XOF", "XPD", "XPF", "XPT", "XRE", "XSU", "XTS", "XUA", "XXX", "YDD", "YER", "YUD", "YUM", "YUN", "YUR", "ZAL", "ZAR", "ZMK", "ZMW", "ZRN", "ZRZ", "ZWD", "ZWL", "ZWR"},
			monthsAbbreviated:  []string{"", "S-Ɔ", "K-Ɔ", "E-Ɔ", "E-O", "E-K", "O-A", "A-K", "D-Ɔ", "F-Ɛ", "Ɔ-A", "Ɔ-O", "M-Ɔ"},
			monthsWide:         []string{"", "Sanda-Ɔpɛpɔn", "Kwakwar-Ɔgyefuo", "Ebɔw-Ɔbenem", "Ebɔbira-Oforisuo", "Esusow Aketseaba-Kɔtɔnimba", "Obirade-Ayɛwohomumu", "Ayɛwoho-Kitawonsa", "Difuu-Ɔsandaa", "Fankwa-Ɛbɔ", "Ɔbɛsɛ-Ahinime", "Ɔberɛfɛw-Obubuo", "Mumu-Ɔpɛnimba"},
			daysAbbreviated:    []string{"Kwe", "Dwo", "Ben", "Wuk", "Yaw", "Fia", "Mem"},
			daysNarrow:         []string{"K", "D", "B", "W", "Y", "F", "M"},
			daysWide:           []string{"Kwesida", "Dwowda", "Benada", "Wukuda", "Yawda", "Fida", "Memeneda"},
			periodsAbbreviated: []string{"AN", "EW"},
			periodsWide:        []string{"AN", "EW"},
			erasAbbreviated:    []string{"AK", "KE"},
			erasNarrow:         []string{"", ""},
			erasWide:           []string{"Ansa Kristo", "Kristo Ekyiri"},
			timezones:          map[string]string{"ACDT": "ACDT", "ACST": "ACST", "ACWDT": "ACWDT", "ACWST": "ACWST", "ADT": "ADT", "AEDT": "AEDT", "AEST": "AEST", "AKDT": "AKDT", "AKST": "AKST", "ARST": "ARST", "ART": "ART", "AST": "AST", "AWDT": "AWDT", "AWST": "AWST", "BOT": "BOT", "BT": "BT", "CAT": "CAT", "CDT": "CDT", "CHADT": "CHADT", "CHAST": "CHAST", "CLST": "CLST", "CLT": "CLT", "COST": "COST", "COT": "COT", "CST": "CST", "ChST": "ChST", "EAT": "EAT", "ECT": "ECT", "EDT": "EDT", "EST": "EST", "GFT": "GFT", "GMT": "GMT", "GST": "GST", "GYT": "GYT", "HADT": "HADT", "HAST": "HAST", "HAT": "HAT", "HECU": "HECU", "HEEG": "HEEG", "HENOMX": "HENOMX", "HEOG": "HEOG", "HEPM": "HEPM", "HEPMX": "HEPMX", "HKST": "HKST", "HKT": "HKT", "HNCU": "HNCU", "HNEG": "HNEG", "HNNOMX": "HNNOMX", "HNOG": "HNOG", "HNPM": "HNPM", "HNPMX": "HNPMX", "HNT": "HNT", "IST": "IST", "JDT": "JDT", "JST": "JST", "LHDT": "LHDT", "LHST": "LHST", "MDT": "MDT", "MESZ": "MESZ", "MEZ": "MEZ", "MST": "MST", "MYT": "MYT", "NZDT": "NZDT", "NZST": "NZST", "OESZ": "OESZ", "OEZ": "OEZ", "PDT": "PDT", "PST": "PST", "SAST": "SAST", "SGT": "SGT", "SRT": "SRT", "TMST": "TMST", "TMT": "TMT", "UYST": "UYST", "UYT": "UYT", "VET": "VET", "WARST": "WARST", "WART": "WART", "WAST": "WAST", "WAT": "WAT", "WESZ": "WESZ", "WEZ": "WEZ", "WIB": "WIB", "WIT": "WIT", "WITA": "WITA", "∅∅∅": "∅∅∅"},

			fnCardinalPluralRule:  fnCardinalPluralRule_1a767992f2534d16887981ec7c7c1cfb,
			fnDecimal:             fnDecimal_a78485e7dd32c95f41af4e18420793bf,
			fnFmtAccounting:       fnFmtAccounting_ec9761d27ad9ead532f5f112e23983b1,
			fnFmtCurrency:         fnFmtCurrency_21670b336e6e64700cc7f949f05c390f,
			fnFmtDateFull:         fnFmtDateFull_9d575487ce5a187f6efc22e6d3f8a058,
			fnFmtDateLong:         fnFmtDateLong_4ff37a0cfcd7dfa30a768d81e70d334e,
			fnFmtDateMedium:       fnFmtDateMedium_596f6f3746d292714e1810c0b50dd05c,
			fnFmtDateShort:        fnFmtDateShort_93244c9b90b1456ed872d8fc125fd668,
			fnFmtNumber:           fnFmtNumber_2816fdab36e719be095a370ff42e599f,
			fnFmtPercent:          fnFmtPercent_016773d83796aa19d80b7c33bf377883,
			fnFmtTimeFull:         fnFmtTimeFull_37fe4deeee789852cc196a6a1a2f0ccc,
			fnFmtTimeLong:         fnFmtTimeLong_4429ef4fb58a2a9c4d7d5132fd16ecbf,
			fnFmtTimeMedium:       fnFmtTimeMedium_8ef07f6477b7a4944577d4e5392ff21b,
			fnFmtTimeShort:        fnFmtTimeShort_8288b817c5c0216c9815524c71c9e0b4,
			fnGroup:               fnGroup_5c4b80a5ccdee81467241784ab8fcd56,
			fnLocale:              fnLocale_5a217059c67094defae82f249f55f4c5,
			fnMinus:               fnMinus_8b8229905258388dc16a5e0c270b0488,
			fnMonthAbbreviated:    fnMonthAbbreviated_aa9a9957cd9d056ba078b36a08b17478,
			fnMonthNarrow:         fnMonthNarrow_45916040ecf6fc350894d9e3e6c46dc7,
			fnMonthWide:           fnMonthWide_4c946a7e7581c665e7407df1841810b5,
			fnMonthsAbbreviated:   fnMonthsAbbreviated_181f77804b62232997fae36bd57d6cf7,
			fnMonthsNarrow:        fnMonthsNarrow_1edc513af8c7151dc8fe1f42c7d497ba,
			fnMonthsWide:          fnMonthsWide_0ecf36a8b72255e2fee9467af362e989,
			fnOrdinalPluralRule:   fnOrdinalPluralRule_a0e5467912a746c396065750c68e4318,
			fnPluralsCardinal:     fnPluralsCardinal_85b19cac1fab9f2c2cfb9eb41539aa0e,
			fnPluralsOrdinal:      fnPluralsOrdinal_16a60aa09da9778fa82fe463e83076de,
			fnPluralsRange:        fnPluralsRange_332465bda13eb808b3664fa0500f54ce,
			fnRangePluralRule:     fnRangePluralRule_cb15430758f15901fa8a71a0aedc08f8,
			fnWeekdayAbbreviated:  fnWeekdayAbbreviated_4ffbdfbd2be10e6bd8fb5a542a14664a,
			fnWeekdayNarrow:       fnWeekdayNarrow_e86921b3446df5ea9afe9504cfa20d1a,
			fnWeekdayShort:        fnWeekdayShort_82b231d4f504c6d71c7e495aa35cd3c2,
			fnWeekdayWide:         fnWeekdayWide_ab7e026d8685cefd89c5aeb5df512a9a,
			fnWeekdaysAbbreviated: fnWeekdaysAbbreviated_454a3d7d23c662520a64ae5245d404be,
			fnWeekdaysNarrow:      fnWeekdaysNarrow_d23eb0b7a498c40ce19d1bf231cad524,
			fnWeekdaysShort:       fnWeekdaysShort_eb6ee64d01e314991432b4469790d38b,
			fnWeekdaysWide:        fnWeekdaysWide_5e2bbf75a31e730429c100e8a0bd3ebd,
		}
	}
	translatorFuncs["am"] = func() locales.Translator {
		return &localen{

			locale:                 "am",
			pluralsCardinal:        []locales.PluralRule{2, 6},
			pluralsOrdinal:         []locales.PluralRule{6},
			pluralsRange:           []locales.PluralRule{2, 6},
			decimal:                ".",
			group:                  ",",
			minus:                  "-",
			percent:                "%",
			perMille:               "‰",
			timeSeparator:          ":",
			inifinity:              "∞",
			currencies:             []string{"ADP", "AED", "AFA", "AFN", "ALK", "ALL", "AMD", "ANG", "AOA", "AOK", "AON", "AOR", "ARA", "ARL", "ARM", "ARP", "ARS", "ATS", "AU$", "AWG", "AZM", "AZN", "BAD", "BAM", "BAN", "BBD", "BDT", "BEC", "BEF", "BEL", "BGL", "BGM", "BGN", "BGO", "BHD", "BIF", "BMD", "BND", "BOB", "BOL", "BOP", "BOV", "BRB", "BRC", "BRE", "R$", "BRN", "BRR", "BRZ", "BSD", "BTN", "BUK", "BWP", "BYB", "BYN", "BYR", "BZD", "CA$", "CDF", "CHE", "CHF", "CHW", "CLE", "CLF", "CLP", "የቻይና ዩዋን", "CNX", "CN¥", "COP", "COU", "CRC", "CSD", "CSK", "CUC", "CUP", "CVE", "CYP", "CZK", "DDM", "DEM", "DJF", "DKK", "DOP", "DZD", "ECS", "ECV", "EEK", "EGP", "ERN", "ESA", "ESB", "ESP", "ብር", "€", "FIM", "FJD", "FKP", "FRF", "£", "GEK", "GEL", "GHC", "GHS", "GIP", "GMD", "GNF", "GNS", "GQE", "GRD", "GTQ", "GWE", "GWP", "GYD", "HK$", "HNL", "HRD", "HRK", "HTG", "HUF", "IDR", "IEP", "ILP", "ILR", "₪", "₹", "IQD", "IRR", "ISJ", "ISK", "ITL", "JMD", "JOD", "JP¥", "KES", "KGS", "KHR", "KMF", "KPW", "KRH", "KRO", "₩", "KWD", "KYD", "KZT", "LAK", "LBP", "LKR", "LRD", "LSL", "LTL", "LTT", "LUC", "LUF", "LUL", "LVL", "LVR", "LYD", "MAD", "MAF", "MCF", "MDC", "MDL", "MGA", "MGF", "MKD", "MKN", "MLF", "MMK", "MNT", "MOP", "MRO", "MRU", "MTL", "MTP", "MUR", "MVP", "MVR", "MWK", "MX$", "MXP", "MXV", "MYR", "MZE", "MZM", "MZN", "NAD", "NGN", "NIC", "NIO", "NLG", "NOK", "NPR", "NZ$", "OMR", "PAB", "PEI", "PEN", "PES", "PGK", "PHP", "PKR", "PLN", "PLZ", "PTE", "PYG", "QAR", "RHD", "ROL", "RON", "RSD", "RUB", "RUR", "RWF", "SAR", "SBD", "SCR", "SDD", "SDG", "SDP", "SEK", "SGD", "SHP", "SIT", "SKK", "SLL", "SOS", "SRD", "SRG", "SSP", "STD", "STN", "SUR", "SVC", "SYP", "SZL", "฿", "TJR", "TJS", "TMM", "TMT", "TND", "TOP", "TPE", "TRL", "TRY", "TTD", "NT$", "TZS", "UAH", "UAK", "UGS", "UGX", "US$", "USN", "USS", "UYI", "UYP", "UYU", "UYW", "UZS", "VEB", "VEF", "VES", "₫", "VNN", "VUV", "WST", "FCFA", "XAG", "XAU", "XBA", "XBB", "XBC", "XBD", "EC$", "XDR", "XEU", "XFO", "XFU", "CFA", "XPD", "CFPF", "XPT", "XRE", "XSU", "XTS", "XUA", "XXX", "YDD", "YER", "YUD", "YUM", "YUN", "YUR", "ZAL", "ZAR", "ZMK", "ZMW", "ZRN", "ZRZ", "ZWD", "ZWL", "ZWR"},
			currencyNegativePrefix: "(",
			currencyNegativeSuffix: ")",
			monthsAbbreviated:      []string{"", "ጃንዩ", "ፌብሩ", "ማርች", "ኤፕሪ", "ሜይ", "ጁን", "ጁላይ", "ኦገስ", "ሴፕቴ", "ኦክቶ", "ኖቬም", "ዲሴም"},
			monthsNarrow:           []string{"", "ጃ", "ፌ", "ማ", "ኤ", "ሜ", "ጁ", "ጁ", "ኦ", "ሴ", "ኦ", "ኖ", "ዲ"},
			monthsWide:             []string{"", "ጃንዩወሪ", "ፌብሩወሪ", "ማርች", "ኤፕሪል", "ሜይ", "ጁን", "ጁላይ", "ኦገስት", "ሴፕቴምበር", "ኦክቶበር", "ኖቬምበር", "ዲሴምበር"},
			daysAbbreviated:        []string{"እሑድ", "ሰኞ", "ማክሰ", "ረቡዕ", "ሐሙስ", "ዓርብ", "ቅዳሜ"},
			daysNarrow:             []string{"እ", "ሰ", "ማ", "ረ", "ሐ", "ዓ", "ቅ"},
			daysShort:              []string{"እ", "ሰ", "ማ", "ረ", "ሐ", "ዓ", "ቅ"},
			daysWide:               []string{"እሑድ", "ሰኞ", "ማክሰኞ", "ረቡዕ", "ሐሙስ", "ዓርብ", "ቅዳሜ"},
			periodsAbbreviated:     []string{"ጥዋት", "ከሰዓት"},
			periodsNarrow:          []string{"ጠ", "ከ"},
			periodsWide:            []string{"ጥዋት", "ከሰዓት"},
			erasAbbreviated:        []string{"", ""},
			erasNarrow:             []string{"ዓ/ዓ", "ዓ/ም"},
			erasWide:               []string{"ዓመተ ዓለም", "ዓመተ ምሕረት"},
			timezones:              map[string]string{"ACDT": "የአውስትራሊያ መካከለኛ የቀን ሰዓት አቆጣጠር", "ACST": "የአውስትራሊያ መካከለኛ መደበኛ የሰዓት አቆጣጠር", "ACWDT": "የአውስትራሊያ መካከለኛው ምስራቅ የቀን ሰዓት አቆጣጠር", "ACWST": "የአውስትራሊያ መካከለኛ ምስራቃዊ መደበኛ ሰዓት አቆጣጠር", "ADT": "የአትላንቲክ የቀን ሰዓት አቆጣጠር", "AEDT": "የአውስትራሊያ ምዕራባዊ የቀን ሰዓት አቆጣጠር", "AEST": "የአውስትራሊያ ምዕራባዊ መደበኛ የሰዓት አቆጣጠር", "AKDT": "የአላስካ የቀን ሰዓት አቆጣጠር", "AKST": "የአላስካ መደበኛ የሰዓት አቆጣጠር", "ARST": "የአርጀንቲና የበጋ ሰዓት አቆጣጠር", "ART": "የአርጀንቲና መደበኛ ሰዓት አቆጣጠር", "AST": "የአትላንቲክ መደበኛ የሰዓት አቆጣጠር", "AWDT": "የአውስትራሊያ ምስራቃዊ የቀን ሰዓት አቆጣጠር", "AWST": "የአውስትራሊያ ምስራቃዊ መደበኛ ሰዓት አቆጣጠር", "BOT": "የቦሊቪያ ሰዓት", "BT": "የቡታን ሰዓት", "CAT": "የመካከለኛው አፍሪካ ሰዓት", "CDT": "የመካከለኛ የቀን ሰዓት አቆጣጠር", "CHADT": "የቻታም የቀን ብርሃን ሰዓት", "CHAST": "የቻታም መደበኛ ሰዓት", "CLST": "የቺሊ ክረምት ሰዓት", "CLT": "የቺሊ መደበኛ ሰዓት", "COST": "የኮሎምቢያ ክረምት ሰዓት", "COT": "የኮሎምቢያ መደበኛ ሰዓት", "CST": "የሰሜን አሜሪካ የመካከለኛ መደበኛ ሰዓት አቆጣጠር", "ChST": "የቻሞሮ መደበኛ ሰዓት", "EAT": "የምስራቅ አፍሪካ ሰዓት", "ECT": "የኢኳዶር ሰዓት", "EDT": "ምስራቃዊ የቀን ሰዓት አቆጣጠር", "EST": "ምስራቃዊ መደበኛ ሰዓት አቆጣጠር", "GFT": "የፈረንሳይ ጉያና ሰዓት", "GMT": "ግሪንዊች ማዕከላዊ ሰዓት", "GST": "የባህረሰላጤ መደበኛ ሰዓት", "GYT": "የጉያና ሰዓት", "HADT": "የሃዋይ አሌኡት የቀን ሰዓት አቆጣጠር", "HAST": "የሃዋይ አሌኡት መደበኛ ሰዓት አቆጣጠር", "HAT": "የኒውፋውንድላንድ የቀን የሰዓት አቆጣጠር", "HECU": "የኩባ የቀን ብርሃን ሰዓት", "HEEG": "የምስራቅ ግሪንላንድ ክረምት ሰዓት", "HENOMX": "ሰሜናዊ ምእራብ የሜክሲኮ የቀን ሰዓት አቆጣጠር", "HEOG": "የምዕራብ ግሪንላንድ ክረምት ሰዓት", "HEPM": "ቅዱስ የፒዬር እና ሚኴሎን የቀን ብርሃን ሰዓት", "HEPMX": "የሜክሲኮ ፓሲፊክ የቀን ሰዓት አቆጣጠር", "HKST": "የሆንግ ኮንግ ክረምት ሰዓት", "HKT": "የሆንግ ኮንግ መደበኛ ሰዓት", "HNCU": "የኩባ መደበኛ ሰዓት", "HNEG": "የምስራቅ ግሪንላንድ መደበኛ ሰዓት", "HNNOMX": "ሰሜናዊ ምእራብ የሜክሲኮ መደበኛ ሰዓት አቆጣጠር", "HNOG": "የምዕራብ ግሪንላንድ መደበኛ ሰዓት", "HNPM": "ቅዱስ የፒዬር እና ሚኴሎን መደበኛ ሰዓት", "HNPMX": "የሜክሲኮ ፓሲፊክ መደበኛ ሰዓት አቆጣጠር", "HNT": "የኒውፋውንድላንድ መደበኛ የሰዓት አቆጣጠር", "IST": "የህንድ መደበኛ ሰዓት", "JDT": "የጃፓን የቀን ብርሃን ሰዓት", "JST": "የጃፓን መደበኛ ሰዓት", "LHDT": "የሎርድ ሆዌ የቀን ሰዓት አቆጣጠር", "LHST": "የሎርድ ሆዌ መደበኛ የሰዓት አቆጣጠር", "MDT": "የተራራ የቀንሰዓት አቆጣጠር", "MESZ": "የመካከለኛው አውሮፓ ክረምት ሰዓት", "MEZ": "የመካከለኛው አውሮፓ መደበኛ ሰዓት", "MST": "የተራራ መደበኛ የሰዓት አቆጣጠር", "MYT": "የማሌይዢያ ሰዓት", "NZDT": "የኒው ዚላንድ የቀን ብርሃን ሰዓት", "NZST": "የኒው ዚላንድ መደበኛ ሰዓት", "OESZ": "የምስራቃዊ አውሮፓ ክረምት ሰዓት", "OEZ": "የምስራቃዊ አውሮፓ መደበኛ ሰዓት", "PDT": "የፓስፊክ የቀን ሰዓት አቆጣጠር", "PST": "የፓስፊክ መደበኛ ሰዓት አቆጣጠር", "SAST": "የደቡብ አፍሪካ መደበኛ ሰዓት", "SGT": "የሲንጋፒር መደበኛ ሰዓት", "SRT": "የሱሪናም ሰዓት", "TMST": "የቱርክመኒስታን ክረምት ሰዓት", "TMT": "የቱርክመኒስታን መደበኛ ሰዓት", "UYST": "የኡራጓይ ክረምት ሰዓት", "UYT": "የኡራጓይ መደበኛ ሰዓት", "VET": "የቬኔዝዌላ ሰዓት", "WARST": "የአርጀንቲና ምስራቃዊ በጋ ሰዓት አቆጣጠር", "WART": "የምዕራባዊ አርጀንቲና መደበኛ ሰዓት አቆጣጠር", "WAST": "የምዕራብ አፍሪካ ክረምት ሰዓት", "WAT": "የምዕራብ አፍሪካ መደበኛ ሰዓት", "WESZ": "የምዕራባዊ አውሮፓ ክረምት ሰዓት", "WEZ": "የምዕራባዊ አውሮፓ መደበኛ ሰዓት", "WIB": "የምዕራባዊ ኢንዶኔዢያ ሰዓት", "WIT": "የምስራቃዊ ኢንዶኔዢያ ሰዓት", "WITA": "የመካከለኛው ኢንዶኔዢያ ሰዓት", "∅∅∅": "የብራዚላ የበጋ ሰዓት አቆጣጠር"},

			fnCardinalPluralRule:  fnCardinalPluralRule_75ab0b9c6a421f5e6ca85392796c18cc,
			fnDecimal:             fnDecimal_a78485e7dd32c95f41af4e18420793bf,
			fnFmtAccounting:       fnFmtAccounting_632207f09bf5cde35a195cefb6bc8623,
			fnFmtCurrency:         fnFmtCurrency_6c366a94338df615a7797e45c90cead1,
			fnFmtDateFull:         fnFmtDateFull_3b6427a32603f02ec4f5128c007220b3,
			fnFmtDateLong:         fnFmtDateLong_506f643cda0514f66d873a9ea99bf639,
			fnFmtDateMedium:       fnFmtDateMedium_cb43e8c32d5cd0a27ac6db293a7981fd,
			fnFmtDateShort:        fnFmtDateShort_529ba7a02bedd437d0833b1afdb768c8,
			fnFmtNumber:           fnFmtNumber_fc1f852c40326b41ed4436818cad7bfb,
			fnFmtPercent:          fnFmtPercent_1c35b3868bf10d0e69b22b2e80c40671,
			fnFmtTimeFull:         fnFmtTimeFull_37fe4deeee789852cc196a6a1a2f0ccc,
			fnFmtTimeLong:         fnFmtTimeLong_4429ef4fb58a2a9c4d7d5132fd16ecbf,
			fnFmtTimeMedium:       fnFmtTimeMedium_8ef07f6477b7a4944577d4e5392ff21b,
			fnFmtTimeShort:        fnFmtTimeShort_8288b817c5c0216c9815524c71c9e0b4,
			fnGroup:               fnGroup_5c4b80a5ccdee81467241784ab8fcd56,
			fnLocale:              fnLocale_5a217059c67094defae82f249f55f4c5,
			fnMinus:               fnMinus_8b8229905258388dc16a5e0c270b0488,
			fnMonthAbbreviated:    fnMonthAbbreviated_aa9a9957cd9d056ba078b36a08b17478,
			fnMonthNarrow:         fnMonthNarrow_45916040ecf6fc350894d9e3e6c46dc7,
			fnMonthWide:           fnMonthWide_4c946a7e7581c665e7407df1841810b5,
			fnMonthsAbbreviated:   fnMonthsAbbreviated_181f77804b62232997fae36bd57d6cf7,
			fnMonthsNarrow:        fnMonthsNarrow_75daa2ba82ae9577292175c3f52370cc,
			fnMonthsWide:          fnMonthsWide_0ecf36a8b72255e2fee9467af362e989,
			fnOrdinalPluralRule:   fnOrdinalPluralRule_3355865f05dde9af2a36ba415bea85cb,
			fnPluralsCardinal:     fnPluralsCardinal_85b19cac1fab9f2c2cfb9eb41539aa0e,
			fnPluralsOrdinal:      fnPluralsOrdinal_16a60aa09da9778fa82fe463e83076de,
			fnPluralsRange:        fnPluralsRange_332465bda13eb808b3664fa0500f54ce,
			fnRangePluralRule:     fnRangePluralRule_f6915080a9290ab0c1dd0a3b010cbce8,
			fnWeekdayAbbreviated:  fnWeekdayAbbreviated_4ffbdfbd2be10e6bd8fb5a542a14664a,
			fnWeekdayNarrow:       fnWeekdayNarrow_e86921b3446df5ea9afe9504cfa20d1a,
			fnWeekdayShort:        fnWeekdayShort_82b231d4f504c6d71c7e495aa35cd3c2,
			fnWeekdayWide:         fnWeekdayWide_ab7e026d8685cefd89c5aeb5df512a9a,
			fnWeekdaysAbbreviated: fnWeekdaysAbbreviated_454a3d7d23c662520a64ae5245d404be,
			fnWeekdaysNarrow:      fnWeekdaysNarrow_d23eb0b7a498c40ce19d1bf231cad524,
			fnWeekdaysShort:       fnWeekdaysShort_eb6ee64d01e314991432b4469790d38b,
			fnWeekdaysWide:        fnWeekdaysWide_5e2bbf75a31e730429c100e8a0bd3ebd,
		}
	}
	translatorFuncs["am_et"] = func() locales.Translator {
		return &localen{

			locale:                 "am_ET",
			pluralsCardinal:        []locales.PluralRule{2, 6},
			pluralsOrdinal:         []locales.PluralRule{6},
			pluralsRange:           []locales.PluralRule{2, 6},
			decimal:                ".",
			group:                  ",",
			minus:                  "-",
			percent:                "%",
			perMille:               "‰",
			timeSeparator:          ":",
			inifinity:              "∞",
			currencies:             []string{"ADP", "AED", "AFA", "AFN", "ALK", "ALL", "AMD", "ANG", "AOA", "AOK", "AON", "AOR", "ARA", "ARL", "ARM", "ARP", "ARS", "ATS", "AUD", "AWG", "AZM", "AZN", "BAD", "BAM", "BAN", "BBD", "BDT", "BEC", "BEF", "BEL", "BGL", "BGM", "BGN", "BGO", "BHD", "BIF", "BMD", "BND", "BOB", "BOL", "BOP", "BOV", "BRB", "BRC", "BRE", "BRL", "BRN", "BRR", "BRZ", "BSD", "BTN", "BUK", "BWP", "BYB", "BYN", "BYR", "BZD", "CAD", "CDF", "CHE", "CHF", "CHW", "CLE", "CLF", "CLP", "CNH", "CNX", "CNY", "COP", "COU", "CRC", "CSD", "CSK", "CUC", "CUP", "CVE", "CYP", "CZK", "DDM", "DEM", "DJF", "DKK", "DOP", "DZD", "ECS", "ECV", "EEK", "EGP", "ERN", "ESA", "ESB", "ESP", "ETB", "EUR", "FIM", "FJD", "FKP", "FRF", "GBP", "GEK", "GEL", "GHC", "GHS", "GIP", "GMD", "GNF", "GNS", "GQE", "GRD", "GTQ", "GWE", "GWP", "GYD", "HKD", "HNL", "HRD", "HRK", "HTG", "HUF", "IDR", "IEP", "ILP", "ILR", "ILS", "INR", "IQD", "IRR", "ISJ", "ISK", "ITL", "JMD", "JOD", "JPY", "KES", "KGS", "KHR", "KMF", "KPW", "KRH", "KRO", "KRW", "KWD", "KYD", "KZT", "LAK", "LBP", "LKR", "LRD", "LSL", "LTL", "LTT", "LUC", "LUF", "LUL", "LVL", "LVR", "LYD", "MAD", "MAF", "MCF", "MDC", "MDL", "MGA", "MGF", "MKD", "MKN", "MLF", "MMK", "MNT", "MOP", "MRO", "MRU", "MTL", "MTP", "MUR", "MVP", "MVR", "MWK", "MXN", "MXP", "MXV", "MYR", "MZE", "MZM", "MZN", "NAD", "NGN", "NIC", "NIO", "NLG", "NOK", "NPR", "NZD", "OMR", "PAB", "PEI", "PEN", "PES", "PGK", "PHP", "PKR", "PLN", "PLZ", "PTE", "PYG", "QAR", "RHD", "ROL", "RON", "RSD", "RUB", "RUR", "RWF", "SAR", "SBD", "SCR", "SDD", "SDG", "SDP", "SEK", "SGD", "SHP", "SIT", "SKK", "SLL", "SOS", "SRD", "SRG", "SSP", "STD", "STN", "SUR", "SVC", "SYP", "SZL", "THB", "TJR", "TJS", "TMM", "TMT", "TND", "TOP", "TPE", "TRL", "TRY", "TTD", "TWD", "TZS", "UAH", "UAK", "UGS", "UGX", "USD", "USN", "USS", "UYI", "UYP", "UYU", "UYW", "UZS", "VEB", "VEF", "VES", "VND", "VNN", "VUV", "WST", "XAF", "XAG", "XAU", "XBA", "XBB", "XBC", "XBD", "XCD", "XDR", "XEU", "XFO", "XFU", "XOF", "XPD", "XPF", "XPT", "XRE", "XSU", "XTS", "XUA", "XXX", "YDD", "YER", "YUD", "YUM", "YUN", "YUR", "ZAL", "ZAR", "ZMK", "ZMW", "ZRN", "ZRZ", "ZWD", "ZWL", "ZWR"},
			currencyNegativePrefix: "(",
			currencyNegativeSuffix: ")",
			monthsAbbreviated:      []string{"", "ጃንዩ", "ፌብሩ", "ማርች", "ኤፕሪ", "ሜይ", "ጁን", "ጁላይ", "ኦገስ", "ሴፕቴ", "ኦክቶ", "ኖቬም", "ዲሴም"},
			monthsNarrow:           []string{"", "ጃ", "ፌ", "ማ", "ኤ", "ሜ", "ጁ", "ጁ", "ኦ", "ሴ", "ኦ", "ኖ", "ዲ"},
			monthsWide:             []string{"", "ጃንዩወሪ", "ፌብሩወሪ", "ማርች", "ኤፕሪል", "ሜይ", "ጁን", "ጁላይ", "ኦገስት", "ሴፕቴምበር", "ኦክቶበር", "ኖቬምበር", "ዲሴምበር"},
			daysAbbreviated:        []string{"እሑድ", "ሰኞ", "ማክሰ", "ረቡዕ", "ሐሙስ", "ዓርብ", "ቅዳሜ"},
			daysNarrow:             []string{"እ", "ሰ", "ማ", "ረ", "ሐ", "ዓ", "ቅ"},
			daysShort:              []string{"እ", "ሰ", "ማ", "ረ", "ሐ", "ዓ", "ቅ"},
			daysWide:               []string{"እሑድ", "ሰኞ", "ማክሰኞ", "ረቡዕ", "ሐሙስ", "ዓርብ", "ቅዳሜ"},
			periodsAbbreviated:     []string{"ጥዋት", "ከሰዓት"},
			periodsNarrow:          []string{"ጠ", "ከ"},
			periodsWide:            []string{"ጥዋት", "ከሰዓት"},
			erasAbbreviated:        []string{"", ""},
			erasNarrow:             []string{"ዓ/ዓ", "ዓ/ም"},
			erasWide:               []string{"ዓመተ ዓለም", "ዓመተ ምሕረት"},
			timezones:              map[string]string{"ACDT": "የአውስትራሊያ መካከለኛ የቀን ሰዓት አቆጣጠር", "ACST": "የአውስትራሊያ መካከለኛ መደበኛ የሰዓት አቆጣጠር", "ACWDT": "የአውስትራሊያ መካከለኛው ምስራቅ የቀን ሰዓት አቆጣጠር", "ACWST": "የአውስትራሊያ መካከለኛ ምስራቃዊ መደበኛ ሰዓት አቆጣጠር", "ADT": "የአትላንቲክ የቀን ሰዓት አቆጣጠር", "AEDT": "የአውስትራሊያ ምዕራባዊ የቀን ሰዓት አቆጣጠር", "AEST": "የአውስትራሊያ ምዕራባዊ መደበኛ የሰዓት አቆጣጠር", "AKDT": "የአላስካ የቀን ሰዓት አቆጣጠር", "AKST": "የአላስካ መደበኛ የሰዓት አቆጣጠር", "ARST": "የአርጀንቲና የበጋ ሰዓት አቆጣጠር", "ART": "የአርጀንቲና መደበኛ ሰዓት አቆጣጠር", "AST": "የአትላንቲክ መደበኛ የሰዓት አቆጣጠር", "AWDT": "የአውስትራሊያ ምስራቃዊ የቀን ሰዓት አቆጣጠር", "AWST": "የአውስትራሊያ ምስራቃዊ መደበኛ ሰዓት አቆጣጠር", "BOT": "የቦሊቪያ ሰዓት", "BT": "የቡታን ሰዓት", "CAT": "የመካከለኛው አፍሪካ ሰዓት", "CDT": "የመካከለኛ የቀን ሰዓት አቆጣጠር", "CHADT": "የቻታም የቀን ብርሃን ሰዓት", "CHAST": "የቻታም መደበኛ ሰዓት", "CLST": "የቺሊ ክረምት ሰዓት", "CLT": "የቺሊ መደበኛ ሰዓት", "COST": "የኮሎምቢያ ክረምት ሰዓት", "COT": "የኮሎምቢያ መደበኛ ሰዓት", "CST": "የሰሜን አሜሪካ የመካከለኛ መደበኛ ሰዓት አቆጣጠር", "ChST": "የቻሞሮ መደበኛ ሰዓት", "EAT": "የምስራቅ አፍሪካ ሰዓት", "ECT": "የኢኳዶር ሰዓት", "EDT": "ምስራቃዊ የቀን ሰዓት አቆጣጠር", "EST": "ምስራቃዊ መደበኛ ሰዓት አቆጣጠር", "GFT": "የፈረንሳይ ጉያና ሰዓት", "GMT": "ግሪንዊች ማዕከላዊ ሰዓት", "GST": "የባህረሰላጤ መደበኛ ሰዓት", "GYT": "የጉያና ሰዓት", "HADT": "የሃዋይ አሌኡት የቀን ሰዓት አቆጣጠር", "HAST": "የሃዋይ አሌኡት መደበኛ ሰዓት አቆጣጠር", "HAT": "የኒውፋውንድላንድ የቀን የሰዓት አቆጣጠር", "HECU": "የኩባ የቀን ብርሃን ሰዓት", "HEEG": "የምስራቅ ግሪንላንድ ክረምት ሰዓት", "HENOMX": "ሰሜናዊ ምእራብ የሜክሲኮ የቀን ሰዓት አቆጣጠር", "HEOG": "የምዕራብ ግሪንላንድ ክረምት ሰዓት", "HEPM": "ቅዱስ የፒዬር እና ሚኴሎን የቀን ብርሃን ሰዓት", "HEPMX": "የሜክሲኮ ፓሲፊክ የቀን ሰዓት አቆጣጠር", "HKST": "የሆንግ ኮንግ ክረምት ሰዓት", "HKT": "የሆንግ ኮንግ መደበኛ ሰዓት", "HNCU": "የኩባ መደበኛ ሰዓት", "HNEG": "የምስራቅ ግሪንላንድ መደበኛ ሰዓት", "HNNOMX": "ሰሜናዊ ምእራብ የሜክሲኮ መደበኛ ሰዓት አቆጣጠር", "HNOG": "የምዕራብ ግሪንላንድ መደበኛ ሰዓት", "HNPM": "ቅዱስ የፒዬር እና ሚኴሎን መደበኛ ሰዓት", "HNPMX": "የሜክሲኮ ፓሲፊክ መደበኛ ሰዓት አቆጣጠር", "HNT": "የኒውፋውንድላንድ መደበኛ የሰዓት አቆጣጠር", "IST": "የህንድ መደበኛ ሰዓት", "JDT": "የጃፓን የቀን ብርሃን ሰዓት", "JST": "የጃፓን መደበኛ ሰዓት", "LHDT": "የሎርድ ሆዌ የቀን ሰዓት አቆጣጠር", "LHST": "የሎርድ ሆዌ መደበኛ የሰዓት አቆጣጠር", "MDT": "የተራራ የቀንሰዓት አቆጣጠር", "MESZ": "የመካከለኛው አውሮፓ ክረምት ሰዓት", "MEZ": "የመካከለኛው አውሮፓ መደበኛ ሰዓት", "MST": "የተራራ መደበኛ የሰዓት አቆጣጠር", "MYT": "የማሌይዢያ ሰዓት", "NZDT": "የኒው ዚላንድ የቀን ብርሃን ሰዓት", "NZST": "የኒው ዚላንድ መደበኛ ሰዓት", "OESZ": "የምስራቃዊ አውሮፓ ክረምት ሰዓት", "OEZ": "የምስራቃዊ አውሮፓ መደበኛ ሰዓት", "PDT": "የፓስፊክ የቀን ሰዓት አቆጣጠር", "PST": "የፓስፊክ መደበኛ ሰዓት አቆጣጠር", "SAST": "የደቡብ አፍሪካ መደበኛ ሰዓት", "SGT": "የሲንጋፒር መደበኛ ሰዓት", "SRT": "የሱሪናም ሰዓት", "TMST": "የቱርክመኒስታን ክረምት ሰዓት", "TMT": "የቱርክመኒስታን መደበኛ ሰዓት", "UYST": "የኡራጓይ ክረምት ሰዓት", "UYT": "የኡራጓይ መደበኛ ሰዓት", "VET": "የቬኔዝዌላ ሰዓት", "WARST": "የአርጀንቲና ምስራቃዊ በጋ ሰዓት አቆጣጠር", "WART": "የምዕራባዊ አርጀንቲና መደበኛ ሰዓት አቆጣጠር", "WAST": "የምዕራብ አፍሪካ ክረምት ሰዓት", "WAT": "የምዕራብ አፍሪካ መደበኛ ሰዓት", "WESZ": "የምዕራባዊ አውሮፓ ክረምት ሰዓት", "WEZ": "የምዕራባዊ አውሮፓ መደበኛ ሰዓት", "WIB": "የምዕራባዊ ኢንዶኔዢያ ሰዓት", "WIT": "የምስራቃዊ ኢንዶኔዢያ ሰዓት", "WITA": "የመካከለኛው ኢንዶኔዢያ ሰዓት", "∅∅∅": "የፔሩ ክረምት ሰዓት"},

			fnCardinalPluralRule:  fnCardinalPluralRule_75ab0b9c6a421f5e6ca85392796c18cc,
			fnDecimal:             fnDecimal_a78485e7dd32c95f41af4e18420793bf,
			fnFmtAccounting:       fnFmtAccounting_632207f09bf5cde35a195cefb6bc8623,
			fnFmtCurrency:         fnFmtCurrency_6c366a94338df615a7797e45c90cead1,
			fnFmtDateFull:         fnFmtDateFull_3b6427a32603f02ec4f5128c007220b3,
			fnFmtDateLong:         fnFmtDateLong_506f643cda0514f66d873a9ea99bf639,
			fnFmtDateMedium:       fnFmtDateMedium_cb43e8c32d5cd0a27ac6db293a7981fd,
			fnFmtDateShort:        fnFmtDateShort_529ba7a02bedd437d0833b1afdb768c8,
			fnFmtNumber:           fnFmtNumber_fc1f852c40326b41ed4436818cad7bfb,
			fnFmtPercent:          fnFmtPercent_1c35b3868bf10d0e69b22b2e80c40671,
			fnFmtTimeFull:         fnFmtTimeFull_37fe4deeee789852cc196a6a1a2f0ccc,
			fnFmtTimeLong:         fnFmtTimeLong_4429ef4fb58a2a9c4d7d5132fd16ecbf,
			fnFmtTimeMedium:       fnFmtTimeMedium_8ef07f6477b7a4944577d4e5392ff21b,
			fnFmtTimeShort:        fnFmtTimeShort_8288b817c5c0216c9815524c71c9e0b4,
			fnGroup:               fnGroup_5c4b80a5ccdee81467241784ab8fcd56,
			fnLocale:              fnLocale_5a217059c67094defae82f249f55f4c5,
			fnMinus:               fnMinus_8b8229905258388dc16a5e0c270b0488,
			fnMonthAbbreviated:    fnMonthAbbreviated_aa9a9957cd9d056ba078b36a08b17478,
			fnMonthNarrow:         fnMonthNarrow_45916040ecf6fc350894d9e3e6c46dc7,
			fnMonthWide:           fnMonthWide_4c946a7e7581c665e7407df1841810b5,
			fnMonthsAbbreviated:   fnMonthsAbbreviated_181f77804b62232997fae36bd57d6cf7,
			fnMonthsNarrow:        fnMonthsNarrow_75daa2ba82ae9577292175c3f52370cc,
			fnMonthsWide:          fnMonthsWide_0ecf36a8b72255e2fee9467af362e989,
			fnOrdinalPluralRule:   fnOrdinalPluralRule_3355865f05dde9af2a36ba415bea85cb,
			fnPluralsCardinal:     fnPluralsCardinal_85b19cac1fab9f2c2cfb9eb41539aa0e,
			fnPluralsOrdinal:      fnPluralsOrdinal_16a60aa09da9778fa82fe463e83076de,
			fnPluralsRange:        fnPluralsRange_332465bda13eb808b3664fa0500f54ce,
			fnRangePluralRule:     fnRangePluralRule_f6915080a9290ab0c1dd0a3b010cbce8,
			fnWeekdayAbbreviated:  fnWeekdayAbbreviated_4ffbdfbd2be10e6bd8fb5a542a14664a,
			fnWeekdayNarrow:       fnWeekdayNarrow_e86921b3446df5ea9afe9504cfa20d1a,
			fnWeekdayShort:        fnWeekdayShort_82b231d4f504c6d71c7e495aa35cd3c2,
			fnWeekdayWide:         fnWeekdayWide_ab7e026d8685cefd89c5aeb5df512a9a,
			fnWeekdaysAbbreviated: fnWeekdaysAbbreviated_454a3d7d23c662520a64ae5245d404be,
			fnWeekdaysNarrow:      fnWeekdaysNarrow_d23eb0b7a498c40ce19d1bf231cad524,
			fnWeekdaysShort:       fnWeekdaysShort_eb6ee64d01e314991432b4469790d38b,
			fnWeekdaysWide:        fnWeekdaysWide_5e2bbf75a31e730429c100e8a0bd3ebd,
		}
	}
	translatorFuncs["ar"] = func() locales.Translator {
		return &localen{

			locale:                 "ar",
			pluralsCardinal:        []locales.PluralRule{1, 2, 3, 4, 5, 6},
			pluralsOrdinal:         []locales.PluralRule{6},
			pluralsRange:           []locales.PluralRule{1, 4, 5, 6},
			decimal:                "٫",
			group:                  "٬",
			minus:                  "؜-",
			percent:                "٪؜",
			perMille:               "؉",
			timeSeparator:          ":",
			inifinity:              "∞",
			currencies:             []string{"ADP", "د.إ.\u200f", "AFA", "AFN", "ALK", "ALL", "AMD", "ANG", "AOA", "AOK", "AON", "AOR", "ARA", "ARL", "ARM", "ARP", "ARS", "ATS", "AU$", "AWG", "AZM", "AZN", "BAD", "BAM", "BAN", "BBD", "BDT", "BEC", "BEF", "BEL", "BGL", "BGM", "BGN", "BGO", "د.ب.\u200f", "BIF", "BMD", "BND", "BOB", "BOL", "BOP", "BOV", "BRB", "BRC", "BRE", "R$", "BRN", "BRR", "BRZ", "BSD", "BTN", "BUK", "BWP", "BYB", "BYN", "BYR", "BZD", "CA$", "CDF", "CHE", "CHF", "CHW", "CLE", "CLF", "CLP", "CNH", "CNX", "CN¥", "COP", "COU", "CRC", "CSD", "CSK", "CUC", "CUP", "CVE", "CYP", "CZK", "DDM", "DEM", "DJF", "DKK", "DOP", "د.ج.\u200f", "ECS", "ECV", "EEK", "ج.م.\u200f", "ERN", "ESA", "ESB", "ESP", "ETB", "€", "FIM", "FJD", "FKP", "FRF", "UK£", "GEK", "GEL", "GHC", "GHS", "GIP", "GMD", "GNF", "GNS", "GQE", "GRD", "GTQ", "GWE", "GWP", "GYD", "HK$", "HNL", "HRD", "HRK", "HTG", "HUF", "IDR", "IEP", "ILP", "ILR", "₪", "₹", "د.ع.\u200f", "ر.إ.", "ISJ", "ISK", "ITL", "JMD", "د.أ.\u200f", "JP¥", "KES", "KGS", "KHR", "KMF", "KPW", "KRH", "KRO", "₩", "د.ك.\u200f", "KYD", "KZT", "LAK", "ل.ل.\u200f", "LKR", "LRD", "LSL", "LTL", "LTT", "LUC", "LUF", "LUL", "LVL", "LVR", "د.ل.\u200f", "د.م.\u200f", "MAF", "MCF", "MDC", "MDL", "MGA", "MGF", "MKD", "MKN", "MLF", "MMK", "MNT", "MOP", "MRO", "أ.م.", "MTL", "MTP", "MUR", "MVP", "MVR", "MWK", "MX$", "MXP", "MXV", "MYR", "MZE", "MZM", "MZN", "NAD", "NGN", "NIC", "NIO", "NLG", "NOK", "NPR", "NZ$", "ر.ع.\u200f", "PAB", "PEI", "PEN", "PES", "PGK", "PHP", "PKR", "PLN", "PLZ", "PTE", "PYG", "ر.ق.\u200f", "RHD", "ROL", "RON", "RSD", "RUB", "RUR", "RWF", "ر.س.\u200f", "SBD", "SCR", "د.س.\u200f", "ج.س.", "SDP", "SEK", "SGD", "SHP", "SIT", "SKK", "SLL", "SOS", "SRD", "SRG", "SSP", "STD", "STN", "SUR", "SVC", "ل.س.\u200f", "SZL", "฿", "TJR", "TJS", "TMM", "TMT", "د.ت.\u200f", "TOP", "TPE", "TRL", "TRY", "TTD", "NT$", "TZS", "UAH", "UAK", "UGS", "UGX", "US$", "USN", "USS", "UYI", "UYP", "UYU", "UYW", "UZS", "VEB", "VEF", "VES", "₫", "VNN", "VUV", "WST", "FCFA", "XAG", "XAU", "XBA", "XBB", "XBC", "XBD", "EC$", "XDR", "XEU", "XFO", "XFU", "CFA", "XPD", "CFPF", "XPT", "XRE", "XSU", "XTS", "XUA", "***", "YDD", "ر.ي.\u200f", "YUD", "YUM", "YUN", "YUR", "ZAL", "ZAR", "ZMK", "ZMW", "ZRN", "ZRZ", "ZWD", "ZWL", "ZWR"},
			currencyPositiveSuffix: " ",
			currencyNegativeSuffix: " ",
			monthsAbbreviated:      []string{"", "يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"},
			monthsNarrow:           []string{"", "ي", "ف", "م", "أ", "و", "ن", "ل", "غ", "س", "ك", "ب", "د"},
			monthsWide:             []string{"", "يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"},
			daysAbbreviated:        []string{"الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"},
			daysNarrow:             []string{"ح", "ن", "ث", "ر", "خ", "ج", "س"},
			daysShort:              []string{"أحد", "إثنين", "ثلاثاء", "أربعاء", "خميس", "جمعة", "سبت"},
			daysWide:               []string{"الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"},
			periodsAbbreviated:     []string{"ص", "م"},
			periodsNarrow:          []string{"ص", "م"},
			periodsWide:            []string{"ص", "م"},
			erasAbbreviated:        []string{"ق.م", "م"},
			erasNarrow:             []string{"", ""},
			erasWide:               []string{"قبل الميلاد", "ميلادي"},
			timezones:              map[string]string{"ACDT": "توقيت وسط أستراليا الصيفي", "ACST": "توقيت وسط أستراليا الرسمي", "ACWDT": "توقيت غرب وسط أستراليا الصيفي", "ACWST": "توقيت غرب وسط أستراليا الرسمي", "ADT": "التوقيت الصيفي الأطلسي", "AEDT": "توقيت شرق أستراليا الصيفي", "AEST": "توقيت شرق أستراليا الرسمي", "AKDT": "توقيت ألاسكا الصيفي", "AKST": "التوقيت الرسمي لألاسكا", "ARST": "توقيت الأرجنتين الصيفي", "ART": "توقيت الأرجنتين الرسمي", "AST": "التوقيت الرسمي الأطلسي", "AWDT": "توقيت غرب أستراليا الصيفي", "AWST": "توقيت غرب أستراليا الرسمي", "BOT": "توقيت بوليفيا", "BT": "توقيت بوتان", "CAT": "توقيت وسط أفريقيا", "CDT": "التوقيت الصيفي المركزي لأمريكا الشمالية", "CHADT": "توقيت تشاتام الصيفي", "CHAST": "توقيت تشاتام الرسمي", "CLST": "توقيت تشيلي الصيفي", "CLT": "توقيت تشيلي الرسمي", "COST": "توقيت كولومبيا الصيفي", "COT": "توقيت كولومبيا الرسمي", "CST": "التوقيت الرسمي المركزي لأمريكا الشمالية", "ChST": "توقيت تشامورو", "EAT": "توقيت شرق أفريقيا", "ECT": "توقيت الإكوادور", "EDT": "التوقيت الصيفي الشرقي لأمريكا الشمالية", "EST": "التوقيت الرسمي الشرقي لأمريكا الشمالية", "GFT": "توقيت غويانا الفرنسية", "GMT": "توقيت غرينتش", "GST": "توقيت الخليج", "GYT": "توقيت غيانا", "HADT": "توقيت هاواي ألوتيان الصيفي", "HAST": "توقيت هاواي ألوتيان الرسمي", "HAT": "توقيت نيوفاوندلاند الصيفي", "HECU": "توقيت كوبا الصيفي", "HEEG": "توقيت شرق غرينلاند الصيفي", "HENOMX": "التوقيت الصيفي لشمال غرب المكسيك", "HEOG": "توقيت غرب غرينلاند الصيفي", "HEPM": "توقيت سانت بيير وميكولون الصيفي", "HEPMX": "توقيت المحيط الهادي الصيفي للمكسيك", "HKST": "توقيت هونغ كونغ الصيفي", "HKT": "توقيت هونغ كونغ الرسمي", "HNCU": "توقيت كوبا الرسمي", "HNEG": "توقيت شرق غرينلاند الرسمي", "HNNOMX": "التوقيت الرسمي لشمال غرب المكسيك", "HNOG": "توقيت غرب غرينلاند الرسمي", "HNPM": "توقيت سانت بيير وميكولون الرسمي", "HNPMX": "توقيت المحيط الهادي الرسمي للمكسيك", "HNT": "توقيت نيوفاوندلاند الرسمي", "IST": "توقيت الهند", "JDT": "توقيت اليابان الصيفي", "JST": "توقيت اليابان الرسمي", "LHDT": "التوقيت الصيفي للورد هاو", "LHST": "توقيت لورد هاو الرسمي", "MDT": "التوقيت الجبلي الصيفي لأمريكا الشمالية", "MESZ": "توقيت وسط أوروبا الصيفي", "MEZ": "توقيت وسط أوروبا الرسمي", "MST": "التوقيت الجبلي الرسمي لأمريكا الشمالية", "MYT": "توقيت ماليزيا", "NZDT": "توقيت نيوزيلندا الصيفي", "NZST": "توقيت نيوزيلندا الرسمي", "OESZ": "توقيت شرق أوروبا الصيفي", "OEZ": "توقيت شرق أوروبا الرسمي", "PDT": "توقيت المحيط الهادي الصيفي", "PST": "توقيت المحيط الهادي الرسمي", "SAST": "توقيت جنوب أفريقيا", "SGT": "توقيت سنغافورة", "SRT": "توقيت سورينام", "TMST": "توقيت تركمانستان الصيفي", "TMT": "توقيت تركمانستان الرسمي", "UYST": "توقيت أوروغواي الصيفي", "UYT": "توقيت أوروغواي الرسمي", "VET": "توقيت فنزويلا", "WARST": "توقيت غرب الأرجنتين الصيفي", "WART": "توقيت غرب الأرجنتين الرسمي", "WAST": "توقيت غرب أفريقيا الصيفي", "WAT": "توقيت غرب أفريقيا الرسمي", "WESZ": "توقيت غرب أوروبا الصيفي", "WEZ": "توقيت غرب أوروبا الرسمي", "WIB": "توقيت غرب إندونيسيا", "WIT": "توقيت شرق إندونيسيا", "WITA": "توقيت وسط إندونيسيا", "∅∅∅": "توقيت أزورس الصيفي"},

			fnCardinalPluralRule:  fnCardinalPluralRule_f27514af189883ea7cd186156edfe998,
			fnDecimal:             fnDecimal_a78485e7dd32c95f41af4e18420793bf,
			fnFmtAccounting:       fnFmtAccounting_f74088692afba81682b73af3d3e7c19a,
			fnFmtCurrency:         fnFmtCurrency_e28d302f22cf4ed4b5009e290f74e359,
			fnFmtDateFull:         fnFmtDateFull_2d3b405215099e683568cb9c052cbd54,
			fnFmtDateLong:         fnFmtDateLong_506f643cda0514f66d873a9ea99bf639,
			fnFmtDateMedium:       fnFmtDateMedium_a55320da438aec0cfbc31bc4d718abc1,
			fnFmtDateShort:        fnFmtDateShort_05c85041b5f9b6fa224b9c4ba9be3590,
			fnFmtNumber:           fnFmtNumber_eef52ddc8fa71bd12171ac9ef3cd3328,
			fnFmtPercent:          fnFmtPercent_60ca2e9d27b8160a5fec0f6694129759,
			fnFmtTimeFull:         fnFmtTimeFull_37fe4deeee789852cc196a6a1a2f0ccc,
			fnFmtTimeLong:         fnFmtTimeLong_4429ef4fb58a2a9c4d7d5132fd16ecbf,
			fnFmtTimeMedium:       fnFmtTimeMedium_8ef07f6477b7a4944577d4e5392ff21b,
			fnFmtTimeShort:        fnFmtTimeShort_8288b817c5c0216c9815524c71c9e0b4,
			fnGroup:               fnGroup_5c4b80a5ccdee81467241784ab8fcd56,
			fnLocale:              fnLocale_5a217059c67094defae82f249f55f4c5,
			fnMinus:               fnMinus_8b8229905258388dc16a5e0c270b0488,
			fnMonthAbbreviated:    fnMonthAbbreviated_aa9a9957cd9d056ba078b36a08b17478,
			fnMonthNarrow:         fnMonthNarrow_45916040ecf6fc350894d9e3e6c46dc7,
			fnMonthWide:           fnMonthWide_4c946a7e7581c665e7407df1841810b5,
			fnMonthsAbbreviated:   fnMonthsAbbreviated_181f77804b62232997fae36bd57d6cf7,
			fnMonthsNarrow:        fnMonthsNarrow_75daa2ba82ae9577292175c3f52370cc,
			fnMonthsWide:          fnMonthsWide_0ecf36a8b72255e2fee9467af362e989,
			fnOrdinalPluralRule:   fnOrdinalPluralRule_3355865f05dde9af2a36ba415bea85cb,
			fnPluralsCardinal:     fnPluralsCardinal_85b19cac1fab9f2c2cfb9eb41539aa0e,
			fnPluralsOrdinal:      fnPluralsOrdinal_16a60aa09da9778fa82fe463e83076de,
			fnPluralsRange:        fnPluralsRange_332465bda13eb808b3664fa0500f54ce,
			fnRangePluralRule:     fnRangePluralRule_47500e2a682fd3a64da69f06f7b93c0a,
			fnWeekdayAbbreviated:  fnWeekdayAbbreviated_4ffbdfbd2be10e6bd8fb5a542a14664a,
			fnWeekdayNarrow:       fnWeekdayNarrow_e86921b3446df5ea9afe9504cfa20d1a,
			fnWeekdayShort:        fnWeekdayShort_82b231d4f504c6d71c7e495aa35cd3c2,
			fnWeekdayWide:         fnWeekdayWide_ab7e026d8685cefd89c5aeb5df512a9a,
			fnWeekdaysAbbreviated: fnWeekdaysAbbreviated_454a3d7d23c662520a64ae5245d404be,
			fnWeekdaysNarrow:      fnWeekdaysNarrow_d23eb0b7a498c40ce19d1bf231cad524,
			fnWeekdaysShort:       fnWeekdaysShort_eb6ee64d01e314991432b4469790d38b,
			fnWeekdaysWide:        fnWeekdaysWide_5e2bbf75a31e730429c100e8a0bd3ebd,
		}
	}
	translatorFuncs["ar_001"] = func() locales.Translator {
		return &localen{

			locale:                 "ar_001",
			pluralsCardinal:        []locales.PluralRule{1, 2, 3, 4, 5, 6},
			pluralsOrdinal:         []locales.PluralRule{6},
			pluralsRange:           []locales.PluralRule{1, 4, 5, 6},
			decimal:                "٫",
			group:                  "٬",
			minus:                  "؜-",
			percent:                "٪؜",
			perMille:               "؉",
			timeSeparator:          ":",
			inifinity:              "∞",
			currencies:             []string{"ADP", "AED", "AFA", "AFN", "ALK", "ALL", "AMD", "ANG", "AOA", "AOK", "AON", "AOR", "ARA", "ARL", "ARM", "ARP", "ARS", "ATS", "AUD", "AWG", "AZM", "AZN", "BAD", "BAM", "BAN", "BBD", "BDT", "BEC", "BEF", "BEL", "BGL", "BGM", "BGN", "BGO", "BHD", "BIF", "BMD", "BND", "BOB", "BOL", "BOP", "BOV", "BRB", "BRC", "BRE", "BRL", "BRN", "BRR", "BRZ", "BSD", "BTN", "BUK", "BWP", "BYB", "BYN", "BYR", "BZD", "CAD", "CDF", "CHE", "CHF", "CHW", "CLE", "CLF", "CLP", "CNH", "CNX", "CNY", "COP", "COU", "CRC", "CSD", "CSK", "CUC", "CUP", "CVE", "CYP", "CZK", "DDM", "DEM", "DJF", "DKK", "DOP", "DZD", "ECS", "ECV", "EEK", "EGP", "ERN", "ESA", "ESB", "ESP", "ETB", "EUR", "FIM", "FJD", "FKP", "FRF", "GBP", "GEK", "GEL", "GHC", "GHS", "GIP", "GMD", "GNF", "GNS", "GQE", "GRD", "GTQ", "GWE", "GWP", "GYD", "HKD", "HNL", "HRD", "HRK", "HTG", "HUF", "IDR", "IEP", "ILP", "ILR", "ILS", "INR", "IQD", "IRR", "ISJ", "ISK", "ITL", "JMD", "JOD", "JPY", "KES", "KGS", "KHR", "KMF", "KPW", "KRH", "KRO", "KRW", "KWD", "KYD", "KZT", "LAK", "LBP", "LKR", "LRD", "LSL", "LTL", "LTT", "LUC", "LUF", "LUL", "LVL", "LVR", "LYD", "MAD", "MAF", "MCF", "MDC", "MDL", "MGA", "MGF", "MKD", "MKN", "MLF", "MMK", "MNT", "MOP", "MRO", "MRU", "MTL", "MTP", "MUR", "MVP", "MVR", "MWK", "MXN", "MXP", "MXV", "MYR", "MZE", "MZM", "MZN", "NAD", "NGN", "NIC", "NIO", "NLG", "NOK", "NPR", "NZD", "OMR", "PAB", "PEI", "PEN", "PES", "PGK", "PHP", "PKR", "PLN", "PLZ", "PTE", "PYG", "QAR", "RHD", "ROL", "RON", "RSD", "RUB", "RUR", "RWF", "SAR", "SBD", "SCR", "SDD", "SDG", "SDP", "SEK", "SGD", "SHP", "SIT", "SKK", "SLL", "SOS", "SRD", "SRG", "SSP", "STD", "STN", "SUR", "SVC", "SYP", "SZL", "THB", "TJR", "TJS", "TMM", "TMT", "TND", "TOP", "TPE", "TRL", "TRY", "TTD", "TWD", "TZS", "UAH", "UAK", "UGS", "UGX", "USD", "USN", "USS", "UYI", "UYP", "UYU", "UYW", "UZS", "VEB", "VEF", "VES", "VND", "VNN", "VUV", "WST", "XAF", "XAG", "XAU", "XBA", "XBB", "XBC", "XBD", "XCD", "XDR", "XEU", "XFO", "XFU", "XOF", "XPD", "XPF", "XPT", "XRE", "XSU", "XTS", "XUA", "XXX", "YDD", "YER", "YUD", "YUM", "YUN", "YUR", "ZAL", "ZAR", "ZMK", "ZMW", "ZRN", "ZRZ", "ZWD", "ZWL", "ZWR"},
			currencyPositiveSuffix: " ",
			currencyNegativeSuffix: " ",
			monthsAbbreviated:      []string{"", "يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"},
			monthsNarrow:           []string{"", "ي", "ف", "م", "أ", "و", "ن", "ل", "غ", "س", "ك", "ب", "د"},
			monthsWide:             []string{"", "يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"},
			daysAbbreviated:        []string{"الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"},
			daysNarrow:             []string{"ح", "ن", "ث", "ر", "خ", "ج", "س"},
			daysShort:              []string{"أحد", "إثنين", "ثلاثاء", "أربعاء", "خميس", "جمعة", "سبت"},
			daysWide:               []string{"الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"},
			periodsAbbreviated:     []string{"ص", "م"},
			periodsNarrow:          []string{"ص", "م"},
			periodsWide:            []string{"ص", "م"},
			erasAbbreviated:        []string{"ق.م", "م"},
			erasNarrow:             []string{"", ""},
			erasWide:               []string{"قبل الميلاد", "ميلادي"},
			timezones:              map[string]string{"ACDT": "توقيت وسط أستراليا الصيفي", "ACST": "توقيت وسط أستراليا الرسمي", "ACWDT": "توقيت غرب وسط أستراليا الصيفي", "ACWST": "توقيت غرب وسط أستراليا الرسمي", "ADT": "التوقيت الصيفي الأطلسي", "AEDT": "توقيت شرق أستراليا الصيفي", "AEST": "توقيت شرق أستراليا الرسمي", "AKDT": "توقيت ألاسكا الصيفي", "AKST": "التوقيت الرسمي لألاسكا", "ARST": "توقيت الأرجنتين الصيفي", "ART": "توقيت الأرجنتين الرسمي", "AST": "التوقيت الرسمي الأطلسي", "AWDT": "توقيت غرب أستراليا الصيفي", "AWST": "توقيت غرب أستراليا الرسمي", "BOT": "توقيت بوليفيا", "BT": "توقيت بوتان", "CAT": "توقيت وسط أفريقيا", "CDT": "التوقيت الصيفي المركزي لأمريكا الشمالية", "CHADT": "توقيت تشاتام الصيفي", "CHAST": "توقيت تشاتام الرسمي", "CLST": "توقيت تشيلي الصيفي", "CLT": "توقيت تشيلي الرسمي", "COST": "توقيت كولومبيا الصيفي", "COT": "توقيت كولومبيا الرسمي", "CST": "التوقيت الرسمي المركزي لأمريكا الشمالية", "ChST": "توقيت تشامورو", "EAT": "توقيت شرق أفريقيا", "ECT": "توقيت الإكوادور", "EDT": "التوقيت الصيفي الشرقي لأمريكا الشمالية", "EST": "التوقيت الرسمي الشرقي لأمريكا الشمالية", "GFT": "توقيت غويانا الفرنسية", "GMT": "توقيت غرينتش", "GST": "توقيت الخليج", "GYT": "توقيت غيانا", "HADT": "توقيت هاواي ألوتيان الصيفي", "HAST": "توقيت هاواي ألوتيان الرسمي", "HAT": "توقيت نيوفاوندلاند الصيفي", "HECU": "توقيت كوبا الصيفي", "HEEG": "توقيت شرق غرينلاند الصيفي", "HENOMX": "التوقيت الصيفي لشمال غرب المكسيك", "HEOG": "توقيت غرب غرينلاند الصيفي", "HEPM": "توقيت سانت بيير وميكولون الصيفي", "HEPMX": "توقيت المحيط الهادي الصيفي للمكسيك", "HKST": "توقيت هونغ كونغ الصيفي", "HKT": "توقيت هونغ كونغ الرسمي", "HNCU": "توقيت كوبا الرسمي", "HNEG": "توقيت شرق غرينلاند الرسمي", "HNNOMX": "التوقيت الرسمي لشمال غرب المكسيك", "HNOG": "توقيت غرب غرينلاند الرسمي", "HNPM": "توقيت سانت بيير وميكولون الرسمي", "HNPMX": "توقيت المحيط الهادي الرسمي للمكسيك", "HNT": "توقيت نيوفاوندلاند الرسمي", "IST": "توقيت الهند", "JDT": "توقيت اليابان الصيفي", "JST": "توقيت اليابان الرسمي", "LHDT": "التوقيت الصيفي للورد هاو", "LHST": "توقيت لورد هاو الرسمي", "MDT": "التوقيت الجبلي الصيفي لأمريكا الشمالية", "MESZ": "توقيت وسط أوروبا الصيفي", "MEZ": "توقيت وسط أوروبا الرسمي", "MST": "التوقيت الجبلي الرسمي لأمريكا الشمالية", "MYT": "توقيت ماليزيا", "NZDT": "توقيت نيوزيلندا الصيفي", "NZST": "توقيت نيوزيلندا الرسمي", "OESZ": "توقيت شرق أوروبا الصيفي", "OEZ": "توقيت شرق أوروبا الرسمي", "PDT": "توقيت المحيط الهادي الصيفي", "PST": "توقيت المحيط الهادي الرسمي", "SAST": "توقيت جنوب أفريقيا", "SGT": "توقيت سنغافورة", "SRT": "توقيت سورينام", "TMST": "توقيت تركمانستان الصيفي", "TMT": "توقيت تركمانستان الرسمي", "UYST": "توقيت أوروغواي الصيفي", "UYT": "توقيت أوروغواي الرسمي", "VET": "توقيت فنزويلا", "WARST": "توقيت غرب الأرجنتين الصيفي", "WART": "توقيت غرب الأرجنتين الرسمي", "WAST": "توقيت غرب أفريقيا الصيفي", "WAT": "توقيت غرب أفريقيا الرسمي", "WESZ": "توقيت غرب أوروبا الصيفي", "WEZ": "توقيت غرب أوروبا الرسمي", "WIB": "توقيت غرب إندونيسيا", "WIT": "توقيت شرق إندونيسيا", "WITA": "توقيت وسط إندونيسيا", "∅∅∅": "توقيت بيرو الصيفي"},

			fnCardinalPluralRule:  fnCardinalPluralRule_f27514af189883ea7cd186156edfe998,
			fnDecimal:             fnDecimal_a78485e7dd32c95f41af4e18420793bf,
			fnFmtAccounting:       fnFmtAccounting_f74088692afba81682b73af3d3e7c19a,
			fnFmtCurrency:         fnFmtCurrency_e28d302f22cf4ed4b5009e290f74e359,
			fnFmtDateFull:         fnFmtDateFull_2d3b405215099e683568cb9c052cbd54,
			fnFmtDateLong:         fnFmtDateLong_506f643cda0514f66d873a9ea99bf639,
			fnFmtDateMedium:       fnFmtDateMedium_a55320da438aec0cfbc31bc4d718abc1,
			fnFmtDateShort:        fnFmtDateShort_05c85041b5f9b6fa224b9c4ba9be3590,
			fnFmtNumber:           fnFmtNumber_eef52ddc8fa71bd12171ac9ef3cd3328,
			fnFmtPercent:          fnFmtPercent_60ca2e9d27b8160a5fec0f6694129759,
			fnFmtTimeFull:         fnFmtTimeFull_37fe4deeee789852cc196a6a1a2f0ccc,
			fnFmtTimeLong:         fnFmtTimeLong_4429ef4fb58a2a9c4d7d5132fd16ecbf,
			fnFmtTimeMedium:       fnFmtTimeMedium_8ef07f6477b7a4944577d4e5392ff21b,
			fnFmtTimeShort:        fnFmtTimeShort_8288b817c5c0216c9815524c71c9e0b4,
			fnGroup:               fnGroup_5c4b80a5ccdee81467241784ab8fcd56,
			fnLocale:              fnLocale_5a217059c67094defae82f249f55f4c5,
			fnMinus:               fnMinus_8b8229905258388dc16a5e0c270b0488,
			fnMonthAbbreviated:    fnMonthAbbreviated_aa9a9957cd9d056ba078b36a08b17478,
			fnMonthNarrow:         fnMonthNarrow_45916040ecf6fc350894d9e3e6c46dc7,
			fnMonthWide:           fnMonthWide_4c946a7e7581c665e7407df1841810b5,
			fnMonthsAbbreviated:   fnMonthsAbbreviated_181f77804b62232997fae36bd57d6cf7,
			fnMonthsNarrow:        fnMonthsNarrow_75daa2ba82ae9577292175c3f52370cc,
			fnMonthsWide:          fnMonthsWide_0ecf36a8b72255e2fee9467af362e989,
			fnOrdinalPluralRule:   fnOrdinalPluralRule_3355865f05dde9af2a36ba415bea85cb,
			fnPluralsCardinal:     fnPluralsCardinal_85b19cac1fab9f2c2cfb9eb41539aa0e,
			fnPluralsOrdinal:      fnPluralsOrdinal_16a60aa09da9778fa82fe463e83076de,
			fnPluralsRange:        fnPluralsRange_332465bda13eb808b3664fa0500f54ce,
			fnRangePluralRule:     fnRangePluralRule_47500e2a682fd3a64da69f06f7b93c0a,
			fnWeekdayAbbreviated:  fnWeekdayAbbreviated_4ffbdfbd2be10e6bd8fb5a542a14664a,
			fnWeekdayNarrow:       fnWeekdayNarrow_e86921b3446df5ea9afe9504cfa20d1a,
			fnWeekdayShort:        fnWeekdayShort_82b231d4f504c6d71c7e495aa35cd3c2,
			fnWeekdayWide:         fnWeekdayWide_ab7e026d8685cefd89c5aeb5df512a9a,
			fnWeekdaysAbbreviated: fnWeekdaysAbbreviated_454a3d7d23c662520a64ae5245d404be,
			fnWeekdaysNarrow:      fnWeekdaysNarrow_d23eb0b7a498c40ce19d1bf231cad524,
			fnWeekdaysShort:       fnWeekdaysShort_eb6ee64d01e314991432b4469790d38b,
			fnWeekdaysWide:        fnWeekdaysWide_5e2bbf75a31e730429c100e8a0bd3ebd,
		}
	}
	translatorFuncs["ar_ae"] = func() locales.Translator {
		return &localen{

			locale:                 "ar_AE",
			pluralsCardinal:        []locales.PluralRule{1, 2, 3, 4, 5, 6},
			pluralsOrdinal:         []locales.PluralRule{6},
			pluralsRange:           []locales.PluralRule{1, 4, 5, 6},
			decimal:                "٫",
			group:                  "٬",
			minus:                  "؜-",
			percent:                "٪؜",
			perMille:               "؉",
			timeSeparator:          ":",
			inifinity:              "∞",
			currencies:             []string{"ADP", "AED", "AFA", "AFN", "ALK", "ALL", "AMD", "ANG", "AOA", "AOK", "AON", "AOR", "ARA", "ARL", "ARM", "ARP", "ARS", "ATS", "AUD", "AWG", "AZM", "AZN", "BAD", "BAM", "BAN", "BBD", "BDT", "BEC", "BEF", "BEL", "BGL", "BGM", "BGN", "BGO", "BHD", "BIF", "BMD", "$", "BOB", "BOL", "BOP", "BOV", "BRB", "BRC", "BRE", "BRL", "BRN", "BRR", "BRZ", "BSD", "BTN", "BUK", "BWP", "BYB", "BYN", "BYR", "BZD", "CAD", "CDF", "CHE", "CHF", "CHW", "CLE", "CLF", "CLP", "CNH", "CNX", "CNY", "COP", "COU", "CRC", "CSD", "CSK", "CUC", "CUP", "CVE", "CYP", "CZK", "DDM", "DEM", "DJF", "DKK", "DOP", "DZD", "ECS", "ECV", "EEK", "EGP", "ERN", "ESA", "ESB", "ESP", "ETB", "EUR", "FIM", "FJD", "FKP", "FRF", "GBP", "GEK", "GEL", "GHC", "GHS", "GIP", "GMD", "GNF", "GNS", "GQE", "GRD", "GTQ", "GWE", "GWP", "GYD", "HKD", "HNL", "HRD", "HRK", "HTG", "HUF", "IDR", "IEP", "ILP", "ILR", "ILS", "INR", "IQD", "IRR", "ISJ", "ISK", "ITL", "JMD", "JOD", "JPY", "KES", "KGS", "KHR", "KMF", "KPW", "KRH", "KRO", "KRW", "KWD", "KYD", "KZT", "LAK", "LBP", "LKR", "LRD", "LSL", "LTL", "LTT", "LUC", "LUF", "LUL", "LVL", "LVR", "LYD", "MAD", "MAF", "MCF", "MDC", "MDL", "MGA", "MGF", "MKD", "MKN", "MLF", "MMK", "MNT", "MOP", "MRO", "MRU", "MTL", "MTP", "MUR", "MVP", "MVR", "MWK", "MXN", "MXP", "MXV", "MYR", "MZE", "MZM", "MZN", "NAD", "NGN", "NIC", "NIO", "NLG", "NOK", "NPR", "NZD", "OMR", "PAB", "PEI", "PEN", "PES", "PGK", "PHP", "PKR", "PLN", "PLZ", "PTE", "PYG", "QAR", "RHD", "ROL", "RON", "RSD", "RUB", "RUR", "RWF", "SAR", "SBD", "SCR", "SDD", "SDG", "SDP", "SEK", "SGD", "SHP", "SIT", "SKK", "SLL", "SOS", "SRD", "SRG", "SSP", "STD", "STN", "SUR", "SVC", "SYP", "SZL", "THB", "TJR", "TJS", "TMM", "TMT", "TND", "TOP", "TPE", "TRL", "TRY", "TTD", "TWD", "TZS", "UAH", "UAK", "UGS", "UGX", "USD", "USN", "USS", "UYI", "UYP", "UYU", "UYW", "UZS", "VEB", "VEF", "VES", "VND", "VNN", "VUV", "WST", "XAF", "XAG", "XAU", "XBA", "XBB", "XBC", "XBD", "XCD", "XDR", "XEU", "XFO", "XFU", "XOF", "XPD", "XPF", "XPT", "XRE", "XSU", "XTS", "XUA", "XXX", "YDD", "YER", "YUD", "YUM", "YUN", "YUR", "ZAL", "ZAR", "ZMK", "ZMW", "ZRN", "ZRZ", "ZWD", "ZWL", "ZWR"},
			currencyPositiveSuffix: " ",
			currencyNegativeSuffix: " ",
			monthsAbbreviated:      []string{"", "يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"},
			monthsNarrow:           []string{"", "ي", "ف", "م", "أ", "و", "ن", "ل", "غ", "س", "ك", "ب", "د"},
			monthsWide:             []string{"", "يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"},
			daysAbbreviated:        []string{"الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"},
			daysNarrow:             []string{"ح", "ن", "ث", "ر", "خ", "ج", "س"},
			daysShort:              []string{"أحد", "إثنين", "ثلاثاء", "أربعاء", "خميس", "جمعة", "سبت"},
			daysWide:               []string{"الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"},
			periodsAbbreviated:     []string{"ص", "م"},
			periodsNarrow:          []string{"ص", "م"},
			periodsWide:            []string{"ص", "م"},
			erasAbbreviated:        []string{"", ""},
			erasNarrow:             []string{"", ""},
			erasWide:               []string{"", ""},
			timezones:              map[string]string{"ACDT": "توقيت وسط أستراليا الصيفي", "ACST": "توقيت وسط أستراليا الرسمي", "ACWDT": "توقيت غرب وسط أستراليا الصيفي", "ACWST": "توقيت غرب وسط أستراليا الرسمي", "ADT": "التوقيت الصيفي الأطلسي", "AEDT": "توقيت شرق أستراليا الصيفي", "AEST": "توقيت شرق أستراليا الرسمي", "AKDT": "توقيت ألاسكا الصيفي", "AKST": "التوقيت الرسمي لألاسكا", "ARST": "توقيت الأرجنتين الصيفي", "ART": "توقيت الأرجنتين الرسمي", "AST": "التوقيت الرسمي الأطلسي", "AWDT": "توقيت غرب أستراليا الصيفي", "AWST": "توقيت غرب أستراليا الرسمي", "BOT": "توقيت بوليفيا", "BT": "توقيت بوتان", "CAT": "توقيت وسط أفريقيا", "CDT": "التوقيت الصيفي المركزي لأمريكا الشمالية", "CHADT": "توقيت تشاتام الصيفي", "CHAST": "توقيت تشاتام الرسمي", "CLST": "توقيت تشيلي الصيفي", "CLT": "توقيت تشيلي الرسمي", "COST": "توقيت كولومبيا الصيفي", "COT": "توقيت كولومبيا الرسمي", "CST": "التوقيت الرسمي المركزي لأمريكا الشمالية", "ChST": "توقيت تشامورو", "EAT": "توقيت شرق أفريقيا", "ECT": "توقيت الإكوادور", "EDT": "التوقيت الصيفي الشرقي لأمريكا الشمالية", "EST": "التوقيت الرسمي الشرقي لأمريكا الشمالية", "GFT": "توقيت غويانا الفرنسية", "GMT": "توقيت غرينتش", "GST": "توقيت الخليج", "GYT": "توقيت غيانا", "HADT": "توقيت هاواي ألوتيان الصيفي", "HAST": "توقيت هاواي ألوتيان الرسمي", "HAT": "توقيت نيوفاوندلاند الصيفي", "HECU": "توقيت كوبا الصيفي", "HEEG": "توقيت شرق غرينلاند الصيفي", "HENOMX": "التوقيت الصيفي لشمال غرب المكسيك", "HEOG": "توقيت غرب غرينلاند الصيفي", "HEPM": "توقيت سانت بيير وميكولون الصيفي", "HEPMX": "توقيت المحيط الهادي الصيفي للمكسيك", "HKST": "توقيت هونغ كونغ الصيفي", "HKT": "توقيت هونغ كونغ الرسمي", "HNCU": "توقيت كوبا الرسمي", "HNEG": "توقيت شرق غرينلاند الرسمي", "HNNOMX": "التوقيت الرسمي لشمال غرب المكسيك", "HNOG": "توقيت غرب غرينلاند الرسمي", "HNPM": "توقيت سانت بيير وميكولون الرسمي", "HNPMX": "توقيت المحيط الهادي الرسمي للمكسيك", "HNT": "توقيت نيوفاوندلاند الرسمي", "IST": "توقيت الهند", "JDT": "توقيت اليابان الصيفي", "JST": "توقيت اليابان الرسمي", "LHDT": "التوقيت الصيفي للورد هاو", "LHST": "توقيت لورد هاو الرسمي", "MDT": "التوقيت الجبلي الصيفي لأمريكا الشمالية", "MESZ": "توقيت وسط أوروبا الصيفي", "MEZ": "توقيت وسط أوروبا الرسمي", "MST": "التوقيت الجبلي الرسمي لأمريكا الشمالية", "MYT": "توقيت ماليزيا", "NZDT": "توقيت نيوزيلندا الصيفي", "NZST": "توقيت نيوزيلندا الرسمي", "OESZ": "توقيت شرق أوروبا الصيفي", "OEZ": "توقيت شرق أوروبا الرسمي", "PDT": "توقيت المحيط الهادي الصيفي", "PST": "توقيت المحيط الهادي الرسمي", "SAST": "توقيت جنوب أفريقيا", "SGT": "توقيت سنغافورة", "SRT": "توقيت سورينام", "TMST": "توقيت تركمانستان الصيفي", "TMT": "توقيت تركمانستان الرسمي", "UYST": "توقيت أوروغواي الصيفي", "UYT": "توقيت أوروغواي الرسمي", "VET": "توقيت فنزويلا", "WARST": "توقيت غرب الأرجنتين الصيفي", "WART": "توقيت غرب الأرجنتين الرسمي", "WAST": "توقيت غرب أفريقيا الصيفي", "WAT": "توقيت غرب أفريقيا الرسمي", "WESZ": "توقيت غرب أوروبا الصيفي", "WEZ": "توقيت غرب أوروبا الرسمي", "WIB": "توقيت غرب إندونيسيا", "WIT": "توقيت شرق إندونيسيا", "WITA": "توقيت وسط إندونيسيا", "∅∅∅": "توقيت أزورس الصيفي"},

			fnCardinalPluralRule:  fnCardinalPluralRule_f27514af189883ea7cd186156edfe998,
			fnDecimal:             fnDecimal_a78485e7dd32c95f41af4e18420793bf,
			fnFmtAccounting:       fnFmtAccounting_f74088692afba81682b73af3d3e7c19a,
			fnFmtCurrency:         fnFmtCurrency_e28d302f22cf4ed4b5009e290f74e359,
			fnFmtDateFull:         fnFmtDateFull_2d3b405215099e683568cb9c052cbd54,
			fnFmtDateLong:         fnFmtDateLong_506f643cda0514f66d873a9ea99bf639,
			fnFmtDateMedium:       fnFmtDateMedium_a55320da438aec0cfbc31bc4d718abc1,
			fnFmtDateShort:        fnFmtDateShort_05c85041b5f9b6fa224b9c4ba9be3590,
			fnFmtNumber:           fnFmtNumber_eef52ddc8fa71bd12171ac9ef3cd3328,
			fnFmtPercent:          fnFmtPercent_60ca2e9d27b8160a5fec0f6694129759,
			fnFmtTimeFull:         fnFmtTimeFull_37fe4deeee789852cc196a6a1a2f0ccc,
			fnFmtTimeLong:         fnFmtTimeLong_4429ef4fb58a2a9c4d7d5132fd16ecbf,
			fnFmtTimeMedium:       fnFmtTimeMedium_8ef07f6477b7a4944577d4e5392ff21b,
			fnFmtTimeShort:        fnFmtTimeShort_8288b817c5c0216c9815524c71c9e0b4,
			fnGroup:               fnGroup_5c4b80a5ccdee81467241784ab8fcd56,
			fnLocale:              fnLocale_5a217059c67094defae82f249f55f4c5,
			fnMinus:               fnMinus_8b8229905258388dc16a5e0c270b0488,
			fnMonthAbbreviated:    fnMonthAbbreviated_aa9a9957cd9d056ba078b36a08b17478,
			fnMonthNarrow:         fnMonthNarrow_45916040ecf6fc350894d9e3e6c46dc7,
			fnMonthWide:           fnMonthWide_4c946a7e7581c665e7407df1841810b5,
			fnMonthsAbbreviated:   fnMonthsAbbreviated_181f77804b62232997fae36bd57d6cf7,
			fnMonthsNarrow:        fnMonthsNarrow_75daa2ba82ae9577292175c3f52370cc,
			fnMonthsWide:          fnMonthsWide_0ecf36a8b72255e2fee9467af362e989,
			fnOrdinalPluralRule:   fnOrdinalPluralRule_3355865f05dde9af2a36ba415bea85cb,
			fnPluralsCardinal:     fnPluralsCardinal_85b19cac1fab9f2c2cfb9eb41539aa0e,
			fnPluralsOrdinal:      fnPluralsOrdinal_16a60aa09da9778fa82fe463e83076de,
			fnPluralsRange:        fnPluralsRange_332465bda13eb808b3664fa0500f54ce,
			fnRangePluralRule:     fnRangePluralRule_47500e2a682fd3a64da69f06f7b93c0a,
			fnWeekdayAbbreviated:  fnWeekdayAbbreviated_4ffbdfbd2be10e6bd8fb5a542a14664a,
			fnWeekdayNarrow:       fnWeekdayNarrow_e86921b3446df5ea9afe9504cfa20d1a,
			fnWeekdayShort:        fnWeekdayShort_82b231d4f504c6d71c7e495aa35cd3c2,
			fnWeekdayWide:         fnWeekdayWide_ab7e026d8685cefd89c5aeb5df512a9a,
			fnWeekdaysAbbreviated: fnWeekdaysAbbreviated_454a3d7d23c662520a64ae5245d404be,
			fnWeekdaysNarrow:      fnWeekdaysNarrow_d23eb0b7a498c40ce19d1bf231cad524,
			fnWeekdaysShort:       fnWeekdaysShort_eb6ee64d01e314991432b4469790d38b,
			fnWeekdaysWide:        fnWeekdaysWide_5e2bbf75a31e730429c100e8a0bd3ebd,
		}
	}
	translatorFuncs["ar_bh"] = func() locales.Translator {
		return &localen{

			locale:                 "ar_BH",
			pluralsCardinal:        []locales.PluralRule{1, 2, 3, 4, 5, 6},
			pluralsOrdinal:         []locales.PluralRule{6},
			pluralsRange:           []locales.PluralRule{1, 4, 5, 6},
			decimal:                "٫",
			group:                  "٬",
			minus:                  "؜-",
			percent:                "٪؜",
			perMille:               "؉",
			timeSeparator:          ":",
			inifinity:              "∞",
			currencies:             []string{"ADP", "AED", "AFA", "AFN", "ALK", "ALL", "AMD", "ANG", "AOA", "AOK", "AON", "AOR", "ARA", "ARL", "ARM", "ARP", "ARS", "ATS", "AUD", "AWG", "AZM", "AZN", "BAD", "BAM", "BAN", "BBD", "BDT", "BEC", "BEF", "BEL", "BGL", "BGM", "BGN", "BGO", "BHD", "BIF", "BMD", "BND", "BOB", "BOL", "BOP", "BOV", "BRB", "BRC", "BRE", "BRL", "BRN", "BRR", "BRZ", "BSD", "BTN", "BUK", "BWP", "BYB", "BYN", "BYR", "BZD", "CAD", "CDF", "CHE", "CHF", "CHW", "CLE", "CLF", "CLP", "CNH", "CNX", "CNY", "COP", "COU", "CRC", "CSD", "CSK", "CUC", "CUP", "CVE", "CYP", "CZK", "DDM", "DEM", "DJF", "DKK", "DOP", "DZD", "ECS", "ECV", "EEK", "EGP", "ERN", "ESA", "ESB", "ESP", "ETB", "EUR", "FIM", "FJD", "FKP", "FRF", "GBP", "GEK", "GEL", "GHC", "GHS", "GIP", "GMD", "GNF", "GNS", "GQE", "GRD", "GTQ", "GWE", "GWP", "GYD", "HKD", "HNL", "HRD", "HRK", "HTG", "HUF", "IDR", "IEP", "ILP", "ILR", "ILS", "INR", "IQD", "IRR", "ISJ", "ISK", "ITL", "JMD", "JOD", "JPY", "KES", "KGS", "KHR", "KMF", "KPW", "KRH", "KRO", "KRW", "KWD", "KYD", "KZT", "LAK", "LBP", "LKR", "LRD", "LSL", "LTL", "LTT", "LUC", "LUF", "LUL", "LVL", "LVR", "LYD", "MAD", "MAF", "MCF", "MDC", "MDL", "MGA", "MGF", "MKD", "MKN", "MLF", "MMK", "MNT", "MOP", "MRO", "MRU", "MTL", "MTP", "MUR", "MVP", "MVR", "MWK", "MXN", "MXP", "MXV", "MYR", "MZE", "MZM", "MZN", "NAD", "NGN", "NIC", "NIO", "NLG", "NOK", "NPR", "NZD", "OMR", "PAB", "PEI", "PEN", "PES", "PGK", "PHP", "PKR", "PLN", "PLZ", "PTE", "PYG", "QAR", "RHD", "ROL", "RON", "RSD", "RUB", "RUR", "RWF", "SAR", "SBD", "SCR", "SDD", "SDG", "SDP", "SEK", "SGD", "SHP", "SIT", "SKK", "SLL", "SOS", "SRD", "SRG", "SSP", "STD", "STN", "SUR", "SVC", "SYP", "SZL", "THB", "TJR", "TJS", "TMM", "TMT", "TND", "TOP", "TPE", "TRL", "TRY", "TTD", "TWD", "TZS", "UAH", "UAK", "UGS", "UGX", "USD", "USN", "USS", "UYI", "UYP", "UYU", "UYW", "UZS", "VEB", "VEF", "VES", "VND", "VNN", "VUV", "WST", "XAF", "XAG", "XAU", "XBA", "XBB", "XBC", "XBD", "XCD", "XDR", "XEU", "XFO", "XFU", "XOF", "XPD", "XPF", "XPT", "XRE", "XSU", "XTS", "XUA", "XXX", "YDD", "YER", "YUD", "YUM", "YUN", "YUR", "ZAL", "ZAR", "ZMK", "ZMW", "ZRN", "ZRZ", "ZWD", "ZWL", "ZWR"},
			currencyPositiveSuffix: " ",
			currencyNegativeSuffix: " ",
			monthsAbbreviated:      []string{"", "يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"},
			monthsNarrow:           []string{"", "ي", "ف", "م", "أ", "و", "ن", "ل", "غ", "س", "ك", "ب", "د"},
			monthsWide:             []string{"", "يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"},
			daysAbbreviated:        []string{"الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"},
			daysNarrow:             []string{"ح", "ن", "ث", "ر", "خ", "ج", "س"},
			daysShort:              []string{"أحد", "إثنين", "ثلاثاء", "أربعاء", "خميس", "جمعة", "سبت"},
			daysWide:               []string{"الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"},
			periodsAbbreviated:     []string{"ص", "م"},
			periodsNarrow:          []string{"ص", "م"},
			periodsWide:            []string{"ص", "م"},
			erasAbbreviated:        []string{"ق.م", "م"},
			erasNarrow:             []string{"", ""},
			erasWide:               []string{"قبل الميلاد", "ميلادي"},
			timezones:              map[string]string{"ACDT": "توقيت وسط أستراليا الصيفي", "ACST": "توقيت وسط أستراليا الرسمي", "ACWDT": "توقيت غرب وسط أستراليا الصيفي", "ACWST": "توقيت غرب وسط أستراليا الرسمي", "ADT": "التوقيت الصيفي الأطلسي", "AEDT": "توقيت شرق أستراليا الصيفي", "AEST": "توقيت شرق أستراليا الرسمي", "AKDT": "توقيت ألاسكا الصيفي", "AKST": "التوقيت الرسمي لألاسكا", "ARST": "توقيت الأرجنتين الصيفي", "ART": "توقيت الأرجنتين الرسمي", "AST": "التوقيت الرسمي الأطلسي", "AWDT": "توقيت غرب أستراليا الصيفي", "AWST": "توقيت غرب أستراليا الرسمي", "BOT": "توقيت بوليفيا", "BT": "توقيت بوتان", "CAT": "توقيت وسط أفريقيا", "CDT": "التوقيت الصيفي المركزي لأمريكا الشمالية", "CHADT": "توقيت تشاتام الصيفي", "CHAST": "توقيت تشاتام الرسمي", "CLST": "توقيت تشيلي الصيفي", "CLT": "توقيت تشيلي الرسمي", "COST": "توقيت كولومبيا الصيفي", "COT": "توقيت كولومبيا الرسمي", "CST": "التوقيت الرسمي المركزي لأمريكا الشمالية", "ChST": "توقيت تشامورو", "EAT": "توقيت شرق أفريقيا", "ECT": "توقيت الإكوادور", "EDT": "التوقيت الصيفي الشرقي لأمريكا الشمالية", "EST": "التوقيت الرسمي الشرقي لأمريكا الشمالية", "GFT": "توقيت غويانا الفرنسية", "GMT": "توقيت غرينتش", "GST": "توقيت الخليج", "GYT": "توقيت غيانا", "HADT": "توقيت هاواي ألوتيان الصيفي", "HAST": "توقيت هاواي ألوتيان الرسمي", "HAT": "توقيت نيوفاوندلاند الصيفي", "HECU": "توقيت كوبا الصيفي", "HEEG": "توقيت شرق غرينلاند الصيفي", "HENOMX": "التوقيت الصيفي لشمال غرب المكسيك", "HEOG": "توقيت غرب غرينلاند الصيفي", "HEPM": "توقيت سانت بيير وميكولون الصيفي", "HEPMX": "توقيت المحيط الهادي الصيفي للمكسيك", "HKST": "توقيت هونغ كونغ الصيفي", "HKT": "توقيت هونغ كونغ الرسمي", "HNCU": "توقيت كوبا الرسمي", "HNEG": "توقيت شرق غرينلاند الرسمي", "HNNOMX": "التوقيت الرسمي لشمال غرب المكسيك", "HNOG": "توقيت غرب غرينلاند الرسمي", "HNPM": "توقيت سانت بيير وميكولون الرسمي", "HNPMX": "توقيت المحيط الهادي الرسمي للمكسيك", "HNT": "توقيت نيوفاوندلاند الرسمي", "IST": "توقيت الهند", "JDT": "توقيت اليابان الصيفي", "JST": "توقيت اليابان الرسمي", "LHDT": "التوقيت الصيفي للورد هاو", "LHST": "توقيت لورد هاو الرسمي", "MDT": "التوقيت الجبلي الصيفي لأمريكا الشمالية", "MESZ": "توقيت وسط أوروبا الصيفي", "MEZ": "توقيت وسط أوروبا الرسمي", "MST": "التوقيت الجبلي الرسمي لأمريكا الشمالية", "MYT": "توقيت ماليزيا", "NZDT": "توقيت نيوزيلندا الصيفي", "NZST": "توقيت نيوزيلندا الرسمي", "OESZ": "توقيت شرق أوروبا الصيفي", "OEZ": "توقيت شرق أوروبا الرسمي", "PDT": "توقيت المحيط الهادي الصيفي", "PST": "توقيت المحيط الهادي الرسمي", "SAST": "توقيت جنوب أفريقيا", "SGT": "توقيت سنغافورة", "SRT": "توقيت سورينام", "TMST": "توقيت تركمانستان الصيفي", "TMT": "توقيت تركمانستان الرسمي", "UYST": "توقيت أوروغواي الصيفي", "UYT": "توقيت أوروغواي الرسمي", "VET": "توقيت فنزويلا", "WARST": "توقيت غرب الأرجنتين الصيفي", "WART": "توقيت غرب الأرجنتين الرسمي", "WAST": "توقيت غرب أفريقيا الصيفي", "WAT": "توقيت غرب أفريقيا الرسمي", "WESZ": "توقيت غرب أوروبا الصيفي", "WEZ": "توقيت غرب أوروبا الرسمي", "WIB": "توقيت غرب إندونيسيا", "WIT": "توقيت شرق إندونيسيا", "WITA": "توقيت وسط إندونيسيا", "∅∅∅": "توقيت برازيليا الصيفي"},

			fnCardinalPluralRule:  fnCardinalPluralRule_f27514af189883ea7cd186156edfe998,
			fnDecimal:             fnDecimal_a78485e7dd32c95f41af4e18420793bf,
			fnFmtAccounting:       fnFmtAccounting_f74088692afba81682b73af3d3e7c19a,
			fnFmtCurrency:         fnFmtCurrency_e28d302f22cf4ed4b5009e290f74e359,
			fnFmtDateFull:         fnFmtDateFull_2d3b405215099e683568cb9c052cbd54,
			fnFmtDateLong:         fnFmtDateLong_506f643cda0514f66d873a9ea99bf639,
			fnFmtDateMedium:       fnFmtDateMedium_a55320da438aec0cfbc31bc4d718abc1,
			fnFmtDateShort:        fnFmtDateShort_05c85041b5f9b6fa224b9c4ba9be3590,
			fnFmtNumber:           fnFmtNumber_eef52ddc8fa71bd12171ac9ef3cd3328,
			fnFmtPercent:          fnFmtPercent_60ca2e9d27b8160a5fec0f6694129759,
			fnFmtTimeFull:         fnFmtTimeFull_37fe4deeee789852cc196a6a1a2f0ccc,
			fnFmtTimeLong:         fnFmtTimeLong_4429ef4fb58a2a9c4d7d5132fd16ecbf,
			fnFmtTimeMedium:       fnFmtTimeMedium_8ef07f6477b7a4944577d4e5392ff21b,
			fnFmtTimeShort:        fnFmtTimeShort_8288b817c5c0216c9815524c71c9e0b4,
			fnGroup:               fnGroup_5c4b80a5ccdee81467241784ab8fcd56,
			fnLocale:              fnLocale_5a217059c67094defae82f249f55f4c5,
			fnMinus:               fnMinus_8b8229905258388dc16a5e0c270b0488,
			fnMonthAbbreviated:    fnMonthAbbreviated_aa9a9957cd9d056ba078b36a08b17478,
			fnMonthNarrow:         fnMonthNarrow_45916040ecf6fc350894d9e3e6c46dc7,
			fnMonthWide:           fnMonthWide_4c946a7e7581c665e7407df1841810b5,
			fnMonthsAbbreviated:   fnMonthsAbbreviated_181f77804b62232997fae36bd57d6cf7,
			fnMonthsNarrow:        fnMonthsNarrow_75daa2ba82ae9577292175c3f52370cc,
			fnMonthsWide:          fnMonthsWide_0ecf36a8b72255e2fee9467af362e989,
			fnOrdinalPluralRule:   fnOrdinalPluralRule_3355865f05dde9af2a36ba415bea85cb,
			fnPluralsCardinal:     fnPluralsCardinal_85b19cac1fab9f2c2cfb9eb41539aa0e,
			fnPluralsOrdinal:      fnPluralsOrdinal_16a60aa09da9778fa82fe463e83076de,
			fnPluralsRange:        fnPluralsRange_332465bda13eb808b3664fa0500f54ce,
			fnRangePluralRule:     fnRangePluralRule_47500e2a682fd3a64da69f06f7b93c0a,
			fnWeekdayAbbreviated:  fnWeekdayAbbreviated_4ffbdfbd2be10e6bd8fb5a542a14664a,
			fnWeekdayNarrow:       fnWeekdayNarrow_e86921b3446df5ea9afe9504cfa20d1a,
			fnWeekdayShort:        fnWeekdayShort_82b231d4f504c6d71c7e495aa35cd3c2,
			fnWeekdayWide:         fnWeekdayWide_ab7e026d8685cefd89c5aeb5df512a9a,
			fnWeekdaysAbbreviated: fnWeekdaysAbbreviated_454a3d7d23c662520a64ae5245d404be,
			fnWeekdaysNarrow:      fnWeekdaysNarrow_d23eb0b7a498c40ce19d1bf231cad524,
			fnWeekdaysShort:       fnWeekdaysShort_eb6ee64d01e314991432b4469790d38b,
			fnWeekdaysWide:        fnWeekdaysWide_5e2bbf75a31e730429c100e8a0bd3ebd,
		}
	}
	translatorFuncs["ar_dj"] = func() locales.Translator {
		return &localen{

			locale:                 "ar_DJ",
			pluralsCardinal:        []locales.PluralRule{1, 2, 3, 4, 5, 6},
			pluralsOrdinal:         []locales.PluralRule{6},
			pluralsRange:           []locales.PluralRule{1, 4, 5, 6},
			decimal:                "٫",
			group:                  "٬",
			minus:                  "؜-",
			percent:                "٪؜",
			perMille:               "؉",
			timeSeparator:          ":",
			inifinity:              "∞",
			currencies:             []string{"ADP", "AED", "AFA", "AFN", "ALK", "ALL", "AMD", "ANG", "AOA", "AOK", "AON", "AOR", "ARA", "ARL", "ARM", "ARP", "ARS", "ATS", "AUD", "AWG", "AZM", "AZN", "BAD", "BAM", "BAN", "BBD", "BDT", "BEC", "BEF", "BEL", "BGL", "BGM", "BGN", "BGO", "BHD", "BIF", "BMD", "BND", "BOB", "BOL", "BOP", "BOV", "BRB", "BRC", "BRE", "BRL", "BRN", "BRR", "BRZ", "BSD", "BTN", "BUK", "BWP", "BYB", "BYN", "BYR", "BZD", "CAD", "CDF", "CHE", "CHF", "CHW", "CLE", "CLF", "CLP", "CNH", "CNX", "CNY", "COP", "COU", "CRC", "CSD", "CSK", "CUC", "CUP", "CVE", "CYP", "CZK", "DDM", "DEM", "Fdj", "DKK", "DOP", "DZD", "ECS", "ECV", "EEK", "EGP", "ERN", "ESA", "ESB", "ESP", "ETB", "EUR", "FIM", "FJD", "FKP", "FRF", "GBP", "GEK", "GEL", "GHC", "GHS", "GIP", "GMD", "GNF", "GNS", "GQE", "GRD", "GTQ", "GWE", "GWP", "GYD", "HKD", "HNL", "HRD", "HRK", "HTG", "HUF", "IDR", "IEP", "ILP", "ILR", "ILS", "INR", "IQD", "IRR", "ISJ", "ISK", "ITL", "JMD", "JOD", "JPY", "KES", "KGS", "KHR", "KMF", "KPW", "KRH", "KRO", "KRW", "KWD", "KYD", "KZT", "LAK", "LBP", "LKR", "LRD", "LSL", "LTL", "LTT", "LUC", "LUF", "LUL", "LVL", "LVR", "LYD", "MAD", "MAF", "MCF", "MDC", "MDL", "MGA", "MGF", "MKD", "MKN", "MLF", "MMK", "MNT", "MOP", "MRO", "MRU", "MTL", "MTP", "MUR", "MVP", "MVR", "MWK", "MXN", "MXP", "MXV", "MYR", "MZE", "MZM", "MZN", "NAD", "NGN", "NIC", "NIO", "NLG", "NOK", "NPR", "NZD", "OMR", "PAB", "PEI", "PEN", "PES", "PGK", "PHP", "PKR", "PLN", "PLZ", "PTE", "PYG", "QAR", "RHD", "ROL", "RON", "RSD", "RUB", "RUR", "RWF", "SAR", "SBD", "SCR", "SDD", "SDG", "SDP", "SEK", "SGD", "SHP", "SIT", "SKK", "SLL", "SOS", "SRD", "SRG", "SSP", "STD", "STN", "SUR", "SVC", "SYP", "SZL", "THB", "TJR", "TJS", "TMM", "TMT", "TND", "TOP", "TPE", "TRL", "TRY", "TTD", "TWD", "TZS", "UAH", "UAK", "UGS", "UGX", "USD", "USN", "USS", "UYI", "UYP", "UYU", "UYW", "UZS", "VEB", "VEF", "VES", "VND", "VNN", "VUV", "WST", "XAF", "XAG", "XAU", "XBA", "XBB", "XBC", "XBD", "XCD", "XDR", "XEU", "XFO", "XFU", "XOF", "XPD", "XPF", "XPT", "XRE", "XSU", "XTS", "XUA", "XXX", "YDD", "YER", "YUD", "YUM", "YUN", "YUR", "ZAL", "ZAR", "ZMK", "ZMW", "ZRN", "ZRZ", "ZWD", "ZWL", "ZWR"},
			currencyPositiveSuffix: " ",
			currencyNegativeSuffix: " ",
			monthsAbbreviated:      []string{"", "يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"},
			monthsNarrow:           []string{"", "ي", "ف", "م", "أ", "و", "ن", "ل", "غ", "س", "ك", "ب", "د"},
			monthsWide:             []string{"", "يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"},
			daysAbbreviated:        []string{"الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"},
			daysNarrow:             []string{"ح", "ن", "ث", "ر", "خ", "ج", "س"},
			daysShort:              []string{"أحد", "إثنين", "ثلاثاء", "أربعاء", "خميس", "جمعة", "سبت"},
			daysWide:               []string{"الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"},
			periodsAbbreviated:     []string{"ص", "م"},
			periodsNarrow:          []string{"ص", "م"},
			periodsWide:            []string{"ص", "م"},
			erasAbbreviated:        []string{"ق.م", "م"},
			erasNarrow:             []string{"", ""},
			erasWide:               []string{"قبل الميلاد", "ميلادي"},
			timezones:              map[string]string{"ACDT": "توقيت وسط أستراليا الصيفي", "ACST": "توقيت وسط أستراليا الرسمي", "ACWDT": "توقيت غرب وسط أستراليا الصيفي", "ACWST": "توقيت غرب وسط أستراليا الرسمي", "ADT": "التوقيت الصيفي الأطلسي", "AEDT": "توقيت شرق أستراليا الصيفي", "AEST": "توقيت شرق أستراليا الرسمي", "AKDT": "توقيت ألاسكا الصيفي", "AKST": "التوقيت الرسمي لألاسكا", "ARST": "توقيت الأرجنتين الصيفي", "ART": "توقيت الأرجنتين الرسمي", "AST": "التوقيت الرسمي الأطلسي", "AWDT": "توقيت غرب أستراليا الصيفي", "AWST": "توقيت غرب أستراليا الرسمي", "BOT": "توقيت بوليفيا", "BT": "توقيت بوتان", "CAT": "توقيت وسط أفريقيا", "CDT": "التوقيت الصيفي المركزي لأمريكا الشمالية", "CHADT": "توقيت تشاتام الصيفي", "CHAST": "توقيت تشاتام الرسمي", "CLST": "توقيت تشيلي الصيفي", "CLT": "توقيت تشيلي الرسمي", "COST": "توقيت كولومبيا الصيفي", "COT": "توقيت كولومبيا الرسمي", "CST": "التوقيت الرسمي المركزي لأمريكا الشمالية", "ChST": "توقيت تشامورو", "EAT": "توقيت شرق أفريقيا", "ECT": "توقيت الإكوادور", "EDT": "التوقيت الصيفي الشرقي لأمريكا الشمالية", "EST": "التوقيت الرسمي الشرقي لأمريكا الشمالية", "GFT": "توقيت غويانا الفرنسية", "GMT": "توقيت غرينتش", "GST": "توقيت الخليج", "GYT": "توقيت غيانا", "HADT": "توقيت هاواي ألوتيان الصيفي", "HAST": "توقيت هاواي ألوتيان الرسمي", "HAT": "توقيت نيوفاوندلاند الصيفي", "HECU": "توقيت كوبا الصيفي", "HEEG": "توقيت شرق غرينلاند الصيفي", "HENOMX": "التوقيت الصيفي لشمال غرب المكسيك", "HEOG": "توقيت غرب غرينلاند الصيفي", "HEPM": "توقيت سانت بيير وميكولون الصيفي", "HEPMX": "توقيت المحيط الهادي الصيفي للمكسيك", "HKST": "توقيت هونغ كونغ الصيفي", "HKT": "توقيت هونغ كونغ الرسمي", "HNCU": "توقيت كوبا الرسمي", "HNEG": "توقيت شرق غرينلاند الرسمي", "HNNOMX": "التوقيت الرسمي لشمال غرب المكسيك", "HNOG": "توقيت غرب غرينلاند الرسمي", "HNPM": "توقيت سانت بيير وميكولون الرسمي", "HNPMX": "توقيت المحيط الهادي الرسمي للمكسيك", "HNT": "توقيت نيوفاوندلاند الرسمي", "IST": "توقيت الهند", "JDT": "توقيت اليابان الصيفي", "JST": "توقيت اليابان الرسمي", "LHDT": "التوقيت الصيفي للورد هاو", "LHST": "توقيت لورد هاو الرسمي", "MDT": "التوقيت الجبلي الصيفي لأمريكا الشمالية", "MESZ": "توقيت وسط أوروبا الصيفي", "MEZ": "توقيت وسط أوروبا الرسمي", "MST": "التوقيت الجبلي الرسمي لأمريكا الشمالية", "MYT": "توقيت ماليزيا", "NZDT": "توقيت نيوزيلندا الصيفي", "NZST": "توقيت نيوزيلندا الرسمي", "OESZ": "توقيت شرق أوروبا الصيفي", "OEZ": "توقيت شرق أوروبا الرسمي", "PDT": "توقيت المحيط الهادي الصيفي", "PST": "توقيت المحيط الهادي الرسمي", "SAST": "توقيت جنوب أفريقيا", "SGT": "توقيت سنغافورة", "SRT": "توقيت سورينام", "TMST": "توقيت تركمانستان الصيفي", "TMT": "توقيت تركمانستان الرسمي", "UYST": "توقيت أوروغواي الصيفي", "UYT": "توقيت أوروغواي الرسمي", "VET": "توقيت فنزويلا", "WARST": "توقيت غرب الأرجنتين الصيفي", "WART": "توقيت غرب الأرجنتين الرسمي", "WAST": "توقيت غرب أفريقيا الصيفي", "WAT": "توقيت غرب أفريقيا الرسمي", "WESZ": "توقيت غرب أوروبا الصيفي", "WEZ": "توقيت غرب أوروبا الرسمي", "WIB": "توقيت غرب إندونيسيا", "WIT": "توقيت شرق إندونيسيا", "WITA": "توقيت وسط إندونيسيا", "∅∅∅": "توقيت أزورس الصيفي"},

			fnCardinalPluralRule:  fnCardinalPluralRule_f27514af189883ea7cd186156edfe998,
			fnDecimal:             fnDecimal_a78485e7dd32c95f41af4e18420793bf,
			fnFmtAccounting:       fnFmtAccounting_f74088692afba81682b73af3d3e7c19a,
			fnFmtCurrency:         fnFmtCurrency_e28d302f22cf4ed4b5009e290f74e359,
			fnFmtDateFull:         fnFmtDateFull_2d3b405215099e683568cb9c052cbd54,
			fnFmtDateLong:         fnFmtDateLong_506f643cda0514f66d873a9ea99bf639,
			fnFmtDateMedium:       fnFmtDateMedium_a55320da438aec0cfbc31bc4d718abc1,
			fnFmtDateShort:        fnFmtDateShort_05c85041b5f9b6fa224b9c4ba9be3590,
			fnFmtNumber:           fnFmtNumber_eef52ddc8fa71bd12171ac9ef3cd3328,
			fnFmtPercent:          fnFmtPercent_60ca2e9d27b8160a5fec0f6694129759,
			fnFmtTimeFull:         fnFmtTimeFull_37fe4deeee789852cc196a6a1a2f0ccc,
			fnFmtTimeLong:         fnFmtTimeLong_4429ef4fb58a2a9c4d7d5132fd16ecbf,
			fnFmtTimeMedium:       fnFmtTimeMedium_8ef07f6477b7a4944577d4e5392ff21b,
			fnFmtTimeShort:        fnFmtTimeShort_8288b817c5c0216c9815524c71c9e0b4,
			fnGroup:               fnGroup_5c4b80a5ccdee81467241784ab8fcd56,
			fnLocale:              fnLocale_5a217059c67094defae82f249f55f4c5,
			fnMinus:               fnMinus_8b8229905258388dc16a5e0c270b0488,
			fnMonthAbbreviated:    fnMonthAbbreviated_aa9a9957cd9d056ba078b36a08b17478,
			fnMonthNarrow:         fnMonthNarrow_45916040ecf6fc350894d9e3e6c46dc7,
			fnMonthWide:           fnMonthWide_4c946a7e7581c665e7407df1841810b5,
			fnMonthsAbbreviated:   fnMonthsAbbreviated_181f77804b62232997fae36bd57d6cf7,
			fnMonthsNarrow:        fnMonthsNarrow_75daa2ba82ae9577292175c3f52370cc,
			fnMonthsWide:          fnMonthsWide_0ecf36a8b72255e2fee9467af362e989,
			fnOrdinalPluralRule:   fnOrdinalPluralRule_3355865f05dde9af2a36ba415bea85cb,
			fnPluralsCardinal:     fnPluralsCardinal_85b19cac1fab9f2c2cfb9eb41539aa0e,
			fnPluralsOrdinal:      fnPluralsOrdinal_16a60aa09da9778fa82fe463e83076de,
			fnPluralsRange:        fnPluralsRange_332465bda13eb808b3664fa0500f54ce,
			fnRangePluralRule:     fnRangePluralRule_47500e2a682fd3a64da69f06f7b93c0a,
			fnWeekdayAbbreviated:  fnWeekdayAbbreviated_4ffbdfbd2be10e6bd8fb5a542a14664a,
			fnWeekdayNarrow:       fnWeekdayNarrow_e86921b3446df5ea9afe9504cfa20d1a,
			fnWeekdayShort:        fnWeekdayShort_82b231d4f504c6d71c7e495aa35cd3c2,
			fnWeekdayWide:         fnWeekdayWide_ab7e026d8685cefd89c5aeb5df512a9a,
			fnWeekdaysAbbreviated: fnWeekdaysAbbreviated_454a3d7d23c662520a64ae5245d404be,
			fnWeekdaysNarrow:      fnWeekdaysNarrow_d23eb0b7a498c40ce19d1bf231cad524,
			fnWeekdaysShort:       fnWeekdaysShort_eb6ee64d01e314991432b4469790d38b,
			fnWeekdaysWide:        fnWeekdaysWide_5e2bbf75a31e730429c100e8a0bd3ebd,
		}
	}
	translatorFuncs["ar_dz"] = func() locales.Translator {
		return &localen{

			locale:                 "ar_DZ",
			pluralsCardinal:        []locales.PluralRule{1, 2, 3, 4, 5, 6},
			pluralsOrdinal:         []locales.PluralRule{6},
			pluralsRange:           []locales.PluralRule{1, 4, 5, 6},
			decimal:                ",",
			group:                  ".",
			minus:                  "؜-",
			percent:                "٪؜",
			perMille:               "؉",
			timeSeparator:          ":",
			inifinity:              "∞",
			currencies:             []string{"ADP", "AED", "AFA", "AFN", "ALK", "ALL", "AMD", "ANG", "AOA", "AOK", "AON", "AOR", "ARA", "ARL", "ARM", "ARP", "ARS", "ATS", "AUD", "AWG", "AZM", "AZN", "BAD", "BAM", "BAN", "BBD", "BDT", "BEC", "BEF", "BEL", "BGL", "BGM", "BGN", "BGO", "BHD", "BIF", "BMD", "BND", "BOB", "BOL", "BOP", "BOV", "BRB", "BRC", "BRE", "BRL", "BRN", "BRR", "BRZ", "BSD", "BTN", "BUK", "BWP", "BYB", "BYN", "BYR", "BZD", "CAD", "CDF", "CHE", "CHF", "CHW", "CLE", "CLF", "CLP", "CNH", "CNX", "CNY", "COP", "COU", "CRC", "CSD", "CSK", "CUC", "CUP", "CVE", "CYP", "CZK", "DDM", "DEM", "DJF", "DKK", "DOP", "DZD", "ECS", "ECV", "EEK", "EGP", "ERN", "ESA", "ESB", "ESP", "ETB", "EUR", "FIM", "FJD", "FKP", "FRF", "GBP", "GEK", "GEL", "GHC", "GHS", "GIP", "GMD", "GNF", "GNS", "GQE", "GRD", "GTQ", "GWE", "GWP", "GYD", "HKD", "HNL", "HRD", "HRK", "HTG", "HUF", "IDR", "IEP", "ILP", "ILR", "ILS", "INR", "IQD", "IRR", "ISJ", "ISK", "ITL", "JMD", "JOD", "JPY", "KES", "KGS", "KHR", "KMF", "KPW", "KRH", "KRO", "KRW", "KWD", "KYD", "KZT", "LAK", "LBP", "LKR", "LRD", "LSL", "LTL", "LTT", "LUC", "LUF", "LUL", "LVL", "LVR", "LYD", "MAD", "MAF", "MCF", "MDC", "MDL", "MGA", "MGF", "MKD", "MKN", "MLF", "MMK", "MNT", "MOP", "MRO", "MRU", "MTL", "MTP", "MUR", "MVP", "MVR", "MWK", "MXN", "MXP", "MXV", "MYR", "MZE", "MZM", "MZN", "NAD", "NGN", "NIC", "NIO", "NLG", "NOK", "NPR", "NZD", "OMR", "PAB", "PEI", "PEN", "PES", "PGK", "PHP", "PKR", "PLN", "PLZ", "PTE", "PYG", "QAR", "RHD", "ROL", "RON", "RSD", "RUB", "RUR", "RWF", "SAR", "SBD", "SCR", "SDD", "SDG", "SDP", "SEK", "SGD", "SHP", "SIT", "SKK", "SLL", "SOS", "SRD", "SRG", "SSP", "STD", "STN", "SUR", "SVC", "SYP", "SZL", "THB", "TJR", "TJS", "TMM", "TMT", "TND", "TOP", "TPE", "TRL", "TRY", "TTD", "TWD", "TZS", "UAH", "UAK", "UGS", "UGX", "USD", "USN", "USS", "UYI", "UYP", "UYU", "UYW", "UZS", "VEB", "VEF", "VES", "VND", "VNN", "VUV", "WST", "XAF", "XAG", "XAU", "XBA", "XBB", "XBC", "XBD", "XCD", "XDR", "XEU", "XFO", "XFU", "XOF", "XPD", "XPF", "XPT", "XRE", "XSU", "XTS", "XUA", "XXX", "YDD", "YER", "YUD", "YUM", "YUN", "YUR", "ZAL", "ZAR", "ZMK", "ZMW", "ZRN", "ZRZ", "ZWD", "ZWL", "ZWR"},
			currencyPositiveSuffix: " ",
			currencyNegativeSuffix: " ",
			monthsAbbreviated:      []string{"", "جانفي", "فيفري", "أفريل", "ماي", "جوان", "جويلية", "أوت"},
			monthsNarrow:           []string{"", "ج", "م", "ج", "ج", "أ", "أ", "ن"},
			monthsWide:             []string{"", "جانفي", "فيفري", "أفريل", "ماي", "جوان", "جويلية", "أوت"},
			daysAbbreviated:        []string{"الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"},
			daysNarrow:             []string{"ح", "ن", "ث", "ر", "خ", "ج", "س"},
			daysShort:              []string{"أحد", "إثنين", "ثلاثاء", "أربعاء", "خميس", "جمعة", "سبت"},
			daysWide:               []string{"الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"},
			periodsAbbreviated:     []string{"ص", "م"},
			periodsNarrow:          []string{"ص", "م"},
			periodsWide:            []string{"ص", "م"},
			erasAbbreviated:        []string{"ق.م", "م"},
			erasNarrow:             []string{"", ""},
			erasWide:               []string{"قبل الميلاد", "ميلادي"},
			timezones:              map[string]string{"ACDT": "توقيت وسط أستراليا الصيفي", "ACST": "توقيت وسط أستراليا الرسمي", "ACWDT": "توقيت غرب وسط أستراليا الصيفي", "ACWST": "توقيت غرب وسط أستراليا الرسمي", "ADT": "التوقيت الصيفي الأطلسي", "AEDT": "توقيت شرق أستراليا الصيفي", "AEST": "توقيت شرق أستراليا الرسمي", "AKDT": "توقيت ألاسكا الصيفي", "AKST": "التوقيت الرسمي لألاسكا", "ARST": "توقيت الأرجنتين الصيفي", "ART": "توقيت الأرجنتين الرسمي", "AST": "التوقيت الرسمي الأطلسي", "AWDT": "توقيت غرب أستراليا الصيفي", "AWST": "توقيت غرب أستراليا الرسمي", "BOT": "توقيت بوليفيا", "BT": "توقيت بوتان", "CAT": "توقيت وسط أفريقيا", "CDT": "التوقيت الصيفي المركزي لأمريكا الشمالية", "CHADT": "توقيت تشاتام الصيفي", "CHAST": "توقيت تشاتام الرسمي", "CLST": "توقيت تشيلي الصيفي", "CLT": "توقيت تشيلي الرسمي", "COST": "توقيت كولومبيا الصيفي", "COT": "توقيت كولومبيا الرسمي", "CST": "التوقيت الرسمي المركزي لأمريكا الشمالية", "ChST": "توقيت تشامورو", "EAT": "توقيت شرق أفريقيا", "ECT": "توقيت الإكوادور", "EDT": "التوقيت الصيفي الشرقي لأمريكا الشمالية", "EST": "التوقيت الرسمي الشرقي لأمريكا الشمالية", "GFT": "توقيت غويانا الفرنسية", "GMT": "توقيت غرينتش", "GST": "توقيت الخليج", "GYT": "توقيت غيانا", "HADT": "توقيت هاواي ألوتيان الصيفي", "HAST": "توقيت هاواي ألوتيان الرسمي", "HAT": "توقيت نيوفاوندلاند الصيفي", "HECU": "توقيت كوبا الصيفي", "HEEG": "توقيت شرق غرينلاند الصيفي", "HENOMX": "التوقيت الصيفي لشمال غرب المكسيك", "HEOG": "توقيت غرب غرينلاند الصيفي", "HEPM": "توقيت سانت بيير وميكولون الصيفي", "HEPMX": "توقيت المحيط الهادي الصيفي للمكسيك", "HKST": "توقيت هونغ كونغ الصيفي", "HKT": "توقيت هونغ كونغ الرسمي", "HNCU": "توقيت كوبا الرسمي", "HNEG": "توقيت شرق غرينلاند الرسمي", "HNNOMX": "التوقيت الرسمي لشمال غرب المكسيك", "HNOG": "توقيت غرب غرينلاند الرسمي", "HNPM": "توقيت سانت بيير وميكولون الرسمي", "HNPMX": "توقيت المحيط الهادي الرسمي للمكسيك", "HNT": "توقيت نيوفاوندلاند الرسمي", "IST": "توقيت الهند", "JDT": "توقيت اليابان الصيفي", "JST": "توقيت اليابان الرسمي", "LHDT": "التوقيت الصيفي للورد هاو", "LHST": "توقيت لورد هاو الرسمي", "MDT": "التوقيت الجبلي الصيفي لأمريكا الشمالية", "MESZ": "توقيت وسط أوروبا الصيفي", "MEZ": "توقيت وسط أوروبا الرسمي", "MST": "التوقيت الجبلي الرسمي لأمريكا الشمالية", "MYT": "توقيت ماليزيا", "NZDT": "توقيت نيوزيلندا الصيفي", "NZST": "توقيت نيوزيلندا الرسمي", "OESZ": "توقيت شرق أوروبا الصيفي", "OEZ": "توقيت شرق أوروبا الرسمي", "PDT": "توقيت المحيط الهادي الصيفي", "PST": "توقيت المحيط الهادي الرسمي", "SAST": "توقيت جنوب أفريقيا", "SGT": "توقيت سنغافورة", "SRT": "توقيت سورينام", "TMST": "توقيت تركمانستان الصيفي", "TMT": "توقيت تركمانستان الرسمي", "UYST": "توقيت أوروغواي الصيفي", "UYT": "توقيت أوروغواي الرسمي", "VET": "توقيت فنزويلا", "WARST": "توقيت غرب الأرجنتين الصيفي", "WART": "توقيت غرب الأرجنتين الرسمي", "WAST": "توقيت غرب أفريقيا الصيفي", "WAT": "توقيت غرب أفريقيا الرسمي", "WESZ": "توقيت غرب أوروبا الصيفي", "WEZ": "توقيت غرب أوروبا الرسمي", "WIB": "توقيت غرب إندونيسيا", "WIT": "توقيت شرق إندونيسيا", "WITA": "توقيت وسط إندونيسيا", "∅∅∅": "توقيت بيرو الصيفي"},

			fnCardinalPluralRule:  fnCardinalPluralRule_f27514af189883ea7cd186156edfe998,
			fnDecimal:             fnDecimal_a78485e7dd32c95f41af4e18420793bf,
			fnFmtAccounting:       fnFmtAccounting_d5455f8fcf723c4be2a5a03fd41298f2,
			fnFmtCurrency:         fnFmtCurrency_2c2268a7a667170346d6d4c829feb8a4,
			fnFmtDateFull:         fnFmtDateFull_2d3b405215099e683568cb9c052cbd54,
			fnFmtDateLong:         fnFmtDateLong_506f643cda0514f66d873a9ea99bf639,
			fnFmtDateMedium:       fnFmtDateMedium_a55320da438aec0cfbc31bc4d718abc1,
			fnFmtDateShort:        fnFmtDateShort_05c85041b5f9b6fa224b9c4ba9be3590,
			fnFmtNumber:           fnFmtNumber_f253fbd23af5a54db29f42f905c9e33a,
			fnFmtPercent:          fnFmtPercent_fb7ade3a9509df0c54be19484c433a01,
			fnFmtTimeFull:         fnFmtTimeFull_37fe4deeee789852cc196a6a1a2f0ccc,
			fnFmtTimeLong:         fnFmtTimeLong_4429ef4fb58a2a9c4d7d5132fd16ecbf,
			fnFmtTimeMedium:       fnFmtTimeMedium_8ef07f6477b7a4944577d4e5392ff21b,
			fnFmtTimeShort:        fnFmtTimeShort_8288b817c5c0216c9815524c71c9e0b4,
			fnGroup:               fnGroup_5c4b80a5ccdee81467241784ab8fcd56,
			fnLocale:              fnLocale_5a217059c67094defae82f249f55f4c5,
			fnMinus:               fnMinus_8b8229905258388dc16a5e0c270b0488,
			fnMonthAbbreviated:    fnMonthAbbreviated_aa9a9957cd9d056ba078b36a08b17478,
			fnMonthNarrow:         fnMonthNarrow_45916040ecf6fc350894d9e3e6c46dc7,
			fnMonthWide:           fnMonthWide_4c946a7e7581c665e7407df1841810b5,
			fnMonthsAbbreviated:   fnMonthsAbbreviated_181f77804b62232997fae36bd57d6cf7,
			fnMonthsNarrow:        fnMonthsNarrow_75daa2ba82ae9577292175c3f52370cc,
			fnMonthsWide:          fnMonthsWide_0ecf36a8b72255e2fee9467af362e989,
			fnOrdinalPluralRule:   fnOrdinalPluralRule_3355865f05dde9af2a36ba415bea85cb,
			fnPluralsCardinal:     fnPluralsCardinal_85b19cac1fab9f2c2cfb9eb41539aa0e,
			fnPluralsOrdinal:      fnPluralsOrdinal_16a60aa09da9778fa82fe463e83076de,
			fnPluralsRange:        fnPluralsRange_332465bda13eb808b3664fa0500f54ce,
			fnRangePluralRule:     fnRangePluralRule_47500e2a682fd3a64da69f06f7b93c0a,
			fnWeekdayAbbreviated:  fnWeekdayAbbreviated_4ffbdfbd2be10e6bd8fb5a542a14664a,
			fnWeekdayNarrow:       fnWeekdayNarrow_e86921b3446df5ea9afe9504cfa20d1a,
			fnWeekdayShort:        fnWeekdayShort_82b231d4f504c6d71c7e495aa35cd3c2,
			fnWeekdayWide:         fnWeekdayWide_ab7e026d8685cefd89c5aeb5df512a9a,
			fnWeekdaysAbbreviated: fnWeekdaysAbbreviated_454a3d7d23c662520a64ae5245d404be,
			fnWeekdaysNarrow:      fnWeekdaysNarrow_d23eb0b7a498c40ce19d1bf231cad524,
			fnWeekdaysShort:       fnWeekdaysShort_eb6ee64d01e314991432b4469790d38b,
			fnWeekdaysWide:        fnWeekdaysWide_5e2bbf75a31e730429c100e8a0bd3ebd,
		}
	}
	translatorFuncs["ar_eg"] = func() locales.Translator {
		return &localen{

			locale:                 "ar_EG",
			pluralsCardinal:        []locales.PluralRule{1, 2, 3, 4, 5, 6},
			pluralsOrdinal:         []locales.PluralRule{6},
			pluralsRange:           []locales.PluralRule{1, 4, 5, 6},
			decimal:                "٫",
			group:                  "٬",
			minus:                  "؜-",
			percent:                "٪؜",
			perMille:               "؉",
			timeSeparator:          ":",
			inifinity:              "∞",
			currencies:             []string{"ADP", "AED", "AFA", "AFN", "ALK", "ALL", "AMD", "ANG", "AOA", "AOK", "AON", "AOR", "ARA", "ARL", "ARM", "ARP", "ARS", "ATS", "AUD", "AWG", "AZM", "AZN", "BAD", "BAM", "BAN", "BBD", "BDT", "BEC", "BEF", "BEL", "BGL", "BGM", "BGN", "BGO", "BHD", "BIF", "BMD", "BND", "BOB", "BOL", "BOP", "BOV", "BRB", "BRC", "BRE", "BRL", "BRN", "BRR", "BRZ", "BSD", "BTN", "BUK", "BWP", "BYB", "BYN", "BYR", "BZD", "CAD", "CDF", "CHE", "CHF", "CHW", "CLE", "CLF", "CLP", "CNH", "CNX", "CNY", "COP", "COU", "CRC", "CSD", "CSK", "CUC", "CUP", "CVE", "CYP", "CZK", "DDM", "DEM", "DJF", "DKK", "DOP", "DZD", "ECS", "ECV", "EEK", "EGP", "ERN", "ESA", "ESB", "ESP", "ETB", "EUR", "FIM", "FJD", "FKP", "FRF", "GBP", "GEK", "GEL", "GHC", "GHS", "GIP", "GMD", "GNF", "GNS", "GQE", "GRD", "GTQ", "GWE", "GWP", "GYD", "HKD", "HNL", "HRD", "HRK", "HTG", "HUF", "IDR", "IEP", "ILP", "ILR", "ILS", "INR", "IQD", "IRR", "ISJ", "ISK", "ITL", "JMD", "JOD", "JPY", "KES", "KGS", "KHR", "KMF", "KPW", "KRH", "KRO", "KRW", "KWD", "KYD", "KZT", "LAK", "LBP", "LKR", "LRD", "LSL", "LTL", "LTT", "LUC", "LUF", "LUL", "LVL", "LVR", "LYD", "MAD", "MAF", "MCF", "MDC", "MDL", "MGA", "MGF", "MKD", "MKN", "MLF", "MMK", "MNT", "MOP", "MRO", "MRU", "MTL", "MTP", "MUR", "MVP", "MVR", "MWK", "MXN", "MXP", "MXV", "MYR", "MZE", "MZM", "MZN", "NAD", "NGN", "NIC", "NIO", "NLG", "NOK", "NPR", "NZD", "OMR", "PAB", "PEI", "PEN", "PES", "PGK", "PHP", "PKR", "PLN", "PLZ", "PTE", "PYG", "QAR", "RHD", "ROL", "RON", "RSD", "RUB", "RUR", "RWF", "SAR", "SBD", "SCR", "SDD", "SDG", "SDP", "SEK", "SGD", "SHP", "SIT", "SKK", "SLL", "SOS", "SRD", "SRG", "SSP", "STD", "STN", "SUR", "SVC", "SYP", "SZL", "THB", "TJR", "TJS", "TMM", "TMT", "TND", "TOP", "TPE", "TRL", "TRY", "TTD", "TWD", "TZS", "UAH", "UAK", "UGS", "UGX", "USD", "USN", "USS", "UYI", "UYP", "UYU", "UYW", "UZS", "VEB", "VEF", "VES", "VND", "VNN", "VUV", "WST", "XAF", "XAG", "XAU", "XBA", "XBB", "XBC", "XBD", "XCD", "XDR", "XEU", "XFO", "XFU", "XOF", "XPD", "XPF", "XPT", "XRE", "XSU", "XTS", "XUA", "XXX", "YDD", "YER", "YUD", "YUM", "YUN", "YUR", "ZAL", "ZAR", "ZMK", "ZMW", "ZRN", "ZRZ", "ZWD", "ZWL", "ZWR"},
			currencyPositiveSuffix: " ",
			currencyNegativeSuffix: " ",
			monthsAbbreviated:      []string{"", "يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"},
			monthsNarrow:           []string{"", "ي", "ف", "م", "أ", "و", "ن", "ل", "غ", "س", "ك", "ب", "د"},
			monthsWide:             []string{"", "يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"},
			daysAbbreviated:        []string{"الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"},
			daysNarrow:             []string{"ح", "ن", "ث", "ر", "خ", "ج", "س"},
			daysShort:              []string{"أحد", "إثنين", "ثلاثاء", "أربعاء", "خميس", "جمعة", "سبت"},
			daysWide:               []string{"الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"},
			periodsAbbreviated:     []string{"ص", "م"},
			periodsNarrow:          []string{"ص", "م"},
			periodsWide:            []string{"ص", "م"},
			erasAbbreviated:        []string{"ق.م", "م"},
			erasNarrow:             []string{"", ""},
			erasWide:               []string{"قبل الميلاد", "ميلادي"},
			timezones:              map[string]string{"ACDT": "توقيت وسط أستراليا الصيفي", "ACST": "توقيت وسط أستراليا الرسمي", "ACWDT": "توقيت غرب وسط أستراليا الصيفي", "ACWST": "توقيت غرب وسط أستراليا الرسمي", "ADT": "التوقيت الصيفي الأطلسي", "AEDT": "توقيت شرق أستراليا الصيفي", "AEST": "توقيت شرق أستراليا الرسمي", "AKDT": "توقيت ألاسكا الصيفي", "AKST": "التوقيت الرسمي لألاسكا", "ARST": "توقيت الأرجنتين الصيفي", "ART": "توقيت الأرجنتين الرسمي", "AST": "التوقيت الرسمي الأطلسي", "AWDT": "توقيت غرب أستراليا الصيفي", "AWST": "توقيت غرب أستراليا الرسمي", "BOT": "توقيت بوليفيا", "BT": "توقيت بوتان", "CAT": "توقيت وسط أفريقيا", "CDT": "التوقيت الصيفي المركزي لأمريكا الشمالية", "CHADT": "توقيت تشاتام الصيفي", "CHAST": "توقيت تشاتام الرسمي", "CLST": "توقيت تشيلي الصيفي", "CLT": "توقيت تشيلي الرسمي", "COST": "توقيت كولومبيا الصيفي", "COT": "توقيت كولومبيا الرسمي", "CST": "التوقيت الرسمي المركزي لأمريكا الشمالية", "ChST": "توقيت تشامورو", "EAT": "توقيت شرق أفريقيا", "ECT": "توقيت الإكوادور", "EDT": "التوقيت الصيفي الشرقي لأمريكا الشمالية", "EST": "التوقيت الرسمي الشرقي لأمريكا الشمالية", "GFT": "توقيت غويانا الفرنسية", "GMT": "توقيت غرينتش", "GST": "توقيت الخليج", "GYT": "توقيت غيانا", "HADT": "توقيت هاواي ألوتيان الصيفي", "HAST": "توقيت هاواي ألوتيان الرسمي", "HAT": "توقيت نيوفاوندلاند الصيفي", "HECU": "توقيت كوبا الصيفي", "HEEG": "توقيت شرق غرينلاند الصيفي", "HENOMX": "التوقيت الصيفي لشمال غرب المكسيك", "HEOG": "توقيت غرب غرينلاند الصيفي", "HEPM": "توقيت سانت بيير وميكولون الصيفي", "HEPMX": "توقيت المحيط الهادي الصيفي للمكسيك", "HKST": "توقيت هونغ كونغ الصيفي", "HKT": "توقيت هونغ كونغ الرسمي", "HNCU": "توقيت كوبا الرسمي", "HNEG": "توقيت شرق غرينلاند الرسمي", "HNNOMX": "التوقيت الرسمي لشمال غرب المكسيك", "HNOG": "توقيت غرب غرينلاند الرسمي", "HNPM": "توقيت سانت بيير وميكولون الرسمي", "HNPMX": "توقيت المحيط الهادي الرسمي للمكسيك", "HNT": "توقيت نيوفاوندلاند الرسمي", "IST": "توقيت الهند", "JDT": "توقيت اليابان الصيفي", "JST": "توقيت اليابان الرسمي", "LHDT": "التوقيت الصيفي للورد هاو", "LHST": "توقيت لورد هاو الرسمي", "MDT": "التوقيت الجبلي الصيفي لأمريكا الشمالية", "MESZ": "توقيت وسط أوروبا الصيفي", "MEZ": "توقيت وسط أوروبا الرسمي", "MST": "التوقيت الجبلي الرسمي لأمريكا الشمالية", "MYT": "توقيت ماليزيا", "NZDT": "توقيت نيوزيلندا الصيفي", "NZST": "توقيت نيوزيلندا الرسمي", "OESZ": "توقيت شرق أوروبا الصيفي", "OEZ": "توقيت شرق أوروبا الرسمي", "PDT": "توقيت المحيط الهادي الصيفي", "PST": "توقيت المحيط الهادي الرسمي", "SAST": "توقيت جنوب أفريقيا", "SGT": "توقيت سنغافورة", "SRT": "توقيت سورينام", "TMST": "توقيت تركمانستان الصيفي", "TMT": "توقيت تركمانستان الرسمي", "UYST": "توقيت أوروغواي الصيفي", "UYT": "توقيت أوروغواي الرسمي", "VET": "توقيت فنزويلا", "WARST": "توقيت غرب الأرجنتين الصيفي", "WART": "توقيت غرب الأرجنتين الرسمي", "WAST": "توقيت غرب أفريقيا الصيفي", "WAT": "توقيت غرب أفريقيا الرسمي", "WESZ": "توقيت غرب أوروبا الصيفي", "WEZ": "توقيت غرب أوروبا الرسمي", "WIB": "توقيت غرب إندونيسيا", "WIT": "توقيت شرق إندونيسيا", "WITA": "توقيت وسط إندونيسيا", "∅∅∅": "توقيت بيرو الصيفي"},

			fnCardinalPluralRule:  fnCardinalPluralRule_f27514af189883ea7cd186156edfe998,
			fnDecimal:             fnDecimal_a78485e7dd32c95f41af4e18420793bf,
			fnFmtAccounting:       fnFmtAccounting_f74088692afba81682b73af3d3e7c19a,
			fnFmtCurrency:         fnFmtCurrency_e28d302f22cf4ed4b5009e290f74e359,
			fnFmtDateFull:         fnFmtDateFull_2d3b405215099e683568cb9c052cbd54,
			fnFmtDateLong:         fnFmtDateLong_506f643cda0514f66d873a9ea99bf639,
			fnFmtDateMedium:       fnFmtDateMedium_a55320da438aec0cfbc31bc4d718abc1,
			fnFmtDateShort:        fnFmtDateShort_05c85041b5f9b6fa224b9c4ba9be3590,
			fnFmtNumber:           fnFmtNumber_eef52ddc8fa71bd12171ac9ef3cd3328,
			fnFmtPercent:          fnFmtPercent_60ca2e9d27b8160a5fec0f6694129759,
			fnFmtTimeFull:         fnFmtTimeFull_37fe4deeee789852cc196a6a1a2f0ccc,
			fnFmtTimeLong:         fnFmtTimeLong_4429ef4fb58a2a9c4d7d5132fd16ecbf,
			fnFmtTimeMedium:       fnFmtTimeMedium_8ef07f6477b7a4944577d4e5392ff21b,
			fnFmtTimeShort:        fnFmtTimeShort_8288b817c5c0216c9815524c71c9e0b4,
			fnGroup:               fnGroup_5c4b80a5ccdee81467241784ab8fcd56,
			fnLocale:              fnLocale_5a217059c67094defae82f249f55f4c5,
			fnMinus:               fnMinus_8b8229905258388dc16a5e0c270b0488,
			fnMonthAbbreviated:    fnMonthAbbreviated_aa9a9957cd9d056ba078b36a08b17478,
			fnMonthNarrow:         fnMonthNarrow_45916040ecf6fc350894d9e3e6c46dc7,
			fnMonthWide:           fnMonthWide_4c946a7e7581c665e7407df1841810b5,
			fnMonthsAbbreviated:   fnMonthsAbbreviated_181f77804b62232997fae36bd57d6cf7,
			fnMonthsNarrow:        fnMonthsNarrow_75daa2ba82ae9577292175c3f52370cc,
			fnMonthsWide:          fnMonthsWide_0ecf36a8b72255e2fee9467af362e989,
			fnOrdinalPluralRule:   fnOrdinalPluralRule_3355865f05dde9af2a36ba415bea85cb,
			fnPluralsCardinal:     fnPluralsCardinal_85b19cac1fab9f2c2cfb9eb41539aa0e,
			fnPluralsOrdinal:      fnPluralsOrdinal_16a60aa09da9778fa82fe463e83076de,
			fnPluralsRange:        fnPluralsRange_332465bda13eb808b3664fa0500f54ce,
			fnRangePluralRule:     fnRangePluralRule_47500e2a682fd3a64da69f06f7b93c0a,
			fnWeekdayAbbreviated:  fnWeekdayAbbreviated_4ffbdfbd2be10e6bd8fb5a542a14664a,
			fnWeekdayNarrow:       fnWeekdayNarrow_e86921b3446df5ea9afe9504cfa20d1a,
			fnWeekdayShort:        fnWeekdayShort_82b231d4f504c6d71c7e495aa35cd3c2,
			fnWeekdayWide:         fnWeekdayWide_ab7e026d8685cefd89c5aeb5df512a9a,
			fnWeekdaysAbbreviated: fnWeekdaysAbbreviated_454a3d7d23c662520a64ae5245d404be,
			fnWeekdaysNarrow:      fnWeekdaysNarrow_d23eb0b7a498c40ce19d1bf231cad524,
			fnWeekdaysShort:       fnWeekdaysShort_eb6ee64d01e314991432b4469790d38b,
			fnWeekdaysWide:        fnWeekdaysWide_5e2bbf75a31e730429c100e8a0bd3ebd,
		}
	}
	translatorFuncs["ar_eh"] = func() locales.Translator {
		return &localen{

			locale:                 "ar_EH",
			pluralsCardinal:        []locales.PluralRule{1, 2, 3, 4, 5, 6},
			pluralsOrdinal:         []locales.PluralRule{6},
			pluralsRange:           []locales.PluralRule{1, 4, 5, 6},
			decimal:                "٫",
			group:                  "٬",
			minus:                  "؜-",
			percent:                "٪؜",
			perMille:               "؉",
			timeSeparator:          ":",
			inifinity:              "∞",
			currencies:             []string{"ADP", "AED", "AFA", "AFN", "ALK", "ALL", "AMD", "ANG", "AOA", "AOK", "AON", "AOR", "ARA", "ARL", "ARM", "ARP", "ARS", "ATS", "AUD", "AWG", "AZM", "AZN", "BAD", "BAM", "BAN", "BBD", "BDT", "BEC", "BEF", "BEL", "BGL", "BGM", "BGN", "BGO", "BHD", "BIF", "BMD", "BND", "BOB", "BOL", "BOP", "BOV", "BRB", "BRC", "BRE", "BRL", "BRN", "BRR", "BRZ", "BSD", "BTN", "BUK", "BWP", "BYB", "BYN", "BYR", "BZD", "CAD", "CDF", "CHE", "CHF", "CHW", "CLE", "CLF", "CLP", "CNH", "CNX", "CNY", "COP", "COU", "CRC", "CSD", "CSK", "CUC", "CUP", "CVE", "CYP", "CZK", "DDM", "DEM", "DJF", "DKK", "DOP", "DZD", "ECS", "ECV", "EEK", "EGP", "ERN", "ESA", "ESB", "ESP", "ETB", "EUR", "FIM", "FJD", "FKP", "FRF", "GBP", "GEK", "GEL", "GHC", "GHS", "GIP", "GMD", "GNF", "GNS", "GQE", "GRD", "GTQ", "GWE", "GWP", "GYD", "HKD", "HNL", "HRD", "HRK", "HTG", "HUF", "IDR", "IEP", "ILP", "ILR", "ILS", "INR", "IQD", "IRR", "ISJ", "ISK", "ITL", "JMD", "JOD", "JPY", "KES", "KGS", "KHR", "KMF", "KPW", "KRH", "KRO", "KRW", "KWD", "KYD", "KZT", "LAK", "LBP", "LKR", "LRD", "LSL", "LTL", "LTT", "LUC", "LUF", "LUL", "LVL", "LVR", "LYD", "MAD", "MAF", "MCF", "MDC", "MDL", "MGA", "MGF", "MKD", "MKN", "MLF", "MMK", "MNT", "MOP", "MRO", "MRU", "MTL", "MTP", "MUR", "MVP", "MVR", "MWK", "MXN", "MXP", "MXV", "MYR", "MZE", "MZM", "MZN", "NAD", "NGN", "NIC", "NIO", "NLG", "NOK", "NPR", "NZD", "OMR", "PAB", "PEI", "PEN", "PES", "PGK", "PHP", "PKR", "PLN", "PLZ", "PTE", "PYG", "QAR", "RHD", "ROL", "RON", "RSD", "RUB", "RUR", "RWF", "SAR", "SBD", "SCR", "SDD", "SDG", "SDP", "SEK", "SGD", "SHP", "SIT", "SKK", "SLL", "SOS", "SRD", "SRG", "SSP", "STD", "STN", "SUR", "SVC", "SYP", "SZL", "THB", "TJR", "TJS", "TMM", "TMT", "TND", "TOP", "TPE", "TRL", "TRY", "TTD", "TWD", "TZS", "UAH", "UAK", "UGS", "UGX", "USD", "USN", "USS", "UYI", "UYP", "UYU", "UYW", "UZS", "VEB", "VEF", "VES", "VND", "VNN", "VUV", "WST", "XAF", "XAG", "XAU", "XBA", "XBB", "XBC", "XBD", "XCD", "XDR", "XEU", "XFO", "XFU", "XOF", "XPD", "XPF", "XPT", "XRE", "XSU", "XTS", "XUA", "XXX", "YDD", "YER", "YUD", "YUM", "YUN", "YUR", "ZAL", "ZAR", "ZMK", "ZMW", "ZRN", "ZRZ", "ZWD", "ZWL", "ZWR"},
			currencyPositiveSuffix: " ",
			currencyNegativeSuffix: " ",
			monthsAbbreviated:      []string{"", "يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"},
			monthsNarrow:           []string{"", "ي", "ف", "م", "أ", "و", "ن", "ل", "غ", "س", "ك", "ب", "د"},
			monthsWide:             []string{"", "يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"},
			daysAbbreviated:        []string{"الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"},
			daysNarrow:             []string{"ح", "ن", "ث", "ر", "خ", "ج", "س"},
			daysShort:              []string{"أحد", "إثنين", "ثلاثاء", "أربعاء", "خميس", "جمعة", "سبت"},
			daysWide:               []string{"الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"},
			periodsAbbreviated:     []string{"ص", "م"},
			periodsNarrow:          []string{"ص", "م"},
			periodsWide:            []string{"ص", "م"},
			erasAbbreviated:        []string{"ق.م", "م"},
			erasNarrow:             []string{"", ""},
			erasWide:               []string{"قبل الميلاد", "ميلادي"},
			timezones:              map[string]string{"ACDT": "توقيت وسط أستراليا الصيفي", "ACST": "توقيت وسط أستراليا الرسمي", "ACWDT": "توقيت غرب وسط أستراليا الصيفي", "ACWST": "توقيت غرب وسط أستراليا الرسمي", "ADT": "التوقيت الصيفي الأطلسي", "AEDT": "توقيت شرق أستراليا الصيفي", "AEST": "توقيت شرق أستراليا الرسمي", "AKDT": "توقيت ألاسكا الصيفي", "AKST": "التوقيت الرسمي لألاسكا", "ARST": "توقيت الأرجنتين الصيفي", "ART": "توقيت الأرجنتين الرسمي", "AST": "التوقيت الرسمي الأطلسي", "AWDT": "توقيت غرب أستراليا الصيفي", "AWST": "توقيت غرب أستراليا الرسمي", "BOT": "توقيت بوليفيا", "BT": "توقيت بوتان", "CAT": "توقيت وسط أفريقيا", "CDT": "التوقيت الصيفي المركزي لأمريكا الشمالية", "CHADT": "توقيت تشاتام الصيفي", "CHAST": "توقيت تشاتام الرسمي", "CLST": "توقيت تشيلي الصيفي", "CLT": "توقيت تشيلي الرسمي", "COST": "توقيت كولومبيا الصيفي", "COT": "توقيت كولومبيا الرسمي", "CST": "التوقيت الرسمي المركزي لأمريكا الشمالية", "ChST": "توقيت تشامورو", "EAT": "توقيت شرق أفريقيا", "ECT": "توقيت الإكوادور", "EDT": "التوقيت الصيفي الشرقي لأمريكا الشمالية", "EST": "التوقيت الرسمي الشرقي لأمريكا الشمالية", "GFT": "توقيت غويانا الفرنسية", "GMT": "توقيت غرينتش", "GST": "توقيت الخليج", "GYT": "توقيت غيانا", "HADT": "توقيت هاواي ألوتيان الصيفي", "HAST": "توقيت هاواي ألوتيان الرسمي", "HAT": "توقيت نيوفاوندلاند الصيفي", "HECU": "توقيت كوبا الصيفي", "HEEG": "توقيت شرق غرينلاند الصيفي", "HENOMX": "التوقيت الصيفي لشمال غرب المكسيك", "HEOG": "توقيت غرب غرينلاند الصيفي", "HEPM": "توقيت سانت بيير وميكولون الصيفي", "HEPMX": "توقيت المحيط الهادي الصيفي للمكسيك", "HKST": "توقيت هونغ كونغ الصيفي", "HKT": "توقيت هونغ كونغ الرسمي", "HNCU": "توقيت كوبا الرسمي", "HNEG": "توقيت شرق غرينلاند الرسمي", "HNNOMX": "التوقيت الرسمي لشمال غرب المكسيك", "HNOG": "توقيت غرب غرينلاند الرسمي", "HNPM": "توقيت سانت بيير وميكولون الرسمي", "HNPMX": "توقيت المحيط الهادي الرسمي للمكسيك", "HNT": "توقيت نيوفاوندلاند الرسمي", "IST": "توقيت الهند", "JDT": "توقيت اليابان الصيفي", "JST": "توقيت اليابان الرسمي", "LHDT": "التوقيت الصيفي للورد هاو", "LHST": "توقيت لورد هاو الرسمي", "MDT": "التوقيت الجبلي الصيفي لأمريكا الشمالية", "MESZ": "توقيت وسط أوروبا الصيفي", "MEZ": "توقيت وسط أوروبا الرسمي", "MST": "التوقيت الجبلي الرسمي لأمريكا الشمالية", "MYT": "توقيت ماليزيا", "NZDT": "توقيت نيوزيلندا الصيفي", "NZST": "توقيت نيوزيلندا الرسمي", "OESZ": "توقيت شرق أوروبا الصيفي", "OEZ": "توقيت شرق أوروبا الرسمي", "PDT": "توقيت المحيط الهادي الصيفي", "PST": "توقيت المحيط الهادي الرسمي", "SAST": "توقيت جنوب أفريقيا", "SGT": "توقيت سنغافورة", "SRT": "توقيت سورينام", "TMST": "توقيت تركمانستان الصيفي", "TMT": "توقيت تركمانستان الرسمي", "UYST": "توقيت أوروغواي الصيفي", "UYT": "توقيت أوروغواي الرسمي", "VET": "توقيت فنزويلا", "WARST": "توقيت غرب الأرجنتين الصيفي", "WART": "توقيت غرب الأرجنتين الرسمي", "WAST": "توقيت غرب أفريقيا الصيفي", "WAT": "توقيت غرب أفريقيا الرسمي", "WESZ": "توقيت غرب أوروبا الصيفي", "WEZ": "توقيت غرب أوروبا الرسمي", "WIB": "توقيت غرب إندونيسيا", "WIT": "توقيت شرق إندونيسيا", "WITA": "توقيت وسط إندونيسيا", "∅∅∅": "توقيت الأمازون الصيفي"},

			fnCardinalPluralRule:  fnCardinalPluralRule_f27514af189883ea7cd186156edfe998,
			fnDecimal:             fnDecimal_a78485e7dd32c95f41af4e18420793bf,
			fnFmtAccounting:       fnFmtAccounting_f74088692afba81682b73af3d3e7c19a,
			fnFmtCurrency:         fnFmtCurrency_e28d302f22cf4ed4b5009e290f74e359,
			fnFmtDateFull:         fnFmtDateFull_2d3b405215099e683568cb9c052cbd54,
			fnFmtDateLong:         fnFmtDateLong_506f643cda0514f66d873a9ea99bf639,
			fnFmtDateMedium:       fnFmtDateMedium_a55320da438aec0cfbc31bc4d718abc1,
			fnFmtDateShort:        fnFmtDateShort_05c85041b5f9b6fa224b9c4ba9be3590,
			fnFmtNumber:           fnFmtNumber_eef52ddc8fa71bd12171ac9ef3cd3328,
			fnFmtPercent:          fnFmtPercent_60ca2e9d27b8160a5fec0f6694129759,
			fnFmtTimeFull:         fnFmtTimeFull_37fe4deeee789852cc196a6a1a2f0ccc,
			fnFmtTimeLong:         fnFmtTimeLong_4429ef4fb58a2a9c4d7d5132fd16ecbf,
			fnFmtTimeMedium:       fnFmtTimeMedium_8ef07f6477b7a4944577d4e5392ff21b,
			fnFmtTimeShort:        fnFmtTimeShort_8288b817c5c0216c9815524c71c9e0b4,
			fnGroup:               fnGroup_5c4b80a5ccdee81467241784ab8fcd56,
			fnLocale:              fnLocale_5a217059c67094defae82f249f55f4c5,
			fnMinus:               fnMinus_8b8229905258388dc16a5e0c270b0488,
			fnMonthAbbreviated:    fnMonthAbbreviated_aa9a9957cd9d056ba078b36a08b17478,
			fnMonthNarrow:         fnMonthNarrow_45916040ecf6fc350894d9e3e6c46dc7,
			fnMonthWide:           fnMonthWide_4c946a7e7581c665e7407df1841810b5,
			fnMonthsAbbreviated:   fnMonthsAbbreviated_181f77804b62232997fae36bd57d6cf7,
			fnMonthsNarrow:        fnMonthsNarrow_75daa2ba82ae9577292175c3f52370cc,
			fnMonthsWide:          fnMonthsWide_0ecf36a8b72255e2fee9467af362e989,
			fnOrdinalPluralRule:   fnOrdinalPluralRule_3355865f05dde9af2a36ba415bea85cb,
			fnPluralsCardinal:     fnPluralsCardinal_85b19cac1fab9f2c2cfb9eb41539aa0e,
			fnPluralsOrdinal:      fnPluralsOrdinal_16a60aa09da9778fa82fe463e83076de,
			fnPluralsRange:        fnPluralsRange_332465bda13eb808b3664fa0500f54ce,
			fnRangePluralRule:     fnRangePluralRule_47500e2a682fd3a64da69f06f7b93c0a,
			fnWeekdayAbbreviated:  fnWeekdayAbbreviated_4ffbdfbd2be10e6bd8fb5a542a14664a,
			fnWeekdayNarrow:       fnWeekdayNarrow_e86921b3446df5ea9afe9504cfa20d1a,
			fnWeekdayShort:        fnWeekdayShort_82b231d4f504c6d71c7e495aa35cd3c2,
			fnWeekdayWide:         fnWeekdayWide_ab7e026d8685cefd89c5aeb5df512a9a,
			fnWeekdaysAbbreviated: fnWeekdaysAbbreviated_454a3d7d23c662520a64ae5245d404be,
			fnWeekdaysNarrow:      fnWeekdaysNarrow_d23eb0b7a498c40ce19d1bf231cad524,
			fnWeekdaysShort:       fnWeekdaysShort_eb6ee64d01e314991432b4469790d38b,
			fnWeekdaysWide:        fnWeekdaysWide_5e2bbf75a31e730429c100e8a0bd3ebd,
		}
	}
	translatorFuncs["ar_er"] = func() locales.Translator {
		return &localen{

			locale:                 "ar_ER",
			pluralsCardinal:        []locales.PluralRule{1, 2, 3, 4, 5, 6},
			pluralsOrdinal:         []locales.PluralRule{6},
			pluralsRange:           []locales.PluralRule{1, 4, 5, 6},
			decimal:                "٫",
			group:                  "٬",
			minus:                  "؜-",
			percent:                "٪؜",
			perMille:               "؉",
			timeSeparator:          ":",
			inifinity:              "∞",
			currencies:             []string{"ADP", "AED", "AFA", "AFN", "ALK", "ALL", "AMD", "ANG", "AOA", "AOK", "AON", "AOR", "ARA", "ARL", "ARM", "ARP", "ARS", "ATS", "AUD", "AWG", "AZM", "AZN", "BAD", "BAM", "BAN", "BBD", "BDT", "BEC", "BEF", "BEL", "BGL", "BGM", "BGN", "BGO", "BHD", "BIF", "BMD", "BND", "BOB", "BOL", "BOP", "BOV", "BRB", "BRC", "BRE", "BRL", "BRN", "BRR", "BRZ", "BSD", "BTN", "BUK", "BWP", "BYB", "BYN", "BYR", "BZD", "CAD", "CDF", "CHE", "CHF", "CHW", "CLE", "CLF", "CLP", "CNH", "CNX", "CNY", "COP", "COU", "CRC", "CSD", "CSK", "CUC", "CUP", "CVE", "CYP", "CZK", "DDM", "DEM", "DJF", "DKK", "DOP", "DZD", "ECS", "ECV", "EEK", "EGP", "Nfk", "ESA", "ESB", "ESP", "ETB", "EUR", "FIM", "FJD", "FKP", "FRF", "GBP", "GEK", "GEL", "GHC", "GHS", "GIP", "GMD", "GNF", "GNS", "GQE", "GRD", "GTQ", "GWE", "GWP", "GYD", "HKD", "HNL", "HRD", "HRK", "HTG", "HUF", "IDR", "IEP", "ILP", "ILR", "ILS", "INR", "IQD", "IRR", "ISJ", "ISK", "ITL", "JMD", "JOD", "JPY", "KES", "KGS", "KHR", "KMF", "KPW", "KRH", "KRO", "KRW", "KWD", "KYD", "KZT", "LAK", "LBP", "LKR", "LRD", "LSL", "LTL", "LTT", "LUC", "LUF", "LUL", "LVL", "LVR", "LYD", "MAD", "MAF", "MCF", "MDC", "MDL", "MGA", "MGF", "MKD", "MKN", "MLF", "MMK", "MNT", "MOP", "MRO", "MRU", "MTL", "MTP", "MUR", "MVP", "MVR", "MWK", "MXN", "MXP", "MXV", "MYR", "MZE", "MZM", "MZN", "NAD", "NGN", "NIC", "NIO", "NLG", "NOK", "NPR", "NZD", "OMR", "PAB", "PEI", "PEN", "PES", "PGK", "PHP", "PKR", "PLN", "PLZ", "PTE", "PYG", "QAR", "RHD", "ROL", "RON", "RSD", "RUB", "RUR", "RWF", "SAR", "SBD", "SCR", "SDD", "SDG", "SDP", "SEK", "SGD", "SHP", "SIT", "SKK", "SLL", "SOS", "SRD", "SRG", "SSP", "STD", "STN", "SUR", "SVC", "SYP", "SZL", "THB", "TJR", "TJS", "TMM", "TMT", "TND", "TOP", "TPE", "TRL", "TRY", "TTD", "TWD", "TZS", "UAH", "UAK", "UGS", "UGX", "USD", "USN", "USS", "UYI", "UYP", "UYU", "UYW", "UZS", "VEB", "VEF", "VES", "VND", "VNN", "VUV", "WST", "XAF", "XAG", "XAU", "XBA", "XBB", "XBC", "XBD", "XCD", "XDR", "XEU", "XFO", "XFU", "XOF", "XPD", "XPF", "XPT", "XRE", "XSU", "XTS", "XUA", "XXX", "YDD", "YER", "YUD", "YUM", "YUN", "YUR", "ZAL", "ZAR", "ZMK", "ZMW", "ZRN", "ZRZ", "ZWD", "ZWL", "ZWR"},
			currencyPositiveSuffix: " ",
			currencyNegativeSuffix: " ",
			monthsAbbreviated:      []string{"", "يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"},
			monthsNarrow:           []string{"", "ي", "ف", "م", "أ", "و", "ن", "ل", "غ", "س", "ك", "ب", "د"},
			monthsWide:             []string{"", "يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"},
			daysAbbreviated:        []string{"الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"},
			daysNarrow:             []string{"ح", "ن", "ث", "ر", "خ", "ج", "س"},
			daysShort:              []string{"أحد", "إثنين", "ثلاثاء", "أربعاء", "خميس", "جمعة", "سبت"},
			daysWide:               []string{"الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"},
			periodsAbbreviated:     []string{"ص", "م"},
			periodsNarrow:          []string{"ص", "م"},
			periodsWide:            []string{"ص", "م"},
			erasAbbreviated:        []string{"ق.م", "م"},
			erasNarrow:             []string{"", ""},
			erasWide:               []string{"قبل الميلاد", "ميلادي"},
			timezones:              map[string]string{"ACDT": "توقيت وسط أستراليا الصيفي", "ACST": "توقيت وسط أستراليا الرسمي", "ACWDT": "توقيت غرب وسط أستراليا الصيفي", "ACWST": "توقيت غرب وسط أستراليا الرسمي", "ADT": "التوقيت الصيفي الأطلسي", "AEDT": "توقيت شرق أستراليا الصيفي", "AEST": "توقيت شرق أستراليا الرسمي", "AKDT": "توقيت ألاسكا الصيفي", "AKST": "التوقيت الرسمي لألاسكا", "ARST": "توقيت الأرجنتين الصيفي", "ART": "توقيت الأرجنتين الرسمي", "AST": "التوقيت الرسمي الأطلسي", "AWDT": "توقيت غرب أستراليا الصيفي", "AWST": "توقيت غرب أستراليا الرسمي", "BOT": "توقيت بوليفيا", "BT": "توقيت بوتان", "CAT": "توقيت وسط أفريقيا", "CDT": "التوقيت الصيفي المركزي لأمريكا الشمالية", "CHADT": "توقيت تشاتام الصيفي", "CHAST": "توقيت تشاتام الرسمي", "CLST": "توقيت تشيلي الصيفي", "CLT": "توقيت تشيلي الرسمي", "COST": "توقيت كولومبيا الصيفي", "COT": "توقيت كولومبيا الرسمي", "CST": "التوقيت الرسمي المركزي لأمريكا الشمالية", "ChST": "توقيت تشامورو", "EAT": "توقيت شرق أفريقيا", "ECT": "توقيت الإكوادور", "EDT": "التوقيت الصيفي الشرقي لأمريكا الشمالية", "EST": "التوقيت الرسمي الشرقي لأمريكا الشمالية", "GFT": "توقيت غويانا الفرنسية", "GMT": "توقيت غرينتش", "GST": "توقيت الخليج", "GYT": "توقيت غيانا", "HADT": "توقيت هاواي ألوتيان الصيفي", "HAST": "توقيت هاواي ألوتيان الرسمي", "HAT": "توقيت نيوفاوندلاند الصيفي", "HECU": "توقيت كوبا الصيفي", "HEEG": "توقيت شرق غرينلاند الصيفي", "HENOMX": "التوقيت الصيفي لشمال غرب المكسيك", "HEOG": "توقيت غرب غرينلاند الصيفي", "HEPM": "توقيت سانت بيير وميكولون الصيفي", "HEPMX": "توقيت المحيط الهادي الصيفي للمكسيك", "HKST": "توقيت هونغ كونغ الصيفي", "HKT": "توقيت هونغ كونغ الرسمي", "HNCU": "توقيت كوبا الرسمي", "HNEG": "توقيت شرق غرينلاند الرسمي", "HNNOMX": "التوقيت الرسمي لشمال غرب المكسيك", "HNOG": "توقيت غرب غرينلاند الرسمي", "HNPM": "توقيت سانت بيير وميكولون الرسمي", "HNPMX": "توقيت المحيط الهادي الرسمي للمكسيك", "HNT": "توقيت نيوفاوندلاند الرسمي", "IST": "توقيت الهند", "JDT": "توقيت اليابان الصيفي", "JST": "توقيت اليابان الرسمي", "LHDT": "التوقيت الصيفي للورد هاو", "LHST": "توقيت لورد هاو الرسمي", "MDT": "MDT", "MESZ": "توقيت وسط أوروبا الصيفي", "MEZ": "توقيت وسط أوروبا الرسمي", "MST": "MST", "MYT": "توقيت ماليزيا", "NZDT": "توقيت نيوزيلندا الصيفي", "NZST": "توقيت نيوزيلندا الرسمي", "OESZ": "توقيت شرق أوروبا الصيفي", "OEZ": "توقيت شرق أوروبا الرسمي", "PDT": "توقيت المحيط الهادي الصيفي", "PST": "توقيت المحيط الهادي الرسمي", "SAST": "توقيت جنوب أفريقيا", "SGT": "توقيت سنغافورة", "SRT": "توقيت سورينام", "TMST": "توقيت تركمانستان الصيفي", "TMT": "توقيت تركمانستان الرسمي", "UYST": "توقيت أوروغواي الصيفي", "UYT": "توقيت أوروغواي الرسمي", "VET": "توقيت فنزويلا", "WARST": "توقيت غرب الأرجنتين الصيفي", "WART": "توقيت غرب الأرجنتين الرسمي", "WAST": "توقيت غرب أفريقيا الصيفي", "WAT": "توقيت غرب أفريقيا الرسمي", "WESZ": "توقيت غرب أوروبا الصيفي", "WEZ": "توقيت غرب أوروبا الرسمي", "WIB": "توقيت غرب إندونيسيا", "WIT": "توقيت شرق إندونيسيا", "WITA": "توقيت وسط إندونيسيا", "∅∅∅": "توقيت بيرو الصيفي"},

			fnCardinalPluralRule:  fnCardinalPluralRule_f27514af189883ea7cd186156edfe998,
			fnDecimal:             fnDecimal_a78485e7dd32c95f41af4e18420793bf,
			fnFmtAccounting:       fnFmtAccounting_f74088692afba81682b73af3d3e7c19a,
			fnFmtCurrency:         fnFmtCurrency_e28d302f22cf4ed4b5009e290f74e359,
			fnFmtDateFull:         fnFmtDateFull_2d3b405215099e683568cb9c052cbd54,
			fnFmtDateLong:         fnFmtDateLong_506f643cda0514f66d873a9ea99bf639,
			fnFmtDateMedium:       fnFmtDateMedium_a55320da438aec0cfbc31bc4d718abc1,
			fnFmtDateShort:        fnFmtDateShort_05c85041b5f9b6fa224b9c4ba9be3590,
			fnFmtNumber:           fnFmtNumber_eef52ddc8fa71bd12171ac9ef3cd3328,
			fnFmtPercent:          fnFmtPercent_60ca2e9d27b8160a5fec0f6694129759,
			fnFmtTimeFull:         fnFmtTimeFull_37fe4deeee789852cc196a6a1a2f0ccc,
			fnFmtTimeLong:         fnFmtTimeLong_4429ef4fb58a2a9c4d7d5132fd16ecbf,
			fnFmtTimeMedium:       fnFmtTimeMedium_8ef07f6477b7a4944577d4e5392ff21b,
			fnFmtTimeShort:        fnFmtTimeShort_8288b817c5c0216c9815524c71c9e0b4,
			fnGroup:               fnGroup_5c4b80a5ccdee81467241784ab8fcd56,
			fnLocale:              fnLocale_5a217059c67094defae82f249f55f4c5,
			fnMinus:               fnMinus_8b8229905258388dc16a5e0c270b0488,
			fnMonthAbbreviated:    fnMonthAbbreviated_aa9a9957cd9d056ba078b36a08b17478,
			fnMonthNarrow:         fnMonthNarrow_45916040ecf6fc350894d9e3e6c46dc7,
			fnMonthWide:           fnMonthWide_4c946a7e7581c665e7407df1841810b5,
			fnMonthsAbbreviated:   fnMonthsAbbreviated_181f77804b62232997fae36bd57d6cf7,
			fnMonthsNarrow:        fnMonthsNarrow_75daa2ba82ae9577292175c3f52370cc,
			fnMonthsWide:          fnMonthsWide_0ecf36a8b72255e2fee9467af362e989,
			fnOrdinalPluralRule:   fnOrdinalPluralRule_3355865f05dde9af2a36ba415bea85cb,
			fnPluralsCardinal:     fnPluralsCardinal_85b19cac1fab9f2c2cfb9eb41539aa0e,
			fnPluralsOrdinal:      fnPluralsOrdinal_16a60aa09da9778fa82fe463e83076de,
			fnPluralsRange:        fnPluralsRange_332465bda13eb808b3664fa0500f54ce,
			fnRangePluralRule:     fnRangePluralRule_47500e2a682fd3a64da69f06f7b93c0a,
			fnWeekdayAbbreviated:  fnWeekdayAbbreviated_4ffbdfbd2be10e6bd8fb5a542a14664a,
			fnWeekdayNarrow:       fnWeekdayNarrow_e86921b3446df5ea9afe9504cfa20d1a,
			fnWeekdayShort:        fnWeekdayShort_82b231d4f504c6d71c7e495aa35cd3c2,
			fnWeekdayWide:         fnWeekdayWide_ab7e026d8685cefd89c5aeb5df512a9a,
			fnWeekdaysAbbreviated: fnWeekdaysAbbreviated_454a3d7d23c662520a64ae5245d404be,
			fnWeekdaysNarrow:      fnWeekdaysNarrow_d23eb0b7a498c40ce19d1bf231cad524,
			fnWeekdaysShort:       fnWeekdaysShort_eb6ee64d01e314991432b4469790d38b,
			fnWeekdaysWide:        fnWeekdaysWide_5e2bbf75a31e730429c100e8a0bd3ebd,
		}
	}
	translatorFuncs["ar_il"] = func() locales.Translator {
		return &localen{

			locale:                 "ar_IL",
			pluralsCardinal:        []locales.PluralRule{1, 2, 3, 4, 5, 6},
			pluralsOrdinal:         []locales.PluralRule{6},
			pluralsRange:           []locales.PluralRule{1, 4, 5, 6},
			decimal:                "٫",
			group:                  "٬",
			minus:                  "؜-",
			percent:                "٪؜",
			perMille:               "؉",
			timeSeparator:          ":",
			inifinity:              "∞",
			currencies:             []string{"ADP", "AED", "AFA", "AFN", "ALK", "ALL", "AMD", "ANG", "AOA", "AOK", "AON", "AOR", "ARA", "ARL", "ARM", "ARP", "ARS", "ATS", "AUD", "AWG", "AZM", "AZN", "BAD", "BAM", "BAN", "BBD", "BDT", "BEC", "BEF", "BEL", "BGL", "BGM", "BGN", "BGO", "BHD", "BIF", "BMD", "BND", "BOB", "BOL", "BOP", "BOV", "BRB", "BRC", "BRE", "BRL", "BRN", "BRR", "BRZ", "BSD", "BTN", "BUK", "BWP", "BYB", "BYN", "BYR", "BZD", "CAD", "CDF", "CHE", "CHF", "CHW", "CLE", "CLF", "CLP", "CNH", "CNX", "CNY", "COP", "COU", "CRC", "CSD", "CSK", "CUC", "CUP", "CVE", "CYP", "CZK", "DDM", "DEM", "DJF", "DKK", "DOP", "DZD", "ECS", "ECV", "EEK", "EGP", "ERN", "ESA", "ESB", "ESP", "ETB", "EUR", "FIM", "FJD", "FKP", "FRF", "GBP", "GEK", "GEL", "GHC", "GHS", "GIP", "GMD", "GNF", "GNS", "GQE", "GRD", "GTQ", "GWE", "GWP", "GYD", "HKD", "HNL", "HRD", "HRK", "HTG", "HUF", "IDR", "IEP", "ILP", "ILR", "ILS", "INR", "IQD", "IRR", "ISJ", "ISK", "ITL", "JMD", "JOD", "JPY", "KES", "KGS", "KHR", "KMF", "KPW", "KRH", "KRO", "KRW", "KWD", "KYD", "KZT", "LAK", "LBP", "LKR", "LRD", "LSL", "LTL", "LTT", "LUC", "LUF", "LUL", "LVL", "LVR", "LYD", "MAD", "MAF", "MCF", "MDC", "MDL", "MGA", "MGF", "MKD", "MKN", "MLF", "MMK", "MNT", "MOP", "MRO", "MRU", "MTL", "MTP", "MUR", "MVP", "MVR", "MWK", "MXN", "MXP", "MXV", "MYR", "MZE", "MZM", "MZN", "NAD", "NGN", "NIC", "NIO", "NLG", "NOK", "NPR", "NZD", "OMR", "PAB", "PEI", "PEN", "PES", "PGK", "PHP", "PKR", "PLN", "PLZ", "PTE", "PYG", "QAR", "RHD", "ROL", "RON", "RSD", "RUB", "RUR", "RWF", "SAR", "SBD", "SCR", "SDD", "SDG", "SDP", "SEK", "SGD", "SHP", "SIT", "SKK", "SLL", "SOS", "SRD", "SRG", "SSP", "STD", "STN", "SUR", "SVC", "SYP", "SZL", "THB", "TJR", "TJS", "TMM", "TMT", "TND", "TOP", "TPE", "TRL", "TRY", "TTD", "TWD", "TZS", "UAH", "UAK", "UGS", "UGX", "USD", "USN", "USS", "UYI", "UYP", "UYU", "UYW", "UZS", "VEB", "VEF", "VES", "VND", "VNN", "VUV", "WST", "XAF", "XAG", "XAU", "XBA", "XBB", "XBC", "XBD", "XCD", "XDR", "XEU", "XFO", "XFU", "XOF", "XPD", "XPF", "XPT", "XRE", "XSU", "XTS", "XUA", "XXX", "YDD", "YER", "YUD", "YUM", "YUN", "YUR", "ZAL", "ZAR", "ZMK", "ZMW", "ZRN", "ZRZ", "ZWD", "ZWL", "ZWR"},
			currencyPositiveSuffix: " ",
			currencyNegativeSuffix: " ",
			monthsAbbreviated:      []string{"", "يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"},
			monthsNarrow:           []string{"", "ي", "ف", "م", "أ", "و", "ن", "ل", "غ", "س", "ك", "ب", "د"},
			monthsWide:             []string{"", "يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"},
			daysAbbreviated:        []string{"الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"},
			daysNarrow:             []string{"ح", "ن", "ث", "ر", "خ", "ج", "س"},
			daysShort:              []string{"أحد", "إثنين", "ثلاثاء", "أربعاء", "خميس", "جمعة", "سبت"},
			daysWide:               []string{"الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"},
			periodsAbbreviated:     []string{"ص", "م"},
			periodsNarrow:          []string{"ص", "م"},
			periodsWide:            []string{"ص", "م"},
			erasAbbreviated:        []string{"ق.م", "م"},
			erasNarrow:             []string{"", ""},
			erasWide:               []string{"قبل الميلاد", "ميلادي"},
			timezones:              map[string]string{"ACDT": "توقيت وسط أستراليا الصيفي", "ACST": "توقيت وسط أستراليا الرسمي", "ACWDT": "توقيت غرب وسط أستراليا الصيفي", "ACWST": "توقيت غرب وسط أستراليا الرسمي", "ADT": "التوقيت الصيفي الأطلسي", "AEDT": "توقيت شرق أستراليا الصيفي", "AEST": "توقيت شرق أستراليا الرسمي", "AKDT": "توقيت ألاسكا الصيفي", "AKST": "التوقيت الرسمي لألاسكا", "ARST": "توقيت الأرجنتين الصيفي", "ART": "توقيت الأرجنتين الرسمي", "AST": "التوقيت الرسمي الأطلسي", "AWDT": "توقيت غرب أستراليا الصيفي", "AWST": "توقيت غرب أستراليا الرسمي", "BOT": "توقيت بوليفيا", "BT": "توقيت بوتان", "CAT": "توقيت وسط أفريقيا", "CDT": "التوقيت الصيفي المركزي لأمريكا الشمالية", "CHADT": "توقيت تشاتام الصيفي", "CHAST": "توقيت تشاتام الرسمي", "CLST": "توقيت تشيلي الصيفي", "CLT": "توقيت تشيلي الرسمي", "COST": "توقيت كولومبيا الصيفي", "COT": "توقيت كولومبيا الرسمي", "CST": "التوقيت الرسمي المركزي لأمريكا الشمالية", "ChST": "توقيت تشامورو", "EAT": "توقيت شرق أفريقيا", "ECT": "توقيت الإكوادور", "EDT": "التوقيت الصيفي الشرقي لأمريكا الشمالية", "EST": "التوقيت الرسمي الشرقي لأمريكا الشمالية", "GFT": "توقيت غويانا الفرنسية", "GMT": "توقيت غرينتش", "GST": "توقيت الخليج", "GYT": "توقيت غيانا", "HADT": "توقيت هاواي ألوتيان الصيفي", "HAST": "توقيت هاواي ألوتيان الرسمي", "HAT": "توقيت نيوفاوندلاند الصيفي", "HECU": "توقيت كوبا الصيفي", "HEEG": "توقيت شرق غرينلاند الصيفي", "HENOMX": "التوقيت الصيفي لشمال غرب المكسيك", "HEOG": "توقيت غرب غرينلاند الصيفي", "HEPM": "توقيت سانت بيير وميكولون الصيفي", "HEPMX": "توقيت المحيط الهادي الصيفي للمكسيك", "HKST": "توقيت هونغ كونغ الصيفي", "HKT": "توقيت هونغ كونغ الرسمي", "HNCU": "توقيت كوبا الرسمي", "HNEG": "توقيت شرق غرينلاند الرسمي", "HNNOMX": "التوقيت الرسمي لشمال غرب المكسيك", "HNOG": "توقيت غرب غرينلاند الرسمي", "HNPM": "توقيت سانت بيير وميكولون الرسمي", "HNPMX": "توقيت المحيط الهادي الرسمي للمكسيك", "HNT": "توقيت نيوفاوندلاند الرسمي", "IST": "توقيت الهند", "JDT": "توقيت اليابان الصيفي", "JST": "توقيت اليابان الرسمي", "LHDT": "التوقيت الصيفي للورد هاو", "LHST": "توقيت لورد هاو الرسمي", "MDT": "التوقيت الجبلي الصيفي لأمريكا الشمالية", "MESZ": "توقيت وسط أوروبا الصيفي", "MEZ": "توقيت وسط أوروبا الرسمي", "MST": "التوقيت الجبلي الرسمي لأمريكا الشمالية", "MYT": "توقيت ماليزيا", "NZDT": "توقيت نيوزيلندا الصيفي", "NZST": "توقيت نيوزيلندا الرسمي", "OESZ": "توقيت شرق أوروبا الصيفي", "OEZ": "توقيت شرق أوروبا الرسمي", "PDT": "توقيت المحيط الهادي الصيفي", "PST": "توقيت المحيط الهادي الرسمي", "SAST": "توقيت جنوب أفريقيا", "SGT": "توقيت سنغافورة", "SRT": "توقيت سورينام", "TMST": "توقيت تركمانستان الصيفي", "TMT": "توقيت تركمانستان الرسمي", "UYST": "توقيت أوروغواي الصيفي", "UYT": "توقيت أوروغواي الرسمي", "VET": "توقيت فنزويلا", "WARST": "توقيت غرب الأرجنتين الصيفي", "WART": "توقيت غرب الأرجنتين الرسمي", "WAST": "توقيت غرب أفريقيا الصيفي", "WAT": "توقيت غرب أفريقيا الرسمي", "WESZ": "توقيت غرب أوروبا الصيفي", "WEZ": "توقيت غرب أوروبا الرسمي", "WIB": "توقيت غرب إندونيسيا", "WIT": "توقيت شرق إندونيسيا", "WITA": "توقيت وسط إندونيسيا", "∅∅∅": "توقيت برازيليا الصيفي"},

			fnCardinalPluralRule:  fnCardinalPluralRule_f27514af189883ea7cd186156edfe998,
			fnDecimal:             fnDecimal_a78485e7dd32c95f41af4e18420793bf,
			fnFmtAccounting:       fnFmtAccounting_f74088692afba81682b73af3d3e7c19a,
			fnFmtCurrency:         fnFmtCurrency_e28d302f22cf4ed4b5009e290f74e359,
			fnFmtDateFull:         fnFmtDateFull_2d3b405215099e683568cb9c052cbd54,
			fnFmtDateLong:         fnFmtDateLong_506f643cda0514f66d873a9ea99bf639,
			fnFmtDateMedium:       fnFmtDateMedium_a55320da438aec0cfbc31bc4d718abc1,
			fnFmtDateShort:        fnFmtDateShort_05c85041b5f9b6fa224b9c4ba9be3590,
			fnFmtNumber:           fnFmtNumber_eef52ddc8fa71bd12171ac9ef3cd3328,
			fnFmtPercent:          fnFmtPercent_60ca2e9d27b8160a5fec0f6694129759,
			fnFmtTimeFull:         fnFmtTimeFull_103caa51aab787e802d47e2174ea5313,
			fnFmtTimeLong:         fnFmtTimeLong_14ec37cb9b88b34ab642f7ee8fd2800b,
			fnFmtTimeMedium:       fnFmtTimeMedium_c3e2f72b9dd7b60e99ec7ed62baf96a4,
			fnFmtTimeShort:        fnFmtTimeShort_d0370e7a739d1d7da91c2071fa2c12c5,
			fnGroup:               fnGroup_5c4b80a5ccdee81467241784ab8fcd56,
			fnLocale:              fnLocale_5a217059c67094defae82f249f55f4c5,
			fnMinus:               fnMinus_8b8229905258388dc16a5e0c270b0488,
			fnMonthAbbreviated:    fnMonthAbbreviated_aa9a9957cd9d056ba078b36a08b17478,
			fnMonthNarrow:         fnMonthNarrow_45916040ecf6fc350894d9e3e6c46dc7,
			fnMonthWide:           fnMonthWide_4c946a7e7581c665e7407df1841810b5,
			fnMonthsAbbreviated:   fnMonthsAbbreviated_181f77804b62232997fae36bd57d6cf7,
			fnMonthsNarrow:        fnMonthsNarrow_75daa2ba82ae9577292175c3f52370cc,
			fnMonthsWide:          fnMonthsWide_0ecf36a8b72255e2fee9467af362e989,
			fnOrdinalPluralRule:   fnOrdinalPluralRule_3355865f05dde9af2a36ba415bea85cb,
			fnPluralsCardinal:     fnPluralsCardinal_85b19cac1fab9f2c2cfb9eb41539aa0e,
			fnPluralsOrdinal:      fnPluralsOrdinal_16a60aa09da9778fa82fe463e83076de,
			fnPluralsRange:        fnPluralsRange_332465bda13eb808b3664fa0500f54ce,
			fnRangePluralRule:     fnRangePluralRule_47500e2a682fd3a64da69f06f7b93c0a,
			fnWeekdayAbbreviated:  fnWeekdayAbbreviated_4ffbdfbd2be10e6bd8fb5a542a14664a,
			fnWeekdayNarrow:       fnWeekdayNarrow_e86921b3446df5ea9afe9504cfa20d1a,
			fnWeekdayShort:        fnWeekdayShort_82b231d4f504c6d71c7e495aa35cd3c2,
			fnWeekdayWide:         fnWeekdayWide_ab7e026d8685cefd89c5aeb5df512a9a,
			fnWeekdaysAbbreviated: fnWeekdaysAbbreviated_454a3d7d23c662520a64ae5245d404be,
			fnWeekdaysNarrow:      fnWeekdaysNarrow_d23eb0b7a498c40ce19d1bf231cad524,
			fnWeekdaysShort:       fnWeekdaysShort_eb6ee64d01e314991432b4469790d38b,
			fnWeekdaysWide:        fnWeekdaysWide_5e2bbf75a31e730429c100e8a0bd3ebd,
		}
	}
	translatorFuncs["ar_iq"] = func() locales.Translator {
		return &localen{

			locale:                 "ar_IQ",
			pluralsCardinal:        []locales.PluralRule{1, 2, 3, 4, 5, 6},
			pluralsOrdinal:         []locales.PluralRule{6},
			pluralsRange:           []locales.PluralRule{1, 4, 5, 6},
			decimal:                "٫",
			group:                  "٬",
			minus:                  "؜-",
			percent:                "٪؜",
			perMille:               "؉",
			timeSeparator:          ":",
			inifinity:              "∞",
			currencies:             []string{"ADP", "AED", "AFA", "AFN", "ALK", "ALL", "AMD", "ANG", "AOA", "AOK", "AON", "AOR", "ARA", "ARL", "ARM", "ARP", "ARS", "ATS", "AUD", "AWG", "AZM", "AZN", "BAD", "BAM", "BAN", "BBD", "BDT", "BEC", "BEF", "BEL", "BGL", "BGM", "BGN", "BGO", "BHD", "BIF", "BMD", "BND", "BOB", "BOL", "BOP", "BOV", "BRB", "BRC", "BRE", "BRL", "BRN", "BRR", "BRZ", "BSD", "BTN", "BUK", "BWP", "BYB", "BYN", "BYR", "BZD", "CAD", "CDF", "CHE", "CHF", "CHW", "CLE", "CLF", "CLP", "CNH", "CNX", "CNY", "COP", "COU", "CRC", "CSD", "CSK", "CUC", "CUP", "CVE", "CYP", "CZK", "DDM", "DEM", "DJF", "DKK", "DOP", "DZD", "ECS", "ECV", "EEK", "EGP", "ERN", "ESA", "ESB", "ESP", "ETB", "EUR", "FIM", "FJD", "FKP", "FRF", "GBP", "GEK", "GEL", "GHC", "GHS", "GIP", "GMD", "GNF", "GNS", "GQE", "GRD", "GTQ", "GWE", "GWP", "GYD", "HKD", "HNL", "HRD", "HRK", "HTG", "HUF", "IDR", "IEP", "ILP", "ILR", "ILS", "INR", "IQD", "IRR", "ISJ", "ISK", "ITL", "JMD", "JOD", "JPY", "KES", "KGS", "KHR", "KMF", "KPW", "KRH", "KRO", "KRW", "KWD", "KYD", "KZT", "LAK", "LBP", "LKR", "LRD", "LSL", "LTL", "LTT", "LUC", "LUF", "LUL", "LVL", "LVR", "LYD", "MAD", "MAF", "MCF", "MDC", "MDL", "MGA", "MGF", "MKD", "MKN", "MLF", "MMK", "MNT", "MOP", "MRO", "MRU", "MTL", "MTP", "MUR", "MVP", "MVR", "MWK", "MXN", "MXP", "MXV", "MYR", "MZE", "MZM", "MZN", "NAD", "NGN", "NIC", "NIO", "NLG", "NOK", "NPR", "NZD", "OMR", "PAB", "PEI", "PEN", "PES", "PGK", "PHP", "PKR", "PLN", "PLZ", "PTE", "PYG", "QAR", "RHD", "ROL", "RON", "RSD", "RUB", "RUR", "RWF", "SAR", "SBD", "SCR", "SDD", "SDG", "SDP", "SEK", "SGD", "SHP", "SIT", "SKK", "SLL", "SOS", "SRD", "SRG", "SSP", "STD", "STN", "SUR", "SVC", "SYP", "SZL", "THB", "TJR", "TJS", "TMM", "TMT", "TND", "TOP", "TPE", "TRL", "TRY", "TTD", "TWD", "TZS", "UAH", "UAK", "UGS", "UGX", "USD", "USN", "USS", "UYI", "UYP", "UYU", "UYW", "UZS", "VEB", "VEF", "VES", "VND", "VNN", "VUV", "WST", "XAF", "XAG", "XAU", "XBA", "XBB", "XBC", "XBD", "XCD", "XDR", "XEU", "XFO", "XFU", "XOF", "XPD", "XPF", "XPT", "XRE", "XSU", "XTS", "XUA", "XXX", "YDD", "YER", "YUD", "YUM", "YUN", "YUR", "ZAL", "ZAR", "ZMK", "ZMW", "ZRN", "ZRZ", "ZWD", "ZWL", "ZWR"},
			currencyPositiveSuffix: " ",
			currencyNegativeSuffix: " ",
			monthsAbbreviated:      []string{"", "كانون الثاني", "شباط", "آذار", "نيسان", "أيار", "حزيران", "تموز", "آب", "أيلول", "تشرين\u00a0الأول", "تشرين الثاني", "كانون الأول"},
			monthsNarrow:           []string{"", "ك", "ش", "آ", "ن", "أ", "ح", "ت", "آ", "أ", "ت", "ت", "ك"},
			monthsWide:             []string{"", "كانون الثاني", "شباط", "آذار", "نيسان", "أيار", "حزيران", "تموز", "آب", "أيلول", "تشرين الأول", "تشرين الثاني", "كانون الأول"},
			daysAbbreviated:        []string{"الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"},
			daysNarrow:             []string{"ح", "ن", "ث", "ر", "خ", "ج", "س"},
			daysShort:              []string{"أحد", "إثنين", "ثلاثاء", "أربعاء", "خميس", "جمعة", "سبت"},
			daysWide:               []string{"الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"},
			periodsAbbreviated:     []string{"ص", "م"},
			periodsNarrow:          []string{"ص", "م"},
			periodsWide:            []string{"ص", "م"},
			erasAbbreviated:        []string{"ق.م", "م"},
			erasNarrow:             []string{"", ""},
			erasWide:               []string{"قبل الميلاد", "ميلادي"},
			timezones:              map[string]string{"ACDT": "توقيت وسط أستراليا الصيفي", "ACST": "توقيت وسط أستراليا الرسمي", "ACWDT": "توقيت غرب وسط أستراليا الصيفي", "ACWST": "توقيت غرب وسط أستراليا الرسمي", "ADT": "التوقيت الصيفي الأطلسي", "AEDT": "توقيت شرق أستراليا الصيفي", "AEST": "توقيت شرق أستراليا الرسمي", "AKDT": "توقيت ألاسكا الصيفي", "AKST": "التوقيت الرسمي لألاسكا", "ARST": "توقيت الأرجنتين الصيفي", "ART": "توقيت الأرجنتين الرسمي", "AST": "التوقيت الرسمي الأطلسي", "AWDT": "توقيت غرب أستراليا الصيفي", "AWST": "توقيت غرب أستراليا الرسمي", "BOT": "توقيت بوليفيا", "BT": "توقيت بوتان", "CAT": "توقيت وسط أفريقيا", "CDT": "التوقيت الصيفي المركزي لأمريكا الشمالية", "CHADT": "توقيت تشاتام الصيفي", "CHAST": "توقيت تشاتام الرسمي", "CLST": "توقيت تشيلي الصيفي", "CLT": "توقيت تشيلي الرسمي", "COST": "توقيت كولومبيا الصيفي", "COT": "توقيت كولومبيا الرسمي", "CST": "التوقيت الرسمي المركزي لأمريكا الشمالية", "ChST": "توقيت تشامورو", "EAT": "توقيت شرق أفريقيا", "ECT": "توقيت الإكوادور", "EDT": "التوقيت الصيفي الشرقي لأمريكا الشمالية", "EST": "التوقيت الرسمي الشرقي لأمريكا الشمالية", "GFT": "توقيت غويانا الفرنسية", "GMT": "توقيت غرينتش", "GST": "توقيت الخليج", "GYT": "توقيت غيانا", "HADT": "توقيت هاواي ألوتيان الصيفي", "HAST": "توقيت هاواي ألوتيان الرسمي", "HAT": "توقيت نيوفاوندلاند الصيفي", "HECU": "توقيت كوبا الصيفي", "HEEG": "توقيت شرق غرينلاند الصيفي", "HENOMX": "التوقيت الصيفي لشمال غرب المكسيك", "HEOG": "توقيت غرب غرينلاند الصيفي", "HEPM": "توقيت سانت بيير وميكولون الصيفي", "HEPMX": "توقيت المحيط الهادي الصيفي للمكسيك", "HKST": "توقيت هونغ كونغ الصيفي", "HKT": "توقيت هونغ كونغ الرسمي", "HNCU": "توقيت كوبا الرسمي", "HNEG": "توقيت شرق غرينلاند الرسمي", "HNNOMX": "التوقيت الرسمي لشمال غرب المكسيك", "HNOG": "توقيت غرب غرينلاند الرسمي", "HNPM": "توقيت سانت بيير وميكولون الرسمي", "HNPMX": "توقيت المحيط الهادي الرسمي للمكسيك", "HNT": "توقيت نيوفاوندلاند الرسمي", "IST": "توقيت الهند", "JDT": "توقيت اليابان الصيفي", "JST": "توقيت اليابان الرسمي", "LHDT": "التوقيت الصيفي للورد هاو", "LHST": "توقيت لورد هاو الرسمي", "MDT": "التوقيت الجبلي الصيفي لأمريكا الشمالية", "MESZ": "توقيت وسط أوروبا الصيفي", "MEZ": "توقيت وسط أوروبا الرسمي", "MST": "التوقيت الجبلي الرسمي لأمريكا الشمالية", "MYT": "توقيت ماليزيا", "NZDT": "توقيت نيوزيلندا الصيفي", "NZST": "توقيت نيوزيلندا الرسمي", "OESZ": "توقيت شرق أوروبا الصيفي", "OEZ": "توقيت شرق أوروبا الرسمي", "PDT": "توقيت المحيط الهادي الصيفي", "PST": "توقيت المحيط الهادي الرسمي", "SAST": "توقيت جنوب أفريقيا", "SGT": "توقيت سنغافورة", "SRT": "توقيت سورينام", "TMST": "توقيت تركمانستان الصيفي", "TMT": "توقيت تركمانستان الرسمي", "UYST": "توقيت أوروغواي الصيفي", "UYT": "توقيت أوروغواي الرسمي", "VET": "توقيت فنزويلا", "WARST": "توقيت غرب الأرجنتين الصيفي", "WART": "توقيت غرب الأرجنتين الرسمي", "WAST": "توقيت غرب أفريقيا الصيفي", "WAT": "توقيت غرب أفريقيا الرسمي", "WESZ": "توقيت غرب أوروبا الصيفي", "WEZ": "توقيت غرب أوروبا الرسمي", "WIB": "توقيت غرب إندونيسيا", "WIT": "توقيت شرق إندونيسيا", "WITA": "توقيت وسط إندونيسيا", "∅∅∅": "توقيت أزورس الصيفي"},

			fnCardinalPluralRule:  fnCardinalPluralRule_f27514af189883ea7cd186156edfe998,
			fnDecimal:             fnDecimal_a78485e7dd32c95f41af4e18420793bf,
			fnFmtAccounting:       fnFmtAccounting_f74088692afba81682b73af3d3e7c19a,
			fnFmtCurrency:         fnFmtCurrency_e28d302f22cf4ed4b5009e290f74e359,
			fnFmtDateFull:         fnFmtDateFull_2d3b405215099e683568cb9c052cbd54,
			fnFmtDateLong:         fnFmtDateLong_506f643cda0514f66d873a9ea99bf639,
			fnFmtDateMedium:       fnFmtDateMedium_a55320da438aec0cfbc31bc4d718abc1,
			fnFmtDateShort:        fnFmtDateShort_05c85041b5f9b6fa224b9c4ba9be3590,
			fnFmtNumber:           fnFmtNumber_eef52ddc8fa71bd12171ac9ef3cd3328,
			fnFmtPercent:          fnFmtPercent_60ca2e9d27b8160a5fec0f6694129759,
			fnFmtTimeFull:         fnFmtTimeFull_37fe4deeee789852cc196a6a1a2f0ccc,
			fnFmtTimeLong:         fnFmtTimeLong_4429ef4fb58a2a9c4d7d5132fd16ecbf,
			fnFmtTimeMedium:       fnFmtTimeMedium_8ef07f6477b7a4944577d4e5392ff21b,
			fnFmtTimeShort:        fnFmtTimeShort_8288b817c5c0216c9815524c71c9e0b4,
			fnGroup:               fnGroup_5c4b80a5ccdee81467241784ab8fcd56,
			fnLocale:              fnLocale_5a217059c67094defae82f249f55f4c5,
			fnMinus:               fnMinus_8b8229905258388dc16a5e0c270b0488,
			fnMonthAbbreviated:    fnMonthAbbreviated_aa9a9957cd9d056ba078b36a08b17478,
			fnMonthNarrow:         fnMonthNarrow_45916040ecf6fc350894d9e3e6c46dc7,
			fnMonthWide:           fnMonthWide_4c946a7e7581c665e7407df1841810b5,
			fnMonthsAbbreviated:   fnMonthsAbbreviated_181f77804b62232997fae36bd57d6cf7,
			fnMonthsNarrow:        fnMonthsNarrow_75daa2ba82ae9577292175c3f52370cc,
			fnMonthsWide:          fnMonthsWide_0ecf36a8b72255e2fee9467af362e989,
			fnOrdinalPluralRule:   fnOrdinalPluralRule_3355865f05dde9af2a36ba415bea85cb,
			fnPluralsCardinal:     fnPluralsCardinal_85b19cac1fab9f2c2cfb9eb41539aa0e,
			fnPluralsOrdinal:      fnPluralsOrdinal_16a60aa09da9778fa82fe463e83076de,
			fnPluralsRange:        fnPluralsRange_332465bda13eb808b3664fa0500f54ce,
			fnRangePluralRule:     fnRangePluralRule_47500e2a682fd3a64da69f06f7b93c0a,
			fnWeekdayAbbreviated:  fnWeekdayAbbreviated_4ffbdfbd2be10e6bd8fb5a542a14664a,
			fnWeekdayNarrow:       fnWeekdayNarrow_e86921b3446df5ea9afe9504cfa20d1a,
			fnWeekdayShort:        fnWeekdayShort_82b231d4f504c6d71c7e495aa35cd3c2,
			fnWeekdayWide:         fnWeekdayWide_ab7e026d8685cefd89c5aeb5df512a9a,
			fnWeekdaysAbbreviated: fnWeekdaysAbbreviated_454a3d7d23c662520a64ae5245d404be,
			fnWeekdaysNarrow:      fnWeekdaysNarrow_d23eb0b7a498c40ce19d1bf231cad524,
			fnWeekdaysShort:       fnWeekdaysShort_eb6ee64d01e314991432b4469790d38b,
			fnWeekdaysWide:        fnWeekdaysWide_5e2bbf75a31e730429c100e8a0bd3ebd,
		}
	}
	translatorFuncs["ar_jo"] = func() locales.Translator {
		return &localen{

			locale:                 "ar_JO",
			pluralsCardinal:        []locales.PluralRule{1, 2, 3, 4, 5, 6},
			pluralsOrdinal:         []locales.PluralRule{6},
			pluralsRange:           []locales.PluralRule{1, 4, 5, 6},
			decimal:                "٫",
			group:                  "٬",
			minus:                  "؜-",
			percent:                "٪؜",
			perMille:               "؉",
			timeSeparator:          ":",
			inifinity:              "∞",
			currencies:             []string{"ADP", "AED", "AFA", "AFN", "ALK", "ALL", "AMD", "ANG", "AOA", "AOK", "AON", "AOR", "ARA", "ARL", "ARM", "ARP", "ARS", "ATS", "AUD", "AWG", "AZM", "AZN", "BAD", "BAM", "BAN", "BBD", "BDT", "BEC", "BEF", "BEL", "BGL", "BGM", "BGN", "BGO", "BHD", "BIF", "BMD", "BND", "BOB", "BOL", "BOP", "BOV", "BRB", "BRC", "BRE", "BRL", "BRN", "BRR", "BRZ", "BSD", "BTN", "BUK", "BWP", "BYB", "BYN", "BYR", "BZD", "CAD", "CDF", "CHE", "CHF", "CHW", "CLE", "CLF", "CLP", "CNH", "CNX", "CNY", "COP", "COU", "CRC", "CSD", "CSK", "CUC", "CUP", "CVE", "CYP", "CZK", "DDM", "DEM", "DJF", "DKK", "DOP", "DZD", "ECS", "ECV", "EEK", "EGP", "ERN", "ESA", "ESB", "ESP", "ETB", "EUR", "FIM", "FJD", "FKP", "FRF", "GBP", "GEK", "GEL", "GHC", "GHS", "GIP", "GMD", "GNF", "GNS", "GQE", "GRD", "GTQ", "GWE", "GWP", "GYD", "HKD", "HNL", "HRD", "HRK", "HTG", "HUF", "IDR", "IEP", "ILP", "ILR", "ILS", "INR", "IQD", "IRR", "ISJ", "ISK", "ITL", "JMD", "JOD", "JPY", "KES", "KGS", "KHR", "KMF", "KPW", "KRH", "KRO", "KRW", "KWD", "KYD", "KZT", "LAK", "LBP", "LKR", "LRD", "LSL", "LTL", "LTT", "LUC", "LUF", "LUL", "LVL", "LVR", "LYD", "MAD", "MAF", "MCF", "MDC", "MDL", "MGA", "MGF", "MKD", "MKN", "MLF", "MMK", "MNT", "MOP", "MRO", "MRU", "MTL", "MTP", "MUR", "MVP", "MVR", "MWK", "MXN", "MXP", "MXV", "MYR", "MZE", "MZM", "MZN", "NAD", "NGN", "NIC", "NIO", "NLG", "NOK", "NPR", "NZD", "OMR", "PAB", "PEI", "PEN", "PES", "PGK", "PHP", "PKR", "PLN", "PLZ", "PTE", "PYG", "QAR", "RHD", "ROL", "RON", "RSD", "RUB", "RUR", "RWF", "SAR", "SBD", "SCR", "SDD", "SDG", "SDP", "SEK", "SGD", "SHP", "SIT", "SKK", "SLL", "SOS", "SRD", "SRG", "SSP", "STD", "STN", "SUR", "SVC", "SYP", "SZL", "THB", "TJR", "TJS", "TMM", "TMT", "TND", "TOP", "TPE", "TRL", "TRY", "TTD", "TWD", "TZS", "UAH", "UAK", "UGS", "UGX", "USD", "USN", "USS", "UYI", "UYP", "UYU", "UYW", "UZS", "VEB", "VEF", "VES", "VND", "VNN", "VUV", "WST", "XAF", "XAG", "XAU", "XBA", "XBB", "XBC", "XBD", "XCD", "XDR", "XEU", "XFO", "XFU", "XOF", "XPD", "XPF", "XPT", "XRE", "XSU", "XTS", "XUA", "XXX", "YDD", "YER", "YUD", "YUM", "YUN", "YUR", "ZAL", "ZAR", "ZMK", "ZMW", "ZRN", "ZRZ", "ZWD", "ZWL", "ZWR"},
			currencyPositiveSuffix: " ",
			currencyNegativeSuffix: " ",
			monthsAbbreviated:      []string{"", "كانون الثاني", "شباط", "آذار", "نيسان", "أيار", "حزيران", "تموز", "آب", "أيلول", "تشرين الأول", "تشرين الثاني", "كانون الأول"},
			monthsNarrow:           []string{"", "ك", "ش", "آ", "ن", "أ", "ح", "ت", "آ", "أ", "ت", "ت", "ك"},
			monthsWide:             []string{"", "كانون الثاني", "شباط", "آذار", "نيسان", "أيار", "حزيران", "تموز", "آب", "أيلول", "تشرين الأول", "تشرين الثاني", "كانون الأول"},
			daysAbbreviated:        []string{"الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"},
			daysNarrow:             []string{"ح", "ن", "ث", "ر", "خ", "ج", "س"},
			daysShort:              []string{"أحد", "إثنين", "ثلاثاء", "أربعاء", "خميس", "جمعة", "سبت"},
			daysWide:               []string{"الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"},
			periodsAbbreviated:     []string{"ص", "م"},
			periodsNarrow:          []string{"ص", "م"},
			periodsWide:            []string{"ص", "م"},
			erasAbbreviated:        []string{"ق.م", "م"},
			erasNarrow:             []string{"", ""},
			erasWide:               []string{"قبل الميلاد", "ميلادي"},
			timezones:              map[string]string{"ACDT": "توقيت وسط أستراليا الصيفي", "ACST": "توقيت وسط أستراليا الرسمي", "ACWDT": "توقيت غرب وسط أستراليا الصيفي", "ACWST": "توقيت غرب وسط أستراليا الرسمي", "ADT": "التوقيت الصيفي الأطلسي", "AEDT": "توقيت شرق أستراليا الصيفي", "AEST": "توقيت شرق أستراليا الرسمي", "AKDT": "توقيت ألاسكا الصيفي", "AKST": "التوقيت الرسمي لألاسكا", "ARST": "توقيت الأرجنتين الصيفي", "ART": "توقيت الأرجنتين الرسمي", "AST": "التوقيت الرسمي الأطلسي", "AWDT": "توقيت غرب أستراليا الصيفي", "AWST": "توقيت غرب أستراليا الرسمي", "BOT": "توقيت بوليفيا", "BT": "توقيت بوتان", "CAT": "توقيت وسط أفريقيا", "CDT": "التوقيت الصيفي المركزي لأمريكا الشمالية", "CHADT": "توقيت تشاتام الصيفي", "CHAST": "توقيت تشاتام الرسمي", "CLST": "توقيت تشيلي الصيفي", "CLT": "توقيت تشيلي الرسمي", "COST": "توقيت كولومبيا الصيفي", "COT": "توقيت كولومبيا الرسمي", "CST": "التوقيت الرسمي المركزي لأمريكا الشمالية", "ChST": "توقيت تشامورو", "EAT": "توقيت شرق أفريقيا", "ECT": "توقيت الإكوادور", "EDT": "التوقيت الصيفي الشرقي لأمريكا الشمالية", "EST": "التوقيت الرسمي الشرقي لأمريكا الشمالية", "GFT": "توقيت غويانا الفرنسية", "GMT": "توقيت غرينتش", "GST": "توقيت الخليج", "GYT": "توقيت غيانا", "HADT": "توقيت هاواي ألوتيان الصيفي", "HAST": "توقيت هاواي ألوتيان الرسمي", "HAT": "توقيت نيوفاوندلاند الصيفي", "HECU": "توقيت كوبا الصيفي", "HEEG": "توقيت شرق غرينلاند الصيفي", "HENOMX": "التوقيت الصيفي لشمال غرب المكسيك", "HEOG": "توقيت غرب غرينلاند الصيفي", "HEPM": "توقيت سانت بيير وميكولون الصيفي", "HEPMX": "توقيت المحيط الهادي الصيفي للمكسيك", "HKST": "توقيت هونغ كونغ الصيفي", "HKT": "توقيت هونغ كونغ الرسمي", "HNCU": "توقيت كوبا الرسمي", "HNEG": "توقيت شرق غرينلاند الرسمي", "HNNOMX": "التوقيت الرسمي لشمال غرب المكسيك", "HNOG": "توقيت غرب غرينلاند الرسمي", "HNPM": "توقيت سانت بيير وميكولون الرسمي", "HNPMX": "توقيت المحيط الهادي الرسمي للمكسيك", "HNT": "توقيت نيوفاوندلاند الرسمي", "IST": "توقيت الهند", "JDT": "توقيت اليابان الصيفي", "JST": "توقيت اليابان الرسمي", "LHDT": "التوقيت الصيفي للورد هاو", "LHST": "توقيت لورد هاو الرسمي", "MDT": "التوقيت الجبلي الصيفي لأمريكا الشمالية", "MESZ": "توقيت وسط أوروبا الصيفي", "MEZ": "توقيت وسط أوروبا الرسمي", "MST": "التوقيت الجبلي الرسمي لأمريكا الشمالية", "MYT": "توقيت ماليزيا", "NZDT": "توقيت نيوزيلندا الصيفي", "NZST": "توقيت نيوزيلندا الرسمي", "OESZ": "توقيت شرق أوروبا الصيفي", "OEZ": "توقيت شرق أوروبا الرسمي", "PDT": "توقيت المحيط الهادي الصيفي", "PST": "توقيت المحيط الهادي الرسمي", "SAST": "توقيت جنوب أفريقيا", "SGT": "توقيت سنغافورة", "SRT": "توقيت سورينام", "TMST": "توقيت تركمانستان الصيفي", "TMT": "توقيت تركمانستان الرسمي", "UYST": "توقيت أوروغواي الصيفي", "UYT": "توقيت أوروغواي الرسمي", "VET": "توقيت فنزويلا", "WARST": "توقيت غرب الأرجنتين الصيفي", "WART": "توقيت غرب الأرجنتين الرسمي", "WAST": "توقيت غرب أفريقيا الصيفي", "WAT": "توقيت غرب أفريقيا الرسمي", "WESZ": "توقيت غرب أوروبا الصيفي", "WEZ": "توقيت غرب أوروبا الرسمي", "WIB": "توقيت غرب إندونيسيا", "WIT": "توقيت شرق إندونيسيا", "WITA": "توقيت وسط إندونيسيا", "∅∅∅": "توقيت أزورس الصيفي"},

			fnCardinalPluralRule:  fnCardinalPluralRule_f27514af189883ea7cd186156edfe998,
			fnDecimal:             fnDecimal_a78485e7dd32c95f41af4e18420793bf,
			fnFmtAccounting:       fnFmtAccounting_f74088692afba81682b73af3d3e7c19a,
			fnFmtCurrency:         fnFmtCurrency_e28d302f22cf4ed4b5009e290f74e359,
			fnFmtDateFull:         fnFmtDateFull_2d3b405215099e683568cb9c052cbd54,
			fnFmtDateLong:         fnFmtDateLong_506f643cda0514f66d873a9ea99bf639,
			fnFmtDateMedium:       fnFmtDateMedium_a55320da438aec0cfbc31bc4d718abc1,
			fnFmtDateShort:        fnFmtDateShort_05c85041b5f9b6fa224b9c4ba9be3590,
			fnFmtNumber:           fnFmtNumber_eef52ddc8fa71bd12171ac9ef3cd3328,
			fnFmtPercent:          fnFmtPercent_60ca2e9d27b8160a5fec0f6694129759,
			fnFmtTimeFull:         fnFmtTimeFull_37fe4deeee789852cc196a6a1a2f0ccc,
			fnFmtTimeLong:         fnFmtTimeLong_4429ef4fb58a2a9c4d7d5132fd16ecbf,
			fnFmtTimeMedium:       fnFmtTimeMedium_8ef07f6477b7a4944577d4e5392ff21b,
			fnFmtTimeShort:        fnFmtTimeShort_8288b817c5c0216c9815524c71c9e0b4,
			fnGroup:               fnGroup_5c4b80a5ccdee81467241784ab8fcd56,
			fnLocale:              fnLocale_5a217059c67094defae82f249f55f4c5,
			fnMinus:               fnMinus_8b8229905258388dc16a5e0c270b0488,
			fnMonthAbbreviated:    fnMonthAbbreviated_aa9a9957cd9d056ba078b36a08b17478,
			fnMonthNarrow:         fnMonthNarrow_45916040ecf6fc350894d9e3e6c46dc7,
			fnMonthWide:           fnMonthWide_4c946a7e7581c665e7407df1841810b5,
			fnMonthsAbbreviated:   fnMonthsAbbreviated_181f77804b62232997fae36bd57d6cf7,
			fnMonthsNarrow:        fnMonthsNarrow_75daa2ba82ae9577292175c3f52370cc,
			fnMonthsWide:          fnMonthsWide_0ecf36a8b72255e2fee9467af362e989,
			fnOrdinalPluralRule:   fnOrdinalPluralRule_3355865f05dde9af2a36ba415bea85cb,
			fnPluralsCardinal:     fnPluralsCardinal_85b19cac1fab9f2c2cfb9eb41539aa0e,
			fnPluralsOrdinal:      fnPluralsOrdinal_16a60aa09da9778fa82fe463e83076de,
			fnPluralsRange:        fnPluralsRange_332465bda13eb808b3664fa0500f54ce,
			fnRangePluralRule:     fnRangePluralRule_47500e2a682fd3a64da69f06f7b93c0a,
			fnWeekdayAbbreviated:  fnWeekdayAbbreviated_4ffbdfbd2be10e6bd8fb5a542a14664a,
			fnWeekdayNarrow:       fnWeekdayNarrow_e86921b3446df5ea9afe9504cfa20d1a,
			fnWeekdayShort:        fnWeekdayShort_82b231d4f504c6d71c7e495aa35cd3c2,
			fnWeekdayWide:         fnWeekdayWide_ab7e026d8685cefd89c5aeb5df512a9a,
			fnWeekdaysAbbreviated: fnWeekdaysAbbreviated_454a3d7d23c662520a64ae5245d404be,
			fnWeekdaysNarrow:      fnWeekdaysNarrow_d23eb0b7a498c40ce19d1bf231cad524,
			fnWeekdaysShort:       fnWeekdaysShort_eb6ee64d01e314991432b4469790d38b,
			fnWeekdaysWide:        fnWeekdaysWide_5e2bbf75a31e730429c100e8a0bd3ebd,
		}
	}
	translatorFuncs["ar_km"] = func() locales.Translator {
		return &localen{

			locale:                 "ar_KM",
			pluralsCardinal:        []locales.PluralRule{1, 2, 3, 4, 5, 6},
			pluralsOrdinal:         []locales.PluralRule{6},
			pluralsRange:           []locales.PluralRule{1, 4, 5, 6},
			decimal:                "٫",
			group:                  "٬",
			minus:                  "؜-",
			percent:                "٪؜",
			perMille:               "؉",
			timeSeparator:          ":",
			inifinity:              "∞",
			currencies:             []string{"ADP", "AED", "AFA", "AFN", "ALK", "ALL", "AMD", "ANG", "AOA", "AOK", "AON", "AOR", "ARA", "ARL", "ARM", "ARP", "ARS", "ATS", "AUD", "AWG", "AZM", "AZN", "BAD", "BAM", "BAN", "BBD", "BDT", "BEC", "BEF", "BEL", "BGL", "BGM", "BGN", "BGO", "BHD", "BIF", "BMD", "BND", "BOB", "BOL", "BOP", "BOV", "BRB", "BRC", "BRE", "BRL", "BRN", "BRR", "BRZ", "BSD", "BTN", "BUK", "BWP", "BYB", "BYN", "BYR", "BZD", "CAD", "CDF", "CHE", "CHF", "CHW", "CLE", "CLF", "CLP", "CNH", "CNX", "CNY", "COP", "COU", "CRC", "CSD", "CSK", "CUC", "CUP", "CVE", "CYP", "CZK", "DDM", "DEM", "DJF", "DKK", "DOP", "DZD", "ECS", "ECV", "EEK", "EGP", "ERN", "ESA", "ESB", "ESP", "ETB", "EUR", "FIM", "FJD", "FKP", "FRF", "GBP", "GEK", "GEL", "GHC", "GHS", "GIP", "GMD", "GNF", "GNS", "GQE", "GRD", "GTQ", "GWE", "GWP", "GYD", "HKD", "HNL", "HRD", "HRK", "HTG", "HUF", "IDR", "IEP", "ILP", "ILR", "ILS", "INR", "IQD", "IRR", "ISJ", "ISK", "ITL", "JMD", "JOD", "JPY", "KES", "KGS", "KHR", "CF", "KPW", "KRH", "KRO", "KRW", "KWD", "KYD", "KZT", "LAK", "LBP", "LKR", "LRD", "LSL", "LTL", "LTT", "LUC", "LUF", "LUL", "LVL", "LVR", "LYD", "MAD", "MAF", "MCF", "MDC", "MDL", "MGA", "MGF", "MKD", "MKN", "MLF", "MMK", "MNT", "MOP", "MRO", "MRU", "MTL", "MTP", "MUR", "MVP", "MVR", "MWK", "MXN", "MXP", "MXV", "MYR", "MZE", "MZM", "MZN", "NAD", "NGN", "NIC", "NIO", "NLG", "NOK", "NPR", "NZD", "OMR", "PAB", "PEI", "PEN", "PES", "PGK", "PHP", "PKR", "PLN", "PLZ", "PTE", "PYG", "QAR", "RHD", "ROL", "RON", "RSD", "RUB", "RUR", "RWF", "SAR", "SBD", "SCR", "SDD", "SDG", "SDP", "SEK", "SGD", "SHP", "SIT", "SKK", "SLL", "SOS", "SRD", "SRG", "SSP", "STD", "STN", "SUR", "SVC", "SYP", "SZL", "THB", "TJR", "TJS", "TMM", "TMT", "TND", "TOP", "TPE", "TRL", "TRY", "TTD", "TWD", "TZS", "UAH", "UAK", "UGS", "UGX", "USD", "USN", "USS", "UYI", "UYP", "UYU", "UYW", "UZS", "VEB", "VEF", "VES", "VND", "VNN", "VUV", "WST", "XAF", "XAG", "XAU", "XBA", "XBB", "XBC", "XBD", "XCD", "XDR", "XEU", "XFO", "XFU", "XOF", "XPD", "XPF", "XPT", "XRE", "XSU", "XTS", "XUA", "XXX", "YDD", "YER", "YUD", "YUM", "YUN", "YUR", "ZAL", "ZAR", "ZMK", "ZMW", "ZRN", "ZRZ", "ZWD", "ZWL", "ZWR"},
			currencyPositiveSuffix: " ",
			currencyNegativeSuffix: " ",
			monthsAbbreviated:      []string{"", "يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"},
			monthsNarrow:           []string{"", "ي", "ف", "م", "أ", "و", "ن", "ل", "غ", "س", "ك", "ب", "د"},
			monthsWide:             []string{"", "يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"},
			daysAbbreviated:        []string{"الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"},
			daysNarrow:             []string{"ح", "ن", "ث", "ر", "خ", "ج", "س"},
			daysShort:              []string{"أحد", "إثنين", "ثلاثاء", "أربعاء", "خميس", "جمعة", "سبت"},
			daysWide:               []string{"الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"},
			periodsAbbreviated:     []string{"ص", "م"},
			periodsNarrow:          []string{"ص", "م"},
			periodsWide:            []string{"ص", "م"},
			erasAbbreviated:        []string{"ق.م", "م"},
			erasNarrow:             []string{"", ""},
			erasWide:               []string{"قبل الميلاد", "ميلادي"},
			timezones:              map[string]string{"ACDT": "توقيت وسط أستراليا الصيفي", "ACST": "توقيت وسط أستراليا الرسمي", "ACWDT": "توقيت غرب وسط أستراليا الصيفي", "ACWST": "توقيت غرب وسط أستراليا الرسمي", "ADT": "التوقيت الصيفي الأطلسي", "AEDT": "توقيت شرق أستراليا الصيفي", "AEST": "توقيت شرق أستراليا الرسمي", "AKDT": "توقيت ألاسكا الصيفي", "AKST": "التوقيت الرسمي لألاسكا", "ARST": "توقيت الأرجنتين الصيفي", "ART": "توقيت الأرجنتين الرسمي", "AST": "التوقيت الرسمي الأطلسي", "AWDT": "توقيت غرب أستراليا الصيفي", "AWST": "توقيت غرب أستراليا الرسمي", "BOT": "توقيت بوليفيا", "BT": "توقيت بوتان", "CAT": "توقيت وسط أفريقيا", "CDT": "التوقيت الصيفي المركزي لأمريكا الشمالية", "CHADT": "توقيت تشاتام الصيفي", "CHAST": "توقيت تشاتام الرسمي", "CLST": "توقيت تشيلي الصيفي", "CLT": "توقيت تشيلي الرسمي", "COST": "توقيت كولومبيا الصيفي", "COT": "توقيت كولومبيا الرسمي", "CST": "التوقيت الرسمي المركزي لأمريكا الشمالية", "ChST": "توقيت تشامورو", "EAT": "توقيت شرق أفريقيا", "ECT": "توقيت الإكوادور", "EDT": "التوقيت الصيفي الشرقي لأمريكا الشمالية", "EST": "التوقيت الرسمي الشرقي لأمريكا الشمالية", "GFT": "توقيت غويانا الفرنسية", "GMT": "توقيت غرينتش", "GST": "توقيت الخليج", "GYT": "توقيت غيانا", "HADT": "توقيت هاواي ألوتيان الصيفي", "HAST": "توقيت هاواي ألوتيان الرسمي", "HAT": "توقيت نيوفاوندلاند الصيفي", "HECU": "توقيت كوبا الصيفي", "HEEG": "توقيت شرق غرينلاند الصيفي", "HENOMX": "التوقيت الصيفي لشمال غرب المكسيك", "HEOG": "توقيت غرب غرينلاند الصيفي", "HEPM": "توقيت سانت بيير وميكولون الصيفي", "HEPMX": "توقيت المحيط الهادي الصيفي للمكسيك", "HKST": "توقيت هونغ كونغ الصيفي", "HKT": "توقيت هونغ كونغ الرسمي", "HNCU": "توقيت كوبا الرسمي", "HNEG": "توقيت شرق غرينلاند الرسمي", "HNNOMX": "التوقيت الرسمي لشمال غرب المكسيك", "HNOG": "توقيت غرب غرينلاند الرسمي", "HNPM": "توقيت سانت بيير وميكولون الرسمي", "HNPMX": "توقيت المحيط الهادي الرسمي للمكسيك", "HNT": "توقيت نيوفاوندلاند الرسمي", "IST": "توقيت الهند", "JDT": "توقيت اليابان الصيفي", "JST": "توقيت اليابان الرسمي", "LHDT": "التوقيت الصيفي للورد هاو", "LHST": "توقيت لورد هاو الرسمي", "MDT": "التوقيت الجبلي الصيفي لأمريكا الشمالية", "MESZ": "توقيت وسط أوروبا الصيفي", "MEZ": "توقيت وسط أوروبا الرسمي", "MST": "التوقيت الجبلي الرسمي لأمريكا الشمالية", "MYT": "توقيت ماليزيا", "NZDT": "توقيت نيوزيلندا الصيفي", "NZST": "توقيت نيوزيلندا الرسمي", "OESZ": "توقيت شرق أوروبا الصيفي", "OEZ": "توقيت شرق أوروبا الرسمي", "PDT": "توقيت المحيط الهادي الصيفي", "PST": "توقيت المحيط الهادي الرسمي", "SAST": "توقيت جنوب أفريقيا", "SGT": "توقيت سنغافورة", "SRT": "توقيت سورينام", "TMST": "توقيت تركمانستان الصيفي", "TMT": "توقيت تركمانستان الرسمي", "UYST": "توقيت أوروغواي الصيفي", "UYT": "توقيت أوروغواي الرسمي", "VET": "توقيت فنزويلا", "WARST": "توقيت غرب الأرجنتين الصيفي", "WART": "توقيت غرب الأرجنتين الرسمي", "WAST": "توقيت غرب أفريقيا الصيفي", "WAT": "توقيت غرب أفريقيا الرسمي", "WESZ": "توقيت غرب أوروبا الصيفي", "WEZ": "توقيت غرب أوروبا الرسمي", "WIB": "توقيت غرب إندونيسيا", "WIT": "توقيت شرق إندونيسيا", "WITA": "توقيت وسط إندونيسيا", "∅∅∅": "توقيت برازيليا الصيفي"},

			fnCardinalPluralRule:  fnCardinalPluralRule_f27514af189883ea7cd186156edfe998,
			fnDecimal:             fnDecimal_a78485e7dd32c95f41af4e18420793bf,
			fnFmtAccounting:       fnFmtAccounting_f74088692afba81682b73af3d3e7c19a,
			fnFmtCurrency:         fnFmtCurrency_e28d302f22cf4ed4b5009e290f74e359,
			fnFmtDateFull:         fnFmtDateFull_2d3b405215099e683568cb9c052cbd54,
			fnFmtDateLong:         fnFmtDateLong_506f643cda0514f66d873a9ea99bf639,
			fnFmtDateMedium:       fnFmtDateMedium_a55320da438aec0cfbc31bc4d718abc1,
			fnFmtDateShort:        fnFmtDateShort_05c85041b5f9b6fa224b9c4ba9be3590,
			fnFmtNumber:           fnFmtNumber_eef52ddc8fa71bd12171ac9ef3cd3328,
			fnFmtPercent:          fnFmtPercent_60ca2e9d27b8160a5fec0f6694129759,
			fnFmtTimeFull:         fnFmtTimeFull_ebdf96de1e47f9043145564c500ef7dc,
			fnFmtTimeLong:         fnFmtTimeLong_987bec4676d3a5de4218e415e123649d,
			fnFmtTimeMedium:       fnFmtTimeMedium_b6f697552cd4965cd1195fe56dc87003,
			fnFmtTimeShort:        fnFmtTimeShort_8ffba4d1a2f04a0a6486853d76cf434b,
			fnGroup:               fnGroup_5c4b80a5ccdee81467241784ab8fcd56,
			fnLocale:              fnLocale_5a217059c67094defae82f249f55f4c5,
			fnMinus:               fnMinus_8b8229905258388dc16a5e0c270b0488,
			fnMonthAbbreviated:    fnMonthAbbreviated_aa9a9957cd9d056ba078b36a08b17478,
			fnMonthNarrow:         fnMonthNarrow_45916040ecf6fc350894d9e3e6c46dc7,
			fnMonthWide:           fnMonthWide_4c946a7e7581c665e7407df1841810b5,
			fnMonthsAbbreviated:   fnMonthsAbbreviated_181f77804b62232997fae36bd57d6cf7,
			fnMonthsNarrow:        fnMonthsNarrow_75daa2ba82ae9577292175c3f52370cc,
			fnMonthsWide:          fnMonthsWide_0ecf36a8b72255e2fee9467af362e989,
			fnOrdinalPluralRule:   fnOrdinalPluralRule_3355865f05dde9af2a36ba415bea85cb,
			fnPluralsCardinal:     fnPluralsCardinal_85b19cac1fab9f2c2cfb9eb41539aa0e,
			fnPluralsOrdinal:      fnPluralsOrdinal_16a60aa09da9778fa82fe463e83076de,
			fnPluralsRange:        fnPluralsRange_332465bda13eb808b3664fa0500f54ce,
			fnRangePluralRule:     fnRangePluralRule_47500e2a682fd3a64da69f06f7b93c0a,
			fnWeekdayAbbreviated:  fnWeekdayAbbreviated_4ffbdfbd2be10e6bd8fb5a542a14664a,
			fnWeekdayNarrow:       fnWeekdayNarrow_e86921b3446df5ea9afe9504cfa20d1a,
			fnWeekdayShort:        fnWeekdayShort_82b231d4f504c6d71c7e495aa35cd3c2,
			fnWeekdayWide:         fnWeekdayWide_ab7e026d8685cefd89c5aeb5df512a9a,
			fnWeekdaysAbbreviated: fnWeekdaysAbbreviated_454a3d7d23c662520a64ae5245d404be,
			fnWeekdaysNarrow:      fnWeekdaysNarrow_d23eb0b7a498c40ce19d1bf231cad524,
			fnWeekdaysShort:       fnWeekdaysShort_eb6ee64d01e314991432b4469790d38b,
			fnWeekdaysWide:        fnWeekdaysWide_5e2bbf75a31e730429c100e8a0bd3ebd,
		}
	}
	translatorFuncs["ar_kw"] = func() locales.Translator {
		return &localen{

			locale:                 "ar_KW",
			pluralsCardinal:        []locales.PluralRule{1, 2, 3, 4, 5, 6},
			pluralsOrdinal:         []locales.PluralRule{6},
			pluralsRange:           []locales.PluralRule{1, 4, 5, 6},
			decimal:                "٫",
			group:                  "٬",
			minus:                  "؜-",
			percent:                "٪؜",
			perMille:               "؉",
			timeSeparator:          ":",
			inifinity:              "∞",
			currencies:             []string{"ADP", "AED", "AFA", "AFN", "ALK", "ALL", "AMD", "ANG", "AOA", "AOK", "AON", "AOR", "ARA", "ARL", "ARM", "ARP", "ARS", "ATS", "AUD", "AWG", "AZM", "AZN", "BAD", "BAM", "BAN", "BBD", "BDT", "BEC", "BEF", "BEL", "BGL", "BGM", "BGN", "BGO", "BHD", "BIF", "BMD", "BND", "BOB", "BOL", "BOP", "BOV", "BRB", "BRC", "BRE", "BRL", "BRN", "BRR", "BRZ", "BSD", "BTN", "BUK", "BWP", "BYB", "BYN", "BYR", "BZD", "CAD", "CDF", "CHE", "CHF", "CHW", "CLE", "CLF", "CLP", "CNH", "CNX", "CNY", "COP", "COU", "CRC", "CSD", "CSK", "CUC", "CUP", "CVE", "CYP", "CZK", "DDM", "DEM", "DJF", "DKK", "DOP", "DZD", "ECS", "ECV", "EEK", "EGP", "ERN", "ESA", "ESB", "ESP", "ETB", "EUR", "FIM", "FJD", "FKP", "FRF", "GBP", "GEK", "GEL", "GHC", "GHS", "GIP", "GMD", "GNF", "GNS", "GQE", "GRD", "GTQ", "GWE", "GWP", "GYD", "HKD", "HNL", "HRD", "HRK", "HTG", "HUF", "IDR", "IEP", "ILP", "ILR", "ILS", "INR", "IQD", "IRR", "ISJ", "ISK", "ITL", "JMD", "JOD", "JPY", "KES", "KGS", "KHR", "KMF", "KPW", "KRH", "KRO", "KRW", "KWD", "KYD", "KZT", "LAK", "LBP", "LKR", "LRD", "LSL", "LTL", "LTT", "LUC", "LUF", "LUL", "LVL", "LVR", "LYD", "MAD", "MAF", "MCF", "MDC", "MDL", "MGA", "MGF", "MKD", "MKN", "MLF", "MMK", "MNT", "MOP", "MRO", "MRU", "MTL", "MTP", "MUR", "MVP", "MVR", "MWK", "MXN", "MXP", "MXV", "MYR", "MZE", "MZM", "MZN", "NAD", "NGN", "NIC", "NIO", "NLG", "NOK", "NPR", "NZD", "OMR", "PAB", "PEI", "PEN", "PES", "PGK", "PHP", "PKR", "PLN", "PLZ", "PTE", "PYG", "QAR", "RHD", "ROL", "RON", "RSD", "RUB", "RUR", "RWF", "SAR", "SBD", "SCR", "SDD", "SDG", "SDP", "SEK", "SGD", "SHP", "SIT", "SKK", "SLL", "SOS", "SRD", "SRG", "SSP", "STD", "STN", "SUR", "SVC", "SYP", "SZL", "THB", "TJR", "TJS", "TMM", "TMT", "TND", "TOP", "TPE", "TRL", "TRY", "TTD", "TWD", "TZS", "UAH", "UAK", "UGS", "UGX", "USD", "USN", "USS", "UYI", "UYP", "UYU", "UYW", "UZS", "VEB", "VEF", "VES", "VND", "VNN", "VUV", "WST", "XAF", "XAG", "XAU", "XBA", "XBB", "XBC", "XBD", "XCD", "XDR", "XEU", "XFO", "XFU", "XOF", "XPD", "XPF", "XPT", "XRE", "XSU", "XTS", "XUA", "XXX", "YDD", "YER", "YUD", "YUM", "YUN", "YUR", "ZAL", "ZAR", "ZMK", "ZMW", "ZRN", "ZRZ", "ZWD", "ZWL", "ZWR"},
			currencyPositiveSuffix: " ",
			currencyNegativeSuffix: " ",
			monthsAbbreviated:      []string{"", "يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"},
			monthsNarrow:           []string{"", "ي", "ف", "م", "أ", "و", "ن", "ل", "غ", "س", "ك", "ب", "د"},
			monthsWide:             []string{"", "يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"},
			daysAbbreviated:        []string{"الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"},
			daysNarrow:             []string{"ح", "ن", "ث", "ر", "خ", "ج", "س"},
			daysShort:              []string{"أحد", "إثنين", "ثلاثاء", "أربعاء", "خميس", "جمعة", "سبت"},
			daysWide:               []string{"الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"},
			periodsAbbreviated:     []string{"ص", "م"},
			periodsNarrow:          []string{"ص", "م"},
			periodsWide:            []string{"ص", "م"},
			erasAbbreviated:        []string{"ق.م", "م"},
			erasNarrow:             []string{"", ""},
			erasWide:               []string{"قبل الميلاد", "ميلادي"},
			timezones:              map[string]string{"ACDT": "توقيت وسط أستراليا الصيفي", "ACST": "توقيت وسط أستراليا الرسمي", "ACWDT": "توقيت غرب وسط أستراليا الصيفي", "ACWST": "توقيت غرب وسط أستراليا الرسمي", "ADT": "التوقيت الصيفي الأطلسي", "AEDT": "توقيت شرق أستراليا الصيفي", "AEST": "توقيت شرق أستراليا الرسمي", "AKDT": "توقيت ألاسكا الصيفي", "AKST": "التوقيت الرسمي لألاسكا", "ARST": "توقيت الأرجنتين الصيفي", "ART": "توقيت الأرجنتين الرسمي", "AST": "التوقيت الرسمي الأطلسي", "AWDT": "توقيت غرب أستراليا الصيفي", "AWST": "توقيت غرب أستراليا الرسمي", "BOT": "توقيت بوليفيا", "BT": "توقيت بوتان", "CAT": "توقيت وسط أفريقيا", "CDT": "التوقيت الصيفي المركزي لأمريكا الشمالية", "CHADT": "توقيت تشاتام الصيفي", "CHAST": "توقيت تشاتام الرسمي", "CLST": "توقيت تشيلي الصيفي", "CLT": "توقيت تشيلي الرسمي", "COST": "توقيت كولومبيا الصيفي", "COT": "توقيت كولومبيا الرسمي", "CST": "التوقيت الرسمي المركزي لأمريكا الشمالية", "ChST": "توقيت تشامورو", "EAT": "توقيت شرق أفريقيا", "ECT": "توقيت الإكوادور", "EDT": "التوقيت الصيفي الشرقي لأمريكا الشمالية", "EST": "التوقيت الرسمي الشرقي لأمريكا الشمالية", "GFT": "توقيت غويانا الفرنسية", "GMT": "توقيت غرينتش", "GST": "توقيت الخليج", "GYT": "توقيت غيانا", "HADT": "توقيت هاواي ألوتيان الصيفي", "HAST": "توقيت هاواي ألوتيان الرسمي", "HAT": "توقيت نيوفاوندلاند الصيفي", "HECU": "توقيت كوبا الصيفي", "HEEG": "توقيت شرق غرينلاند الصيفي", "HENOMX": "التوقيت الصيفي لشمال غرب المكسيك", "HEOG": "توقيت غرب غرينلاند الصيفي", "HEPM": "توقيت سانت بيير وميكولون الصيفي", "HEPMX": "توقيت المحيط الهادي الصيفي للمكسيك", "HKST": "توقيت هونغ كونغ الصيفي", "HKT": "توقيت هونغ كونغ الرسمي", "HNCU": "توقيت كوبا الرسمي", "HNEG": "توقيت شرق غرينلاند الرسمي", "HNNOMX": "التوقيت الرسمي لشمال غرب المكسيك", "HNOG": "توقيت غرب غرينلاند الرسمي", "HNPM": "توقيت سانت بيير وميكولون الرسمي", "HNPMX": "توقيت المحيط الهادي الرسمي للمكسيك", "HNT": "توقيت نيوفاوندلاند الرسمي", "IST": "توقيت الهند", "JDT": "توقيت اليابان الصيفي", "JST": "توقيت اليابان الرسمي", "LHDT": "التوقيت الصيفي للورد هاو", "LHST": "توقيت لورد هاو الرسمي", "MDT": "التوقيت الجبلي الصيفي لأمريكا الشمالية", "MESZ": "توقيت وسط أوروبا الصيفي", "MEZ": "توقيت وسط أوروبا الرسمي", "MST": "التوقيت الجبلي الرسمي لأمريكا الشمالية", "MYT": "توقيت ماليزيا", "NZDT": "توقيت نيوزيلندا الصيفي", "NZST": "توقيت نيوزيلندا الرسمي", "OESZ": "توقيت شرق أوروبا الصيفي", "OEZ": "توقيت شرق أوروبا الرسمي", "PDT": "توقيت المحيط الهادي الصيفي", "PST": "توقيت المحيط الهادي الرسمي", "SAST": "توقيت جنوب أفريقيا", "SGT": "توقيت سنغافورة", "SRT": "توقيت سورينام", "TMST": "توقيت تركمانستان الصيفي", "TMT": "توقيت تركمانستان الرسمي", "UYST": "توقيت أوروغواي الصيفي", "UYT": "توقيت أوروغواي الرسمي", "VET": "توقيت فنزويلا", "WARST": "توقيت غرب الأرجنتين الصيفي", "WART": "توقيت غرب الأرجنتين الرسمي", "WAST": "توقيت غرب أفريقيا الصيفي", "WAT": "توقيت غرب أفريقيا الرسمي", "WESZ": "توقيت غرب أوروبا الصيفي", "WEZ": "توقيت غرب أوروبا الرسمي", "WIB": "توقيت غرب إندونيسيا", "WIT": "توقيت شرق إندونيسيا", "WITA": "توقيت وسط إندونيسيا", "∅∅∅": "توقيت برازيليا الصيفي"},

			fnCardinalPluralRule:  fnCardinalPluralRule_f27514af189883ea7cd186156edfe998,
			fnDecimal:             fnDecimal_a78485e7dd32c95f41af4e18420793bf,
			fnFmtAccounting:       fnFmtAccounting_f74088692afba81682b73af3d3e7c19a,
			fnFmtCurrency:         fnFmtCurrency_e28d302f22cf4ed4b5009e290f74e359,
			fnFmtDateFull:         fnFmtDateFull_2d3b405215099e683568cb9c052cbd54,
			fnFmtDateLong:         fnFmtDateLong_506f643cda0514f66d873a9ea99bf639,
			fnFmtDateMedium:       fnFmtDateMedium_a55320da438aec0cfbc31bc4d718abc1,
			fnFmtDateShort:        fnFmtDateShort_05c85041b5f9b6fa224b9c4ba9be3590,
			fnFmtNumber:           fnFmtNumber_eef52ddc8fa71bd12171ac9ef3cd3328,
			fnFmtPercent:          fnFmtPercent_60ca2e9d27b8160a5fec0f6694129759,
			fnFmtTimeFull:         fnFmtTimeFull_37fe4deeee789852cc196a6a1a2f0ccc,
			fnFmtTimeLong:         fnFmtTimeLong_4429ef4fb58a2a9c4d7d5132fd16ecbf,
			fnFmtTimeMedium:       fnFmtTimeMedium_8ef07f6477b7a4944577d4e5392ff21b,
			fnFmtTimeShort:        fnFmtTimeShort_8288b817c5c0216c9815524c71c9e0b4,
			fnGroup:               fnGroup_5c4b80a5ccdee81467241784ab8fcd56,
			fnLocale:              fnLocale_5a217059c67094defae82f249f55f4c5,
			fnMinus:               fnMinus_8b8229905258388dc16a5e0c270b0488,
			fnMonthAbbreviated:    fnMonthAbbreviated_aa9a9957cd9d056ba078b36a08b17478,
			fnMonthNarrow:         fnMonthNarrow_45916040ecf6fc350894d9e3e6c46dc7,
			fnMonthWide:           fnMonthWide_4c946a7e7581c665e7407df1841810b5,
			fnMonthsAbbreviated:   fnMonthsAbbreviated_181f77804b62232997fae36bd57d6cf7,
			fnMonthsNarrow:        fnMonthsNarrow_75daa2ba82ae9577292175c3f52370cc,
			fnMonthsWide:          fnMonthsWide_0ecf36a8b72255e2fee9467af362e989,
			fnOrdinalPluralRule:   fnOrdinalPluralRule_3355865f05dde9af2a36ba415bea85cb,
			fnPluralsCardinal:     fnPluralsCardinal_85b19cac1fab9f2c2cfb9eb41539aa0e,
			fnPluralsOrdinal:      fnPluralsOrdinal_16a60aa09da9778fa82fe463e83076de,
			fnPluralsRange:        fnPluralsRange_332465bda13eb808b3664fa0500f54ce,
			fnRangePluralRule:     fnRangePluralRule_47500e2a682fd3a64da69f06f7b93c0a,
			fnWeekdayAbbreviated:  fnWeekdayAbbreviated_4ffbdfbd2be10e6bd8fb5a542a14664a,
			fnWeekdayNarrow:       fnWeekdayNarrow_e86921b3446df5ea9afe9504cfa20d1a,
			fnWeekdayShort:        fnWeekdayShort_82b231d4f504c6d71c7e495aa35cd3c2,
			fnWeekdayWide:         fnWeekdayWide_ab7e026d8685cefd89c5aeb5df512a9a,
			fnWeekdaysAbbreviated: fnWeekdaysAbbreviated_454a3d7d23c662520a64ae5245d404be,
			fnWeekdaysNarrow:      fnWeekdaysNarrow_d23eb0b7a498c40ce19d1bf231cad524,
			fnWeekdaysShort:       fnWeekdaysShort_eb6ee64d01e314991432b4469790d38b,
			fnWeekdaysWide:        fnWeekdaysWide_5e2bbf75a31e730429c100e8a0bd3ebd,
		}
	}
	translatorFuncs["ar_lb"] = func() locales.Translator {
		return &localen{

			locale:                 "ar_LB",
			pluralsCardinal:        []locales.PluralRule{1, 2, 3, 4, 5, 6},
			pluralsOrdinal:         []locales.PluralRule{6},
			pluralsRange:           []locales.PluralRule{1, 4, 5, 6},
			decimal:                ",",
			group:                  ".",
			minus:                  "؜-",
			percent:                "٪؜",
			perMille:               "؉",
			timeSeparator:          ":",
			inifinity:              "∞",
			currencies:             []string{"ADP", "AED", "AFA", "AFN", "ALK", "ALL", "AMD", "ANG", "AOA", "AOK", "AON", "AOR", "ARA", "ARL", "ARM", "ARP", "ARS", "ATS", "AUD", "AWG", "AZM", "AZN", "BAD", "BAM", "BAN", "BBD", "BDT", "BEC", "BEF", "BEL", "BGL", "BGM", "BGN", "BGO", "BHD", "BIF", "BMD", "BND", "BOB", "BOL", "BOP", "BOV", "BRB", "BRC", "BRE", "BRL", "BRN", "BRR", "BRZ", "BSD", "BTN", "BUK", "BWP", "BYB", "BYN", "BYR", "BZD", "CAD", "CDF", "CHE", "CHF", "CHW", "CLE", "CLF", "CLP", "CNH", "CNX", "CNY", "COP", "COU", "CRC", "CSD", "CSK", "CUC", "CUP", "CVE", "CYP", "CZK", "DDM", "DEM", "DJF", "DKK", "DOP", "DZD", "ECS", "ECV", "EEK", "EGP", "ERN", "ESA", "ESB", "ESP", "ETB", "EUR", "FIM", "FJD", "FKP", "FRF", "GBP", "GEK", "GEL", "GHC", "GHS", "GIP", "GMD", "GNF", "GNS", "GQE", "GRD", "GTQ", "GWE", "GWP", "GYD", "HKD", "HNL", "HRD", "HRK", "HTG", "HUF", "IDR", "IEP", "ILP", "ILR", "ILS", "INR", "IQD", "IRR", "ISJ", "ISK", "ITL", "JMD", "JOD", "JPY", "KES", "KGS", "KHR", "KMF", "KPW", "KRH", "KRO", "KRW", "KWD", "KYD", "KZT", "LAK", "LBP", "LKR", "LRD", "LSL", "LTL", "LTT", "LUC", "LUF", "LUL", "LVL", "LVR", "LYD", "MAD", "MAF", "MCF", "MDC", "MDL", "MGA", "MGF", "MKD", "MKN", "MLF", "MMK", "MNT", "MOP", "MRO", "MRU", "MTL", "MTP", "MUR", "MVP", "MVR", "MWK", "MXN", "MXP", "MXV", "MYR", "MZE", "MZM", "MZN", "NAD", "NGN", "NIC", "NIO", "NLG", "NOK", "NPR", "NZD", "OMR", "PAB", "PEI", "PEN", "PES", "PGK", "PHP", "PKR", "PLN", "PLZ", "PTE", "PYG", "QAR", "RHD", "ROL", "RON", "RSD", "RUB", "RUR", "RWF", "SAR", "SBD", "SCR", "SDD", "SDG", "SDP", "SEK", "SGD", "SHP", "SIT", "SKK", "SLL", "SOS", "SRD", "SRG", "SSP", "STD", "STN", "SUR", "SVC", "SYP", "SZL", "THB", "TJR", "TJS", "TMM", "TMT", "TND", "TOP", "TPE", "TRL", "TRY", "TTD", "TWD", "TZS", "UAH", "UAK", "UGS", "UGX", "USD", "USN", "USS", "UYI", "UYP", "UYU", "UYW", "UZS", "VEB", "VEF", "VES", "VND", "VNN", "VUV", "WST", "XAF", "XAG", "XAU", "XBA", "XBB", "XBC", "XBD", "XCD", "XDR", "XEU", "XFO", "XFU", "XOF", "XPD", "XPF", "XPT", "XRE", "XSU", "XTS", "XUA", "XXX", "YDD", "YER", "YUD", "YUM", "YUN", "YUR", "ZAL", "ZAR", "ZMK", "ZMW", "ZRN", "ZRZ", "ZWD", "ZWL", "ZWR"},
			currencyPositiveSuffix: " ",
			currencyNegativeSuffix: " ",
			monthsAbbreviated:      []string{"", "كانون الثاني", "شباط", "آذار", "نيسان", "أيار", "حزيران", "تموز", "آب", "أيلول", "تشرين الأول", "تشرين الثاني", "كانون الأول"},
			monthsNarrow:           []string{"", "ك", "ش", "آ", "ن", "أ", "ح", "ت", "آ", "أ", "ت", "ت", "ك"},
			monthsWide:             []string{"", "كانون الثاني", "شباط", "آذار", "نيسان", "أيار", "حزيران", "تموز", "آب", "أيلول", "تشرين الأول", "تشرين الثاني", "كانون الأول"},
			daysAbbreviated:        []string{"الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"},
			daysNarrow:             []string{"ح", "ن", "ث", "ر", "خ", "ج", "س"},
			daysShort:              []string{"أحد", "إثنين", "ثلاثاء", "أربعاء", "خميس", "جمعة", "سبت"},
			daysWide:               []string{"الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"},
			periodsAbbreviated:     []string{"ص", "م"},
			periodsNarrow:          []string{"ص", "م"},
			periodsWide:            []string{"ص", "م"},
			erasAbbreviated:        []string{"ق.م", "م"},
			erasNarrow:             []string{"", ""},
			erasWide:               []string{"قبل الميلاد", "ميلادي"},
			timezones:              map[string]string{"ACDT": "توقيت وسط أستراليا الصيفي", "ACST": "توقيت وسط أستراليا الرسمي", "ACWDT": "توقيت غرب وسط أستراليا الصيفي", "ACWST": "توقيت غرب وسط أستراليا الرسمي", "ADT": "التوقيت الصيفي الأطلسي", "AEDT": "توقيت شرق أستراليا الصيفي", "AEST": "توقيت شرق أستراليا الرسمي", "AKDT": "توقيت ألاسكا الصيفي", "AKST": "التوقيت الرسمي لألاسكا", "ARST": "توقيت الأرجنتين الصيفي", "ART": "توقيت الأرجنتين الرسمي", "AST": "التوقيت الرسمي الأطلسي", "AWDT": "توقيت غرب أستراليا الصيفي", "AWST": "توقيت غرب أستراليا الرسمي", "BOT": "توقيت بوليفيا", "BT": "توقيت بوتان", "CAT": "توقيت وسط أفريقيا", "CDT": "التوقيت الصيفي المركزي لأمريكا الشمالية", "CHADT": "توقيت تشاتام الصيفي", "CHAST": "توقيت تشاتام الرسمي", "CLST": "توقيت تشيلي الصيفي", "CLT": "توقيت تشيلي الرسمي", "COST": "توقيت كولومبيا الصيفي", "COT": "توقيت كولومبيا الرسمي", "CST": "التوقيت الرسمي المركزي لأمريكا الشمالية", "ChST": "توقيت تشامورو", "EAT": "توقيت شرق أفريقيا", "ECT": "توقيت الإكوادور", "EDT": "التوقيت الصيفي الشرقي لأمريكا الشمالية", "EST": "التوقيت الرسمي الشرقي لأمريكا الشمالية", "GFT": "توقيت غويانا الفرنسية", "GMT": "توقيت غرينتش", "GST": "توقيت الخليج", "GYT": "توقيت غيانا", "HADT": "توقيت هاواي ألوتيان الصيفي", "HAST": "توقيت هاواي ألوتيان الرسمي", "HAT": "توقيت نيوفاوندلاند الصيفي", "HECU": "توقيت كوبا الصيفي", "HEEG": "توقيت شرق غرينلاند الصيفي", "HENOMX": "التوقيت الصيفي لشمال غرب المكسيك", "HEOG": "توقيت غرب غرينلاند الصيفي", "HEPM": "توقيت سانت بيير وميكولون الصيفي", "HEPMX": "توقيت المحيط الهادي الصيفي للمكسيك", "HKST": "توقيت هونغ كونغ الصيفي", "HKT": "توقيت هونغ كونغ الرسمي", "HNCU": "توقيت كوبا الرسمي", "HNEG": "توقيت شرق غرينلاند الرسمي", "HNNOMX": "التوقيت الرسمي لشمال غرب المكسيك", "HNOG": "توقيت غرب غرينلاند الرسمي", "HNPM": "توقيت سانت بيير وميكولون الرسمي", "HNPMX": "توقيت المحيط الهادي الرسمي للمكسيك", "HNT": "توقيت نيوفاوندلاند الرسمي", "IST": "توقيت الهند", "JDT": "توقيت اليابان الصيفي", "JST": "توقيت اليابان الرسمي", "LHDT": "التوقيت الصيفي للورد هاو", "LHST": "توقيت لورد هاو الرسمي", "MDT": "التوقيت الجبلي الصيفي لأمريكا الشمالية", "MESZ": "توقيت وسط أوروبا الصيفي", "MEZ": "توقيت وسط أوروبا الرسمي", "MST": "التوقيت الجبلي الرسمي لأمريكا الشمالية", "MYT": "توقيت ماليزيا", "NZDT": "توقيت نيوزيلندا الصيفي", "NZST": "توقيت نيوزيلندا الرسمي", "OESZ": "توقيت شرق أوروبا الصيفي", "OEZ": "توقيت شرق أوروبا الرسمي", "PDT": "توقيت المحيط الهادي الصيفي", "PST": "توقيت المحيط الهادي الرسمي", "SAST": "توقيت جنوب أفريقيا", "SGT": "توقيت سنغافورة", "SRT": "توقيت سورينام", "TMST": "توقيت تركمانستان الصيفي", "TMT": "توقيت تركمانستان الرسمي", "UYST": "توقيت أوروغواي الصيفي", "UYT": "توقيت أوروغواي الرسمي", "VET": "توقيت فنزويلا", "WARST": "توقيت غرب الأرجنتين الصيفي", "WART": "توقيت غرب الأرجنتين الرسمي", "WAST": "توقيت غرب أفريقيا الصيفي", "WAT": "توقيت غرب أفريقيا الرسمي", "WESZ": "توقيت غرب أوروبا الصيفي", "WEZ": "توقيت غرب أوروبا الرسمي", "WIB": "توقيت غرب إندونيسيا", "WIT": "توقيت شرق إندونيسيا", "WITA": "توقيت وسط إندونيسيا", "∅∅∅": "توقيت برازيليا الصيفي"},

			fnCardinalPluralRule:  fnCardinalPluralRule_f27514af189883ea7cd186156edfe998,
			fnDecimal:             fnDecimal_a78485e7dd32c95f41af4e18420793bf,
			fnFmtAccounting:       fnFmtAccounting_d5455f8fcf723c4be2a5a03fd41298f2,
			fnFmtCurrency:         fnFmtCurrency_2c2268a7a667170346d6d4c829feb8a4,
			fnFmtDateFull:         fnFmtDateFull_2d3b405215099e683568cb9c052cbd54,
			fnFmtDateLong:         fnFmtDateLong_506f643cda0514f66d873a9ea99bf639,
			fnFmtDateMedium:       fnFmtDateMedium_a55320da438aec0cfbc31bc4d718abc1,
			fnFmtDateShort:        fnFmtDateShort_05c85041b5f9b6fa224b9c4ba9be3590,
			fnFmtNumber:           fnFmtNumber_f253fbd23af5a54db29f42f905c9e33a,
			fnFmtPercent:          fnFmtPercent_fb7ade3a9509df0c54be19484c433a01,
			fnFmtTimeFull:         fnFmtTimeFull_37fe4deeee789852cc196a6a1a2f0ccc,
			fnFmtTimeLong:         fnFmtTimeLong_4429ef4fb58a2a9c4d7d5132fd16ecbf,
			fnFmtTimeMedium:       fnFmtTimeMedium_8ef07f6477b7a4944577d4e5392ff21b,
			fnFmtTimeShort:        fnFmtTimeShort_8288b817c5c0216c9815524c71c9e0b4,
			fnGroup:               fnGroup_5c4b80a5ccdee81467241784ab8fcd56,
			fnLocale:              fnLocale_5a217059c67094defae82f249f55f4c5,
			fnMinus:               fnMinus_8b8229905258388dc16a5e0c270b0488,
			fnMonthAbbreviated:    fnMonthAbbreviated_aa9a9957cd9d056ba078b36a08b17478,
			fnMonthNarrow:         fnMonthNarrow_45916040ecf6fc350894d9e3e6c46dc7,
			fnMonthWide:           fnMonthWide_4c946a7e7581c665e7407df1841810b5,
			fnMonthsAbbreviated:   fnMonthsAbbreviated_181f77804b62232997fae36bd57d6cf7,
			fnMonthsNarrow:        fnMonthsNarrow_75daa2ba82ae9577292175c3f52370cc,
			fnMonthsWide:          fnMonthsWide_0ecf36a8b72255e2fee9467af362e989,
			fnOrdinalPluralRule:   fnOrdinalPluralRule_3355865f05dde9af2a36ba415bea85cb,
			fnPluralsCardinal:     fnPluralsCardinal_85b19cac1fab9f2c2cfb9eb41539aa0e,
			fnPluralsOrdinal:      fnPluralsOrdinal_16a60aa09da9778fa82fe463e83076de,
			fnPluralsRange:        fnPluralsRange_332465bda13eb808b3664fa0500f54ce,
			fnRangePluralRule:     fnRangePluralRule_47500e2a682fd3a64da69f06f7b93c0a,
			fnWeekdayAbbreviated:  fnWeekdayAbbreviated_4ffbdfbd2be10e6bd8fb5a542a14664a,
			fnWeekdayNarrow:       fnWeekdayNarrow_e86921b3446df5ea9afe9504cfa20d1a,
			fnWeekdayShort:        fnWeekdayShort_82b231d4f504c6d71c7e495aa35cd3c2,
			fnWeekdayWide:         fnWeekdayWide_ab7e026d8685cefd89c5aeb5df512a9a,
			fnWeekdaysAbbreviated: fnWeekdaysAbbreviated_454a3d7d23c662520a64ae5245d404be,
			fnWeekdaysNarrow:      fnWeekdaysNarrow_d23eb0b7a498c40ce19d1bf231cad524,
			fnWeekdaysShort:       fnWeekdaysShort_eb6ee64d01e314991432b4469790d38b,
			fnWeekdaysWide:        fnWeekdaysWide_5e2bbf75a31e730429c100e8a0bd3ebd,
		}
	}
	translatorFuncs["ar_ly"] = func() locales.Translator {
		return &localen{

			locale:                 "ar_LY",
			pluralsCardinal:        []locales.PluralRule{1, 2, 3, 4, 5, 6},
			pluralsOrdinal:         []locales.PluralRule{6},
			pluralsRange:           []locales.PluralRule{1, 4, 5, 6},
			decimal:                ",",
			group:                  ".",
			minus:                  "؜-",
			percent:                "٪؜",
			perMille:               "؉",
			timeSeparator:          ":",
			inifinity:              "∞",
			currencies:             []string{"ADP", "AED", "AFA", "AFN", "ALK", "ALL", "AMD", "ANG", "AOA", "AOK", "AON", "AOR", "ARA", "ARL", "ARM", "ARP", "ARS", "ATS", "AUD", "AWG", "AZM", "AZN", "BAD", "BAM", "BAN", "BBD", "BDT", "BEC", "BEF", "BEL", "BGL", "BGM", "BGN", "BGO", "BHD", "BIF", "BMD", "BND", "BOB", "BOL", "BOP", "BOV", "BRB", "BRC", "BRE", "BRL", "BRN", "BRR", "BRZ", "BSD", "BTN", "BUK", "BWP", "BYB", "BYN", "BYR", "BZD", "CAD", "CDF", "CHE", "CHF", "CHW", "CLE", "CLF", "CLP", "CNH", "CNX", "CNY", "COP", "COU", "CRC", "CSD", "CSK", "CUC", "CUP", "CVE", "CYP", "CZK", "DDM", "DEM", "DJF", "DKK", "DOP", "DZD", "ECS", "ECV", "EEK", "EGP", "ERN", "ESA", "ESB", "ESP", "ETB", "EUR", "FIM", "FJD", "FKP", "FRF", "GBP", "GEK", "GEL", "GHC", "GHS", "GIP", "GMD", "GNF", "GNS", "GQE", "GRD", "GTQ", "GWE", "GWP", "GYD", "HKD", "HNL", "HRD", "HRK", "HTG", "HUF", "IDR", "IEP", "ILP", "ILR", "ILS", "INR", "IQD", "IRR", "ISJ", "ISK", "ITL", "JMD", "JOD", "JPY", "KES", "KGS", "KHR", "KMF", "KPW", "KRH", "KRO", "KRW", "KWD", "KYD", "KZT", "LAK", "LBP", "LKR", "LRD", "LSL", "LTL", "LTT", "LUC", "LUF", "LUL", "LVL", "LVR", "LYD", "MAD", "MAF", "MCF", "MDC", "MDL", "MGA", "MGF", "MKD", "MKN", "MLF", "MMK", "MNT", "MOP", "MRO", "MRU", "MTL", "MTP", "MUR", "MVP", "MVR", "MWK", "MXN", "MXP", "MXV", "MYR", "MZE", "MZM", "MZN", "NAD", "NGN", "NIC", "NIO", "NLG", "NOK", "NPR", "NZD", "OMR", "PAB", "PEI", "PEN", "PES", "PGK", "PHP", "PKR", "PLN", "PLZ", "PTE", "PYG", "QAR", "RHD", "ROL", "RON", "RSD", "RUB", "RUR", "RWF", "SAR", "SBD", "SCR", "SDD", "SDG", "SDP", "SEK", "SGD", "SHP", "SIT", "SKK", "SLL", "SOS", "SRD", "SRG", "SSP", "STD", "STN", "SUR", "SVC", "SYP", "SZL", "THB", "TJR", "TJS", "TMM", "TMT", "TND", "TOP", "TPE", "TRL", "TRY", "TTD", "TWD", "TZS", "UAH", "UAK", "UGS", "UGX", "USD", "USN", "USS", "UYI", "UYP", "UYU", "UYW", "UZS", "VEB", "VEF", "VES", "VND", "VNN", "VUV", "WST", "XAF", "XAG", "XAU", "XBA", "XBB", "XBC", "XBD", "XCD", "XDR", "XEU", "XFO", "XFU", "XOF", "XPD", "XPF", "XPT", "XRE", "XSU", "XTS", "XUA", "XXX", "YDD", "YER", "YUD", "YUM", "YUN", "YUR", "ZAL", "ZAR", "ZMK", "ZMW", "ZRN", "ZRZ", "ZWD", "ZWL", "ZWR"},
			currencyPositiveSuffix: " ",
			currencyNegativeSuffix: " ",
			monthsAbbreviated:      []string{"", "يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"},
			monthsNarrow:           []string{"", "ي", "ف", "م", "أ", "و", "ن", "ل", "غ", "س", "ك", "ب", "د"},
			monthsWide:             []string{"", "يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"},
			daysAbbreviated:        []string{"الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"},
			daysNarrow:             []string{"ح", "ن", "ث", "ر", "خ", "ج", "س"},
			daysShort:              []string{"أحد", "إثنين", "ثلاثاء", "أربعاء", "خميس", "جمعة", "سبت"},
			daysWide:               []string{"الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"},
			periodsAbbreviated:     []string{"", ""},
			periodsNarrow:          []string{"ص", "م"},
			periodsWide:            []string{"ص", "م"},
			erasAbbreviated:        []string{"ق.م", "م"},
			erasNarrow:             []string{"", ""},
			erasWide:               []string{"قبل الميلاد", "ميلادي"},
			timezones:              map[string]string{"ACDT": "توقيت وسط أستراليا الصيفي", "ACST": "توقيت وسط أستراليا الرسمي", "ACWDT": "توقيت غرب وسط أستراليا الصيفي", "ACWST": "توقيت غرب وسط أستراليا الرسمي", "ADT": "التوقيت الصيفي الأطلسي", "AEDT": "توقيت شرق أستراليا الصيفي", "AEST": "توقيت شرق أستراليا الرسمي", "AKDT": "توقيت ألاسكا الصيفي", "AKST": "التوقيت الرسمي لألاسكا", "ARST": "توقيت الأرجنتين الصيفي", "ART": "توقيت الأرجنتين الرسمي", "AST": "التوقيت الرسمي الأطلسي", "AWDT": "توقيت غرب أستراليا الصيفي", "AWST": "توقيت غرب أستراليا الرسمي", "BOT": "توقيت بوليفيا", "BT": "توقيت بوتان", "CAT": "توقيت وسط أفريقيا", "CDT": "التوقيت الصيفي المركزي لأمريكا الشمالية", "CHADT": "توقيت تشاتام الصيفي", "CHAST": "توقيت تشاتام الرسمي", "CLST": "توقيت تشيلي الصيفي", "CLT": "توقيت تشيلي الرسمي", "COST": "توقيت كولومبيا الصيفي", "COT": "توقيت كولومبيا الرسمي", "CST": "التوقيت الرسمي المركزي لأمريكا الشمالية", "ChST": "توقيت تشامورو", "EAT": "توقيت شرق أفريقيا", "ECT": "توقيت الإكوادور", "EDT": "التوقيت الصيفي الشرقي لأمريكا الشمالية", "EST": "التوقيت الرسمي الشرقي لأمريكا الشمالية", "GFT": "توقيت غويانا الفرنسية", "GMT": "توقيت غرينتش", "GST": "توقيت الخليج", "GYT": "توقيت غيانا", "HADT": "توقيت هاواي ألوتيان الصيفي", "HAST": "توقيت هاواي ألوتيان الرسمي", "HAT": "توقيت نيوفاوندلاند الصيفي", "HECU": "توقيت كوبا الصيفي", "HEEG": "توقيت شرق غرينلاند الصيفي", "HENOMX": "التوقيت الصيفي لشمال غرب المكسيك", "HEOG": "توقيت غرب غرينلاند الصيفي", "HEPM": "توقيت سانت بيير وميكولون الصيفي", "HEPMX": "توقيت المحيط الهادي الصيفي للمكسيك", "HKST": "توقيت هونغ كونغ الصيفي", "HKT": "توقيت هونغ كونغ الرسمي", "HNCU": "توقيت كوبا الرسمي", "HNEG": "توقيت شرق غرينلاند الرسمي", "HNNOMX": "التوقيت الرسمي لشمال غرب المكسيك", "HNOG": "توقيت غرب غرينلاند الرسمي", "HNPM": "توقيت سانت بيير وميكولون الرسمي", "HNPMX": "توقيت المحيط الهادي الرسمي للمكسيك", "HNT": "توقيت نيوفاوندلاند الرسمي", "IST": "توقيت الهند", "JDT": "توقيت اليابان الصيفي", "JST": "توقيت اليابان الرسمي", "LHDT": "التوقيت الصيفي للورد هاو", "LHST": "توقيت لورد هاو الرسمي", "MDT": "التوقيت الجبلي الصيفي لأمريكا الشمالية", "MESZ": "توقيت وسط أوروبا الصيفي", "MEZ": "توقيت وسط أوروبا الرسمي", "MST": "التوقيت الجبلي الرسمي لأمريكا الشمالية", "MYT": "توقيت ماليزيا", "NZDT": "توقيت نيوزيلندا الصيفي", "NZST": "توقيت نيوزيلندا الرسمي", "OESZ": "توقيت شرق أوروبا الصيفي", "OEZ": "توقيت شرق أوروبا الرسمي", "PDT": "توقيت المحيط الهادي الصيفي", "PST": "توقيت المحيط الهادي الرسمي", "SAST": "توقيت جنوب أفريقيا", "SGT": "توقيت سنغافورة", "SRT": "توقيت سورينام", "TMST": "توقيت تركمانستان الصيفي", "TMT": "توقيت تركمانستان الرسمي", "UYST": "توقيت أوروغواي الصيفي", "UYT": "توقيت أوروغواي الرسمي", "VET": "توقيت فنزويلا", "WARST": "توقيت غرب الأرجنتين الصيفي", "WART": "توقيت غرب الأرجنتين الرسمي", "WAST": "توقيت غرب أفريقيا الصيفي", "WAT": "توقيت غرب أفريقيا الرسمي", "WESZ": "توقيت غرب أوروبا الصيفي", "WEZ": "توقيت غرب أوروبا الرسمي", "WIB": "توقيت غرب إندونيسيا", "WIT": "توقيت شرق إندونيسيا", "WITA": "توقيت وسط إندونيسيا", "∅∅∅": "توقيت برازيليا الصيفي"},

			fnCardinalPluralRule:  fnCardinalPluralRule_f27514af189883ea7cd186156edfe998,
			fnDecimal:             fnDecimal_a78485e7dd32c95f41af4e18420793bf,
			fnFmtAccounting:       fnFmtAccounting_d5455f8fcf723c4be2a5a03fd41298f2,
			fnFmtCurrency:         fnFmtCurrency_2c2268a7a667170346d6d4c829feb8a4,
			fnFmtDateFull:         fnFmtDateFull_2d3b405215099e683568cb9c052cbd54,
			fnFmtDateLong:         fnFmtDateLong_506f643cda0514f66d873a9ea99bf639,
			fnFmtDateMedium:       fnFmtDateMedium_a55320da438aec0cfbc31bc4d718abc1,
			fnFmtDateShort:        fnFmtDateShort_05c85041b5f9b6fa224b9c4ba9be3590,
			fnFmtNumber:           fnFmtNumber_f253fbd23af5a54db29f42f905c9e33a,
			fnFmtPercent:          fnFmtPercent_fb7ade3a9509df0c54be19484c433a01,
			fnFmtTimeFull:         fnFmtTimeFull_37fe4deeee789852cc196a6a1a2f0ccc,
			fnFmtTimeLong:         fnFmtTimeLong_4429ef4fb58a2a9c4d7d5132fd16ecbf,
			fnFmtTimeMedium:       fnFmtTimeMedium_8ef07f6477b7a4944577d4e5392ff21b,
			fnFmtTimeShort:        fnFmtTimeShort_8288b817c5c0216c9815524c71c9e0b4,
			fnGroup:               fnGroup_5c4b80a5ccdee81467241784ab8fcd56,
			fnLocale:              fnLocale_5a217059c67094defae82f249f55f4c5,
			fnMinus:               fnMinus_8b8229905258388dc16a5e0c270b0488,
			fnMonthAbbreviated:    fnMonthAbbreviated_aa9a9957cd9d056ba078b36a08b17478,
			fnMonthNarrow:         fnMonthNarrow_45916040ecf6fc350894d9e3e6c46dc7,
			fnMonthWide:           fnMonthWide_4c946a7e7581c665e7407df1841810b5,
			fnMonthsAbbreviated:   fnMonthsAbbreviated_181f77804b62232997fae36bd57d6cf7,
			fnMonthsNarrow:        fnMonthsNarrow_75daa2ba82ae9577292175c3f52370cc,
			fnMonthsWide:          fnMonthsWide_0ecf36a8b72255e2fee9467af362e989,
			fnOrdinalPluralRule:   fnOrdinalPluralRule_3355865f05dde9af2a36ba415bea85cb,
			fnPluralsCardinal:     fnPluralsCardinal_85b19cac1fab9f2c2cfb9eb41539aa0e,
			fnPluralsOrdinal:      fnPluralsOrdinal_16a60aa09da9778fa82fe463e83076de,
			fnPluralsRange:        fnPluralsRange_332465bda13eb808b3664fa0500f54ce,
			fnRangePluralRule:     fnRangePluralRule_47500e2a682fd3a64da69f06f7b93c0a,
			fnWeekdayAbbreviated:  fnWeekdayAbbreviated_4ffbdfbd2be10e6bd8fb5a542a14664a,
			fnWeekdayNarrow:       fnWeekdayNarrow_e86921b3446df5ea9afe9504cfa20d1a,
			fnWeekdayShort:        fnWeekdayShort_82b231d4f504c6d71c7e495aa35cd3c2,
			fnWeekdayWide:         fnWeekdayWide_ab7e026d8685cefd89c5aeb5df512a9a,
			fnWeekdaysAbbreviated: fnWeekdaysAbbreviated_454a3d7d23c662520a64ae5245d404be,
			fnWeekdaysNarrow:      fnWeekdaysNarrow_d23eb0b7a498c40ce19d1bf231cad524,
			fnWeekdaysShort:       fnWeekdaysShort_eb6ee64d01e314991432b4469790d38b,
			fnWeekdaysWide:        fnWeekdaysWide_5e2bbf75a31e730429c100e8a0bd3ebd,
		}
	}
	translatorFuncs["ar_ma"] = func() locales.Translator {
		return &localen{

			locale:                 "ar_MA",
			pluralsCardinal:        []locales.PluralRule{1, 2, 3, 4, 5, 6},
			pluralsOrdinal:         []locales.PluralRule{6},
			pluralsRange:           []locales.PluralRule{1, 4, 5, 6},
			decimal:                ",",
			group:                  ".",
			minus:                  "؜-",
			percent:                "٪؜",
			perMille:               "؉",
			timeSeparator:          ":",
			inifinity:              "∞",
			currencies:             []string{"ADP", "AED", "AFA", "AFN", "ALK", "ALL", "AMD", "ANG", "AOA", "AOK", "AON", "AOR", "ARA", "ARL", "ARM", "ARP", "ARS", "ATS", "AUD", "AWG", "AZM", "AZN", "BAD", "BAM", "BAN", "BBD", "BDT", "BEC", "BEF", "BEL", "BGL", "BGM", "BGN", "BGO", "BHD", "BIF", "BMD", "BND", "BOB", "BOL", "BOP", "BOV", "BRB", "BRC", "BRE", "BRL", "BRN", "BRR", "BRZ", "BSD", "BTN", "BUK", "BWP", "BYB", "BYN", "BYR", "BZD", "CAD", "CDF", "CHE", "CHF", "CHW", "CLE", "CLF", "CLP", "CNH", "CNX", "CNY", "COP", "COU", "CRC", "CSD", "CSK", "CUC", "CUP", "CVE", "CYP", "CZK", "DDM", "DEM", "DJF", "DKK", "DOP", "DZD", "ECS", "ECV", "EEK", "EGP", "ERN", "ESA", "ESB", "ESP", "ETB", "EUR", "FIM", "FJD", "FKP", "FRF", "GBP", "GEK", "GEL", "GHC", "GHS", "GIP", "GMD", "GNF", "GNS", "GQE", "GRD", "GTQ", "GWE", "GWP", "GYD", "HKD", "HNL", "HRD", "HRK", "HTG", "HUF", "IDR", "IEP", "ILP", "ILR", "ILS", "INR", "IQD", "IRR", "ISJ", "ISK", "ITL", "JMD", "JOD", "JPY", "KES", "KGS", "KHR", "KMF", "KPW", "KRH", "KRO", "KRW", "KWD", "KYD", "KZT", "LAK", "LBP", "LKR", "LRD", "LSL", "LTL", "LTT", "LUC", "LUF", "LUL", "LVL", "LVR", "LYD", "MAD", "MAF", "MCF", "MDC", "MDL", "MGA", "MGF", "MKD", "MKN", "MLF", "MMK", "MNT", "MOP", "MRO", "MRU", "MTL", "MTP", "MUR", "MVP", "MVR", "MWK", "MXN", "MXP", "MXV", "MYR", "MZE", "MZM", "MZN", "NAD", "NGN", "NIC", "NIO", "NLG", "NOK", "NPR", "NZD", "OMR", "PAB", "PEI", "PEN", "PES", "PGK", "PHP", "PKR", "PLN", "PLZ", "PTE", "PYG", "QAR", "RHD", "ROL", "RON", "RSD", "RUB", "RUR", "RWF", "SAR", "SBD", "SCR", "SDD", "SDG", "SDP", "SEK", "SGD", "SHP", "SIT", "SKK", "SLL", "SOS", "SRD", "SRG", "SSP", "STD", "STN", "SUR", "SVC", "SYP", "SZL", "THB", "TJR", "TJS", "TMM", "TMT", "TND", "TOP", "TPE", "TRL", "TRY", "TTD", "TWD", "TZS", "UAH", "UAK", "UGS", "UGX", "USD", "USN", "USS", "UYI", "UYP", "UYU", "UYW", "UZS", "VEB", "VEF", "VES", "VND", "VNN", "VUV", "WST", "XAF", "XAG", "XAU", "XBA", "XBB", "XBC", "XBD", "XCD", "XDR", "XEU", "XFO", "XFU", "XOF", "XPD", "XPF", "XPT", "XRE", "XSU", "XTS", "XUA", "XXX", "YDD", "YER", "YUD", "YUM", "YUN", "YUR", "ZAL", "ZAR", "ZMK", "ZMW", "ZRN", "ZRZ", "ZWD", "ZWL", "ZWR"},
			currencyPositiveSuffix: " ",
			currencyNegativeSuffix: " ",
			monthsAbbreviated:      []string{"", "أبريل", "ماي", "يوليوز", "غشت", "شتنبر", "نونبر", "دجنبر"},
			monthsNarrow:           []string{"", "أ", "م", "ن", "ل", "ش", "ك", "ب", "د"},
			monthsWide:             []string{"", "أبريل", "ماي", "يوليوز", "غشت", "شتنبر", "نونبر", "دجنبر"},
			daysAbbreviated:        []string{"الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"},
			daysNarrow:             []string{"ح", "ن", "ث", "ر", "خ", "ج", "س"},
			daysShort:              []string{"أحد", "إثنين", "ثلاثاء", "أربعاء", "خميس", "جمعة", "سبت"},
			daysWide:               []string{"الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"},
			periodsAbbreviated:     []string{"ص", "م"},
			periodsNarrow:          []string{"ص", "م"},
			periodsWide:            []string{"ص", "م"},
			erasAbbreviated:        []string{"ق.م", "م"},
			erasNarrow:             []string{"", ""},
			erasWide:               []string{"قبل الميلاد", "ميلادي"},
			timezones:              map[string]string{"ACDT": "توقيت وسط أستراليا الصيفي", "ACST": "توقيت وسط أستراليا الرسمي", "ACWDT": "توقيت غرب وسط أستراليا الصيفي", "ACWST": "توقيت غرب وسط أستراليا الرسمي", "ADT": "التوقيت الصيفي الأطلسي", "AEDT": "توقيت شرق أستراليا الصيفي", "AEST": "توقيت شرق أستراليا الرسمي", "AKDT": "توقيت ألاسكا الصيفي", "AKST": "التوقيت الرسمي لألاسكا", "ARST": "توقيت الأرجنتين الصيفي", "ART": "توقيت الأرجنتين الرسمي", "AST": "التوقيت الرسمي الأطلسي", "AWDT": "توقيت غرب أستراليا الصيفي", "AWST": "توقيت غرب أستراليا الرسمي", "BOT": "توقيت بوليفيا", "BT": "توقيت بوتان", "CAT": "توقيت وسط أفريقيا", "CDT": "التوقيت الصيفي المركزي لأمريكا الشمالية", "CHADT": "توقيت تشاتام الصيفي", "CHAST": "توقيت تشاتام الرسمي", "CLST": "توقيت تشيلي الصيفي", "CLT": "توقيت تشيلي الرسمي", "COST": "توقيت كولومبيا الصيفي", "COT": "توقيت كولومبيا الرسمي", "CST": "التوقيت الرسمي المركزي لأمريكا الشمالية", "ChST": "توقيت تشامورو", "EAT": "توقيت شرق أفريقيا", "ECT": "توقيت الإكوادور", "EDT": "التوقيت الصيفي الشرقي لأمريكا الشمالية", "EST": "التوقيت الرسمي الشرقي لأمريكا الشمالية", "GFT": "توقيت غويانا الفرنسية", "GMT": "توقيت غرينتش", "GST": "توقيت الخليج", "GYT": "توقيت غيانا", "HADT": "توقيت هاواي ألوتيان الصيفي", "HAST": "توقيت هاواي ألوتيان الرسمي", "HAT": "توقيت نيوفاوندلاند الصيفي", "HECU": "توقيت كوبا الصيفي", "HEEG": "توقيت شرق غرينلاند الصيفي", "HENOMX": "التوقيت الصيفي لشمال غرب المكسيك", "HEOG": "توقيت غرب غرينلاند الصيفي", "HEPM": "توقيت سانت بيير وميكولون الصيفي", "HEPMX": "توقيت المحيط الهادي الصيفي للمكسيك", "HKST": "توقيت هونغ كونغ الصيفي", "HKT": "توقيت هونغ كونغ الرسمي", "HNCU": "توقيت كوبا الرسمي", "HNEG": "توقيت شرق غرينلاند الرسمي", "HNNOMX": "التوقيت الرسمي لشمال غرب المكسيك", "HNOG": "توقيت غرب غرينلاند الرسمي", "HNPM": "توقيت سانت بيير وميكولون الرسمي", "HNPMX": "توقيت المحيط الهادي الرسمي للمكسيك", "HNT": "توقيت نيوفاوندلاند الرسمي", "IST": "توقيت الهند", "JDT": "توقيت اليابان الصيفي", "JST": "توقيت اليابان الرسمي", "LHDT": "التوقيت الصيفي للورد هاو", "LHST": "توقيت لورد هاو الرسمي", "MDT": "التوقيت الجبلي الصيفي لأمريكا الشمالية", "MESZ": "توقيت وسط أوروبا الصيفي", "MEZ": "توقيت وسط أوروبا الرسمي", "MST": "التوقيت الجبلي الرسمي لأمريكا الشمالية", "MYT": "توقيت ماليزيا", "NZDT": "توقيت نيوزيلندا الصيفي", "NZST": "توقيت نيوزيلندا الرسمي", "OESZ": "توقيت شرق أوروبا الصيفي", "OEZ": "توقيت شرق أوروبا الرسمي", "PDT": "توقيت المحيط الهادي الصيفي", "PST": "توقيت المحيط الهادي الرسمي", "SAST": "توقيت جنوب أفريقيا", "SGT": "توقيت سنغافورة", "SRT": "توقيت سورينام", "TMST": "توقيت تركمانستان الصيفي", "TMT": "توقيت تركمانستان الرسمي", "UYST": "توقيت أوروغواي الصيفي", "UYT": "توقيت أوروغواي الرسمي", "VET": "توقيت فنزويلا", "WARST": "توقيت غرب الأرجنتين الصيفي", "WART": "توقيت غرب الأرجنتين الرسمي", "WAST": "توقيت غرب أفريقيا الصيفي", "WAT": "توقيت غرب أفريقيا الرسمي", "WESZ": "توقيت غرب أوروبا الصيفي", "WEZ": "توقيت غرب أوروبا الرسمي", "WIB": "توقيت غرب إندونيسيا", "WIT": "توقيت شرق إندونيسيا", "WITA": "توقيت وسط إندونيسيا", "∅∅∅": "توقيت بيرو الصيفي"},

			fnCardinalPluralRule:  fnCardinalPluralRule_f27514af189883ea7cd186156edfe998,
			fnDecimal:             fnDecimal_a78485e7dd32c95f41af4e18420793bf,
			fnFmtAccounting:       fnFmtAccounting_d5455f8fcf723c4be2a5a03fd41298f2,
			fnFmtCurrency:         fnFmtCurrency_2c2268a7a667170346d6d4c829feb8a4,
			fnFmtDateFull:         fnFmtDateFull_2d3b405215099e683568cb9c052cbd54,
			fnFmtDateLong:         fnFmtDateLong_506f643cda0514f66d873a9ea99bf639,
			fnFmtDateMedium:       fnFmtDateMedium_a55320da438aec0cfbc31bc4d718abc1,
			fnFmtDateShort:        fnFmtDateShort_05c85041b5f9b6fa224b9c4ba9be3590,
			fnFmtNumber:           fnFmtNumber_f253fbd23af5a54db29f42f905c9e33a,
			fnFmtPercent:          fnFmtPercent_fb7ade3a9509df0c54be19484c433a01,
			fnFmtTimeFull:         fnFmtTimeFull_ebdf96de1e47f9043145564c500ef7dc,
			fnFmtTimeLong:         fnFmtTimeLong_987bec4676d3a5de4218e415e123649d,
			fnFmtTimeMedium:       fnFmtTimeMedium_b6f697552cd4965cd1195fe56dc87003,
			fnFmtTimeShort:        fnFmtTimeShort_8ffba4d1a2f04a0a6486853d76cf434b,
			fnGroup:               fnGroup_5c4b80a5ccdee81467241784ab8fcd56,
			fnLocale:              fnLocale_5a217059c67094defae82f249f55f4c5,
			fnMinus:               fnMinus_8b8229905258388dc16a5e0c270b0488,
			fnMonthAbbreviated:    fnMonthAbbreviated_aa9a9957cd9d056ba078b36a08b17478,
			fnMonthNarrow:         fnMonthNarrow_45916040ecf6fc350894d9e3e6c46dc7,
			fnMonthWide:           fnMonthWide_4c946a7e7581c665e7407df1841810b5,
			fnMonthsAbbreviated:   fnMonthsAbbreviated_181f77804b62232997fae36bd57d6cf7,
			fnMonthsNarrow:        fnMonthsNarrow_75daa2ba82ae9577292175c3f52370cc,
			fnMonthsWide:          fnMonthsWide_0ecf36a8b72255e2fee9467af362e989,
			fnOrdinalPluralRule:   fnOrdinalPluralRule_3355865f05dde9af2a36ba415bea85cb,
			fnPluralsCardinal:     fnPluralsCardinal_85b19cac1fab9f2c2cfb9eb41539aa0e,
			fnPluralsOrdinal:      fnPluralsOrdinal_16a60aa09da9778fa82fe463e83076de,
			fnPluralsRange:        fnPluralsRange_332465bda13eb808b3664fa0500f54ce,
			fnRangePluralRule:     fnRangePluralRule_47500e2a682fd3a64da69f06f7b93c0a,
			fnWeekdayAbbreviated:  fnWeekdayAbbreviated_4ffbdfbd2be10e6bd8fb5a542a14664a,
			fnWeekdayNarrow:       fnWeekdayNarrow_e86921b3446df5ea9afe9504cfa20d1a,
			fnWeekdayShort:        fnWeekdayShort_82b231d4f504c6d71c7e495aa35cd3c2,
			fnWeekdayWide:         fnWeekdayWide_ab7e026d8685cefd89c5aeb5df512a9a,
			fnWeekdaysAbbreviated: fnWeekdaysAbbreviated_454a3d7d23c662520a64ae5245d404be,
			fnWeekdaysNarrow:      fnWeekdaysNarrow_d23eb0b7a498c40ce19d1bf231cad524,
			fnWeekdaysShort:       fnWeekdaysShort_eb6ee64d01e314991432b4469790d38b,
			fnWeekdaysWide:        fnWeekdaysWide_5e2bbf75a31e730429c100e8a0bd3ebd,
		}
	}
	translatorFuncs["ar_mr"] = func() locales.Translator {
		return &localen{

			locale:                 "ar_MR",
			pluralsCardinal:        []locales.PluralRule{1, 2, 3, 4, 5, 6},
			pluralsOrdinal:         []locales.PluralRule{6},
			pluralsRange:           []locales.PluralRule{1, 4, 5, 6},
			decimal:                ",",
			group:                  ".",
			minus:                  "؜-",
			percent:                "٪؜",
			perMille:               "؉",
			timeSeparator:          ":",
			inifinity:              "∞",
			currencies:             []string{"ADP", "AED", "AFA", "AFN", "ALK", "ALL", "AMD", "ANG", "AOA", "AOK", "AON", "AOR", "ARA", "ARL", "ARM", "ARP", "ARS", "ATS", "AUD", "AWG", "AZM", "AZN", "BAD", "BAM", "BAN", "BBD", "BDT", "BEC", "BEF", "BEL", "BGL", "BGM", "BGN", "BGO", "BHD", "BIF", "BMD", "BND", "BOB", "BOL", "BOP", "BOV", "BRB", "BRC", "BRE", "BRL", "BRN", "BRR", "BRZ", "BSD", "BTN", "BUK", "BWP", "BYB", "BYN", "BYR", "BZD", "CAD", "CDF", "CHE", "CHF", "CHW", "CLE", "CLF", "CLP", "CNH", "CNX", "CNY", "COP", "COU", "CRC", "CSD", "CSK", "CUC", "CUP", "CVE", "CYP", "CZK", "DDM", "DEM", "DJF", "DKK", "DOP", "DZD", "ECS", "ECV", "EEK", "EGP", "ERN", "ESA", "ESB", "ESP", "ETB", "EUR", "FIM", "FJD", "FKP", "FRF", "GBP", "GEK", "GEL", "GHC", "GHS", "GIP", "GMD", "GNF", "GNS", "GQE", "GRD", "GTQ", "GWE", "GWP", "GYD", "HKD", "HNL", "HRD", "HRK", "HTG", "HUF", "IDR", "IEP", "ILP", "ILR", "ILS", "INR", "IQD", "IRR", "ISJ", "ISK", "ITL", "JMD", "JOD", "JPY", "KES", "KGS", "KHR", "KMF", "KPW", "KRH", "KRO", "KRW", "KWD", "KYD", "KZT", "LAK", "LBP", "LKR", "LRD", "LSL", "LTL", "LTT", "LUC", "LUF", "LUL", "LVL", "LVR", "LYD", "MAD", "MAF", "MCF", "MDC", "MDL", "MGA", "MGF", "MKD", "MKN", "MLF", "MMK", "MNT", "MOP", "MRO", "MRU", "MTL", "MTP", "MUR", "MVP", "MVR", "MWK", "MXN", "MXP", "MXV", "MYR", "MZE", "MZM", "MZN", "NAD", "NGN", "NIC", "NIO", "NLG", "NOK", "NPR", "NZD", "OMR", "PAB", "PEI", "PEN", "PES", "PGK", "PHP", "PKR", "PLN", "PLZ", "PTE", "PYG", "QAR", "RHD", "ROL", "RON", "RSD", "RUB", "RUR", "RWF", "SAR", "SBD", "SCR", "SDD", "SDG", "SDP", "SEK", "SGD", "SHP", "SIT", "SKK", "SLL", "SOS", "SRD", "SRG", "SSP", "STD", "STN", "SUR", "SVC", "SYP", "SZL", "THB", "TJR", "TJS", "TMM", "TMT", "TND", "TOP", "TPE", "TRL", "TRY", "TTD", "TWD", "TZS", "UAH", "UAK", "UGS", "UGX", "USD", "USN", "USS", "UYI", "UYP", "UYU", "UYW", "UZS", "VEB", "VEF", "VES", "VND", "VNN", "VUV", "WST", "XAF", "XAG", "XAU", "XBA", "XBB", "XBC", "XBD", "XCD", "XDR", "XEU", "XFO", "XFU", "XOF", "XPD", "XPF", "XPT", "XRE", "XSU", "XTS", "XUA", "XXX", "YDD", "YER", "YUD", "YUM", "YUN", "YUR", "ZAL", "ZAR", "ZMK", "ZMW", "ZRN", "ZRZ", "ZWD", "ZWL", "ZWR"},
			currencyPositiveSuffix: " ",
			currencyNegativeSuffix: " ",
			monthsAbbreviated:      []string{"", "يناير", "فبراير", "مارس", "إبريل", "مايو", "يونيو", "يوليو", "أغشت", "شتمبر", "أكتوبر", "نوفمبر", "دجمبر"},
			monthsNarrow:           []string{"", "ي", "ف", "م", "إ", "و", "ن", "ل", "غ", "ش", "ك", "ب", "د"},
			monthsWide:             []string{"", "يناير", "فبراير", "مارس", "إبريل", "مايو", "يونيو", "يوليو", "أغشت", "شتمبر", "أكتوبر", "نوفمبر", "دجمبر"},
			daysAbbreviated:        []string{"الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"},
			daysNarrow:             []string{"ح", "ن", "ث", "ر", "خ", "ج", "س"},
			daysShort:              []string{"أحد", "إثنين", "ثلاثاء", "أربعاء", "خميس", "جمعة", "سبت"},
			daysWide:               []string{"الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"},
			periodsAbbreviated:     []string{"ص", "م"},
			periodsNarrow:          []string{"ص", "م"},
			periodsWide:            []string{"ص", "م"},
			erasAbbreviated:        []string{"ق.م", "م"},
			erasNarrow:             []string{"", ""},
			erasWide:               []string{"قبل الميلاد", "ميلادي"},
			timezones:              map[string]string{"ACDT": "توقيت وسط أستراليا الصيفي", "ACST": "توقيت وسط أستراليا الرسمي", "ACWDT": "توقيت غرب وسط أستراليا الصيفي", "ACWST": "توقيت غرب وسط أستراليا الرسمي", "ADT": "التوقيت الصيفي الأطلسي", "AEDT": "توقيت شرق أستراليا الصيفي", "AEST": "توقيت شرق أستراليا الرسمي", "AKDT": "توقيت ألاسكا الصيفي", "AKST": "التوقيت الرسمي لألاسكا", "ARST": "توقيت الأرجنتين الصيفي", "ART": "توقيت الأرجنتين الرسمي", "AST": "التوقيت الرسمي الأطلسي", "AWDT": "توقيت غرب أستراليا الصيفي", "AWST": "توقيت غرب أستراليا الرسمي", "BOT": "توقيت بوليفيا", "BT": "توقيت بوتان", "CAT": "توقيت وسط أفريقيا", "CDT": "التوقيت الصيفي المركزي لأمريكا الشمالية", "CHADT": "توقيت تشاتام الصيفي", "CHAST": "توقيت تشاتام الرسمي", "CLST": "توقيت تشيلي الصيفي", "CLT": "توقيت تشيلي الرسمي", "COST": "توقيت كولومبيا الصيفي", "COT": "توقيت كولومبيا الرسمي", "CST": "التوقيت الرسمي المركزي لأمريكا الشمالية", "ChST": "توقيت تشامورو", "EAT": "توقيت شرق أفريقيا", "ECT": "توقيت الإكوادور", "EDT": "التوقيت الصيفي الشرقي لأمريكا الشمالية", "EST": "التوقيت الرسمي الشرقي لأمريكا الشمالية", "GFT": "توقيت غويانا الفرنسية", "GMT": "توقيت غرينتش", "GST": "توقيت الخليج", "GYT": "توقيت غيانا", "HADT": "توقيت هاواي ألوتيان الصيفي", "HAST": "توقيت هاواي ألوتيان الرسمي", "HAT": "توقيت نيوفاوندلاند الصيفي", "HECU": "توقيت كوبا الصيفي", "HEEG": "توقيت شرق غرينلاند الصيفي", "HENOMX": "التوقيت الصيفي لشمال غرب المكسيك", "HEOG": "توقيت غرب غرينلاند الصيفي", "HEPM": "توقيت سانت بيير وميكولون الصيفي", "HEPMX": "توقيت المحيط الهادي الصيفي للمكسيك", "HKST": "توقيت هونغ كونغ الصيفي", "HKT": "توقيت هونغ كونغ الرسمي", "HNCU": "توقيت كوبا الرسمي", "HNEG": "توقيت شرق غرينلاند الرسمي", "HNNOMX": "التوقيت الرسمي لشمال غرب المكسيك", "HNOG": "توقيت غرب غرينلاند الرسمي", "HNPM": "توقيت سانت بيير وميكولون الرسمي", "HNPMX": "توقيت المحيط الهادي الرسمي للمكسيك", "HNT": "توقيت نيوفاوندلاند الرسمي", "IST": "توقيت الهند", "JDT": "توقيت اليابان الصيفي", "JST": "توقيت اليابان الرسمي", "LHDT": "التوقيت الصيفي للورد هاو", "LHST": "توقيت لورد هاو الرسمي", "MDT": "التوقيت الجبلي الصيفي لأمريكا الشمالية", "MESZ": "توقيت وسط أوروبا الصيفي", "MEZ": "توقيت وسط أوروبا الرسمي", "MST": "التوقيت الجبلي الرسمي لأمريكا الشمالية", "MYT": "توقيت ماليزيا", "NZDT": "توقيت نيوزيلندا الصيفي", "NZST": "توقيت نيوزيلندا الرسمي", "OESZ": "توقيت شرق أوروبا الصيفي", "OEZ": "توقيت شرق أوروبا الرسمي", "PDT": "توقيت المحيط الهادي الصيفي", "PST": "توقيت المحيط الهادي الرسمي", "SAST": "توقيت جنوب أفريقيا", "SGT": "توقيت سنغافورة", "SRT": "توقيت سورينام", "TMST": "توقيت تركمانستان الصيفي", "TMT": "توقيت تركمانستان الرسمي", "UYST": "توقيت أوروغواي الصيفي", "UYT": "توقيت أوروغواي الرسمي", "VET": "توقيت فنزويلا", "WARST": "توقيت غرب الأرجنتين الصيفي", "WART": "توقيت غرب الأرجنتين الرسمي", "WAST": "توقيت غرب أفريقيا الصيفي", "WAT": "توقيت غرب أفريقيا الرسمي", "WESZ": "توقيت غرب أوروبا الصيفي", "WEZ": "توقيت غرب أوروبا الرسمي", "WIB": "توقيت غرب إندونيسيا", "WIT": "توقيت شرق إندونيسيا", "WITA": "توقيت وسط إندونيسيا", "∅∅∅": "توقيت أزورس الصيفي"},

			fnCardinalPluralRule:  fnCardinalPluralRule_f27514af189883ea7cd186156edfe998,
			fnDecimal:             fnDecimal_a78485e7dd32c95f41af4e18420793bf,
			fnFmtAccounting:       fnFmtAccounting_d5455f8fcf723c4be2a5a03fd41298f2,
			fnFmtCurrency:         fnFmtCurrency_2c2268a7a667170346d6d4c829feb8a4,
			fnFmtDateFull:         fnFmtDateFull_2d3b405215099e683568cb9c052cbd54,
			fnFmtDateLong:         fnFmtDateLong_506f643cda0514f66d873a9ea99bf639,
			fnFmtDateMedium:       fnFmtDateMedium_a55320da438aec0cfbc31bc4d718abc1,
			fnFmtDateShort:        fnFmtDateShort_05c85041b5f9b6fa224b9c4ba9be3590,
			fnFmtNumber:           fnFmtNumber_f253fbd23af5a54db29f42f905c9e33a,
			fnFmtPercent:          fnFmtPercent_fb7ade3a9509df0c54be19484c433a01,
			fnFmtTimeFull:         fnFmtTimeFull_37fe4deeee789852cc196a6a1a2f0ccc,
			fnFmtTimeLong:         fnFmtTimeLong_4429ef4fb58a2a9c4d7d5132fd16ecbf,
			fnFmtTimeMedium:       fnFmtTimeMedium_8ef07f6477b7a4944577d4e5392ff21b,
			fnFmtTimeShort:        fnFmtTimeShort_8288b817c5c0216c9815524c71c9e0b4,
			fnGroup:               fnGroup_5c4b80a5ccdee81467241784ab8fcd56,
			fnLocale:              fnLocale_5a217059c67094defae82f249f55f4c5,
			fnMinus:               fnMinus_8b8229905258388dc16a5e0c270b0488,
			fnMonthAbbreviated:    fnMonthAbbreviated_aa9a9957cd9d056ba078b36a08b17478,
			fnMonthNarrow:         fnMonthNarrow_45916040ecf6fc350894d9e3e6c46dc7,
			fnMonthWide:           fnMonthWide_4c946a7e7581c665e7407df1841810b5,
			fnMonthsAbbreviated:   fnMonthsAbbreviated_181f77804b62232997fae36bd57d6cf7,
			fnMonthsNarrow:        fnMonthsNarrow_75daa2ba82ae9577292175c3f52370cc,
			fnMonthsWide:          fnMonthsWide_0ecf36a8b72255e2fee9467af362e989,
			fnOrdinalPluralRule:   fnOrdinalPluralRule_3355865f05dde9af2a36ba415bea85cb,
			fnPluralsCardinal:     fnPluralsCardinal_85b19cac1fab9f2c2cfb9eb41539aa0e,
			fnPluralsOrdinal:      fnPluralsOrdinal_16a60aa09da9778fa82fe463e83076de,
			fnPluralsRange:        fnPluralsRange_332465bda13eb808b3664fa0500f54ce,
			fnRangePluralRule:     fnRangePluralRule_47500e2a682fd3a64da69f06f7b93c0a,
			fnWeekdayAbbreviated:  fnWeekdayAbbreviated_4ffbdfbd2be10e6bd8fb5a542a14664a,
			fnWeekdayNarrow:       fnWeekdayNarrow_e86921b3446df5ea9afe9504cfa20d1a,
			fnWeekdayShort:        fnWeekdayShort_82b231d4f504c6d71c7e495aa35cd3c2,
			fnWeekdayWide:         fnWeekdayWide_ab7e026d8685cefd89c5aeb5df512a9a,
			fnWeekdaysAbbreviated: fnWeekdaysAbbreviated_454a3d7d23c662520a64ae5245d404be,
			fnWeekdaysNarrow:      fnWeekdaysNarrow_d23eb0b7a498c40ce19d1bf231cad524,
			fnWeekdaysShort:       fnWeekdaysShort_eb6ee64d01e314991432b4469790d38b,
			fnWeekdaysWide:        fnWeekdaysWide_5e2bbf75a31e730429c100e8a0bd3ebd,
		}
	}
	translatorFuncs["ar_om"] = func() locales.Translator {
		return &localen{

			locale:                 "ar_OM",
			pluralsCardinal:        []locales.PluralRule{1, 2, 3, 4, 5, 6},
			pluralsOrdinal:         []locales.PluralRule{6},
			pluralsRange:           []locales.PluralRule{1, 4, 5, 6},
			decimal:                "٫",
			group:                  "٬",
			minus:                  "؜-",
			percent:                "٪؜",
			perMille:               "؉",
			timeSeparator:          ":",
			inifinity:              "∞",
			currencies:             []string{"ADP", "AED", "AFA", "AFN", "ALK", "ALL", "AMD", "ANG", "AOA", "AOK", "AON", "AOR", "ARA", "ARL", "ARM", "ARP", "ARS", "ATS", "AUD", "AWG", "AZM", "AZN", "BAD", "BAM", "BAN", "BBD", "BDT", "BEC", "BEF", "BEL", "BGL", "BGM", "BGN", "BGO", "BHD", "BIF", "BMD", "BND", "BOB", "BOL", "BOP", "BOV", "BRB", "BRC", "BRE", "BRL", "BRN", "BRR", "BRZ", "BSD", "BTN", "BUK", "BWP", "BYB", "BYN", "BYR", "BZD", "CAD", "CDF", "CHE", "CHF", "CHW", "CLE", "CLF", "CLP", "CNH", "CNX", "CNY", "COP", "COU", "CRC", "CSD", "CSK", "CUC", "CUP", "CVE", "CYP", "CZK", "DDM", "DEM", "DJF", "DKK", "DOP", "DZD", "ECS", "ECV", "EEK", "EGP", "ERN", "ESA", "ESB", "ESP", "ETB", "EUR", "FIM", "FJD", "FKP", "FRF", "GBP", "GEK", "GEL", "GHC", "GHS", "GIP", "GMD", "GNF", "GNS", "GQE", "GRD", "GTQ", "GWE", "GWP", "GYD", "HKD", "HNL", "HRD", "HRK", "HTG", "HUF", "IDR", "IEP", "ILP", "ILR", "ILS", "INR", "IQD", "IRR", "ISJ", "ISK", "ITL", "JMD", "JOD", "JPY", "KES", "KGS", "KHR", "KMF", "KPW", "KRH", "KRO", "KRW", "KWD", "KYD", "KZT", "LAK", "LBP", "LKR", "LRD", "LSL", "LTL", "LTT", "LUC", "LUF", "LUL", "LVL", "LVR", "LYD", "MAD", "MAF", "MCF", "MDC", "MDL", "MGA", "MGF", "MKD", "MKN", "MLF", "MMK", "MNT", "MOP", "MRO", "MRU", "MTL", "MTP", "MUR", "MVP", "MVR", "MWK", "MXN", "MXP", "MXV", "MYR", "MZE", "MZM", "MZN", "NAD", "NGN", "NIC", "NIO", "NLG", "NOK", "NPR", "NZD", "OMR", "PAB", "PEI", "PEN", "PES", "PGK", "PHP", "PKR", "PLN", "PLZ", "PTE", "PYG", "QAR", "RHD", "ROL", "RON", "RSD", "RUB", "RUR", "RWF", "SAR", "SBD", "SCR", "SDD", "SDG", "SDP", "SEK", "SGD", "SHP", "SIT", "SKK", "SLL", "SOS", "SRD", "SRG", "SSP", "STD", "STN", "SUR", "SVC", "SYP", "SZL", "THB", "TJR", "TJS", "TMM", "TMT", "TND", "TOP", "TPE", "TRL", "TRY", "TTD", "TWD", "TZS", "UAH", "UAK", "UGS", "UGX", "USD", "USN", "USS", "UYI", "UYP", "UYU", "UYW", "UZS", "VEB", "VEF", "VES", "VND", "VNN", "VUV", "WST", "XAF", "XAG", "XAU", "XBA", "XBB", "XBC", "XBD", "XCD", "XDR", "XEU", "XFO", "XFU", "XOF", "XPD", "XPF", "XPT", "XRE", "XSU", "XTS", "XUA", "XXX", "YDD", "YER", "YUD", "YUM", "YUN", "YUR", "ZAL", "ZAR", "ZMK", "ZMW", "ZRN", "ZRZ", "ZWD", "ZWL", "ZWR"},
			currencyPositiveSuffix: " ",
			currencyNegativeSuffix: " ",
			monthsAbbreviated:      []string{"", "يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"},
			monthsNarrow:           []string{"", "ي", "ف", "م", "أ", "و", "ن", "ل", "غ", "س", "ك", "ب", "د"},
			monthsWide:             []string{"", "يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"},
			daysAbbreviated:        []string{"الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"},
			daysNarrow:             []string{"ح", "ن", "ث", "ر", "خ", "ج", "س"},
			daysShort:              []string{"أحد", "إثنين", "ثلاثاء", "أربعاء", "خميس", "جمعة", "سبت"},
			daysWide:               []string{"الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"},
			periodsAbbreviated:     []string{"ص", "م"},
			periodsNarrow:          []string{"ص", "م"},
			periodsWide:            []string{"ص", "م"},
			erasAbbreviated:        []string{"ق.م", "م"},
			erasNarrow:             []string{"", ""},
			erasWide:               []string{"قبل الميلاد", "ميلادي"},
			timezones:              map[string]string{"ACDT": "توقيت وسط أستراليا الصيفي", "ACST": "توقيت وسط أستراليا الرسمي", "ACWDT": "توقيت غرب وسط أستراليا الصيفي", "ACWST": "توقيت غرب وسط أستراليا الرسمي", "ADT": "التوقيت الصيفي الأطلسي", "AEDT": "توقيت شرق أستراليا الصيفي", "AEST": "توقيت شرق أستراليا الرسمي", "AKDT": "توقيت ألاسكا الصيفي", "AKST": "التوقيت الرسمي لألاسكا", "ARST": "توقيت الأرجنتين الصيفي", "ART": "توقيت الأرجنتين الرسمي", "AST": "التوقيت الرسمي الأطلسي", "AWDT": "توقيت غرب أستراليا الصيفي", "AWST": "توقيت غرب أستراليا الرسمي", "BOT": "توقيت بوليفيا", "BT": "توقيت بوتان", "CAT": "توقيت وسط أفريقيا", "CDT": "التوقيت الصيفي المركزي لأمريكا الشمالية", "CHADT": "توقيت تشاتام الصيفي", "CHAST": "توقيت تشاتام الرسمي", "CLST": "توقيت تشيلي الصيفي", "CLT": "توقيت تشيلي الرسمي", "COST": "توقيت كولومبيا الصيفي", "COT": "توقيت كولومبيا الرسمي", "CST": "التوقيت الرسمي المركزي لأمريكا الشمالية", "ChST": "توقيت تشامورو", "EAT": "توقيت شرق أفريقيا", "ECT": "توقيت الإكوادور", "EDT": "التوقيت الصيفي الشرقي لأمريكا الشمالية", "EST": "التوقيت الرسمي الشرقي لأمريكا الشمالية", "GFT": "توقيت غويانا الفرنسية", "GMT": "توقيت غرينتش", "GST": "توقيت الخليج", "GYT": "توقيت غيانا", "HADT": "توقيت هاواي ألوتيان الصيفي", "HAST": "توقيت هاواي ألوتيان الرسمي", "HAT": "توقيت نيوفاوندلاند الصيفي", "HECU": "توقيت كوبا الصيفي", "HEEG": "توقيت شرق غرينلاند الصيفي", "HENOMX": "التوقيت الصيفي لشمال غرب المكسيك", "HEOG": "توقيت غرب غرينلاند الصيفي", "HEPM": "توقيت سانت بيير وميكولون الصيفي", "HEPMX": "توقيت المحيط الهادي الصيفي للمكسيك", "HKST": "توقيت هونغ كونغ الصيفي", "HKT": "توقيت هونغ كونغ الرسمي", "HNCU": "توقيت كوبا الرسمي", "HNEG": "توقيت شرق غرينلاند الرسمي", "HNNOMX": "التوقيت الرسمي لشمال غرب المكسيك", "HNOG": "توقيت غرب غرينلاند الرسمي", "HNPM": "توقيت سانت بيير وميكولون الرسمي", "HNPMX": "توقيت المحيط الهادي الرسمي للمكسيك", "HNT": "توقيت نيوفاوندلاند الرسمي", "IST": "توقيت الهند", "JDT": "توقيت اليابان الصيفي", "JST": "توقيت اليابان الرسمي", "LHDT": "التوقيت الصيفي للورد هاو", "LHST": "توقيت لورد هاو الرسمي", "MDT": "التوقيت الجبلي الصيفي لأمريكا الشمالية", "MESZ": "توقيت وسط أوروبا الصيفي", "MEZ": "توقيت وسط أوروبا الرسمي", "MST": "التوقيت الجبلي الرسمي لأمريكا الشمالية", "MYT": "توقيت ماليزيا", "NZDT": "توقيت نيوزيلندا الصيفي", "NZST": "توقيت نيوزيلندا الرسمي", "OESZ": "توقيت شرق أوروبا الصيفي", "OEZ": "توقيت شرق أوروبا الرسمي", "PDT": "توقيت المحيط الهادي الصيفي", "PST": "توقيت المحيط الهادي الرسمي", "SAST": "توقيت جنوب أفريقيا", "SGT": "توقيت سنغافورة", "SRT": "توقيت سورينام", "TMST": "توقيت تركمانستان الصيفي", "TMT": "توقيت تركمانستان الرسمي", "UYST": "توقيت أوروغواي الصيفي", "UYT": "توقيت أوروغواي الرسمي", "VET": "توقيت فنزويلا", "WARST": "توقيت غرب الأرجنتين الصيفي", "WART": "توقيت غرب الأرجنتين الرسمي", "WAST": "توقيت غرب أفريقيا الصيفي", "WAT": "توقيت غرب أفريقيا الرسمي", "WESZ": "توقيت غرب أوروبا الصيفي", "WEZ": "توقيت غرب أوروبا الرسمي", "WIB": "توقيت غرب إندونيسيا", "WIT": "توقيت شرق إندونيسيا", "WITA": "توقيت وسط إندونيسيا", "∅∅∅": "توقيت الأمازون الصيفي"},

			fnCardinalPluralRule:  fnCardinalPluralRule_f27514af189883ea7cd186156edfe998,
			fnDecimal:             fnDecimal_a78485e7dd32c95f41af4e18420793bf,
			fnFmtAccounting:       fnFmtAccounting_f74088692afba81682b73af3d3e7c19a,
			fnFmtCurrency:         fnFmtCurrency_e28d302f22cf4ed4b5009e290f74e359,
			fnFmtDateFull:         fnFmtDateFull_2d3b405215099e683568cb9c052cbd54,
			fnFmtDateLong:         fnFmtDateLong_506f643cda0514f66d873a9ea99bf639,
			fnFmtDateMedium:       fnFmtDateMedium_a55320da438aec0cfbc31bc4d718abc1,
			fnFmtDateShort:        fnFmtDateShort_05c85041b5f9b6fa224b9c4ba9be3590,
			fnFmtNumber:           fnFmtNumber_eef52ddc8fa71bd12171ac9ef3cd3328,
			fnFmtPercent:          fnFmtPercent_60ca2e9d27b8160a5fec0f6694129759,
			fnFmtTimeFull:         fnFmtTimeFull_37fe4deeee789852cc196a6a1a2f0ccc,
			fnFmtTimeLong:         fnFmtTimeLong_4429ef4fb58a2a9c4d7d5132fd16ecbf,
			fnFmtTimeMedium:       fnFmtTimeMedium_8ef07f6477b7a4944577d4e5392ff21b,
			fnFmtTimeShort:        fnFmtTimeShort_8288b817c5c0216c9815524c71c9e0b4,
			fnGroup:               fnGroup_5c4b80a5ccdee81467241784ab8fcd56,
			fnLocale:              fnLocale_5a217059c67094defae82f249f55f4c5,
			fnMinus:               fnMinus_8b8229905258388dc16a5e0c270b0488,
			fnMonthAbbreviated:    fnMonthAbbreviated_aa9a9957cd9d056ba078b36a08b17478,
			fnMonthNarrow:         fnMonthNarrow_45916040ecf6fc350894d9e3e6c46dc7,
			fnMonthWide:           fnMonthWide_4c946a7e7581c665e7407df1841810b5,
			fnMonthsAbbreviated:   fnMonthsAbbreviated_181f77804b62232997fae36bd57d6cf7,
			fnMonthsNarrow:        fnMonthsNarrow_75daa2ba82ae9577292175c3f52370cc,
			fnMonthsWide:          fnMonthsWide_0ecf36a8b72255e2fee9467af362e989,
			fnOrdinalPluralRule:   fnOrdinalPluralRule_3355865f05dde9af2a36ba415bea85cb,
			fnPluralsCardinal:     fnPluralsCardinal_85b19cac1fab9f2c2cfb9eb41539aa0e,
			fnPluralsOrdinal:      fnPluralsOrdinal_16a60aa09da9778fa82fe463e83076de,
			fnPluralsRange:        fnPluralsRange_332465bda13eb808b3664fa0500f54ce,
			fnRangePluralRule:     fnRangePluralRule_47500e2a682fd3a64da69f06f7b93c0a,
			fnWeekdayAbbreviated:  fnWeekdayAbbreviated_4ffbdfbd2be10e6bd8fb5a542a14664a,
			fnWeekdayNarrow:       fnWeekdayNarrow_e86921b3446df5ea9afe9504cfa20d1a,
			fnWeekdayShort:        fnWeekdayShort_82b231d4f504c6d71c7e495aa35cd3c2,
			fnWeekdayWide:         fnWeekdayWide_ab7e026d8685cefd89c5aeb5df512a9a,
			fnWeekdaysAbbreviated: fnWeekdaysAbbreviated_454a3d7d23c662520a64ae5245d404be,
			fnWeekdaysNarrow:      fnWeekdaysNarrow_d23eb0b7a498c40ce19d1bf231cad524,
			fnWeekdaysShort:       fnWeekdaysShort_eb6ee64d01e314991432b4469790d38b,
			fnWeekdaysWide:        fnWeekdaysWide_5e2bbf75a31e730429c100e8a0bd3ebd,
		}
	}
	translatorFuncs["ar_ps"] = func() locales.Translator {
		return &localen{

			locale:                 "ar_PS",
			pluralsCardinal:        []locales.PluralRule{1, 2, 3, 4, 5, 6},
			pluralsOrdinal:         []locales.PluralRule{6},
			pluralsRange:           []locales.PluralRule{1, 4, 5, 6},
			decimal:                "٫",
			group:                  "٬",
			minus:                  "؜-",
			percent:                "٪؜",
			perMille:               "؉",
			timeSeparator:          ":",
			inifinity:              "∞",
			currencies:             []string{"ADP", "AED", "AFA", "AFN", "ALK", "ALL", "AMD", "ANG", "AOA", "AOK", "AON", "AOR", "ARA", "ARL", "ARM", "ARP", "ARS", "ATS", "AUD", "AWG", "AZM", "AZN", "BAD", "BAM", "BAN", "BBD", "BDT", "BEC", "BEF", "BEL", "BGL", "BGM", "BGN", "BGO", "BHD", "BIF", "BMD", "BND", "BOB", "BOL", "BOP", "BOV", "BRB", "BRC", "BRE", "BRL", "BRN", "BRR", "BRZ", "BSD", "BTN", "BUK", "BWP", "BYB", "BYN", "BYR", "BZD", "CAD", "CDF", "CHE", "CHF", "CHW", "CLE", "CLF", "CLP", "CNH", "CNX", "CNY", "COP", "COU", "CRC", "CSD", "CSK", "CUC", "CUP", "CVE", "CYP", "CZK", "DDM", "DEM", "DJF", "DKK", "DOP", "DZD", "ECS", "ECV", "EEK", "EGP", "ERN", "ESA", "ESB", "ESP", "ETB", "EUR", "FIM", "FJD", "FKP", "FRF", "GBP", "GEK", "GEL", "GHC", "GHS", "GIP", "GMD", "GNF", "GNS", "GQE", "GRD", "GTQ", "GWE", "GWP", "GYD", "HKD", "HNL", "HRD", "HRK", "HTG", "HUF", "IDR", "IEP", "ILP", "ILR", "ILS", "INR", "IQD", "IRR", "ISJ", "ISK", "ITL", "JMD", "JOD", "JPY", "KES", "KGS", "KHR", "KMF", "KPW", "KRH", "KRO", "KRW", "KWD", "KYD", "KZT", "LAK", "LBP", "LKR", "LRD", "LSL", "LTL", "LTT", "LUC", "LUF", "LUL", "LVL", "LVR", "LYD", "MAD", "MAF", "MCF", "MDC", "MDL", "MGA", "MGF", "MKD", "MKN", "MLF", "MMK", "MNT", "MOP", "MRO", "MRU", "MTL", "MTP", "MUR", "MVP", "MVR", "MWK", "MXN", "MXP", "MXV", "MYR", "MZE", "MZM", "MZN", "NAD", "NGN", "NIC", "NIO", "NLG", "NOK", "NPR", "NZD", "OMR", "PAB", "PEI", "PEN", "PES", "PGK", "PHP", "PKR", "PLN", "PLZ", "PTE", "PYG", "QAR", "RHD", "ROL", "RON", "RSD", "RUB", "RUR", "RWF", "SAR", "SBD", "SCR", "SDD", "SDG", "SDP", "SEK", "SGD", "SHP", "SIT", "SKK", "SLL", "SOS", "SRD", "SRG", "SSP", "STD", "STN", "SUR", "SVC", "SYP", "SZL", "THB", "TJR", "TJS", "TMM", "TMT", "TND", "TOP", "TPE", "TRL", "TRY", "TTD", "TWD", "TZS", "UAH", "UAK", "UGS", "UGX", "USD", "USN", "USS", "UYI", "UYP", "UYU", "UYW", "UZS", "VEB", "VEF", "VES", "VND", "VNN", "VUV", "WST", "XAF", "XAG", "XAU", "XBA", "XBB", "XBC", "XBD", "XCD", "XDR", "XEU", "XFO", "XFU", "XOF", "XPD", "XPF", "XPT", "XRE", "XSU", "XTS", "XUA", "XXX", "YDD", "YER", "YUD", "YUM", "YUN", "YUR", "ZAL", "ZAR", "ZMK", "ZMW", "ZRN", "ZRZ", "ZWD", "ZWL", "ZWR"},
			currencyPositiveSuffix: " ",
			currencyNegativeSuffix: " ",
			monthsAbbreviated:      []string{"", "كانون الثاني", "شباط", "آذار", "نيسان", "أيار", "حزيران", "تموز", "آب", "أيلول", "تشرين الأول", "تشرين الثاني", "كانون الأول"},
			monthsNarrow:           []string{"", "ك", "ش", "آ", "ن", "أ", "ح", "ت", "آ", "أ", "ت", "ت", "ك"},
			monthsWide:             []string{"", "كانون الثاني", "شباط", "آذار", "نيسان", "أيار", "حزيران", "تموز", "آب", "أيلول", "تشرين الأول", "تشرين الثاني", "كانون الأول"},
			daysAbbreviated:        []string{"الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"},
			daysNarrow:             []string{"ح", "ن", "ث", "ر", "خ", "ج", "س"},
			daysShort:              []string{"أحد", "إثنين", "ثلاثاء", "أربعاء", "خميس", "جمعة", "سبت"},
			daysWide:               []string{"الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"},
			periodsAbbreviated:     []string{"ص", "م"},
			periodsNarrow:          []string{"ص", "م"},
			periodsWide:            []string{"ص", "م"},
			erasAbbreviated:        []string{"ق.م", "م"},
			erasNarrow:             []string{"", ""},
			erasWide:               []string{"قبل الميلاد", "ميلادي"},
			timezones:              map[string]string{"ACDT": "توقيت وسط أستراليا الصيفي", "ACST": "توقيت وسط أستراليا الرسمي", "ACWDT": "توقيت غرب وسط أستراليا الصيفي", "ACWST": "توقيت غرب وسط أستراليا الرسمي", "ADT": "التوقيت الصيفي الأطلسي", "AEDT": "توقيت شرق أستراليا الصيفي", "AEST": "توقيت شرق أستراليا الرسمي", "AKDT": "توقيت ألاسكا الصيفي", "AKST": "التوقيت الرسمي لألاسكا", "ARST": "توقيت الأرجنتين الصيفي", "ART": "توقيت الأرجنتين الرسمي", "AST": "التوقيت الرسمي الأطلسي", "AWDT": "توقيت غرب أستراليا الصيفي", "AWST": "توقيت غرب أستراليا الرسمي", "BOT": "توقيت بوليفيا", "BT": "توقيت بوتان", "CAT": "توقيت وسط أفريقيا", "CDT": "التوقيت الصيفي المركزي لأمريكا الشمالية", "CHADT": "توقيت تشاتام الصيفي", "CHAST": "توقيت تشاتام الرسمي", "CLST": "توقيت تشيلي الصيفي", "CLT": "توقيت تشيلي الرسمي", "COST": "توقيت كولومبيا الصيفي", "COT": "توقيت كولومبيا الرسمي", "CST": "التوقيت الرسمي المركزي لأمريكا الشمالية", "ChST": "توقيت تشامورو", "EAT": "توقيت شرق أفريقيا", "ECT": "توقيت الإكوادور", "EDT": "التوقيت الصيفي الشرقي لأمريكا الشمالية", "EST": "التوقيت الرسمي الشرقي لأمريكا الشمالية", "GFT": "توقيت غويانا الفرنسية", "GMT": "توقيت غرينتش", "GST": "توقيت الخليج", "GYT": "توقيت غيانا", "HADT": "توقيت هاواي ألوتيان الصيفي", "HAST": "توقيت هاواي ألوتيان الرسمي", "HAT": "توقيت نيوفاوندلاند الصيفي", "HECU": "توقيت كوبا الصيفي", "HEEG": "توقيت شرق غرينلاند الصيفي", "HENOMX": "التوقيت الصيفي لشمال غرب المكسيك", "HEOG": "توقيت غرب غرينلاند الصيفي", "HEPM": "توقيت سانت بيير وميكولون الصيفي", "HEPMX": "توقيت المحيط الهادي الصيفي للمكسيك", "HKST": "توقيت هونغ كونغ الصيفي", "HKT": "توقيت هونغ كونغ الرسمي", "HNCU": "توقيت كوبا الرسمي", "HNEG": "توقيت شرق غرينلاند الرسمي", "HNNOMX": "التوقيت الرسمي لشمال غرب المكسيك", "HNOG": "توقيت غرب غرينلاند الرسمي", "HNPM": "توقيت سانت بيير وميكولون الرسمي", "HNPMX": "توقيت المحيط الهادي الرسمي للمكسيك", "HNT": "توقيت نيوفاوندلاند الرسمي", "IST": "توقيت الهند", "JDT": "توقيت اليابان الصيفي", "JST": "توقيت اليابان الرسمي", "LHDT": "التوقيت الصيفي للورد هاو", "LHST": "توقيت لورد هاو الرسمي", "MDT": "التوقيت الجبلي الصيفي لأمريكا الشمالية", "MESZ": "توقيت وسط أوروبا الصيفي", "MEZ": "توقيت وسط أوروبا الرسمي", "MST": "التوقيت الجبلي الرسمي لأمريكا الشمالية", "MYT": "توقيت ماليزيا", "NZDT": "توقيت نيوزيلندا الصيفي", "NZST": "توقيت نيوزيلندا الرسمي", "OESZ": "توقيت شرق أوروبا الصيفي", "OEZ": "توقيت شرق أوروبا الرسمي", "PDT": "توقيت المحيط الهادي الصيفي", "PST": "توقيت المحيط الهادي الرسمي", "SAST": "توقيت جنوب أفريقيا", "SGT": "توقيت سنغافورة", "SRT": "توقيت سورينام", "TMST": "توقيت تركمانستان الصيفي", "TMT": "توقيت تركمانستان الرسمي", "UYST": "توقيت أوروغواي الصيفي", "UYT": "توقيت أوروغواي الرسمي", "VET": "توقيت فنزويلا", "WARST": "توقيت غرب الأرجنتين الصيفي", "WART": "توقيت غرب الأرجنتين الرسمي", "WAST": "توقيت غرب أفريقيا الصيفي", "WAT": "توقيت غرب أفريقيا الرسمي", "WESZ": "توقيت غرب أوروبا الصيفي", "WEZ": "توقيت غرب أوروبا الرسمي", "WIB": "توقيت غرب إندونيسيا", "WIT": "توقيت شرق إندونيسيا", "WITA": "توقيت وسط إندونيسيا", "∅∅∅": "توقيت برازيليا الصيفي"},

			fnCardinalPluralRule:  fnCardinalPluralRule_f27514af189883ea7cd186156edfe998,
			fnDecimal:             fnDecimal_a78485e7dd32c95f41af4e18420793bf,
			fnFmtAccounting:       fnFmtAccounting_f74088692afba81682b73af3d3e7c19a,
			fnFmtCurrency:         fnFmtCurrency_e28d302f22cf4ed4b5009e290f74e359,
			fnFmtDateFull:         fnFmtDateFull_2d3b405215099e683568cb9c052cbd54,
			fnFmtDateLong:         fnFmtDateLong_506f643cda0514f66d873a9ea99bf639,
			fnFmtDateMedium:       fnFmtDateMedium_a55320da438aec0cfbc31bc4d718abc1,
			fnFmtDateShort:        fnFmtDateShort_05c85041b5f9b6fa224b9c4ba9be3590,
			fnFmtNumber:           fnFmtNumber_eef52ddc8fa71bd12171ac9ef3cd3328,
			fnFmtPercent:          fnFmtPercent_60ca2e9d27b8160a5fec0f6694129759,
			fnFmtTimeFull:         fnFmtTimeFull_37fe4deeee789852cc196a6a1a2f0ccc,
			fnFmtTimeLong:         fnFmtTimeLong_4429ef4fb58a2a9c4d7d5132fd16ecbf,
			fnFmtTimeMedium:       fnFmtTimeMedium_8ef07f6477b7a4944577d4e5392ff21b,
			fnFmtTimeShort:        fnFmtTimeShort_8288b817c5c0216c9815524c71c9e0b4,
			fnGroup:               fnGroup_5c4b80a5ccdee81467241784ab8fcd56,
			fnLocale:              fnLocale_5a217059c67094defae82f249f55f4c5,
			fnMinus:               fnMinus_8b8229905258388dc16a5e0c270b0488,
			fnMonthAbbreviated:    fnMonthAbbreviated_aa9a9957cd9d056ba078b36a08b17478,
			fnMonthNarrow:         fnMonthNarrow_45916040ecf6fc350894d9e3e6c46dc7,
			fnMonthWide:           fnMonthWide_4c946a7e7581c665e7407df1841810b5,
			fnMonthsAbbreviated:   fnMonthsAbbreviated_181f77804b62232997fae36bd57d6cf7,
			fnMonthsNarrow:        fnMonthsNarrow_75daa2ba82ae9577292175c3f52370cc,
			fnMonthsWide:          fnMonthsWide_0ecf36a8b72255e2fee9467af362e989,
			fnOrdinalPluralRule:   fnOrdinalPluralRule_3355865f05dde9af2a36ba415bea85cb,
			fnPluralsCardinal:     fnPluralsCardinal_85b19cac1fab9f2c2cfb9eb41539aa0e,
			fnPluralsOrdinal:      fnPluralsOrdinal_16a60aa09da9778fa82fe463e83076de,
			fnPluralsRange:        fnPluralsRange_332465bda13eb808b3664fa0500f54ce,
			fnRangePluralRule:     fnRangePluralRule_47500e2a682fd3a64da69f06f7b93c0a,
			fnWeekdayAbbreviated:  fnWeekdayAbbreviated_4ffbdfbd2be10e6bd8fb5a542a14664a,
			fnWeekdayNarrow:       fnWeekdayNarrow_e86921b3446df5ea9afe9504cfa20d1a,
			fnWeekdayShort:        fnWeekdayShort_82b231d4f504c6d71c7e495aa35cd3c2,
			fnWeekdayWide:         fnWeekdayWide_ab7e026d8685cefd89c5aeb5df512a9a,
			fnWeekdaysAbbreviated: fnWeekdaysAbbreviated_454a3d7d23c662520a64ae5245d404be,
			fnWeekdaysNarrow:      fnWeekdaysNarrow_d23eb0b7a498c40ce19d1bf231cad524,
			fnWeekdaysShort:       fnWeekdaysShort_eb6ee64d01e314991432b4469790d38b,
			fnWeekdaysWide:        fnWeekdaysWide_5e2bbf75a31e730429c100e8a0bd3ebd,
		}
	}
	translatorFuncs["ar_qa"] = func() locales.Translator {
		return &localen{

			locale:                 "ar_QA",
			pluralsCardinal:        []locales.PluralRule{1, 2, 3, 4, 5, 6},
			pluralsOrdinal:         []locales.PluralRule{6},
			pluralsRange:           []locales.PluralRule{1, 4, 5, 6},
			decimal:                "٫",
			group:                  "٬",
			minus:                  "؜-",
			percent:                "٪؜",
			perMille:               "؉",
			timeSeparator:          ":",
			inifinity:              "∞",
			currencies:             []string{"ADP", "AED", "AFA", "AFN", "ALK", "ALL", "AMD", "ANG", "AOA", "AOK", "AON", "AOR", "ARA", "ARL", "ARM", "ARP", "ARS", "ATS", "AUD", "AWG", "AZM", "AZN", "BAD", "BAM", "BAN", "BBD", "BDT", "BEC", "BEF", "BEL", "BGL", "BGM", "BGN", "BGO", "BHD", "BIF", "BMD", "BND", "BOB", "BOL", "BOP", "BOV", "BRB", "BRC", "BRE", "BRL", "BRN", "BRR", "BRZ", "BSD", "BTN", "BUK", "BWP", "BYB", "BYN", "BYR", "BZD", "CAD", "CDF", "CHE", "CHF", "CHW", "CLE", "CLF", "CLP", "CNH", "CNX", "CNY", "COP", "COU", "CRC", "CSD", "CSK", "CUC", "CUP", "CVE", "CYP", "CZK", "DDM", "DEM", "DJF", "DKK", "DOP", "DZD", "ECS", "ECV", "EEK", "EGP", "ERN", "ESA", "ESB", "ESP", "ETB", "EUR", "FIM", "FJD", "FKP", "FRF", "GBP", "GEK", "GEL", "GHC", "GHS", "GIP", "GMD", "GNF", "GNS", "GQE", "GRD", "GTQ", "GWE", "GWP", "GYD", "HKD", "HNL", "HRD", "HRK", "HTG", "HUF", "IDR", "IEP", "ILP", "ILR", "ILS", "INR", "IQD", "IRR", "ISJ", "ISK", "ITL", "JMD", "JOD", "JPY", "KES", "KGS", "KHR", "KMF", "KPW", "KRH", "KRO", "KRW", "KWD", "KYD", "KZT", "LAK", "LBP", "LKR", "LRD", "LSL", "LTL", "LTT", "LUC", "LUF", "LUL", "LVL", "LVR", "LYD", "MAD", "MAF", "MCF", "MDC", "MDL", "MGA", "MGF", "MKD", "MKN", "MLF", "MMK", "MNT", "MOP", "MRO", "MRU", "MTL", "MTP", "MUR", "MVP", "MVR", "MWK", "MXN", "MXP", "MXV", "MYR", "MZE", "MZM", "MZN", "NAD", "NGN", "NIC", "NIO", "NLG", "NOK", "NPR", "NZD", "OMR", "PAB", "PEI", "PEN", "PES", "PGK", "PHP", "PKR", "PLN", "PLZ", "PTE", "PYG", "QAR", "RHD", "ROL", "RON", "RSD", "RUB", "RUR", "RWF", "SAR", "SBD", "SCR", "SDD", "SDG", "SDP", "SEK", "SGD", "SHP", "SIT", "SKK", "SLL", "SOS", "SRD", "SRG", "SSP", "STD", "STN", "SUR", "SVC", "SYP", "SZL", "THB", "TJR", "TJS", "TMM", "TMT", "TND", "TOP", "TPE", "TRL", "TRY", "TTD", "TWD", "TZS", "UAH", "UAK", "UGS", "UGX", "USD", "USN", "USS", "UYI", "UYP", "UYU", "UYW", "UZS", "VEB", "VEF", "VES", "VND", "VNN", "VUV", "WST", "XAF", "XAG", "XAU", "XBA", "XBB", "XBC", "XBD", "XCD", "XDR", "XEU", "XFO", "XFU", "XOF", "XPD", "XPF", "XPT", "XRE", "XSU", "XTS", "XUA", "XXX", "YDD", "YER", "YUD", "YUM", "YUN", "YUR", "ZAL", "ZAR", "ZMK", "ZMW", "ZRN", "ZRZ", "ZWD", "ZWL", "ZWR"},
			currencyPositiveSuffix: " ",
			currencyNegativeSuffix: " ",
			monthsAbbreviated:      []string{"", "يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"},
			monthsNarrow:           []string{"", "ي", "ف", "م", "أ", "و", "ن", "ل", "غ", "س", "ك", "ب", "د"},
			monthsWide:             []string{"", "يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"},
			daysAbbreviated:        []string{"الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"},
			daysNarrow:             []string{"ح", "ن", "ث", "ر", "خ", "ج", "س"},
			daysShort:              []string{"أحد", "إثنين", "ثلاثاء", "أربعاء", "خميس", "جمعة", "سبت"},
			daysWide:               []string{"الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"},
			periodsAbbreviated:     []string{"ص", "م"},
			periodsNarrow:          []string{"ص", "م"},
			periodsWide:            []string{"ص", "م"},
			erasAbbreviated:        []string{"ق.م", "م"},
			erasNarrow:             []string{"", ""},
			erasWide:               []string{"قبل الميلاد", "ميلادي"},
			timezones:              map[string]string{"ACDT": "توقيت وسط أستراليا الصيفي", "ACST": "توقيت وسط أستراليا الرسمي", "ACWDT": "توقيت غرب وسط أستراليا الصيفي", "ACWST": "توقيت غرب وسط أستراليا الرسمي", "ADT": "التوقيت الصيفي الأطلسي", "AEDT": "توقيت شرق أستراليا الصيفي", "AEST": "توقيت شرق أستراليا الرسمي", "AKDT": "توقيت ألاسكا الصيفي", "AKST": "التوقيت الرسمي لألاسكا", "ARST": "توقيت الأرجنتين الصيفي", "ART": "توقيت الأرجنتين الرسمي", "AST": "التوقيت الرسمي الأطلسي", "AWDT": "توقيت غرب أستراليا الصيفي", "AWST": "توقيت غرب أستراليا الرسمي", "BOT": "توقيت بوليفيا", "BT": "توقيت بوتان", "CAT": "توقيت وسط أفريقيا", "CDT": "التوقيت الصيفي المركزي لأمريكا الشمالية", "CHADT": "توقيت تشاتام الصيفي", "CHAST": "توقيت تشاتام الرسمي", "CLST": "توقيت تشيلي الصيفي", "CLT": "توقيت تشيلي الرسمي", "COST": "توقيت كولومبيا الصيفي", "COT": "توقيت كولومبيا الرسمي", "CST": "التوقيت الرسمي المركزي لأمريكا الشمالية", "ChST": "توقيت تشامورو", "EAT": "توقيت شرق أفريقيا", "ECT": "توقيت الإكوادور", "EDT": "التوقيت الصيفي الشرقي لأمريكا الشمالية", "EST": "التوقيت الرسمي الشرقي لأمريكا الشمالية", "GFT": "توقيت غويانا الفرنسية", "GMT": "توقيت غرينتش", "GST": "توقيت الخليج", "GYT": "توقيت غيانا", "HADT": "توقيت هاواي ألوتيان الصيفي", "HAST": "توقيت هاواي ألوتيان الرسمي", "HAT": "توقيت نيوفاوندلاند الصيفي", "HECU": "توقيت كوبا الصيفي", "HEEG": "توقيت شرق غرينلاند الصيفي", "HENOMX": "التوقيت الصيفي لشمال غرب المكسيك", "HEOG": "توقيت غرب غرينلاند الصيفي", "HEPM": "توقيت سانت بيير وميكولون الصيفي", "HEPMX": "توقيت المحيط الهادي الصيفي للمكسيك", "HKST": "توقيت هونغ كونغ الصيفي", "HKT": "توقيت هونغ كونغ الرسمي", "HNCU": "توقيت كوبا الرسمي", "HNEG": "توقيت شرق غرينلاند الرسمي", "HNNOMX": "التوقيت الرسمي لشمال غرب المكسيك", "HNOG": "توقيت غرب غرينلاند الرسمي", "HNPM": "توقيت سانت بيير وميكولون الرسمي", "HNPMX": "توقيت المحيط الهادي الرسمي للمكسيك", "HNT": "توقيت نيوفاوندلاند الرسمي", "IST": "توقيت الهند", "JDT": "توقيت اليابان الصيفي", "JST": "توقيت اليابان الرسمي", "LHDT": "التوقيت الصيفي للورد هاو", "LHST": "توقيت لورد هاو الرسمي", "MDT": "التوقيت الجبلي الصيفي لأمريكا الشمالية", "MESZ": "توقيت وسط أوروبا الصيفي", "MEZ": "توقيت وسط أوروبا الرسمي", "MST": "التوقيت الجبلي الرسمي لأمريكا الشمالية", "MYT": "توقيت ماليزيا", "NZDT": "توقيت نيوزيلندا الصيفي", "NZST": "توقيت نيوزيلندا الرسمي", "OESZ": "توقيت شرق أوروبا الصيفي", "OEZ": "توقيت شرق أوروبا الرسمي", "PDT": "توقيت المحيط الهادي الصيفي", "PST": "توقيت المحيط الهادي الرسمي", "SAST": "توقيت جنوب أفريقيا", "SGT": "توقيت سنغافورة", "SRT": "توقيت سورينام", "TMST": "توقيت تركمانستان الصيفي", "TMT": "توقيت تركمانستان الرسمي", "UYST": "توقيت أوروغواي الصيفي", "UYT": "توقيت أوروغواي الرسمي", "VET": "توقيت فنزويلا", "WARST": "توقيت غرب الأرجنتين الصيفي", "WART": "توقيت غرب الأرجنتين الرسمي", "WAST": "توقيت غرب أفريقيا الصيفي", "WAT": "توقيت غرب أفريقيا الرسمي", "WESZ": "توقيت غرب أوروبا الصيفي", "WEZ": "توقيت غرب أوروبا الرسمي", "WIB": "توقيت غرب إندونيسيا", "WIT": "توقيت شرق إندونيسيا", "WITA": "توقيت وسط إندونيسيا", "∅∅∅": "توقيت بيرو الصيفي"},

			fnCardinalPluralRule:  fnCardinalPluralRule_f27514af189883ea7cd186156edfe998,
			fnDecimal:             fnDecimal_a78485e7dd32c95f41af4e18420793bf,
			fnFmtAccounting:       fnFmtAccounting_f74088692afba81682b73af3d3e7c19a,
			fnFmtCurrency:         fnFmtCurrency_e28d302f22cf4ed4b5009e290f74e359,
			fnFmtDateFull:         fnFmtDateFull_2d3b405215099e683568cb9c052cbd54,
			fnFmtDateLong:         fnFmtDateLong_506f643cda0514f66d873a9ea99bf639,
			fnFmtDateMedium:       fnFmtDateMedium_a55320da438aec0cfbc31bc4d718abc1,
			fnFmtDateShort:        fnFmtDateShort_05c85041b5f9b6fa224b9c4ba9be3590,
			fnFmtNumber:           fnFmtNumber_eef52ddc8fa71bd12171ac9ef3cd3328,
			fnFmtPercent:          fnFmtPercent_60ca2e9d27b8160a5fec0f6694129759,
			fnFmtTimeFull:         fnFmtTimeFull_37fe4deeee789852cc196a6a1a2f0ccc,
			fnFmtTimeLong:         fnFmtTimeLong_4429ef4fb58a2a9c4d7d5132fd16ecbf,
			fnFmtTimeMedium:       fnFmtTimeMedium_8ef07f6477b7a4944577d4e5392ff21b,
			fnFmtTimeShort:        fnFmtTimeShort_8288b817c5c0216c9815524c71c9e0b4,
			fnGroup:               fnGroup_5c4b80a5ccdee81467241784ab8fcd56,
			fnLocale:              fnLocale_5a217059c67094defae82f249f55f4c5,
			fnMinus:               fnMinus_8b8229905258388dc16a5e0c270b0488,
			fnMonthAbbreviated:    fnMonthAbbreviated_aa9a9957cd9d056ba078b36a08b17478,
			fnMonthNarrow:         fnMonthNarrow_45916040ecf6fc350894d9e3e6c46dc7,
			fnMonthWide:           fnMonthWide_4c946a7e7581c665e7407df1841810b5,
			fnMonthsAbbreviated:   fnMonthsAbbreviated_181f77804b62232997fae36bd57d6cf7,
			fnMonthsNarrow:        fnMonthsNarrow_75daa2ba82ae9577292175c3f52370cc,
			fnMonthsWide:          fnMonthsWide_0ecf36a8b72255e2fee9467af362e989,
			fnOrdinalPluralRule:   fnOrdinalPluralRule_3355865f05dde9af2a36ba415bea85cb,
			fnPluralsCardinal:     fnPluralsCardinal_85b19cac1fab9f2c2cfb9eb41539aa0e,
			fnPluralsOrdinal:      fnPluralsOrdinal_16a60aa09da9778fa82fe463e83076de,
			fnPluralsRange:        fnPluralsRange_332465bda13eb808b3664fa0500f54ce,
			fnRangePluralRule:     fnRangePluralRule_47500e2a682fd3a64da69f06f7b93c0a,
			fnWeekdayAbbreviated:  fnWeekdayAbbreviated_4ffbdfbd2be10e6bd8fb5a542a14664a,
			fnWeekdayNarrow:       fnWeekdayNarrow_e86921b3446df5ea9afe9504cfa20d1a,
			fnWeekdayShort:        fnWeekdayShort_82b231d4f504c6d71c7e495aa35cd3c2,
			fnWeekdayWide:         fnWeekdayWide_ab7e026d8685cefd89c5aeb5df512a9a,
			fnWeekdaysAbbreviated: fnWeekdaysAbbreviated_454a3d7d23c662520a64ae5245d404be,
			fnWeekdaysNarrow:      fnWeekdaysNarrow_d23eb0b7a498c40ce19d1bf231cad524,
			fnWeekdaysShort:       fnWeekdaysShort_eb6ee64d01e314991432b4469790d38b,
			fnWeekdaysWide:        fnWeekdaysWide_5e2bbf75a31e730429c100e8a0bd3ebd,
		}
	}
	translatorFuncs["ar_sa"] = func() locales.Translator {
		return &localen{

			locale:                 "ar_SA",
			pluralsCardinal:        []locales.PluralRule{1, 2, 3, 4, 5, 6},
			pluralsOrdinal:         []locales.PluralRule{6},
			pluralsRange:           []locales.PluralRule{1, 4, 5, 6},
			decimal:                "٫",
			group:                  "٬",
			minus:                  "؜-",
			percent:                "٪",
			perMille:               "؉",
			timeSeparator:          ":",
			inifinity:              "∞",
			currencies:             []string{"ADP", "AED", "AFA", "AFN", "ALK", "ALL", "AMD", "ANG", "AOA", "AOK", "AON", "AOR", "ARA", "ARL", "ARM", "ARP", "ARS", "ATS", "AUD", "AWG", "AZM", "AZN", "BAD", "BAM", "BAN", "BBD", "BDT", "BEC", "BEF", "BEL", "BGL", "BGM", "BGN", "BGO", "BHD", "BIF", "BMD", "BND", "BOB", "BOL", "BOP", "BOV", "BRB", "BRC", "BRE", "BRL", "BRN", "BRR", "BRZ", "BSD", "BTN", "BUK", "BWP", "BYB", "BYN", "BYR", "BZD", "CAD", "CDF", "CHE", "CHF", "CHW", "CLE", "CLF", "CLP", "CNH", "CNX", "CNY", "COP", "COU", "CRC", "CSD", "CSK", "CUC", "CUP", "CVE", "CYP", "CZK", "DDM", "DEM", "DJF", "DKK", "DOP", "DZD", "ECS", "ECV", "EEK", "EGP", "ERN", "ESA", "ESB", "ESP", "ETB", "EUR", "FIM", "FJD", "FKP", "FRF", "GBP", "GEK", "GEL", "GHC", "GHS", "GIP", "GMD", "GNF", "GNS", "GQE", "GRD", "GTQ", "GWE", "GWP", "GYD", "HKD", "HNL", "HRD", "HRK", "HTG", "HUF", "IDR", "IEP", "ILP", "ILR", "ILS", "INR", "IQD", "IRR", "ISJ", "ISK", "ITL", "JMD", "JOD", "JPY", "KES", "KGS", "KHR", "KMF", "KPW", "KRH", "KRO", "KRW", "KWD", "KYD", "KZT", "LAK", "LBP", "LKR", "LRD", "LSL", "LTL", "LTT", "LUC", "LUF", "LUL", "LVL", "LVR", "LYD", "MAD", "MAF", "MCF", "MDC", "MDL", "MGA", "MGF", "MKD", "MKN", "MLF", "MMK", "MNT", "MOP", "MRO", "MRU", "MTL", "MTP", "MUR", "MVP", "MVR", "MWK", "MXN", "MXP", "MXV", "MYR", "MZE", "MZM", "MZN", "NAD", "NGN", "NIC", "NIO", "NLG", "NOK", "NPR", "NZD", "OMR", "PAB", "PEI", "PEN", "PES", "PGK", "PHP", "PKR", "PLN", "PLZ", "PTE", "PYG", "QAR", "RHD", "ROL", "RON", "RSD", "RUB", "RUR", "RWF", "SAR", "SBD", "SCR", "SDD", "SDG", "SDP", "SEK", "SGD", "SHP", "SIT", "SKK", "SLL", "SOS", "SRD", "SRG", "SSP", "STD", "STN", "SUR", "SVC", "SYP", "SZL", "THB", "TJR", "TJS", "TMM", "TMT", "TND", "TOP", "TPE", "TRL", "TRY", "TTD", "TWD", "TZS", "UAH", "UAK", "UGS", "UGX", "USD", "USN", "USS", "UYI", "UYP", "UYU", "UYW", "UZS", "VEB", "VEF", "VES", "VND", "VNN", "VUV", "WST", "XAF", "XAG", "XAU", "XBA", "XBB", "XBC", "XBD", "XCD", "XDR", "XEU", "XFO", "XFU", "XOF", "XPD", "XPF", "XPT", "XRE", "XSU", "XTS", "XUA", "XXX", "YDD", "YER", "YUD", "YUM", "YUN", "YUR", "ZAL", "ZAR", "ZMK", "ZMW", "ZRN", "ZRZ", "ZWD", "ZWL", "ZWR"},
			currencyPositiveSuffix: " ",
			currencyNegativeSuffix: " ",
			monthsAbbreviated:      []string{"", "يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"},
			monthsNarrow:           []string{"", "ي", "ف", "م", "أ", "و", "ن", "ل", "غ", "س", "ك", "ب", "د"},
			monthsWide:             []string{"", "يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"},
			daysAbbreviated:        []string{"الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"},
			daysNarrow:             []string{"ح", "ن", "ث", "ر", "خ", "ج", "س"},
			daysShort:              []string{"أحد", "إثنين", "ثلاثاء", "أربعاء", "خميس", "جمعة", "سبت"},
			daysWide:               []string{"الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"},
			periodsAbbreviated:     []string{"", ""},
			periodsNarrow:          []string{"ص", "م"},
			periodsWide:            []string{"ص", "م"},
			erasAbbreviated:        []string{"ق.م", "م"},
			erasNarrow:             []string{"", ""},
			erasWide:               []string{"قبل الميلاد", "ميلادي"},
			timezones:              map[string]string{"ACDT": "توقيت وسط أستراليا الصيفي", "ACST": "توقيت وسط أستراليا الرسمي", "ACWDT": "توقيت غرب وسط أستراليا الصيفي", "ACWST": "توقيت غرب وسط أستراليا الرسمي", "ADT": "التوقيت الصيفي الأطلسي", "AEDT": "توقيت شرق أستراليا الصيفي", "AEST": "توقيت شرق أستراليا الرسمي", "AKDT": "توقيت ألاسكا الصيفي", "AKST": "التوقيت الرسمي لألاسكا", "ARST": "توقيت الأرجنتين الصيفي", "ART": "توقيت الأرجنتين الرسمي", "AST": "التوقيت الرسمي الأطلسي", "AWDT": "توقيت غرب أستراليا الصيفي", "AWST": "توقيت غرب أستراليا الرسمي", "BOT": "توقيت بوليفيا", "BT": "توقيت بوتان", "CAT": "توقيت وسط أفريقيا", "CDT": "التوقيت الصيفي المركزي لأمريكا الشمالية", "CHADT": "توقيت تشاتام الصيفي", "CHAST": "توقيت تشاتام الرسمي", "CLST": "توقيت تشيلي الصيفي", "CLT": "توقيت تشيلي الرسمي", "COST": "توقيت كولومبيا الصيفي", "COT": "توقيت كولومبيا الرسمي", "CST": "التوقيت الرسمي المركزي لأمريكا الشمالية", "ChST": "توقيت تشامورو", "EAT": "توقيت شرق أفريقيا", "ECT": "توقيت الإكوادور", "EDT": "التوقيت الصيفي الشرقي لأمريكا الشمالية", "EST": "التوقيت الرسمي الشرقي لأمريكا الشمالية", "GFT": "توقيت غويانا الفرنسية", "GMT": "توقيت غرينتش", "GST": "توقيت الخليج", "GYT": "توقيت غيانا", "HADT": "توقيت هاواي ألوتيان الصيفي", "HAST": "توقيت هاواي ألوتيان الرسمي", "HAT": "توقيت نيوفاوندلاند الصيفي", "HECU": "توقيت كوبا الصيفي", "HEEG": "توقيت شرق غرينلاند الصيفي", "HENOMX": "التوقيت الصيفي لشمال غرب المكسيك", "HEOG": "توقيت غرب غرينلاند الصيفي", "HEPM": "توقيت سانت بيير وميكولون الصيفي", "HEPMX": "توقيت المحيط الهادي الصيفي للمكسيك", "HKST": "توقيت هونغ كونغ الصيفي", "HKT": "توقيت هونغ كونغ الرسمي", "HNCU": "توقيت كوبا الرسمي", "HNEG": "توقيت شرق غرينلاند الرسمي", "HNNOMX": "التوقيت الرسمي لشمال غرب المكسيك", "HNOG": "توقيت غرب غرينلاند الرسمي", "HNPM": "توقيت سانت بيير وميكولون الرسمي", "HNPMX": "توقيت المحيط الهادي الرسمي للمكسيك", "HNT": "توقيت نيوفاوندلاند الرسمي", "IST": "توقيت الهند", "JDT": "توقيت اليابان الصيفي", "JST": "توقيت اليابان الرسمي", "LHDT": "التوقيت الصيفي للورد هاو", "LHST": "توقيت لورد هاو الرسمي", "MDT": "التوقيت الجبلي الصيفي لأمريكا الشمالية", "MESZ": "توقيت وسط أوروبا الصيفي", "MEZ": "توقيت وسط أوروبا الرسمي", "MST": "التوقيت الجبلي الرسمي لأمريكا الشمالية", "MYT": "توقيت ماليزيا", "NZDT": "توقيت نيوزيلندا الصيفي", "NZST": "توقيت نيوزيلندا الرسمي", "OESZ": "توقيت شرق أوروبا الصيفي", "OEZ": "توقيت شرق أوروبا الرسمي", "PDT": "توقيت المحيط الهادي الصيفي", "PST": "توقيت المحيط الهادي الرسمي", "SAST": "توقيت جنوب أفريقيا", "SGT": "توقيت سنغافورة", "SRT": "توقيت سورينام", "TMST": "توقيت تركمانستان الصيفي", "TMT": "توقيت تركمانستان الرسمي", "UYST": "توقيت أوروغواي الصيفي", "UYT": "توقيت أوروغواي الرسمي", "VET": "توقيت فنزويلا", "WARST": "توقيت غرب الأرجنتين الصيفي", "WART": "توقيت غرب الأرجنتين الرسمي", "WAST": "توقيت غرب أفريقيا الصيفي", "WAT": "توقيت غرب أفريقيا الرسمي", "WESZ": "توقيت غرب أوروبا الصيفي", "WEZ": "توقيت غرب أوروبا الرسمي", "WIB": "توقيت غرب إندونيسيا", "WIT": "توقيت شرق إندونيسيا", "WITA": "توقيت وسط إندونيسيا", "∅∅∅": "توقيت برازيليا الصيفي"},

			fnCardinalPluralRule:  fnCardinalPluralRule_f27514af189883ea7cd186156edfe998,
			fnDecimal:             fnDecimal_a78485e7dd32c95f41af4e18420793bf,
			fnFmtAccounting:       fnFmtAccounting_f74088692afba81682b73af3d3e7c19a,
			fnFmtCurrency:         fnFmtCurrency_e28d302f22cf4ed4b5009e290f74e359,
			fnFmtDateFull:         fnFmtDateFull_2d3b405215099e683568cb9c052cbd54,
			fnFmtDateLong:         fnFmtDateLong_506f643cda0514f66d873a9ea99bf639,
			fnFmtDateMedium:       fnFmtDateMedium_a55320da438aec0cfbc31bc4d718abc1,
			fnFmtDateShort:        fnFmtDateShort_05c85041b5f9b6fa224b9c4ba9be3590,
			fnFmtNumber:           fnFmtNumber_eef52ddc8fa71bd12171ac9ef3cd3328,
			fnFmtPercent:          fnFmtPercent_f074e0c8dff3d1b13a6f552a71cedb58,
			fnFmtTimeFull:         fnFmtTimeFull_37fe4deeee789852cc196a6a1a2f0ccc,
			fnFmtTimeLong:         fnFmtTimeLong_4429ef4fb58a2a9c4d7d5132fd16ecbf,
			fnFmtTimeMedium:       fnFmtTimeMedium_8ef07f6477b7a4944577d4e5392ff21b,
			fnFmtTimeShort:        fnFmtTimeShort_8288b817c5c0216c9815524c71c9e0b4,
			fnGroup:               fnGroup_5c4b80a5ccdee81467241784ab8fcd56,
			fnLocale:              fnLocale_5a217059c67094defae82f249f55f4c5,
			fnMinus:               fnMinus_8b8229905258388dc16a5e0c270b0488,
			fnMonthAbbreviated:    fnMonthAbbreviated_aa9a9957cd9d056ba078b36a08b17478,
			fnMonthNarrow:         fnMonthNarrow_45916040ecf6fc350894d9e3e6c46dc7,
			fnMonthWide:           fnMonthWide_4c946a7e7581c665e7407df1841810b5,
			fnMonthsAbbreviated:   fnMonthsAbbreviated_181f77804b62232997fae36bd57d6cf7,
			fnMonthsNarrow:        fnMonthsNarrow_75daa2ba82ae9577292175c3f52370cc,
			fnMonthsWide:          fnMonthsWide_0ecf36a8b72255e2fee9467af362e989,
			fnOrdinalPluralRule:   fnOrdinalPluralRule_3355865f05dde9af2a36ba415bea85cb,
			fnPluralsCardinal:     fnPluralsCardinal_85b19cac1fab9f2c2cfb9eb41539aa0e,
			fnPluralsOrdinal:      fnPluralsOrdinal_16a60aa09da9778fa82fe463e83076de,
			fnPluralsRange:        fnPluralsRange_332465bda13eb808b3664fa0500f54ce,
			fnRangePluralRule:     fnRangePluralRule_47500e2a682fd3a64da69f06f7b93c0a,
			fnWeekdayAbbreviated:  fnWeekdayAbbreviated_4ffbdfbd2be10e6bd8fb5a542a14664a,
			fnWeekdayNarrow:       fnWeekdayNarrow_e86921b3446df5ea9afe9504cfa20d1a,
			fnWeekdayShort:        fnWeekdayShort_82b231d4f504c6d71c7e495aa35cd3c2,
			fnWeekdayWide:         fnWeekdayWide_ab7e026d8685cefd89c5aeb5df512a9a,
			fnWeekdaysAbbreviated: fnWeekdaysAbbreviated_454a3d7d23c662520a64ae5245d404be,
			fnWeekdaysNarrow:      fnWeekdaysNarrow_d23eb0b7a498c40ce19d1bf231cad524,
			fnWeekdaysShort:       fnWeekdaysShort_eb6ee64d01e314991432b4469790d38b,
			fnWeekdaysWide:        fnWeekdaysWide_5e2bbf75a31e730429c100e8a0bd3ebd,
		}
	}
	translatorFuncs["ar_sd"] = func() locales.Translator {
		return &localen{

			locale:                 "ar_SD",
			pluralsCardinal:        []locales.PluralRule{1, 2, 3, 4, 5, 6},
			pluralsOrdinal:         []locales.PluralRule{6},
			pluralsRange:           []locales.PluralRule{1, 4, 5, 6},
			decimal:                "٫",
			group:                  "٬",
			minus:                  "؜-",
			percent:                "٪؜",
			perMille:               "؉",
			timeSeparator:          ":",
			inifinity:              "∞",
			currencies:             []string{"ADP", "AED", "AFA", "AFN", "ALK", "ALL", "AMD", "ANG", "AOA", "AOK", "AON", "AOR", "ARA", "ARL", "ARM", "ARP", "ARS", "ATS", "AUD", "AWG", "AZM", "AZN", "BAD", "BAM", "BAN", "BBD", "BDT", "BEC", "BEF", "BEL", "BGL", "BGM", "BGN", "BGO", "BHD", "BIF", "BMD", "BND", "BOB", "BOL", "BOP", "BOV", "BRB", "BRC", "BRE", "BRL", "BRN", "BRR", "BRZ", "BSD", "BTN", "BUK", "BWP", "BYB", "BYN", "BYR", "BZD", "CAD", "CDF", "CHE", "CHF", "CHW", "CLE", "CLF", "CLP", "CNH", "CNX", "CNY", "COP", "COU", "CRC", "CSD", "CSK", "CUC", "CUP", "CVE", "CYP", "CZK", "DDM", "DEM", "DJF", "DKK", "DOP", "DZD", "ECS", "ECV", "EEK", "EGP", "ERN", "ESA", "ESB", "ESP", "ETB", "EUR", "FIM", "FJD", "FKP", "FRF", "GBP", "GEK", "GEL", "GHC", "GHS", "GIP", "GMD", "GNF", "GNS", "GQE", "GRD", "GTQ", "GWE", "GWP", "GYD", "HKD", "HNL", "HRD", "HRK", "HTG", "HUF", "IDR", "IEP", "ILP", "ILR", "ILS", "INR", "IQD", "IRR", "ISJ", "ISK", "ITL", "JMD", "JOD", "JPY", "KES", "KGS", "KHR", "KMF", "KPW", "KRH", "KRO", "KRW", "KWD", "KYD", "KZT", "LAK", "LBP", "LKR", "LRD", "LSL", "LTL", "LTT", "LUC", "LUF", "LUL", "LVL", "LVR", "LYD", "MAD", "MAF", "MCF", "MDC", "MDL", "MGA", "MGF", "MKD", "MKN", "MLF", "MMK", "MNT", "MOP", "MRO", "MRU", "MTL", "MTP", "MUR", "MVP", "MVR", "MWK", "MXN", "MXP", "MXV", "MYR", "MZE", "MZM", "MZN", "NAD", "NGN", "NIC", "NIO", "NLG", "NOK", "NPR", "NZD", "OMR", "PAB", "PEI", "PEN", "PES", "PGK", "PHP", "PKR", "PLN", "PLZ", "PTE", "PYG", "QAR", "RHD", "ROL", "RON", "RSD", "RUB", "RUR", "RWF", "SAR", "SBD", "SCR", "SDD", "SDG", "SDP", "SEK", "SGD", "SHP", "SIT", "SKK", "SLL", "SOS", "SRD", "SRG", "SSP", "STD", "STN", "SUR", "SVC", "SYP", "SZL", "THB", "TJR", "TJS", "TMM", "TMT", "TND", "TOP", "TPE", "TRL", "TRY", "TTD", "TWD", "TZS", "UAH", "UAK", "UGS", "UGX", "USD", "USN", "USS", "UYI", "UYP", "UYU", "UYW", "UZS", "VEB", "VEF", "VES", "VND", "VNN", "VUV", "WST", "XAF", "XAG", "XAU", "XBA", "XBB", "XBC", "XBD", "XCD", "XDR", "XEU", "XFO", "XFU", "XOF", "XPD", "XPF", "XPT", "XRE", "XSU", "XTS", "XUA", "XXX", "YDD", "YER", "YUD", "YUM", "YUN", "YUR", "ZAL", "ZAR", "ZMK", "ZMW", "ZRN", "ZRZ", "ZWD", "ZWL", "ZWR"},
			currencyPositiveSuffix: " ",
			currencyNegativeSuffix: " ",
			monthsAbbreviated:      []string{"", "يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"},
			monthsNarrow:           []string{"", "ي", "ف", "م", "أ", "و", "ن", "ل", "غ", "س", "ك", "ب", "د"},
			monthsWide:             []string{"", "يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"},
			daysAbbreviated:        []string{"الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"},
			daysNarrow:             []string{"ح", "ن", "ث", "ر", "خ", "ج", "س"},
			daysShort:              []string{"أحد", "إثنين", "ثلاثاء", "أربعاء", "خميس", "جمعة", "سبت"},
			daysWide:               []string{"الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"},
			periodsAbbreviated:     []string{"ص", "م"},
			periodsNarrow:          []string{"ص", "م"},
			periodsWide:            []string{"ص", "م"},
			erasAbbreviated:        []string{"ق.م", "م"},
			erasNarrow:             []string{"", ""},
			erasWide:               []string{"قبل الميلاد", "ميلادي"},
			timezones:              map[string]string{"ACDT": "توقيت وسط أستراليا الصيفي", "ACST": "توقيت وسط أستراليا الرسمي", "ACWDT": "توقيت غرب وسط أستراليا الصيفي", "ACWST": "توقيت غرب وسط أستراليا الرسمي", "ADT": "التوقيت الصيفي الأطلسي", "AEDT": "توقيت شرق أستراليا الصيفي", "AEST": "توقيت شرق أستراليا الرسمي", "AKDT": "توقيت ألاسكا الصيفي", "AKST": "التوقيت الرسمي لألاسكا", "ARST": "توقيت الأرجنتين الصيفي", "ART": "توقيت الأرجنتين الرسمي", "AST": "التوقيت الرسمي الأطلسي", "AWDT": "توقيت غرب أستراليا الصيفي", "AWST": "توقيت غرب أستراليا الرسمي", "BOT": "توقيت بوليفيا", "BT": "توقيت بوتان", "CAT": "توقيت وسط أفريقيا", "CDT": "التوقيت الصيفي المركزي لأمريكا الشمالية", "CHADT": "توقيت تشاتام الصيفي", "CHAST": "توقيت تشاتام الرسمي", "CLST": "توقيت تشيلي الصيفي", "CLT": "توقيت تشيلي الرسمي", "COST": "توقيت كولومبيا الصيفي", "COT": "توقيت كولومبيا الرسمي", "CST": "التوقيت الرسمي المركزي لأمريكا الشمالية", "ChST": "توقيت تشامورو", "EAT": "توقيت شرق أفريقيا", "ECT": "توقيت الإكوادور", "EDT": "التوقيت الصيفي الشرقي لأمريكا الشمالية", "EST": "التوقيت الرسمي الشرقي لأمريكا الشمالية", "GFT": "توقيت غويانا الفرنسية", "GMT": "توقيت غرينتش", "GST": "توقيت الخليج", "GYT": "توقيت غيانا", "HADT": "توقيت هاواي ألوتيان الصيفي", "HAST": "توقيت هاواي ألوتيان الرسمي", "HAT": "توقيت نيوفاوندلاند الصيفي", "HECU": "توقيت كوبا الصيفي", "HEEG": "توقيت شرق غرينلاند الصيفي", "HENOMX": "التوقيت الصيفي لشمال غرب المكسيك", "HEOG": "توقيت غرب غرينلاند الصيفي", "HEPM": "توقيت سانت بيير وميكولون الصيفي", "HEPMX": "توقيت المحيط الهادي الصيفي للمكسيك", "HKST": "توقيت هونغ كونغ الصيفي", "HKT": "توقيت هونغ كونغ الرسمي", "HNCU": "توقيت كوبا الرسمي", "HNEG": "توقيت شرق غرينلاند الرسمي", "HNNOMX": "التوقيت الرسمي لشمال غرب المكسيك", "HNOG": "توقيت غرب غرينلاند الرسمي", "HNPM": "توقيت سانت بيير وميكولون الرسمي", "HNPMX": "توقيت المحيط الهادي الرسمي للمكسيك", "HNT": "توقيت نيوفاوندلاند الرسمي", "IST": "توقيت الهند", "JDT": "توقيت اليابان الصيفي", "JST": "توقيت اليابان الرسمي", "LHDT": "التوقيت الصيفي للورد هاو", "LHST": "توقيت لورد هاو الرسمي", "MDT": "التوقيت الجبلي الصيفي لأمريكا الشمالية", "MESZ": "توقيت وسط أوروبا الصيفي", "MEZ": "توقيت وسط أوروبا الرسمي", "MST": "التوقيت الجبلي الرسمي لأمريكا الشمالية", "MYT": "توقيت ماليزيا", "NZDT": "توقيت نيوزيلندا الصيفي", "NZST": "توقيت نيوزيلندا الرسمي", "OESZ": "توقيت شرق أوروبا الصيفي", "OEZ": "توقيت شرق أوروبا الرسمي", "PDT": "توقيت المحيط الهادي الصيفي", "PST": "توقيت المحيط الهادي الرسمي", "SAST": "توقيت جنوب أفريقيا", "SGT": "توقيت سنغافورة", "SRT": "توقيت سورينام", "TMST": "توقيت تركمانستان الصيفي", "TMT": "توقيت تركمانستان الرسمي", "UYST": "توقيت أوروغواي الصيفي", "UYT": "توقيت أوروغواي الرسمي", "VET": "توقيت فنزويلا", "WARST": "توقيت غرب الأرجنتين الصيفي", "WART": "توقيت غرب الأرجنتين الرسمي", "WAST": "توقيت غرب أفريقيا الصيفي", "WAT": "توقيت غرب أفريقيا الرسمي", "WESZ": "توقيت غرب أوروبا الصيفي", "WEZ": "توقيت غرب أوروبا الرسمي", "WIB": "توقيت غرب إندونيسيا", "WIT": "توقيت شرق إندونيسيا", "WITA": "توقيت وسط إندونيسيا", "∅∅∅": "توقيت أزورس الصيفي"},

			fnCardinalPluralRule:  fnCardinalPluralRule_f27514af189883ea7cd186156edfe998,
			fnDecimal:             fnDecimal_a78485e7dd32c95f41af4e18420793bf,
			fnFmtAccounting:       fnFmtAccounting_f74088692afba81682b73af3d3e7c19a,
			fnFmtCurrency:         fnFmtCurrency_e28d302f22cf4ed4b5009e290f74e359,
			fnFmtDateFull:         fnFmtDateFull_2d3b405215099e683568cb9c052cbd54,
			fnFmtDateLong:         fnFmtDateLong_506f643cda0514f66d873a9ea99bf639,
			fnFmtDateMedium:       fnFmtDateMedium_a55320da438aec0cfbc31bc4d718abc1,
			fnFmtDateShort:        fnFmtDateShort_05c85041b5f9b6fa224b9c4ba9be3590,
			fnFmtNumber:           fnFmtNumber_eef52ddc8fa71bd12171ac9ef3cd3328,
			fnFmtPercent:          fnFmtPercent_60ca2e9d27b8160a5fec0f6694129759,
			fnFmtTimeFull:         fnFmtTimeFull_37fe4deeee789852cc196a6a1a2f0ccc,
			fnFmtTimeLong:         fnFmtTimeLong_4429ef4fb58a2a9c4d7d5132fd16ecbf,
			fnFmtTimeMedium:       fnFmtTimeMedium_8ef07f6477b7a4944577d4e5392ff21b,
			fnFmtTimeShort:        fnFmtTimeShort_8288b817c5c0216c9815524c71c9e0b4,
			fnGroup:               fnGroup_5c4b80a5ccdee81467241784ab8fcd56,
			fnLocale:              fnLocale_5a217059c67094defae82f249f55f4c5,
			fnMinus:               fnMinus_8b8229905258388dc16a5e0c270b0488,
			fnMonthAbbreviated:    fnMonthAbbreviated_aa9a9957cd9d056ba078b36a08b17478,
			fnMonthNarrow:         fnMonthNarrow_45916040ecf6fc350894d9e3e6c46dc7,
			fnMonthWide:           fnMonthWide_4c946a7e7581c665e7407df1841810b5,
			fnMonthsAbbreviated:   fnMonthsAbbreviated_181f77804b62232997fae36bd57d6cf7,
			fnMonthsNarrow:        fnMonthsNarrow_75daa2ba82ae9577292175c3f52370cc,
			fnMonthsWide:          fnMonthsWide_0ecf36a8b72255e2fee9467af362e989,
			fnOrdinalPluralRule:   fnOrdinalPluralRule_3355865f05dde9af2a36ba415bea85cb,
			fnPluralsCardinal:     fnPluralsCardinal_85b19cac1fab9f2c2cfb9eb41539aa0e,
			fnPluralsOrdinal:      fnPluralsOrdinal_16a60aa09da9778fa82fe463e83076de,
			fnPluralsRange:        fnPluralsRange_332465bda13eb808b3664fa0500f54ce,
			fnRangePluralRule:     fnRangePluralRule_47500e2a682fd3a64da69f06f7b93c0a,
			fnWeekdayAbbreviated:  fnWeekdayAbbreviated_4ffbdfbd2be10e6bd8fb5a542a14664a,
			fnWeekdayNarrow:       fnWeekdayNarrow_e86921b3446df5ea9afe9504cfa20d1a,
			fnWeekdayShort:        fnWeekdayShort_82b231d4f504c6d71c7e495aa35cd3c2,
			fnWeekdayWide:         fnWeekdayWide_ab7e026d8685cefd89c5aeb5df512a9a,
			fnWeekdaysAbbreviated: fnWeekdaysAbbreviated_454a3d7d23c662520a64ae5245d404be,
			fnWeekdaysNarrow:      fnWeekdaysNarrow_d23eb0b7a498c40ce19d1bf231cad524,
			fnWeekdaysShort:       fnWeekdaysShort_eb6ee64d01e314991432b4469790d38b,
			fnWeekdaysWide:        fnWeekdaysWide_5e2bbf75a31e730429c100e8a0bd3ebd,
		}
	}
	translatorFuncs["ar_so"] = func() locales.Translator {
		return &localen{

			locale:                 "ar_SO",
			pluralsCardinal:        []locales.PluralRule{1, 2, 3, 4, 5, 6},
			pluralsOrdinal:         []locales.PluralRule{6},
			pluralsRange:           []locales.PluralRule{1, 4, 5, 6},
			decimal:                "٫",
			group:                  "٬",
			minus:                  "؜-",
			percent:                "٪",
			perMille:               "؉",
			timeSeparator:          ":",
			inifinity:              "∞",
			currencies:             []string{"ADP", "AED", "AFA", "AFN", "ALK", "ALL", "AMD", "ANG", "AOA", "AOK", "AON", "AOR", "ARA", "ARL", "ARM", "ARP", "ARS", "ATS", "AUD", "AWG", "AZM", "AZN", "BAD", "BAM", "BAN", "BBD", "BDT", "BEC", "BEF", "BEL", "BGL", "BGM", "BGN", "BGO", "BHD", "BIF", "BMD", "BND", "BOB", "BOL", "BOP", "BOV", "BRB", "BRC", "BRE", "BRL", "BRN", "BRR", "BRZ", "BSD", "BTN", "BUK", "BWP", "BYB", "BYN", "BYR", "BZD", "CAD", "CDF", "CHE", "CHF", "CHW", "CLE", "CLF", "CLP", "CNH", "CNX", "CNY", "COP", "COU", "CRC", "CSD", "CSK", "CUC", "CUP", "CVE", "CYP", "CZK", "DDM", "DEM", "DJF", "DKK", "DOP", "DZD", "ECS", "ECV", "EEK", "EGP", "ERN", "ESA", "ESB", "ESP", "ETB", "EUR", "FIM", "FJD", "FKP", "FRF", "GBP", "GEK", "GEL", "GHC", "GHS", "GIP", "GMD", "GNF", "GNS", "GQE", "GRD", "GTQ", "GWE", "GWP", "GYD", "HKD", "HNL", "HRD", "HRK", "HTG", "HUF", "IDR", "IEP", "ILP", "ILR", "ILS", "INR", "IQD", "IRR", "ISJ", "ISK", "ITL", "JMD", "JOD", "JPY", "KES", "KGS", "KHR", "KMF", "KPW", "KRH", "KRO", "KRW", "KWD", "KYD", "KZT", "LAK", "LBP", "LKR", "LRD", "LSL", "LTL", "LTT", "LUC", "LUF", "LUL", "LVL", "LVR", "LYD", "MAD", "MAF", "MCF", "MDC", "MDL", "MGA", "MGF", "MKD", "MKN", "MLF", "MMK", "MNT", "MOP", "MRO", "MRU", "MTL", "MTP", "MUR", "MVP", "MVR", "MWK", "MXN", "MXP", "MXV", "MYR", "MZE", "MZM", "MZN", "NAD", "NGN", "NIC", "NIO", "NLG", "NOK", "NPR", "NZD", "OMR", "PAB", "PEI", "PEN", "PES", "PGK", "PHP", "PKR", "PLN", "PLZ", "PTE", "PYG", "QAR", "RHD", "ROL", "RON", "RSD", "RUB", "RUR", "RWF", "SAR", "SBD", "SCR", "SDD", "SDG", "SDP", "SEK", "SGD", "SHP", "SIT", "SKK", "SLL", "S", "SRD", "SRG", "SSP", "STD", "STN", "SUR", "SVC", "SYP", "SZL", "THB", "TJR", "TJS", "TMM", "TMT", "TND", "TOP", "TPE", "TRL", "TRY", "TTD", "TWD", "TZS", "UAH", "UAK", "UGS", "UGX", "USD", "USN", "USS", "UYI", "UYP", "UYU", "UYW", "UZS", "VEB", "VEF", "VES", "VND", "VNN", "VUV", "WST", "XAF", "XAG", "XAU", "XBA", "XBB", "XBC", "XBD", "XCD", "XDR", "XEU", "XFO", "XFU", "XOF", "XPD", "XPF", "XPT", "XRE", "XSU", "XTS", "XUA", "XXX", "YDD", "YER", "YUD", "YUM", "YUN", "YUR", "ZAL", "ZAR", "ZMK", "ZMW", "ZRN", "ZRZ", "ZWD", "ZWL", "ZWR"},
			currencyPositiveSuffix: " ",
			currencyNegativeSuffix: " ",
			monthsAbbreviated:      []string{"", "يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"},
			monthsNarrow:           []string{"", "ي", "ف", "م", "أ", "و", "ن", "ل", "غ", "س", "ك", "ب", "د"},
			monthsWide:             []string{"", "يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"},
			daysAbbreviated:        []string{"الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"},
			daysNarrow:             []string{"ح", "ن", "ث", "ر", "خ", "ج", "س"},
			daysShort:              []string{"أحد", "إثنين", "ثلاثاء", "أربعاء", "خميس", "جمعة", "سبت"},
			daysWide:               []string{"الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"},
			periodsAbbreviated:     []string{"ص", "م"},
			periodsNarrow:          []string{"ص", "م"},
			periodsWide:            []string{"ص", "م"},
			erasAbbreviated:        []string{"ق.م", "م"},
			erasNarrow:             []string{"", ""},
			erasWide:               []string{"قبل الميلاد", "ميلادي"},
			timezones:              map[string]string{"ACDT": "توقيت وسط أستراليا الصيفي", "ACST": "توقيت وسط أستراليا الرسمي", "ACWDT": "توقيت غرب وسط أستراليا الصيفي", "ACWST": "توقيت غرب وسط أستراليا الرسمي", "ADT": "التوقيت الصيفي الأطلسي", "AEDT": "توقيت شرق أستراليا الصيفي", "AEST": "توقيت شرق أستراليا الرسمي", "AKDT": "توقيت ألاسكا الصيفي", "AKST": "التوقيت الرسمي لألاسكا", "ARST": "توقيت الأرجنتين الصيفي", "ART": "توقيت الأرجنتين الرسمي", "AST": "التوقيت الرسمي الأطلسي", "AWDT": "توقيت غرب أستراليا الصيفي", "AWST": "توقيت غرب أستراليا الرسمي", "BOT": "توقيت بوليفيا", "BT": "توقيت بوتان", "CAT": "توقيت وسط أفريقيا", "CDT": "التوقيت الصيفي المركزي لأمريكا الشمالية", "CHADT": "توقيت تشاتام الصيفي", "CHAST": "توقيت تشاتام الرسمي", "CLST": "توقيت تشيلي الصيفي", "CLT": "توقيت تشيلي الرسمي", "COST": "توقيت كولومبيا الصيفي", "COT": "توقيت كولومبيا الرسمي", "CST": "التوقيت الرسمي المركزي لأمريكا الشمالية", "ChST": "توقيت تشامورو", "EAT": "توقيت شرق أفريقيا", "ECT": "توقيت الإكوادور", "EDT": "التوقيت الصيفي الشرقي لأمريكا الشمالية", "EST": "التوقيت الرسمي الشرقي لأمريكا الشمالية", "GFT": "توقيت غويانا الفرنسية", "GMT": "توقيت غرينتش", "GST": "توقيت الخليج", "GYT": "توقيت غيانا", "HADT": "توقيت هاواي ألوتيان الصيفي", "HAST": "توقيت هاواي ألوتيان الرسمي", "HAT": "توقيت نيوفاوندلاند الصيفي", "HECU": "توقيت كوبا الصيفي", "HEEG": "توقيت شرق غرينلاند الصيفي", "HENOMX": "التوقيت الصيفي لشمال غرب المكسيك", "HEOG": "توقيت غرب غرينلاند الصيفي", "HEPM": "توقيت سانت بيير وميكولون الصيفي", "HEPMX": "توقيت المحيط الهادي الصيفي للمكسيك", "HKST": "توقيت هونغ كونغ الصيفي", "HKT": "توقيت هونغ كونغ الرسمي", "HNCU": "توقيت كوبا الرسمي", "HNEG": "توقيت شرق غرينلاند الرسمي", "HNNOMX": "التوقيت الرسمي لشمال غرب المكسيك", "HNOG": "توقيت غرب غرينلاند الرسمي", "HNPM": "توقيت سانت بيير وميكولون الرسمي", "HNPMX": "توقيت المحيط الهادي الرسمي للمكسيك", "HNT": "توقيت نيوفاوندلاند الرسمي", "IST": "توقيت الهند", "JDT": "توقيت اليابان الصيفي", "JST": "توقيت اليابان الرسمي", "LHDT": "التوقيت الصيفي للورد هاو", "LHST": "توقيت لورد هاو الرسمي", "MDT": "التوقيت الجبلي الصيفي لأمريكا الشمالية", "MESZ": "توقيت وسط أوروبا الصيفي", "MEZ": "توقيت وسط أوروبا الرسمي", "MST": "التوقيت الجبلي الرسمي لأمريكا الشمالية", "MYT": "توقيت ماليزيا", "NZDT": "توقيت نيوزيلندا الصيفي", "NZST": "توقيت نيوزيلندا الرسمي", "OESZ": "توقيت شرق أوروبا الصيفي", "OEZ": "توقيت شرق أوروبا الرسمي", "PDT": "توقيت المحيط الهادي الصيفي", "PST": "توقيت المحيط الهادي الرسمي", "SAST": "توقيت جنوب أفريقيا", "SGT": "توقيت سنغافورة", "SRT": "توقيت سورينام", "TMST": "توقيت تركمانستان الصيفي", "TMT": "توقيت تركمانستان الرسمي", "UYST": "توقيت أوروغواي الصيفي", "UYT": "توقيت أوروغواي الرسمي", "VET": "توقيت فنزويلا", "WARST": "توقيت غرب الأرجنتين الصيفي", "WART": "توقيت غرب الأرجنتين الرسمي", "WAST": "توقيت غرب أفريقيا الصيفي", "WAT": "توقيت غرب أفريقيا الرسمي", "WESZ": "توقيت غرب أوروبا الصيفي", "WEZ": "توقيت غرب أوروبا الرسمي", "WIB": "توقيت غرب إندونيسيا", "WIT": "توقيت شرق إندونيسيا", "WITA": "توقيت وسط إندونيسيا", "∅∅∅": "توقيت برازيليا الصيفي"},

			fnCardinalPluralRule:  fnCardinalPluralRule_f27514af189883ea7cd186156edfe998,
			fnDecimal:             fnDecimal_a78485e7dd32c95f41af4e18420793bf,
			fnFmtAccounting:       fnFmtAccounting_f74088692afba81682b73af3d3e7c19a,
			fnFmtCurrency:         fnFmtCurrency_e28d302f22cf4ed4b5009e290f74e359,
			fnFmtDateFull:         fnFmtDateFull_2d3b405215099e683568cb9c052cbd54,
			fnFmtDateLong:         fnFmtDateLong_506f643cda0514f66d873a9ea99bf639,
			fnFmtDateMedium:       fnFmtDateMedium_a55320da438aec0cfbc31bc4d718abc1,
			fnFmtDateShort:        fnFmtDateShort_05c85041b5f9b6fa224b9c4ba9be3590,
			fnFmtNumber:           fnFmtNumber_eef52ddc8fa71bd12171ac9ef3cd3328,
			fnFmtPercent:          fnFmtPercent_f074e0c8dff3d1b13a6f552a71cedb58,
			fnFmtTimeFull:         fnFmtTimeFull_37fe4deeee789852cc196a6a1a2f0ccc,
			fnFmtTimeLong:         fnFmtTimeLong_4429ef4fb58a2a9c4d7d5132fd16ecbf,
			fnFmtTimeMedium:       fnFmtTimeMedium_8ef07f6477b7a4944577d4e5392ff21b,
			fnFmtTimeShort:        fnFmtTimeShort_8288b817c5c0216c9815524c71c9e0b4,
			fnGroup:               fnGroup_5c4b80a5ccdee81467241784ab8fcd56,
			fnLocale:              fnLocale_5a217059c67094defae82f249f55f4c5,
			fnMinus:               fnMinus_8b8229905258388dc16a5e0c270b0488,
			fnMonthAbbreviated:    fnMonthAbbreviated_aa9a9957cd9d056ba078b36a08b17478,
			fnMonthNarrow:         fnMonthNarrow_45916040ecf6fc350894d9e3e6c46dc7,
			fnMonthWide:           fnMonthWide_4c946a7e7581c665e7407df1841810b5,
			fnMonthsAbbreviated:   fnMonthsAbbreviated_181f77804b62232997fae36bd57d6cf7,
			fnMonthsNarrow:        fnMonthsNarrow_75daa2ba82ae9577292175c3f52370cc,
			fnMonthsWide:          fnMonthsWide_0ecf36a8b72255e2fee9467af362e989,
			fnOrdinalPluralRule:   fnOrdinalPluralRule_3355865f05dde9af2a36ba415bea85cb,
			fnPluralsCardinal:     fnPluralsCardinal_85b19cac1fab9f2c2cfb9eb41539aa0e,
			fnPluralsOrdinal:      fnPluralsOrdinal_16a60aa09da9778fa82fe463e83076de,
			fnPluralsRange:        fnPluralsRange_332465bda13eb808b3664fa0500f54ce,
			fnRangePluralRule:     fnRangePluralRule_47500e2a682fd3a64da69f06f7b93c0a,
			fnWeekdayAbbreviated:  fnWeekdayAbbreviated_4ffbdfbd2be10e6bd8fb5a542a14664a,
			fnWeekdayNarrow:       fnWeekdayNarrow_e86921b3446df5ea9afe9504cfa20d1a,
			fnWeekdayShort:        fnWeekdayShort_82b231d4f504c6d71c7e495aa35cd3c2,
			fnWeekdayWide:         fnWeekdayWide_ab7e026d8685cefd89c5aeb5df512a9a,
			fnWeekdaysAbbreviated: fnWeekdaysAbbreviated_454a3d7d23c662520a64ae5245d404be,
			fnWeekdaysNarrow:      fnWeekdaysNarrow_d23eb0b7a498c40ce19d1bf231cad524,
			fnWeekdaysShort:       fnWeekdaysShort_eb6ee64d01e314991432b4469790d38b,
			fnWeekdaysWide:        fnWeekdaysWide_5e2bbf75a31e730429c100e8a0bd3ebd,
		}
	}
	translatorFuncs["ar_ss"] = func() locales.Translator {
		return &localen{

			locale:                 "ar_SS",
			pluralsCardinal:        []locales.PluralRule{1, 2, 3, 4, 5, 6},
			pluralsOrdinal:         []locales.PluralRule{6},
			pluralsRange:           []locales.PluralRule{1, 4, 5, 6},
			decimal:                "٫",
			group:                  "٬",
			minus:                  "؜-",
			percent:                "٪؜",
			perMille:               "؉",
			timeSeparator:          ":",
			inifinity:              "∞",
			currencies:             []string{"ADP", "AED", "AFA", "AFN", "ALK", "ALL", "AMD", "ANG", "AOA", "AOK", "AON", "AOR", "ARA", "ARL", "ARM", "ARP", "ARS", "ATS", "AUD", "AWG", "AZM", "AZN", "BAD", "BAM", "BAN", "BBD", "BDT", "BEC", "BEF", "BEL", "BGL", "BGM", "BGN", "BGO", "BHD", "BIF", "BMD", "BND", "BOB", "BOL", "BOP", "BOV", "BRB", "BRC", "BRE", "BRL", "BRN", "BRR", "BRZ", "BSD", "BTN", "BUK", "BWP", "BYB", "BYN", "BYR", "BZD", "CAD", "CDF", "CHE", "CHF", "CHW", "CLE", "CLF", "CLP", "CNH", "CNX", "CNY", "COP", "COU", "CRC", "CSD", "CSK", "CUC", "CUP", "CVE", "CYP", "CZK", "DDM", "DEM", "DJF", "DKK", "DOP", "DZD", "ECS", "ECV", "EEK", "EGP", "ERN", "ESA", "ESB", "ESP", "ETB", "EUR", "FIM", "FJD", "FKP", "FRF", "GB£", "GEK", "GEL", "GHC", "GHS", "GIP", "GMD", "GNF", "GNS", "GQE", "GRD", "GTQ", "GWE", "GWP", "GYD", "HKD", "HNL", "HRD", "HRK", "HTG", "HUF", "IDR", "IEP", "ILP", "ILR", "ILS", "INR", "IQD", "IRR", "ISJ", "ISK", "ITL", "JMD", "JOD", "JPY", "KES", "KGS", "KHR", "KMF", "KPW", "KRH", "KRO", "KRW", "KWD", "KYD", "KZT", "LAK", "LBP", "LKR", "LRD", "LSL", "LTL", "LTT", "LUC", "LUF", "LUL", "LVL", "LVR", "LYD", "MAD", "MAF", "MCF", "MDC", "MDL", "MGA", "MGF", "MKD", "MKN", "MLF", "MMK", "MNT", "MOP", "MRO", "MRU", "MTL", "MTP", "MUR", "MVP", "MVR", "MWK", "MXN", "MXP", "MXV", "MYR", "MZE", "MZM", "MZN", "NAD", "NGN", "NIC", "NIO", "NLG", "NOK", "NPR", "NZD", "OMR", "PAB", "PEI", "PEN", "PES", "PGK", "PHP", "PKR", "PLN", "PLZ", "PTE", "PYG", "QAR", "RHD", "ROL", "RON", "RSD", "RUB", "RUR", "RWF", "SAR", "SBD", "SCR", "SDD", "SDG", "SDP", "SEK", "SGD", "SHP", "SIT", "SKK", "SLL", "SOS", "SRD", "SRG", "£", "STD", "STN", "SUR", "SVC", "SYP", "SZL", "THB", "TJR", "TJS", "TMM", "TMT", "TND", "TOP", "TPE", "TRL", "TRY", "TTD", "TWD", "TZS", "UAH", "UAK", "UGS", "UGX", "USD", "USN", "USS", "UYI", "UYP", "UYU", "UYW", "UZS", "VEB", "VEF", "VES", "VND", "VNN", "VUV", "WST", "XAF", "XAG", "XAU", "XBA", "XBB", "XBC", "XBD", "XCD", "XDR", "XEU", "XFO", "XFU", "XOF", "XPD", "XPF", "XPT", "XRE", "XSU", "XTS", "XUA", "XXX", "YDD", "YER", "YUD", "YUM", "YUN", "YUR", "ZAL", "ZAR", "ZMK", "ZMW", "ZRN", "ZRZ", "ZWD", "ZWL", "ZWR"},
			currencyPositiveSuffix: " ",
			currencyNegativeSuffix: " ",
			monthsAbbreviated:      []string{"", "يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"},
			monthsNarrow:           []string{"", "ي", "ف", "م", "أ", "و", "ن", "ل", "غ", "س", "ك", "ب", "د"},
			monthsWide:             []string{"", "يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"},
			daysAbbreviated:        []string{"الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"},
			daysNarrow:             []string{"ح", "ن", "ث", "ر", "خ", "ج", "س"},
			daysShort:              []string{"أحد", "إثنين", "ثلاثاء", "أربعاء", "خميس", "جمعة", "سبت"},
			daysWide:               []string{"الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"},
			periodsAbbreviated:     []string{"ص", "م"},
			periodsNarrow:          []string{"ص", "م"},
			periodsWide:            []string{"ص", "م"},
			erasAbbreviated:        []string{"ق.م", "م"},
			erasNarrow:             []string{"", ""},
			erasWide:               []string{"قبل الميلاد", "ميلادي"},
			timezones:              map[string]string{"ACDT": "توقيت وسط أستراليا الصيفي", "ACST": "توقيت وسط أستراليا الرسمي", "ACWDT": "توقيت غرب وسط أستراليا الصيفي", "ACWST": "توقيت غرب وسط أستراليا الرسمي", "ADT": "التوقيت الصيفي الأطلسي", "AEDT": "توقيت شرق أستراليا الصيفي", "AEST": "توقيت شرق أستراليا الرسمي", "AKDT": "توقيت ألاسكا الصيفي", "AKST": "التوقيت الرسمي لألاسكا", "ARST": "توقيت الأرجنتين الصيفي", "ART": "توقيت الأرجنتين الرسمي", "AST": "التوقيت الرسمي الأطلسي", "AWDT": "توقيت غرب أستراليا الصيفي", "AWST": "توقيت غرب أستراليا الرسمي", "BOT": "توقيت بوليفيا", "BT": "توقيت بوتان", "CAT": "توقيت وسط أفريقيا", "CDT": "التوقيت الصيفي المركزي لأمريكا الشمالية", "CHADT": "توقيت تشاتام الصيفي", "CHAST": "توقيت تشاتام الرسمي", "CLST": "توقيت تشيلي الصيفي", "CLT": "توقيت تشيلي الرسمي", "COST": "توقيت كولومبيا الصيفي", "COT": "توقيت كولومبيا الرسمي", "CST": "التوقيت الرسمي المركزي لأمريكا الشمالية", "ChST": "توقيت تشامورو", "EAT": "توقيت شرق أفريقيا", "ECT": "توقيت الإكوادور", "EDT": "التوقيت الصيفي الشرقي لأمريكا الشمالية", "EST": "التوقيت الرسمي الشرقي لأمريكا الشمالية", "GFT": "توقيت غويانا الفرنسية", "GMT": "توقيت غرينتش", "GST": "توقيت الخليج", "GYT": "توقيت غيانا", "HADT": "توقيت هاواي ألوتيان الصيفي", "HAST": "توقيت هاواي ألوتيان الرسمي", "HAT": "توقيت نيوفاوندلاند الصيفي", "HECU": "توقيت كوبا الصيفي", "HEEG": "توقيت شرق غرينلاند الصيفي", "HENOMX": "التوقيت الصيفي لشمال غرب المكسيك", "HEOG": "توقيت غرب غرينلاند الصيفي", "HEPM": "توقيت سانت بيير وميكولون الصيفي", "HEPMX": "توقيت المحيط الهادي الصيفي للمكسيك", "HKST": "توقيت هونغ كونغ الصيفي", "HKT": "توقيت هونغ كونغ الرسمي", "HNCU": "توقيت كوبا الرسمي", "HNEG": "توقيت شرق غرينلاند الرسمي", "HNNOMX": "التوقيت الرسمي لشمال غرب المكسيك", "HNOG": "توقيت غرب غرينلاند الرسمي", "HNPM": "توقيت سانت بيير وميكولون الرسمي", "HNPMX": "توقيت المحيط الهادي الرسمي للمكسيك", "HNT": "توقيت نيوفاوندلاند الرسمي", "IST": "توقيت الهند", "JDT": "توقيت اليابان الصيفي", "JST": "توقيت اليابان الرسمي", "LHDT": "التوقيت الصيفي للورد هاو", "LHST": "توقيت لورد هاو الرسمي", "MDT": "التوقيت الجبلي الصيفي لأمريكا الشمالية", "MESZ": "توقيت وسط أوروبا الصيفي", "MEZ": "توقيت وسط أوروبا الرسمي", "MST": "التوقيت الجبلي الرسمي لأمريكا الشمالية", "MYT": "توقيت ماليزيا", "NZDT": "توقيت نيوزيلندا الصيفي", "NZST": "توقيت نيوزيلندا الرسمي", "OESZ": "توقيت شرق أوروبا الصيفي", "OEZ": "توقيت شرق أوروبا الرسمي", "PDT": "توقيت المحيط الهادي الصيفي", "PST": "توقيت المحيط الهادي الرسمي", "SAST": "توقيت جنوب أفريقيا", "SGT": "توقيت سنغافورة", "SRT": "توقيت سورينام", "TMST": "توقيت تركمانستان الصيفي", "TMT": "توقيت تركمانستان الرسمي", "UYST": "توقيت أوروغواي الصيفي", "UYT": "توقيت أوروغواي الرسمي", "VET": "توقيت فنزويلا", "WARST": "توقيت غرب الأرجنتين الصيفي", "WART": "توقيت غرب الأرجنتين الرسمي", "WAST": "توقيت غرب أفريقيا الصيفي", "WAT": "توقيت غرب أفريقيا الرسمي", "WESZ": "توقيت غرب أوروبا الصيفي", "WEZ": "توقيت غرب أوروبا الرسمي", "WIB": "توقيت غرب إندونيسيا", "WIT": "توقيت شرق إندونيسيا", "WITA": "توقيت وسط إندونيسيا", "∅∅∅": "توقيت برازيليا الصيفي"},

			fnCardinalPluralRule:  fnCardinalPluralRule_f27514af189883ea7cd186156edfe998,
			fnDecimal:             fnDecimal_a78485e7dd32c95f41af4e18420793bf,
			fnFmtAccounting:       fnFmtAccounting_f74088692afba81682b73af3d3e7c19a,
			fnFmtCurrency:         fnFmtCurrency_e28d302f22cf4ed4b5009e290f74e359,
			fnFmtDateFull:         fnFmtDateFull_2d3b405215099e683568cb9c052cbd54,
			fnFmtDateLong:         fnFmtDateLong_506f643cda0514f66d873a9ea99bf639,
			fnFmtDateMedium:       fnFmtDateMedium_a55320da438aec0cfbc31bc4d718abc1,
			fnFmtDateShort:        fnFmtDateShort_05c85041b5f9b6fa224b9c4ba9be3590,
			fnFmtNumber:           fnFmtNumber_eef52ddc8fa71bd12171ac9ef3cd3328,
			fnFmtPercent:          fnFmtPercent_60ca2e9d27b8160a5fec0f6694129759,
			fnFmtTimeFull:         fnFmtTimeFull_37fe4deeee789852cc196a6a1a2f0ccc,
			fnFmtTimeLong:         fnFmtTimeLong_4429ef4fb58a2a9c4d7d5132fd16ecbf,
			fnFmtTimeMedium:       fnFmtTimeMedium_8ef07f6477b7a4944577d4e5392ff21b,
			fnFmtTimeShort:        fnFmtTimeShort_8288b817c5c0216c9815524c71c9e0b4,
			fnGroup:               fnGroup_5c4b80a5ccdee81467241784ab8fcd56,
			fnLocale:              fnLocale_5a217059c67094defae82f249f55f4c5,
			fnMinus:               fnMinus_8b8229905258388dc16a5e0c270b0488,
			fnMonthAbbreviated:    fnMonthAbbreviated_aa9a9957cd9d056ba078b36a08b17478,
			fnMonthNarrow:         fnMonthNarrow_45916040ecf6fc350894d9e3e6c46dc7,
			fnMonthWide:           fnMonthWide_4c946a7e7581c665e7407df1841810b5,
			fnMonthsAbbreviated:   fnMonthsAbbreviated_181f77804b62232997fae36bd57d6cf7,
			fnMonthsNarrow:        fnMonthsNarrow_75daa2ba82ae9577292175c3f52370cc,
			fnMonthsWide:          fnMonthsWide_0ecf36a8b72255e2fee9467af362e989,
			fnOrdinalPluralRule:   fnOrdinalPluralRule_3355865f05dde9af2a36ba415bea85cb,
			fnPluralsCardinal:     fnPluralsCardinal_85b19cac1fab9f2c2cfb9eb41539aa0e,
			fnPluralsOrdinal:      fnPluralsOrdinal_16a60aa09da9778fa82fe463e83076de,
			fnPluralsRange:        fnPluralsRange_332465bda13eb808b3664fa0500f54ce,
			fnRangePluralRule:     fnRangePluralRule_47500e2a682fd3a64da69f06f7b93c0a,
			fnWeekdayAbbreviated:  fnWeekdayAbbreviated_4ffbdfbd2be10e6bd8fb5a542a14664a,
			fnWeekdayNarrow:       fnWeekdayNarrow_e86921b3446df5ea9afe9504cfa20d1a,
			fnWeekdayShort:        fnWeekdayShort_82b231d4f504c6d71c7e495aa35cd3c2,
			fnWeekdayWide:         fnWeekdayWide_ab7e026d8685cefd89c5aeb5df512a9a,
			fnWeekdaysAbbreviated: fnWeekdaysAbbreviated_454a3d7d23c662520a64ae5245d404be,
			fnWeekdaysNarrow:      fnWeekdaysNarrow_d23eb0b7a498c40ce19d1bf231cad524,
			fnWeekdaysShort:       fnWeekdaysShort_eb6ee64d01e314991432b4469790d38b,
			fnWeekdaysWide:        fnWeekdaysWide_5e2bbf75a31e730429c100e8a0bd3ebd,
		}
	}
	translatorFuncs["ar_sy"] = func() locales.Translator {
		return &localen{

			locale:                 "ar_SY",
			pluralsCardinal:        []locales.PluralRule{1, 2, 3, 4, 5, 6},
			pluralsOrdinal:         []locales.PluralRule{6},
			pluralsRange:           []locales.PluralRule{1, 4, 5, 6},
			decimal:                "٫",
			group:                  "٬",
			minus:                  "؜-",
			percent:                "٪؜",
			perMille:               "؉",
			timeSeparator:          ":",
			inifinity:              "∞",
			currencies:             []string{"ADP", "AED", "AFA", "AFN", "ALK", "ALL", "AMD", "ANG", "AOA", "AOK", "AON", "AOR", "ARA", "ARL", "ARM", "ARP", "ARS", "ATS", "AUD", "AWG", "AZM", "AZN", "BAD", "BAM", "BAN", "BBD", "BDT", "BEC", "BEF", "BEL", "BGL", "BGM", "BGN", "BGO", "BHD", "BIF", "BMD", "BND", "BOB", "BOL", "BOP", "BOV", "BRB", "BRC", "BRE", "BRL", "BRN", "BRR", "BRZ", "BSD", "BTN", "BUK", "BWP", "BYB", "BYN", "BYR", "BZD", "CAD", "CDF", "CHE", "CHF", "CHW", "CLE", "CLF", "CLP", "CNH", "CNX", "CNY", "COP", "COU", "CRC", "CSD", "CSK", "CUC", "CUP", "CVE", "CYP", "CZK", "DDM", "DEM", "DJF", "DKK", "DOP", "DZD", "ECS", "ECV", "EEK", "EGP", "ERN", "ESA", "ESB", "ESP", "ETB", "EUR", "FIM", "FJD", "FKP", "FRF", "GBP", "GEK", "GEL", "GHC", "GHS", "GIP", "GMD", "GNF", "GNS", "GQE", "GRD", "GTQ", "GWE", "GWP", "GYD", "HKD", "HNL", "HRD", "HRK", "HTG", "HUF", "IDR", "IEP", "ILP", "ILR", "ILS", "INR", "IQD", "IRR", "ISJ", "ISK", "ITL", "JMD", "JOD", "JPY", "KES", "KGS", "KHR", "KMF", "KPW", "KRH", "KRO", "KRW", "KWD", "KYD", "KZT", "LAK", "LBP", "LKR", "LRD", "LSL", "LTL", "LTT", "LUC", "LUF", "LUL", "LVL", "LVR", "LYD", "MAD", "MAF", "MCF", "MDC", "MDL", "MGA", "MGF", "MKD", "MKN", "MLF", "MMK", "MNT", "MOP", "MRO", "MRU", "MTL", "MTP", "MUR", "MVP", "MVR", "MWK", "MXN", "MXP", "MXV", "MYR", "MZE", "MZM", "MZN", "NAD", "NGN", "NIC", "NIO", "NLG", "NOK", "NPR", "NZD", "OMR", "PAB", "PEI", "PEN", "PES", "PGK", "PHP", "PKR", "PLN", "PLZ", "PTE", "PYG", "QAR", "RHD", "ROL", "RON", "RSD", "RUB", "RUR", "RWF", "SAR", "SBD", "SCR", "SDD", "SDG", "SDP", "SEK", "SGD", "SHP", "SIT", "SKK", "SLL", "SOS", "SRD", "SRG", "SSP", "STD", "STN", "SUR", "SVC", "SYP", "SZL", "THB", "TJR", "TJS", "TMM", "TMT", "TND", "TOP", "TPE", "TRL", "TRY", "TTD", "TWD", "TZS", "UAH", "UAK", "UGS", "UGX", "USD", "USN", "USS", "UYI", "UYP", "UYU", "UYW", "UZS", "VEB", "VEF", "VES", "VND", "VNN", "VUV", "WST", "XAF", "XAG", "XAU", "XBA", "XBB", "XBC", "XBD", "XCD", "XDR", "XEU", "XFO", "XFU", "XOF", "XPD", "XPF", "XPT", "XRE", "XSU", "XTS", "XUA", "XXX", "YDD", "YER", "YUD", "YUM", "YUN", "YUR", "ZAL", "ZAR", "ZMK", "ZMW", "ZRN", "ZRZ", "ZWD", "ZWL", "ZWR"},
			currencyPositiveSuffix: " ",
			currencyNegativeSuffix: " ",
			monthsAbbreviated:      []string{"", "كانون الثاني", "شباط", "آذار", "نيسان", "أيار", "حزيران", "تموز", "آب", "أيلول", "تشرين الأول", "تشرين الثاني", "كانون الأول"},
			monthsNarrow:           []string{"", "ك", "ش", "آ", "ن", "أ", "ح", "ت", "آ", "أ", "ت", "ت", "ك"},
			monthsWide:             []string{"", "كانون الثاني", "شباط", "آذار", "نيسان", "أيار", "حزيران", "تموز", "آب", "أيلول", "تشرين الأول", "تشرين الثاني", "كانون الأول"},
			daysAbbreviated:        []string{"الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"},
			daysNarrow:             []string{"ح", "ن", "ث", "ر", "خ", "ج", "س"},
			daysShort:              []string{"أحد", "إثنين", "ثلاثاء", "أربعاء", "خميس", "جمعة", "سبت"},
			daysWide:               []string{"الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"},
			periodsAbbreviated:     []string{"ص", "م"},
			periodsNarrow:          []string{"ص", "م"},
			periodsWide:            []string{"ص", "م"},
			erasAbbreviated:        []string{"ق.م", "م"},
			erasNarrow:             []string{"", ""},
			erasWide:               []string{"قبل الميلاد", "ميلادي"},
			timezones:              map[string]string{"ACDT": "توقيت وسط أستراليا الصيفي", "ACST": "توقيت وسط أستراليا الرسمي", "ACWDT": "توقيت غرب وسط أستراليا الصيفي", "ACWST": "توقيت غرب وسط أستراليا الرسمي", "ADT": "التوقيت الصيفي الأطلسي", "AEDT": "توقيت شرق أستراليا الصيفي", "AEST": "توقيت شرق أستراليا الرسمي", "AKDT": "توقيت ألاسكا الصيفي", "AKST": "التوقيت الرسمي لألاسكا", "ARST": "توقيت الأرجنتين الصيفي", "ART": "توقيت الأرجنتين الرسمي", "AST": "التوقيت الرسمي الأطلسي", "AWDT": "توقيت غرب أستراليا الصيفي", "AWST": "توقيت غرب أستراليا الرسمي", "BOT": "توقيت بوليفيا", "BT": "توقيت بوتان", "CAT": "توقيت وسط أفريقيا", "CDT": "التوقيت الصيفي المركزي لأمريكا الشمالية", "CHADT": "توقيت تشاتام الصيفي", "CHAST": "توقيت تشاتام الرسمي", "CLST": "توقيت تشيلي الصيفي", "CLT": "توقيت تشيلي الرسمي", "COST": "توقيت كولومبيا الصيفي", "COT": "توقيت كولومبيا الرسمي", "CST": "التوقيت الرسمي المركزي لأمريكا الشمالية", "ChST": "توقيت تشامورو", "EAT": "توقيت شرق أفريقيا", "ECT": "توقيت الإكوادور", "EDT": "التوقيت الصيفي الشرقي لأمريكا الشمالية", "EST": "التوقيت الرسمي الشرقي لأمريكا الشمالية", "GFT": "توقيت غويانا الفرنسية", "GMT": "توقيت غرينتش", "GST": "توقيت الخليج", "GYT": "توقيت غيانا", "HADT": "توقيت هاواي ألوتيان الصيفي", "HAST": "توقيت هاواي ألوتيان الرسمي", "HAT": "توقيت نيوفاوندلاند الصيفي", "HECU": "توقيت كوبا الصيفي", "HEEG": "توقيت شرق غرينلاند الصيفي", "HENOMX": "التوقيت الصيفي لشمال غرب المكسيك", "HEOG": "توقيت غرب غرينلاند الصيفي", "HEPM": "توقيت سانت بيير وميكولون الصيفي", "HEPMX": "توقيت المحيط الهادي الصيفي للمكسيك", "HKST": "توقيت هونغ كونغ الصيفي", "HKT": "توقيت هونغ كونغ الرسمي", "HNCU": "توقيت كوبا الرسمي", "HNEG": "توقيت شرق غرينلاند الرسمي", "HNNOMX": "التوقيت الرسمي لشمال غرب المكسيك", "HNOG": "توقيت غرب غرينلاند الرسمي", "HNPM": "توقيت سانت بيير وميكولون الرسمي", "HNPMX": "توقيت المحيط الهادي الرسمي للمكسيك", "HNT": "توقيت نيوفاوندلاند الرسمي", "IST": "توقيت الهند", "JDT": "توقيت اليابان الصيفي", "JST": "توقيت اليابان الرسمي", "LHDT": "التوقيت الصيفي للورد هاو", "LHST": "توقيت لورد هاو الرسمي", "MDT": "التوقيت الجبلي الصيفي لأمريكا الشمالية", "MESZ": "توقيت وسط أوروبا الصيفي", "MEZ": "توقيت وسط أوروبا الرسمي", "MST": "التوقيت الجبلي الرسمي لأمريكا الشمالية", "MYT": "توقيت ماليزيا", "NZDT": "توقيت نيوزيلندا الصيفي", "NZST": "توقيت نيوزيلندا الرسمي", "OESZ": "توقيت شرق أوروبا الصيفي", "OEZ": "توقيت شرق أوروبا الرسمي", "PDT": "توقيت المحيط الهادي الصيفي", "PST": "توقيت المحيط الهادي الرسمي", "SAST": "توقيت جنوب أفريقيا", "SGT": "توقيت سنغافورة", "SRT": "توقيت سورينام", "TMST": "توقيت تركمانستان الصيفي", "TMT": "توقيت تركمانستان الرسمي", "UYST": "توقيت أوروغواي الصيفي", "UYT": "توقيت أوروغواي الرسمي", "VET": "توقيت فنزويلا", "WARST": "توقيت غرب الأرجنتين الصيفي", "WART": "توقيت غرب الأرجنتين الرسمي", "WAST": "توقيت غرب أفريقيا الصيفي", "WAT": "توقيت غرب أفريقيا الرسمي", "WESZ": "توقيت غرب أوروبا الصيفي", "WEZ": "توقيت غرب أوروبا الرسمي", "WIB": "توقيت غرب إندونيسيا", "WIT": "توقيت شرق إندونيسيا", "WITA": "توقيت وسط إندونيسيا", "∅∅∅": "توقيت برازيليا الصيفي"},

			fnCardinalPluralRule:  fnCardinalPluralRule_f27514af189883ea7cd186156edfe998,
			fnDecimal:             fnDecimal_a78485e7dd32c95f41af4e18420793bf,
			fnFmtAccounting:       fnFmtAccounting_f74088692afba81682b73af3d3e7c19a,
			fnFmtCurrency:         fnFmtCurrency_e28d302f22cf4ed4b5009e290f74e359,
			fnFmtDateFull:         fnFmtDateFull_2d3b405215099e683568cb9c052cbd54,
			fnFmtDateLong:         fnFmtDateLong_506f643cda0514f66d873a9ea99bf639,
			fnFmtDateMedium:       fnFmtDateMedium_a55320da438aec0cfbc31bc4d718abc1,
			fnFmtDateShort:        fnFmtDateShort_05c85041b5f9b6fa224b9c4ba9be3590,
			fnFmtNumber:           fnFmtNumber_eef52ddc8fa71bd12171ac9ef3cd3328,
			fnFmtPercent:          fnFmtPercent_60ca2e9d27b8160a5fec0f6694129759,
			fnFmtTimeFull:         fnFmtTimeFull_37fe4deeee789852cc196a6a1a2f0ccc,
			fnFmtTimeLong:         fnFmtTimeLong_4429ef4fb58a2a9c4d7d5132fd16ecbf,
			fnFmtTimeMedium:       fnFmtTimeMedium_8ef07f6477b7a4944577d4e5392ff21b,
			fnFmtTimeShort:        fnFmtTimeShort_8288b817c5c0216c9815524c71c9e0b4,
			fnGroup:               fnGroup_5c4b80a5ccdee81467241784ab8fcd56,
			fnLocale:              fnLocale_5a217059c67094defae82f249f55f4c5,
			fnMinus:               fnMinus_8b8229905258388dc16a5e0c270b0488,
			fnMonthAbbreviated:    fnMonthAbbreviated_aa9a9957cd9d056ba078b36a08b17478,
			fnMonthNarrow:         fnMonthNarrow_45916040ecf6fc350894d9e3e6c46dc7,
			fnMonthWide:           fnMonthWide_4c946a7e7581c665e7407df1841810b5,
			fnMonthsAbbreviated:   fnMonthsAbbreviated_181f77804b62232997fae36bd57d6cf7,
			fnMonthsNarrow:        fnMonthsNarrow_75daa2ba82ae9577292175c3f52370cc,
			fnMonthsWide:          fnMonthsWide_0ecf36a8b72255e2fee9467af362e989,
			fnOrdinalPluralRule:   fnOrdinalPluralRule_3355865f05dde9af2a36ba415bea85cb,
			fnPluralsCardinal:     fnPluralsCardinal_85b19cac1fab9f2c2cfb9eb41539aa0e,
			fnPluralsOrdinal:      fnPluralsOrdinal_16a60aa09da9778fa82fe463e83076de,
			fnPluralsRange:        fnPluralsRange_332465bda13eb808b3664fa0500f54ce,
			fnRangePluralRule:     fnRangePluralRule_47500e2a682fd3a64da69f06f7b93c0a,
			fnWeekdayAbbreviated:  fnWeekdayAbbreviated_4ffbdfbd2be10e6bd8fb5a542a14664a,
			fnWeekdayNarrow:       fnWeekdayNarrow_e86921b3446df5ea9afe9504cfa20d1a,
			fnWeekdayShort:        fnWeekdayShort_82b231d4f504c6d71c7e495aa35cd3c2,
			fnWeekdayWide:         fnWeekdayWide_ab7e026d8685cefd89c5aeb5df512a9a,
			fnWeekdaysAbbreviated: fnWeekdaysAbbreviated_454a3d7d23c662520a64ae5245d404be,
			fnWeekdaysNarrow:      fnWeekdaysNarrow_d23eb0b7a498c40ce19d1bf231cad524,
			fnWeekdaysShort:       fnWeekdaysShort_eb6ee64d01e314991432b4469790d38b,
			fnWeekdaysWide:        fnWeekdaysWide_5e2bbf75a31e730429c100e8a0bd3ebd,
		}
	}
	translatorFuncs["ar_td"] = func() locales.Translator {
		return &localen{

			locale:                 "ar_TD",
			pluralsCardinal:        []locales.PluralRule{1, 2, 3, 4, 5, 6},
			pluralsOrdinal:         []locales.PluralRule{6},
			pluralsRange:           []locales.PluralRule{1, 4, 5, 6},
			decimal:                "٫",
			group:                  "٬",
			minus:                  "؜-",
			percent:                "٪؜",
			perMille:               "؉",
			timeSeparator:          ":",
			inifinity:              "∞",
			currencies:             []string{"ADP", "AED", "AFA", "AFN", "ALK", "ALL", "AMD", "ANG", "AOA", "AOK", "AON", "AOR", "ARA", "ARL", "ARM", "ARP", "ARS", "ATS", "AUD", "AWG", "AZM", "AZN", "BAD", "BAM", "BAN", "BBD", "BDT", "BEC", "BEF", "BEL", "BGL", "BGM", "BGN", "BGO", "BHD", "BIF", "BMD", "BND", "BOB", "BOL", "BOP", "BOV", "BRB", "BRC", "BRE", "BRL", "BRN", "BRR", "BRZ", "BSD", "BTN", "BUK", "BWP", "BYB", "BYN", "BYR", "BZD", "CAD", "CDF", "CHE", "CHF", "CHW", "CLE", "CLF", "CLP", "CNH", "CNX", "CNY", "COP", "COU", "CRC", "CSD", "CSK", "CUC", "CUP", "CVE", "CYP", "CZK", "DDM", "DEM", "DJF", "DKK", "DOP", "DZD", "ECS", "ECV", "EEK", "EGP", "ERN", "ESA", "ESB", "ESP", "ETB", "EUR", "FIM", "FJD", "FKP", "FRF", "GBP", "GEK", "GEL", "GHC", "GHS", "GIP", "GMD", "GNF", "GNS", "GQE", "GRD", "GTQ", "GWE", "GWP", "GYD", "HKD", "HNL", "HRD", "HRK", "HTG", "HUF", "IDR", "IEP", "ILP", "ILR", "ILS", "INR", "IQD", "IRR", "ISJ", "ISK", "ITL", "JMD", "JOD", "JPY", "KES", "KGS", "KHR", "KMF", "KPW", "KRH", "KRO", "KRW", "KWD", "KYD", "KZT", "LAK", "LBP", "LKR", "LRD", "LSL", "LTL", "LTT", "LUC", "LUF", "LUL", "LVL", "LVR", "LYD", "MAD", "MAF", "MCF", "MDC", "MDL", "MGA", "MGF", "MKD", "MKN", "MLF", "MMK", "MNT", "MOP", "MRO", "MRU", "MTL", "MTP", "MUR", "MVP", "MVR", "MWK", "MXN", "MXP", "MXV", "MYR", "MZE", "MZM", "MZN", "NAD", "NGN", "NIC", "NIO", "NLG", "NOK", "NPR", "NZD", "OMR", "PAB", "PEI", "PEN", "PES", "PGK", "PHP", "PKR", "PLN", "PLZ", "PTE", "PYG", "QAR", "RHD", "ROL", "RON", "RSD", "RUB", "RUR", "RWF", "SAR", "SBD", "SCR", "SDD", "SDG", "SDP", "SEK", "SGD", "SHP", "SIT", "SKK", "SLL", "SOS", "SRD", "SRG", "SSP", "STD", "STN", "SUR", "SVC", "SYP", "SZL", "THB", "TJR", "TJS", "TMM", "TMT", "TND", "TOP", "TPE", "TRL", "TRY", "TTD", "TWD", "TZS", "UAH", "UAK", "UGS", "UGX", "USD", "USN", "USS", "UYI", "UYP", "UYU", "UYW", "UZS", "VEB", "VEF", "VES", "VND", "VNN", "VUV", "WST", "XAF", "XAG", "XAU", "XBA", "XBB", "XBC", "XBD", "XCD", "XDR", "XEU", "XFO", "XFU", "XOF", "XPD", "XPF", "XPT", "XRE", "XSU", "XTS", "XUA", "XXX", "YDD", "YER", "YUD", "YUM", "YUN", "YUR", "ZAL", "ZAR", "ZMK", "ZMW", "ZRN", "ZRZ", "ZWD", "ZWL", "ZWR"},
			currencyPositiveSuffix: " ",
			currencyNegativeSuffix: " ",
			monthsAbbreviated:      []string{"", "يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"},
			monthsNarrow:           []string{"", "ي", "ف", "م", "أ", "و", "ن", "ل", "غ", "س", "ك", "ب", "د"},
			monthsWide:             []string{"", "يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"},
			daysAbbreviated:        []string{"الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"},
			daysNarrow:             []string{"ح", "ن", "ث", "ر", "خ", "ج", "س"},
			daysShort:              []string{"أحد", "إثنين", "ثلاثاء", "أربعاء", "خميس", "جمعة", "سبت"},
			daysWide:               []string{"الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"},
			periodsAbbreviated:     []string{"ص", "م"},
			periodsNarrow:          []string{"ص", "م"},
			periodsWide:            []string{"ص", "م"},
			erasAbbreviated:        []string{"ق.م", "م"},
			erasNarrow:             []string{"", ""},
			erasWide:               []string{"قبل الميلاد", "ميلادي"},
			timezones:              map[string]string{"ACDT": "توقيت وسط أستراليا الصيفي", "ACST": "توقيت وسط أستراليا الرسمي", "ACWDT": "توقيت غرب وسط أستراليا الصيفي", "ACWST": "توقيت غرب وسط أستراليا الرسمي", "ADT": "التوقيت الصيفي الأطلسي", "AEDT": "توقيت شرق أستراليا الصيفي", "AEST": "توقيت شرق أستراليا الرسمي", "AKDT": "توقيت ألاسكا الصيفي", "AKST": "التوقيت الرسمي لألاسكا", "ARST": "توقيت الأرجنتين الصيفي", "ART": "توقيت الأرجنتين الرسمي", "AST": "التوقيت الرسمي الأطلسي", "AWDT": "توقيت غرب أستراليا الصيفي", "AWST": "توقيت غرب أستراليا الرسمي", "BOT": "توقيت بوليفيا", "BT": "توقيت بوتان", "CAT": "توقيت وسط أفريقيا", "CDT": "التوقيت الصيفي المركزي لأمريكا الشمالية", "CHADT": "توقيت تشاتام الصيفي", "CHAST": "توقيت تشاتام الرسمي", "CLST": "توقيت تشيلي الصيفي", "CLT": "توقيت تشيلي الرسمي", "COST": "توقيت كولومبيا الصيفي", "COT": "توقيت كولومبيا الرسمي", "CST": "التوقيت الرسمي المركزي لأمريكا الشمالية", "ChST": "توقيت تشامورو", "EAT": "توقيت شرق أفريقيا", "ECT": "توقيت الإكوادور", "EDT": "التوقيت الصيفي الشرقي لأمريكا الشمالية", "EST": "التوقيت الرسمي الشرقي لأمريكا الشمالية", "GFT": "توقيت غويانا الفرنسية", "GMT": "توقيت غرينتش", "GST": "توقيت الخليج", "GYT": "توقيت غيانا", "HADT": "توقيت هاواي ألوتيان الصيفي", "HAST": "توقيت هاواي ألوتيان الرسمي", "HAT": "توقيت نيوفاوندلاند الصيفي", "HECU": "توقيت كوبا الصيفي", "HEEG": "توقيت شرق غرينلاند الصيفي", "HENOMX": "التوقيت الصيفي لشمال غرب المكسيك", "HEOG": "توقيت غرب غرينلاند الصيفي", "HEPM": "توقيت سانت بيير وميكولون الصيفي", "HEPMX": "توقيت المحيط الهادي الصيفي للمكسيك", "HKST": "توقيت هونغ كونغ الصيفي", "HKT": "توقيت هونغ كونغ الرسمي", "HNCU": "توقيت كوبا الرسمي", "HNEG": "توقيت شرق غرينلاند الرسمي", "HNNOMX": "التوقيت الرسمي لشمال غرب المكسيك", "HNOG": "توقيت غرب غرينلاند الرسمي", "HNPM": "توقيت سانت بيير وميكولون الرسمي", "HNPMX": "توقيت المحيط الهادي الرسمي للمكسيك", "HNT": "توقيت نيوفاوندلاند الرسمي", "IST": "توقيت الهند", "JDT": "توقيت اليابان الصيفي", "JST": "توقيت اليابان الرسمي", "LHDT": "التوقيت الصيفي للورد هاو", "LHST": "توقيت لورد هاو الرسمي", "MDT": "التوقيت الجبلي الصيفي لأمريكا الشمالية", "MESZ": "توقيت وسط أوروبا الصيفي", "MEZ": "توقيت وسط أوروبا الرسمي", "MST": "التوقيت الجبلي الرسمي لأمريكا الشمالية", "MYT": "توقيت ماليزيا", "NZDT": "توقيت نيوزيلندا الصيفي", "NZST": "توقيت نيوزيلندا الرسمي", "OESZ": "توقيت شرق أوروبا الصيفي", "OEZ": "توقيت شرق أوروبا الرسمي", "PDT": "توقيت المحيط الهادي الصيفي", "PST": "توقيت المحيط الهادي الرسمي", "SAST": "توقيت جنوب أفريقيا", "SGT": "توقيت سنغافورة", "SRT": "توقيت سورينام", "TMST": "توقيت تركمانستان الصيفي", "TMT": "توقيت تركمانستان الرسمي", "UYST": "توقيت أوروغواي الصيفي", "UYT": "توقيت أوروغواي الرسمي", "VET": "توقيت فنزويلا", "WARST": "توقيت غرب الأرجنتين الصيفي", "WART": "توقيت غرب الأرجنتين الرسمي", "WAST": "توقيت غرب أفريقيا الصيفي", "WAT": "توقيت غرب أفريقيا الرسمي", "WESZ": "توقيت غرب أوروبا الصيفي", "WEZ": "توقيت غرب أوروبا الرسمي", "WIB": "توقيت غرب إندونيسيا", "WIT": "توقيت شرق إندونيسيا", "WITA": "توقيت وسط إندونيسيا", "∅∅∅": "توقيت أزورس الصيفي"},

			fnCardinalPluralRule:  fnCardinalPluralRule_f27514af189883ea7cd186156edfe998,
			fnDecimal:             fnDecimal_a78485e7dd32c95f41af4e18420793bf,
			fnFmtAccounting:       fnFmtAccounting_f74088692afba81682b73af3d3e7c19a,
			fnFmtCurrency:         fnFmtCurrency_e28d302f22cf4ed4b5009e290f74e359,
			fnFmtDateFull:         fnFmtDateFull_2d3b405215099e683568cb9c052cbd54,
			fnFmtDateLong:         fnFmtDateLong_506f643cda0514f66d873a9ea99bf639,
			fnFmtDateMedium:       fnFmtDateMedium_a55320da438aec0cfbc31bc4d718abc1,
			fnFmtDateShort:        fnFmtDateShort_05c85041b5f9b6fa224b9c4ba9be3590,
			fnFmtNumber:           fnFmtNumber_eef52ddc8fa71bd12171ac9ef3cd3328,
			fnFmtPercent:          fnFmtPercent_60ca2e9d27b8160a5fec0f6694129759,
			fnFmtTimeFull:         fnFmtTimeFull_37fe4deeee789852cc196a6a1a2f0ccc,
			fnFmtTimeLong:         fnFmtTimeLong_4429ef4fb58a2a9c4d7d5132fd16ecbf,
			fnFmtTimeMedium:       fnFmtTimeMedium_8ef07f6477b7a4944577d4e5392ff21b,
			fnFmtTimeShort:        fnFmtTimeShort_8288b817c5c0216c9815524c71c9e0b4,
			fnGroup:               fnGroup_5c4b80a5ccdee81467241784ab8fcd56,
			fnLocale:              fnLocale_5a217059c67094defae82f249f55f4c5,
			fnMinus:               fnMinus_8b8229905258388dc16a5e0c270b0488,
			fnMonthAbbreviated:    fnMonthAbbreviated_aa9a9957cd9d056ba078b36a08b17478,
			fnMonthNarrow:         fnMonthNarrow_45916040ecf6fc350894d9e3e6c46dc7,
			fnMonthWide:           fnMonthWide_4c946a7e7581c665e7407df1841810b5,
			fnMonthsAbbreviated:   fnMonthsAbbreviated_181f77804b62232997fae36bd57d6cf7,
			fnMonthsNarrow:        fnMonthsNarrow_75daa2ba82ae9577292175c3f52370cc,
			fnMonthsWide:          fnMonthsWide_0ecf36a8b72255e2fee9467af362e989,
			fnOrdinalPluralRule:   fnOrdinalPluralRule_3355865f05dde9af2a36ba415bea85cb,
			fnPluralsCardinal:     fnPluralsCardinal_85b19cac1fab9f2c2cfb9eb41539aa0e,
			fnPluralsOrdinal:      fnPluralsOrdinal_16a60aa09da9778fa82fe463e83076de,
			fnPluralsRange:        fnPluralsRange_332465bda13eb808b3664fa0500f54ce,
			fnRangePluralRule:     fnRangePluralRule_47500e2a682fd3a64da69f06f7b93c0a,
			fnWeekdayAbbreviated:  fnWeekdayAbbreviated_4ffbdfbd2be10e6bd8fb5a542a14664a,
			fnWeekdayNarrow:       fnWeekdayNarrow_e86921b3446df5ea9afe9504cfa20d1a,
			fnWeekdayShort:        fnWeekdayShort_82b231d4f504c6d71c7e495aa35cd3c2,
			fnWeekdayWide:         fnWeekdayWide_ab7e026d8685cefd89c5aeb5df512a9a,
			fnWeekdaysAbbreviated: fnWeekdaysAbbreviated_454a3d7d23c662520a64ae5245d404be,
			fnWeekdaysNarrow:      fnWeekdaysNarrow_d23eb0b7a498c40ce19d1bf231cad524,
			fnWeekdaysShort:       fnWeekdaysShort_eb6ee64d01e314991432b4469790d38b,
			fnWeekdaysWide:        fnWeekdaysWide_5e2bbf75a31e730429c100e8a0bd3ebd,
		}
	}
	translatorFuncs["ar_tn"] = func() locales.Translator {
		return &localen{

			locale:                 "ar_TN",
			pluralsCardinal:        []locales.PluralRule{1, 2, 3, 4, 5, 6},
			pluralsOrdinal:         []locales.PluralRule{6},
			pluralsRange:           []locales.PluralRule{1, 4, 5, 6},
			decimal:                ",",
			group:                  ".",
			minus:                  "؜-",
			percent:                "٪؜",
			perMille:               "؉",
			timeSeparator:          ":",
			inifinity:              "∞",
			currencies:             []string{"ADP", "AED", "AFA", "AFN", "ALK", "ALL", "AMD", "ANG", "AOA", "AOK", "AON", "AOR", "ARA", "ARL", "ARM", "ARP", "ARS", "ATS", "AUD", "AWG", "AZM", "AZN", "BAD", "BAM", "BAN", "BBD", "BDT", "BEC", "BEF", "BEL", "BGL", "BGM", "BGN", "BGO", "BHD", "BIF", "BMD", "BND", "BOB", "BOL", "BOP", "BOV", "BRB", "BRC", "BRE", "BRL", "BRN", "BRR", "BRZ", "BSD", "BTN", "BUK", "BWP", "BYB", "BYN", "BYR", "BZD", "CAD", "CDF", "CHE", "CHF", "CHW", "CLE", "CLF", "CLP", "CNH", "CNX", "CNY", "COP", "COU", "CRC", "CSD", "CSK", "CUC", "CUP", "CVE", "CYP", "CZK", "DDM", "DEM", "DJF", "DKK", "DOP", "DZD", "ECS", "ECV", "EEK", "EGP", "ERN", "ESA", "ESB", "ESP", "ETB", "EUR", "FIM", "FJD", "FKP", "FRF", "GBP", "GEK", "GEL", "GHC", "GHS", "GIP", "GMD", "GNF", "GNS", "GQE", "GRD", "GTQ", "GWE", "GWP", "GYD", "HKD", "HNL", "HRD", "HRK", "HTG", "HUF", "IDR", "IEP", "ILP", "ILR", "ILS", "INR", "IQD", "IRR", "ISJ", "ISK", "ITL", "JMD", "JOD", "JPY", "KES", "KGS", "KHR", "KMF", "KPW", "KRH", "KRO", "KRW", "KWD", "KYD", "KZT", "LAK", "LBP", "LKR", "LRD", "LSL", "LTL", "LTT", "LUC", "LUF", "LUL", "LVL", "LVR", "LYD", "MAD", "MAF", "MCF", "MDC", "MDL", "MGA", "MGF", "MKD", "MKN", "MLF", "MMK", "MNT", "MOP", "MRO", "MRU", "MTL", "MTP", "MUR", "MVP", "MVR", "MWK", "MXN", "MXP", "MXV", "MYR", "MZE", "MZM", "MZN", "NAD", "NGN", "NIC", "NIO", "NLG", "NOK", "NPR", "NZD", "OMR", "PAB", "PEI", "PEN", "PES", "PGK", "PHP", "PKR", "PLN", "PLZ", "PTE", "PYG", "QAR", "RHD", "ROL", "RON", "RSD", "RUB", "RUR", "RWF", "SAR", "SBD", "SCR", "SDD", "SDG", "SDP", "SEK", "SGD", "SHP", "SIT", "SKK", "SLL", "SOS", "SRD", "SRG", "SSP", "STD", "STN", "SUR", "SVC", "SYP", "SZL", "THB", "TJR", "TJS", "TMM", "TMT", "TND", "TOP", "TPE", "TRL", "TRY", "TTD", "TWD", "TZS", "UAH", "UAK", "UGS", "UGX", "USD", "USN", "USS", "UYI", "UYP", "UYU", "UYW", "UZS", "VEB", "VEF", "VES", "VND", "VNN", "VUV", "WST", "XAF", "XAG", "XAU", "XBA", "XBB", "XBC", "XBD", "XCD", "XDR", "XEU", "XFO", "XFU", "XOF", "XPD", "XPF", "XPT", "XRE", "XSU", "XTS", "XUA", "XXX", "YDD", "YER", "YUD", "YUM", "YUN", "YUR", "ZAL", "ZAR", "ZMK", "ZMW", "ZRN", "ZRZ", "ZWD", "ZWL", "ZWR"},
			currencyPositiveSuffix: " ",
			currencyNegativeSuffix: " ",
			monthsAbbreviated:      []string{"", "جانفي", "فيفري", "أفريل", "ماي", "جوان", "جويلية", "أوت"},
			monthsNarrow:           []string{"", "ج", "م", "ج", "ج", "أ", "أ", "ن"},
			monthsWide:             []string{"", "جانفي", "فيفري", "أفريل", "ماي", "جوان", "جويلية", "أوت"},
			daysAbbreviated:        []string{"الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"},
			daysNarrow:             []string{"ح", "ن", "ث", "ر", "خ", "ج", "س"},
			daysShort:              []string{"أحد", "إثنين", "ثلاثاء", "أربعاء", "خميس", "جمعة", "سبت"},
			daysWide:               []string{"الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"},
			periodsAbbreviated:     []string{"ص", "م"},
			periodsNarrow:          []string{"ص", "م"},
			periodsWide:            []string{"ص", "م"},
			erasAbbreviated:        []string{"ق.م", "م"},
			erasNarrow:             []string{"", ""},
			erasWide:               []string{"قبل الميلاد", "ميلادي"},
			timezones:              map[string]string{"ACDT": "توقيت وسط أستراليا الصيفي", "ACST": "توقيت وسط أستراليا الرسمي", "ACWDT": "توقيت غرب وسط أستراليا الصيفي", "ACWST": "توقيت غرب وسط أستراليا الرسمي", "ADT": "التوقيت الصيفي الأطلسي", "AEDT": "توقيت شرق أستراليا الصيفي", "AEST": "توقيت شرق أستراليا الرسمي", "AKDT": "توقيت ألاسكا الصيفي", "AKST": "التوقيت الرسمي لألاسكا", "ARST": "توقيت الأرجنتين الصيفي", "ART": "توقيت الأرجنتين الرسمي", "AST": "التوقيت الرسمي الأطلسي", "AWDT": "توقيت غرب أستراليا الصيفي", "AWST": "توقيت غرب أستراليا الرسمي", "BOT": "توقيت بوليفيا", "BT": "توقيت بوتان", "CAT": "توقيت وسط أفريقيا", "CDT": "التوقيت الصيفي المركزي لأمريكا الشمالية", "CHADT": "توقيت تشاتام الصيفي", "CHAST": "توقيت تشاتام الرسمي", "CLST": "توقيت تشيلي الصيفي", "CLT": "توقيت تشيلي الرسمي", "COST": "توقيت كولومبيا الصيفي", "COT": "توقيت كولومبيا الرسمي", "CST": "التوقيت الرسمي المركزي لأمريكا الشمالية", "ChST": "توقيت تشامورو", "EAT": "توقيت شرق أفريقيا", "ECT": "توقيت الإكوادور", "EDT": "التوقيت الصيفي الشرقي لأمريكا الشمالية", "EST": "التوقيت الرسمي الشرقي لأمريكا الشمالية", "GFT": "توقيت غويانا الفرنسية", "GMT": "توقيت غرينتش", "GST": "توقيت الخليج", "GYT": "توقيت غيانا", "HADT": "توقيت هاواي ألوتيان الصيفي", "HAST": "توقيت هاواي ألوتيان الرسمي", "HAT": "توقيت نيوفاوندلاند الصيفي", "HECU": "توقيت كوبا الصيفي", "HEEG": "توقيت شرق غرينلاند الصيفي", "HENOMX": "التوقيت الصيفي لشمال غرب المكسيك", "HEOG": "توقيت غرب غرينلاند الصيفي", "HEPM": "توقيت سانت بيير وميكولون الصيفي", "HEPMX": "توقيت المحيط الهادي الصيفي للمكسيك", "HKST": "توقيت هونغ كونغ الصيفي", "HKT": "توقيت هونغ كونغ الرسمي", "HNCU": "توقيت كوبا الرسمي", "HNEG": "توقيت شرق غرينلاند الرسمي", "HNNOMX": "التوقيت الرسمي لشمال غرب المكسيك", "HNOG": "توقيت غرب غرينلاند الرسمي", "HNPM": "توقيت سانت بيير وميكولون الرسمي", "HNPMX": "توقيت المحيط الهادي الرسمي للمكسيك", "HNT": "توقيت نيوفاوندلاند الرسمي", "IST": "توقيت الهند", "JDT": "توقيت اليابان الصيفي", "JST": "توقيت اليابان الرسمي", "LHDT": "التوقيت الصيفي للورد هاو", "LHST": "توقيت لورد هاو الرسمي", "MDT": "MDT", "MESZ": "توقيت وسط أوروبا الصيفي", "MEZ": "توقيت وسط أوروبا الرسمي", "MST": "MST", "MYT": "توقيت ماليزيا", "NZDT": "توقيت نيوزيلندا الصيفي", "NZST": "توقيت نيوزيلندا الرسمي", "OESZ": "توقيت شرق أوروبا الصيفي", "OEZ": "توقيت شرق أوروبا الرسمي", "PDT": "توقيت المحيط الهادي الصيفي", "PST": "توقيت المحيط الهادي الرسمي", "SAST": "توقيت جنوب أفريقيا", "SGT": "توقيت سنغافورة", "SRT": "توقيت سورينام", "TMST": "توقيت تركمانستان الصيفي", "TMT": "توقيت تركمانستان الرسمي", "UYST": "توقيت أوروغواي الصيفي", "UYT": "توقيت أوروغواي الرسمي", "VET": "توقيت فنزويلا", "WARST": "توقيت غرب الأرجنتين الصيفي", "WART": "توقيت غرب الأرجنتين الرسمي", "WAST": "توقيت غرب أفريقيا الصيفي", "WAT": "توقيت غرب أفريقيا الرسمي", "WESZ": "توقيت غرب أوروبا الصيفي", "WEZ": "توقيت غرب أوروبا الرسمي", "WIB": "توقيت غرب إندونيسيا", "WIT": "توقيت شرق إندونيسيا", "WITA": "توقيت وسط إندونيسيا", "∅∅∅": "توقيت بيرو الصيفي"},

			fnCardinalPluralRule:  fnCardinalPluralRule_f27514af189883ea7cd186156edfe998,
			fnDecimal:             fnDecimal_a78485e7dd32c95f41af4e18420793bf,
			fnFmtAccounting:       fnFmtAccounting_d5455f8fcf723c4be2a5a03fd41298f2,
			fnFmtCurrency:         fnFmtCurrency_2c2268a7a667170346d6d4c829feb8a4,
			fnFmtDateFull:         fnFmtDateFull_2d3b405215099e683568cb9c052cbd54,
			fnFmtDateLong:         fnFmtDateLong_506f643cda0514f66d873a9ea99bf639,
			fnFmtDateMedium:       fnFmtDateMedium_a55320da438aec0cfbc31bc4d718abc1,
			fnFmtDateShort:        fnFmtDateShort_05c85041b5f9b6fa224b9c4ba9be3590,
			fnFmtNumber:           fnFmtNumber_f253fbd23af5a54db29f42f905c9e33a,
			fnFmtPercent:          fnFmtPercent_fb7ade3a9509df0c54be19484c433a01,
			fnFmtTimeFull:         fnFmtTimeFull_37fe4deeee789852cc196a6a1a2f0ccc,
			fnFmtTimeLong:         fnFmtTimeLong_4429ef4fb58a2a9c4d7d5132fd16ecbf,
			fnFmtTimeMedium:       fnFmtTimeMedium_8ef07f6477b7a4944577d4e5392ff21b,
			fnFmtTimeShort:        fnFmtTimeShort_8288b817c5c0216c9815524c71c9e0b4,
			fnGroup:               fnGroup_5c4b80a5ccdee81467241784ab8fcd56,
			fnLocale:              fnLocale_5a217059c67094defae82f249f55f4c5,
			fnMinus:               fnMinus_8b8229905258388dc16a5e0c270b0488,
			fnMonthAbbreviated:    fnMonthAbbreviated_aa9a9957cd9d056ba078b36a08b17478,
			fnMonthNarrow:         fnMonthNarrow_45916040ecf6fc350894d9e3e6c46dc7,
			fnMonthWide:           fnMonthWide_4c946a7e7581c665e7407df1841810b5,
			fnMonthsAbbreviated:   fnMonthsAbbreviated_181f77804b62232997fae36bd57d6cf7,
			fnMonthsNarrow:        fnMonthsNarrow_75daa2ba82ae9577292175c3f52370cc,
			fnMonthsWide:          fnMonthsWide_0ecf36a8b72255e2fee9467af362e989,
			fnOrdinalPluralRule:   fnOrdinalPluralRule_3355865f05dde9af2a36ba415bea85cb,
			fnPluralsCardinal:     fnPluralsCardinal_85b19cac1fab9f2c2cfb9eb41539aa0e,
			fnPluralsOrdinal:      fnPluralsOrdinal_16a60aa09da9778fa82fe463e83076de,
			fnPluralsRange:        fnPluralsRange_332465bda13eb808b3664fa0500f54ce,
			fnRangePluralRule:     fnRangePluralRule_47500e2a682fd3a64da69f06f7b93c0a,
			fnWeekdayAbbreviated:  fnWeekdayAbbreviated_4ffbdfbd2be10e6bd8fb5a542a14664a,
			fnWeekdayNarrow:       fnWeekdayNarrow_e86921b3446df5ea9afe9504cfa20d1a,
			fnWeekdayShort:        fnWeekdayShort_82b231d4f504c6d71c7e495aa35cd3c2,
			fnWeekdayWide:         fnWeekdayWide_ab7e026d8685cefd89c5aeb5df512a9a,
			fnWeekdaysAbbreviated: fnWeekdaysAbbreviated_454a3d7d23c662520a64ae5245d404be,
			fnWeekdaysNarrow:      fnWeekdaysNarrow_d23eb0b7a498c40ce19d1bf231cad524,
			fnWeekdaysShort:       fnWeekdaysShort_eb6ee64d01e314991432b4469790d38b,
			fnWeekdaysWide:        fnWeekdaysWide_5e2bbf75a31e730429c100e8a0bd3ebd,
		}
	}
	translatorFuncs["ar_ye"] = func() locales.Translator {
		return &localen{

			locale:                 "ar_YE",
			pluralsCardinal:        []locales.PluralRule{1, 2, 3, 4, 5, 6},
			pluralsOrdinal:         []locales.PluralRule{6},
			pluralsRange:           []locales.PluralRule{1, 4, 5, 6},
			decimal:                "٫",
			group:                  "٬",
			minus:                  "؜-",
			percent:                "٪؜",
			perMille:               "؉",
			timeSeparator:          ":",
			inifinity:              "∞",
			currencies:             []string{"ADP", "AED", "AFA", "AFN", "ALK", "ALL", "AMD", "ANG", "AOA", "AOK", "AON", "AOR", "ARA", "ARL", "ARM", "ARP", "ARS", "ATS", "AUD", "AWG", "AZM", "AZN", "BAD", "BAM", "BAN", "BBD", "BDT", "BEC", "BEF", "BEL", "BGL", "BGM", "BGN", "BGO", "BHD", "BIF", "BMD", "BND", "BOB", "BOL", "BOP", "BOV", "BRB", "BRC", "BRE", "BRL", "BRN", "BRR", "BRZ", "BSD", "BTN", "BUK", "BWP", "BYB", "BYN", "BYR", "BZD", "CAD", "CDF", "CHE", "CHF", "CHW", "CLE", "CLF", "CLP", "CNH", "CNX", "CNY", "COP", "COU", "CRC", "CSD", "CSK", "CUC", "CUP", "CVE", "CYP", "CZK", "DDM", "DEM", "DJF", "DKK", "DOP", "DZD", "ECS", "ECV", "EEK", "EGP", "ERN", "ESA", "ESB", "ESP", "ETB", "EUR", "FIM", "FJD", "FKP", "FRF", "GBP", "GEK", "GEL", "GHC", "GHS", "GIP", "GMD", "GNF", "GNS", "GQE", "GRD", "GTQ", "GWE", "GWP", "GYD", "HKD", "HNL", "HRD", "HRK", "HTG", "HUF", "IDR", "IEP", "ILP", "ILR", "ILS", "INR", "IQD", "IRR", "ISJ", "ISK", "ITL", "JMD", "JOD", "JPY", "KES", "KGS", "KHR", "KMF", "KPW", "KRH", "KRO", "KRW", "KWD", "KYD", "KZT", "LAK", "LBP", "LKR", "LRD", "LSL", "LTL", "LTT", "LUC", "LUF", "LUL", "LVL", "LVR", "LYD", "MAD", "MAF", "MCF", "MDC", "MDL", "MGA", "MGF", "MKD", "MKN", "MLF", "MMK", "MNT", "MOP", "MRO", "MRU", "MTL", "MTP", "MUR", "MVP", "MVR", "MWK", "MXN", "MXP", "MXV", "MYR", "MZE", "MZM", "MZN", "NAD", "NGN", "NIC", "NIO", "NLG", "NOK", "NPR", "NZD", "OMR", "PAB", "PEI", "PEN", "PES", "PGK", "PHP", "PKR", "PLN", "PLZ", "PTE", "PYG", "QAR", "RHD", "ROL", "RON", "RSD", "RUB", "RUR", "RWF", "SAR", "SBD", "SCR", "SDD", "SDG", "SDP", "SEK", "SGD", "SHP", "SIT", "SKK", "SLL", "SOS", "SRD", "SRG", "SSP", "STD", "STN", "SUR", "SVC", "SYP", "SZL", "THB", "TJR", "TJS", "TMM", "TMT", "TND", "TOP", "TPE", "TRL", "TRY", "TTD", "TWD", "TZS", "UAH", "UAK", "UGS", "UGX", "USD", "USN", "USS", "UYI", "UYP", "UYU", "UYW", "UZS", "VEB", "VEF", "VES", "VND", "VNN", "VUV", "WST", "XAF", "XAG", "XAU", "XBA", "XBB", "XBC", "XBD", "XCD", "XDR", "XEU", "XFO", "XFU", "XOF", "XPD", "XPF", "XPT", "XRE", "XSU", "XTS", "XUA", "XXX", "YDD", "YER", "YUD", "YUM", "YUN", "YUR", "ZAL", "ZAR", "ZMK", "ZMW", "ZRN", "ZRZ", "ZWD", "ZWL", "ZWR"},
			currencyPositiveSuffix: " ",
			currencyNegativeSuffix: " ",
			monthsAbbreviated:      []string{"", "يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"},
			monthsNarrow:           []string{"", "ي", "ف", "م", "أ", "و", "ن", "ل", "غ", "س", "ك", "ب", "د"},
			monthsWide:             []string{"", "يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"},
			daysAbbreviated:        []string{"الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"},
			daysNarrow:             []string{"ح", "ن", "ث", "ر", "خ", "ج", "س"},
			daysShort:              []string{"أحد", "إثنين", "ثلاثاء", "أربعاء", "خميس", "جمعة", "سبت"},
			daysWide:               []string{"الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"},
			periodsAbbreviated:     []string{"ص", "م"},
			periodsNarrow:          []string{"ص", "م"},
			periodsWide:            []string{"ص", "م"},
			erasAbbreviated:        []string{"ق.م", "م"},
			erasNarrow:             []string{"", ""},
			erasWide:               []string{"قبل الميلاد", "ميلادي"},
			timezones:              map[string]string{"ACDT": "توقيت وسط أستراليا الصيفي", "ACST": "توقيت وسط أستراليا الرسمي", "ACWDT": "توقيت غرب وسط أستراليا الصيفي", "ACWST": "توقيت غرب وسط أستراليا الرسمي", "ADT": "التوقيت الصيفي الأطلسي", "AEDT": "توقيت شرق أستراليا الصيفي", "AEST": "توقيت شرق أستراليا الرسمي", "AKDT": "توقيت ألاسكا الصيفي", "AKST": "التوقيت الرسمي لألاسكا", "ARST": "توقيت الأرجنتين الصيفي", "ART": "توقيت الأرجنتين الرسمي", "AST": "التوقيت الرسمي الأطلسي", "AWDT": "توقيت غرب أستراليا الصيفي", "AWST": "توقيت غرب أستراليا الرسمي", "BOT": "توقيت بوليفيا", "BT": "توقيت بوتان", "CAT": "توقيت وسط أفريقيا", "CDT": "التوقيت الصيفي المركزي لأمريكا الشمالية", "CHADT": "توقيت تشاتام الصيفي", "CHAST": "توقيت تشاتام الرسمي", "CLST": "توقيت تشيلي الصيفي", "CLT": "توقيت تشيلي الرسمي", "COST": "توقيت كولومبيا الصيفي", "COT": "توقيت كولومبيا الرسمي", "CST": "التوقيت الرسمي المركزي لأمريكا الشمالية", "ChST": "توقيت تشامورو", "EAT": "توقيت شرق أفريقيا", "ECT": "توقيت الإكوادور", "EDT": "التوقيت الصيفي الشرقي لأمريكا الشمالية", "EST": "التوقيت الرسمي الشرقي لأمريكا الشمالية", "GFT": "توقيت غويانا الفرنسية", "GMT": "توقيت غرينتش", "GST": "توقيت الخليج", "GYT": "توقيت غيانا", "HADT": "توقيت هاواي ألوتيان الصيفي", "HAST": "توقيت هاواي ألوتيان الرسمي", "HAT": "توقيت نيوفاوندلاند الصيفي", "HECU": "توقيت كوبا الصيفي", "HEEG": "توقيت شرق غرينلاند الصيفي", "HENOMX": "التوقيت الصيفي لشمال غرب المكسيك", "HEOG": "توقيت غرب غرينلاند الصيفي", "HEPM": "توقيت سانت بيير وميكولون الصيفي", "HEPMX": "توقيت المحيط الهادي الصيفي للمكسيك", "HKST": "توقيت هونغ كونغ الصيفي", "HKT": "توقيت هونغ كونغ الرسمي", "HNCU": "توقيت كوبا الرسمي", "HNEG": "توقيت شرق غرينلاند الرسمي", "HNNOMX": "التوقيت الرسمي لشمال غرب المكسيك", "HNOG": "توقيت غرب غرينلاند الرسمي", "HNPM": "توقيت سانت بيير وميكولون الرسمي", "HNPMX": "توقيت المحيط الهادي الرسمي للمكسيك", "HNT": "توقيت نيوفاوندلاند الرسمي", "IST": "توقيت الهند", "JDT": "توقيت اليابان الصيفي", "JST": "توقيت اليابان الرسمي", "LHDT": "التوقيت الصيفي للورد هاو", "LHST": "توقيت لورد هاو الرسمي", "MDT": "التوقيت الجبلي الصيفي لأمريكا الشمالية", "MESZ": "توقيت وسط أوروبا الصيفي", "MEZ": "توقيت وسط أوروبا الرسمي", "MST": "التوقيت الجبلي الرسمي لأمريكا الشمالية", "MYT": "توقيت ماليزيا", "NZDT": "توقيت نيوزيلندا الصيفي", "NZST": "توقيت نيوزيلندا الرسمي", "OESZ": "توقيت شرق أوروبا الصيفي", "OEZ": "توقيت شرق أوروبا الرسمي", "PDT": "توقيت المحيط الهادي الصيفي", "PST": "توقيت المحيط الهادي الرسمي", "SAST": "توقيت جنوب أفريقيا", "SGT": "توقيت سنغافورة", "SRT": "توقيت سورينام", "TMST": "توقيت تركمانستان الصيفي", "TMT": "توقيت تركمانستان الرسمي", "UYST": "توقيت أوروغواي الصيفي", "UYT": "توقيت أوروغواي الرسمي", "VET": "توقيت فنزويلا", "WARST": "توقيت غرب الأرجنتين الصيفي", "WART": "توقيت غرب الأرجنتين الرسمي", "WAST": "توقيت غرب أفريقيا الصيفي", "WAT": "توقيت غرب أفريقيا الرسمي", "WESZ": "توقيت غرب أوروبا الصيفي", "WEZ": "توقيت غرب أوروبا الرسمي", "WIB": "توقيت غرب إندونيسيا", "WIT": "توقيت شرق إندونيسيا", "WITA": "توقيت وسط إندونيسيا", "∅∅∅": "توقيت برازيليا الصيفي"},

			fnCardinalPluralRule:  fnCardinalPluralRule_f27514af189883ea7cd186156edfe998,
			fnDecimal:             fnDecimal_a78485e7dd32c95f41af4e18420793bf,
			fnFmtAccounting:       fnFmtAccounting_f74088692afba81682b73af3d3e7c19a,
			fnFmtCurrency:         fnFmtCurrency_e28d302f22cf4ed4b5009e290f74e359,
			fnFmtDateFull:         fnFmtDateFull_2d3b405215099e683568cb9c052cbd54,
			fnFmtDateLong:         fnFmtDateLong_506f643cda0514f66d873a9ea99bf639,
			fnFmtDateMedium:       fnFmtDateMedium_a55320da438aec0cfbc31bc4d718abc1,
			fnFmtDateShort:        fnFmtDateShort_05c85041b5f9b6fa224b9c4ba9be3590,
			fnFmtNumber:           fnFmtNumber_eef52ddc8fa71bd12171ac9ef3cd3328,
			fnFmtPercent:          fnFmtPercent_60ca2e9d27b8160a5fec0f6694129759,
			fnFmtTimeFull:         fnFmtTimeFull_37fe4deeee789852cc196a6a1a2f0ccc,
			fnFmtTimeLong:         fnFmtTimeLong_4429ef4fb58a2a9c4d7d5132fd16ecbf,
			fnFmtTimeMedium:       fnFmtTimeMedium_8ef07f6477b7a4944577d4e5392ff21b,
			fnFmtTimeShort:        fnFmtTimeShort_8288b817c5c0216c9815524c71c9e0b4,
			fnGroup:               fnGroup_5c4b80a5ccdee81467241784ab8fcd56,
			fnLocale:              fnLocale_5a217059c67094defae82f249f55f4c5,
			fnMinus:               fnMinus_8b8229905258388dc16a5e0c270b0488,
			fnMonthAbbreviated:    fnMonthAbbreviated_aa9a9957cd9d056ba078b36a08b17478,
			fnMonthNarrow:         fnMonthNarrow_45916040ecf6fc350894d9e3e6c46dc7,
			fnMonthWide:           fnMonthWide_4c946a7e7581c665e7407df1841810b5,
			fnMonthsAbbreviated:   fnMonthsAbbreviated_181f77804b62232997fae36bd57d6cf7,
			fnMonthsNarrow:        fnMonthsNarrow_75daa2ba82ae9577292175c3f52370cc,
			fnMonthsWide:          fnMonthsWide_0ecf36a8b72255e2fee9467af362e989,
			fnOrdinalPluralRule:   fnOrdinalPluralRule_3355865f05dde9af2a36ba415bea85cb,
			fnPluralsCardinal:     fnPluralsCardinal_85b19cac1fab9f2c2cfb9eb41539aa0e,
			fnPluralsOrdinal:      fnPluralsOrdinal_16a60aa09da9778fa82fe463e83076de,
			fnPluralsRange:        fnPluralsRange_332465bda13eb808b3664fa0500f54ce,
			fnRangePluralRule:     fnRangePluralRule_47500e2a682fd3a64da69f06f7b93c0a,
			fnWeekdayAbbreviated:  fnWeekdayAbbreviated_4ffbdfbd2be10e6bd8fb5a542a14664a,
			fnWeekdayNarrow:       fnWeekdayNarrow_e86921b3446df5ea9afe9504cfa20d1a,
			fnWeekdayShort:        fnWeekdayShort_82b231d4f504c6d71c7e495aa35cd3c2,
			fnWeekdayWide:         fnWeekdayWide_ab7e026d8685cefd89c5aeb5df512a9a,
			fnWeekdaysAbbreviated: fnWeekdaysAbbreviated_454a3d7d23c662520a64ae5245d404be,
			fnWeekdaysNarrow:      fnWeekdaysNarrow_d23eb0b7a498c40ce19d1bf231cad524,
			fnWeekdaysShort:       fnWeekdaysShort_eb6ee64d01e314991432b4469790d38b,
			fnWeekdaysWide:        fnWeekdaysWide_5e2bbf75a31e730429c100e8a0bd3ebd,
		}
	}
	translatorFuncs["as"] = func() locales.Translator {
		return &localen{

			locale:                 "as",
			pluralsCardinal:        []locales.PluralRule{2, 6},
			pluralsOrdinal:         []locales.PluralRule{2, 3, 4, 5, 6},
			pluralsRange:           []locales.PluralRule{2, 6},
			decimal:                ".",
			group:                  ",",
			minus:                  "-",
			percent:                "%",
			perMille:               "‰",
			timeSeparator:          ":",
			inifinity:              "∞",
			currencies:             []string{"ADP", "AED", "AFA", "AFN", "ALK", "ALL", "AMD", "ANG", "AOA", "AOK", "AON", "AOR", "ARA", "ARL", "ARM", "ARP", "ARS", "ATS", "A$", "AWG", "AZM", "AZN", "BAD", "BAM", "BAN", "BBD", "BDT", "BEC", "BEF", "BEL", "BGL", "BGM", "BGN", "BGO", "BHD", "BIF", "BMD", "BND", "BOB", "BOL", "BOP", "BOV", "BRB", "BRC", "BRE", "R$", "BRN", "BRR", "BRZ", "BSD", "BTN", "BUK", "BWP", "BYB", "BYN", "BYR", "BZD", "CA$", "CDF", "CHE", "CHF", "CHW", "CLE", "CLF", "CLP", "CNH", "CNX", "CN¥", "COP", "COU", "CRC", "CSD", "CSK", "CUC", "CUP", "CVE", "CYP", "CZK", "DDM", "DEM", "DJF", "DKK", "DOP", "DZD", "ECS", "ECV", "EEK", "EGP", "ERN", "ESA", "ESB", "ESP", "ETB", "€", "FIM", "FJD", "FKP", "FRF", "£", "GEK", "GEL", "GHC", "GHS", "GIP", "GMD", "GNF", "GNS", "GQE", "GRD", "GTQ", "GWE", "GWP", "GYD", "HK$", "HNL", "HRD", "HRK", "HTG", "HUF", "IDR", "IEP", "ILP", "ILR", "₪", "₹", "IQD", "IRR", "ISJ", "ISK", "ITL", "JMD", "JOD", "JP¥", "KES", "KGS", "KHR", "KMF", "KPW", "KRH", "KRO", "₩", "KWD", "KYD", "KZT", "LAK", "LBP", "LKR", "LRD", "LSL", "LTL", "LTT", "LUC", "LUF", "LUL", "LVL", "LVR", "LYD", "MAD", "MAF", "MCF", "MDC", "MDL", "MGA", "MGF", "MKD", "MKN", "MLF", "MMK", "MNT", "MOP", "MRO", "MRU", "MTL", "MTP", "MUR", "MVP", "MVR", "MWK", "MX$", "MXP", "MXV", "MYR", "MZE", "MZM", "MZN", "NAD", "NGN", "NIC", "NIO", "NLG", "NOK", "NPR", "NZ$", "OMR", "PAB", "PEI", "PEN", "PES", "PGK", "PHP", "PKR", "PLN", "PLZ", "PTE", "PYG", "QAR", "RHD", "ROL", "RON", "RSD", "RUB", "RUR", "RWF", "SAR", "SBD", "SCR", "SDD", "SDG", "SDP", "SEK", "SGD", "SHP", "SIT", "SKK", "SLL", "SOS", "SRD", "SRG", "SSP", "STD", "STN", "SUR", "SVC", "SYP", "SZL", "THB", "TJR", "TJS", "TMM", "TMT", "TND", "TOP", "TPE", "TRL", "TRY", "TTD", "NT$", "TZS", "UAH", "UAK", "UGS", "UGX", "US$", "USN", "USS", "UYI", "UYP", "UYU", "UYW", "UZS", "VEB", "VEF", "VES", "₫", "VNN", "VUV", "WST", "FCFA", "XAG", "XAU", "XBA", "XBB", "XBC", "XBD", "EC$", "XDR", "XEU", "XFO", "XFU", "CFA", "XPD", "CFPF", "XPT", "XRE", "XSU", "XTS", "XUA", "XXX", "YDD", "YER", "YUD", "YUM", "YUN", "YUR", "ZAL", "ZAR", "ZMK", "ZMW", "ZRN", "ZRZ", "ZWD", "ZWL", "ZWR"},
			currencyPositivePrefix: " ",
			currencyNegativePrefix: " ",
			monthsAbbreviated:      []string{"", "জানু", "ফেব্ৰু", "মাৰ্চ", "এপ্ৰিল", "মে’", "জুন", "জুলাই", "আগ", "ছেপ্তে", "অক্টো", "নৱে", "ডিচে"},
			monthsNarrow:           []string{"", "জ", "ফ", "ম", "এ", "ম", "জ", "জ", "আ", "ছ", "অ", "ন", "ড"},
			monthsWide:             []string{"", "জানুৱাৰী", "ফেব্ৰুৱাৰী", "মাৰ্চ", "এপ্ৰিল", "মে’", "জুন", "জুলাই", "আগষ্ট", "ছেপ্তেম্বৰ", "অক্টোবৰ", "নৱেম্বৰ", "ডিচেম্বৰ"},
			daysAbbreviated:        []string{"দেও", "সোম", "মঙ্গল", "বুধ", "বৃহ", "শুক্ৰ", "শনি"},
			daysNarrow:             []string{"দ", "স", "ম", "ব", "ব", "শ", "শ"},
			daysShort:              []string{"দেও", "সোম", "মঙ্গল", "বুধ", "বৃহ", "শুক্ৰ", "শনি"},
			daysWide:               []string{"দেওবাৰ", "সোমবাৰ", "মঙ্গলবাৰ", "বুধবাৰ", "বৃহস্পতিবাৰ", "শুক্ৰবাৰ", "শনিবাৰ"},
			periodsAbbreviated:     []string{"পূৰ্বাহ্ন", "অপৰাহ্ন"},
			periodsNarrow:          []string{"পূৰ্বাহ্ন", "অপৰাহ্ন"},
			periodsWide:            []string{"পূৰ্বাহ্ন", "অপৰাহ্ন"},
			erasAbbreviated:        []string{"খ্ৰীঃ পূঃ", "খ্ৰীঃ"},
			erasNarrow:             []string{"", ""},
			erasWide:               []string{"খ্ৰীষ্টপূৰ্ব", "খ্ৰীষ্টাব্দ"},
			timezones:              map[string]string{"ACDT": "অষ্ট্ৰেলিয়াৰ কেন্দ্ৰীয় ডেলাইট সময়", "ACST": "অষ্ট্ৰেলিয়াৰ কেন্দ্ৰীয় মান সময়", "ACWDT": "অষ্ট্ৰেলিয়াৰ কেন্দ্ৰীয় পাশ্চাত্য ডেলাইট সময়", "ACWST": "অষ্ট্ৰেলিয়াৰ কেন্দ্ৰীয় পাশ্চাত্য মান সময়", "ADT": "আটলাণ্টিক ডেলাইট সময়", "AEDT": "অষ্ট্ৰেলিয়াৰ প্ৰাচ্য ডেলাইট সময়", "AEST": "অষ্ট্ৰেলিয়াৰ প্ৰাচ্য মান সময়", "AKDT": "আলাস্কাৰ ডেলাইট সময়", "AKST": "আলাস্কাৰ মান সময়", "ARST": "আৰ্জেণ্টিনাৰ গ্ৰীষ্মকালীন সময়", "ART": "আৰ্জেণ্টিনাৰ মান সময়", "AST": "আটলাণ্টিক মান সময়", "AWDT": "অষ্ট্ৰেলিয়াৰ পাশ্চাত্য ডেলাইট সময়", "AWST": "অষ্ট্ৰেলিয়াৰ পাশ্চাত্য মান সময়", "BOT": "বলিভিয়াৰ সময়", "BT": "ভুটানৰ সময়", "CAT": "মধ্য আফ্ৰিকাৰ সময়", "CDT": "উত্তৰ আমেৰিকাৰ কেন্দ্ৰীয় ডেলাইট সময়", "CHADT": "চাথামৰ ডেলাইট সময়", "CHAST": "চাথামৰ মান সময়", "CLST": "চিলিৰ গ্ৰীষ্মকালীন সময়", "CLT": "চিলিৰ মান সময়", "COST": "কলম্বিয়াৰ গ্ৰীষ্মকালীন সময়", "COT": "কলম্বিয়াৰ মান সময়", "CST": "উত্তৰ আমেৰিকাৰ কেন্দ্ৰীয় মান সময়", "ChST": "চামোৰোৰ মান সময়", "EAT": "পূব আফ্ৰিকাৰ সময়", "ECT": "ইকুৱেডৰৰ সময়", "EDT": "উত্তৰ আমেৰিকাৰ প্ৰাচ্য ডেলাইট সময়", "EST": "উত্তৰ আমেৰিকাৰ প্ৰাচ্য মান সময়", "GFT": "ফ্ৰান্স গয়ানাৰ সময়", "GMT": "গ্ৰীণউইচ মান সময়", "GST": "উপসাগৰীয় মান সময়", "GYT": "গায়ানাৰ সময়", "HADT": "হাৱাই-এলিউশ্বনৰ ডেলাইট সময়", "HAST": "হাৱাই-এলিউশ্বনৰ মান সময়", "HAT": "নিউফাউণ্ডলেণ্ডৰ ডেলাইট সময়", "HECU": "কিউবাৰ ডেলাইট সময়", "HEEG": "পূব গ্ৰীণলেণ্ডৰ গ্ৰীষ্মকালীন সময়", "HENOMX": "উত্তৰ-পশ্চিম মেক্সিকোৰ ডেলাইট সময়", "HEOG": "পশ্চিম গ্ৰীণলেণ্ডৰ গ্ৰীষ্মকালীন সময়", "HEPM": "ছেইণ্ট পিয়েৰে আৰু মিকিউৱেলনৰ ডেলাইট সময়", "HEPMX": "মেক্সিকোৰ প্ৰশান্ত ডেলাইট সময়", "HKST": "হং কঙৰ গ্ৰীষ্মকালীন সময়", "HKT": "হং কঙৰ মান সময়", "HNCU": "কিউবাৰ মান সময়", "HNEG": "পূব গ্ৰীণলেণ্ডৰ মান সময়", "HNNOMX": "উত্তৰ-পশ্চিম মেক্সিকোৰ মান সময়", "HNOG": "পশ্চিম গ্ৰীণলেণ্ডৰ মান সময়", "HNPM": "ছেইণ্ট পিয়েৰে আৰু মিকিউৱেলনৰ মান সময়", "HNPMX": "মেক্সিকোৰ প্ৰশান্ত মান সময়", "HNT": "নিউফাউণ্ডলেণ্ডৰ মান সময়", "IST": "ভাৰতীয় মান সময়", "JDT": "জাপানৰ ডেলাইট সময়", "JST": "জাপানৰ মান সময়", "LHDT": "লৰ্ড হাওৰ ডেলাইট সময়", "LHST": "লৰ্ড হাওৰ মান সময়", "MDT": "উত্তৰ আমেৰিকাৰ পৰ্ব্বতীয় ডেলাইট সময়", "MESZ": "মধ্য ইউৰোপীয় গ্ৰীষ্মকালীন সময়", "MEZ": "মধ্য ইউৰোপীয় মান সময়", "MST": "উত্তৰ আমেৰিকাৰ পৰ্ব্বতীয় মান সময়", "MYT": "মালয়েচিয়াৰ সময়", "NZDT": "নিউজিলেণ্ডৰ ডেলাইট সময়", "NZST": "নিউজিলেণ্ডৰ মান সময়", "OESZ": "প্ৰাচ্য ইউৰোপীয় গ্ৰীষ্মকালীন সময়", "OEZ": "প্ৰাচ্য ইউৰোপীয় মান সময়", "PDT": "উত্তৰ আমেৰিকাৰ ডেলাইট সময়", "PST": "উত্তৰ আমেৰিকাৰ প্ৰশান্ত মান সময়", "SAST": "দক্ষিণ আফ্ৰিকাৰ মান সময়", "SGT": "ছিংগাপুৰৰ মান সময়", "SRT": "ছুৰিনামৰ সময়", "TMST": "তুৰ্কমেনিস্তানৰ গ্ৰীষ্মকালীন সময়", "TMT": "তুৰ্কমেনিস্তানৰ মান সময়", "UYST": "উৰুগুৱেৰ গ্ৰীষ্মকালীন সময়", "UYT": "উৰুগুৱেৰ মান সময়", "VET": "ভেনিজুৱেলাৰ সময়", "WARST": "পাশ্চাত্য আৰ্জেণ্টিনাৰ গ্ৰীষ্মকালীন সময়", "WART": "পাশ্চাত্য আৰ্জেণ্টিনাৰ মান সময়", "WAST": "পশ্চিম আফ্ৰিকাৰ গ্ৰীষ্মকালীন সময়", "WAT": "পশ্চিম আফ্ৰিকাৰ মান সময়", "WESZ": "পাশ্চাত্য ইউৰোপীয় গ্ৰীষ্মকালীন সময়", "WEZ": "পাশ্চাত্য ইউৰোপীয় মান সময়", "WIB": "পাশ্চাত্য ইণ্ডোনেচিয়াৰ সময়", "WIT": "প্ৰাচ্য ইণ্ডোনেচিয়াৰ সময়", "WITA": "মধ্য ইণ্ডোনেচিয়াৰ সময়", "∅∅∅": "ব্ৰাজিলিয়াৰ গ্ৰীষ্মকালীন সময়"},

			fnCardinalPluralRule:  fnCardinalPluralRule_75ab0b9c6a421f5e6ca85392796c18cc,
			fnDecimal:             fnDecimal_a78485e7dd32c95f41af4e18420793bf,
			fnFmtAccounting:       fnFmtAccounting_cd503abfb0c9bd938bcf20e65858f8d7,
			fnFmtCurrency:         fnFmtCurrency_9f465d9454a1702118c7b32dfb89b3d1,
			fnFmtDateFull:         fnFmtDateFull_bd1b45bc043b6b4e8c3b831b9263891b,
			fnFmtDateLong:         fnFmtDateLong_a234d460b585eebc392634bc08485ebd,
			fnFmtDateMedium:       fnFmtDateMedium_7b5970ebef47b6071b7a9bff570eba75,
			fnFmtDateShort:        fnFmtDateShort_48f6d56925de0117a6fe7b1ec232f585,
			fnFmtNumber:           fnFmtNumber_d7ae7636100e1f19a61ae0ac52b51e8c,
			fnFmtPercent:          fnFmtPercent_1c35b3868bf10d0e69b22b2e80c40671,
			fnFmtTimeFull:         fnFmtTimeFull_3ce7dc5b6b225559fd40d102900d6c81,
			fnFmtTimeLong:         fnFmtTimeLong_b2fdf6411542ab907630622b3d42a6b0,
			fnFmtTimeMedium:       fnFmtTimeMedium_74593f8f5ae9c1a3e4637628d509c179,
			fnFmtTimeShort:        fnFmtTimeShort_6c9fb1bcda2b27013e9a8a47c7326805,
			fnGroup:               fnGroup_5c4b80a5ccdee81467241784ab8fcd56,
			fnLocale:              fnLocale_5a217059c67094defae82f249f55f4c5,
			fnMinus:               fnMinus_8b8229905258388dc16a5e0c270b0488,
			fnMonthAbbreviated:    fnMonthAbbreviated_aa9a9957cd9d056ba078b36a08b17478,
			fnMonthNarrow:         fnMonthNarrow_45916040ecf6fc350894d9e3e6c46dc7,
			fnMonthWide:           fnMonthWide_4c946a7e7581c665e7407df1841810b5,
			fnMonthsAbbreviated:   fnMonthsAbbreviated_181f77804b62232997fae36bd57d6cf7,
			fnMonthsNarrow:        fnMonthsNarrow_75daa2ba82ae9577292175c3f52370cc,
			fnMonthsWide:          fnMonthsWide_0ecf36a8b72255e2fee9467af362e989,
			fnOrdinalPluralRule:   fnOrdinalPluralRule_2d950970290e57f43f401dd367ad94dc,
			fnPluralsCardinal:     fnPluralsCardinal_85b19cac1fab9f2c2cfb9eb41539aa0e,
			fnPluralsOrdinal:      fnPluralsOrdinal_16a60aa09da9778fa82fe463e83076de,
			fnPluralsRange:        fnPluralsRange_332465bda13eb808b3664fa0500f54ce,
			fnRangePluralRule:     fnRangePluralRule_f6915080a9290ab0c1dd0a3b010cbce8,
			fnWeekdayAbbreviated:  fnWeekdayAbbreviated_4ffbdfbd2be10e6bd8fb5a542a14664a,
			fnWeekdayNarrow:       fnWeekdayNarrow_e86921b3446df5ea9afe9504cfa20d1a,
			fnWeekdayShort:        fnWeekdayShort_82b231d4f504c6d71c7e495aa35cd3c2,
			fnWeekdayWide:         fnWeekdayWide_ab7e026d8685cefd89c5aeb5df512a9a,
			fnWeekdaysAbbreviated: fnWeekdaysAbbreviated_454a3d7d23c662520a64ae5245d404be,
			fnWeekdaysNarrow:      fnWeekdaysNarrow_d23eb0b7a498c40ce19d1bf231cad524,
			fnWeekdaysShort:       fnWeekdaysShort_eb6ee64d01e314991432b4469790d38b,
			fnWeekdaysWide:        fnWeekdaysWide_5e2bbf75a31e730429c100e8a0bd3ebd,
		}
	}
	translatorFuncs["as_in"] = func() locales.Translator {
		return &localen{

			locale:                 "as_IN",
			pluralsCardinal:        []locales.PluralRule{2, 6},
			pluralsOrdinal:         []locales.PluralRule{2, 3, 4, 5, 6},
			pluralsRange:           []locales.PluralRule{2, 6},
			decimal:                ".",
			group:                  ",",
			minus:                  "-",
			percent:                "%",
			perMille:               "‰",
			timeSeparator:          ":",
			inifinity:              "∞",
			currencies:             []string{"ADP", "AED", "AFA", "AFN", "ALK", "ALL", "AMD", "ANG", "AOA", "AOK", "AON", "AOR", "ARA", "ARL", "ARM", "ARP", "ARS", "ATS", "AUD", "AWG", "AZM", "AZN", "BAD", "BAM", "BAN", "BBD", "BDT", "BEC", "BEF", "BEL", "BGL", "BGM", "BGN", "BGO", "BHD", "BIF", "BMD", "BND", "BOB", "BOL", "BOP", "BOV", "BRB", "BRC", "BRE", "BRL", "BRN", "BRR", "BRZ", "BSD", "BTN", "BUK", "BWP", "BYB", "BYN", "BYR", "BZD", "CAD", "CDF", "CHE", "CHF", "CHW", "CLE", "CLF", "CLP", "CNH", "CNX", "CNY", "COP", "COU", "CRC", "CSD", "CSK", "CUC", "CUP", "CVE", "CYP", "CZK", "DDM", "DEM", "DJF", "DKK", "DOP", "DZD", "ECS", "ECV", "EEK", "EGP", "ERN", "ESA", "ESB", "ESP", "ETB", "EUR", "FIM", "FJD", "FKP", "FRF", "GBP", "GEK", "GEL", "GHC", "GHS", "GIP", "GMD", "GNF", "GNS", "GQE", "GRD", "GTQ", "GWE", "GWP", "GYD", "HKD", "HNL", "HRD", "HRK", "HTG", "HUF", "IDR", "IEP", "ILP", "ILR", "ILS", "INR", "IQD", "IRR", "ISJ", "ISK", "ITL", "JMD", "JOD", "JPY", "KES", "KGS", "KHR", "KMF", "KPW", "KRH", "KRO", "KRW", "KWD", "KYD", "KZT", "LAK", "LBP", "LKR", "LRD", "LSL", "LTL", "LTT", "LUC", "LUF", "LUL", "LVL", "LVR", "LYD", "MAD", "MAF", "MCF", "MDC", "MDL", "MGA", "MGF", "MKD", "MKN", "MLF", "MMK", "MNT", "MOP", "MRO", "MRU", "MTL", "MTP", "MUR", "MVP", "MVR", "MWK", "MXN", "MXP", "MXV", "MYR", "MZE", "MZM", "MZN", "NAD", "NGN", "NIC", "NIO", "NLG", "NOK", "NPR", "NZD", "OMR", "PAB", "PEI", "PEN", "PES", "PGK", "PHP", "PKR", "PLN", "PLZ", "PTE", "PYG", "QAR", "RHD", "ROL", "RON", "RSD", "RUB", "RUR", "RWF", "SAR", "SBD", "SCR", "SDD", "SDG", "SDP", "SEK", "SGD", "SHP", "SIT", "SKK", "SLL", "SOS", "SRD", "SRG", "SSP", "STD", "STN", "SUR", "SVC", "SYP", "SZL", "THB", "TJR", "TJS", "TMM", "TMT", "TND", "TOP", "TPE", "TRL", "TRY", "TTD", "TWD", "TZS", "UAH", "UAK", "UGS", "UGX", "USD", "USN", "USS", "UYI", "UYP", "UYU", "UYW", "UZS", "VEB", "VEF", "VES", "VND", "VNN", "VUV", "WST", "XAF", "XAG", "XAU", "XBA", "XBB", "XBC", "XBD", "XCD", "XDR", "XEU", "XFO", "XFU", "XOF", "XPD", "XPF", "XPT", "XRE", "XSU", "XTS", "XUA", "XXX", "YDD", "YER", "YUD", "YUM", "YUN", "YUR", "ZAL", "ZAR", "ZMK", "ZMW", "ZRN", "ZRZ", "ZWD", "ZWL", "ZWR"},
			currencyPositivePrefix: " ",
			currencyNegativePrefix: " ",
			monthsAbbreviated:      []string{"", "জানু", "ফেব্ৰু", "মাৰ্চ", "এপ্ৰিল", "মে’", "জুন", "জুলাই", "আগ", "ছেপ্তে", "অক্টো", "নৱে", "ডিচে"},
			monthsNarrow:           []string{"", "জ", "ফ", "ম", "এ", "ম", "জ", "জ", "আ", "ছ", "অ", "ন", "ড"},
			monthsWide:             []string{"", "জানুৱাৰী", "ফেব্ৰুৱাৰী", "মাৰ্চ", "এপ্ৰিল", "মে’", "জুন", "জুলাই", "আগষ্ট", "ছেপ্তেম্বৰ", "অক্টোবৰ", "নৱেম্বৰ", "ডিচেম্বৰ"},
			daysAbbreviated:        []string{"দেও", "সোম", "মঙ্গল", "বুধ", "বৃহ", "শুক্ৰ", "শনি"},
			daysNarrow:             []string{"দ", "স", "ম", "ব", "ব", "শ", "শ"},
			daysShort:              []string{"দেও", "সোম", "মঙ্গল", "বুধ", "বৃহ", "শুক্ৰ", "শনি"},
			daysWide:               []string{"দেওবাৰ", "সোমবাৰ", "মঙ্গলবাৰ", "বুধবাৰ", "বৃহস্পতিবাৰ", "শুক্ৰবাৰ", "শনিবাৰ"},
			periodsAbbreviated:     []string{"পূৰ্বাহ্ন", "অপৰাহ্ন"},
			periodsNarrow:          []string{"পূৰ্বাহ্ন", "অপৰাহ্ন"},
			periodsWide:            []string{"পূৰ্বাহ্ন", "অপৰাহ্ন"},
			erasAbbreviated:        []string{"খ্ৰীঃ পূঃ", "খ্ৰীঃ"},
			erasNarrow:             []string{"", ""},
			erasWide:               []string{"খ্ৰীষ্টপূৰ্ব", "খ্ৰীষ্টাব্দ"},
			timezones:              map[string]string{"ACDT": "অষ্ট্ৰেলিয়াৰ কেন্দ্ৰীয় ডেলাইট সময়", "ACST": "অষ্ট্ৰেলিয়াৰ কেন্দ্ৰীয় মান সময়", "ACWDT": "অষ্ট্ৰেলিয়াৰ কেন্দ্ৰীয় পাশ্চাত্য ডেলাইট সময়", "ACWST": "অষ্ট্ৰেলিয়াৰ কেন্দ্ৰীয় পাশ্চাত্য মান সময়", "ADT": "আটলাণ্টিক ডেলাইট সময়", "AEDT": "অষ্ট্ৰেলিয়াৰ প্ৰাচ্য ডেলাইট সময়", "AEST": "অষ্ট্ৰেলিয়াৰ প্ৰাচ্য মান সময়", "AKDT": "আলাস্কাৰ ডেলাইট সময়", "AKST": "আলাস্কাৰ মান সময়", "ARST": "আৰ্জেণ্টিনাৰ গ্ৰীষ্মকালীন সময়", "ART": "আৰ্জেণ্টিনাৰ মান সময়", "AST": "আটলাণ্টিক মান সময়", "AWDT": "অষ্ট্ৰেলিয়াৰ পাশ্চাত্য ডেলাইট সময়", "AWST": "অষ্ট্ৰেলিয়াৰ পাশ্চাত্য মান সময়", "BOT": "বলিভিয়াৰ সময়", "BT": "ভুটানৰ সময়", "CAT": "মধ্য আফ্ৰিকাৰ সময়", "CDT": "উত্তৰ আমেৰিকাৰ কেন্দ্ৰীয় ডেলাইট সময়", "CHADT": "চাথামৰ ডেলাইট সময়", "CHAST": "চাথামৰ মান সময়", "CLST": "চিলিৰ গ্ৰীষ্মকালীন সময়", "CLT": "চিলিৰ মান সময়", "COST": "কলম্বিয়াৰ গ্ৰীষ্মকালীন সময়", "COT": "কলম্বিয়াৰ মান সময়", "CST": "উত্তৰ আমেৰিকাৰ কেন্দ্ৰীয় মান সময়", "ChST": "চামোৰোৰ মান সময়", "EAT": "পূব আফ্ৰিকাৰ সময়", "ECT": "ইকুৱেডৰৰ সময়", "EDT": "উত্তৰ আমেৰিকাৰ প্ৰাচ্য ডেলাইট সময়", "EST": "উত্তৰ আমেৰিকাৰ প্ৰাচ্য মান সময়", "GFT": "ফ্ৰান্স গয়ানাৰ সময়", "GMT": "গ্ৰীণউইচ মান সময়", "GST": "উপসাগৰীয় মান সময়", "GYT": "গায়ানাৰ সময়", "HADT": "হাৱাই-এলিউশ্বনৰ ডেলাইট সময়", "HAST": "হাৱাই-এলিউশ্বনৰ মান সময়", "HAT": "নিউফাউণ্ডলেণ্ডৰ ডেলাইট সময়", "HECU": "কিউবাৰ ডেলাইট সময়", "HEEG": "পূব গ্ৰীণলেণ্ডৰ গ্ৰীষ্মকালীন সময়", "HENOMX": "উত্তৰ-পশ্চিম মেক্সিকোৰ ডেলাইট সময়", "HEOG": "পশ্চিম গ্ৰীণলেণ্ডৰ গ্ৰীষ্মকালীন সময়", "HEPM": "ছেইণ্ট পিয়েৰে আৰু মিকিউৱেলনৰ ডেলাইট সময়", "HEPMX": "মেক্সিকোৰ প্ৰশান্ত ডেলাইট সময়", "HKST": "হং কঙৰ গ্ৰীষ্মকালীন সময়", "HKT": "হং কঙৰ মান সময়", "HNCU": "কিউবাৰ মান সময়", "HNEG": "পূব গ্ৰীণলেণ্ডৰ মান সময়", "HNNOMX": "উত্তৰ-পশ্চিম মেক্সিকোৰ মান সময়", "HNOG": "পশ্চিম গ্ৰীণলেণ্ডৰ মান সময়", "HNPM": "ছেইণ্ট পিয়েৰে আৰু মিকিউৱেলনৰ মান সময়", "HNPMX": "মেক্সিকোৰ প্ৰশান্ত মান সময়", "HNT": "নিউফাউণ্ডলেণ্ডৰ মান সময়", "IST": "ভাৰতীয় মান সময়", "JDT": "জাপানৰ ডেলাইট সময়", "JST": "জাপানৰ মান সময়", "LHDT": "লৰ্ড হাওৰ ডেলাইট সময়", "LHST": "লৰ্ড হাওৰ মান সময়", "MDT": "উত্তৰ আমেৰিকাৰ পৰ্ব্বতীয় ডেলাইট সময়", "MESZ": "মধ্য ইউৰোপীয় গ্ৰীষ্মকালীন সময়", "MEZ": "মধ্য ইউৰোপীয় মান সময়", "MST": "উত্তৰ আমেৰিকাৰ পৰ্ব্বতীয় মান সময়", "MYT": "মালয়েচিয়াৰ সময়", "NZDT": "নিউজিলেণ্ডৰ ডেলাইট সময়", "NZST": "নিউজিলেণ্ডৰ মান সময়", "OESZ": "প্ৰাচ্য ইউৰোপীয় গ্ৰীষ্মকালীন সময়", "OEZ": "প্ৰাচ্য ইউৰোপীয় মান সময়", "PDT": "উত্তৰ আমেৰিকাৰ ডেলাইট সময়", "PST": "উত্তৰ আমেৰিকাৰ প্ৰশান্ত মান সময়", "SAST": "দক্ষিণ আফ্ৰিকাৰ মান সময়", "SGT": "ছিংগাপুৰৰ মান সময়", "SRT": "ছুৰিনামৰ সময়", "TMST": "তুৰ্কমেনিস্তানৰ গ্ৰীষ্মকালীন সময়", "TMT": "তুৰ্কমেনিস্তানৰ মান সময়", "UYST": "উৰুগুৱেৰ গ্ৰীষ্মকালীন সময়", "UYT": "উৰুগুৱেৰ মান সময়", "VET": "ভেনিজুৱেলাৰ সময়", "WARST": "পাশ্চাত্য আৰ্জেণ্টিনাৰ গ্ৰীষ্মকালীন সময়", "WART": "পাশ্চাত্য আৰ্জেণ্টিনাৰ মান সময়", "WAST": "পশ্চিম আফ্ৰিকাৰ গ্ৰীষ্মকালীন সময়", "WAT": "পশ্চিম আফ্ৰিকাৰ মান সময়", "WESZ": "পাশ্চাত্য ইউৰোপীয় গ্ৰীষ্মকালীন সময়", "WEZ": "পাশ্চাত্য ইউৰোপীয় মান সময়", "WIB": "পাশ্চাত্য ইণ্ডোনেচিয়াৰ সময়", "WIT": "প্ৰাচ্য ইণ্ডোনেচিয়াৰ সময়", "WITA": "মধ্য ইণ্ডোনেচিয়াৰ সময়", "∅∅∅": "আজোৰেছৰ গ্ৰীষ্মকালীন সময়"},

			fnCardinalPluralRule:  fnCardinalPluralRule_75ab0b9c6a421f5e6ca85392796c18cc,
			fnDecimal:             fnDecimal_a78485e7dd32c95f41af4e18420793bf,
			fnFmtAccounting:       fnFmtAccounting_cd503abfb0c9bd938bcf20e65858f8d7,
			fnFmtCurrency:         fnFmtCurrency_9f465d9454a1702118c7b32dfb89b3d1,
			fnFmtDateFull:         fnFmtDateFull_bd1b45bc043b6b4e8c3b831b9263891b,
			fnFmtDateLong:         fnFmtDateLong_a234d460b585eebc392634bc08485ebd,
			fnFmtDateMedium:       fnFmtDateMedium_7b5970ebef47b6071b7a9bff570eba75,
			fnFmtDateShort:        fnFmtDateShort_48f6d56925de0117a6fe7b1ec232f585,
			fnFmtNumber:           fnFmtNumber_d7ae7636100e1f19a61ae0ac52b51e8c,
			fnFmtPercent:          fnFmtPercent_1c35b3868bf10d0e69b22b2e80c40671,
			fnFmtTimeFull:         fnFmtTimeFull_3ce7dc5b6b225559fd40d102900d6c81,
			fnFmtTimeLong:         fnFmtTimeLong_b2fdf6411542ab907630622b3d42a6b0,
			fnFmtTimeMedium:       fnFmtTimeMedium_74593f8f5ae9c1a3e4637628d509c179,
			fnFmtTimeShort:        fnFmtTimeShort_6c9fb1bcda2b27013e9a8a47c7326805,
			fnGroup:               fnGroup_5c4b80a5ccdee81467241784ab8fcd56,
			fnLocale:              fnLocale_5a217059c67094defae82f249f55f4c5,
			fnMinus:               fnMinus_8b8229905258388dc16a5e0c270b0488,
			fnMonthAbbreviated:    fnMonthAbbreviated_aa9a9957cd9d056ba078b36a08b17478,
			fnMonthNarrow:         fnMonthNarrow_45916040ecf6fc350894d9e3e6c46dc7,
			fnMonthWide:           fnMonthWide_4c946a7e7581c665e7407df1841810b5,
			fnMonthsAbbreviated:   fnMonthsAbbreviated_181f77804b62232997fae36bd57d6cf7,
			fnMonthsNarrow:        fnMonthsNarrow_75daa2ba82ae9577292175c3f52370cc,
			fnMonthsWide:          fnMonthsWide_0ecf36a8b72255e2fee9467af362e989,
			fnOrdinalPluralRule:   fnOrdinalPluralRule_2d950970290e57f43f401dd367ad94dc,
			fnPluralsCardinal:     fnPluralsCardinal_85b19cac1fab9f2c2cfb9eb41539aa0e,
			fnPluralsOrdinal:      fnPluralsOrdinal_16a60aa09da9778fa82fe463e83076de,
			fnPluralsRange:        fnPluralsRange_332465bda13eb808b3664fa0500f54ce,
			fnRangePluralRule:     fnRangePluralRule_f6915080a9290ab0c1dd0a3b010cbce8,
			fnWeekdayAbbreviated:  fnWeekdayAbbreviated_4ffbdfbd2be10e6bd8fb5a542a14664a,
			fnWeekdayNarrow:       fnWeekdayNarrow_e86921b3446df5ea9afe9504cfa20d1a,
			fnWeekdayShort:        fnWeekdayShort_82b231d4f504c6d71c7e495aa35cd3c2,
			fnWeekdayWide:         fnWeekdayWide_ab7e026d8685cefd89c5aeb5df512a9a,
			fnWeekdaysAbbreviated: fnWeekdaysAbbreviated_454a3d7d23c662520a64ae5245d404be,
			fnWeekdaysNarrow:      fnWeekdaysNarrow_d23eb0b7a498c40ce19d1bf231cad524,
			fnWeekdaysShort:       fnWeekdaysShort_eb6ee64d01e314991432b4469790d38b,
			fnWeekdaysWide:        fnWeekdaysWide_5e2bbf75a31e730429c100e8a0bd3ebd,
		}
	}
	translatorFuncs["asa"] = func() locales.Translator {
		return &localen{

			locale:                 "asa",
			pluralsCardinal:        []locales.PluralRule{2, 6},
			pluralsOrdinal:         nil,
			pluralsRange:           nil,
			timeSeparator:          ":",
			currencies:             []string{"ADP", "AED", "AFA", "AFN", "ALK", "ALL", "AMD", "ANG", "AOA", "AOK", "AON", "AOR", "ARA", "ARL", "ARM", "ARP", "ARS", "ATS", "AUD", "AWG", "AZM", "AZN", "BAD", "BAM", "BAN", "BBD", "BDT", "BEC", "BEF", "BEL", "BGL", "BGM", "BGN", "BGO", "BHD", "BIF", "BMD", "BND", "BOB", "BOL", "BOP", "BOV", "BRB", "BRC", "BRE", "BRL", "BRN", "BRR", "BRZ", "BSD", "BTN", "BUK", "BWP", "BYB", "BYN", "BYR", "BZD", "CAD", "CDF", "CHE", "CHF", "CHW", "CLE", "CLF", "CLP", "CNH", "CNX", "CNY", "COP", "COU", "CRC", "CSD", "CSK", "CUC", "CUP", "CVE", "CYP", "CZK", "DDM", "DEM", "DJF", "DKK", "DOP", "DZD", "ECS", "ECV", "EEK", "EGP", "ERN", "ESA", "ESB", "ESP", "ETB", "EUR", "FIM", "FJD", "FKP", "FRF", "GBP", "GEK", "GEL", "GHC", "GHS", "GIP", "GMD", "GNF", "GNS", "GQE", "GRD", "GTQ", "GWE", "GWP", "GYD", "HKD", "HNL", "HRD", "HRK", "HTG", "HUF", "IDR", "IEP", "ILP", "ILR", "ILS", "INR", "IQD", "IRR", "ISJ", "ISK", "ITL", "JMD", "JOD", "JPY", "KES", "KGS", "KHR", "KMF", "KPW", "KRH", "KRO", "KRW", "KWD", "KYD", "KZT", "LAK", "LBP", "LKR", "LRD", "LSL", "LTL", "LTT", "LUC", "LUF", "LUL", "LVL", "LVR", "LYD", "MAD", "MAF", "MCF", "MDC", "MDL", "MGA", "MGF", "MKD", "MKN", "MLF", "MMK", "MNT", "MOP", "MRO", "MRU", "MTL", "MTP", "MUR", "MVP", "MVR", "MWK", "MXN", "MXP", "MXV", "MYR", "MZE", "MZM", "MZN", "NAD", "NGN", "NIC", "NIO", "NLG", "NOK", "NPR", "NZD", "OMR", "PAB", "PEI", "PEN", "PES", "PGK", "PHP", "PKR", "PLN", "PLZ", "PTE", "PYG", "QAR", "RHD", "ROL", "RON", "RSD", "RUB", "RUR", "RWF", "SAR", "SBD", "SCR", "SDD", "SDG", "SDP", "SEK", "SGD", "SHP", "SIT", "SKK", "SLL", "SOS", "SRD", "SRG", "SSP", "STD", "STN", "SUR", "SVC", "SYP", "SZL", "THB", "TJR", "TJS", "TMM", "TMT", "TND", "TOP", "TPE", "TRL", "TRY", "TTD", "TWD", "TSh", "UAH", "UAK", "UGS", "UGX", "USD", "USN", "USS", "UYI", "UYP", "UYU", "UYW", "UZS", "VEB", "VEF", "VES", "VND", "VNN", "VUV", "WST", "XAF", "XAG", "XAU", "XBA", "XBB", "XBC", "XBD", "XCD", "XDR", "XEU", "XFO", "XFU", "XOF", "XPD", "XPF", "XPT", "XRE", "XSU", "XTS", "XUA", "XXX", "YDD", "YER", "YUD", "YUM", "YUN", "YUR", "ZAL", "ZAR", "ZMK", "ZMW", "ZRN", "ZRZ", "ZWD", "ZWL", "ZWR"},
			currencyPositiveSuffix: " ",
			currencyNegativeSuffix: " ",
			monthsAbbreviated:      []string{"", "Jan", "Feb", "Mac", "Apr", "Mei", "Jun", "Jul", "Ago", "Sep", "Okt", "Nov", "Dec"},
			monthsNarrow:           []string{"", "J", "F", "M", "A", "M", "J", "J", "A", "S", "O", "N", "D"},
			monthsWide:             []string{"", "Januari", "Februari", "Machi", "Aprili", "Mei", "Juni", "Julai", "Agosti", "Septemba", "Oktoba", "Novemba", "Desemba"},
			daysAbbreviated:        []string{"Jpi", "Jtt", "Jnn", "Jtn", "Alh", "Ijm", "Jmo"},
			daysNarrow:             []string{"J", "J", "J", "J", "A", "I", "J"},
			daysWide:               []string{"Jumapili", "Jumatatu", "Jumanne", "Jumatano", "Alhamisi", "Ijumaa", "Jumamosi"},
			periodsAbbreviated:     []string{"icheheavo", "ichamthi"},
			periodsWide:            []string{"icheheavo", "ichamthi"},
			erasAbbreviated:        []string{"KM", "BM"},
			erasNarrow:             []string{"", ""},
			erasWide:               []string{"Kabla yakwe Yethu", "Baada yakwe Yethu"},
			timezones:              map[string]string{"ACDT": "ACDT", "ACST": "ACST", "ACWDT": "ACWDT", "ACWST": "ACWST", "ADT": "ADT", "AEDT": "AEDT", "AEST": "AEST", "AKDT": "AKDT", "AKST": "AKST", "ARST": "ARST", "ART": "ART", "AST": "AST", "AWDT": "AWDT", "AWST": "AWST", "BOT": "BOT", "BT": "BT", "CAT": "CAT", "CDT": "CDT", "CHADT": "CHADT", "CHAST": "CHAST", "CLST": "CLST", "CLT": "CLT", "COST": "COST", "COT": "COT", "CST": "CST", "ChST": "ChST", "EAT": "EAT", "ECT": "ECT", "EDT": "EDT", "EST": "EST", "GFT": "GFT", "GMT": "GMT", "GST": "GST", "GYT": "GYT", "HADT": "HADT", "HAST": "HAST", "HAT": "HAT", "HECU": "HECU", "HEEG": "HEEG", "HENOMX": "HENOMX", "HEOG": "HEOG", "HEPM": "HEPM", "HEPMX": "HEPMX", "HKST": "HKST", "HKT": "HKT", "HNCU": "HNCU", "HNEG": "HNEG", "HNNOMX": "HNNOMX", "HNOG": "HNOG", "HNPM": "HNPM", "HNPMX": "HNPMX", "HNT": "HNT", "IST": "IST", "JDT": "JDT", "JST": "JST", "LHDT": "LHDT", "LHST": "LHST", "MDT": "MDT", "MESZ": "MESZ", "MEZ": "MEZ", "MST": "MST", "MYT": "MYT", "NZDT": "NZDT", "NZST": "NZST", "OESZ": "OESZ", "OEZ": "OEZ", "PDT": "PDT", "PST": "PST", "SAST": "SAST", "SGT": "SGT", "SRT": "SRT", "TMST": "TMST", "TMT": "TMT", "UYST": "UYST", "UYT": "UYT", "VET": "VET", "WARST": "WARST", "WART": "WART", "WAST": "WAST", "WAT": "WAT", "WESZ": "WESZ", "WEZ": "WEZ", "WIB": "WIB", "WIT": "WIT", "WITA": "WITA", "∅∅∅": "∅∅∅"},

			fnCardinalPluralRule:  fnCardinalPluralRule_0758171f702b5b6024bdf47d25d8166d,
			fnDecimal:             fnDecimal_a78485e7dd32c95f41af4e18420793bf,
			fnFmtAccounting:       fnFmtAccounting_97eb2dc886e17a0500b9446194e6f039,
			fnFmtCurrency:         fnFmtCurrency_bf0b02b2ea7c6ce42329b55a6be0d7f3,
			fnFmtDateFull:         fnFmtDateFull_c568798c9683b61c27e1bae4ea10cb6b,
			fnFmtDateLong:         fnFmtDateLong_506f643cda0514f66d873a9ea99bf639,
			fnFmtDateMedium:       fnFmtDateMedium_cb43e8c32d5cd0a27ac6db293a7981fd,
			fnFmtDateShort:        fnFmtDateShort_529ba7a02bedd437d0833b1afdb768c8,
			fnFmtNumber:           fnFmtNumber_2816fdab36e719be095a370ff42e599f,
			fnFmtPercent:          fnFmtPercent_016773d83796aa19d80b7c33bf377883,
			fnFmtTimeFull:         fnFmtTimeFull_ebdf96de1e47f9043145564c500ef7dc,
			fnFmtTimeLong:         fnFmtTimeLong_987bec4676d3a5de4218e415e123649d,
			fnFmtTimeMedium:       fnFmtTimeMedium_b6f697552cd4965cd1195fe56dc87003,
			fnFmtTimeShort:        fnFmtTimeShort_8ffba4d1a2f04a0a6486853d76cf434b,
			fnGroup:               fnGroup_5c4b80a5ccdee81467241784ab8fcd56,
			fnLocale:              fnLocale_5a217059c67094defae82f249f55f4c5,
			fnMinus:               fnMinus_8b8229905258388dc16a5e0c270b0488,
			fnMonthAbbreviated:    fnMonthAbbreviated_aa9a9957cd9d056ba078b36a08b17478,
			fnMonthNarrow:         fnMonthNarrow_45916040ecf6fc350894d9e3e6c46dc7,
			fnMonthWide:           fnMonthWide_4c946a7e7581c665e7407df1841810b5,
			fnMonthsAbbreviated:   fnMonthsAbbreviated_181f77804b62232997fae36bd57d6cf7,
			fnMonthsNarrow:        fnMonthsNarrow_75daa2ba82ae9577292175c3f52370cc,
			fnMonthsWide:          fnMonthsWide_0ecf36a8b72255e2fee9467af362e989,
			fnOrdinalPluralRule:   fnOrdinalPluralRule_a0e5467912a746c396065750c68e4318,
			fnPluralsCardinal:     fnPluralsCardinal_85b19cac1fab9f2c2cfb9eb41539aa0e,
			fnPluralsOrdinal:      fnPluralsOrdinal_16a60aa09da9778fa82fe463e83076de,
			fnPluralsRange:        fnPluralsRange_332465bda13eb808b3664fa0500f54ce,
			fnRangePluralRule:     fnRangePluralRule_e0f62e2cf3ae7407fb4b54d084341c0b,
			fnWeekdayAbbreviated:  fnWeekdayAbbreviated_4ffbdfbd2be10e6bd8fb5a542a14664a,
			fnWeekdayNarrow:       fnWeekdayNarrow_e86921b3446df5ea9afe9504cfa20d1a,
			fnWeekdayShort:        fnWeekdayShort_82b231d4f504c6d71c7e495aa35cd3c2,
			fnWeekdayWide:         fnWeekdayWide_ab7e026d8685cefd89c5aeb5df512a9a,
			fnWeekdaysAbbreviated: fnWeekdaysAbbreviated_454a3d7d23c662520a64ae5245d404be,
			fnWeekdaysNarrow:      fnWeekdaysNarrow_d23eb0b7a498c40ce19d1bf231cad524,
			fnWeekdaysShort:       fnWeekdaysShort_eb6ee64d01e314991432b4469790d38b,
			fnWeekdaysWide:        fnWeekdaysWide_5e2bbf75a31e730429c100e8a0bd3ebd,
		}
	}
	translatorFuncs["asa_tz"] = func() locales.Translator {
		return &localen{

			locale:                 "asa_TZ",
			pluralsCardinal:        []locales.PluralRule{2, 6},
			pluralsOrdinal:         nil,
			pluralsRange:           nil,
			timeSeparator:          ":",
			currencies:             []string{"ADP", "AED", "AFA", "AFN", "ALK", "ALL", "AMD", "ANG", "AOA", "AOK", "AON", "AOR", "ARA", "ARL", "ARM", "ARP", "ARS", "ATS", "AUD", "AWG", "AZM", "AZN", "BAD", "BAM", "BAN", "BBD", "BDT", "BEC", "BEF", "BEL", "BGL", "BGM", "BGN", "BGO", "BHD", "BIF", "BMD", "BND", "BOB", "BOL", "BOP", "BOV", "BRB", "BRC", "BRE", "BRL", "BRN", "BRR", "BRZ", "BSD", "BTN", "BUK", "BWP", "BYB", "BYN", "BYR", "BZD", "CAD", "CDF", "CHE", "CHF", "CHW", "CLE", "CLF", "CLP", "CNH", "CNX", "CNY", "COP", "COU", "CRC", "CSD", "CSK", "CUC", "CUP", "CVE", "CYP", "CZK", "DDM", "DEM", "DJF", "DKK", "DOP", "DZD", "ECS", "ECV", "EEK", "EGP", "ERN", "ESA", "ESB", "ESP", "ETB", "EUR", "FIM", "FJD", "FKP", "FRF", "GBP", "GEK", "GEL", "GHC", "GHS", "GIP", "GMD", "GNF", "GNS", "GQE", "GRD", "GTQ", "GWE", "GWP", "GYD", "HKD", "HNL", "HRD", "HRK", "HTG", "HUF", "IDR", "IEP", "ILP", "ILR", "ILS", "INR", "IQD", "IRR", "ISJ", "ISK", "ITL", "JMD", "JOD", "JPY", "KES", "KGS", "KHR", "KMF", "KPW", "KRH", "KRO", "KRW", "KWD", "KYD", "KZT", "LAK", "LBP", "LKR", "LRD", "LSL", "LTL", "LTT", "LUC", "LUF", "LUL", "LVL", "LVR", "LYD", "MAD", "MAF", "MCF", "MDC", "MDL", "MGA", "MGF", "MKD", "MKN", "MLF", "MMK", "MNT", "MOP", "MRO", "MRU", "MTL", "MTP", "MUR", "MVP", "MVR", "MWK", "MXN", "MXP", "MXV", "MYR", "MZE", "MZM", "MZN", "NAD", "NGN", "NIC", "NIO", "NLG", "NOK", "NPR", "NZD", "OMR", "PAB", "PEI", "PEN", "PES", "PGK", "PHP", "PKR", "PLN", "PLZ", "PTE", "PYG", "QAR", "RHD", "ROL", "RON", "RSD", "RUB", "RUR", "RWF", "SAR", "SBD", "SCR", "SDD", "SDG", "SDP", "SEK", "SGD", "SHP", "SIT", "SKK", "SLL", "SOS", "SRD", "SRG", "SSP", "STD", "STN", "SUR", "SVC", "SYP", "SZL", "THB", "TJR", "TJS", "TMM", "TMT", "TND", "TOP", "TPE", "TRL", "TRY", "TTD", "TWD", "TZS", "UAH", "UAK", "UGS", "UGX", "USD", "USN", "USS", "UYI", "UYP", "UYU", "UYW", "UZS", "VEB", "VEF", "VES", "VND", "VNN", "VUV", "WST", "XAF", "XAG", "XAU", "XBA", "XBB", "XBC", "XBD", "XCD", "XDR", "XEU", "XFO", "XFU", "XOF", "XPD", "XPF", "XPT", "XRE", "XSU", "XTS", "XUA", "XXX", "YDD", "YER", "YUD", "YUM", "YUN", "YUR", "ZAL", "ZAR", "ZMK", "ZMW", "ZRN", "ZRZ", "ZWD", "ZWL", "ZWR"},
			currencyPositiveSuffix: " ",
			currencyNegativeSuffix: " ",
			monthsAbbreviated:      []string{"", "Jan", "Feb", "Mac", "Apr", "Mei", "Jun", "Jul", "Ago", "Sep", "Okt", "Nov", "Dec"},
			monthsNarrow:           []string{"", "J", "F", "M", "A", "M", "J", "J", "A", "S", "O", "N", "D"},
			monthsWide:             []string{"", "Januari", "Februari", "Machi", "Aprili", "Mei", "Juni", "Julai", "Agosti", "Septemba", "Oktoba", "Novemba", "Desemba"},
			daysAbbreviated:        []string{"Jpi", "Jtt", "Jnn", "Jtn", "Alh", "Ijm", "Jmo"},
			daysNarrow:             []string{"J", "J", "J", "J", "A", "I", "J"},
			daysWide:               []string{"Jumapili", "Jumatatu", "Jumanne", "Jumatano", "Alhamisi", "Ijumaa", "Jumamosi"},
			periodsAbbreviated:     []string{"icheheavo", "ichamthi"},
			periodsWide:            []string{"icheheavo", "ichamthi"},
			erasAbbreviated:        []string{"KM", "BM"},
			erasNarrow:             []string{"", ""},
			erasWide:               []string{"Kabla yakwe Yethu", "Baada yakwe Yethu"},
			timezones:              map[string]string{"ACDT": "ACDT", "ACST": "ACST", "ACWDT": "ACWDT", "ACWST": "ACWST", "ADT": "ADT", "AEDT": "AEDT", "AEST": "AEST", "AKDT": "AKDT", "AKST": "AKST", "ARST": "ARST", "ART": "ART", "AST": "AST", "AWDT": "AWDT", "AWST": "AWST", "BOT": "BOT", "BT": "BT", "CAT": "CAT", "CDT": "CDT", "CHADT": "CHADT", "CHAST": "CHAST", "CLST": "CLST", "CLT": "CLT", "COST": "COST", "COT": "COT", "CST": "CST", "ChST": "ChST", "EAT": "EAT", "ECT": "ECT", "EDT": "EDT", "EST": "EST", "GFT": "GFT", "GMT": "GMT", "GST": "GST", "GYT": "GYT", "HADT": "HADT", "HAST": "HAST", "HAT": "HAT", "HECU": "HECU", "HEEG": "HEEG", "HENOMX": "HENOMX", "HEOG": "HEOG", "HEPM": "HEPM", "HEPMX": "HEPMX", "HKST": "HKST", "HKT": "HKT", "HNCU": "HNCU", "HNEG": "HNEG", "HNNOMX": "HNNOMX", "HNOG": "HNOG", "HNPM": "HNPM", "HNPMX": "HNPMX", "HNT": "HNT", "IST": "IST", "JDT": "JDT", "JST": "JST", "LHDT": "LHDT", "LHST": "LHST", "MDT": "MDT", "MESZ": "MESZ", "MEZ": "MEZ", "MST": "MST", "MYT": "MYT", "NZDT": "NZDT", "NZST": "NZST", "OESZ": "OESZ", "OEZ": "OEZ", "PDT": "PDT", "PST": "PST", "SAST": "SAST", "SGT": "SGT", "SRT": "SRT", "TMST": "TMST", "TMT": "TMT", "UYST": "UYST", "UYT": "UYT", "VET": "VET", "WARST": "WARST", "WART": "WART", "WAST": "WAST", "WAT": "WAT", "WESZ": "WESZ", "WEZ": "WEZ", "WIB": "WIB", "WIT": "WIT", "WITA": "WITA", "∅∅∅": "∅∅∅"},

			fnCardinalPluralRule:  fnCardinalPluralRule_0758171f702b5b6024bdf47d25d8166d,
			fnDecimal:             fnDecimal_a78485e7dd32c95f41af4e18420793bf,
			fnFmtAccounting:       fnFmtAccounting_97eb2dc886e17a0500b9446194e6f039,
			fnFmtCurrency:         fnFmtCurrency_bf0b02b2ea7c6ce42329b55a6be0d7f3,
			fnFmtDateFull:         fnFmtDateFull_c568798c9683b61c27e1bae4ea10cb6b,
			fnFmtDateLong:         fnFmtDateLong_506f643cda0514f66d873a9ea99bf639,
			fnFmtDateMedium:       fnFmtDateMedium_cb43e8c32d5cd0a27ac6db293a7981fd,
			fnFmtDateShort:        fnFmtDateShort_529ba7a02bedd437d0833b1afdb768c8,
			fnFmtNumber:           fnFmtNumber_2816fdab36e719be095a370ff42e599f,
			fnFmtPercent:          fnFmtPercent_016773d83796aa19d80b7c33bf377883,
			fnFmtTimeFull:         fnFmtTimeFull_ebdf96de1e47f9043145564c500ef7dc,
			fnFmtTimeLong:         fnFmtTimeLong_987bec4676d3a5de4218e415e123649d,
			fnFmtTimeMedium:       fnFmtTimeMedium_b6f697552cd4965cd1195fe56dc87003,
			fnFmtTimeShort:        fnFmtTimeShort_8ffba4d1a2f04a0a6486853d76cf434b,
			fnGroup:               fnGroup_5c4b80a5ccdee81467241784ab8fcd56,
			fnLocale:              fnLocale_5a217059c67094defae82f249f55f4c5,
			fnMinus:               fnMinus_8b8229905258388dc16a5e0c270b0488,
			fnMonthAbbreviated:    fnMonthAbbreviated_aa9a9957cd9d056ba078b36a08b17478,
			fnMonthNarrow:         fnMonthNarrow_45916040ecf6fc350894d9e3e6c46dc7,
			fnMonthWide:           fnMonthWide_4c946a7e7581c665e7407df1841810b5,
			fnMonthsAbbreviated:   fnMonthsAbbreviated_181f77804b62232997fae36bd57d6cf7,
			fnMonthsNarrow:        fnMonthsNarrow_75daa2ba82ae9577292175c3f52370cc,
			fnMonthsWide:          fnMonthsWide_0ecf36a8b72255e2fee9467af362e989,
			fnOrdinalPluralRule:   fnOrdinalPluralRule_a0e5467912a746c396065750c68e4318,
			fnPluralsCardinal:     fnPluralsCardinal_85b19cac1fab9f2c2cfb9eb41539aa0e,
			fnPluralsOrdinal:      fnPluralsOrdinal_16a60aa09da9778fa82fe463e83076de,
			fnPluralsRange:        fnPluralsRange_332465bda13eb808b3664fa0500f54ce,
			fnRangePluralRule:     fnRangePluralRule_e0f62e2cf3ae7407fb4b54d084341c0b,
			fnWeekdayAbbreviated:  fnWeekdayAbbreviated_4ffbdfbd2be10e6bd8fb5a542a14664a,
			fnWeekdayNarrow:       fnWeekdayNarrow_e86921b3446df5ea9afe9504cfa20d1a,
			fnWeekdayShort:        fnWeekdayShort_82b231d4f504c6d71c7e495aa35cd3c2,
			fnWeekdayWide:         fnWeekdayWide_ab7e026d8685cefd89c5aeb5df512a9a,
			fnWeekdaysAbbreviated: fnWeekdaysAbbreviated_454a3d7d23c662520a64ae5245d404be,
			fnWeekdaysNarrow:      fnWeekdaysNarrow_d23eb0b7a498c40ce19d1bf231cad524,
			fnWeekdaysShort:       fnWeekdaysShort_eb6ee64d01e314991432b4469790d38b,
			fnWeekdaysWide:        fnWeekdaysWide_5e2bbf75a31e730429c100e8a0bd3ebd,
		}
	}
	translatorFuncs["ast"] = func() locales.Translator {
		return &localen{

			locale:                 "ast",
			pluralsCardinal:        []locales.PluralRule{2, 6},
			pluralsOrdinal:         nil,
			pluralsRange:           nil,
			decimal:                ",",
			group:                  ".",
			minus:                  "-",
			percent:                "%",
			perMille:               "‰",
			timeSeparator:          ":",
			inifinity:              "∞",
			currencies:             []string{"ADP", "AED", "AFA", "AFN", "ALK", "ALL", "AMD", "ANG", "AOA", "AOK", "AON", "AOR", "ARA", "ARL", "ARM", "ARP", "ARS", "ATS", "A$", "AWG", "AZM", "AZN", "BAD", "BAM", "BAN", "BBD", "BDT", "BEC", "BEF", "BEL", "BGL", "BGM", "BGN", "BGO", "BHD", "BIF", "BMD", "BND", "BOB", "BOL", "BOP", "BOV", "BRB", "BRC", "BRE", "R$", "BRN", "BRR", "BRZ", "BSD", "BTN", "BUK", "BWP", "BYB", "BYN", "BYR", "BZD", "CA$", "CDF", "CHE", "CHF", "CHW", "CLE", "CLF", "CLP", "CNH", "CNX", "CN¥", "COP", "COU", "CRC", "CSD", "CSK", "CUC", "CUP", "CVE", "CYP", "CZK", "DDM", "DEM", "DJF", "DKK", "DOP", "DZD", "ECS", "ECV", "EEK", "EGP", "ERN", "ESA", "ESB", "ESP", "ETB", "€", "FIM", "FJD", "FKP", "FRF", "£", "GEK", "GEL", "GHC", "GHS", "GIP", "GMD", "GNF", "GNS", "GQE", "GRD", "GTQ", "GWE", "GWP", "GYD", "HK$", "HNL", "HRD", "HRK", "HTG", "HUF", "IDR", "IEP", "ILP", "ILR", "₪", "₹", "IQD", "IRR", "ISJ", "ISK", "ITL", "JMD", "JOD", "¥", "KES", "KGS", "KHR", "KMF", "KPW", "KRH", "KRO", "₩", "KWD", "KYD", "KZT", "LAK", "LBP", "LKR", "LRD", "LSL", "LTL", "LTT", "LUC", "LUF", "LUL", "LVL", "LVR", "LYD", "MAD", "MAF", "MCF", "MDC", "MDL", "MGA", "MGF", "MKD", "MKN", "MLF", "MMK", "MNT", "MOP", "MRO", "MRU", "MTL", "MTP", "MUR", "MVP", "MVR", "MWK", "MX$", "MXP", "MXV", "MYR", "MZE", "MZM", "MZN", "NAD", "NGN", "NIC", "NIO", "NLG", "NOK", "NPR", "NZ$", "OMR", "PAB", "PEI", "PEN", "PES", "PGK", "PHP", "PKR", "PLN", "PLZ", "PTE", "PYG", "QAR", "RHD", "ROL", "RON", "RSD", "RUB", "RUR", "RWF", "SAR", "SBD", "SCR", "SDD", "SDG", "SDP", "SEK", "SGD", "SHP", "SIT", "SKK", "SLL", "SOS", "SRD", "SRG", "SSP", "STD", "Db", "SUR", "SVC", "SYP", "SZL", "฿", "TJR", "TJS", "TMM", "TMT", "TND", "TOP", "TPE", "TRL", "TRY", "TTD", "NT$", "TZS", "UAH", "UAK", "UGS", "UGX", "$", "USN", "USS", "UYI", "UYP", "UYU", "UYW", "UZS", "VEB", "VEF", "VES", "₫", "VNN", "VUV", "WST", "FCFA", "XAG", "XAU", "XBA", "XBB", "XBC", "XBD", "EC$", "XDR", "XEU", "XFO", "XFU", "CFA", "XPD", "CFPF", "XPT", "XRE", "XSU", "XTS", "XUA", "XXX", "YDD", "YER", "YUD", "YUM", "YUN", "YUR", "ZAL", "ZAR", "ZMK", "ZMW", "ZRN", "ZRZ", "ZWD", "ZWL", "ZWR"},
			currencyPositiveSuffix: " ",
			currencyNegativeSuffix: " ",
			monthsAbbreviated:      []string{"", "xin", "feb", "mar", "abr", "may", "xun", "xnt", "ago", "set", "och", "pay", "avi"},
			monthsNarrow:           []string{"", "X", "F", "M", "A", "M", "X", "X", "A", "S", "O", "P", "A"},
			monthsWide:             []string{"", "de xineru", "de febreru", "de marzu", "d’abril", "de mayu", "de xunu", "de xunetu", "d’agostu", "de setiembre", "d’ochobre", "de payares", "d’avientu"},
			daysAbbreviated:        []string{"dom", "llu", "mar", "mié", "xue", "vie", "sáb"},
			daysNarrow:             []string{"D", "L", "M", "M", "X", "V", "S"},
			daysShort:              []string{"do", "ll", "ma", "mi", "xu", "vi", "sá"},
			daysWide:               []string{"domingu", "llunes", "martes", "miércoles", "xueves", "vienres", "sábadu"},
			periodsAbbreviated:     []string{"AM", "PM"},
			periodsNarrow:          []string{"a", "p"},
			periodsWide:            []string{"de la mañana", "de la tarde"},
			erasAbbreviated:        []string{"e.C.", "d.C."},
			erasNarrow:             []string{"", ""},
			erasWide:               []string{"enantes de Cristu", "después de Cristu"},
			timezones:              map[string]string{"ACDT": "Hora braniega d’Australia central", "ACST": "Hora estándar d’Australia central", "ACWDT": "Hora braniega d’Australia central del oeste", "ACWST": "Hora estándar d’Australia central del oeste", "ADT": "Hora braniega del Atlánticu", "AEDT": "Hora braniega d’Australia del este", "AEST": "Hora estándar d’Australia del este", "AKDT": "Hora braniega d’Alaska", "AKST": "Hora estándar d’Alaska", "ARST": "Hora braniega d’Arxentina", "ART": "Hora estándar d’Arxentina", "AST": "Hora estándar del Atlánticu", "AWDT": "Hora braniega d’Australia del oeste", "AWST": "Hora estándar d’Australia del oeste", "BOT": "Hora de Bolivia", "BT": "Hora de Bután", "CAT": "Hora d’África central", "CDT": "Hora braniega central norteamericana", "CHADT": "Hora braniega de Chatham", "CHAST": "Hora estándar de Chatham", "CLST": "Hora braniega de Chile", "CLT": "Hora estándar de Chile", "COST": "Hora braniega de Colombia", "COT": "Hora estándar de Colombia", "CST": "Hora estándar central norteamericana", "ChST": "Hora estándar de Chamorro", "EAT": "Hora d’África del este", "ECT": "Hora d’Ecuador", "EDT": "Hora braniega del este norteamericanu", "EST": "Hora estándar del este norteamericanu", "GFT": "Hora de La Guyana Francesa", "GMT": "Hora media de Greenwich", "GST": "Hora estándar del Golfu", "GYT": "Hora de La Guyana", "HADT": "Hora braniega de Hawaii-Aleutianes", "HAST": "Hora estándar de Hawaii-Aleutianes", "HAT": "Hora braniega de Newfoundland", "HECU": "Hora braniega de Cuba", "HEEG": "Hora braniega de Groenlandia oriental", "HENOMX": "Hora braniega del noroeste de Méxicu", "HEOG": "Hora braniega de Groenlandia occidental", "HEPM": "Hora braniega de Saint Pierre y Miquelon", "HEPMX": "Hora braniega del Pacíficu de Méxicu", "HKST": "Hora braniega de Ḥong Kong", "HKT": "Hora estándar de Ḥong Kong", "HNCU": "Hora estándar de Cuba", "HNEG": "Hora estándar de Groenlandia oriental", "HNNOMX": "Hora estándar del noroeste de Méxicu", "HNOG": "Hora estándar de Groenlandia occidental", "HNPM": "Hora estándar de Saint Pierre y Miquelon", "HNPMX": "Hora estándar del Pacíficu de Méxicu", "HNT": "Hora estándar de Newfoundland", "IST": "Hora estándar de la India", "JDT": "Hora braniega de Xapón", "JST": "Hora estándar de Xapón", "LHDT": "Hora braniega de Lord Howe", "LHST": "Hora estándar de Lord Howe", "MDT": "Hora braniega de les montañes norteamericanes", "MESZ": "Hora braniega d’Europa Central", "MEZ": "Hora estándar d’Europa Central", "MST": "Hora estándar de les montañes norteamericanes", "MYT": "Hora de Malasia", "NZDT": "Hora braniega de Nueva Zelanda", "NZST": "Hora estándar de Nueva Zelanda", "OESZ": "Hora braniega d’Europa del Este", "OEZ": "Hora estándar d’Europa del Este", "PDT": "Hora braniega del Pacíficu norteamericanu", "PST": "Hora estándar del Pacíficu norteamericanu", "SAST": "Hora de Sudáfrica", "SGT": "Hora estándar de Singapur", "SRT": "Hora del Surinam", "TMST": "Hora braniega del Turkmenistán", "TMT": "Hora estándar del Turkmenistán", "UYST": "Hora braniega del Uruguái", "UYT": "Hora estándar del Uruguái", "VET": "Hora de Venezuela", "WARST": "Hora braniega occidental d’Arxentina", "WART": "Hora estándar occidental d’Arxentina", "WAST": "Hora braniega d’África del oeste", "WAT": "Hora estándar d’África del oeste", "WESZ": "Hora braniega d’Europa Occidental", "WEZ": "Hora estándar d’Europa Occidental", "WIB": "Hora d’Indonesia del oeste", "WIT": "Hora d’Indonesia del este", "WITA": "Hora d’Indonesia central", "∅∅∅": "Hora braniega de Brasilia"},

			fnCardinalPluralRule:  fnCardinalPluralRule_c037ba21b7495f414cf38823ca036d30,
			fnDecimal:             fnDecimal_a78485e7dd32c95f41af4e18420793bf,
			fnFmtAccounting:       fnFmtAccounting_295d01ff3669c94717ee670511c0e25e,
			fnFmtCurrency:         fnFmtCurrency_c43b1593289525b3b62af252d88e9f2d,
			fnFmtDateFull:         fnFmtDateFull_6f37ff0e733377c3c49c15d7ec4ea94b,
			fnFmtDateLong:         fnFmtDateLong_b496f47cbe02a0b60f833a85f2f19cbc,
			fnFmtDateMedium:       fnFmtDateMedium_cb43e8c32d5cd0a27ac6db293a7981fd,
			fnFmtDateShort:        fnFmtDateShort_f44877b6023a2d0fb0de41f9e2966ad0,
			fnFmtNumber:           fnFmtNumber_fc1f852c40326b41ed4436818cad7bfb,
			fnFmtPercent:          fnFmtPercent_1c35b3868bf10d0e69b22b2e80c40671,
			fnFmtTimeFull:         fnFmtTimeFull_ebdf96de1e47f9043145564c500ef7dc,
			fnFmtTimeLong:         fnFmtTimeLong_987bec4676d3a5de4218e415e123649d,
			fnFmtTimeMedium:       fnFmtTimeMedium_b6f697552cd4965cd1195fe56dc87003,
			fnFmtTimeShort:        fnFmtTimeShort_8ffba4d1a2f04a0a6486853d76cf434b,
			fnGroup:               fnGroup_5c4b80a5ccdee81467241784ab8fcd56,
			fnLocale:              fnLocale_5a217059c67094defae82f249f55f4c5,
			fnMinus:               fnMinus_8b8229905258388dc16a5e0c270b0488,
			fnMonthAbbreviated:    fnMonthAbbreviated_aa9a9957cd9d056ba078b36a08b17478,
			fnMonthNarrow:         fnMonthNarrow_45916040ecf6fc350894d9e3e6c46dc7,
			fnMonthWide:           fnMonthWide_4c946a7e7581c665e7407df1841810b5,
			fnMonthsAbbreviated:   fnMonthsAbbreviated_181f77804b62232997fae36bd57d6cf7,
			fnMonthsNarrow:        fnMonthsNarrow_75daa2ba82ae9577292175c3f52370cc,
			fnMonthsWide:          fnMonthsWide_0ecf36a8b72255e2fee9467af362e989,
			fnOrdinalPluralRule:   fnOrdinalPluralRule_a0e5467912a746c396065750c68e4318,
			fnPluralsCardinal:     fnPluralsCardinal_85b19cac1fab9f2c2cfb9eb41539aa0e,
			fnPluralsOrdinal:      fnPluralsOrdinal_16a60aa09da9778fa82fe463e83076de,
			fnPluralsRange:        fnPluralsRange_332465bda13eb808b3664fa0500f54ce,
			fnRangePluralRule:     fnRangePluralRule_e0f62e2cf3ae7407fb4b54d084341c0b,
			fnWeekdayAbbreviated:  fnWeekdayAbbreviated_4ffbdfbd2be10e6bd8fb5a542a14664a,
			fnWeekdayNarrow:       fnWeekdayNarrow_e86921b3446df5ea9afe9504cfa20d1a,
			fnWeekdayShort:        fnWeekdayShort_82b231d4f504c6d71c7e495aa35cd3c2,
			fnWeekdayWide:         fnWeekdayWide_ab7e026d8685cefd89c5aeb5df512a9a,
			fnWeekdaysAbbreviated: fnWeekdaysAbbreviated_454a3d7d23c662520a64ae5245d404be,
			fnWeekdaysNarrow:      fnWeekdaysNarrow_d23eb0b7a498c40ce19d1bf231cad524,
			fnWeekdaysShort:       fnWeekdaysShort_eb6ee64d01e314991432b4469790d38b,
			fnWeekdaysWide:        fnWeekdaysWide_5e2bbf75a31e730429c100e8a0bd3ebd,
		}
	}
	translatorFuncs["ast_es"] = func() locales.Translator {
		return &localen{

			locale:                 "ast_ES",
			pluralsCardinal:        []locales.PluralRule{2, 6},
			pluralsOrdinal:         nil,
			pluralsRange:           nil,
			decimal:                ",",
			group:                  ".",
			minus:                  "-",
			percent:                "%",
			perMille:               "‰",
			timeSeparator:          ":",
			inifinity:              "∞",
			currencies:             []string{"ADP", "AED", "AFA", "AFN", "ALK", "ALL", "AMD", "ANG", "AOA", "AOK", "AON", "AOR", "ARA", "ARL", "ARM", "ARP", "ARS", "ATS", "AUD", "AWG", "AZM", "AZN", "BAD", "BAM", "BAN", "BBD", "BDT", "BEC", "BEF", "BEL", "BGL", "BGM", "BGN", "BGO", "BHD", "BIF", "BMD", "BND", "BOB", "BOL", "BOP", "BOV", "BRB", "BRC", "BRE", "BRL", "BRN", "BRR", "BRZ", "BSD", "BTN", "BUK", "BWP", "BYB", "BYN", "BYR", "BZD", "CAD", "CDF", "CHE", "CHF", "CHW", "CLE", "CLF", "CLP", "CNH", "CNX", "CNY", "COP", "COU", "CRC", "CSD", "CSK", "CUC", "CUP", "CVE", "CYP", "CZK", "DDM", "DEM", "DJF", "DKK", "DOP", "DZD", "ECS", "ECV", "EEK", "EGP", "ERN", "ESA", "ESB", "ESP", "ETB", "EUR", "FIM", "FJD", "FKP", "FRF", "GBP", "GEK", "GEL", "GHC", "GHS", "GIP", "GMD", "GNF", "GNS", "GQE", "GRD", "GTQ", "GWE", "GWP", "GYD", "HKD", "HNL", "HRD", "HRK", "HTG", "HUF", "IDR", "IEP", "ILP", "ILR", "ILS", "INR", "IQD", "IRR", "ISJ", "ISK", "ITL", "JMD", "JOD", "JPY", "KES", "KGS", "KHR", "KMF", "KPW", "KRH", "KRO", "KRW", "KWD", "KYD", "KZT", "LAK", "LBP", "LKR", "LRD", "LSL", "LTL", "LTT", "LUC", "LUF", "LUL", "LVL", "LVR", "LYD", "MAD", "MAF", "MCF", "MDC", "MDL", "MGA", "MGF", "MKD", "MKN", "MLF", "MMK", "MNT", "MOP", "MRO", "MRU", "MTL", "MTP", "MUR", "MVP", "MVR", "MWK", "MXN", "MXP", "MXV", "MYR", "MZE", "MZM", "MZN", "NAD", "NGN", "NIC", "NIO", "NLG", "NOK", "NPR", "NZD", "OMR", "PAB", "PEI", "PEN", "PES", "PGK", "PHP", "PKR", "PLN", "PLZ", "PTE", "PYG", "QAR", "RHD", "ROL", "RON", "RSD", "RUB", "RUR", "RWF", "SAR", "SBD", "SCR", "SDD", "SDG", "SDP", "SEK", "SGD", "SHP", "SIT", "SKK", "SLL", "SOS", "SRD", "SRG", "SSP", "STD", "STN", "SUR", "SVC", "SYP", "SZL", "THB", "TJR", "TJS", "TMM", "TMT", "TND", "TOP", "TPE", "TRL", "TRY", "TTD", "TWD", "TZS", "UAH", "UAK", "UGS", "UGX", "USD", "USN", "USS", "UYI", "UYP", "UYU", "UYW", "UZS", "VEB", "VEF", "VES", "VND", "VNN", "VUV", "WST", "XAF", "XAG", "XAU", "XBA", "XBB", "XBC", "XBD", "XCD", "XDR", "XEU", "XFO", "XFU", "XOF", "XPD", "XPF", "XPT", "XRE", "XSU", "XTS", "XUA", "XXX", "YDD", "YER", "YUD", "YUM", "YUN", "YUR", "ZAL", "ZAR", "ZMK", "ZMW", "ZRN", "ZRZ", "ZWD", "ZWL", "ZWR"},
			currencyPositiveSuffix: " ",
			currencyNegativeSuffix: " ",
			monthsAbbreviated:      []string{"", "xin", "feb", "mar", "abr", "may", "xun", "xnt", "ago", "set", "och", "pay", "avi"},
			monthsNarrow:           []string{"", "X", "F", "M", "A", "M", "X", "X", "A", "S", "O", "P", "A"},
			monthsWide:             []string{"", "de xineru", "de febreru", "de marzu", "d’abril", "de mayu", "de xunu", "de xunetu", "d’agostu", "de setiembre", "d’ochobre", "de payares", "d’avientu"},
			daysAbbreviated:        []string{"dom", "llu", "mar", "mié", "xue", "vie", "sáb"},
			daysNarrow:             []string{"D", "L", "M", "M", "X", "V", "S"},
			daysShort:              []string{"do", "ll", "ma", "mi", "xu", "vi", "sá"},
			daysWide:               []string{"domingu", "llunes", "martes", "miércoles", "xueves", "vienres", "sábadu"},
			periodsAbbreviated:     []string{"AM", "PM"},
			periodsNarrow:          []string{"a", "p"},
			periodsWide:            []string{"de la mañana", "de la tarde"},
			erasAbbreviated:        []string{"e.C.", "d.C."},
			erasNarrow:             []string{"", ""},
			erasWide:               []string{"enantes de Cristu", "después de Cristu"},
			timezones:              map[string]string{"ACDT": "Hora braniega d’Australia central", "ACST": "Hora estándar d’Australia central", "ACWDT": "Hora braniega d’Australia central del oeste", "ACWST": "Hora estándar d’Australia central del oeste", "ADT": "Hora braniega del Atlánticu", "AEDT": "Hora braniega d’Australia del este", "AEST": "Hora estándar d’Australia del este", "AKDT": "Hora braniega d’Alaska", "AKST": "Hora estándar d’Alaska", "ARST": "Hora braniega d’Arxentina", "ART": "Hora estándar d’Arxentina", "AST": "Hora estándar del Atlánticu", "AWDT": "Hora braniega d’Australia del oeste", "AWST": "Hora estándar d’Australia del oeste", "BOT": "Hora de Bolivia", "BT": "Hora de Bután", "CAT": "Hora d’África central", "CDT": "Hora braniega central norteamericana", "CHADT": "Hora braniega de Chatham", "CHAST": "Hora estándar de Chatham", "CLST": "Hora braniega de Chile", "CLT": "Hora estándar de Chile", "COST": "Hora braniega de Colombia", "COT": "Hora estándar de Colombia", "CST": "Hora estándar central norteamericana", "ChST": "Hora estándar de Chamorro", "EAT": "Hora d’África del este", "ECT": "Hora d’Ecuador", "EDT": "Hora braniega del este norteamericanu", "EST": "Hora estándar del este norteamericanu", "GFT": "Hora de La Guyana Francesa", "GMT": "Hora media de Greenwich", "GST": "Hora estándar del Golfu", "GYT": "Hora de La Guyana", "HADT": "Hora braniega de Hawaii-Aleutianes", "HAST": "Hora estándar de Hawaii-Aleutianes", "HAT": "Hora braniega de Newfoundland", "HECU": "Hora braniega de Cuba", "HEEG": "Hora braniega de Groenlandia oriental", "HENOMX": "Hora braniega del noroeste de Méxicu", "HEOG": "Hora braniega de Groenlandia occidental", "HEPM": "Hora braniega de Saint Pierre y Miquelon", "HEPMX": "Hora braniega del Pacíficu de Méxicu", "HKST": "Hora braniega de Ḥong Kong", "HKT": "Hora estándar de Ḥong Kong", "HNCU": "Hora estándar de Cuba", "HNEG": "Hora estándar de Groenlandia oriental", "HNNOMX": "Hora estándar del noroeste de Méxicu", "HNOG": "Hora estándar de Groenlandia occidental", "HNPM": "Hora estándar de Saint Pierre y Miquelon", "HNPMX": "Hora estándar del Pacíficu de Méxicu", "HNT": "Hora estándar de Newfoundland", "IST": "Hora estándar de la India", "JDT": "Hora braniega de Xapón", "JST": "Hora estándar de Xapón", "LHDT": "Hora braniega de Lord Howe", "LHST": "Hora estándar de Lord Howe", "MDT": "Hora braniega de les montañes norteamericanes", "MESZ": "Hora braniega d’Europa Central", "MEZ": "Hora estándar d’Europa Central", "MST": "Hora estándar de les montañes norteamericanes", "MYT": "Hora de Malasia", "NZDT": "Hora braniega de Nueva Zelanda", "NZST": "Hora estándar de Nueva Zelanda", "OESZ": "Hora braniega d’Europa del Este", "OEZ": "Hora estándar d’Europa del Este", "PDT": "Hora braniega del Pacíficu norteamericanu", "PST": "Hora estándar del Pacíficu norteamericanu", "SAST": "Hora de Sudáfrica", "SGT": "Hora estándar de Singapur", "SRT": "Hora del Surinam", "TMST": "Hora braniega del Turkmenistán", "TMT": "Hora estándar del Turkmenistán", "UYST": "Hora braniega del Uruguái", "UYT": "Hora estándar del Uruguái", "VET": "Hora de Venezuela", "WARST": "Hora braniega occidental d’Arxentina", "WART": "Hora estándar occidental d’Arxentina", "WAST": "Hora braniega d’África del oeste", "WAT": "Hora estándar d’África del oeste", "WESZ": "Hora braniega d’Europa Occidental", "WEZ": "Hora estándar d’Europa Occidental", "WIB": "Hora d’Indonesia del oeste", "WIT": "Hora d’Indonesia del este", "WITA": "Hora d’Indonesia central", "∅∅∅": "Hora braniega de Brasilia"},

			fnCardinalPluralRule:  fnCardinalPluralRule_c037ba21b7495f414cf38823ca036d30,
			fnDecimal:             fnDecimal_a78485e7dd32c95f41af4e18420793bf,
			fnFmtAccounting:       fnFmtAccounting_295d01ff3669c94717ee670511c0e25e,
			fnFmtCurrency:         fnFmtCurrency_c43b1593289525b3b62af252d88e9f2d,
			fnFmtDateFull:         fnFmtDateFull_6f37ff0e733377c3c49c15d7ec4ea94b,
			fnFmtDateLong:         fnFmtDateLong_b496f47cbe02a0b60f833a85f2f19cbc,
			fnFmtDateMedium:       fnFmtDateMedium_cb43e8c32d5cd0a27ac6db293a7981fd,
			fnFmtDateShort:        fnFmtDateShort_f44877b6023a2d0fb0de41f9e2966ad0,
			fnFmtNumber:           fnFmtNumber_fc1f852c40326b41ed4436818cad7bfb,
			fnFmtPercent:          fnFmtPercent_1c35b3868bf10d0e69b22b2e80c40671,
			fnFmtTimeFull:         fnFmtTimeFull_ebdf96de1e47f9043145564c500ef7dc,
			fnFmtTimeLong:         fnFmtTimeLong_987bec4676d3a5de4218e415e123649d,
			fnFmtTimeMedium:       fnFmtTimeMedium_b6f697552cd4965cd1195fe56dc87003,
			fnFmtTimeShort:        fnFmtTimeShort_8ffba4d1a2f04a0a6486853d76cf434b,
			fnGroup:               fnGroup_5c4b80a5ccdee81467241784ab8fcd56,
			fnLocale:              fnLocale_5a217059c67094defae82f249f55f4c5,
			fnMinus:               fnMinus_8b8229905258388dc16a5e0c270b0488,
			fnMonthAbbreviated:    fnMonthAbbreviated_aa9a9957cd9d056ba078b36a08b17478,
			fnMonthNarrow:         fnMonthNarrow_45916040ecf6fc350894d9e3e6c46dc7,
			fnMonthWide:           fnMonthWide_4c946a7e7581c665e7407df1841810b5,
			fnMonthsAbbreviated:   fnMonthsAbbreviated_181f77804b62232997fae36bd57d6cf7,
			fnMonthsNarrow:        fnMonthsNarrow_75daa2ba82ae9577292175c3f52370cc,
			fnMonthsWide:          fnMonthsWide_0ecf36a8b72255e2fee9467af362e989,
			fnOrdinalPluralRule:   fnOrdinalPluralRule_a0e5467912a746c396065750c68e4318,
			fnPluralsCardinal:     fnPluralsCardinal_85b19cac1fab9f2c2cfb9eb41539aa0e,
			fnPluralsOrdinal:      fnPluralsOrdinal_16a60aa09da9778fa82fe463e83076de,
			fnPluralsRange:        fnPluralsRange_332465bda13eb808b3664fa0500f54ce,
			fnRangePluralRule:     fnRangePluralRule_e0f62e2cf3ae7407fb4b54d084341c0b,
			fnWeekdayAbbreviated:  fnWeekdayAbbreviated_4ffbdfbd2be10e6bd8fb5a542a14664a,
			fnWeekdayNarrow:       fnWeekdayNarrow_e86921b3446df5ea9afe9504cfa20d1a,
			fnWeekdayShort:        fnWeekdayShort_82b231d4f504c6d71c7e495aa35cd3c2,
			fnWeekdayWide:         fnWeekdayWide_ab7e026d8685cefd89c5aeb5df512a9a,
			fnWeekdaysAbbreviated: fnWeekdaysAbbreviated_454a3d7d23c662520a64ae5245d404be,
			fnWeekdaysNarrow:      fnWeekdaysNarrow_d23eb0b7a498c40ce19d1bf231cad524,
			fnWeekdaysShort:       fnWeekdaysShort_eb6ee64d01e314991432b4469790d38b,
			fnWeekdaysWide:        fnWeekdaysWide_5e2bbf75a31e730429c100e8a0bd3ebd,
		}
	}
	translatorFuncs["az"] = func() locales.Translator {
		return &localen{

			locale:                 "az",
			pluralsCardinal:        []locales.PluralRule{2, 6},
			pluralsOrdinal:         []locales.PluralRule{2, 4, 5, 6},
			pluralsRange:           []locales.PluralRule{2, 6},
			decimal:                ",",
			group:                  ".",
			minus:                  "-",
			percent:                "%",
			perMille:               "‰",
			timeSeparator:          ":",
			inifinity:              "∞",
			currencies:             []string{"ADP", "AED", "AFA", "AFN", "ALK", "ALL", "AMD", "ANG", "AOA", "AOK", "AON", "AOR", "ARA", "ARL", "ARM", "ARP", "ARS", "ATS", "A$", "AWG", "AZM", "₼", "BAD", "BAM", "BAN", "BBD", "BDT", "BEC", "BEF", "BEL", "BGL", "BGM", "BGN", "BGO", "BHD", "BIF", "BMD", "BND", "BOB", "BOL", "BOP", "BOV", "BRB", "BRC", "BRE", "R$", "BRN", "BRR", "BRZ", "BSD", "BTN", "BUK", "BWP", "BYB", "BYN", "BYR", "BZD", "CA$", "CDF", "CHE", "CHF", "CHW", "CLE", "CLF", "CLP", "CNH", "CNX", "CN¥", "COP", "COU", "CRC", "CSD", "CSK", "CUC", "CUP", "CVE", "CYP", "CZK", "DDM", "DEM", "DJF", "DKK", "DOP", "DZD", "ECS", "ECV", "EEK", "EGP", "ERN", "ESA", "ESB", "ESP", "ETB", "€", "FIM", "FJD", "FKP", "FRF", "£", "GEK", "GEL", "GHC", "GHS", "GIP", "GMD", "GNF", "GNS", "GQE", "GRD", "GTQ", "GWE", "GWP", "GYD", "HK$", "HNL", "HRD", "HRK", "HTG", "HUF", "IDR", "IEP", "ILP", "ILR", "₪", "₹", "IQD", "IRR", "ISJ", "ISK", "ITL", "JMD", "JOD", "JP¥", "KES", "KGS", "KHR", "KMF", "KPW", "KRH", "KRO", "₩", "KWD", "KYD", "KZT", "LAK", "LBP", "LKR", "LRD", "LSL", "LTL", "LTT", "LUC", "LUF", "LUL", "LVL", "LVR", "LYD", "MAD", "MAF", "MCF", "MDC", "MDL", "MGA", "MGF", "MKD", "MKN", "MLF", "MMK", "MNT", "MOP", "MRO", "MRU", "MTL", "MTP", "MUR", "MVP", "MVR", "MWK", "MX$", "MXP", "MXV", "MYR", "MZE", "MZM", "MZN", "NAD", "NGN", "NIC", "NIO", "NLG", "NOK", "NPR", "NZ$", "OMR", "PAB", "PEI", "PEN", "PES", "PGK", "PHP", "PKR", "PLN", "PLZ", "PTE", "PYG", "QAR", "RHD", "ROL", "RON", "RSD", "RUB", "RUR", "RWF", "SAR", "SBD", "SCR", "SDD", "SDG", "SDP", "SEK", "SGD", "SHP", "SIT", "SKK", "SLL", "SOS", "SRD", "SRG", "SSP", "STD", "STN", "SUR", "SVC", "SYP", "SZL", "฿", "TJR", "TJS", "TMM", "TMT", "TND", "TOP", "TPE", "TRL", "TRY", "TTD", "NT$", "TZS", "UAH", "UAK", "UGS", "UGX", "US$", "USN", "USS", "UYI", "UYP", "UYU", "UYW", "UZS", "VEB", "VEF", "VES", "₫", "VNN", "VUV", "WST", "FCFA", "XAG", "XAU", "XBA", "XBB", "XBC", "XBD", "EC$", "XDR", "XEU", "XFO", "XFU", "CFA", "XPD", "CFPF", "XPT", "XRE", "XSU", "XTS", "XUA", "XXX", "YDD", "YER", "YUD", "YUM", "YUN", "YUR", "ZAL", "ZAR", "ZMK", "ZMW", "ZRN", "ZRZ", "ZWD", "ZWL", "ZWR"},
			currencyPositiveSuffix: " ",
			currencyNegativeSuffix: " ",
			monthsAbbreviated:      []string{"", "yan", "fev", "mar", "apr", "may", "iyn", "iyl", "avq", "sen", "okt", "noy", "dek"},
			monthsNarrow:           []string{"", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12"},
			monthsWide:             []string{"", "yanvar", "fevral", "mart", "aprel", "may", "iyun", "iyul", "avqust", "sentyabr", "oktyabr", "noyabr", "dekabr"},
			daysAbbreviated:        []string{"B.", "B.e.", "Ç.a.", "Ç.", "C.a.", "C.", "Ş."},
			daysNarrow:             []string{"7", "1", "2", "3", "4", "5", "6"},
			daysShort:              []string{"B.", "B.E.", "Ç.A.", "Ç.", "C.A.", "C.", "Ş."},
			daysWide:               []string{"bazar", "bazar ertəsi", "çərşənbə axşamı", "çərşənbə", "cümə axşamı", "cümə", "şənbə"},
			periodsAbbreviated:     []string{"AM", "PM"},
			periodsNarrow:          []string{"a", "p"},
			periodsWide:            []string{"AM", "PM"},
			erasAbbreviated:        []string{"e.ə.", "y.e."},
			erasNarrow:             []string{"", ""},
			erasWide:               []string{"eramızdan əvvəl", "yeni era"},
			timezones:              map[string]string{"ACDT": "Mərkəzi Avstraliya Yay Vaxtı", "ACST": "Mərkəzi Avstraliya Standart Vaxtı", "ACWDT": "Mərkəzi Qərbi Avstraliya Yay Vaxtı", "ACWST": "Mərkəzi Qərbi Avstraliya Standart Vaxtı", "ADT": "Atlantik Yay Vaxtı", "AEDT": "Şərqi Avstraliya Yay Vaxtı", "AEST": "Şərqi Avstraliya Standart Vaxtı", "AKDT": "Alyaska Yay Vaxtı", "AKST": "Alyaska Standart Vaxtı", "ARST": "Argentina Yay Vaxtı", "ART": "Argentina Standart Vaxtı", "AST": "Atlantik Standart Vaxt", "AWDT": "Qərbi Avstraliya Yay Vaxtı", "AWST": "Qərbi Avstraliya Standart Vaxtı", "BOT": "Boliviya Vaxtı", "BT": "Butan Vaxtı", "CAT": "Mərkəzi Afrika Vaxtı", "CDT": "Şimali Mərkəzi Amerika Yay Vaxtı", "CHADT": "Çatham Yay Vaxtı", "CHAST": "Çatham Standart Vaxtı", "CLST": "Çili Yay Vaxtı", "CLT": "Çili Standart Vaxtı", "COST": "Kolumbiya Yay Vaxtı", "COT": "Kolumbiya Standart Vaxtı", "CST": "Şimali Mərkəzi Amerika Standart Vaxtı", "ChST": "Çamorro Vaxtı", "EAT": "Şərqi Afrika Vaxtı", "ECT": "Ekvador Vaxtı", "EDT": "Şimali Şərqi Amerika Yay Vaxtı", "EST": "Şimali Şərqi Amerika Standart Vaxtı", "GFT": "Fransız Qvianası Vaxtı", "GMT": "Qrinviç Orta Vaxtı", "GST": "Körfəz Vaxtı", "GYT": "Qayana Vaxtı", "HADT": "Havay-Aleut Yay Vaxtı", "HAST": "Havay-Aleut Standart Vaxtı", "HAT": "Nyufaundlend Yay Vaxtı", "HECU": "Kuba Yay Vaxtı", "HEEG": "Şərqi Qrenlandiya Yay Vaxtı", "HENOMX": "Şimal-Qərbi Meksika Yay Vaxtı", "HEOG": "Qərbi Qrenlandiya Yay Vaxtı", "HEPM": "Müqəddəs Pyer və Mikelon Yay Vaxtı", "HEPMX": "Meksika Sakit Okean Yay Vaxtı", "HKST": "Honq Konq Yay Vaxtı", "HKT": "Honq Konq Standart Vaxtı", "HNCU": "Kuba Standart Vaxtı", "HNEG": "Şərqi Qrenlandiya Standart Vaxtı", "HNNOMX": "Şimal-Qərbi Meksika Standart Vaxtı", "HNOG": "Qərbi Qrenlandiya Standart Vaxtı", "HNPM": "Müqəddəs Pyer və Mikelon Standart Vaxtı", "HNPMX": "Meksika Sakit Okean Standart Vaxtı", "HNT": "Nyufaundlend Standart Vaxtı", "IST": "Hindistan Vaxtı", "JDT": "Yaponiya Yay Vaxtı", "JST": "Yaponiya Standart Vaxtı", "LHDT": "Lord Hau Yay vaxtı", "LHST": "Lord Hau Standart Vaxtı", "MDT": "Şimali Dağlıq Amerika Yay Vaxtı", "MESZ": "Mərkəzi Avropa Yay Vaxtı", "MEZ": "Mərkəzi Avropa Standart Vaxtı", "MST": "Şimali Dağlıq Amerika Standart Vaxtı", "MYT": "Malayziya Vaxtı", "NZDT": "Yeni Zelandiya Yay Vaxtı", "NZST": "Yeni Zelandiya Standart Vaxtı", "OESZ": "Şərqi Avropa Yay Vaxtı", "OEZ": "Şərqi Avropa Standart Vaxtı", "PDT": "Şimali Amerika Sakit Okean Yay Vaxtı", "PST": "Şimali Amerika Sakit Okean Standart Vaxtı", "SAST": "Cənubi Afrika Vaxtı", "SGT": "Sinqapur Vaxtı", "SRT": "Surinam Vaxtı", "TMST": "Türkmənistan Yay Vaxtı", "TMT": "Türkmənistan Standart Vaxtı", "UYST": "Uruqvay Yay Vaxtı", "UYT": "Uruqvay Standart Vaxtı", "VET": "Venesuela Vaxtı", "WARST": "Qərbi Argentina Yay Vaxtı", "WART": "Qərbi Argentina Standart Vaxtı", "WAST": "Qərbi Afrika Yay Vaxtı", "WAT": "Qərbi Afrika Standart Vaxtı", "WESZ": "Qərbi Avropa Yay Vaxtı", "WEZ": "Qərbi Avropa Standart Vaxtı", "WIB": "Qərbi İndoneziya Vaxtı", "WIT": "Şərqi İndoneziya Vaxtı", "WITA": "Mərkəzi İndoneziya Vaxtı", "∅∅∅": "Braziliya Yay Vaxtı"},

			fnCardinalPluralRule:  fnCardinalPluralRule_0758171f702b5b6024bdf47d25d8166d,
			fnDecimal:             fnDecimal_a78485e7dd32c95f41af4e18420793bf,
			fnFmtAccounting:       fnFmtAccounting_295d01ff3669c94717ee670511c0e25e,
			fnFmtCurrency:         fnFmtCurrency_c43b1593289525b3b62af252d88e9f2d,
			fnFmtDateFull:         fnFmtDateFull_b94af095d9cfcd967654d0fbd68f2e98,
			fnFmtDateLong:         fnFmtDateLong_506f643cda0514f66d873a9ea99bf639,
			fnFmtDateMedium:       fnFmtDateMedium_cb43e8c32d5cd0a27ac6db293a7981fd,
			fnFmtDateShort:        fnFmtDateShort_c475a13000fd4072cf8feb7c7b40c476,
			fnFmtNumber:           fnFmtNumber_fc1f852c40326b41ed4436818cad7bfb,
			fnFmtPercent:          fnFmtPercent_1c35b3868bf10d0e69b22b2e80c40671,
			fnFmtTimeFull:         fnFmtTimeFull_ebdf96de1e47f9043145564c500ef7dc,
			fnFmtTimeLong:         fnFmtTimeLong_987bec4676d3a5de4218e415e123649d,
			fnFmtTimeMedium:       fnFmtTimeMedium_b6f697552cd4965cd1195fe56dc87003,
			fnFmtTimeShort:        fnFmtTimeShort_8ffba4d1a2f04a0a6486853d76cf434b,
			fnGroup:               fnGroup_5c4b80a5ccdee81467241784ab8fcd56,
			fnLocale:              fnLocale_5a217059c67094defae82f249f55f4c5,
			fnMinus:               fnMinus_8b8229905258388dc16a5e0c270b0488,
			fnMonthAbbreviated:    fnMonthAbbreviated_aa9a9957cd9d056ba078b36a08b17478,
			fnMonthNarrow:         fnMonthNarrow_45916040ecf6fc350894d9e3e6c46dc7,
			fnMonthWide:           fnMonthWide_4c946a7e7581c665e7407df1841810b5,
			fnMonthsAbbreviated:   fnMonthsAbbreviated_181f77804b62232997fae36bd57d6cf7,
			fnMonthsNarrow:        fnMonthsNarrow_75daa2ba82ae9577292175c3f52370cc,
			fnMonthsWide:          fnMonthsWide_0ecf36a8b72255e2fee9467af362e989,
			fnOrdinalPluralRule:   fnOrdinalPluralRule_822e96e7fb113a3156c2e7c532855968,
			fnPluralsCardinal:     fnPluralsCardinal_85b19cac1fab9f2c2cfb9eb41539aa0e,
			fnPluralsOrdinal:      fnPluralsOrdinal_16a60aa09da9778fa82fe463e83076de,
			fnPluralsRange:        fnPluralsRange_332465bda13eb808b3664fa0500f54ce,
			fnRangePluralRule:     fnRangePluralRule_a46571fc772262a1fe652a3412eb1140,
			fnWeekdayAbbreviated:  fnWeekdayAbbreviated_4ffbdfbd2be10e6bd8fb5a542a14664a,
			fnWeekdayNarrow:       fnWeekdayNarrow_e86921b3446df5ea9afe9504cfa20d1a,
			fnWeekdayShort:        fnWeekdayShort_82b231d4f504c6d71c7e495aa35cd3c2,
			fnWeekdayWide:         fnWeekdayWide_ab7e026d8685cefd89c5aeb5df512a9a,
			fnWeekdaysAbbreviated: fnWeekdaysAbbreviated_454a3d7d23c662520a64ae5245d404be,
			fnWeekdaysNarrow:      fnWeekdaysNarrow_d23eb0b7a498c40ce19d1bf231cad524,
			fnWeekdaysShort:       fnWeekdaysShort_eb6ee64d01e314991432b4469790d38b,
			fnWeekdaysWide:        fnWeekdaysWide_5e2bbf75a31e730429c100e8a0bd3ebd,
		}
	}
	translatorFuncs["az_cyrl"] = func() locales.Translator {
		return &localen{

			locale:                 "az_Cyrl",
			pluralsCardinal:        []locales.PluralRule{2, 6},
			pluralsOrdinal:         []locales.PluralRule{2, 4, 5, 6},
			pluralsRange:           []locales.PluralRule{2, 6},
			decimal:                ",",
			group:                  ".",
			minus:                  "-",
			percent:                "%",
			perMille:               "‰",
			timeSeparator:          ":",
			inifinity:              "∞",
			currencies:             []string{"ADP", "AED", "AFA", "AFN", "ALK", "ALL", "AMD", "ANG", "AOA", "AOK", "AON", "AOR", "ARA", "ARL", "ARM", "ARP", "ARS", "ATS", "AUD", "AWG", "AZM", "₼", "BAD", "BAM", "BAN", "BBD", "BDT", "BEC", "BEF", "BEL", "BGL", "BGM", "BGN", "BGO", "BHD", "BIF", "BMD", "BND", "BOB", "BOL", "BOP", "BOV", "BRB", "BRC", "BRE", "BRL", "BRN", "BRR", "BRZ", "BSD", "BTN", "BUK", "BWP", "BYB", "BYN", "BYR", "BZD", "CAD", "CDF", "CHE", "CHF", "CHW", "CLE", "CLF", "CLP", "CNH", "CNX", "CNY", "COP", "COU", "CRC", "CSD", "CSK", "CUC", "CUP", "CVE", "CYP", "CZK", "DDM", "DEM", "DJF", "DKK", "DOP", "DZD", "ECS", "ECV", "EEK", "EGP", "ERN", "ESA", "ESB", "ESP", "ETB", "EUR", "FIM", "FJD", "FKP", "FRF", "GBP", "GEK", "GEL", "GHC", "GHS", "GIP", "GMD", "GNF", "GNS", "GQE", "GRD", "GTQ", "GWE", "GWP", "GYD", "HKD", "HNL", "HRD", "HRK", "HTG", "HUF", "IDR", "IEP", "ILP", "ILR", "ILS", "INR", "IQD", "IRR", "ISJ", "ISK", "ITL", "JMD", "JOD", "JPY", "KES", "KGS", "KHR", "KMF", "KPW", "KRH", "KRO", "KRW", "KWD", "KYD", "KZT", "LAK", "LBP", "LKR", "LRD", "LSL", "LTL", "LTT", "LUC", "LUF", "LUL", "LVL", "LVR", "LYD", "MAD", "MAF", "MCF", "MDC", "MDL", "MGA", "MGF", "MKD", "MKN", "MLF", "MMK", "MNT", "MOP", "MRO", "MRU", "MTL", "MTP", "MUR", "MVP", "MVR", "MWK", "MXN", "MXP", "MXV", "MYR", "MZE", "MZM", "MZN", "NAD", "NGN", "NIC", "NIO", "NLG", "NOK", "NPR", "NZD", "OMR", "PAB", "PEI", "PEN", "PES", "PGK", "PHP", "PKR", "PLN", "PLZ", "PTE", "PYG", "QAR", "RHD", "ROL", "RON", "RSD", "RUB", "RUR", "RWF", "SAR", "SBD", "SCR", "SDD", "SDG", "SDP", "SEK", "SGD", "SHP", "SIT", "SKK", "SLL", "SOS", "SRD", "SRG", "SSP", "STD", "STN", "SUR", "SVC", "SYP", "SZL", "THB", "TJR", "TJS", "TMM", "TMT", "TND", "TOP", "TPE", "TRL", "TRY", "TTD", "TWD", "TZS", "UAH", "UAK", "UGS", "UGX", "USD", "USN", "USS", "UYI", "UYP", "UYU", "UYW", "UZS", "VEB", "VEF", "VES", "VND", "VNN", "VUV", "WST", "XAF", "XAG", "XAU", "XBA", "XBB", "XBC", "XBD", "XCD", "XDR", "XEU", "XFO", "XFU", "XOF", "XPD", "XPF", "XPT", "XRE", "XSU", "XTS", "XUA", "XXX", "YDD", "YER", "YUD", "YUM", "YUN", "YUR", "ZAL", "ZAR", "ZMK", "ZMW", "ZRN", "ZRZ", "ZWD", "ZWL", "ZWR"},
			currencyPositiveSuffix: " ",
			currencyNegativeSuffix: " ",
			monthsAbbreviated:      []string{"", "јан", "фев", "мар", "апр", "май", "ијн", "ијл", "авг", "сен", "окт", "ној", "дек"},
			monthsNarrow:           []string{"", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12"},
			monthsWide:             []string{"", "јанвар", "феврал", "март", "апрел", "май", "ијун", "ијул", "август", "сентјабр", "октјабр", "нојабр", "декабр"},
			daysAbbreviated:        []string{"Б.", "Б.Е.", "Ч.А.", "Ч.", "Ҹ.А.", "Ҹ.", "Ш."},
			daysNarrow:             []string{"7", "1", "2", "3", "4", "5", "6"},
			daysShort:              []string{"Б.", "Б.Е.", "Ч.А.", "Ч.", "Ҹ.А.", "Ҹ.", "Ш."},
			daysWide:               []string{"базар", "базар ертәси", "чәршәнбә ахшамы", "чәршәнбә", "ҹүмә ахшамы", "ҹүмә", "шәнбә"},
			periodsAbbreviated:     []string{"АМ", "ПМ"},
			periodsNarrow:          []string{"а", "п"},
			periodsWide:            []string{"АМ", "ПМ"},
			erasAbbreviated:        []string{"е.ә.", "ј.е."},
			erasNarrow:             []string{"", ""},
			erasWide:               []string{"ерамыздан әввәл", "јени ера"},
			timezones:              map[string]string{"ACDT": "Mərkəzi Avstraliya Yay Vaxtı", "ACST": "Mərkəzi Avstraliya Standart Vaxtı", "ACWDT": "Mərkəzi Qərbi Avstraliya Yay Vaxtı", "ACWST": "Mərkəzi Qərbi Avstraliya Standart Vaxtı", "ADT": "Atlantik Yay Vaxtı", "AEDT": "Şərqi Avstraliya Yay Vaxtı", "AEST": "Şərqi Avstraliya Standart Vaxtı", "AKDT": "Alyaska Yay Vaxtı", "AKST": "Alyaska Standart Vaxtı", "ARST": "Argentina Yay Vaxtı", "ART": "Argentina Standart Vaxtı", "AST": "Atlantik Standart Vaxt", "AWDT": "Qərbi Avstraliya Yay Vaxtı", "AWST": "Qərbi Avstraliya Standart Vaxtı", "BOT": "Boliviya Vaxtı", "BT": "Butan Vaxtı", "CAT": "Mərkəzi Afrika Vaxtı", "CDT": "Şimali Mərkəzi Amerika Yay Vaxtı", "CHADT": "Çatham Yay Vaxtı", "CHAST": "Çatham Standart Vaxtı", "CLST": "Çili Yay Vaxtı", "CLT": "Çili Standart Vaxtı", "COST": "Kolumbiya Yay Vaxtı", "COT": "Kolumbiya Standart Vaxtı", "CST": "Şimali Mərkəzi Amerika Standart Vaxtı", "ChST": "Çamorro Vaxtı", "EAT": "Şərqi Afrika Vaxtı", "ECT": "Ekvador Vaxtı", "EDT": "Şimali Şərqi Amerika Yay Vaxtı", "EST": "Şimali Şərqi Amerika Standart Vaxtı", "GFT": "Fransız Qvianası Vaxtı", "GMT": "Qrinviç Orta Vaxtı", "GST": "Körfəz Vaxtı", "GYT": "Qayana Vaxtı", "HADT": "Havay-Aleut Yay Vaxtı", "HAST": "Havay-Aleut Standart Vaxtı", "HAT": "Nyufaundlend Yay Vaxtı", "HECU": "Kuba Yay Vaxtı", "HEEG": "Şərqi Qrenlandiya Yay Vaxtı", "HENOMX": "Şimal-Qərbi Meksika Yay Vaxtı", "HEOG": "Qərbi Qrenlandiya Yay Vaxtı", "HEPM": "Müqəddəs Pyer və Mikelon Yay Vaxtı", "HEPMX": "Meksika Sakit Okean Yay Vaxtı", "HKST": "Honq Konq Yay Vaxtı", "HKT": "Honq Konq Standart Vaxtı", "HNCU": "Kuba Standart Vaxtı", "HNEG": "Şərqi Qrenlandiya Standart Vaxtı", "HNNOMX": "Şimal-Qərbi Meksika Standart Vaxtı", "HNOG": "Qərbi Qrenlandiya Standart Vaxtı", "HNPM": "Müqəddəs Pyer və Mikelon Standart Vaxtı", "HNPMX": "Meksika Sakit Okean Standart Vaxtı", "HNT": "Nyufaundlend Standart Vaxtı", "IST": "Hindistan Vaxtı", "JDT": "Yaponiya Yay Vaxtı", "JST": "Yaponiya Standart Vaxtı", "LHDT": "Lord Hau Yay vaxtı", "LHST": "Lord Hau Standart Vaxtı", "MDT": "Şimali Dağlıq Amerika Yay Vaxtı", "MESZ": "Mərkəzi Avropa Yay Vaxtı", "MEZ": "Mərkəzi Avropa Standart Vaxtı", "MST": "Şimali Dağlıq Amerika Standart Vaxtı", "MYT": "Malayziya Vaxtı", "NZDT": "Yeni Zelandiya Yay Vaxtı", "NZST": "Yeni Zelandiya Standart Vaxtı", "OESZ": "Şərqi Avropa Yay Vaxtı", "OEZ": "Şərqi Avropa Standart Vaxtı", "PDT": "Şimali Amerika Sakit Okean Yay Vaxtı", "PST": "Şimali Amerika Sakit Okean Standart Vaxtı", "SAST": "Cənubi Afrika Vaxtı", "SGT": "Sinqapur Vaxtı", "SRT": "Surinam Vaxtı", "TMST": "Türkmənistan Yay Vaxtı", "TMT": "Türkmənistan Standart Vaxtı", "UYST": "Uruqvay Yay Vaxtı", "UYT": "Uruqvay Standart Vaxtı", "VET": "Venesuela Vaxtı", "WARST": "Qərbi Argentina Yay Vaxtı", "WART": "Qərbi Argentina Standart Vaxtı", "WAST": "Qərbi Afrika Yay Vaxtı", "WAT": "Qərbi Afrika Standart Vaxtı", "WESZ": "Qərbi Avropa Yay Vaxtı", "WEZ": "Qərbi Avropa Standart Vaxtı", "WIB": "Qərbi İndoneziya Vaxtı", "WIT": "Şərqi İndoneziya Vaxtı", "WITA": "Mərkəzi İndoneziya Vaxtı", "∅∅∅": "Azor Yay Vaxtı"},

			fnCardinalPluralRule:  fnCardinalPluralRule_0758171f702b5b6024bdf47d25d8166d,
			fnDecimal:             fnDecimal_a78485e7dd32c95f41af4e18420793bf,
			fnFmtAccounting:       fnFmtAccounting_295d01ff3669c94717ee670511c0e25e,
			fnFmtCurrency:         fnFmtCurrency_c43b1593289525b3b62af252d88e9f2d,
			fnFmtDateFull:         fnFmtDateFull_b94af095d9cfcd967654d0fbd68f2e98,
			fnFmtDateLong:         fnFmtDateLong_506f643cda0514f66d873a9ea99bf639,
			fnFmtDateMedium:       fnFmtDateMedium_cb43e8c32d5cd0a27ac6db293a7981fd,
			fnFmtDateShort:        fnFmtDateShort_c475a13000fd4072cf8feb7c7b40c476,
			fnFmtNumber:           fnFmtNumber_fc1f852c40326b41ed4436818cad7bfb,
			fnFmtPercent:          fnFmtPercent_1c35b3868bf10d0e69b22b2e80c40671,
			fnFmtTimeFull:         fnFmtTimeFull_ebdf96de1e47f9043145564c500ef7dc,
			fnFmtTimeLong:         fnFmtTimeLong_987bec4676d3a5de4218e415e123649d,
			fnFmtTimeMedium:       fnFmtTimeMedium_b6f697552cd4965cd1195fe56dc87003,
			fnFmtTimeShort:        fnFmtTimeShort_8ffba4d1a2f04a0a6486853d76cf434b,
			fnGroup:               fnGroup_5c4b80a5ccdee81467241784ab8fcd56,
			fnLocale:              fnLocale_5a217059c67094defae82f249f55f4c5,
			fnMinus:               fnMinus_8b8229905258388dc16a5e0c270b0488,
			fnMonthAbbreviated:    fnMonthAbbreviated_aa9a9957cd9d056ba078b36a08b17478,
			fnMonthNarrow:         fnMonthNarrow_45916040ecf6fc350894d9e3e6c46dc7,
			fnMonthWide:           fnMonthWide_4c946a7e7581c665e7407df1841810b5,
			fnMonthsAbbreviated:   fnMonthsAbbreviated_181f77804b62232997fae36bd57d6cf7,
			fnMonthsNarrow:        fnMonthsNarrow_75daa2ba82ae9577292175c3f52370cc,
			fnMonthsWide:          fnMonthsWide_0ecf36a8b72255e2fee9467af362e989,
			fnOrdinalPluralRule:   fnOrdinalPluralRule_822e96e7fb113a3156c2e7c532855968,
			fnPluralsCardinal:     fnPluralsCardinal_85b19cac1fab9f2c2cfb9eb41539aa0e,
			fnPluralsOrdinal:      fnPluralsOrdinal_16a60aa09da9778fa82fe463e83076de,
			fnPluralsRange:        fnPluralsRange_332465bda13eb808b3664fa0500f54ce,
			fnRangePluralRule:     fnRangePluralRule_a46571fc772262a1fe652a3412eb1140,
			fnWeekdayAbbreviated:  fnWeekdayAbbreviated_4ffbdfbd2be10e6bd8fb5a542a14664a,
			fnWeekdayNarrow:       fnWeekdayNarrow_e86921b3446df5ea9afe9504cfa20d1a,
			fnWeekdayShort:        fnWeekdayShort_82b231d4f504c6d71c7e495aa35cd3c2,
			fnWeekdayWide:         fnWeekdayWide_ab7e026d8685cefd89c5aeb5df512a9a,
			fnWeekdaysAbbreviated: fnWeekdaysAbbreviated_454a3d7d23c662520a64ae5245d404be,
			fnWeekdaysNarrow:      fnWeekdaysNarrow_d23eb0b7a498c40ce19d1bf231cad524,
			fnWeekdaysShort:       fnWeekdaysShort_eb6ee64d01e314991432b4469790d38b,
			fnWeekdaysWide:        fnWeekdaysWide_5e2bbf75a31e730429c100e8a0bd3ebd,
		}
	}
	translatorFuncs["az_cyrl_az"] = func() locales.Translator {
		return &localen{

			locale:                 "az_Cyrl_AZ",
			pluralsCardinal:        []locales.PluralRule{2, 6},
			pluralsOrdinal:         []locales.PluralRule{2, 4, 5, 6},
			pluralsRange:           []locales.PluralRule{2, 6},
			decimal:                ",",
			group:                  ".",
			minus:                  "-",
			percent:                "%",
			perMille:               "‰",
			timeSeparator:          ":",
			inifinity:              "∞",
			currencies:             []string{"ADP", "AED", "AFA", "AFN", "ALK", "ALL", "AMD", "ANG", "AOA", "AOK", "AON", "AOR", "ARA", "ARL", "ARM", "ARP", "ARS", "ATS", "AUD", "AWG", "AZM", "AZN", "BAD", "BAM", "BAN", "BBD", "BDT", "BEC", "BEF", "BEL", "BGL", "BGM", "BGN", "BGO", "BHD", "BIF", "BMD", "BND", "BOB", "BOL", "BOP", "BOV", "BRB", "BRC", "BRE", "BRL", "BRN", "BRR", "BRZ", "BSD", "BTN", "BUK", "BWP", "BYB", "BYN", "BYR", "BZD", "CAD", "CDF", "CHE", "CHF", "CHW", "CLE", "CLF", "CLP", "CNH", "CNX", "CNY", "COP", "COU", "CRC", "CSD", "CSK", "CUC", "CUP", "CVE", "CYP", "CZK", "DDM", "DEM", "DJF", "DKK", "DOP", "DZD", "ECS", "ECV", "EEK", "EGP", "ERN", "ESA", "ESB", "ESP", "ETB", "EUR", "FIM", "FJD", "FKP", "FRF", "GBP", "GEK", "GEL", "GHC", "GHS", "GIP", "GMD", "GNF", "GNS", "GQE", "GRD", "GTQ", "GWE", "GWP", "GYD", "HKD", "HNL", "HRD", "HRK", "HTG", "HUF", "IDR", "IEP", "ILP", "ILR", "ILS", "INR", "IQD", "IRR", "ISJ", "ISK", "ITL", "JMD", "JOD", "JPY", "KES", "KGS", "KHR", "KMF", "KPW", "KRH", "KRO", "KRW", "KWD", "KYD", "KZT", "LAK", "LBP", "LKR", "LRD", "LSL", "LTL", "LTT", "LUC", "LUF", "LUL", "LVL", "LVR", "LYD", "MAD", "MAF", "MCF", "MDC", "MDL", "MGA", "MGF", "MKD", "MKN", "MLF", "MMK", "MNT", "MOP", "MRO", "MRU", "MTL", "MTP", "MUR", "MVP", "MVR", "MWK", "MXN", "MXP", "MXV", "MYR", "MZE", "MZM", "MZN", "NAD", "NGN", "NIC", "NIO", "NLG", "NOK", "NPR", "NZD", "OMR", "PAB", "PEI", "PEN", "PES", "PGK", "PHP", "PKR", "PLN", "PLZ", "PTE", "PYG", "QAR", "RHD", "ROL", "RON", "RSD", "RUB", "RUR", "RWF", "SAR", "SBD", "SCR", "SDD", "SDG", "SDP", "SEK", "SGD", "SHP", "SIT", "SKK", "SLL", "SOS", "SRD", "SRG", "SSP", "STD", "STN", "SUR", "SVC", "SYP", "SZL", "THB", "TJR", "TJS", "TMM", "TMT", "TND", "TOP", "TPE", "TRL", "TRY", "TTD", "TWD", "TZS", "UAH", "UAK", "UGS", "UGX", "USD", "USN", "USS", "UYI", "UYP", "UYU", "UYW", "UZS", "VEB", "VEF", "VES", "VND", "VNN", "VUV", "WST", "XAF", "XAG", "XAU", "XBA", "XBB", "XBC", "XBD", "XCD", "XDR", "XEU", "XFO", "XFU", "XOF", "XPD", "XPF", "XPT", "XRE", "XSU", "XTS", "XUA", "XXX", "YDD", "YER", "YUD", "YUM", "YUN", "YUR", "ZAL", "ZAR", "ZMK", "ZMW", "ZRN", "ZRZ", "ZWD", "ZWL", "ZWR"},
			currencyPositiveSuffix: " ",
			currencyNegativeSuffix: " ",
			monthsAbbreviated:      []string{"", "yan", "fev", "mar", "apr", "may", "iyn", "iyl", "avq", "sen", "okt", "noy", "dek"},
			monthsNarrow:           []string{"", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12"},
			monthsWide:             []string{"", "yanvar", "fevral", "mart", "aprel", "may", "iyun", "iyul", "avqust", "sentyabr", "oktyabr", "noyabr", "dekabr"},
			daysAbbreviated:        []string{"B.", "B.e.", "Ç.a.", "Ç.", "C.a.", "C.", "Ş."},
			daysNarrow:             []string{"7", "1", "2", "3", "4", "5", "6"},
			daysShort:              []string{"B.", "B.E.", "Ç.A.", "Ç.", "C.A.", "C.", "Ş."},
			daysWide:               []string{"bazar", "bazar ertəsi", "çərşənbə axşamı", "çərşənbə", "cümə axşamı", "cümə", "şənbə"},
			periodsAbbreviated:     []string{"AM", "PM"},
			periodsNarrow:          []string{"a", "p"},
			periodsWide:            []string{"AM", "PM"},
			erasAbbreviated:        []string{"e.ə.", "y.e."},
			erasNarrow:             []string{"", ""},
			erasWide:               []string{"eramızdan əvvəl", "yeni era"},
			timezones:              map[string]string{"ACDT": "Mərkəzi Avstraliya Yay Vaxtı", "ACST": "Mərkəzi Avstraliya Standart Vaxtı", "ACWDT": "Mərkəzi Qərbi Avstraliya Yay Vaxtı", "ACWST": "Mərkəzi Qərbi Avstraliya Standart Vaxtı", "ADT": "Atlantik Yay Vaxtı", "AEDT": "Şərqi Avstraliya Yay Vaxtı", "AEST": "Şərqi Avstraliya Standart Vaxtı", "AKDT": "Alyaska Yay Vaxtı", "AKST": "Alyaska Standart Vaxtı", "ARST": "Argentina Yay Vaxtı", "ART": "Argentina Standart Vaxtı", "AST": "Atlantik Standart Vaxt", "AWDT": "Qərbi Avstraliya Yay Vaxtı", "AWST": "Qərbi Avstraliya Standart Vaxtı", "BOT": "Boliviya Vaxtı", "BT": "Butan Vaxtı", "CAT": "Mərkəzi Afrika Vaxtı", "CDT": "Şimali Mərkəzi Amerika Yay Vaxtı", "CHADT": "Çatham Yay Vaxtı", "CHAST": "Çatham Standart Vaxtı", "CLST": "Çili Yay Vaxtı", "CLT": "Çili Standart Vaxtı", "COST": "Kolumbiya Yay Vaxtı", "COT": "Kolumbiya Standart Vaxtı", "CST": "Şimali Mərkəzi Amerika Standart Vaxtı", "ChST": "Çamorro Vaxtı", "EAT": "Şərqi Afrika Vaxtı", "ECT": "Ekvador Vaxtı", "EDT": "Şimali Şərqi Amerika Yay Vaxtı", "EST": "Şimali Şərqi Amerika Standart Vaxtı", "GFT": "Fransız Qvianası Vaxtı", "GMT": "Qrinviç Orta Vaxtı", "GST": "Körfəz Vaxtı", "GYT": "Qayana Vaxtı", "HADT": "Havay-Aleut Yay Vaxtı", "HAST": "Havay-Aleut Standart Vaxtı", "HAT": "Nyufaundlend Yay Vaxtı", "HECU": "Kuba Yay Vaxtı", "HEEG": "Şərqi Qrenlandiya Yay Vaxtı", "HENOMX": "Şimal-Qərbi Meksika Yay Vaxtı", "HEOG": "Qərbi Qrenlandiya Yay Vaxtı", "HEPM": "Müqəddəs Pyer və Mikelon Yay Vaxtı", "HEPMX": "Meksika Sakit Okean Yay Vaxtı", "HKST": "Honq Konq Yay Vaxtı", "HKT": "Honq Konq Standart Vaxtı", "HNCU": "Kuba Standart Vaxtı", "HNEG": "Şərqi Qrenlandiya Standart Vaxtı", "HNNOMX": "Şimal-Qərbi Meksika Standart Vaxtı", "HNOG": "Qərbi Qrenlandiya Standart Vaxtı", "HNPM": "Müqəddəs Pyer və Mikelon Standart Vaxtı", "HNPMX": "Meksika Sakit Okean Standart Vaxtı", "HNT": "Nyufaundlend Standart Vaxtı", "IST": "Hindistan Vaxtı", "JDT": "Yaponiya Yay Vaxtı", "JST": "Yaponiya Standart Vaxtı", "LHDT": "Lord Hau Yay vaxtı", "LHST": "Lord Hau Standart Vaxtı", "MDT": "Şimali Dağlıq Amerika Yay Vaxtı", "MESZ": "Mərkəzi Avropa Yay Vaxtı", "MEZ": "Mərkəzi Avropa Standart Vaxtı", "MST": "Şimali Dağlıq Amerika Standart Vaxtı", "MYT": "Malayziya Vaxtı", "NZDT": "Yeni Zelandiya Yay Vaxtı", "NZST": "Yeni Zelandiya Standart Vaxtı", "OESZ": "Şərqi Avropa Yay Vaxtı", "OEZ": "Şərqi Avropa Standart Vaxtı", "PDT": "Şimali Amerika Sakit Okean Yay Vaxtı", "PST": "Şimali Amerika Sakit Okean Standart Vaxtı", "SAST": "Cənubi Afrika Vaxtı", "SGT": "Sinqapur Vaxtı", "SRT": "Surinam Vaxtı", "TMST": "Türkmənistan Yay Vaxtı", "TMT": "Türkmənistan Standart Vaxtı", "UYST": "Uruqvay Yay Vaxtı", "UYT": "Uruqvay Standart Vaxtı", "VET": "Venesuela Vaxtı", "WARST": "Qərbi Argentina Yay Vaxtı", "WART": "Qərbi Argentina Standart Vaxtı", "WAST": "Qərbi Afrika Yay Vaxtı", "WAT": "Qərbi Afrika Standart Vaxtı", "WESZ": "Qərbi Avropa Yay Vaxtı", "WEZ": "Qərbi Avropa Standart Vaxtı", "WIB": "Qərbi İndoneziya Vaxtı", "WIT": "Şərqi İndoneziya Vaxtı", "WITA": "Mərkəzi İndoneziya Vaxtı", "∅∅∅": "Azor Yay Vaxtı"},

			fnCardinalPluralRule:  fnCardinalPluralRule_0758171f702b5b6024bdf47d25d8166d,
			fnDecimal:             fnDecimal_a78485e7dd32c95f41af4e18420793bf,
			fnFmtAccounting:       fnFmtAccounting_295d01ff3669c94717ee670511c0e25e,
			fnFmtCurrency:         fnFmtCurrency_c43b1593289525b3b62af252d88e9f2d,
			fnFmtDateFull:         fnFmtDateFull_b94af095d9cfcd967654d0fbd68f2e98,
			fnFmtDateLong:         fnFmtDateLong_506f643cda0514f66d873a9ea99bf639,
			fnFmtDateMedium:       fnFmtDateMedium_cb43e8c32d5cd0a27ac6db293a7981fd,
			fnFmtDateShort:        fnFmtDateShort_c475a13000fd4072cf8feb7c7b40c476,
			fnFmtNumber:           fnFmtNumber_fc1f852c40326b41ed4436818cad7bfb,
			fnFmtPercent:          fnFmtPercent_1c35b3868bf10d0e69b22b2e80c40671,
			fnFmtTimeFull:         fnFmtTimeFull_ebdf96de1e47f9043145564c500ef7dc,
			fnFmtTimeLong:         fnFmtTimeLong_987bec4676d3a5de4218e415e123649d,
			fnFmtTimeMedium:       fnFmtTimeMedium_b6f697552cd4965cd1195fe56dc87003,
			fnFmtTimeShort:        fnFmtTimeShort_8ffba4d1a2f04a0a6486853d76cf434b,
			fnGroup:               fnGroup_5c4b80a5ccdee81467241784ab8fcd56,
			fnLocale:              fnLocale_5a217059c67094defae82f249f55f4c5,
			fnMinus:               fnMinus_8b8229905258388dc16a5e0c270b0488,
			fnMonthAbbreviated:    fnMonthAbbreviated_aa9a9957cd9d056ba078b36a08b17478,
			fnMonthNarrow:         fnMonthNarrow_45916040ecf6fc350894d9e3e6c46dc7,
			fnMonthWide:           fnMonthWide_4c946a7e7581c665e7407df1841810b5,
			fnMonthsAbbreviated:   fnMonthsAbbreviated_181f77804b62232997fae36bd57d6cf7,
			fnMonthsNarrow:        fnMonthsNarrow_75daa2ba82ae9577292175c3f52370cc,
			fnMonthsWide:          fnMonthsWide_0ecf36a8b72255e2fee9467af362e989,
			fnOrdinalPluralRule:   fnOrdinalPluralRule_822e96e7fb113a3156c2e7c532855968,
			fnPluralsCardinal:     fnPluralsCardinal_85b19cac1fab9f2c2cfb9eb41539aa0e,
			fnPluralsOrdinal:      fnPluralsOrdinal_16a60aa09da9778fa82fe463e83076de,
			fnPluralsRange:        fnPluralsRange_332465bda13eb808b3664fa0500f54ce,
			fnRangePluralRule:     fnRangePluralRule_a46571fc772262a1fe652a3412eb1140,
			fnWeekdayAbbreviated:  fnWeekdayAbbreviated_4ffbdfbd2be10e6bd8fb5a542a14664a,
			fnWeekdayNarrow:       fnWeekdayNarrow_e86921b3446df5ea9afe9504cfa20d1a,
			fnWeekdayShort:        fnWeekdayShort_82b231d4f504c6d71c7e495aa35cd3c2,
			fnWeekdayWide:         fnWeekdayWide_ab7e026d8685cefd89c5aeb5df512a9a,
			fnWeekdaysAbbreviated: fnWeekdaysAbbreviated_454a3d7d23c662520a64ae5245d404be,
			fnWeekdaysNarrow:      fnWeekdaysNarrow_d23eb0b7a498c40ce19d1bf231cad524,
			fnWeekdaysShort:       fnWeekdaysShort_eb6ee64d01e314991432b4469790d38b,
			fnWeekdaysWide:        fnWeekdaysWide_5e2bbf75a31e730429c100e8a0bd3ebd,
		}
	}
	translatorFuncs["az_latn"] = func() locales.Translator {
		return &localen{

			locale:                 "az_Latn",
			pluralsCardinal:        []locales.PluralRule{2, 6},
			pluralsOrdinal:         []locales.PluralRule{2, 4, 5, 6},
			pluralsRange:           []locales.PluralRule{2, 6},
			decimal:                ",",
			group:                  ".",
			minus:                  "-",
			percent:                "%",
			perMille:               "‰",
			timeSeparator:          ":",
			inifinity:              "∞",
			currencies:             []string{"ADP", "AED", "AFA", "AFN", "ALK", "ALL", "AMD", "ANG", "AOA", "AOK", "AON", "AOR", "ARA", "ARL", "ARM", "ARP", "ARS", "ATS", "AUD", "AWG", "AZM", "AZN", "BAD", "BAM", "BAN", "BBD", "BDT", "BEC", "BEF", "BEL", "BGL", "BGM", "BGN", "BGO", "BHD", "BIF", "BMD", "BND", "BOB", "BOL", "BOP", "BOV", "BRB", "BRC", "BRE", "BRL", "BRN", "BRR", "BRZ", "BSD", "BTN", "BUK", "BWP", "BYB", "BYN", "BYR", "BZD", "CAD", "CDF", "CHE", "CHF", "CHW", "CLE", "CLF", "CLP", "CNH", "CNX", "CNY", "COP", "COU", "CRC", "CSD", "CSK", "CUC", "CUP", "CVE", "CYP", "CZK", "DDM", "DEM", "DJF", "DKK", "DOP", "DZD", "ECS", "ECV", "EEK", "EGP", "ERN", "ESA", "ESB", "ESP", "ETB", "EUR", "FIM", "FJD", "FKP", "FRF", "GBP", "GEK", "GEL", "GHC", "GHS", "GIP", "GMD", "GNF", "GNS", "GQE", "GRD", "GTQ", "GWE", "GWP", "GYD", "HKD", "HNL", "HRD", "HRK", "HTG", "HUF", "IDR", "IEP", "ILP", "ILR", "ILS", "INR", "IQD", "IRR", "ISJ", "ISK", "ITL", "JMD", "JOD", "JPY", "KES", "KGS", "KHR", "KMF", "KPW", "KRH", "KRO", "KRW", "KWD", "KYD", "KZT", "LAK", "LBP", "LKR", "LRD", "LSL", "LTL", "LTT", "LUC", "LUF", "LUL", "LVL", "LVR", "LYD", "MAD", "MAF", "MCF", "MDC", "MDL", "MGA", "MGF", "MKD", "MKN", "MLF", "MMK", "MNT", "MOP", "MRO", "MRU", "MTL", "MTP", "MUR", "MVP", "MVR", "MWK", "MXN", "MXP", "MXV", "MYR", "MZE", "MZM", "MZN", "NAD", "NGN", "NIC", "NIO", "NLG", "NOK", "NPR", "NZD", "OMR", "PAB", "PEI", "PEN", "PES", "PGK", "PHP", "PKR", "PLN", "PLZ", "PTE", "PYG", "QAR", "RHD", "ROL", "RON", "RSD", "RUB", "RUR", "RWF", "SAR", "SBD", "SCR", "SDD", "SDG", "SDP", "SEK", "SGD", "SHP", "SIT", "SKK", "SLL", "SOS", "SRD", "SRG", "SSP", "STD", "STN", "SUR", "SVC", "SYP", "SZL", "THB", "TJR", "TJS", "TMM", "TMT", "TND", "TOP", "TPE", "TRL", "TRY", "TTD", "TWD", "TZS", "UAH", "UAK", "UGS", "UGX", "USD", "USN", "USS", "UYI", "UYP", "UYU", "UYW", "UZS", "VEB", "VEF", "VES", "VND", "VNN", "VUV", "WST", "XAF", "XAG", "XAU", "XBA", "XBB", "XBC", "XBD", "XCD", "XDR", "XEU", "XFO", "XFU", "XOF", "XPD", "XPF", "XPT", "XRE", "XSU", "XTS", "XUA", "XXX", "YDD", "YER", "YUD", "YUM", "YUN", "YUR", "ZAL", "ZAR", "ZMK", "ZMW", "ZRN", "ZRZ", "ZWD", "ZWL", "ZWR"},
			currencyPositiveSuffix: " ",
			currencyNegativeSuffix: " ",
			monthsAbbreviated:      []string{"", "yan", "fev", "mar", "apr", "may", "iyn", "iyl", "avq", "sen", "okt", "noy", "dek"},
			monthsNarrow:           []string{"", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12"},
			monthsWide:             []string{"", "yanvar", "fevral", "mart", "aprel", "may", "iyun", "iyul", "avqust", "sentyabr", "oktyabr", "noyabr", "dekabr"},
			daysAbbreviated:        []string{"B.", "B.e.", "Ç.a.", "Ç.", "C.a.", "C.", "Ş."},
			daysNarrow:             []string{"7", "1", "2", "3", "4", "5", "6"},
			daysShort:              []string{"B.", "B.E.", "Ç.A.", "Ç.", "C.A.", "C.", "Ş."},
			daysWide:               []string{"bazar", "bazar ertəsi", "çərşənbə axşamı", "çərşənbə", "cümə axşamı", "cümə", "şənbə"},
			periodsAbbreviated:     []string{"AM", "PM"},
			periodsNarrow:          []string{"a", "p"},
			periodsWide:            []string{"AM", "PM"},
			erasAbbreviated:        []string{"e.ə.", "y.e."},
			erasNarrow:             []string{"", ""},
			erasWide:               []string{"eramızdan əvvəl", "yeni era"},
			timezones:              map[string]string{"ACDT": "Mərkəzi Avstraliya Yay Vaxtı", "ACST": "Mərkəzi Avstraliya Standart Vaxtı", "ACWDT": "Mərkəzi Qərbi Avstraliya Yay Vaxtı", "ACWST": "Mərkəzi Qərbi Avstraliya Standart Vaxtı", "ADT": "Atlantik Yay Vaxtı", "AEDT": "Şərqi Avstraliya Yay Vaxtı", "AEST": "Şərqi Avstraliya Standart Vaxtı", "AKDT": "Alyaska Yay Vaxtı", "AKST": "Alyaska Standart Vaxtı", "ARST": "Argentina Yay Vaxtı", "ART": "Argentina Standart Vaxtı", "AST": "Atlantik Standart Vaxt", "AWDT": "Qərbi Avstraliya Yay Vaxtı", "AWST": "Qərbi Avstraliya Standart Vaxtı", "BOT": "Boliviya Vaxtı", "BT": "Butan Vaxtı", "CAT": "Mərkəzi Afrika Vaxtı", "CDT": "Şimali Mərkəzi Amerika Yay Vaxtı", "CHADT": "Çatham Yay Vaxtı", "CHAST": "Çatham Standart Vaxtı", "CLST": "Çili Yay Vaxtı", "CLT": "Çili Standart Vaxtı", "COST": "Kolumbiya Yay Vaxtı", "COT": "Kolumbiya Standart Vaxtı", "CST": "Şimali Mərkəzi Amerika Standart Vaxtı", "ChST": "Çamorro Vaxtı", "EAT": "Şərqi Afrika Vaxtı", "ECT": "Ekvador Vaxtı", "EDT": "Şimali Şərqi Amerika Yay Vaxtı", "EST": "Şimali Şərqi Amerika Standart Vaxtı", "GFT": "Fransız Qvianası Vaxtı", "GMT": "Qrinviç Orta Vaxtı", "GST": "Körfəz Vaxtı", "GYT": "Qayana Vaxtı", "HADT": "Havay-Aleut Yay Vaxtı", "HAST": "Havay-Aleut Standart Vaxtı", "HAT": "Nyufaundlend Yay Vaxtı", "HECU": "Kuba Yay Vaxtı", "HEEG": "Şərqi Qrenlandiya Yay Vaxtı", "HENOMX": "Şimal-Qərbi Meksika Yay Vaxtı", "HEOG": "Qərbi Qrenlandiya Yay Vaxtı", "HEPM": "Müqəddəs Pyer və Mikelon Yay Vaxtı", "HEPMX": "Meksika Sakit Okean Yay Vaxtı", "HKST": "Honq Konq Yay Vaxtı", "HKT": "Honq Konq Standart Vaxtı", "HNCU": "Kuba Standart Vaxtı", "HNEG": "Şərqi Qrenlandiya Standart Vaxtı", "HNNOMX": "Şimal-Qərbi Meksika Standart Vaxtı", "HNOG": "Qərbi Qrenlandiya Standart Vaxtı", "HNPM": "Müqəddəs Pyer və Mikelon Standart Vaxtı", "HNPMX": "Meksika Sakit Okean Standart Vaxtı", "HNT": "Nyufaundlend Standart Vaxtı", "IST": "Hindistan Vaxtı", "JDT": "Yaponiya Yay Vaxtı", "JST": "Yaponiya Standart Vaxtı", "LHDT": "Lord Hau Yay vaxtı", "LHST": "Lord Hau Standart Vaxtı", "MDT": "Şimali Dağlıq Amerika Yay Vaxtı", "MESZ": "Mərkəzi Avropa Yay Vaxtı", "MEZ": "Mərkəzi Avropa Standart Vaxtı", "MST": "Şimali Dağlıq Amerika Standart Vaxtı", "MYT": "Malayziya Vaxtı", "NZDT": "Yeni Zelandiya Yay Vaxtı", "NZST": "Yeni Zelandiya Standart Vaxtı", "OESZ": "Şərqi Avropa Yay Vaxtı", "OEZ": "Şərqi Avropa Standart Vaxtı", "PDT": "Şimali Amerika Sakit Okean Yay Vaxtı", "PST": "Şimali Amerika Sakit Okean Standart Vaxtı", "SAST": "Cənubi Afrika Vaxtı", "SGT": "Sinqapur Vaxtı", "SRT": "Surinam Vaxtı", "TMST": "Türkmənistan Yay Vaxtı", "TMT": "Türkmənistan Standart Vaxtı", "UYST": "Uruqvay Yay Vaxtı", "UYT": "Uruqvay Standart Vaxtı", "VET": "Venesuela Vaxtı", "WARST": "Qərbi Argentina Yay Vaxtı", "WART": "Qərbi Argentina Standart Vaxtı", "WAST": "Qərbi Afrika Yay Vaxtı", "WAT": "Qərbi Afrika Standart Vaxtı", "WESZ": "Qərbi Avropa Yay Vaxtı", "WEZ": "Qərbi Avropa Standart Vaxtı", "WIB": "Qərbi İndoneziya Vaxtı", "WIT": "Şərqi İndoneziya Vaxtı", "WITA": "Mərkəzi İndoneziya Vaxtı", "∅∅∅": "Peru Yay Vaxtı"},

			fnCardinalPluralRule:  fnCardinalPluralRule_0758171f702b5b6024bdf47d25d8166d,
			fnDecimal:             fnDecimal_a78485e7dd32c95f41af4e18420793bf,
			fnFmtAccounting:       fnFmtAccounting_295d01ff3669c94717ee670511c0e25e,
			fnFmtCurrency:         fnFmtCurrency_c43b1593289525b3b62af252d88e9f2d,
			fnFmtDateFull:         fnFmtDateFull_b94af095d9cfcd967654d0fbd68f2e98,
			fnFmtDateLong:         fnFmtDateLong_506f643cda0514f66d873a9ea99bf639,
			fnFmtDateMedium:       fnFmtDateMedium_cb43e8c32d5cd0a27ac6db293a7981fd,
			fnFmtDateShort:        fnFmtDateShort_c475a13000fd4072cf8feb7c7b40c476,
			fnFmtNumber:           fnFmtNumber_fc1f852c40326b41ed4436818cad7bfb,
			fnFmtPercent:          fnFmtPercent_1c35b3868bf10d0e69b22b2e80c40671,
			fnFmtTimeFull:         fnFmtTimeFull_ebdf96de1e47f9043145564c500ef7dc,
			fnFmtTimeLong:         fnFmtTimeLong_987bec4676d3a5de4218e415e123649d,
			fnFmtTimeMedium:       fnFmtTimeMedium_b6f697552cd4965cd1195fe56dc87003,
			fnFmtTimeShort:        fnFmtTimeShort_8ffba4d1a2f04a0a6486853d76cf434b,
			fnGroup:               fnGroup_5c4b80a5ccdee81467241784ab8fcd56,
			fnLocale:              fnLocale_5a217059c67094defae82f249f55f4c5,
			fnMinus:               fnMinus_8b8229905258388dc16a5e0c270b0488,
			fnMonthAbbreviated:    fnMonthAbbreviated_aa9a9957cd9d056ba078b36a08b17478,
			fnMonthNarrow:         fnMonthNarrow_45916040ecf6fc350894d9e3e6c46dc7,
			fnMonthWide:           fnMonthWide_4c946a7e7581c665e7407df1841810b5,
			fnMonthsAbbreviated:   fnMonthsAbbreviated_181f77804b62232997fae36bd57d6cf7,
			fnMonthsNarrow:        fnMonthsNarrow_75daa2ba82ae9577292175c3f52370cc,
			fnMonthsWide:          fnMonthsWide_0ecf36a8b72255e2fee9467af362e989,
			fnOrdinalPluralRule:   fnOrdinalPluralRule_822e96e7fb113a3156c2e7c532855968,
			fnPluralsCardinal:     fnPluralsCardinal_85b19cac1fab9f2c2cfb9eb41539aa0e,
			fnPluralsOrdinal:      fnPluralsOrdinal_16a60aa09da9778fa82fe463e83076de,
			fnPluralsRange:        fnPluralsRange_332465bda13eb808b3664fa0500f54ce,
			fnRangePluralRule:     fnRangePluralRule_a46571fc772262a1fe652a3412eb1140,
			fnWeekdayAbbreviated:  fnWeekdayAbbreviated_4ffbdfbd2be10e6bd8fb5a542a14664a,
			fnWeekdayNarrow:       fnWeekdayNarrow_e86921b3446df5ea9afe9504cfa20d1a,
			fnWeekdayShort:        fnWeekdayShort_82b231d4f504c6d71c7e495aa35cd3c2,
			fnWeekdayWide:         fnWeekdayWide_ab7e026d8685cefd89c5aeb5df512a9a,
			fnWeekdaysAbbreviated: fnWeekdaysAbbreviated_454a3d7d23c662520a64ae5245d404be,
			fnWeekdaysNarrow:      fnWeekdaysNarrow_d23eb0b7a498c40ce19d1bf231cad524,
			fnWeekdaysShort:       fnWeekdaysShort_eb6ee64d01e314991432b4469790d38b,
			fnWeekdaysWide:        fnWeekdaysWide_5e2bbf75a31e730429c100e8a0bd3ebd,
		}
	}
	translatorFuncs["az_latn_az"] = func() locales.Translator {
		return &localen{

			locale:                 "az_Latn_AZ",
			pluralsCardinal:        []locales.PluralRule{2, 6},
			pluralsOrdinal:         []locales.PluralRule{2, 4, 5, 6},
			pluralsRange:           []locales.PluralRule{2, 6},
			decimal:                ",",
			group:                  ".",
			minus:                  "-",
			percent:                "%",
			perMille:               "‰",
			timeSeparator:          ":",
			inifinity:              "∞",
			currencies:             []string{"ADP", "AED", "AFA", "AFN", "ALK", "ALL", "AMD", "ANG", "AOA", "AOK", "AON", "AOR", "ARA", "ARL", "ARM", "ARP", "ARS", "ATS", "AUD", "AWG", "AZM", "AZN", "BAD", "BAM", "BAN", "BBD", "BDT", "BEC", "BEF", "BEL", "BGL", "BGM", "BGN", "BGO", "BHD", "BIF", "BMD", "BND", "BOB", "BOL", "BOP", "BOV", "BRB", "BRC", "BRE", "BRL", "BRN", "BRR", "BRZ", "BSD", "BTN", "BUK", "BWP", "BYB", "BYN", "BYR", "BZD", "CAD", "CDF", "CHE", "CHF", "CHW", "CLE", "CLF", "CLP", "CNH", "CNX", "CNY", "COP", "COU", "CRC", "CSD", "CSK", "CUC", "CUP", "CVE", "CYP", "CZK", "DDM", "DEM", "DJF", "DKK", "DOP", "DZD", "ECS", "ECV", "EEK", "EGP", "ERN", "ESA", "ESB", "ESP", "ETB", "EUR", "FIM", "FJD", "FKP", "FRF", "GBP", "GEK", "GEL", "GHC", "GHS", "GIP", "GMD", "GNF", "GNS", "GQE", "GRD", "GTQ", "GWE", "GWP", "GYD", "HKD", "HNL", "HRD", "HRK", "HTG", "HUF", "IDR", "IEP", "ILP", "ILR", "ILS", "INR", "IQD", "IRR", "ISJ", "ISK", "ITL", "JMD", "JOD", "JPY", "KES", "KGS", "KHR", "KMF", "KPW", "KRH", "KRO", "KRW", "KWD", "KYD", "KZT", "LAK", "LBP", "LKR", "LRD", "LSL", "LTL", "LTT", "LUC", "LUF", "LUL", "LVL", "LVR", "LYD", "MAD", "MAF", "MCF", "MDC", "MDL", "MGA", "MGF", "MKD", "MKN", "MLF", "MMK", "MNT", "MOP", "MRO", "MRU", "MTL", "MTP", "MUR", "MVP", "MVR", "MWK", "MXN", "MXP", "MXV", "MYR", "MZE", "MZM", "MZN", "NAD", "NGN", "NIC", "NIO", "NLG", "NOK", "NPR", "NZD", "OMR", "PAB", "PEI", "PEN", "PES", "PGK", "PHP", "PKR", "PLN", "PLZ", "PTE", "PYG", "QAR", "RHD", "ROL", "RON", "RSD", "RUB", "RUR", "RWF", "SAR", "SBD", "SCR", "SDD", "SDG", "SDP", "SEK", "SGD", "SHP", "SIT", "SKK", "SLL", "SOS", "SRD", "SRG", "SSP", "STD", "STN", "SUR", "SVC", "SYP", "SZL", "THB", "TJR", "TJS", "TMM", "TMT", "TND", "TOP", "TPE", "TRL", "TRY", "TTD", "TWD", "TZS", "UAH", "UAK", "UGS", "UGX", "USD", "USN", "USS", "UYI", "UYP", "UYU", "UYW", "UZS", "VEB", "VEF", "VES", "VND", "VNN", "VUV", "WST", "XAF", "XAG", "XAU", "XBA", "XBB", "XBC", "XBD", "XCD", "XDR", "XEU", "XFO", "XFU", "XOF", "XPD", "XPF", "XPT", "XRE", "XSU", "XTS", "XUA", "XXX", "YDD", "YER", "YUD", "YUM", "YUN", "YUR", "ZAL", "ZAR", "ZMK", "ZMW", "ZRN", "ZRZ", "ZWD", "ZWL", "ZWR"},
			currencyPositiveSuffix: " ",
			currencyNegativeSuffix: " ",
			monthsAbbreviated:      []string{"", "yan", "fev", "mar", "apr", "may", "iyn", "iyl", "avq", "sen", "okt", "noy", "dek"},
			monthsNarrow:           []string{"", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12"},
			monthsWide:             []string{"", "yanvar", "fevral", "mart", "aprel", "may", "iyun", "iyul", "avqust", "sentyabr", "oktyabr", "noyabr", "dekabr"},
			daysAbbreviated:        []string{"B.", "B.e.", "Ç.a.", "Ç.", "C.a.", "C.", "Ş."},
			daysNarrow:             []string{"7", "1", "2", "3", "4", "5", "6"},
			daysShort:              []string{"B.", "B.E.", "Ç.A.", "Ç.", "C.A.", "C.", "Ş."},
			daysWide:               []string{"bazar", "bazar ertəsi", "çərşənbə axşamı", "çərşənbə", "cümə axşamı", "cümə", "şənbə"},
			periodsAbbreviated:     []string{"AM", "PM"},
			periodsNarrow:          []string{"a", "p"},
			periodsWide:            []string{"AM", "PM"},
			erasAbbreviated:        []string{"e.ə.", "y.e."},
			erasNarrow:             []string{"", ""},
			erasWide:               []string{"eramızdan əvvəl", "yeni era"},
			timezones:              map[string]string{"ACDT": "Mərkəzi Avstraliya Yay Vaxtı", "ACST": "Mərkəzi Avstraliya Standart Vaxtı", "ACWDT": "Mərkəzi Qərbi Avstraliya Yay Vaxtı", "ACWST": "Mərkəzi Qərbi Avstraliya Standart Vaxtı", "ADT": "Atlantik Yay Vaxtı", "AEDT": "Şərqi Avstraliya Yay Vaxtı", "AEST": "Şərqi Avstraliya Standart Vaxtı", "AKDT": "Alyaska Yay Vaxtı", "AKST": "Alyaska Standart Vaxtı", "ARST": "Argentina Yay Vaxtı", "ART": "Argentina Standart Vaxtı", "AST": "Atlantik Standart Vaxt", "AWDT": "Qərbi Avstraliya Yay Vaxtı", "AWST": "Qərbi Avstraliya Standart Vaxtı", "BOT": "Boliviya Vaxtı", "BT": "Butan Vaxtı", "CAT": "Mərkəzi Afrika Vaxtı", "CDT": "Şimali Mərkəzi Amerika Yay Vaxtı", "CHADT": "Çatham Yay Vaxtı", "CHAST": "Çatham Standart Vaxtı", "CLST": "Çili Yay Vaxtı", "CLT": "Çili Standart Vaxtı", "COST": "Kolumbiya Yay Vaxtı", "COT": "Kolumbiya Standart Vaxtı", "CST": "Şimali Mərkəzi Amerika Standart Vaxtı", "ChST": "Çamorro Vaxtı", "EAT": "Şərqi Afrika Vaxtı", "ECT": "Ekvador Vaxtı", "EDT": "Şimali Şərqi Amerika Yay Vaxtı", "EST": "Şimali Şərqi Amerika Standart Vaxtı", "GFT": "Fransız Qvianası Vaxtı", "GMT": "Qrinviç Orta Vaxtı", "GST": "Körfəz Vaxtı", "GYT": "Qayana Vaxtı", "HADT": "Havay-Aleut Yay Vaxtı", "HAST": "Havay-Aleut Standart Vaxtı", "HAT": "Nyufaundlend Yay Vaxtı", "HECU": "Kuba Yay Vaxtı", "HEEG": "Şərqi Qrenlandiya Yay Vaxtı", "HENOMX": "Şimal-Qərbi Meksika Yay Vaxtı", "HEOG": "Qərbi Qrenlandiya Yay Vaxtı", "HEPM": "Müqəddəs Pyer və Mikelon Yay Vaxtı", "HEPMX": "Meksika Sakit Okean Yay Vaxtı", "HKST": "Honq Konq Yay Vaxtı", "HKT": "Honq Konq Standart Vaxtı", "HNCU": "Kuba Standart Vaxtı", "HNEG": "Şərqi Qrenlandiya Standart Vaxtı", "HNNOMX": "Şimal-Qərbi Meksika Standart Vaxtı", "HNOG": "Qərbi Qrenlandiya Standart Vaxtı", "HNPM": "Müqəddəs Pyer və Mikelon Standart Vaxtı", "HNPMX": "Meksika Sakit Okean Standart Vaxtı", "HNT": "Nyufaundlend Standart Vaxtı", "IST": "Hindistan Vaxtı", "JDT": "Yaponiya Yay Vaxtı", "JST": "Yaponiya Standart Vaxtı", "LHDT": "Lord Hau Yay vaxtı", "LHST": "Lord Hau Standart Vaxtı", "MDT": "Şimali Dağlıq Amerika Yay Vaxtı", "MESZ": "Mərkəzi Avropa Yay Vaxtı", "MEZ": "Mərkəzi Avropa Standart Vaxtı", "MST": "Şimali Dağlıq Amerika Standart Vaxtı", "MYT": "Malayziya Vaxtı", "NZDT": "Yeni Zelandiya Yay Vaxtı", "NZST": "Yeni Zelandiya Standart Vaxtı", "OESZ": "Şərqi Avropa Yay Vaxtı", "OEZ": "Şərqi Avropa Standart Vaxtı", "PDT": "Şimali Amerika Sakit Okean Yay Vaxtı", "PST": "Şimali Amerika Sakit Okean Standart Vaxtı", "SAST": "Cənubi Afrika Vaxtı", "SGT": "Sinqapur Vaxtı", "SRT": "Surinam Vaxtı", "TMST": "Türkmənistan Yay Vaxtı", "TMT": "Türkmənistan Standart Vaxtı", "UYST": "Uruqvay Yay Vaxtı", "UYT": "Uruqvay Standart Vaxtı", "VET": "Venesuela Vaxtı", "WARST": "Qərbi Argentina Yay Vaxtı", "WART": "Qərbi Argentina Standart Vaxtı", "WAST": "Qərbi Afrika Yay Vaxtı", "WAT": "Qərbi Afrika Standart Vaxtı", "WESZ": "Qərbi Avropa Yay Vaxtı", "WEZ": "Qərbi Avropa Standart Vaxtı", "WIB": "Qərbi İndoneziya Vaxtı", "WIT": "Şərqi İndoneziya Vaxtı", "WITA": "Mərkəzi İndoneziya Vaxtı", "∅∅∅": "Peru Yay Vaxtı"},

			fnCardinalPluralRule:  fnCardinalPluralRule_0758171f702b5b6024bdf47d25d8166d,
			fnDecimal:             fnDecimal_a78485e7dd32c95f41af4e18420793bf,
			fnFmtAccounting:       fnFmtAccounting_295d01ff3669c94717ee670511c0e25e,
			fnFmtCurrency:         fnFmtCurrency_c43b1593289525b3b62af252d88e9f2d,
			fnFmtDateFull:         fnFmtDateFull_b94af095d9cfcd967654d0fbd68f2e98,
			fnFmtDateLong:         fnFmtDateLong_506f643cda0514f66d873a9ea99bf639,
			fnFmtDateMedium:       fnFmtDateMedium_cb43e8c32d5cd0a27ac6db293a7981fd,
			fnFmtDateShort:        fnFmtDateShort_c475a13000fd4072cf8feb7c7b40c476,
			fnFmtNumber:           fnFmtNumber_fc1f852c40326b41ed4436818cad7bfb,
			fnFmtPercent:          fnFmtPercent_1c35b3868bf10d0e69b22b2e80c40671,
			fnFmtTimeFull:         fnFmtTimeFull_ebdf96de1e47f9043145564c500ef7dc,
			fnFmtTimeLong:         fnFmtTimeLong_987bec4676d3a5de4218e415e123649d,
			fnFmtTimeMedium:       fnFmtTimeMedium_b6f697552cd4965cd1195fe56dc87003,
			fnFmtTimeShort:        fnFmtTimeShort_8ffba4d1a2f04a0a6486853d76cf434b,
			fnGroup:               fnGroup_5c4b80a5ccdee81467241784ab8fcd56,
			fnLocale:              fnLocale_5a217059c67094defae82f249f55f4c5,
			fnMinus:               fnMinus_8b8229905258388dc16a5e0c270b0488,
			fnMonthAbbreviated:    fnMonthAbbreviated_aa9a9957cd9d056ba078b36a08b17478,
			fnMonthNarrow:         fnMonthNarrow_45916040ecf6fc350894d9e3e6c46dc7,
			fnMonthWide:           fnMonthWide_4c946a7e7581c665e7407df1841810b5,
			fnMonthsAbbreviated:   fnMonthsAbbreviated_181f77804b62232997fae36bd57d6cf7,
			fnMonthsNarrow:        fnMonthsNarrow_75daa2ba82ae9577292175c3f52370cc,
			fnMonthsWide:          fnMonthsWide_0ecf36a8b72255e2fee9467af362e989,
			fnOrdinalPluralRule:   fnOrdinalPluralRule_822e96e7fb113a3156c2e7c532855968,
			fnPluralsCardinal:     fnPluralsCardinal_85b19cac1fab9f2c2cfb9eb41539aa0e,
			fnPluralsOrdinal:      fnPluralsOrdinal_16a60aa09da9778fa82fe463e83076de,
			fnPluralsRange:        fnPluralsRange_332465bda13eb808b3664fa0500f54ce,
			fnRangePluralRule:     fnRangePluralRule_a46571fc772262a1fe652a3412eb1140,
			fnWeekdayAbbreviated:  fnWeekdayAbbreviated_4ffbdfbd2be10e6bd8fb5a542a14664a,
			fnWeekdayNarrow:       fnWeekdayNarrow_e86921b3446df5ea9afe9504cfa20d1a,
			fnWeekdayShort:        fnWeekdayShort_82b231d4f504c6d71c7e495aa35cd3c2,
			fnWeekdayWide:         fnWeekdayWide_ab7e026d8685cefd89c5aeb5df512a9a,
			fnWeekdaysAbbreviated: fnWeekdaysAbbreviated_454a3d7d23c662520a64ae5245d404be,
			fnWeekdaysNarrow:      fnWeekdaysNarrow_d23eb0b7a498c40ce19d1bf231cad524,
			fnWeekdaysShort:       fnWeekdaysShort_eb6ee64d01e314991432b4469790d38b,
			fnWeekdaysWide:        fnWeekdaysWide_5e2bbf75a31e730429c100e8a0bd3ebd,
		}
	}
	translatorFuncs["bas"] = func() locales.Translator {
		return &localen{

			locale:                 "bas",
			pluralsCardinal:        nil,
			pluralsOrdinal:         nil,
			pluralsRange:           nil,
			decimal:                ",",
			group:                  " ",
			timeSeparator:          ":",
			currencies:             []string{"ADP", "AED", "AFA", "AFN", "ALK", "ALL", "AMD", "ANG", "AOA", "AOK", "AON", "AOR", "ARA", "ARL", "ARM", "ARP", "ARS", "ATS", "AUD", "AWG", "AZM", "AZN", "BAD", "BAM", "BAN", "BBD", "BDT", "BEC", "BEF", "BEL", "BGL", "BGM", "BGN", "BGO", "BHD", "BIF", "BMD", "BND", "BOB", "BOL", "BOP", "BOV", "BRB", "BRC", "BRE", "BRL", "BRN", "BRR", "BRZ", "BSD", "BTN", "BUK", "BWP", "BYB", "BYN", "BYR", "BZD", "CAD", "CDF", "CHE", "CHF", "CHW", "CLE", "CLF", "CLP", "CNH", "CNX", "CNY", "COP", "COU", "CRC", "CSD", "CSK", "CUC", "CUP", "CVE", "CYP", "CZK", "DDM", "DEM", "DJF", "DKK", "DOP", "DZD", "ECS", "ECV", "EEK", "EGP", "ERN", "ESA", "ESB", "ESP", "ETB", "EUR", "FIM", "FJD", "FKP", "FRF", "GBP", "GEK", "GEL", "GHC", "GHS", "GIP", "GMD", "GNF", "GNS", "GQE", "GRD", "GTQ", "GWE", "GWP", "GYD", "HKD", "HNL", "HRD", "HRK", "HTG", "HUF", "IDR", "IEP", "ILP", "ILR", "ILS", "INR", "IQD", "IRR", "ISJ", "ISK", "ITL", "JMD", "JOD", "JPY", "KES", "KGS", "KHR", "KMF", "KPW", "KRH", "KRO", "KRW", "KWD", "KYD", "KZT", "LAK", "LBP", "LKR", "LRD", "LSL", "LTL", "LTT", "LUC", "LUF", "LUL", "LVL", "LVR", "LYD", "MAD", "MAF", "MCF", "MDC", "MDL", "MGA", "MGF", "MKD", "MKN", "MLF", "MMK", "MNT", "MOP", "MRO", "MRU", "MTL", "MTP", "MUR", "MVP", "MVR", "MWK", "MXN", "MXP", "MXV", "MYR", "MZE", "MZM", "MZN", "NAD", "NGN", "NIC", "NIO", "NLG", "NOK", "NPR", "NZD", "OMR", "PAB", "PEI", "PEN", "PES", "PGK", "PHP", "PKR", "PLN", "PLZ", "PTE", "PYG", "QAR", "RHD", "ROL", "RON", "RSD", "RUB", "RUR", "RWF", "SAR", "SBD", "SCR", "SDD", "SDG", "SDP", "SEK", "SGD", "SHP", "SIT", "SKK", "SLL", "SOS", "SRD", "SRG", "SSP", "STD", "STN", "SUR", "SVC", "SYP", "SZL", "THB", "TJR", "TJS", "TMM", "TMT", "TND", "TOP", "TPE", "TRL", "TRY", "TTD", "TWD", "TZS", "UAH", "UAK", "UGS", "UGX", "USD", "USN", "USS", "UYI", "UYP", "UYU", "UYW", "UZS", "VEB", "VEF", "VES", "VND", "VNN", "VUV", "WST", "XAF", "XAG", "XAU", "XBA", "XBB", "XBC", "XBD", "XCD", "XDR", "XEU", "XFO", "XFU", "XOF", "XPD", "XPF", "XPT", "XRE", "XSU", "XTS", "XUA", "XXX", "YDD", "YER", "YUD", "YUM", "YUN", "YUR", "ZAL", "ZAR", "ZMK", "ZMW", "ZRN", "ZRZ", "ZWD", "ZWL", "ZWR"},
			percentSuffix:          " ",
			currencyPositiveSuffix: " ",
			currencyNegativeSuffix: " ",
			monthsAbbreviated:      []string{"", "kɔn", "mac", "mat", "mto", "mpu", "hil", "nje", "hik", "dip", "bio", "may", "liɓ"},
			monthsNarrow:           []string{"", "k", "m", "m", "m", "m", "h", "n", "h", "d", "b", "m", "l"},
			monthsWide:             []string{"", "Kɔndɔŋ", "Màcɛ̂l", "Màtùmb", "Màtop", "M̀puyɛ", "Hìlòndɛ̀", "Njèbà", "Hìkaŋ", "Dìpɔ̀s", "Bìòôm", "Màyɛsèp", "Lìbuy li ńyèe"},
			daysAbbreviated:        []string{"nɔy", "nja", "uum", "ŋge", "mbɔ", "kɔɔ", "jon"},
			daysNarrow:             []string{"n", "n", "u", "ŋ", "m", "k", "j"},
			daysWide:               []string{"ŋgwà nɔ̂y", "ŋgwà njaŋgumba", "ŋgwà ûm", "ŋgwà ŋgê", "ŋgwà mbɔk", "ŋgwà kɔɔ", "ŋgwà jôn"},
			periodsAbbreviated:     []string{"I bikɛ̂glà", "I ɓugajɔp"},
			periodsWide:            []string{"I bikɛ̂glà", "I ɓugajɔp"},
			erasAbbreviated:        []string{"b.Y.K", "m.Y.K"},
			erasNarrow:             []string{"", ""},
			erasWide:               []string{"bisū bi Yesù Krǐstò", "i mbūs Yesù Krǐstò"},
			timezones:              map[string]string{"ACDT": "ACDT", "ACST": "ACST", "ACWDT": "ACWDT", "ACWST": "ACWST", "ADT": "ADT", "AEDT": "AEDT", "AEST": "AEST", "AKDT": "AKDT", "AKST": "AKST", "ARST": "ARST", "ART": "ART", "AST": "AST", "AWDT": "AWDT", "AWST": "AWST", "BOT": "BOT", "BT": "BT", "CAT": "CAT", "CDT": "CDT", "CHADT": "CHADT", "CHAST": "CHAST", "CLST": "CLST", "CLT": "CLT", "COST": "COST", "COT": "COT", "CST": "CST", "ChST": "ChST", "EAT": "EAT", "ECT": "ECT", "EDT": "EDT", "EST": "EST", "GFT": "GFT", "GMT": "GMT", "GST": "GST", "GYT": "GYT", "HADT": "HADT", "HAST": "HAST", "HAT": "HAT", "HECU": "HECU", "HEEG": "HEEG", "HENOMX": "HENOMX", "HEOG": "HEOG", "HEPM": "HEPM", "HEPMX": "HEPMX", "HKST": "HKST", "HKT": "HKT", "HNCU": "HNCU", "HNEG": "HNEG", "HNNOMX": "HNNOMX", "HNOG": "HNOG", "HNPM": "HNPM", "HNPMX": "HNPMX", "HNT": "HNT", "IST": "IST", "JDT": "JDT", "JST": "JST", "LHDT": "LHDT", "LHST": "LHST", "MDT": "MDT", "MESZ": "MESZ", "MEZ": "MEZ", "MST": "MST", "MYT": "MYT", "NZDT": "NZDT", "NZST": "NZST", "OESZ": "OESZ", "OEZ": "OEZ", "PDT": "PDT", "PST": "PST", "SAST": "SAST", "SGT": "SGT", "SRT": "SRT", "TMST": "TMST", "TMT": "TMT", "UYST": "UYST", "UYT": "UYT", "VET": "VET", "WARST": "WARST", "WART": "WART", "WAST": "WAST", "WAT": "WAT", "WESZ": "WESZ", "WEZ": "WEZ", "WIB": "WIB", "WIT": "WIT", "WITA": "WITA", "∅∅∅": "∅∅∅"},

			fnCardinalPluralRule:  fnCardinalPluralRule_6d6ec1478c59480bfd820f2a0c64a497,
			fnDecimal:             fnDecimal_a78485e7dd32c95f41af4e18420793bf,
			fnFmtAccounting:       fnFmtAccounting_6dd988d8f1a3fac3718e543933915046,
			fnFmtCurrency:         fnFmtCurrency_3398e8f49a5a712d32672f16a1ed2c57,
			fnFmtDateFull:         fnFmtDateFull_e5aac3b796a648ed7f4aaa501e4e3844,
			fnFmtDateLong:         fnFmtDateLong_506f643cda0514f66d873a9ea99bf639,
			fnFmtDateMedium:       fnFmtDateMedium_5e450105cccbc820e4514899ef73128f,
			fnFmtDateShort:        fnFmtDateShort_222c809496186523124eb16d6c474592,
			fnFmtNumber:           fnFmtNumber_ceab7ec754f7f75fd13d22457c77cbf9,
			fnFmtPercent:          fnFmtPercent_e53d7ec2cf4741b3601391772e4c83b0,
			fnFmtTimeFull:         fnFmtTimeFull_ebdf96de1e47f9043145564c500ef7dc,
			fnFmtTimeLong:         fnFmtTimeLong_987bec4676d3a5de4218e415e123649d,
			fnFmtTimeMedium:       fnFmtTimeMedium_b6f697552cd4965cd1195fe56dc87003,
			fnFmtTimeShort:        fnFmtTimeShort_8ffba4d1a2f04a0a6486853d76cf434b,
			fnGroup:               fnGroup_5c4b80a5ccdee81467241784ab8fcd56,
			fnLocale:              fnLocale_5a217059c67094defae82f249f55f4c5,
			fnMinus:               fnMinus_8b8229905258388dc16a5e0c270b0488,
			fnMonthAbbreviated:    fnMonthAbbreviated_aa9a9957cd9d056ba078b36a08b17478,
			fnMonthNarrow:         fnMonthNarrow_45916040ecf6fc350894d9e3e6c46dc7,
			fnMonthWide:           fnMonthWide_4c946a7e7581c665e7407df1841810b5,
			fnMonthsAbbreviated:   fnMonthsAbbreviated_181f77804b62232997fae36bd57d6cf7,
			fnMonthsNarrow:        fnMonthsNarrow_75daa2ba82ae9577292175c3f52370cc,
			fnMonthsWide:          fnMonthsWide_0ecf36a8b72255e2fee9467af362e989,
			fnOrdinalPluralRule:   fnOrdinalPluralRule_a0e5467912a746c396065750c68e4318,
			fnPluralsCardinal:     fnPluralsCardinal_85b19cac1fab9f2c2cfb9eb41539aa0e,
			fnPluralsOrdinal:      fnPluralsOrdinal_16a60aa09da9778fa82fe463e83076de,
			fnPluralsRange:        fnPluralsRange_332465bda13eb808b3664fa0500f54ce,
			fnRangePluralRule:     fnRangePluralRule_e0f62e2cf3ae7407fb4b54d084341c0b,
			fnWeekdayAbbreviated:  fnWeekdayAbbreviated_4ffbdfbd2be10e6bd8fb5a542a14664a,
			fnWeekdayNarrow:       fnWeekdayNarrow_e86921b3446df5ea9afe9504cfa20d1a,
			fnWeekdayShort:        fnWeekdayShort_82b231d4f504c6d71c7e495aa35cd3c2,
			fnWeekdayWide:         fnWeekdayWide_ab7e026d8685cefd89c5aeb5df512a9a,
			fnWeekdaysAbbreviated: fnWeekdaysAbbreviated_454a3d7d23c662520a64ae5245d404be,
			fnWeekdaysNarrow:      fnWeekdaysNarrow_d23eb0b7a498c40ce19d1bf231cad524,
			fnWeekdaysShort:       fnWeekdaysShort_eb6ee64d01e314991432b4469790d38b,
			fnWeekdaysWide:        fnWeekdaysWide_5e2bbf75a31e730429c100e8a0bd3ebd,
		}
	}
	translatorFuncs["bas_cm"] = func() locales.Translator {
		return &localen{

			locale:                 "bas_CM",
			pluralsCardinal:        nil,
			pluralsOrdinal:         nil,
			pluralsRange:           nil,
			decimal:                ",",
			group:                  " ",
			timeSeparator:          ":",
			currencies:             []string{"ADP", "AED", "AFA", "AFN", "ALK", "ALL", "AMD", "ANG", "AOA", "AOK", "AON", "AOR", "ARA", "ARL", "ARM", "ARP", "ARS", "ATS", "AUD", "AWG", "AZM", "AZN", "BAD", "BAM", "BAN", "BBD", "BDT", "BEC", "BEF", "BEL", "BGL", "BGM", "BGN", "BGO", "BHD", "BIF", "BMD", "BND", "BOB", "BOL", "BOP", "BOV", "BRB", "BRC", "BRE", "BRL", "BRN", "BRR", "BRZ", "BSD", "BTN", "BUK", "BWP", "BYB", "BYN", "BYR", "BZD", "CAD", "CDF", "CHE", "CHF", "CHW", "CLE", "CLF", "CLP", "CNH", "CNX", "CNY", "COP", "COU", "CRC", "CSD", "CSK", "CUC", "CUP", "CVE", "CYP", "CZK", "DDM", "DEM", "DJF", "DKK", "DOP", "DZD", "ECS", "ECV", "EEK", "EGP", "ERN", "ESA", "ESB", "ESP", "ETB", "EUR", "FIM", "FJD", "FKP", "FRF", "GBP", "GEK", "GEL", "GHC", "GHS", "GIP", "GMD", "GNF", "GNS", "GQE", "GRD", "GTQ", "GWE", "GWP", "GYD", "HKD", "HNL", "HRD", "HRK", "HTG", "HUF", "IDR", "IEP", "ILP", "ILR", "ILS", "INR", "IQD", "IRR", "ISJ", "ISK", "ITL", "JMD", "JOD", "JPY", "KES", "KGS", "KHR", "KMF", "KPW", "KRH", "KRO", "KRW", "KWD", "KYD", "KZT", "LAK", "LBP", "LKR", "LRD", "LSL", "LTL", "LTT", "LUC", "LUF", "LUL", "LVL", "LVR", "LYD", "MAD", "MAF", "MCF", "MDC", "MDL", "MGA", "MGF", "MKD", "MKN", "MLF", "MMK", "MNT", "MOP", "MRO", "MRU", "MTL", "MTP", "MUR", "MVP", "MVR", "MWK", "MXN", "MXP", "MXV", "MYR", "MZE", "MZM", "MZN", "NAD", "NGN", "NIC", "NIO", "NLG", "NOK", "NPR", "NZD", "OMR", "PAB", "PEI", "PEN", "PES", "PGK", "PHP", "PKR", "PLN", "PLZ", "PTE", "PYG", "QAR", "RHD", "ROL", "RON", "RSD", "RUB", "RUR", "RWF", "SAR", "SBD", "SCR", "SDD", "SDG", "SDP", "SEK", "SGD", "SHP", "SIT", "SKK", "SLL", "SOS", "SRD", "SRG", "SSP", "STD", "STN", "SUR", "SVC", "SYP", "SZL", "THB", "TJR", "TJS", "TMM", "TMT", "TND", "TOP", "TPE", "TRL", "TRY", "TTD", "TWD", "TZS", "UAH", "UAK", "UGS", "UGX", "USD", "USN", "USS", "UYI", "UYP", "UYU", "UYW", "UZS", "VEB", "VEF", "VES", "VND", "VNN", "VUV", "WST", "XAF", "XAG", "XAU", "XBA", "XBB", "XBC", "XBD", "XCD", "XDR", "XEU", "XFO", "XFU", "XOF", "XPD", "XPF", "XPT", "XRE", "XSU", "XTS", "XUA", "XXX", "YDD", "YER", "YUD", "YUM", "YUN", "YUR", "ZAL", "ZAR", "ZMK", "ZMW", "ZRN", "ZRZ", "ZWD", "ZWL", "ZWR"},
			percentSuffix:          " ",
			currencyPositiveSuffix: " ",
			currencyNegativeSuffix: " ",
			monthsAbbreviated:      []string{"", "kɔn", "mac", "mat", "mto", "mpu", "hil", "nje", "hik", "dip", "bio", "may", "liɓ"},
			monthsNarrow:           []string{"", "k", "m", "m", "m", "m", "h", "n", "h", "d", "b", "m", "l"},
			monthsWide:             []string{"", "Kɔndɔŋ", "Màcɛ̂l", "Màtùmb", "Màtop", "M̀puyɛ", "Hìlòndɛ̀", "Njèbà", "Hìkaŋ", "Dìpɔ̀s", "Bìòôm", "Màyɛsèp", "Lìbuy li ńyèe"},
			daysAbbreviated:        []string{"nɔy", "nja", "uum", "ŋge", "mbɔ", "kɔɔ", "jon"},
			daysNarrow:             []string{"n", "n", "u", "ŋ", "m", "k", "j"},
			daysWide:               []string{"ŋgwà nɔ̂y", "ŋgwà njaŋgumba", "ŋgwà ûm", "ŋgwà ŋgê", "ŋgwà mbɔk", "ŋgwà kɔɔ", "ŋgwà jôn"},
			periodsAbbreviated:     []string{"I bikɛ̂glà", "I ɓugajɔp"},
			periodsWide:            []string{"I bikɛ̂glà", "I ɓugajɔp"},
			erasAbbreviated:        []string{"b.Y.K", "m.Y.K"},
			erasNarrow:             []string{"", ""},
			erasWide:               []string{"bisū bi Yesù Krǐstò", "i mbūs Yesù Krǐstò"},
			timezones:              map[string]string{"ACDT": "ACDT", "ACST": "ACST", "ACWDT": "ACWDT", "ACWST": "ACWST", "ADT": "ADT", "AEDT": "AEDT", "AEST": "AEST", "AKDT": "AKDT", "AKST": "AKST", "ARST": "ARST", "ART": "ART", "AST": "AST", "AWDT": "AWDT", "AWST": "AWST", "BOT": "BOT", "BT": "BT", "CAT": "CAT", "CDT": "CDT", "CHADT": "CHADT", "CHAST": "CHAST", "CLST": "CLST", "CLT": "CLT", "COST": "COST", "COT": "COT", "CST": "CST", "ChST": "ChST", "EAT": "EAT", "ECT": "ECT", "EDT": "EDT", "EST": "EST", "GFT": "GFT", "GMT": "GMT", "GST": "GST", "GYT": "GYT", "HADT": "HADT", "HAST": "HAST", "HAT": "HAT", "HECU": "HECU", "HEEG": "HEEG", "HENOMX": "HENOMX", "HEOG": "HEOG", "HEPM": "HEPM", "HEPMX": "HEPMX", "HKST": "HKST", "HKT": "HKT", "HNCU": "HNCU", "HNEG": "HNEG", "HNNOMX": "HNNOMX", "HNOG": "HNOG", "HNPM": "HNPM", "HNPMX": "HNPMX", "HNT": "HNT", "IST": "IST", "JDT": "JDT", "JST": "JST", "LHDT": "LHDT", "LHST": "LHST", "MDT": "MDT", "MESZ": "MESZ", "MEZ": "MEZ", "MST": "MST", "MYT": "MYT", "NZDT": "NZDT", "NZST": "NZST", "OESZ": "OESZ", "OEZ": "OEZ", "PDT": "PDT", "PST": "PST", "SAST": "SAST", "SGT": "SGT", "SRT": "SRT", "TMST": "TMST", "TMT": "TMT", "UYST": "UYST", "UYT": "UYT", "VET": "VET", "WARST": "WARST", "WART": "WART", "WAST": "WAST", "WAT": "WAT", "WESZ": "WESZ", "WEZ": "WEZ", "WIB": "WIB", "WIT": "WIT", "WITA": "WITA", "∅∅∅": "∅∅∅"},

			fnCardinalPluralRule:  fnCardinalPluralRule_6d6ec1478c59480bfd820f2a0c64a497,
			fnDecimal:             fnDecimal_a78485e7dd32c95f41af4e18420793bf,
			fnFmtAccounting:       fnFmtAccounting_6dd988d8f1a3fac3718e543933915046,
			fnFmtCurrency:         fnFmtCurrency_3398e8f49a5a712d32672f16a1ed2c57,
			fnFmtDateFull:         fnFmtDateFull_e5aac3b796a648ed7f4aaa501e4e3844,
			fnFmtDateLong:         fnFmtDateLong_506f643cda0514f66d873a9ea99bf639,
			fnFmtDateMedium:       fnFmtDateMedium_5e450105cccbc820e4514899ef73128f,
			fnFmtDateShort:        fnFmtDateShort_222c809496186523124eb16d6c474592,
			fnFmtNumber:           fnFmtNumber_ceab7ec754f7f75fd13d22457c77cbf9,
			fnFmtPercent:          fnFmtPercent_e53d7ec2cf4741b3601391772e4c83b0,
			fnFmtTimeFull:         fnFmtTimeFull_ebdf96de1e47f9043145564c500ef7dc,
			fnFmtTimeLong:         fnFmtTimeLong_987bec4676d3a5de4218e415e123649d,
			fnFmtTimeMedium:       fnFmtTimeMedium_b6f697552cd4965cd1195fe56dc87003,
			fnFmtTimeShort:        fnFmtTimeShort_8ffba4d1a2f04a0a6486853d76cf434b,
			fnGroup:               fnGroup_5c4b80a5ccdee81467241784ab8fcd56,
			fnLocale:              fnLocale_5a217059c67094defae82f249f55f4c5,
			fnMinus:               fnMinus_8b8229905258388dc16a5e0c270b0488,
			fnMonthAbbreviated:    fnMonthAbbreviated_aa9a9957cd9d056ba078b36a08b17478,
			fnMonthNarrow:         fnMonthNarrow_45916040ecf6fc350894d9e3e6c46dc7,
			fnMonthWide:           fnMonthWide_4c946a7e7581c665e7407df1841810b5,
			fnMonthsAbbreviated:   fnMonthsAbbreviated_181f77804b62232997fae36bd57d6cf7,
			fnMonthsNarrow:        fnMonthsNarrow_75daa2ba82ae9577292175c3f52370cc,
			fnMonthsWide:          fnMonthsWide_0ecf36a8b72255e2fee9467af362e989,
			fnOrdinalPluralRule:   fnOrdinalPluralRule_a0e5467912a746c396065750c68e4318,
			fnPluralsCardinal:     fnPluralsCardinal_85b19cac1fab9f2c2cfb9eb41539aa0e,
			fnPluralsOrdinal:      fnPluralsOrdinal_16a60aa09da9778fa82fe463e83076de,
			fnPluralsRange:        fnPluralsRange_332465bda13eb808b3664fa0500f54ce,
			fnRangePluralRule:     fnRangePluralRule_e0f62e2cf3ae7407fb4b54d084341c0b,
			fnWeekdayAbbreviated:  fnWeekdayAbbreviated_4ffbdfbd2be10e6bd8fb5a542a14664a,
			fnWeekdayNarrow:       fnWeekdayNarrow_e86921b3446df5ea9afe9504cfa20d1a,
			fnWeekdayShort:        fnWeekdayShort_82b231d4f504c6d71c7e495aa35cd3c2,
			fnWeekdayWide:         fnWeekdayWide_ab7e026d8685cefd89c5aeb5df512a9a,
			fnWeekdaysAbbreviated: fnWeekdaysAbbreviated_454a3d7d23c662520a64ae5245d404be,
			fnWeekdaysNarrow:      fnWeekdaysNarrow_d23eb0b7a498c40ce19d1bf231cad524,
			fnWeekdaysShort:       fnWeekdaysShort_eb6ee64d01e314991432b4469790d38b,
			fnWeekdaysWide:        fnWeekdaysWide_5e2bbf75a31e730429c100e8a0bd3ebd,
		}
	}
	translatorFuncs["be"] = func() locales.Translator {
		return &localen{

			locale:                 "be",
			pluralsCardinal:        []locales.PluralRule{2, 4, 5, 6},
			pluralsOrdinal:         []locales.PluralRule{4, 6},
			pluralsRange:           []locales.PluralRule{2, 4, 5, 6},
			decimal:                ",",
			group:                  " ",
			minus:                  "-",
			percent:                "%",
			perMille:               "‰",
			timeSeparator:          ":",
			inifinity:              "∞",
			currencies:             []string{"ADP", "AED", "AFA", "AFN", "ALK", "ALL", "AMD", "ANG", "AOA", "AOK", "AON", "AOR", "ARA", "ARL", "ARM", "ARP", "ARS", "ATS", "A$", "AWG", "AZM", "AZN", "BAD", "BAM", "BAN", "BBD", "BDT", "BEC", "BEF", "BEL", "BGL", "BGM", "BGN", "BGO", "BHD", "BIF", "BMD", "BND", "BOB", "BOL", "BOP", "BOV", "BRB", "BRC", "BRE", "BRL", "BRN", "BRR", "BRZ", "BSD", "BTN", "BUK", "BWP", "BYB", "Br", "BYR", "BZD", "CAD", "CDF", "CHE", "CHF", "CHW", "CLE", "CLF", "CLP", "CNH", "CNX", "CN¥", "COP", "COU", "CRC", "CSD", "CSK", "CUC", "CUP", "CVE", "CYP", "CZK", "DDM", "DEM", "DJF", "DKK", "DOP", "DZD", "ECS", "ECV", "EEK", "EGP", "ERN", "ESA", "ESB", "ESP", "ETB", "€", "FIM", "FJD", "FKP", "FRF", "£", "GEK", "GEL", "GHC", "GHS", "GIP", "GMD", "GNF", "GNS", "GQE", "GRD", "GTQ", "GWE", "GWP", "GYD", "HK$", "HNL", "HRD", "HRK", "HTG", "HUF", "IDR", "IEP", "ILP", "ILR", "₪", "₹", "IQD", "IRR", "ISJ", "ISK", "ITL", "JMD", "JOD", "¥", "KES", "KGS", "KHR", "KMF", "KPW", "KRH", "KRO", "₩", "KWD", "KYD", "KZT", "LAK", "LBP", "LKR", "LRD", "LSL", "LTL", "LTT", "LUC", "LUF", "LUL", "LVL", "LVR", "LYD", "MAD", "MAF", "MCF", "MDC", "MDL", "MGA", "MGF", "MKD", "MKN", "MLF", "MMK", "MNT", "MOP", "MRO", "MRU", "MTL", "MTP", "MUR", "MVP", "MVR", "MWK", "MX$", "MXP", "MXV", "MYR", "MZE", "MZM", "MZN", "NAD", "NGN", "NIC", "NIO", "NLG", "NOK", "NPR", "NZD", "OMR", "PAB", "PEI", "PEN", "PES", "PGK", "PHP", "PKR", "PLN", "PLZ", "PTE", "PYG", "QAR", "RHD", "ROL", "RON", "RSD", "₽", "RUR", "RWF", "SAR", "SBD", "SCR", "SDD", "SDG", "SDP", "SEK", "SGD", "SHP", "SIT", "SKK", "SLL", "SOS", "SRD", "SRG", "SSP", "STD", "STN", "SUR", "SVC", "SYP", "SZL", "THB", "TJR", "TJS", "TMM", "TMT", "TND", "TOP", "TPE", "TRL", "TRY", "TTD", "NT$", "TZS", "UAH", "UAK", "UGS", "UGX", "$", "USN", "USS", "UYI", "UYP", "UYU", "UYW", "UZS", "VEB", "VEF", "VES", "₫", "VNN", "VUV", "WST", "FCFA", "XAG", "XAU", "XBA", "XBB", "XBC", "XBD", "EC$", "XDR", "XEU", "XFO", "XFU", "CFA", "XPD", "CFPF", "XPT", "XRE", "XSU", "XTS", "XUA", "XXX", "YDD", "YER", "YUD", "YUM", "YUN", "YUR", "ZAL", "ZAR", "ZMK", "ZMW", "ZRN", "ZRZ", "ZWD", "ZWL", "ZWR"},
			percentSuffix:          " ",
			currencyPositiveSuffix: " ",
			currencyNegativeSuffix: " ",
			monthsAbbreviated:      []string{"", "сту", "лют", "сак", "кра", "мая", "чэр", "ліп", "жні", "вер", "кас", "ліс", "сне"},
			monthsNarrow:           []string{"", "с", "л", "с", "к", "м", "ч", "л", "ж", "в", "к", "л", "с"},
			monthsWide:             []string{"", "студзеня", "лютага", "сакавіка", "красавіка", "мая", "чэрвеня", "ліпеня", "жніўня", "верасня", "кастрычніка", "лістапада", "снежня"},
			daysAbbreviated:        []string{"нд", "пн", "аў", "ср", "чц", "пт", "сб"},
			daysNarrow:             []string{"н", "п", "а", "с", "ч", "п", "с"},
			daysShort:              []string{"нд", "пн", "аў", "ср", "чц", "пт", "сб"},
			daysWide:               []string{"нядзеля", "панядзелак", "аўторак", "серада", "чацвер", "пятніца", "субота"},
			periodsAbbreviated:     []string{"AM", "PM"},
			periodsNarrow:          []string{"am", "pm"},
			periodsWide:            []string{"AM", "PM"},
			erasAbbreviated:        []string{"да н.э.", "н.э."},
			erasNarrow:             []string{"", ""},
			erasWide:               []string{"да нараджэння Хрыстова", "ад нараджэння Хрыстова"},
			timezones:              map[string]string{"ACDT": "Летні час цэнтральнай Аўстраліі", "ACST": "Стандартны час цэнтральнай Аўстраліі", "ACWDT": "Летні цэнтральна-заходні час Аўстраліі", "ACWST": "Стандартны цэнтральна-заходні час Аўстраліі", "ADT": "Атлантычны летні час", "AEDT": "Летні час усходняй Аўстраліі", "AEST": "Стандартны час усходняй Аўстраліі", "AKDT": "Летні час Аляскі", "AKST": "Стандартны час Аляскі", "ARST": "Аргенцінскі летні час", "ART": "Аргенцінскі стандартны час", "AST": "Атлантычны стандартны час", "AWDT": "Летні час заходняй Аўстраліі", "AWST": "Стандартны час заходняй Аўстраліі", "BOT": "Балівійскі час", "BT": "Час Бутана", "CAT": "Цэнтральнаафрыканскі час", "CDT": "Паўночнаамерыканскі цэнтральны летні час", "CHADT": "Летні час Чатэма", "CHAST": "Стандартны час Чатэма", "CLST": "Чылійскі летні час", "CLT": "Чылійскі стандартны час", "COST": "Калумбійскі летні час", "COT": "Калумбійскі стандартны час", "CST": "Паўночнаамерыканскі цэнтральны стандартны час", "ChST": "Час Чамора", "EAT": "Усходнеафрыканскі час", "ECT": "Эквадорскі час", "EDT": "Паўночнаамерыканскі ўсходні летні час", "EST": "Паўночнаамерыканскі ўсходні стандартны час", "GFT": "Час Французскай Гвіяны", "GMT": "Час па Грынвічы", "GST": "Час Персідскага заліва", "GYT": "Час Гаяны", "HADT": "Гавайска-Алеуцкі летні час", "HAST": "Гавайска-Алеуцкі стандартны час", "HAT": "Ньюфаўндлендскі летні час", "HECU": "Летні час Кубы", "HEEG": "Летні час Усходняй Грэнландыі", "HENOMX": "Паўночна-заходні мексіканскі летні час", "HEOG": "Летні час Заходняй Грэнландыі", "HEPM": "Стандартны летні час Сен-П’ер і Мікелон", "HEPMX": "Мексіканскі ціхаакіянскі летні час", "HKST": "Летні час Ганконга", "HKT": "Стандартны час Ганконга", "HNCU": "Стандартны час Кубы", "HNEG": "Стандартны час Усходняй Грэнландыі", "HNNOMX": "Паўночна-заходні мексіканскі стандартны час", "HNOG": "Стандартны час Заходняй Грэнландыі", "HNPM": "Стандартны час Сен-П’ер і Мікелон", "HNPMX": "Мексіканскі ціхаакіянскі стандатны час", "HNT": "Ньюфаўндлендскі стандартны час", "IST": "Час Індыі", "JDT": "Летні час Японіі", "JST": "Стандартны час Японіі", "LHDT": "Летні час Лорд-Хау", "LHST": "Стандартны час Лорд-Хау", "MDT": "Паўночнаамерыканскі горны летні час", "MESZ": "Цэнтральнаеўрапейскі летні час", "MEZ": "Цэнтральнаеўрапейскі стандартны час", "MST": "Паўночнаамерыканскі горны стандартны час", "MYT": "Час Малайзіі", "NZDT": "Летні час Новай Зеландыі", "NZST": "Стандартны час Новай Зеландыі", "OESZ": "Усходнееўрапейскі летні час", "OEZ": "Усходнееўрапейскі стандартны час", "PDT": "Ціхаакіянскі летні час", "PST": "Ціхаакіянскі стандартны час", "SAST": "Паўднёваафрыканскі час", "SGT": "Сінгапурскі час", "SRT": "Час Сурынама", "TMST": "Летні час Туркменістана", "TMT": "Стандартны час Туркменістана", "UYST": "Уругвайскі летні час", "UYT": "Уругвайскі стандартны час", "VET": "Венесуэльскі час", "WARST": "Летні час Заходняй Аргенціны", "WART": "Стандартны час Заходняй Аргенціны", "WAST": "Заходнеафрыканскі летні час", "WAT": "Заходнеафрыканскі стандартны час", "WESZ": "Заходнееўрапейскі летні час", "WEZ": "Заходнееўрапейскі стандартны час", "WIB": "Заходнеінданезійскі час", "WIT": "Усходнеінданезійскі час", "WITA": "Цэнтральнаінданезійскі час", "∅∅∅": "Бразільскі летні час"},

			fnCardinalPluralRule:  fnCardinalPluralRule_aa3706fccbfeb0fac3cf81d326e3fe96,
			fnDecimal:             fnDecimal_a78485e7dd32c95f41af4e18420793bf,
			fnFmtAccounting:       fnFmtAccounting_a62648328d65f4275e2e521198233607,
			fnFmtCurrency:         fnFmtCurrency_04d2836e8ee5922750958599d99ccc13,
			fnFmtDateFull:         fnFmtDateFull_3bb9a5fb6d982f44bb197fafb3f68087,
			fnFmtDateLong:         fnFmtDateLong_b673377c923e43f185728d5b63716bee,
			fnFmtDateMedium:       fnFmtDateMedium_73098a578f62c763b1a46cfb742142e3,
			fnFmtDateShort:        fnFmtDateShort_cbdb981782261e5a8b8cc19702400c64,
			fnFmtNumber:           fnFmtNumber_0866206624669dc4f03297eb76a545b2,
			fnFmtPercent:          fnFmtPercent_fcc1fa1bb5725d058e89da9d97be1c70,
			fnFmtTimeFull:         fnFmtTimeFull_d302f6108a9d3f4bb461f3a5111143e5,
			fnFmtTimeLong:         fnFmtTimeLong_987bec4676d3a5de4218e415e123649d,
			fnFmtTimeMedium:       fnFmtTimeMedium_b6f697552cd4965cd1195fe56dc87003,
			fnFmtTimeShort:        fnFmtTimeShort_8ffba4d1a2f04a0a6486853d76cf434b,
			fnGroup:               fnGroup_5c4b80a5ccdee81467241784ab8fcd56,
			fnLocale:              fnLocale_5a217059c67094defae82f249f55f4c5,
			fnMinus:               fnMinus_8b8229905258388dc16a5e0c270b0488,
			fnMonthAbbreviated:    fnMonthAbbreviated_aa9a9957cd9d056ba078b36a08b17478,
			fnMonthNarrow:         fnMonthNarrow_45916040ecf6fc350894d9e3e6c46dc7,
			fnMonthWide:           fnMonthWide_4c946a7e7581c665e7407df1841810b5,
			fnMonthsAbbreviated:   fnMonthsAbbreviated_181f77804b62232997fae36bd57d6cf7,
			fnMonthsNarrow:        fnMonthsNarrow_75daa2ba82ae9577292175c3f52370cc,
			fnMonthsWide:          fnMonthsWide_0ecf36a8b72255e2fee9467af362e989,
			fnOrdinalPluralRule:   fnOrdinalPluralRule_62ca292db3807cd1a19e61d6d993a0d9,
			fnPluralsCardinal:     fnPluralsCardinal_85b19cac1fab9f2c2cfb9eb41539aa0e,
			fnPluralsOrdinal:      fnPluralsOrdinal_16a60aa09da9778fa82fe463e83076de,
			fnPluralsRange:        fnPluralsRange_332465bda13eb808b3664fa0500f54ce,
			fnRangePluralRule:     fnRangePluralRule_52e3998ab91a02eab3b89e4e5a856fb5,
			fnWeekdayAbbreviated:  fnWeekdayAbbreviated_4ffbdfbd2be10e6bd8fb5a542a14664a,
			fnWeekdayNarrow:       fnWeekdayNarrow_e86921b3446df5ea9afe9504cfa20d1a,
			fnWeekdayShort:        fnWeekdayShort_82b231d4f504c6d71c7e495aa35cd3c2,
			fnWeekdayWide:         fnWeekdayWide_ab7e026d8685cefd89c5aeb5df512a9a,
			fnWeekdaysAbbreviated: fnWeekdaysAbbreviated_454a3d7d23c662520a64ae5245d404be,
			fnWeekdaysNarrow:      fnWeekdaysNarrow_d23eb0b7a498c40ce19d1bf231cad524,
			fnWeekdaysShort:       fnWeekdaysShort_eb6ee64d01e314991432b4469790d38b,
			fnWeekdaysWide:        fnWeekdaysWide_5e2bbf75a31e730429c100e8a0bd3ebd,
		}
	}
	translatorFuncs["be_by"] = func() locales.Translator {
		return &localen{

			locale:                 "be_BY",
			pluralsCardinal:        []locales.PluralRule{2, 4, 5, 6},
			pluralsOrdinal:         []locales.PluralRule{4, 6},
			pluralsRange:           []locales.PluralRule{2, 4, 5, 6},
			decimal:                ",",
			group:                  " ",
			minus:                  "-",
			percent:                "%",
			perMille:               "‰",
			timeSeparator:          ":",
			inifinity:              "∞",
			currencies:             []string{"ADP", "AED", "AFA", "AFN", "ALK", "ALL", "AMD", "ANG", "AOA", "AOK", "AON", "AOR", "ARA", "ARL", "ARM", "ARP", "ARS", "ATS", "AUD", "AWG", "AZM", "AZN", "BAD", "BAM", "BAN", "BBD", "BDT", "BEC", "BEF", "BEL", "BGL", "BGM", "BGN", "BGO", "BHD", "BIF", "BMD", "BND", "BOB", "BOL", "BOP", "BOV", "BRB", "BRC", "BRE", "BRL", "BRN", "BRR", "BRZ", "BSD", "BTN", "BUK", "BWP", "BYB", "BYN", "BYR", "BZD", "CAD", "CDF", "CHE", "CHF", "CHW", "CLE", "CLF", "CLP", "CNH", "CNX", "CNY", "COP", "COU", "CRC", "CSD", "CSK", "CUC", "CUP", "CVE", "CYP", "CZK", "DDM", "DEM", "DJF", "DKK", "DOP", "DZD", "ECS", "ECV", "EEK", "EGP", "ERN", "ESA", "ESB", "ESP", "ETB", "EUR", "FIM", "FJD", "FKP", "FRF", "GBP", "GEK", "GEL", "GHC", "GHS", "GIP", "GMD", "GNF", "GNS", "GQE", "GRD", "GTQ", "GWE", "GWP", "GYD", "HKD", "HNL", "HRD", "HRK", "HTG", "HUF", "IDR", "IEP", "ILP", "ILR", "ILS", "INR", "IQD", "IRR", "ISJ", "ISK", "ITL", "JMD", "JOD", "JPY", "KES", "KGS", "KHR", "KMF", "KPW", "KRH", "KRO", "KRW", "KWD", "KYD", "KZT", "LAK", "LBP", "LKR", "LRD", "LSL", "LTL", "LTT", "LUC", "LUF", "LUL", "LVL", "LVR", "LYD", "MAD", "MAF", "MCF", "MDC", "MDL", "MGA", "MGF", "MKD", "MKN", "MLF", "MMK", "MNT", "MOP", "MRO", "MRU", "MTL", "MTP", "MUR", "MVP", "MVR", "MWK", "MXN", "MXP", "MXV", "MYR", "MZE", "MZM", "MZN", "NAD", "NGN", "NIC", "NIO", "NLG", "NOK", "NPR", "NZD", "OMR", "PAB", "PEI", "PEN", "PES", "PGK", "PHP", "PKR", "PLN", "PLZ", "PTE", "PYG", "QAR", "RHD", "ROL", "RON", "RSD", "RUB", "RUR", "RWF", "SAR", "SBD", "SCR", "SDD", "SDG", "SDP", "SEK", "SGD", "SHP", "SIT", "SKK", "SLL", "SOS", "SRD", "SRG", "SSP", "STD", "STN", "SUR", "SVC", "SYP", "SZL", "THB", "TJR", "TJS", "TMM", "TMT", "TND", "TOP", "TPE", "TRL", "TRY", "TTD", "TWD", "TZS", "UAH", "UAK", "UGS", "UGX", "USD", "USN", "USS", "UYI", "UYP", "UYU", "UYW", "UZS", "VEB", "VEF", "VES", "VND", "VNN", "VUV", "WST", "XAF", "XAG", "XAU", "XBA", "XBB", "XBC", "XBD", "XCD", "XDR", "XEU", "XFO", "XFU", "XOF", "XPD", "XPF", "XPT", "XRE", "XSU", "XTS", "XUA", "XXX", "YDD", "YER", "YUD", "YUM", "YUN", "YUR", "ZAL", "ZAR", "ZMK", "ZMW", "ZRN", "ZRZ", "ZWD", "ZWL", "ZWR"},
			percentSuffix:          " ",
			currencyPositiveSuffix: " ",
			currencyNegativeSuffix: " ",
			monthsAbbreviated:      []string{"", "сту", "лют", "сак", "кра", "мая", "чэр", "ліп", "жні", "вер", "кас", "ліс", "сне"},
			monthsNarrow:           []string{"", "с", "л", "с", "к", "м", "ч", "л", "ж", "в", "к", "л", "с"},
			monthsWide:             []string{"", "студзеня", "лютага", "сакавіка", "красавіка", "мая", "чэрвеня", "ліпеня", "жніўня", "верасня", "кастрычніка", "лістапада", "снежня"},
			daysAbbreviated:        []string{"нд", "пн", "аў", "ср", "чц", "пт", "сб"},
			daysNarrow:             []string{"н", "п", "а", "с", "ч", "п", "с"},
			daysShort:              []string{"нд", "пн", "аў", "ср", "чц", "пт", "сб"},
			daysWide:               []string{"нядзеля", "панядзелак", "аўторак", "серада", "чацвер", "пятніца", "субота"},
			periodsAbbreviated:     []string{"AM", "PM"},
			periodsNarrow:          []string{"am", "pm"},
			periodsWide:            []string{"AM", "PM"},
			erasAbbreviated:        []string{"да н.э.", "н.э."},
			erasNarrow:             []string{"", ""},
			erasWide:               []string{"да нараджэння Хрыстова", "ад нараджэння Хрыстова"},
			timezones:              map[string]string{"ACDT": "Летні час цэнтральнай Аўстраліі", "ACST": "Стандартны час цэнтральнай Аўстраліі", "ACWDT": "Летні цэнтральна-заходні час Аўстраліі", "ACWST": "Стандартны цэнтральна-заходні час Аўстраліі", "ADT": "Атлантычны летні час", "AEDT": "Летні час усходняй Аўстраліі", "AEST": "Стандартны час усходняй Аўстраліі", "AKDT": "Летні час Аляскі", "AKST": "Стандартны час Аляскі", "ARST": "Аргенцінскі летні час", "ART": "Аргенцінскі стандартны час", "AST": "Атлантычны стандартны час", "AWDT": "Летні час заходняй Аўстраліі", "AWST": "Стандартны час заходняй Аўстраліі", "BOT": "Балівійскі час", "BT": "Час Бутана", "CAT": "Цэнтральнаафрыканскі час", "CDT": "Паўночнаамерыканскі цэнтральны летні час", "CHADT": "Летні час Чатэма", "CHAST": "Стандартны час Чатэма", "CLST": "Чылійскі летні час", "CLT": "Чылійскі стандартны час", "COST": "Калумбійскі летні час", "COT": "Калумбійскі стандартны час", "CST": "Паўночнаамерыканскі цэнтральны стандартны час", "ChST": "Час Чамора", "EAT": "Усходнеафрыканскі час", "ECT": "Эквадорскі час", "EDT": "Паўночнаамерыканскі ўсходні летні час", "EST": "Паўночнаамерыканскі ўсходні стандартны час", "GFT": "Час Французскай Гвіяны", "GMT": "Час па Грынвічы", "GST": "Час Персідскага заліва", "GYT": "Час Гаяны", "HADT": "Гавайска-Алеуцкі летні час", "HAST": "Гавайска-Алеуцкі стандартны час", "HAT": "Ньюфаўндлендскі летні час", "HECU": "Летні час Кубы", "HEEG": "Летні час Усходняй Грэнландыі", "HENOMX": "Паўночна-заходні мексіканскі летні час", "HEOG": "Летні час Заходняй Грэнландыі", "HEPM": "Стандартны летні час Сен-П’ер і Мікелон", "HEPMX": "Мексіканскі ціхаакіянскі летні час", "HKST": "Летні час Ганконга", "HKT": "Стандартны час Ганконга", "HNCU": "Стандартны час Кубы", "HNEG": "Стандартны час Усходняй Грэнландыі", "HNNOMX": "Паўночна-заходні мексіканскі стандартны час", "HNOG": "Стандартны час Заходняй Грэнландыі", "HNPM": "Стандартны час Сен-П’ер і Мікелон", "HNPMX": "Мексіканскі ціхаакіянскі стандатны час", "HNT": "Ньюфаўндлендскі стандартны час", "IST": "Час Індыі", "JDT": "Летні час Японіі", "JST": "Стандартны час Японіі", "LHDT": "Летні час Лорд-Хау", "LHST": "Стандартны час Лорд-Хау", "MDT": "Паўночнаамерыканскі горны летні час", "MESZ": "Цэнтральнаеўрапейскі летні час", "MEZ": "Цэнтральнаеўрапейскі стандартны час", "MST": "Паўночнаамерыканскі горны стандартны час", "MYT": "Час Малайзіі", "NZDT": "Летні час Новай Зеландыі", "NZST": "Стандартны час Новай Зеландыі", "OESZ": "Усходнееўрапейскі летні час", "OEZ": "Усходнееўрапейскі стандартны час", "PDT": "Ціхаакіянскі летні час", "PST": "Ціхаакіянскі стандартны час", "SAST": "Паўднёваафрыканскі час", "SGT": "Сінгапурскі час", "SRT": "Час Сурынама", "TMST": "Летні час Туркменістана", "TMT": "Стандартны час Туркменістана", "UYST": "Уругвайскі летні час", "UYT": "Уругвайскі стандартны час", "VET": "Венесуэльскі час", "WARST": "Летні час Заходняй Аргенціны", "WART": "Стандартны час Заходняй Аргенціны", "WAST": "Заходнеафрыканскі летні час", "WAT": "Заходнеафрыканскі стандартны час", "WESZ": "Заходнееўрапейскі летні час", "WEZ": "Заходнееўрапейскі стандартны час", "WIB": "Заходнеінданезійскі час", "WIT": "Усходнеінданезійскі час", "WITA": "Цэнтральнаінданезійскі час", "∅∅∅": "Бразільскі летні час"},

			fnCardinalPluralRule:  fnCardinalPluralRule_aa3706fccbfeb0fac3cf81d326e3fe96,
			fnDecimal:             fnDecimal_a78485e7dd32c95f41af4e18420793bf,
			fnFmtAccounting:       fnFmtAccounting_a62648328d65f4275e2e521198233607,
			fnFmtCurrency:         fnFmtCurrency_04d2836e8ee5922750958599d99ccc13,
			fnFmtDateFull:         fnFmtDateFull_3bb9a5fb6d982f44bb197fafb3f68087,
			fnFmtDateLong:         fnFmtDateLong_b673377c923e43f185728d5b63716bee,
			fnFmtDateMedium:       fnFmtDateMedium_73098a578f62c763b1a46cfb742142e3,
			fnFmtDateShort:        fnFmtDateShort_cbdb981782261e5a8b8cc19702400c64,
			fnFmtNumber:           fnFmtNumber_0866206624669dc4f03297eb76a545b2,
			fnFmtPercent:          fnFmtPercent_fcc1fa1bb5725d058e89da9d97be1c70,
			fnFmtTimeFull:         fnFmtTimeFull_d302f6108a9d3f4bb461f3a5111143e5,
			fnFmtTimeLong:         fnFmtTimeLong_987bec4676d3a5de4218e415e123649d,
			fnFmtTimeMedium:       fnFmtTimeMedium_b6f697552cd4965cd1195fe56dc87003,
			fnFmtTimeShort:        fnFmtTimeShort_8ffba4d1a2f04a0a6486853d76cf434b,
			fnGroup:               fnGroup_5c4b80a5ccdee81467241784ab8fcd56,
			fnLocale:              fnLocale_5a217059c67094defae82f249f55f4c5,
			fnMinus:               fnMinus_8b8229905258388dc16a5e0c270b0488,
			fnMonthAbbreviated:    fnMonthAbbreviated_aa9a9957cd9d056ba078b36a08b17478,
			fnMonthNarrow:         fnMonthNarrow_45916040ecf6fc350894d9e3e6c46dc7,
			fnMonthWide:           fnMonthWide_4c946a7e7581c665e7407df1841810b5,
			fnMonthsAbbreviated:   fnMonthsAbbreviated_181f77804b62232997fae36bd57d6cf7,
			fnMonthsNarrow:        fnMonthsNarrow_75daa2ba82ae9577292175c3f52370cc,
			fnMonthsWide:          fnMonthsWide_0ecf36a8b72255e2fee9467af362e989,
			fnOrdinalPluralRule:   fnOrdinalPluralRule_62ca292db3807cd1a19e61d6d993a0d9,
			fnPluralsCardinal:     fnPluralsCardinal_85b19cac1fab9f2c2cfb9eb41539aa0e,
			fnPluralsOrdinal:      fnPluralsOrdinal_16a60aa09da9778fa82fe463e83076de,
			fnPluralsRange:        fnPluralsRange_332465bda13eb808b3664fa0500f54ce,
			fnRangePluralRule:     fnRangePluralRule_52e3998ab91a02eab3b89e4e5a856fb5,
			fnWeekdayAbbreviated:  fnWeekdayAbbreviated_4ffbdfbd2be10e6bd8fb5a542a14664a,
			fnWeekdayNarrow:       fnWeekdayNarrow_e86921b3446df5ea9afe9504cfa20d1a,
			fnWeekdayShort:        fnWeekdayShort_82b231d4f504c6d71c7e495aa35cd3c2,
			fnWeekdayWide:         fnWeekdayWide_ab7e026d8685cefd89c5aeb5df512a9a,
			fnWeekdaysAbbreviated: fnWeekdaysAbbreviated_454a3d7d23c662520a64ae5245d404be,
			fnWeekdaysNarrow:      fnWeekdaysNarrow_d23eb0b7a498c40ce19d1bf231cad524,
			fnWeekdaysShort:       fnWeekdaysShort_eb6ee64d01e314991432b4469790d38b,
			fnWeekdaysWide:        fnWeekdaysWide_5e2bbf75a31e730429c100e8a0bd3ebd,
		}
	}
	translatorFuncs["bem"] = func() locales.Translator {
		return &localen{

			locale:                 "bem",
			pluralsCardinal:        []locales.PluralRule{2, 6},
			pluralsOrdinal:         nil,
			pluralsRange:           nil,
			timeSeparator:          ":",
			currencies:             []string{"ADP", "AED", "AFA", "AFN", "ALK", "ALL", "AMD", "ANG", "AOA", "AOK", "AON", "AOR", "ARA", "ARL", "ARM", "ARP", "ARS", "ATS", "AUD", "AWG", "AZM", "AZN", "BAD", "BAM", "BAN", "BBD", "BDT", "BEC", "BEF", "BEL", "BGL", "BGM", "BGN", "BGO", "BHD", "BIF", "BMD", "BND", "BOB", "BOL", "BOP", "BOV", "BRB", "BRC", "BRE", "BRL", "BRN", "BRR", "BRZ", "BSD", "BTN", "BUK", "BWP", "BYB", "BYN", "BYR", "BZD", "CAD", "CDF", "CHE", "CHF", "CHW", "CLE", "CLF", "CLP", "CNH", "CNX", "CNY", "COP", "COU", "CRC", "CSD", "CSK", "CUC", "CUP", "CVE", "CYP", "CZK", "DDM", "DEM", "DJF", "DKK", "DOP", "DZD", "ECS", "ECV", "EEK", "EGP", "ERN", "ESA", "ESB", "ESP", "ETB", "EUR", "FIM", "FJD", "FKP", "FRF", "GBP", "GEK", "GEL", "GHC", "GHS", "GIP", "GMD", "GNF", "GNS", "GQE", "GRD", "GTQ", "GWE", "GWP", "GYD", "HKD", "HNL", "HRD", "HRK", "HTG", "HUF", "IDR", "IEP", "ILP", "ILR", "ILS", "INR", "IQD", "IRR", "ISJ", "ISK", "ITL", "JMD", "JOD", "JPY", "KES", "KGS", "KHR", "KMF", "KPW", "KRH", "KRO", "KRW", "KWD", "KYD", "KZT", "LAK", "LBP", "LKR", "LRD", "LSL", "LTL", "LTT", "LUC", "LUF", "LUL", "LVL", "LVR", "LYD", "MAD", "MAF", "MCF", "MDC", "MDL", "MGA", "MGF", "MKD", "MKN", "MLF", "MMK", "MNT", "MOP", "MRO", "MRU", "MTL", "MTP", "MUR", "MVP", "MVR", "MWK", "MXN", "MXP", "MXV", "MYR", "MZE", "MZM", "MZN", "NAD", "NGN", "NIC", "NIO", "NLG", "NOK", "NPR", "NZD", "OMR", "PAB", "PEI", "PEN", "PES", "PGK", "PHP", "PKR", "PLN", "PLZ", "PTE", "PYG", "QAR", "RHD", "ROL", "RON", "RSD", "RUB", "RUR", "RWF", "SAR", "SBD", "SCR", "SDD", "SDG", "SDP", "SEK", "SGD", "SHP", "SIT", "SKK", "SLL", "SOS", "SRD", "SRG", "SSP", "STD", "STN", "SUR", "SVC", "SYP", "SZL", "THB", "TJR", "TJS", "TMM", "TMT", "TND", "TOP", "TPE", "TRL", "TRY", "TTD", "TWD", "TZS", "UAH", "UAK", "UGS", "UGX", "USD", "USN", "USS", "UYI", "UYP", "UYU", "UYW", "UZS", "VEB", "VEF", "VES", "VND", "VNN", "VUV", "WST", "XAF", "XAG", "XAU", "XBA", "XBB", "XBC", "XBD", "XCD", "XDR", "XEU", "XFO", "XFU", "XOF", "XPD", "XPF", "XPT", "XRE", "XSU", "XTS", "XUA", "XXX", "YDD", "YER", "YUD", "YUM", "YUN", "YUR", "ZAL", "ZAR", "ZMK", "K", "ZRN", "ZRZ", "ZWD", "ZWL", "ZWR"},
			currencyNegativePrefix: "(",
			currencyNegativeSuffix: ")",
			monthsAbbreviated:      []string{"", "Jan", "Feb", "Mac", "Epr", "Mei", "Jun", "Jul", "Oga", "Sep", "Okt", "Nov", "Dis"},
			monthsNarrow:           []string{"", "J", "F", "M", "E", "M", "J", "J", "O", "S", "O", "N", "D"},
			monthsWide:             []string{"", "Januari", "Februari", "Machi", "Epreo", "Mei", "Juni", "Julai", "Ogasti", "Septemba", "Oktoba", "Novemba", "Disemba"},
			daysWide:               []string{"Pa Mulungu", "Palichimo", "Palichibuli", "Palichitatu", "Palichine", "Palichisano", "Pachibelushi"},
			periodsAbbreviated:     []string{"uluchelo", "akasuba"},
			periodsWide:            []string{"uluchelo", "akasuba"},
			erasAbbreviated:        []string{"BC", "AD"},
			erasNarrow:             []string{"", ""},
			erasWide:               []string{"Before Yesu", "After Yesu"},
			timezones:              map[string]string{"ACDT": "ACDT", "ACST": "ACST", "ACWDT": "ACWDT", "ACWST": "ACWST", "ADT": "ADT", "AEDT": "AEDT", "AEST": "AEST", "AKDT": "AKDT", "AKST": "AKST", "ARST": "ARST", "ART": "ART", "AST": "AST", "AWDT": "AWDT", "AWST": "AWST", "BOT": "BOT", "BT": "BT", "CAT": "CAT", "CDT": "CDT", "CHADT": "CHADT", "CHAST": "CHAST", "CLST": "CLST", "CLT": "CLT", "COST": "COST", "COT": "COT", "CST": "CST", "ChST": "ChST", "EAT": "EAT", "ECT": "ECT", "EDT": "EDT", "EST": "EST", "GFT": "GFT", "GMT": "GMT", "GST": "GST", "GYT": "GYT", "HADT": "HADT", "HAST": "HAST", "HAT": "HAT", "HECU": "HECU", "HEEG": "HEEG", "HENOMX": "HENOMX", "HEOG": "HEOG", "HEPM": "HEPM", "HEPMX": "HEPMX", "HKST": "HKST", "HKT": "HKT", "HNCU": "HNCU", "HNEG": "HNEG", "HNNOMX": "HNNOMX", "HNOG": "HNOG", "HNPM": "HNPM", "HNPMX": "HNPMX", "HNT": "HNT", "IST": "IST", "JDT": "JDT", "JST": "JST", "LHDT": "LHDT", "LHST": "LHST", "MDT": "MDT", "MESZ": "MESZ", "MEZ": "MEZ", "MST": "MST", "MYT": "MYT", "NZDT": "NZDT", "NZST": "NZST", "OESZ": "OESZ", "OEZ": "OEZ", "PDT": "PDT", "PST": "PST", "SAST": "SAST", "SGT": "SGT", "SRT": "SRT", "TMST": "TMST", "TMT": "TMT", "UYST": "UYST", "UYT": "UYT", "VET": "VET", "WARST": "WARST", "WART": "WART", "WAST": "WAST", "WAT": "WAT", "WESZ": "WESZ", "WEZ": "WEZ", "WIB": "WIB", "WIT": "WIT", "WITA": "WITA", "∅∅∅": "∅∅∅"},

			fnCardinalPluralRule:  fnCardinalPluralRule_0758171f702b5b6024bdf47d25d8166d,
			fnDecimal:             fnDecimal_a78485e7dd32c95f41af4e18420793bf,
			fnFmtAccounting:       fnFmtAccounting_60b3ba42c7301cf18f0e7795b3eeaa75,
			fnFmtCurrency:         fnFmtCurrency_12d8afad3eb872da9d80fb14637f7f61,
			fnFmtDateFull:         fnFmtDateFull_c568798c9683b61c27e1bae4ea10cb6b,
			fnFmtDateLong:         fnFmtDateLong_506f643cda0514f66d873a9ea99bf639,
			fnFmtDateMedium:       fnFmtDateMedium_cb43e8c32d5cd0a27ac6db293a7981fd,
			fnFmtDateShort:        fnFmtDateShort_529ba7a02bedd437d0833b1afdb768c8,
			fnFmtNumber:           fnFmtNumber_2816fdab36e719be095a370ff42e599f,
			fnFmtPercent:          fnFmtPercent_016773d83796aa19d80b7c33bf377883,
			fnFmtTimeFull:         fnFmtTimeFull_37fe4deeee789852cc196a6a1a2f0ccc,
			fnFmtTimeLong:         fnFmtTimeLong_4429ef4fb58a2a9c4d7d5132fd16ecbf,
			fnFmtTimeMedium:       fnFmtTimeMedium_8ef07f6477b7a4944577d4e5392ff21b,
			fnFmtTimeShort:        fnFmtTimeShort_8288b817c5c0216c9815524c71c9e0b4,
			fnGroup:               fnGroup_5c4b80a5ccdee81467241784ab8fcd56,
			fnLocale:              fnLocale_5a217059c67094defae82f249f55f4c5,
			fnMinus:               fnMinus_8b8229905258388dc16a5e0c270b0488,
			fnMonthAbbreviated:    fnMonthAbbreviated_aa9a9957cd9d056ba078b36a08b17478,
			fnMonthNarrow:         fnMonthNarrow_45916040ecf6fc350894d9e3e6c46dc7,
			fnMonthWide:           fnMonthWide_4c946a7e7581c665e7407df1841810b5,
			fnMonthsAbbreviated:   fnMonthsAbbreviated_181f77804b62232997fae36bd57d6cf7,
			fnMonthsNarrow:        fnMonthsNarrow_75daa2ba82ae9577292175c3f52370cc,
			fnMonthsWide:          fnMonthsWide_0ecf36a8b72255e2fee9467af362e989,
			fnOrdinalPluralRule:   fnOrdinalPluralRule_a0e5467912a746c396065750c68e4318,
			fnPluralsCardinal:     fnPluralsCardinal_85b19cac1fab9f2c2cfb9eb41539aa0e,
			fnPluralsOrdinal:      fnPluralsOrdinal_16a60aa09da9778fa82fe463e83076de,
			fnPluralsRange:        fnPluralsRange_332465bda13eb808b3664fa0500f54ce,
			fnRangePluralRule:     fnRangePluralRule_e0f62e2cf3ae7407fb4b54d084341c0b,
			fnWeekdayAbbreviated:  fnWeekdayAbbreviated_4ffbdfbd2be10e6bd8fb5a542a14664a,
			fnWeekdayNarrow:       fnWeekdayNarrow_e86921b3446df5ea9afe9504cfa20d1a,
			fnWeekdayShort:        fnWeekdayShort_82b231d4f504c6d71c7e495aa35cd3c2,
			fnWeekdayWide:         fnWeekdayWide_ab7e026d8685cefd89c5aeb5df512a9a,
			fnWeekdaysAbbreviated: fnWeekdaysAbbreviated_454a3d7d23c662520a64ae5245d404be,
			fnWeekdaysNarrow:      fnWeekdaysNarrow_d23eb0b7a498c40ce19d1bf231cad524,
			fnWeekdaysShort:       fnWeekdaysShort_eb6ee64d01e314991432b4469790d38b,
			fnWeekdaysWide:        fnWeekdaysWide_5e2bbf75a31e730429c100e8a0bd3ebd,
		}
	}
	translatorFuncs["bem_zm"] = func() locales.Translator {
		return &localen{

			locale:                 "bem_ZM",
			pluralsCardinal:        []locales.PluralRule{2, 6},
			pluralsOrdinal:         nil,
			pluralsRange:           nil,
			timeSeparator:          ":",
			currencies:             []string{"ADP", "AED", "AFA", "AFN", "ALK", "ALL", "AMD", "ANG", "AOA", "AOK", "AON", "AOR", "ARA", "ARL", "ARM", "ARP", "ARS", "ATS", "AUD", "AWG", "AZM", "AZN", "BAD", "BAM", "BAN", "BBD", "BDT", "BEC", "BEF", "BEL", "BGL", "BGM", "BGN", "BGO", "BHD", "BIF", "BMD", "BND", "BOB", "BOL", "BOP", "BOV", "BRB", "BRC", "BRE", "BRL", "BRN", "BRR", "BRZ", "BSD", "BTN", "BUK", "BWP", "BYB", "BYN", "BYR", "BZD", "CAD", "CDF", "CHE", "CHF", "CHW", "CLE", "CLF", "CLP", "CNH", "CNX", "CNY", "COP", "COU", "CRC", "CSD", "CSK", "CUC", "CUP", "CVE", "CYP", "CZK", "DDM", "DEM", "DJF", "DKK", "DOP", "DZD", "ECS", "ECV", "EEK", "EGP", "ERN", "ESA", "ESB", "ESP", "ETB", "EUR", "FIM", "FJD", "FKP", "FRF", "GBP", "GEK", "GEL", "GHC", "GHS", "GIP", "GMD", "GNF", "GNS", "GQE", "GRD", "GTQ", "GWE", "GWP", "GYD", "HKD", "HNL", "HRD", "HRK", "HTG", "HUF", "IDR", "IEP", "ILP", "ILR", "ILS", "INR", "IQD", "IRR", "ISJ", "ISK", "ITL", "JMD", "JOD", "JPY", "KES", "KGS", "KHR", "KMF", "KPW", "KRH", "KRO", "KRW", "KWD", "KYD", "KZT", "LAK", "LBP", "LKR", "LRD", "LSL", "LTL", "LTT", "LUC", "LUF", "LUL", "LVL", "LVR", "LYD", "MAD", "MAF", "MCF", "MDC", "MDL", "MGA", "MGF", "MKD", "MKN", "MLF", "MMK", "MNT", "MOP", "MRO", "MRU", "MTL", "MTP", "MUR", "MVP", "MVR", "MWK", "MXN", "MXP", "MXV", "MYR", "MZE", "MZM", "MZN", "NAD", "NGN", "NIC", "NIO", "NLG", "NOK", "NPR", "NZD", "OMR", "PAB", "PEI", "PEN", "PES", "PGK", "PHP", "PKR", "PLN", "PLZ", "PTE", "PYG", "QAR", "RHD", "ROL", "RON", "RSD", "RUB", "RUR", "RWF", "SAR", "SBD", "SCR", "SDD", "SDG", "SDP", "SEK", "SGD", "SHP", "SIT", "SKK", "SLL", "SOS", "SRD", "SRG", "SSP", "STD", "STN", "SUR", "SVC", "SYP", "SZL", "THB", "TJR", "TJS", "TMM", "TMT", "TND", "TOP", "TPE", "TRL", "TRY", "TTD", "TWD", "TZS", "UAH", "UAK", "UGS", "UGX", "USD", "USN", "USS", "UYI", "UYP", "UYU", "UYW", "UZS", "VEB", "VEF", "VES", "VND", "VNN", "VUV", "WST", "XAF", "XAG", "XAU", "XBA", "XBB", "XBC", "XBD", "XCD", "XDR", "XEU", "XFO", "XFU", "XOF", "XPD", "XPF", "XPT", "XRE", "XSU", "XTS", "XUA", "XXX", "YDD", "YER", "YUD", "YUM", "YUN", "YUR", "ZAL", "ZAR", "ZMK", "ZMW", "ZRN", "ZRZ", "ZWD", "ZWL", "ZWR"},
			currencyNegativePrefix: "(",
			currencyNegativeSuffix: ")",
			monthsAbbreviated:      []string{"", "Jan", "Feb", "Mac", "Epr", "Mei", "Jun", "Jul", "Oga", "Sep", "Okt", "Nov", "Dis"},
			monthsNarrow:           []string{"", "J", "F", "M", "E", "M", "J", "J", "O", "S", "O", "N", "D"},
			monthsWide:             []string{"", "Januari", "Februari", "Machi", "Epreo", "Mei", "Juni", "Julai", "Ogasti", "Septemba", "Oktoba", "Novemba", "Disemba"},
			daysWide:               []string{"Pa Mulungu", "Palichimo", "Palichibuli", "Palichitatu", "Palichine", "Palichisano", "Pachibelushi"},
			periodsAbbreviated:     []string{"uluchelo", "akasuba"},
			periodsWide:            []string{"uluchelo", "akasuba"},
			erasAbbreviated:        []string{"BC", "AD"},
			erasNarrow:             []string{"", ""},
			erasWide:               []string{"Before Yesu", "After Yesu"},
			timezones:              map[string]string{"ACDT": "ACDT", "ACST": "ACST", "ACWDT": "ACWDT", "ACWST": "ACWST", "ADT": "ADT", "AEDT": "AEDT", "AEST": "AEST", "AKDT": "AKDT", "AKST": "AKST", "ARST": "ARST", "ART": "ART", "AST": "AST", "AWDT": "AWDT", "AWST": "AWST", "BOT": "BOT", "BT": "BT", "CAT": "CAT", "CDT": "CDT", "CHADT": "CHADT", "CHAST": "CHAST", "CLST": "CLST", "CLT": "CLT", "COST": "COST", "COT": "COT", "CST": "CST", "ChST": "ChST", "EAT": "EAT", "ECT": "ECT", "EDT": "EDT", "EST": "EST", "GFT": "GFT", "GMT": "GMT", "GST": "GST", "GYT": "GYT", "HADT": "HADT", "HAST": "HAST", "HAT": "HAT", "HECU": "HECU", "HEEG": "HEEG", "HENOMX": "HENOMX", "HEOG": "HEOG", "HEPM": "HEPM", "HEPMX": "HEPMX", "HKST": "HKST", "HKT": "HKT", "HNCU": "HNCU", "HNEG": "HNEG", "HNNOMX": "HNNOMX", "HNOG": "HNOG", "HNPM": "HNPM", "HNPMX": "HNPMX", "HNT": "HNT", "IST": "IST", "JDT": "JDT", "JST": "JST", "LHDT": "LHDT", "LHST": "LHST", "MDT": "MDT", "MESZ": "MESZ", "MEZ": "MEZ", "MST": "MST", "MYT": "MYT", "NZDT": "NZDT", "NZST": "NZST", "OESZ": "OESZ", "OEZ": "OEZ", "PDT": "PDT", "PST": "PST", "SAST": "SAST", "SGT": "SGT", "SRT": "SRT", "TMST": "TMST", "TMT": "TMT", "UYST": "UYST", "UYT": "UYT", "VET": "VET", "WARST": "WARST", "WART": "WART", "WAST": "WAST", "WAT": "WAT", "WESZ": "WESZ", "WEZ": "WEZ", "WIB": "WIB", "WIT": "WIT", "WITA": "WITA", "∅∅∅": "∅∅∅"},

			fnCardinalPluralRule:  fnCardinalPluralRule_0758171f702b5b6024bdf47d25d8166d,
			fnDecimal:             fnDecimal_a78485e7dd32c95f41af4e18420793bf,
			fnFmtAccounting:       fnFmtAccounting_60b3ba42c7301cf18f0e7795b3eeaa75,
			fnFmtCurrency:         fnFmtCurrency_12d8afad3eb872da9d80fb14637f7f61,
			fnFmtDateFull:         fnFmtDateFull_c568798c9683b61c27e1bae4ea10cb6b,
			fnFmtDateLong:         fnFmtDateLong_506f643cda0514f66d873a9ea99bf639,
			fnFmtDateMedium:       fnFmtDateMedium_cb43e8c32d5cd0a27ac6db293a7981fd,
			fnFmtDateShort:        fnFmtDateShort_529ba7a02bedd437d0833b1afdb768c8,
			fnFmtNumber:           fnFmtNumber_2816fdab36e719be095a370ff42e599f,
			fnFmtPercent:          fnFmtPercent_016773d83796aa19d80b7c33bf377883,
			fnFmtTimeFull:         fnFmtTimeFull_37fe4deeee789852cc196a6a1a2f0ccc,
			fnFmtTimeLong:         fnFmtTimeLong_4429ef4fb58a2a9c4d7d5132fd16ecbf,
			fnFmtTimeMedium:       fnFmtTimeMedium_8ef07f6477b7a4944577d4e5392ff21b,
			fnFmtTimeShort:        fnFmtTimeShort_8288b817c5c0216c9815524c71c9e0b4,
			fnGroup:               fnGroup_5c4b80a5ccdee81467241784ab8fcd56,
			fnLocale:              fnLocale_5a217059c67094defae82f249f55f4c5,
			fnMinus:               fnMinus_8b8229905258388dc16a5e0c270b0488,
			fnMonthAbbreviated:    fnMonthAbbreviated_aa9a9957cd9d056ba078b36a08b17478,
			fnMonthNarrow:         fnMonthNarrow_45916040ecf6fc350894d9e3e6c46dc7,
			fnMonthWide:           fnMonthWide_4c946a7e7581c665e7407df1841810b5,
			fnMonthsAbbreviated:   fnMonthsAbbreviated_181f77804b62232997fae36bd57d6cf7,
			fnMonthsNarrow:        fnMonthsNarrow_75daa2ba82ae9577292175c3f52370cc,
			fnMonthsWide:          fnMonthsWide_0ecf36a8b72255e2fee9467af362e989,
			fnOrdinalPluralRule:   fnOrdinalPluralRule_a0e5467912a746c396065750c68e4318,
			fnPluralsCardinal:     fnPluralsCardinal_85b19cac1fab9f2c2cfb9eb41539aa0e,
			fnPluralsOrdinal:      fnPluralsOrdinal_16a60aa09da9778fa82fe463e83076de,
			fnPluralsRange:        fnPluralsRange_332465bda13eb808b3664fa0500f54ce,
			fnRangePluralRule:     fnRangePluralRule_e0f62e2cf3ae7407fb4b54d084341c0b,
			fnWeekdayAbbreviated:  fnWeekdayAbbreviated_4ffbdfbd2be10e6bd8fb5a542a14664a,
			fnWeekdayNarrow:       fnWeekdayNarrow_e86921b3446df5ea9afe9504cfa20d1a,
			fnWeekdayShort:        fnWeekdayShort_82b231d4f504c6d71c7e495aa35cd3c2,
			fnWeekdayWide:         fnWeekdayWide_ab7e026d8685cefd89c5aeb5df512a9a,
			fnWeekdaysAbbreviated: fnWeekdaysAbbreviated_454a3d7d23c662520a64ae5245d404be,
			fnWeekdaysNarrow:      fnWeekdaysNarrow_d23eb0b7a498c40ce19d1bf231cad524,
			fnWeekdaysShort:       fnWeekdaysShort_eb6ee64d01e314991432b4469790d38b,
			fnWeekdaysWide:        fnWeekdaysWide_5e2bbf75a31e730429c100e8a0bd3ebd,
		}
	}
	translatorFuncs["bez"] = func() locales.Translator {
		return &localen{

			locale:             "bez",
			pluralsCardinal:    []locales.PluralRule{2, 6},
			pluralsOrdinal:     nil,
			pluralsRange:       nil,
			timeSeparator:      ":",
			currencies:         []string{"ADP", "AED", "AFA", "AFN", "ALK", "ALL", "AMD", "ANG", "AOA", "AOK", "AON", "AOR", "ARA", "ARL", "ARM", "ARP", "ARS", "ATS", "AUD", "AWG", "AZM", "AZN", "BAD", "BAM", "BAN", "BBD", "BDT", "BEC", "BEF", "BEL", "BGL", "BGM", "BGN", "BGO", "BHD", "BIF", "BMD", "BND", "BOB", "BOL", "BOP", "BOV", "BRB", "BRC", "BRE", "BRL", "BRN", "BRR", "BRZ", "BSD", "BTN", "BUK", "BWP", "BYB", "BYN", "BYR", "BZD", "CAD", "CDF", "CHE", "CHF", "CHW", "CLE", "CLF", "CLP", "CNH", "CNX", "CNY", "COP", "COU", "CRC", "CSD", "CSK", "CUC", "CUP", "CVE", "CYP", "CZK", "DDM", "DEM", "DJF", "DKK", "DOP", "DZD", "ECS", "ECV", "EEK", "EGP", "ERN", "ESA", "ESB", "ESP", "ETB", "EUR", "FIM", "FJD", "FKP", "FRF", "GBP", "GEK", "GEL", "GHC", "GHS", "GIP", "GMD", "GNF", "GNS", "GQE", "GRD", "GTQ", "GWE", "GWP", "GYD", "HKD", "HNL", "HRD", "HRK", "HTG", "HUF", "IDR", "IEP", "ILP", "ILR", "ILS", "INR", "IQD", "IRR", "ISJ", "ISK", "ITL", "JMD", "JOD", "JPY", "KES", "KGS", "KHR", "KMF", "KPW", "KRH", "KRO", "KRW", "KWD", "KYD", "KZT", "LAK", "LBP", "LKR", "LRD", "LSL", "LTL", "LTT", "LUC", "LUF", "LUL", "LVL", "LVR", "LYD", "MAD", "MAF", "MCF", "MDC", "MDL", "MGA", "MGF", "MKD", "MKN", "MLF", "MMK", "MNT", "MOP", "MRO", "MRU", "MTL", "MTP", "MUR", "MVP", "MVR", "MWK", "MXN", "MXP", "MXV", "MYR", "MZE", "MZM", "MZN", "NAD", "NGN", "NIC", "NIO", "NLG", "NOK", "NPR", "NZD", "OMR", "PAB", "PEI", "PEN", "PES", "PGK", "PHP", "PKR", "PLN", "PLZ", "PTE", "PYG", "QAR", "RHD", "ROL", "RON", "RSD", "RUB", "RUR", "RWF", "SAR", "SBD", "SCR", "SDD", "SDG", "SDP", "SEK", "SGD", "SHP", "SIT", "SKK", "SLL", "SOS", "SRD", "SRG", "SSP", "STD", "STN", "SUR", "SVC", "SYP", "SZL", "THB", "TJR", "TJS", "TMM", "TMT", "TND", "TOP", "TPE", "TRL", "TRY", "TTD", "TWD", "TSh", "UAH", "UAK", "UGS", "UGX", "USD", "USN", "USS", "UYI", "UYP", "UYU", "UYW", "UZS", "VEB", "VEF", "VES", "VND", "VNN", "VUV", "WST", "XAF", "XAG", "XAU", "XBA", "XBB", "XBC", "XBD", "XCD", "XDR", "XEU", "XFO", "XFU", "XOF", "XPD", "XPF", "XPT", "XRE", "XSU", "XTS", "XUA", "XXX", "YDD", "YER", "YUD", "YUM", "YUN", "YUR", "ZAL", "ZAR", "ZMK", "ZMW", "ZRN", "ZRZ", "ZWD", "ZWL", "ZWR"},
			monthsAbbreviated:  []string{"", "Hut", "Vil", "Dat", "Tai", "Han", "Sit", "Sab", "Nan", "Tis", "Kum", "Kmj", "Kmb"},
			monthsNarrow:       []string{"", "H", "V", "D", "T", "H", "S", "S", "N", "T", "K", "K", "K"},
			monthsWide:         []string{"", "pa mwedzi gwa hutala", "pa mwedzi gwa wuvili", "pa mwedzi gwa wudatu", "pa mwedzi gwa wutai", "pa mwedzi gwa wuhanu", "pa mwedzi gwa sita", "pa mwedzi gwa saba", "pa mwedzi gwa nane", "pa mwedzi gwa tisa", "pa mwedzi gwa kumi", "pa mwedzi gwa kumi na moja", "pa mwedzi gwa kumi na mbili"},
			daysAbbreviated:    []string{"Mul", "Vil", "Hiv", "Hid", "Hit", "Hih", "Lem"},
			daysNarrow:         []string{"M", "J", "H", "H", "H", "W", "J"},
			daysWide:           []string{"pa mulungu", "pa shahuviluha", "pa hivili", "pa hidatu", "pa hitayi", "pa hihanu", "pa shahulembela"},
			periodsAbbreviated: []string{"pamilau", "pamunyi"},
			periodsWide:        []string{"pamilau", "pamunyi"},
			erasAbbreviated:    []string{"KM", "BM"},
			erasNarrow:         []string{"", ""},
			erasWide:           []string{"Kabla ya Mtwaa", "Baada ya Mtwaa"},
			timezones:          map[string]string{"ACDT": "ACDT", "ACST": "ACST", "ACWDT": "ACWDT", "ACWST": "ACWST", "ADT": "ADT", "AEDT": "AEDT", "AEST": "AEST", "AKDT": "AKDT", "AKST": "AKST", "ARST": "ARST", "ART": "ART", "AST": "AST", "AWDT": "AWDT", "AWST": "AWST", "BOT": "BOT", "BT": "BT", "CAT": "CAT", "CDT": "CDT", "CHADT": "CHADT", "CHAST": "CHAST", "CLST": "CLST", "CLT": "CLT", "COST": "COST", "COT": "COT", "CST": "CST", "ChST": "ChST", "EAT": "EAT", "ECT": "ECT", "EDT": "EDT", "EST": "EST", "GFT": "GFT", "GMT": "GMT", "GST": "GST", "GYT": "GYT", "HADT": "HADT", "HAST": "HAST", "HAT": "HAT", "HECU": "HECU", "HEEG": "HEEG", "HENOMX": "HENOMX", "HEOG": "HEOG", "HEPM": "HEPM", "HEPMX": "HEPMX", "HKST": "HKST", "HKT": "HKT", "HNCU": "HNCU", "HNEG": "HNEG", "HNNOMX": "HNNOMX", "HNOG": "HNOG", "HNPM": "HNPM", "HNPMX": "HNPMX", "HNT": "HNT", "IST": "IST", "JDT": "JDT", "JST": "JST", "LHDT": "LHDT", "LHST": "LHST", "MDT": "MDT", "MESZ": "MESZ", "MEZ": "MEZ", "MST": "MST", "MYT": "MYT", "NZDT": "NZDT", "NZST": "NZST", "OESZ": "OESZ", "OEZ": "OEZ", "PDT": "PDT", "PST": "PST", "SAST": "SAST", "SGT": "SGT", "SRT": "SRT", "TMST": "TMST", "TMT": "TMT", "UYST": "UYST", "UYT": "UYT", "VET": "VET", "WARST": "WARST", "WART": "WART", "WAST": "WAST", "WAT": "WAT", "WESZ": "WESZ", "WEZ": "WEZ", "WIB": "WIB", "WIT": "WIT", "WITA": "WITA", "∅∅∅": "∅∅∅"},

			fnCardinalPluralRule:  fnCardinalPluralRule_0758171f702b5b6024bdf47d25d8166d,
			fnDecimal:             fnDecimal_a78485e7dd32c95f41af4e18420793bf,
			fnFmtAccounting:       fnFmtAccounting_b4b66bcaf750a9b7b42ab51bff8c0e19,
			fnFmtCurrency:         fnFmtCurrency_022949044632e54ed5ae02ba82626546,
			fnFmtDateFull:         fnFmtDateFull_c568798c9683b61c27e1bae4ea10cb6b,
			fnFmtDateLong:         fnFmtDateLong_506f643cda0514f66d873a9ea99bf639,
			fnFmtDateMedium:       fnFmtDateMedium_cb43e8c32d5cd0a27ac6db293a7981fd,
			fnFmtDateShort:        fnFmtDateShort_529ba7a02bedd437d0833b1afdb768c8,
			fnFmtNumber:           fnFmtNumber_2816fdab36e719be095a370ff42e599f,
			fnFmtPercent:          fnFmtPercent_016773d83796aa19d80b7c33bf377883,
			fnFmtTimeFull:         fnFmtTimeFull_ebdf96de1e47f9043145564c500ef7dc,
			fnFmtTimeLong:         fnFmtTimeLong_987bec4676d3a5de4218e415e123649d,
			fnFmtTimeMedium:       fnFmtTimeMedium_b6f697552cd4965cd1195fe56dc87003,
			fnFmtTimeShort:        fnFmtTimeShort_8ffba4d1a2f04a0a6486853d76cf434b,
			fnGroup:               fnGroup_5c4b80a5ccdee81467241784ab8fcd56,
			fnLocale:              fnLocale_5a217059c67094defae82f249f55f4c5,
			fnMinus:               fnMinus_8b8229905258388dc16a5e0c270b0488,
			fnMonthAbbreviated:    fnMonthAbbreviated_aa9a9957cd9d056ba078b36a08b17478,
			fnMonthNarrow:         fnMonthNarrow_45916040ecf6fc350894d9e3e6c46dc7,
			fnMonthWide:           fnMonthWide_4c946a7e7581c665e7407df1841810b5,
			fnMonthsAbbreviated:   fnMonthsAbbreviated_181f77804b62232997fae36bd57d6cf7,
			fnMonthsNarrow:        fnMonthsNarrow_75daa2ba82ae9577292175c3f52370cc,
			fnMonthsWide:          fnMonthsWide_0ecf36a8b72255e2fee9467af362e989,
			fnOrdinalPluralRule:   fnOrdinalPluralRule_a0e5467912a746c396065750c68e4318,
			fnPluralsCardinal:     fnPluralsCardinal_85b19cac1fab9f2c2cfb9eb41539aa0e,
			fnPluralsOrdinal:      fnPluralsOrdinal_16a60aa09da9778fa82fe463e83076de,
			fnPluralsRange:        fnPluralsRange_332465bda13eb808b3664fa0500f54ce,
			fnRangePluralRule:     fnRangePluralRule_e0f62e2cf3ae7407fb4b54d084341c0b,
			fnWeekdayAbbreviated:  fnWeekdayAbbreviated_4ffbdfbd2be10e6bd8fb5a542a14664a,
			fnWeekdayNarrow:       fnWeekdayNarrow_e86921b3446df5ea9afe9504cfa20d1a,
			fnWeekdayShort:        fnWeekdayShort_82b231d4f504c6d71c7e495aa35cd3c2,
			fnWeekdayWide:         fnWeekdayWide_ab7e026d8685cefd89c5aeb5df512a9a,
			fnWeekdaysAbbreviated: fnWeekdaysAbbreviated_454a3d7d23c662520a64ae5245d404be,
			fnWeekdaysNarrow:      fnWeekdaysNarrow_d23eb0b7a498c40ce19d1bf231cad524,
			fnWeekdaysShort:       fnWeekdaysShort_eb6ee64d01e314991432b4469790d38b,
			fnWeekdaysWide:        fnWeekdaysWide_5e2bbf75a31e730429c100e8a0bd3ebd,
		}
	}
	translatorFuncs["bez_tz"] = func() locales.Translator {
		return &localen{

			locale:             "bez_TZ",
			pluralsCardinal:    []locales.PluralRule{2, 6},
			pluralsOrdinal:     nil,
			pluralsRange:       nil,
			timeSeparator:      ":",
			currencies:         []string{"ADP", "AED", "AFA", "AFN", "ALK", "ALL", "AMD", "ANG", "AOA", "AOK", "AON", "AOR", "ARA", "ARL", "ARM", "ARP", "ARS", "ATS", "AUD", "AWG", "AZM", "AZN", "BAD", "BAM", "BAN", "BBD", "BDT", "BEC", "BEF", "BEL", "BGL", "BGM", "BGN", "BGO", "BHD", "BIF", "BMD", "BND", "BOB", "BOL", "BOP", "BOV", "BRB", "BRC", "BRE", "BRL", "BRN", "BRR", "BRZ", "BSD", "BTN", "BUK", "BWP", "BYB", "BYN", "BYR", "BZD", "CAD", "CDF", "CHE", "CHF", "CHW", "CLE", "CLF", "CLP", "CNH", "CNX", "CNY", "COP", "COU", "CRC", "CSD", "CSK", "CUC", "CUP", "CVE", "CYP", "CZK", "DDM", "DEM", "DJF", "DKK", "DOP", "DZD", "ECS", "ECV", "EEK", "EGP", "ERN", "ESA", "ESB", "ESP", "ETB", "EUR", "FIM", "FJD", "FKP", "FRF", "GBP", "GEK", "GEL", "GHC", "GHS", "GIP", "GMD", "GNF", "GNS", "GQE", "GRD", "GTQ", "GWE", "GWP", "GYD", "HKD", "HNL", "HRD", "HRK", "HTG", "HUF", "IDR", "IEP", "ILP", "ILR", "ILS", "INR", "IQD", "IRR", "ISJ", "ISK", "ITL", "JMD", "JOD", "JPY", "KES", "KGS", "KHR", "KMF", "KPW", "KRH", "KRO", "KRW", "KWD", "KYD", "KZT", "LAK", "LBP", "LKR", "LRD", "LSL", "LTL", "LTT", "LUC", "LUF", "LUL", "LVL", "LVR", "LYD", "MAD", "MAF", "MCF", "MDC", "MDL", "MGA", "MGF", "MKD", "MKN", "MLF", "MMK", "MNT", "MOP", "MRO", "MRU", "MTL", "MTP", "MUR", "MVP", "MVR", "MWK", "MXN", "MXP", "MXV", "MYR", "MZE", "MZM", "MZN", "NAD", "NGN", "NIC", "NIO", "NLG", "NOK", "NPR", "NZD", "OMR", "PAB", "PEI", "PEN", "PES", "PGK", "PHP", "PKR", "PLN", "PLZ", "PTE", "PYG", "QAR", "RHD", "ROL", "RON", "RSD", "RUB", "RUR", "RWF", "SAR", "SBD", "SCR", "SDD", "SDG", "SDP", "SEK", "SGD", "SHP", "SIT", "SKK", "SLL", "SOS", "SRD", "SRG", "SSP", "STD", "STN", "SUR", "SVC", "SYP", "SZL", "THB", "TJR", "TJS", "TMM", "TMT", "TND", "TOP", "TPE", "TRL", "TRY", "TTD", "TWD", "TZS", "UAH", "UAK", "UGS", "UGX", "USD", "USN", "USS", "UYI", "UYP", "UYU", "UYW", "UZS", "VEB", "VEF", "VES", "VND", "VNN", "VUV", "WST", "XAF", "XAG", "XAU", "XBA", "XBB", "XBC", "XBD", "XCD", "XDR", "XEU", "XFO", "XFU", "XOF", "XPD", "XPF", "XPT", "XRE", "XSU", "XTS", "XUA", "XXX", "YDD", "YER", "YUD", "YUM", "YUN", "YUR", "ZAL", "ZAR", "ZMK", "ZMW", "ZRN", "ZRZ", "ZWD", "ZWL", "ZWR"},
			monthsAbbreviated:  []string{"", "Hut", "Vil", "Dat", "Tai", "Han", "Sit", "Sab", "Nan", "Tis", "Kum", "Kmj", "Kmb"},
			monthsNarrow:       []string{"", "H", "V", "D", "T", "H", "S", "S", "N", "T", "K", "K", "K"},
			monthsWide:         []string{"", "pa mwedzi gwa hutala", "pa mwedzi gwa wuvili", "pa mwedzi gwa wudatu", "pa mwedzi gwa wutai", "pa mwedzi gwa wuhanu", "pa mwedzi gwa sita", "pa mwedzi gwa saba", "pa mwedzi gwa nane", "pa mwedzi gwa tisa", "pa mwedzi gwa kumi", "pa mwedzi gwa kumi na moja", "pa mwedzi gwa kumi na mbili"},
			daysAbbreviated:    []string{"Mul", "Vil", "Hiv", "Hid", "Hit", "Hih", "Lem"},
			daysNarrow:         []string{"M", "J", "H", "H", "H", "W", "J"},
			daysWide:           []string{"pa mulungu", "pa shahuviluha", "pa hivili", "pa hidatu", "pa hitayi", "pa hihanu", "pa shahulembela"},
			periodsAbbreviated: []string{"pamilau", "pamunyi"},
			periodsWide:        []string{"pamilau", "pamunyi"},
			erasAbbreviated:    []string{"KM", "BM"},
			erasNarrow:         []string{"", ""},
			erasWide:           []string{"Kabla ya Mtwaa", "Baada ya Mtwaa"},
			timezones:          map[string]string{"ACDT": "ACDT", "ACST": "ACST", "ACWDT": "ACWDT", "ACWST": "ACWST", "ADT": "ADT", "AEDT": "AEDT", "AEST": "AEST", "AKDT": "AKDT", "AKST": "AKST", "ARST": "ARST", "ART": "ART", "AST": "AST", "AWDT": "AWDT", "AWST": "AWST", "BOT": "BOT", "BT": "BT", "CAT": "CAT", "CDT": "CDT", "CHADT": "CHADT", "CHAST": "CHAST", "CLST": "CLST", "CLT": "CLT", "COST": "COST", "COT": "COT", "CST": "CST", "ChST": "ChST", "EAT": "EAT", "ECT": "ECT", "EDT": "EDT", "EST": "EST", "GFT": "GFT", "GMT": "GMT", "GST": "GST", "GYT": "GYT", "HADT": "HADT", "HAST": "HAST", "HAT": "HAT", "HECU": "HECU", "HEEG": "HEEG", "HENOMX": "HENOMX", "HEOG": "HEOG", "HEPM": "HEPM", "HEPMX": "HEPMX", "HKST": "HKST", "HKT": "HKT", "HNCU": "HNCU", "HNEG": "HNEG", "HNNOMX": "HNNOMX", "HNOG": "HNOG", "HNPM": "HNPM", "HNPMX": "HNPMX", "HNT": "HNT", "IST": "IST", "JDT": "JDT", "JST": "JST", "LHDT": "LHDT", "LHST": "LHST", "MDT": "MDT", "MESZ": "MESZ", "MEZ": "MEZ", "MST": "MST", "MYT": "MYT", "NZDT": "NZDT", "NZST": "NZST", "OESZ": "OESZ", "OEZ": "OEZ", "PDT": "PDT", "PST": "PST", "SAST": "SAST", "SGT": "SGT", "SRT": "SRT", "TMST": "TMST", "TMT": "TMT", "UYST": "UYST", "UYT": "UYT", "VET": "VET", "WARST": "WARST", "WART": "WART", "WAST": "WAST", "WAT": "WAT", "WESZ": "WESZ", "WEZ": "WEZ", "WIB": "WIB", "WIT": "WIT", "WITA": "WITA", "∅∅∅": "∅∅∅"},

			fnCardinalPluralRule:  fnCardinalPluralRule_0758171f702b5b6024bdf47d25d8166d,
			fnDecimal:             fnDecimal_a78485e7dd32c95f41af4e18420793bf,
			fnFmtAccounting:       fnFmtAccounting_b4b66bcaf750a9b7b42ab51bff8c0e19,
			fnFmtCurrency:         fnFmtCurrency_022949044632e54ed5ae02ba82626546,
			fnFmtDateFull:         fnFmtDateFull_c568798c9683b61c27e1bae4ea10cb6b,
			fnFmtDateLong:         fnFmtDateLong_506f643cda0514f66d873a9ea99bf639,
			fnFmtDateMedium:       fnFmtDateMedium_cb43e8c32d5cd0a27ac6db293a7981fd,
			fnFmtDateShort:        fnFmtDateShort_529ba7a02bedd437d0833b1afdb768c8,
			fnFmtNumber:           fnFmtNumber_2816fdab36e719be095a370ff42e599f,
			fnFmtPercent:          fnFmtPercent_016773d83796aa19d80b7c33bf377883,
			fnFmtTimeFull:         fnFmtTimeFull_ebdf96de1e47f9043145564c500ef7dc,
			fnFmtTimeLong:         fnFmtTimeLong_987bec4676d3a5de4218e415e123649d,
			fnFmtTimeMedium:       fnFmtTimeMedium_b6f697552cd4965cd1195fe56dc87003,
			fnFmtTimeShort:        fnFmtTimeShort_8ffba4d1a2f04a0a6486853d76cf434b,
			fnGroup:               fnGroup_5c4b80a5ccdee81467241784ab8fcd56,
			fnLocale:              fnLocale_5a217059c67094defae82f249f55f4c5,
			fnMinus:               fnMinus_8b8229905258388dc16a5e0c270b0488,
			fnMonthAbbreviated:    fnMonthAbbreviated_aa9a9957cd9d056ba078b36a08b17478,
			fnMonthNarrow:         fnMonthNarrow_45916040ecf6fc350894d9e3e6c46dc7,
			fnMonthWide:           fnMonthWide_4c946a7e7581c665e7407df1841810b5,
			fnMonthsAbbreviated:   fnMonthsAbbreviated_181f77804b62232997fae36bd57d6cf7,
			fnMonthsNarrow:        fnMonthsNarrow_75daa2ba82ae9577292175c3f52370cc,
			fnMonthsWide:          fnMonthsWide_0ecf36a8b72255e2fee9467af362e989,
			fnOrdinalPluralRule:   fnOrdinalPluralRule_a0e5467912a746c396065750c68e4318,
			fnPluralsCardinal:     fnPluralsCardinal_85b19cac1fab9f2c2cfb9eb41539aa0e,
			fnPluralsOrdinal:      fnPluralsOrdinal_16a60aa09da9778fa82fe463e83076de,
			fnPluralsRange:        fnPluralsRange_332465bda13eb808b3664fa0500f54ce,
			fnRangePluralRule:     fnRangePluralRule_e0f62e2cf3ae7407fb4b54d084341c0b,
			fnWeekdayAbbreviated:  fnWeekdayAbbreviated_4ffbdfbd2be10e6bd8fb5a542a14664a,
			fnWeekdayNarrow:       fnWeekdayNarrow_e86921b3446df5ea9afe9504cfa20d1a,
			fnWeekdayShort:        fnWeekdayShort_82b231d4f504c6d71c7e495aa35cd3c2,
			fnWeekdayWide:         fnWeekdayWide_ab7e026d8685cefd89c5aeb5df512a9a,
			fnWeekdaysAbbreviated: fnWeekdaysAbbreviated_454a3d7d23c662520a64ae5245d404be,
			fnWeekdaysNarrow:      fnWeekdaysNarrow_d23eb0b7a498c40ce19d1bf231cad524,
			fnWeekdaysShort:       fnWeekdaysShort_eb6ee64d01e314991432b4469790d38b,
			fnWeekdaysWide:        fnWeekdaysWide_5e2bbf75a31e730429c100e8a0bd3ebd,
		}
	}
	translatorFuncs["bg"] = func() locales.Translator {
		return &localen{

			locale:                 "bg",
			pluralsCardinal:        []locales.PluralRule{2, 6},
			pluralsOrdinal:         []locales.PluralRule{6},
			pluralsRange:           []locales.PluralRule{6},
			decimal:                ",",
			group:                  " ",
			minus:                  "-",
			percent:                "%",
			perMille:               "‰",
			timeSeparator:          ":",
			inifinity:              "∞",
			currencies:             []string{"ADP", "AED", "AFA", "AFN", "ALK", "ALL", "AMD", "ANG", "AOA", "AOK", "AON", "AOR", "ARA", "ARL", "ARM", "ARP", "ARS", "ATS", "AUD", "AWG", "AZM", "AZN", "BAD", "BAM", "BAN", "BBD", "BDT", "BEC", "BEF", "BEL", "BGL", "BGM", "лв.", "BGO", "BHD", "BIF", "BMD", "BND", "BOB", "BOL", "BOP", "BOV", "BRB", "BRC", "BRE", "BRL", "BRN", "BRR", "BRZ", "BSD", "BTN", "BUK", "BWP", "BYB", "BYN", "BYR", "BZD", "CAD", "CDF", "CHE", "CHF", "CHW", "CLE", "CLF", "CLP", "CNH", "CNX", "CNY", "COP", "COU", "CRC", "CSD", "CSK", "CUC", "CUP", "CVE", "CYP", "CZK", "DDM", "DEM", "DJF", "DKK", "DOP", "DZD", "ECS", "ECV", "EEK", "EGP", "ERN", "ESA", "ESB", "ESP", "ETB", "€", "FIM", "FJD", "FKP", "FRF", "GBP", "GEK", "GEL", "GHC", "GHS", "GIP", "GMD", "GNF", "GNS", "GQE", "GRD", "GTQ", "GWE", "GWP", "GYD", "HKD", "HNL", "HRD", "HRK", "HTG", "HUF", "IDR", "IEP", "ILP", "ILR", "ILS", "INR", "IQD", "IRR", "ISJ", "ISK", "ITL", "JMD", "JOD", "JPY", "KES", "KGS", "KHR", "KMF", "KPW", "KRH", "KRO", "KRW", "KWD", "KYD", "KZT", "LAK", "LBP", "LKR", "LRD", "LSL", "LTL", "LTT", "LUC", "LUF", "LUL", "LVL", "LVR", "LYD", "MAD", "MAF", "MCF", "MDC", "MDL", "MGA", "MGF", "MKD", "MKN", "MLF", "MMK", "MNT", "MOP", "MRO", "MRU", "MTL", "MTP", "MUR", "MVP", "MVR", "MWK", "MXN", "MXP", "MXV", "MYR", "MZE", "MZM", "MZN", "NAD", "NGN", "NIC", "NIO", "NLG", "NOK", "NPR", "NZD", "OMR", "PAB", "PEI", "PEN", "PES", "PGK", "PHP", "PKR", "PLN", "PLZ", "PTE", "PYG", "QAR", "RHD", "ROL", "RON", "RSD", "RUB", "RUR", "RWF", "SAR", "SBD", "SCR", "SDD", "SDG", "SDP", "SEK", "SGD", "SHP", "SIT", "SKK", "SLL", "SOS", "SRD", "SRG", "SSP", "STD", "STN", "SUR", "SVC", "SYP", "SZL", "THB", "TJR", "TJS", "TMM", "TMT", "TND", "TOP", "TPE", "TRL", "TRY", "TTD", "TWD", "TZS", "UAH", "UAK", "UGS", "UGX", "щ.д.", "USN", "USS", "UYI", "UYP", "UYU", "UYW", "UZS", "VEB", "VEF", "VES", "VND", "VNN", "VUV", "WST", "FCFA", "XAG", "XAU", "XBA", "XBB", "XBC", "XBD", "XCD", "XDR", "XEU", "XFO", "XFU", "CFA", "XPD", "CFPF", "XPT", "XRE", "XSU", "XTS", "XUA", "XXX", "YDD", "YER", "YUD", "YUM", "YUN", "YUR", "ZAL", "ZAR", "ZMK", "ZMW", "ZRN", "ZRZ", "ZWD", "ZWL", "ZWR"},
			currencyPositiveSuffix: " ",
			currencyNegativePrefix: "(",
			currencyNegativeSuffix: " )",
			monthsAbbreviated:      []string{"", "яну", "фев", "март", "апр", "май", "юни", "юли", "авг", "сеп", "окт", "ное", "дек"},
			monthsNarrow:           []string{"", "я", "ф", "м", "а", "м", "ю", "ю", "а", "с", "о", "н", "д"},
			monthsWide:             []string{"", "януари", "февруари", "март", "април", "май", "юни", "юли", "август", "септември", "октомври", "ноември", "декември"},
			daysAbbreviated:        []string{"нд", "пн", "вт", "ср", "чт", "пт", "сб"},
			daysNarrow:             []string{"н", "п", "в", "с", "ч", "п", "с"},
			daysShort:              []string{"нд", "пн", "вт", "ср", "чт", "пт", "сб"},
			daysWide:               []string{"неделя", "понеделник", "вторник", "сряда", "четвъртък", "петък", "събота"},
			periodsAbbreviated:     []string{"am", "pm"},
			periodsNarrow:          []string{"am", "pm"},
			periodsWide:            []string{"пр.об.", "сл.об."},
			erasAbbreviated:        []string{"пр.Хр.", "сл.Хр."},
			erasNarrow:             []string{"", ""},
			erasWide:               []string{"преди Христа", "след Христа"},
			timezones:              map[string]string{"ACDT": "Централноавстралийско лятно часово време", "ACST": "Централноавстралийско стандартно време", "ACWDT": "Австралия – западно централно лятно часово време", "ACWST": "Австралия – западно централно стандартно време", "ADT": "Северноамериканско атлантическо лятно часово време", "AEDT": "Източноавстралийско лятно часово време", "AEST": "Източноавстралийско стандартно време", "AKDT": "Аляска – лятно часово време", "AKST": "Аляска – стандартно време", "ARST": "Аржентинско лятно часово време", "ART": "Аржентинско стандартно време", "AST": "Северноамериканско атлантическо стандартно време", "AWDT": "Западноавстралийско лятно часово време", "AWST": "Западноавстралийско стандартно време", "BOT": "Боливийско време", "BT": "Бутанско време", "CAT": "Централноафриканско време", "CDT": "Северноамериканско централно лятно часово време", "CHADT": "Чатъмско лятно часово време", "CHAST": "Чатъмско стандартно време", "CLST": "Чилийско лятно часово време", "CLT": "Чилийско стандартно време", "COST": "Колумбийско лятно часово време", "COT": "Колумбийско стандартно време", "CST": "Северноамериканско централно стандартно време", "ChST": "Чаморско време", "EAT": "Източноафриканско време", "ECT": "Еквадорско време", "EDT": "Северноамериканско източно лятно часово време", "EST": "Северноамериканско източно стандартно време", "GFT": "Френска Гвиана", "GMT": "Средно гринуичко време", "GST": "Персийски залив", "GYT": "Гаяна", "HADT": "Хавайско-алеутско лятно часово време", "HAST": "Хавайско-алеутско стандартно време", "HAT": "Нюфаундлендско лятно часово време", "HECU": "Кубинско лятно часово време", "HEEG": "Източногренландско лятно часово време", "HENOMX": "Северозападно лятно часово мексиканско време", "HEOG": "Западногренландско лятно часово време", "HEPM": "Сен Пиер и Микелон – лятно часово време", "HEPMX": "Мексиканско тихоокеанско лятно часово време", "HKST": "Хонконгско лятно часово време", "HKT": "Хонконгско стандартно време", "HNCU": "Кубинско стандартно време", "HNEG": "Източногренландско стандартно време", "HNNOMX": "Северозападно стандартно мексиканско време", "HNOG": "Западногренландско стандартно време", "HNPM": "Сен Пиер и Микелон – стандартно време", "HNPMX": "Мексиканско тихоокеанско стандартно време", "HNT": "Нюфаундлендско стандартно време", "IST": "Индийско време", "JDT": "Японско лятно часово време", "JST": "Японско стандартно време", "LHDT": "Лорд Хау – лятно часово време", "LHST": "Лорд Хау – стандартно време", "MDT": "Северноамериканско планинско лятно часово време", "MESZ": "Централноевропейско лятно часово време", "MEZ": "Централноевропейско стандартно време", "MST": "Северноамериканско планинско стандартно време", "MYT": "Малайзийско време", "NZDT": "Новозеландско лятно часово време", "NZST": "Новозеландско стандартно време", "OESZ": "Източноевропейско лятно часово време", "OEZ": "Източноевропейско стандартно време", "PDT": "Северноамериканско тихоокеанско лятно часово време", "PST": "Северноамериканско тихоокеанско стандартно време", "SAST": "Южноафриканско време", "SGT": "Сингапурско време", "SRT": "Суринамско време", "TMST": "Туркменистанско лятно часово време", "TMT": "Туркменистанско стандартно време", "UYST": "Уругвайско лятно часово време", "UYT": "Уругвайско стандартно време", "VET": "Венецуелско време", "WARST": "Западноаржентинско лятно часово време", "WART": "Западноаржентинско стандартно време", "WAST": "Западноафриканско лятно часово време", "WAT": "Западноафриканско стандартно време", "WESZ": "Западноевропейско лятно време", "WEZ": "Западноевропейско стандартно време", "WIB": "Западноиндонезийско време", "WIT": "Източноиндонезийско време", "WITA": "Централноиндонезийско време", "∅∅∅": "Азорски острови – лятно часово време"},

			fnCardinalPluralRule:  fnCardinalPluralRule_0758171f702b5b6024bdf47d25d8166d,
			fnDecimal:             fnDecimal_a78485e7dd32c95f41af4e18420793bf,
			fnFmtAccounting:       fnFmtAccounting_895833c14256127b155b25fc552f5180,
			fnFmtCurrency:         fnFmtCurrency_88fd8698aec1fdcde88908d426b01f78,
			fnFmtDateFull:         fnFmtDateFull_3bb9a5fb6d982f44bb197fafb3f68087,
			fnFmtDateLong:         fnFmtDateLong_b673377c923e43f185728d5b63716bee,
			fnFmtDateMedium:       fnFmtDateMedium_387f50f821f8034478c23ca141a1b991,
			fnFmtDateShort:        fnFmtDateShort_724096485badda99a595db97f2fdcc96,
			fnFmtNumber:           fnFmtNumber_0866206624669dc4f03297eb76a545b2,
			fnFmtPercent:          fnFmtPercent_1c35b3868bf10d0e69b22b2e80c40671,
			fnFmtTimeFull:         fnFmtTimeFull_103caa51aab787e802d47e2174ea5313,
			fnFmtTimeLong:         fnFmtTimeLong_14ec37cb9b88b34ab642f7ee8fd2800b,
			fnFmtTimeMedium:       fnFmtTimeMedium_c3e2f72b9dd7b60e99ec7ed62baf96a4,
			fnFmtTimeShort:        fnFmtTimeShort_d0370e7a739d1d7da91c2071fa2c12c5,
			fnGroup:               fnGroup_5c4b80a5ccdee81467241784ab8fcd56,
			fnLocale:              fnLocale_5a217059c67094defae82f249f55f4c5,
			fnMinus:               fnMinus_8b8229905258388dc16a5e0c270b0488,
			fnMonthAbbreviated:    fnMonthAbbreviated_aa9a9957cd9d056ba078b36a08b17478,
			fnMonthNarrow:         fnMonthNarrow_45916040ecf6fc350894d9e3e6c46dc7,
			fnMonthWide:           fnMonthWide_4c946a7e7581c665e7407df1841810b5,
			fnMonthsAbbreviated:   fnMonthsAbbreviated_181f77804b62232997fae36bd57d6cf7,
			fnMonthsNarrow:        fnMonthsNarrow_75daa2ba82ae9577292175c3f52370cc,
			fnMonthsWide:          fnMonthsWide_0ecf36a8b72255e2fee9467af362e989,
			fnOrdinalPluralRule:   fnOrdinalPluralRule_3355865f05dde9af2a36ba415bea85cb,
			fnPluralsCardinal:     fnPluralsCardinal_85b19cac1fab9f2c2cfb9eb41539aa0e,
			fnPluralsOrdinal:      fnPluralsOrdinal_16a60aa09da9778fa82fe463e83076de,
			fnPluralsRange:        fnPluralsRange_332465bda13eb808b3664fa0500f54ce,
			fnRangePluralRule:     fnRangePluralRule_91a918d93f773c0b7589da5ebb6c4164,
			fnWeekdayAbbreviated:  fnWeekdayAbbreviated_4ffbdfbd2be10e6bd8fb5a542a14664a,
			fnWeekdayNarrow:       fnWeekdayNarrow_e86921b3446df5ea9afe9504cfa20d1a,
			fnWeekdayShort:        fnWeekdayShort_82b231d4f504c6d71c7e495aa35cd3c2,
			fnWeekdayWide:         fnWeekdayWide_ab7e026d8685cefd89c5aeb5df512a9a,
			fnWeekdaysAbbreviated: fnWeekdaysAbbreviated_454a3d7d23c662520a64ae5245d404be,
			fnWeekdaysNarrow:      fnWeekdaysNarrow_d23eb0b7a498c40ce19d1bf231cad524,
			fnWeekdaysShort:       fnWeekdaysShort_eb6ee64d01e314991432b4469790d38b,
			fnWeekdaysWide:        fnWeekdaysWide_5e2bbf75a31e730429c100e8a0bd3ebd,
		}
	}
	translatorFuncs["bg_bg"] = func() locales.Translator {
		return &localen{

			locale:                 "bg_BG",
			pluralsCardinal:        []locales.PluralRule{2, 6},
			pluralsOrdinal:         []locales.PluralRule{6},
			pluralsRange:           []locales.PluralRule{6},
			decimal:                ",",
			group:                  " ",
			minus:                  "-",
			percent:                "%",
			perMille:               "‰",
			timeSeparator:          ":",
			inifinity:              "∞",
			currencies:             []string{"ADP", "AED", "AFA", "AFN", "ALK", "ALL", "AMD", "ANG", "AOA", "AOK", "AON", "AOR", "ARA", "ARL", "ARM", "ARP", "ARS", "ATS", "AUD", "AWG", "AZM", "AZN", "BAD", "BAM", "BAN", "BBD", "BDT", "BEC", "BEF", "BEL", "BGL", "BGM", "BGN", "BGO", "BHD", "BIF", "BMD", "BND", "BOB", "BOL", "BOP", "BOV", "BRB", "BRC", "BRE", "BRL", "BRN", "BRR", "BRZ", "BSD", "BTN", "BUK", "BWP", "BYB", "BYN", "BYR", "BZD", "CAD", "CDF", "CHE", "CHF", "CHW", "CLE", "CLF", "CLP", "CNH", "CNX", "CNY", "COP", "COU", "CRC", "CSD", "CSK", "CUC", "CUP", "CVE", "CYP", "CZK", "DDM", "DEM", "DJF", "DKK", "DOP", "DZD", "ECS", "ECV", "EEK", "EGP", "ERN", "ESA", "ESB", "ESP", "ETB", "EUR", "FIM", "FJD", "FKP", "FRF", "GBP", "GEK", "GEL", "GHC", "GHS", "GIP", "GMD", "GNF", "GNS", "GQE", "GRD", "GTQ", "GWE", "GWP", "GYD", "HKD", "HNL", "HRD", "HRK", "HTG", "HUF", "IDR", "IEP", "ILP", "ILR", "ILS", "INR", "IQD", "IRR", "ISJ", "ISK", "ITL", "JMD", "JOD", "JPY", "KES", "KGS", "KHR", "KMF", "KPW", "KRH", "KRO", "KRW", "KWD", "KYD", "KZT", "LAK", "LBP", "LKR", "LRD", "LSL", "LTL", "LTT", "LUC", "LUF", "LUL", "LVL", "LVR", "LYD", "MAD", "MAF", "MCF", "MDC", "MDL", "MGA", "MGF", "MKD", "MKN", "MLF", "MMK", "MNT", "MOP", "MRO", "MRU", "MTL", "MTP", "MUR", "MVP", "MVR", "MWK", "MXN", "MXP", "MXV", "MYR", "MZE", "MZM", "MZN", "NAD", "NGN", "NIC", "NIO", "NLG", "NOK", "NPR", "NZD", "OMR", "PAB", "PEI", "PEN", "PES", "PGK", "PHP", "PKR", "PLN", "PLZ", "PTE", "PYG", "QAR", "RHD", "ROL", "RON", "RSD", "RUB", "RUR", "RWF", "SAR", "SBD", "SCR", "SDD", "SDG", "SDP", "SEK", "SGD", "SHP", "SIT", "SKK", "SLL", "SOS", "SRD", "SRG", "SSP", "STD", "STN", "SUR", "SVC", "SYP", "SZL", "THB", "TJR", "TJS", "TMM", "TMT", "TND", "TOP", "TPE", "TRL", "TRY", "TTD", "TWD", "TZS", "UAH", "UAK", "UGS", "UGX", "USD", "USN", "USS", "UYI", "UYP", "UYU", "UYW", "UZS", "VEB", "VEF", "VES", "VND", "VNN", "VUV", "WST", "XAF", "XAG", "XAU", "XBA", "XBB", "XBC", "XBD", "XCD", "XDR", "XEU", "XFO", "XFU", "XOF", "XPD", "XPF", "XPT", "XRE", "XSU", "XTS", "XUA", "XXX", "YDD", "YER", "YUD", "YUM", "YUN", "YUR", "ZAL", "ZAR", "ZMK", "ZMW", "ZRN", "ZRZ", "ZWD", "ZWL", "ZWR"},
			currencyPositiveSuffix: " ",
			currencyNegativePrefix: "(",
			currencyNegativeSuffix: " )",
			monthsAbbreviated:      []string{"", "яну", "фев", "март", "апр", "май", "юни", "юли", "авг", "сеп", "окт", "ное", "дек"},
			monthsNarrow:           []string{"", "я", "ф", "м", "а", "м", "ю", "ю", "а", "с", "о", "н", "д"},
			monthsWide:             []string{"", "януари", "февруари", "март", "април", "май", "юни", "юли", "август", "септември", "октомври", "ноември", "декември"},
			daysAbbreviated:        []string{"нд", "пн", "вт", "ср", "чт", "пт", "сб"},
			daysNarrow:             []string{"н", "п", "в", "с", "ч", "п", "с"},
			daysShort:              []string{"нд", "пн", "вт", "ср", "чт", "пт", "сб"},
			daysWide:               []string{"неделя", "понеделник", "вторник", "сряда", "четвъртък", "петък", "събота"},
			periodsAbbreviated:     []string{"am", "pm"},
			periodsNarrow:          []string{"am", "pm"},
			periodsWide:            []string{"пр.об.", "сл.об."},
			erasAbbreviated:        []string{"пр.Хр.", "сл.Хр."},
			erasNarrow:             []string{"", ""},
			erasWide:               []string{"преди Христа", "след Христа"},
			timezones:              map[string]string{"ACDT": "Централноавстралийско лятно часово време", "ACST": "Централноавстралийско стандартно време", "ACWDT": "Австралия – западно централно лятно часово време", "ACWST": "Австралия – западно централно стандартно време", "ADT": "Северноамериканско атлантическо лятно часово време", "AEDT": "Източноавстралийско лятно часово време", "AEST": "Източноавстралийско стандартно време", "AKDT": "Аляска – лятно часово време", "AKST": "Аляска – стандартно време", "ARST": "Аржентинско лятно часово време", "ART": "Аржентинско стандартно време", "AST": "Северноамериканско атлантическо стандартно време", "AWDT": "Западноавстралийско лятно часово време", "AWST": "Западноавстралийско стандартно време", "BOT": "Боливийско време", "BT": "Бутанско време", "CAT": "Централноафриканско време", "CDT": "Северноамериканско централно лятно часово време", "CHADT": "Чатъмско лятно часово време", "CHAST": "Чатъмско стандартно време", "CLST": "Чилийско лятно часово време", "CLT": "Чилийско стандартно време", "COST": "Колумбийско лятно часово време", "COT": "Колумбийско стандартно време", "CST": "Северноамериканско централно стандартно време", "ChST": "Чаморско време", "EAT": "Източноафриканско време", "ECT": "Еквадорско време", "EDT": "Северноамериканско източно лятно часово време", "EST": "Северноамериканско източно стандартно време", "GFT": "Френска Гвиана", "GMT": "Средно гринуичко време", "GST": "Персийски залив", "GYT": "Гаяна", "HADT": "Хавайско-алеутско лятно часово време", "HAST": "Хавайско-алеутско стандартно време", "HAT": "Нюфаундлендско лятно часово време", "HECU": "Кубинско лятно часово време", "HEEG": "Източногренландско лятно часово време", "HENOMX": "Северозападно лятно часово мексиканско време", "HEOG": "Западногренландско лятно часово време", "HEPM": "Сен Пиер и Микелон – лятно часово време", "HEPMX": "Мексиканско тихоокеанско лятно часово време", "HKST": "Хонконгско лятно часово време", "HKT": "Хонконгско стандартно време", "HNCU": "Кубинско стандартно време", "HNEG": "Източногренландско стандартно време", "HNNOMX": "Северозападно стандартно мексиканско време", "HNOG": "Западногренландско стандартно време", "HNPM": "Сен Пиер и Микелон – стандартно време", "HNPMX": "Мексиканско тихоокеанско стандартно време", "HNT": "Нюфаундлендско стандартно време", "IST": "Индийско време", "JDT": "Японско лятно часово време", "JST": "Японско стандартно време", "LHDT": "Лорд Хау – лятно часово време", "LHST": "Лорд Хау – стандартно време", "MDT": "Северноамериканско планинско лятно часово време", "MESZ": "Централноевропейско лятно часово време", "MEZ": "Централноевропейско стандартно време", "MST": "Северноамериканско планинско стандартно време", "MYT": "Малайзийско време", "NZDT": "Новозеландско лятно часово време", "NZST": "Новозеландско стандартно време", "OESZ": "Източноевропейско лятно часово време", "OEZ": "Източноевропейско стандартно време", "PDT": "Северноамериканско тихоокеанско лятно часово време", "PST": "Северноамериканско тихоокеанско стандартно време", "SAST": "Южноафриканско време", "SGT": "Сингапурско време", "SRT": "Суринамско време", "TMST": "Туркменистанско лятно часово време", "TMT": "Туркменистанско стандартно време", "UYST": "Уругвайско лятно часово време", "UYT": "Уругвайско стандартно време", "VET": "Венецуелско време", "WARST": "Западноаржентинско лятно часово време", "WART": "Западноаржентинско стандартно време", "WAST": "Западноафриканско лятно часово време", "WAT": "Западноафриканско стандартно време", "WESZ": "Западноевропейско лятно време", "WEZ": "Западноевропейско стандартно време", "WIB": "Западноиндонезийско време", "WIT": "Източноиндонезийско време", "WITA": "Централноиндонезийско време", "∅∅∅": "Бразилско лятно часово време"},

			fnCardinalPluralRule:  fnCardinalPluralRule_0758171f702b5b6024bdf47d25d8166d,
			fnDecimal:             fnDecimal_a78485e7dd32c95f41af4e18420793bf,
			fnFmtAccounting:       fnFmtAccounting_895833c14256127b155b25fc552f5180,
			fnFmtCurrency:         fnFmtCurrency_88fd8698aec1fdcde88908d426b01f78,
			fnFmtDateFull:         fnFmtDateFull_3bb9a5fb6d982f44bb197fafb3f68087,
			fnFmtDateLong:         fnFmtDateLong_b673377c923e43f185728d5b63716bee,
			fnFmtDateMedium:       fnFmtDateMedium_387f50f821f8034478c23ca141a1b991,
			fnFmtDateShort:        fnFmtDateShort_724096485badda99a595db97f2fdcc96,
			fnFmtNumber:           fnFmtNumber_0866206624669dc4f03297eb76a545b2,
			fnFmtPercent:          fnFmtPercent_1c35b3868bf10d0e69b22b2e80c40671,
			fnFmtTimeFull:         fnFmtTimeFull_103caa51aab787e802d47e2174ea5313,
			fnFmtTimeLong:         fnFmtTimeLong_14ec37cb9b88b34ab642f7ee8fd2800b,
			fnFmtTimeMedium:       fnFmtTimeMedium_c3e2f72b9dd7b60e99ec7ed62baf96a4,
			fnFmtTimeShort:        fnFmtTimeShort_d0370e7a739d1d7da91c2071fa2c12c5,
			fnGroup:               fnGroup_5c4b80a5ccdee81467241784ab8fcd56,
			fnLocale:              fnLocale_5a217059c67094defae82f249f55f4c5,
			fnMinus:               fnMinus_8b8229905258388dc16a5e0c270b0488,
			fnMonthAbbreviated:    fnMonthAbbreviated_aa9a9957cd9d056ba078b36a08b17478,
			fnMonthNarrow:         fnMonthNarrow_45916040ecf6fc350894d9e3e6c46dc7,
			fnMonthWide:           fnMonthWide_4c946a7e7581c665e7407df1841810b5,
			fnMonthsAbbreviated:   fnMonthsAbbreviated_181f77804b62232997fae36bd57d6cf7,
			fnMonthsNarrow:        fnMonthsNarrow_75daa2ba82ae9577292175c3f52370cc,
			fnMonthsWide:          fnMonthsWide_0ecf36a8b72255e2fee9467af362e989,
			fnOrdinalPluralRule:   fnOrdinalPluralRule_3355865f05dde9af2a36ba415bea85cb,
			fnPluralsCardinal:     fnPluralsCardinal_85b19cac1fab9f2c2cfb9eb41539aa0e,
			fnPluralsOrdinal:      fnPluralsOrdinal_16a60aa09da9778fa82fe463e83076de,
			fnPluralsRange:        fnPluralsRange_332465bda13eb808b3664fa0500f54ce,
			fnRangePluralRule:     fnRangePluralRule_91a918d93f773c0b7589da5ebb6c4164,
			fnWeekdayAbbreviated:  fnWeekdayAbbreviated_4ffbdfbd2be10e6bd8fb5a542a14664a,
			fnWeekdayNarrow:       fnWeekdayNarrow_e86921b3446df5ea9afe9504cfa20d1a,
			fnWeekdayShort:        fnWeekdayShort_82b231d4f504c6d71c7e495aa35cd3c2,
			fnWeekdayWide:         fnWeekdayWide_ab7e026d8685cefd89c5aeb5df512a9a,
			fnWeekdaysAbbreviated: fnWeekdaysAbbreviated_454a3d7d23c662520a64ae5245d404be,
			fnWeekdaysNarrow:      fnWeekdaysNarrow_d23eb0b7a498c40ce19d1bf231cad524,
			fnWeekdaysShort:       fnWeekdaysShort_eb6ee64d01e314991432b4469790d38b,
			fnWeekdaysWide:        fnWeekdaysWide_5e2bbf75a31e730429c100e8a0bd3ebd,
		}
	}
	translatorFuncs["bm"] = func() locales.Translator {
		return &localen{

			locale:                 "bm",
			pluralsCardinal:        []locales.PluralRule{6},
			pluralsOrdinal:         nil,
			pluralsRange:           nil,
			timeSeparator:          ":",
			currencies:             []string{"ADP", "AED", "AFA", "AFN", "ALK", "ALL", "AMD", "ANG", "AOA", "AOK", "AON", "AOR", "ARA", "ARL", "ARM", "ARP", "ARS", "ATS", "AUD", "AWG", "AZM", "AZN", "BAD", "BAM", "BAN", "BBD", "BDT", "BEC", "BEF", "BEL", "BGL", "BGM", "BGN", "BGO", "BHD", "BIF", "BMD", "BND", "BOB", "BOL", "BOP", "BOV", "BRB", "BRC", "BRE", "BRL", "BRN", "BRR", "BRZ", "BSD", "BTN", "BUK", "BWP", "BYB", "BYN", "BYR", "BZD", "CAD", "CDF", "CHE", "CHF", "CHW", "CLE", "CLF", "CLP", "CNH", "CNX", "CNY", "COP", "COU", "CRC", "CSD", "CSK", "CUC", "CUP", "CVE", "CYP", "CZK", "DDM", "DEM", "DJF", "DKK", "DOP", "DZD", "ECS", "ECV", "EEK", "EGP", "ERN", "ESA", "ESB", "ESP", "ETB", "EUR", "FIM", "FJD", "FKP", "FRF", "GBP", "GEK", "GEL", "GHC", "GHS", "GIP", "GMD", "GNF", "GNS", "GQE", "GRD", "GTQ", "GWE", "GWP", "GYD", "HKD", "HNL", "HRD", "HRK", "HTG", "HUF", "IDR", "IEP", "ILP", "ILR", "ILS", "INR", "IQD", "IRR", "ISJ", "ISK", "ITL", "JMD", "JOD", "JPY", "KES", "KGS", "KHR", "KMF", "KPW", "KRH", "KRO", "KRW", "KWD", "KYD", "KZT", "LAK", "LBP", "LKR", "LRD", "LSL", "LTL", "LTT", "LUC", "LUF", "LUL", "LVL", "LVR", "LYD", "MAD", "MAF", "MCF", "MDC", "MDL", "MGA", "MGF", "MKD", "MKN", "MLF", "MMK", "MNT", "MOP", "MRO", "MRU", "MTL", "MTP", "MUR", "MVP", "MVR", "MWK", "MXN", "MXP", "MXV", "MYR", "MZE", "MZM", "MZN", "NAD", "NGN", "NIC", "NIO", "NLG", "NOK", "NPR", "NZD", "OMR", "PAB", "PEI", "PEN", "PES", "PGK", "PHP", "PKR", "PLN", "PLZ", "PTE", "PYG", "QAR", "RHD", "ROL", "RON", "RSD", "RUB", "RUR", "RWF", "SAR", "SBD", "SCR", "SDD", "SDG", "SDP", "SEK", "SGD", "SHP", "SIT", "SKK", "SLL", "SOS", "SRD", "SRG", "SSP", "STD", "STN", "SUR", "SVC", "SYP", "SZL", "THB", "TJR", "TJS", "TMM", "TMT", "TND", "TOP", "TPE", "TRL", "TRY", "TTD", "TWD", "TZS", "UAH", "UAK", "UGS", "UGX", "USD", "USN", "USS", "UYI", "UYP", "UYU", "UYW", "UZS", "VEB", "VEF", "VES", "VND", "VNN", "VUV", "WST", "XAF", "XAG", "XAU", "XBA", "XBB", "XBC", "XBD", "XCD", "XDR", "XEU", "XFO", "XFU", "XOF", "XPD", "XPF", "XPT", "XRE", "XSU", "XTS", "XUA", "XXX", "YDD", "YER", "YUD", "YUM", "YUN", "YUR", "ZAL", "ZAR", "ZMK", "ZMW", "ZRN", "ZRZ", "ZWD", "ZWL", "ZWR"},
			currencyNegativePrefix: "(",
			currencyNegativeSuffix: ")",
			monthsAbbreviated:      []string{"", "zan", "feb", "mar", "awi", "mɛ", "zuw", "zul", "uti", "sɛt", "ɔku", "now", "des"},
			monthsNarrow:           []string{"", "Z", "F", "M", "A", "M", "Z", "Z", "U", "S", "Ɔ", "N", "D"},
			monthsWide:             []string{"", "zanwuye", "feburuye", "marisi", "awirili", "mɛ", "zuwɛn", "zuluye", "uti", "sɛtanburu", "ɔkutɔburu", "nowanburu", "desanburu"},
			daysAbbreviated:        []string{"kar", "ntɛ", "tar", "ara", "ala", "jum", "sib"},
			daysNarrow:             []string{"K", "N", "T", "A", "A", "J", "S"},
			daysWide:               []string{"kari", "ntɛnɛ", "tarata", "araba", "alamisa", "juma", "sibiri"},
			erasAbbreviated:        []string{"J.-C. ɲɛ", "ni J.-C."},
			erasNarrow:             []string{"", ""},
			erasWide:               []string{"jezu krisiti ɲɛ", "jezu krisiti minkɛ"},
			timezones:              map[string]string{"ACDT": "ACDT", "ACST": "ACST", "ACWDT": "ACWDT", "ACWST": "ACWST", "ADT": "ADT", "AEDT": "AEDT", "AEST": "AEST", "AKDT": "AKDT", "AKST": "AKST", "ARST": "ARST", "ART": "ART", "AST": "AST", "AWDT": "AWDT", "AWST": "AWST", "BOT": "BOT", "BT": "BT", "CAT": "CAT", "CDT": "CDT", "CHADT": "CHADT", "CHAST": "CHAST", "CLST": "CLST", "CLT": "CLT", "COST": "COST", "COT": "COT", "CST": "CST", "ChST": "ChST", "EAT": "EAT", "ECT": "ECT", "EDT": "EDT", "EST": "EST", "GFT": "GFT", "GMT": "GMT", "GST": "GST", "GYT": "GYT", "HADT": "HADT", "HAST": "HAST", "HAT": "HAT", "HECU": "HECU", "HEEG": "HEEG", "HENOMX": "HENOMX", "HEOG": "HEOG", "HEPM": "HEPM", "HEPMX": "HEPMX", "HKST": "HKST", "HKT": "HKT", "HNCU": "HNCU", "HNEG": "HNEG", "HNNOMX": "HNNOMX", "HNOG": "HNOG", "HNPM": "HNPM", "HNPMX": "HNPMX", "HNT": "HNT", "IST": "IST", "JDT": "JDT", "JST": "JST", "LHDT": "LHDT", "LHST": "LHST", "MDT": "MDT", "MESZ": "MESZ", "MEZ": "MEZ", "MST": "MST", "MYT": "MYT", "NZDT": "NZDT", "NZST": "NZST", "OESZ": "OESZ", "OEZ": "OEZ", "PDT": "PDT", "PST": "PST", "SAST": "SAST", "SGT": "SGT", "SRT": "SRT", "TMST": "TMST", "TMT": "TMT", "UYST": "UYST", "UYT": "UYT", "VET": "VET", "WARST": "WARST", "WART": "WART", "WAST": "WAST", "WAT": "WAT", "WESZ": "WESZ", "WEZ": "WEZ", "WIB": "WIB", "WIT": "WIT", "WITA": "WITA", "∅∅∅": "∅∅∅"},

			fnCardinalPluralRule:  fnCardinalPluralRule_18b4522c3f6126d1e01414d5e423288b,
			fnDecimal:             fnDecimal_a78485e7dd32c95f41af4e18420793bf,
			fnFmtAccounting:       fnFmtAccounting_60b3ba42c7301cf18f0e7795b3eeaa75,
			fnFmtCurrency:         fnFmtCurrency_12d8afad3eb872da9d80fb14637f7f61,
			fnFmtDateFull:         fnFmtDateFull_e5aac3b796a648ed7f4aaa501e4e3844,
			fnFmtDateLong:         fnFmtDateLong_506f643cda0514f66d873a9ea99bf639,
			fnFmtDateMedium:       fnFmtDateMedium_5e450105cccbc820e4514899ef73128f,
			fnFmtDateShort:        fnFmtDateShort_222c809496186523124eb16d6c474592,
			fnFmtNumber:           fnFmtNumber_2816fdab36e719be095a370ff42e599f,
			fnFmtPercent:          fnFmtPercent_016773d83796aa19d80b7c33bf377883,
			fnFmtTimeFull:         fnFmtTimeFull_ebdf96de1e47f9043145564c500ef7dc,
			fnFmtTimeLong:         fnFmtTimeLong_987bec4676d3a5de4218e415e123649d,
			fnFmtTimeMedium:       fnFmtTimeMedium_b6f697552cd4965cd1195fe56dc87003,
			fnFmtTimeShort:        fnFmtTimeShort_8ffba4d1a2f04a0a6486853d76cf434b,
			fnGroup:               fnGroup_5c4b80a5ccdee81467241784ab8fcd56,
			fnLocale:              fnLocale_5a217059c67094defae82f249f55f4c5,
			fnMinus:               fnMinus_8b8229905258388dc16a5e0c270b0488,
			fnMonthAbbreviated:    fnMonthAbbreviated_aa9a9957cd9d056ba078b36a08b17478,
			fnMonthNarrow:         fnMonthNarrow_45916040ecf6fc350894d9e3e6c46dc7,
			fnMonthWide:           fnMonthWide_4c946a7e7581c665e7407df1841810b5,
			fnMonthsAbbreviated:   fnMonthsAbbreviated_181f77804b62232997fae36bd57d6cf7,
			fnMonthsNarrow:        fnMonthsNarrow_75daa2ba82ae9577292175c3f52370cc,
			fnMonthsWide:          fnMonthsWide_0ecf36a8b72255e2fee9467af362e989,
			fnOrdinalPluralRule:   fnOrdinalPluralRule_a0e5467912a746c396065750c68e4318,
			fnPluralsCardinal:     fnPluralsCardinal_85b19cac1fab9f2c2cfb9eb41539aa0e,
			fnPluralsOrdinal:      fnPluralsOrdinal_16a60aa09da9778fa82fe463e83076de,
			fnPluralsRange:        fnPluralsRange_332465bda13eb808b3664fa0500f54ce,
			fnRangePluralRule:     fnRangePluralRule_e0f62e2cf3ae7407fb4b54d084341c0b,
			fnWeekdayAbbreviated:  fnWeekdayAbbreviated_4ffbdfbd2be10e6bd8fb5a542a14664a,
			fnWeekdayNarrow:       fnWeekdayNarrow_e86921b3446df5ea9afe9504cfa20d1a,
			fnWeekdayShort:        fnWeekdayShort_82b231d4f504c6d71c7e495aa35cd3c2,
			fnWeekdayWide:         fnWeekdayWide_ab7e026d8685cefd89c5aeb5df512a9a,
			fnWeekdaysAbbreviated: fnWeekdaysAbbreviated_454a3d7d23c662520a64ae5245d404be,
			fnWeekdaysNarrow:      fnWeekdaysNarrow_d23eb0b7a498c40ce19d1bf231cad524,
			fnWeekdaysShort:       fnWeekdaysShort_eb6ee64d01e314991432b4469790d38b,
			fnWeekdaysWide:        fnWeekdaysWide_5e2bbf75a31e730429c100e8a0bd3ebd,
		}
	}
	translatorFuncs["bm_ml"] = func() locales.Translator {
		return &localen{

			locale:                 "bm_ML",
			pluralsCardinal:        []locales.PluralRule{6},
			pluralsOrdinal:         nil,
			pluralsRange:           nil,
			timeSeparator:          ":",
			currencies:             []string{"ADP", "AED", "AFA", "AFN", "ALK", "ALL", "AMD", "ANG", "AOA", "AOK", "AON", "AOR", "ARA", "ARL", "ARM", "ARP", "ARS", "ATS", "AUD", "AWG", "AZM", "AZN", "BAD", "BAM", "BAN", "BBD", "BDT", "BEC", "BEF", "BEL", "BGL", "BGM", "BGN", "BGO", "BHD", "BIF", "BMD", "BND", "BOB", "BOL", "BOP", "BOV", "BRB", "BRC", "BRE", "BRL", "BRN", "BRR", "BRZ", "BSD", "BTN", "BUK", "BWP", "BYB", "BYN", "BYR", "BZD", "CAD", "CDF", "CHE", "CHF", "CHW", "CLE", "CLF", "CLP", "CNH", "CNX", "CNY", "COP", "COU", "CRC", "CSD", "CSK", "CUC", "CUP", "CVE", "CYP", "CZK", "DDM", "DEM", "DJF", "DKK", "DOP", "DZD", "ECS", "ECV", "EEK", "EGP", "ERN", "ESA", "ESB", "ESP", "ETB", "EUR", "FIM", "FJD", "FKP", "FRF", "GBP", "GEK", "GEL", "GHC", "GHS", "GIP", "GMD", "GNF", "GNS", "GQE", "GRD", "GTQ", "GWE", "GWP", "GYD", "HKD", "HNL", "HRD", "HRK", "HTG", "HUF", "IDR", "IEP", "ILP", "ILR", "ILS", "INR", "IQD", "IRR", "ISJ", "ISK", "ITL", "JMD", "JOD", "JPY", "KES", "KGS", "KHR", "KMF", "KPW", "KRH", "KRO", "KRW", "KWD", "KYD", "KZT", "LAK", "LBP", "LKR", "LRD", "LSL", "LTL", "LTT", "LUC", "LUF", "LUL", "LVL", "LVR", "LYD", "MAD", "MAF", "MCF", "MDC", "MDL", "MGA", "MGF", "MKD", "MKN", "MLF", "MMK", "MNT", "MOP", "MRO", "MRU", "MTL", "MTP", "MUR", "MVP", "MVR", "MWK", "MXN", "MXP", "MXV", "MYR", "MZE", "MZM", "MZN", "NAD", "NGN", "NIC", "NIO", "NLG", "NOK", "NPR", "NZD", "OMR", "PAB", "PEI", "PEN", "PES", "PGK", "PHP", "PKR", "PLN", "PLZ", "PTE", "PYG", "QAR", "RHD", "ROL", "RON", "RSD", "RUB", "RUR", "RWF", "SAR", "SBD", "SCR", "SDD", "SDG", "SDP", "SEK", "SGD", "SHP", "SIT", "SKK", "SLL", "SOS", "SRD", "SRG", "SSP", "STD", "STN", "SUR", "SVC", "SYP", "SZL", "THB", "TJR", "TJS", "TMM", "TMT", "TND", "TOP", "TPE", "TRL", "TRY", "TTD", "TWD", "TZS", "UAH", "UAK", "UGS", "UGX", "USD", "USN", "USS", "UYI", "UYP", "UYU", "UYW", "UZS", "VEB", "VEF", "VES", "VND", "VNN", "VUV", "WST", "XAF", "XAG", "XAU", "XBA", "XBB", "XBC", "XBD", "XCD", "XDR", "XEU", "XFO", "XFU", "XOF", "XPD", "XPF", "XPT", "XRE", "XSU", "XTS", "XUA", "XXX", "YDD", "YER", "YUD", "YUM", "YUN", "YUR", "ZAL", "ZAR", "ZMK", "ZMW", "ZRN", "ZRZ", "ZWD", "ZWL", "ZWR"},
			currencyNegativePrefix: "(",
			currencyNegativeSuffix: ")",
			monthsAbbreviated:      []string{"", "zan", "feb", "mar", "awi", "mɛ", "zuw", "zul", "uti", "sɛt", "ɔku", "now", "des"},
			monthsNarrow:           []string{"", "Z", "F", "M", "A", "M", "Z", "Z", "U", "S", "Ɔ", "N", "D"},
			monthsWide:             []string{"", "zanwuye", "feburuye", "marisi", "awirili", "mɛ", "zuwɛn", "zuluye", "uti", "sɛtanburu", "ɔkutɔburu", "nowanburu", "desanburu"},
			daysAbbreviated:        []string{"kar", "ntɛ", "tar", "ara", "ala", "jum", "sib"},
			daysNarrow:             []string{"K", "N", "T", "A", "A", "J", "S"},
			daysWide:               []string{"kari", "ntɛnɛ", "tarata", "araba", "alamisa", "juma", "sibiri"},
			erasAbbreviated:        []string{"J.-C. ɲɛ", "ni J.-C."},
			erasNarrow:             []string{"", ""},
			erasWide:               []string{"jezu krisiti ɲɛ", "jezu krisiti minkɛ"},
			timezones:              map[string]string{"ACDT": "ACDT", "ACST": "ACST", "ACWDT": "ACWDT", "ACWST": "ACWST", "ADT": "ADT", "AEDT": "AEDT", "AEST": "AEST", "AKDT": "AKDT", "AKST": "AKST", "ARST": "ARST", "ART": "ART", "AST": "AST", "AWDT": "AWDT", "AWST": "AWST", "BOT": "BOT", "BT": "BT", "CAT": "CAT", "CDT": "CDT", "CHADT": "CHADT", "CHAST": "CHAST", "CLST": "CLST", "CLT": "CLT", "COST": "COST", "COT": "COT", "CST": "CST", "ChST": "ChST", "EAT": "EAT", "ECT": "ECT", "EDT": "EDT", "EST": "EST", "GFT": "GFT", "GMT": "GMT", "GST": "GST", "GYT": "GYT", "HADT": "HADT", "HAST": "HAST", "HAT": "HAT", "HECU": "HECU", "HEEG": "HEEG", "HENOMX": "HENOMX", "HEOG": "HEOG", "HEPM": "HEPM", "HEPMX": "HEPMX", "HKST": "HKST", "HKT": "HKT", "HNCU": "HNCU", "HNEG": "HNEG", "HNNOMX": "HNNOMX", "HNOG": "HNOG", "HNPM": "HNPM", "HNPMX": "HNPMX", "HNT": "HNT", "IST": "IST", "JDT": "JDT", "JST": "JST", "LHDT": "LHDT", "LHST": "LHST", "MDT": "MDT", "MESZ": "MESZ", "MEZ": "MEZ", "MST": "MST", "MYT": "MYT", "NZDT": "NZDT", "NZST": "NZST", "OESZ": "OESZ", "OEZ": "OEZ", "PDT": "PDT", "PST": "PST", "SAST": "SAST", "SGT": "SGT", "SRT": "SRT", "TMST": "TMST", "TMT": "TMT", "UYST": "UYST", "UYT": "UYT", "VET": "VET", "WARST": "WARST", "WART": "WART", "WAST": "WAST", "WAT": "WAT", "WESZ": "WESZ", "WEZ": "WEZ", "WIB": "WIB", "WIT": "WIT", "WITA": "WITA", "∅∅∅": "∅∅∅"},

			fnCardinalPluralRule:  fnCardinalPluralRule_18b4522c3f6126d1e01414d5e423288b,
			fnDecimal:             fnDecimal_a78485e7dd32c95f41af4e18420793bf,
			fnFmtAccounting:       fnFmtAccounting_60b3ba42c7301cf18f0e7795b3eeaa75,
			fnFmtCurrency:         fnFmtCurrency_12d8afad3eb872da9d80fb14637f7f61,
			fnFmtDateFull:         fnFmtDateFull_e5aac3b796a648ed7f4aaa501e4e3844,
			fnFmtDateLong:         fnFmtDateLong_506f643cda0514f66d873a9ea99bf639,
			fnFmtDateMedium:       fnFmtDateMedium_5e450105cccbc820e4514899ef73128f,
			fnFmtDateShort:        fnFmtDateShort_222c809496186523124eb16d6c474592,
			fnFmtNumber:           fnFmtNumber_2816fdab36e719be095a370ff42e599f,
			fnFmtPercent:          fnFmtPercent_016773d83796aa19d80b7c33bf377883,
			fnFmtTimeFull:         fnFmtTimeFull_ebdf96de1e47f9043145564c500ef7dc,
			fnFmtTimeLong:         fnFmtTimeLong_987bec4676d3a5de4218e415e123649d,
			fnFmtTimeMedium:       fnFmtTimeMedium_b6f697552cd4965cd1195fe56dc87003,
			fnFmtTimeShort:        fnFmtTimeShort_8ffba4d1a2f04a0a6486853d76cf434b,
			fnGroup:               fnGroup_5c4b80a5ccdee81467241784ab8fcd56,
			fnLocale:              fnLocale_5a217059c67094defae82f249f55f4c5,
			fnMinus:               fnMinus_8b8229905258388dc16a5e0c270b0488,
			fnMonthAbbreviated:    fnMonthAbbreviated_aa9a9957cd9d056ba078b36a08b17478,
			fnMonthNarrow:         fnMonthNarrow_45916040ecf6fc350894d9e3e6c46dc7,
			fnMonthWide:           fnMonthWide_4c946a7e7581c665e7407df1841810b5,
			fnMonthsAbbreviated:   fnMonthsAbbreviated_181f77804b62232997fae36bd57d6cf7,
			fnMonthsNarrow:        fnMonthsNarrow_75daa2ba82ae9577292175c3f52370cc,
			fnMonthsWide:          fnMonthsWide_0ecf36a8b72255e2fee9467af362e989,
			fnOrdinalPluralRule:   fnOrdinalPluralRule_a0e5467912a746c396065750c68e4318,
			fnPluralsCardinal:     fnPluralsCardinal_85b19cac1fab9f2c2cfb9eb41539aa0e,
			fnPluralsOrdinal:      fnPluralsOrdinal_16a60aa09da9778fa82fe463e83076de,
			fnPluralsRange:        fnPluralsRange_332465bda13eb808b3664fa0500f54ce,
			fnRangePluralRule:     fnRangePluralRule_e0f62e2cf3ae7407fb4b54d084341c0b,
			fnWeekdayAbbreviated:  fnWeekdayAbbreviated_4ffbdfbd2be10e6bd8fb5a542a14664a,
			fnWeekdayNarrow:       fnWeekdayNarrow_e86921b3446df5ea9afe9504cfa20d1a,
			fnWeekdayShort:        fnWeekdayShort_82b231d4f504c6d71c7e495aa35cd3c2,
			fnWeekdayWide:         fnWeekdayWide_ab7e026d8685cefd89c5aeb5df512a9a,
			fnWeekdaysAbbreviated: fnWeekdaysAbbreviated_454a3d7d23c662520a64ae5245d404be,
			fnWeekdaysNarrow:      fnWeekdaysNarrow_d23eb0b7a498c40ce19d1bf231cad524,
			fnWeekdaysShort:       fnWeekdaysShort_eb6ee64d01e314991432b4469790d38b,
			fnWeekdaysWide:        fnWeekdaysWide_5e2bbf75a31e730429c100e8a0bd3ebd,
		}
	}
	translatorFuncs["bn"] = func() locales.Translator {
		return &localen{

			locale:             "bn",
			pluralsCardinal:    []locales.PluralRule{2, 6},
			pluralsOrdinal:     []locales.PluralRule{2, 3, 4, 5, 6},
			pluralsRange:       []locales.PluralRule{2, 6},
			decimal:            ".",
			group:              ",",
			minus:              "-",
			percent:            "%",
			perMille:           "‰",
			timeSeparator:      ":",
			inifinity:          "∞",
			currencies:         []string{"ADP", "AED", "AFA", "AFN", "ALK", "ALL", "AMD", "ANG", "AOA", "AOK", "AON", "AOR", "ARA", "ARL", "ARM", "ARP", "ARS", "ATS", "A$", "AWG", "AZM", "AZN", "BAD", "BAM", "BAN", "BBD", "৳", "BEC", "BEF", "BEL", "BGL", "BGM", "BGN", "BGO", "BHD", "BIF", "BMD", "BND", "BOB", "BOL", "BOP", "BOV", "BRB", "BRC", "BRE", "R$", "BRN", "BRR", "BRZ", "BSD", "BTN", "BUK", "BWP", "BYB", "BYN", "BYR", "BZD", "CA$", "CDF", "CHE", "CHF", "CHW", "CLE", "CLF", "CLP", "CNH", "CNX", "CN¥", "COP", "COU", "CRC", "CSD", "CSK", "CUC", "CUP", "CVE", "CYP", "CZK", "DDM", "DEM", "DJF", "DKK", "DOP", "DZD", "ECS", "ECV", "EEK", "EGP", "ERN", "ESA", "ESB", "ESP", "ETB", "€", "FIM", "FJD", "FKP", "FRF", "£", "GEK", "GEL", "GHC", "GHS", "GIP", "GMD", "GNF", "GNS", "GQE", "GRD", "GTQ", "GWE", "GWP", "GYD", "HK$", "HNL", "HRD", "HRK", "HTG", "HUF", "IDR", "IEP", "ILP", "ILR", "₪", "₹", "IQD", "IRR", "ISJ", "ISK", "ITL", "JMD", "JOD", "JP¥", "KES", "KGS", "KHR", "KMF", "KPW", "KRH", "KRO", "₩", "KWD", "KYD", "KZT", "LAK", "LBP", "LKR", "LRD", "LSL", "LTL", "LTT", "LUC", "LUF", "LUL", "LVL", "LVR", "LYD", "MAD", "MAF", "MCF", "MDC", "MDL", "MGA", "MGF", "MKD", "MKN", "MLF", "MMK", "MNT", "MOP", "MRO", "MRU", "MTL", "MTP", "MUR", "MVP", "MVR", "MWK", "MX$", "MXP", "MXV", "MYR", "MZE", "MZM", "MZN", "NAD", "NGN", "NIC", "NIO", "NLG", "NOK", "NPR", "NZ$", "OMR", "PAB", "PEI", "PEN", "PES", "PGK", "PHP", "PKR", "PLN", "PLZ", "PTE", "PYG", "QAR", "RHD", "ROL", "RON", "RSD", "RUB", "RUR", "RWF", "SAR", "SBD", "SCR", "SDD", "SDG", "SDP", "SEK", "SGD", "SHP", "SIT", "SKK", "SLL", "SOS", "SRD", "SRG", "SSP", "STD", "STN", "SUR", "SVC", "SYP", "SZL", "฿", "TJR", "TJS", "TMM", "TMT", "TND", "TOP", "TPE", "TRL", "TRY", "TTD", "NT$", "TZS", "UAH", "UAK", "UGS", "UGX", "US$", "USN", "USS", "UYI", "UYP", "UYU", "UYW", "UZS", "VEB", "VEF", "VES", "₫", "VNN", "VUV", "WST", "FCFA", "XAG", "XAU", "XBA", "XBB", "XBC", "XBD", "EC$", "XDR", "XEU", "XFO", "XFU", "CFA", "XPD", "CFPF", "XPT", "XRE", "XSU", "XTS", "XUA", "XXX", "YDD", "YER", "YUD", "YUM", "YUN", "YUR", "ZAL", "ZAR", "ZMK", "ZMW", "ZRN", "ZRZ", "ZWD", "ZWL", "ZWR"},
			monthsAbbreviated:  []string{"", "জানু", "ফেব", "মার্চ", "এপ্রিল", "মে", "জুন", "জুলাই", "আগস্ট", "সেপ্টেম্বর", "অক্টোবর", "নভেম্বর", "ডিসেম্বর"},
			monthsNarrow:       []string{"", "জা", "ফে", "মা", "এ", "মে", "জুন", "জু", "আ", "সে", "অ", "ন", "ডি"},
			monthsWide:         []string{"", "জানুয়ারী", "ফেব্রুয়ারী", "মার্চ", "এপ্রিল", "মে", "জুন", "জুলাই", "আগস্ট", "সেপ্টেম্বর", "অক্টোবর", "নভেম্বর", "ডিসেম্বর"},
			daysAbbreviated:    []string{"রবি", "সোম", "মঙ্গল", "বুধ", "বৃহস্পতি", "শুক্র", "শনি"},
			daysNarrow:         []string{"র", "সো", "ম", "বু", "বৃ", "শু", "শ"},
			daysShort:          []string{"রঃ", "সোঃ", "মঃ", "বুঃ", "বৃঃ", "শুঃ", "শনি"},
			daysWide:           []string{"রবিবার", "সোমবার", "মঙ্গলবার", "বুধবার", "বৃহস্পতিবার", "শুক্রবার", "শনিবার"},
			periodsAbbreviated: []string{"AM", "PM"},
			periodsNarrow:      []string{"AM", "PM"},
			periodsWide:        []string{"AM", "PM"},
			erasAbbreviated:    []string{"খ্রিস্টপূর্ব", "খৃষ্টাব্দ"},
			erasNarrow:         []string{"", ""},
			erasWide:           []string{"খ্রিস্টপূর্ব", "খ্রীষ্টাব্দ"},
			timezones:          map[string]string{"ACDT": "অস্ট্রেলীয় কেন্দ্রীয় দিবালোক সময়", "ACST": "অস্ট্রেলীয় কেন্দ্রীয় মানক সময়", "ACWDT": "অস্ট্রেলীয় কেন্দ্রীয় পশ্চিমি দিবালোক সময়", "ACWST": "অস্ট্রেলীয় কেন্দ্রীয় পশ্চিমি মানক সময়", "ADT": "অতলান্তিক দিবালোক সময়", "AEDT": "অস্ট্রেলীয় পূর্ব দিবালোক সময়", "AEST": "অস্ট্রেলীয় পূর্ব মানক সময়", "AKDT": "আলাস্কা দিবালোক সময়", "AKST": "আলাস্কা মানক সময়", "ARST": "আর্জেন্টিনা গ্রীষ্মকালীন সময়", "ART": "আর্জেন্টিনা মানক সময়", "AST": "অতলান্তিক মানক সময়", "AWDT": "অস্ট্রেলীয় পশ্চিমি দিবালোক সময়", "AWST": "অস্ট্রেলীয় পশ্চিমি মানক সময়", "BOT": "বোলিভিয়া সময়", "BT": "ভুটান সময়", "CAT": "মধ্য আফ্রিকা সময়", "CDT": "কেন্দ্রীয় দিবালোক সময়", "CHADT": "চ্যাথাম দিবালোক সময়", "CHAST": "চ্যাথাম মানক সময়", "CLST": "চিলি গ্রীষ্মকালীন সময়", "CLT": "চিলি মানক সময়", "COST": "কোলোম্বিয়া গ্রীষ্মকালীন সময়", "COT": "কোলোম্বিয়া মানক সময়", "CST": "কেন্দ্রীয় মানক সময়", "ChST": "চামেরো মানক সময়", "EAT": "পূর্ব আফ্রিকা সময়", "ECT": "ইকুয়েডর সময়", "EDT": "পূর্বাঞ্চলের দিবালোক সময়", "EST": "পূর্বাঞ্চলের প্রমাণ সময়", "GFT": "ফরাসি গায়ানা সময়", "GMT": "গ্রীনিচ মিন টাইম", "GST": "উপসাগরীয় মানক সময়", "GYT": "গুয়ানা সময়", "HADT": "হাওয়াই-আলেউত দিবালোক সময়", "HAST": "হাওয়াই-আলেউত মানক সময়", "HAT": "নিউফাউন্ডল্যান্ড দিবালোক সময়", "HECU": "কিউবা দিবালোক সময়", "HEEG": "পূর্ব গ্রীনল্যান্ড গ্রীষ্মকালীন সময়", "HENOMX": "উত্তরপশ্চিম মেক্সিকোর দিনের সময়", "HEOG": "পশ্চিম গ্রীনল্যান্ড গ্রীষ্মকালীন সময়", "HEPM": "সেন্ট পিয়ের ও মিকেলন দিবালোক সময়", "HEPMX": "মেক্সিকান প্রশান্ত মহাসাগরীয় দিবালোক সময়", "HKST": "হং কং গ্রীষ্মকালীন সময়", "HKT": "হং কং মানক সময়", "HNCU": "কিউবা মানক সময়", "HNEG": "পূর্ব গ্রীনল্যান্ড মানক সময়", "HNNOMX": "উত্তরপশ্চিম মেক্সিকোর মানক সময়", "HNOG": "পশ্চিম গ্রীনল্যান্ড মানক সময়", "HNPM": "সেন্ট পিয়ের ও মিকেলন মানক সময়", "HNPMX": "মেক্সিকান প্রশান্ত মহসাগরীয় মানক সময়", "HNT": "নিউফাউন্ডল্যান্ড মানক সময়", "IST": "ভারতীয় মানক সময়", "JDT": "জাপান দিবালোক সময়", "JST": "জাপান মানক সময়", "LHDT": "লর্ড হাওয়ে দিবালোক মসয়", "LHST": "লর্ড হাওয়ে মানক মসয়", "MDT": "পার্বত্য অঞ্চলের দিনের সময়", "MESZ": "মধ্য ইউরোপীয় গ্রীষ্মকালীন সময়", "MEZ": "মধ্য ইউরোপীয় মানক সময়", "MST": "পার্বত্য অঞ্চলের প্রমাণ সময়", "MYT": "মালয়েশিয়া সময়", "NZDT": "নিউজিল্যান্ড দিবালোক সময়", "NZST": "নিউজিল্যান্ড মানক সময়", "OESZ": "পূর্ব ইউরোপীয় গ্রীষ্মকালীন সময়", "OEZ": "পূর্ব ইউরোপীয় মানক সময়", "PDT": "প্রশান্ত মহাসাগরীয় অঞ্চলের দিনের সময়", "PST": "প্রশান্ত মহাসাগরীয় অঞ্চলের মানক সময়", "SAST": "দক্ষিণ আফ্রিকা মানক সময়", "SGT": "সিঙ্গাপুর মানক সময়", "SRT": "সুরিনাম সময়", "TMST": "তুর্কমেনিস্তান গ্রীষ্মকালীন সময়", "TMT": "তুর্কমেনিস্তান মানক সময়", "UYST": "উরুগুয়ে গ্রীষ্মকালীন সময়", "UYT": "উরুগুয়ে মানক সময়", "VET": "ভেনেজুয়েলা সময়", "WARST": "পশ্চিমি আর্জেনটিনা গ্রীষ্মকালীন সময়", "WART": "পশ্চিমি আর্জেনটিনার প্রমাণ সময়", "WAST": "পশ্চিম আফ্রিকা গ্রীষ্মকালীন সময়", "WAT": "পশ্চিম আফ্রিকা মানক সময়", "WESZ": "পশ্চিম ইউরোপীয় গ্রীষ্মকালীন সময়", "WEZ": "পশ্চিম ইউরোপীয় মানক সময়", "WIB": "পশ্চিমী ইন্দোনেশিয়া সময়", "WIT": "পূর্ব ইন্দোনেশিয়া সময়", "WITA": "কেন্দ্রীয় ইন্দোনেশিয়া সময়", "∅∅∅": "ব্রাসিলিয়া গ্রীষ্মকালীন সময়"},

			fnCardinalPluralRule:  fnCardinalPluralRule_75ab0b9c6a421f5e6ca85392796c18cc,
			fnDecimal:             fnDecimal_a78485e7dd32c95f41af4e18420793bf,
			fnFmtAccounting:       fnFmtAccounting_1df869b66b1bebb824de5401f039b55a,
			fnFmtCurrency:         fnFmtCurrency_ac4758b65e3186b6295da12d015494cf,
			fnFmtDateFull:         fnFmtDateFull_bd1b45bc043b6b4e8c3b831b9263891b,
			fnFmtDateLong:         fnFmtDateLong_a234d460b585eebc392634bc08485ebd,
			fnFmtDateMedium:       fnFmtDateMedium_5e450105cccbc820e4514899ef73128f,
			fnFmtDateShort:        fnFmtDateShort_f44877b6023a2d0fb0de41f9e2966ad0,
			fnFmtNumber:           fnFmtNumber_d7ae7636100e1f19a61ae0ac52b51e8c,
			fnFmtPercent:          fnFmtPercent_1c35b3868bf10d0e69b22b2e80c40671,
			fnFmtTimeFull:         fnFmtTimeFull_37fe4deeee789852cc196a6a1a2f0ccc,
			fnFmtTimeLong:         fnFmtTimeLong_4429ef4fb58a2a9c4d7d5132fd16ecbf,
			fnFmtTimeMedium:       fnFmtTimeMedium_8ef07f6477b7a4944577d4e5392ff21b,
			fnFmtTimeShort:        fnFmtTimeShort_8288b817c5c0216c9815524c71c9e0b4,
			fnGroup:               fnGroup_5c4b80a5ccdee81467241784ab8fcd56,
			fnLocale:              fnLocale_5a217059c67094defae82f249f55f4c5,
			fnMinus:               fnMinus_8b8229905258388dc16a5e0c270b0488,
			fnMonthAbbreviated:    fnMonthAbbreviated_aa9a9957cd9d056ba078b36a08b17478,
			fnMonthNarrow:         fnMonthNarrow_45916040ecf6fc350894d9e3e6c46dc7,
			fnMonthWide:           fnMonthWide_4c946a7e7581c665e7407df1841810b5,
			fnMonthsAbbreviated:   fnMonthsAbbreviated_181f77804b62232997fae36bd57d6cf7,
			fnMonthsNarrow:        fnMonthsNarrow_75daa2ba82ae9577292175c3f52370cc,
			fnMonthsWide:          fnMonthsWide_0ecf36a8b72255e2fee9467af362e989,
			fnOrdinalPluralRule:   fnOrdinalPluralRule_2d950970290e57f43f401dd367ad94dc,
			fnPluralsCardinal:     fnPluralsCardinal_85b19cac1fab9f2c2cfb9eb41539aa0e,
			fnPluralsOrdinal:      fnPluralsOrdinal_16a60aa09da9778fa82fe463e83076de,
			fnPluralsRange:        fnPluralsRange_332465bda13eb808b3664fa0500f54ce,
			fnRangePluralRule:     fnRangePluralRule_f6915080a9290ab0c1dd0a3b010cbce8,
			fnWeekdayAbbreviated:  fnWeekdayAbbreviated_4ffbdfbd2be10e6bd8fb5a542a14664a,
			fnWeekdayNarrow:       fnWeekdayNarrow_e86921b3446df5ea9afe9504cfa20d1a,
			fnWeekdayShort:        fnWeekdayShort_82b231d4f504c6d71c7e495aa35cd3c2,
			fnWeekdayWide:         fnWeekdayWide_ab7e026d8685cefd89c5aeb5df512a9a,
			fnWeekdaysAbbreviated: fnWeekdaysAbbreviated_454a3d7d23c662520a64ae5245d404be,
			fnWeekdaysNarrow:      fnWeekdaysNarrow_d23eb0b7a498c40ce19d1bf231cad524,
			fnWeekdaysShort:       fnWeekdaysShort_eb6ee64d01e314991432b4469790d38b,
			fnWeekdaysWide:        fnWeekdaysWide_5e2bbf75a31e730429c100e8a0bd3ebd,
		}
	}
	translatorFuncs["bn_bd"] = func() locales.Translator {
		return &localen{

			locale:             "bn_BD",
			pluralsCardinal:    []locales.PluralRule{2, 6},
			pluralsOrdinal:     []locales.PluralRule{2, 3, 4, 5, 6},
			pluralsRange:       []locales.PluralRule{2, 6},
			decimal:            ".",
			group:              ",",
			minus:              "-",
			percent:            "%",
			perMille:           "‰",
			timeSeparator:      ":",
			inifinity:          "∞",
			currencies:         []string{"ADP", "AED", "AFA", "AFN", "ALK", "ALL", "AMD", "ANG", "AOA", "AOK", "AON", "AOR", "ARA", "ARL", "ARM", "ARP", "ARS", "ATS", "AUD", "AWG", "AZM", "AZN", "BAD", "BAM", "BAN", "BBD", "BDT", "BEC", "BEF", "BEL", "BGL", "BGM", "BGN", "BGO", "BHD", "BIF", "BMD", "BND", "BOB", "BOL", "BOP", "BOV", "BRB", "BRC", "BRE", "BRL", "BRN", "BRR", "BRZ", "BSD", "BTN", "BUK", "BWP", "BYB", "BYN", "BYR", "BZD", "CAD", "CDF", "CHE", "CHF", "CHW", "CLE", "CLF", "CLP", "CNH", "CNX", "CNY", "COP", "COU", "CRC", "CSD", "CSK", "CUC", "CUP", "CVE", "CYP", "CZK", "DDM", "DEM", "DJF", "DKK", "DOP", "DZD", "ECS", "ECV", "EEK", "EGP", "ERN", "ESA", "ESB", "ESP", "ETB", "EUR", "FIM", "FJD", "FKP", "FRF", "GBP", "GEK", "GEL", "GHC", "GHS", "GIP", "GMD", "GNF", "GNS", "GQE", "GRD", "GTQ", "GWE", "GWP", "GYD", "HKD", "HNL", "HRD", "HRK", "HTG", "HUF", "IDR", "IEP", "ILP", "ILR", "ILS", "INR", "IQD", "IRR", "ISJ", "ISK", "ITL", "JMD", "JOD", "JPY", "KES", "KGS", "KHR", "KMF", "KPW", "KRH", "KRO", "KRW", "KWD", "KYD", "KZT", "LAK", "LBP", "LKR", "LRD", "LSL", "LTL", "LTT", "LUC", "LUF", "LUL", "LVL", "LVR", "LYD", "MAD", "MAF", "MCF", "MDC", "MDL", "MGA", "MGF", "MKD", "MKN", "MLF", "MMK", "MNT", "MOP", "MRO", "MRU", "MTL", "MTP", "MUR", "MVP", "MVR", "MWK", "MXN", "MXP", "MXV", "MYR", "MZE", "MZM", "MZN", "NAD", "NGN", "NIC", "NIO", "NLG", "NOK", "NPR", "NZD", "OMR", "PAB", "PEI", "PEN", "PES", "PGK", "PHP", "PKR", "PLN", "PLZ", "PTE", "PYG", "QAR", "RHD", "ROL", "RON", "RSD", "RUB", "RUR", "RWF", "SAR", "SBD", "SCR", "SDD", "SDG", "SDP", "SEK", "SGD", "SHP", "SIT", "SKK", "SLL", "SOS", "SRD", "SRG", "SSP", "STD", "STN", "SUR", "SVC", "SYP", "SZL", "THB", "TJR", "TJS", "TMM", "TMT", "TND", "TOP", "TPE", "TRL", "TRY", "TTD", "TWD", "TZS", "UAH", "UAK", "UGS", "UGX", "USD", "USN", "USS", "UYI", "UYP", "UYU", "UYW", "UZS", "VEB", "VEF", "VES", "VND", "VNN", "VUV", "WST", "XAF", "XAG", "XAU", "XBA", "XBB", "XBC", "XBD", "XCD", "XDR", "XEU", "XFO", "XFU", "XOF", "XPD", "XPF", "XPT", "XRE", "XSU", "XTS", "XUA", "XXX", "YDD", "YER", "YUD", "YUM", "YUN", "YUR", "ZAL", "ZAR", "ZMK", "ZMW", "ZRN", "ZRZ", "ZWD", "ZWL", "ZWR"},
			monthsAbbreviated:  []string{"", "জানু", "ফেব", "মার্চ", "এপ্রিল", "মে", "জুন", "জুলাই", "আগস্ট", "সেপ্টেম্বর", "অক্টোবর", "নভেম্বর", "ডিসেম্বর"},
			monthsNarrow:       []string{"", "জা", "ফে", "মা", "এ", "মে", "জুন", "জু", "আ", "সে", "অ", "ন", "ডি"},
			monthsWide:         []string{"", "জানুয়ারী", "ফেব্রুয়ারী", "মার্চ", "এপ্রিল", "মে", "জুন", "জুলাই", "আগস্ট", "সেপ্টেম্বর", "অক্টোবর", "নভেম্বর", "ডিসেম্বর"},
			daysAbbreviated:    []string{"রবি", "সোম", "মঙ্গল", "বুধ", "বৃহস্পতি", "শুক্র", "শনি"},
			daysNarrow:         []string{"র", "সো", "ম", "বু", "বৃ", "শু", "শ"},
			daysShort:          []string{"রঃ", "সোঃ", "মঃ", "বুঃ", "বৃঃ", "শুঃ", "শনি"},
			daysWide:           []string{"রবিবার", "সোমবার", "মঙ্গলবার", "বুধবার", "বৃহস্পতিবার", "শুক্রবার", "শনিবার"},
			periodsAbbreviated: []string{"AM", "PM"},
			periodsNarrow:      []string{"AM", "PM"},
			periodsWide:        []string{"AM", "PM"},
			erasAbbreviated:    []string{"খ্রিস্টপূর্ব", "খৃষ্টাব্দ"},
			erasNarrow:         []string{"", ""},
			erasWide:           []string{"খ্রিস্টপূর্ব", "খ্রীষ্টাব্দ"},
			timezones:          map[string]string{"ACDT": "অস্ট্রেলীয় কেন্দ্রীয় দিবালোক সময়", "ACST": "অস্ট্রেলীয় কেন্দ্রীয় মানক সময়", "ACWDT": "অস্ট্রেলীয় কেন্দ্রীয় পশ্চিমি দিবালোক সময়", "ACWST": "অস্ট্রেলীয় কেন্দ্রীয় পশ্চিমি মানক সময়", "ADT": "অতলান্তিক দিবালোক সময়", "AEDT": "অস্ট্রেলীয় পূর্ব দিবালোক সময়", "AEST": "অস্ট্রেলীয় পূর্ব মানক সময়", "AKDT": "আলাস্কা দিবালোক সময়", "AKST": "আলাস্কা মানক সময়", "ARST": "আর্জেন্টিনা গ্রীষ্মকালীন সময়", "ART": "আর্জেন্টিনা মানক সময়", "AST": "অতলান্তিক মানক সময়", "AWDT": "অস্ট্রেলীয় পশ্চিমি দিবালোক সময়", "AWST": "অস্ট্রেলীয় পশ্চিমি মানক সময়", "BOT": "বোলিভিয়া সময়", "BT": "ভুটান সময়", "CAT": "মধ্য আফ্রিকা সময়", "CDT": "কেন্দ্রীয় দিবালোক সময়", "CHADT": "চ্যাথাম দিবালোক সময়", "CHAST": "চ্যাথাম মানক সময়", "CLST": "চিলি গ্রীষ্মকালীন সময়", "CLT": "চিলি মানক সময়", "COST": "কোলোম্বিয়া গ্রীষ্মকালীন সময়", "COT": "কোলোম্বিয়া মানক সময়", "CST": "কেন্দ্রীয় মানক সময়", "ChST": "চামেরো মানক সময়", "EAT": "পূর্ব আফ্রিকা সময়", "ECT": "ইকুয়েডর সময়", "EDT": "পূর্বাঞ্চলের দিবালোক সময়", "EST": "পূর্বাঞ্চলের প্রমাণ সময়", "GFT": "ফরাসি গায়ানা সময়", "GMT": "গ্রীনিচ মিন টাইম", "GST": "উপসাগরীয় মানক সময়", "GYT": "গুয়ানা সময়", "HADT": "হাওয়াই-আলেউত দিবালোক সময়", "HAST": "হাওয়াই-আলেউত মানক সময়", "HAT": "নিউফাউন্ডল্যান্ড দিবালোক সময়", "HECU": "কিউবা দিবালোক সময়", "HEEG": "পূর্ব গ্রীনল্যান্ড গ্রীষ্মকালীন সময়", "HENOMX": "উত্তরপশ্চিম মেক্সিকোর দিনের সময়", "HEOG": "পশ্চিম গ্রীনল্যান্ড গ্রীষ্মকালীন সময়", "HEPM": "সেন্ট পিয়ের ও মিকেলন দিবালোক সময়", "HEPMX": "মেক্সিকান প্রশান্ত মহাসাগরীয় দিবালোক সময়", "HKST": "হং কং গ্রীষ্মকালীন সময়", "HKT": "হং কং মানক সময়", "HNCU": "কিউবা মানক সময়", "HNEG": "পূর্ব গ্রীনল্যান্ড মানক সময়", "HNNOMX": "উত্তরপশ্চিম মেক্সিকোর মানক সময়", "HNOG": "পশ্চিম গ্রীনল্যান্ড মানক সময়", "HNPM": "সেন্ট পিয়ের ও মিকেলন মানক সময়", "HNPMX": "মেক্সিকান প্রশান্ত মহসাগরীয় মানক সময়", "HNT": "নিউফাউন্ডল্যান্ড মানক সময়", "IST": "ভারতীয় মানক সময়", "JDT": "জাপান দিবালোক সময়", "JST": "জাপান মানক সময়", "LHDT": "লর্ড হাওয়ে দিবালোক মসয়", "LHST": "লর্ড হাওয়ে মানক মসয়", "MDT": "পার্বত্য অঞ্চলের দিনের সময়", "MESZ": "মধ্য ইউরোপীয় গ্রীষ্মকালীন সময়", "MEZ": "মধ্য ইউরোপীয় মানক সময়", "MST": "পার্বত্য অঞ্চলের প্রমাণ সময়", "MYT": "মালয়েশিয়া সময়", "NZDT": "নিউজিল্যান্ড দিবালোক সময়", "NZST": "নিউজিল্যান্ড মানক সময়", "OESZ": "পূর্ব ইউরোপীয় গ্রীষ্মকালীন সময়", "OEZ": "পূর্ব ইউরোপীয় মানক সময়", "PDT": "প্রশান্ত মহাসাগরীয় অঞ্চলের দিনের সময়", "PST": "প্রশান্ত মহাসাগরীয় অঞ্চলের মানক সময়", "SAST": "দক্ষিণ আফ্রিকা মানক সময়", "SGT": "সিঙ্গাপুর মানক সময়", "SRT": "সুরিনাম সময়", "TMST": "তুর্কমেনিস্তান গ্রীষ্মকালীন সময়", "TMT": "তুর্কমেনিস্তান মানক সময়", "UYST": "উরুগুয়ে গ্রীষ্মকালীন সময়", "UYT": "উরুগুয়ে মানক সময়", "VET": "ভেনেজুয়েলা সময়", "WARST": "পশ্চিমি আর্জেনটিনা গ্রীষ্মকালীন সময়", "WART": "পশ্চিমি আর্জেনটিনার প্রমাণ সময়", "WAST": "পশ্চিম আফ্রিকা গ্রীষ্মকালীন সময়", "WAT": "পশ্চিম আফ্রিকা মানক সময়", "WESZ": "পশ্চিম ইউরোপীয় গ্রীষ্মকালীন সময়", "WEZ": "পশ্চিম ইউরোপীয় মানক সময়", "WIB": "পশ্চিমী ইন্দোনেশিয়া সময়", "WIT": "পূর্ব ইন্দোনেশিয়া সময়", "WITA": "কেন্দ্রীয় ইন্দোনেশিয়া সময়", "∅∅∅": "পেরু গ্রীষ্মকালীন সময়"},

			fnCardinalPluralRule:  fnCardinalPluralRule_75ab0b9c6a421f5e6ca85392796c18cc,
			fnDecimal:             fnDecimal_a78485e7dd32c95f41af4e18420793bf,
			fnFmtAccounting:       fnFmtAccounting_1df869b66b1bebb824de5401f039b55a,
			fnFmtCurrency:         fnFmtCurrency_ac4758b65e3186b6295da12d015494cf,
			fnFmtDateFull:         fnFmtDateFull_bd1b45bc043b6b4e8c3b831b9263891b,
			fnFmtDateLong:         fnFmtDateLong_a234d460b585eebc392634bc08485ebd,
			fnFmtDateMedium:       fnFmtDateMedium_5e450105cccbc820e4514899ef73128f,
			fnFmtDateShort:        fnFmtDateShort_f44877b6023a2d0fb0de41f9e2966ad0,
			fnFmtNumber:           fnFmtNumber_d7ae7636100e1f19a61ae0ac52b51e8c,
			fnFmtPercent:          fnFmtPercent_1c35b3868bf10d0e69b22b2e80c40671,
			fnFmtTimeFull:         fnFmtTimeFull_37fe4deeee789852cc196a6a1a2f0ccc,
			fnFmtTimeLong:         fnFmtTimeLong_4429ef4fb58a2a9c4d7d5132fd16ecbf,
			fnFmtTimeMedium:       fnFmtTimeMedium_8ef07f6477b7a4944577d4e5392ff21b,
			fnFmtTimeShort:        fnFmtTimeShort_8288b817c5c0216c9815524c71c9e0b4,
			fnGroup:               fnGroup_5c4b80a5ccdee81467241784ab8fcd56,
			fnLocale:              fnLocale_5a217059c67094defae82f249f55f4c5,
			fnMinus:               fnMinus_8b8229905258388dc16a5e0c270b0488,
			fnMonthAbbreviated:    fnMonthAbbreviated_aa9a9957cd9d056ba078b36a08b17478,
			fnMonthNarrow:         fnMonthNarrow_45916040ecf6fc350894d9e3e6c46dc7,
			fnMonthWide:           fnMonthWide_4c946a7e7581c665e7407df1841810b5,
			fnMonthsAbbreviated:   fnMonthsAbbreviated_181f77804b62232997fae36bd57d6cf7,
			fnMonthsNarrow:        fnMonthsNarrow_75daa2ba82ae9577292175c3f52370cc,
			fnMonthsWide:          fnMonthsWide_0ecf36a8b72255e2fee9467af362e989,
			fnOrdinalPluralRule:   fnOrdinalPluralRule_2d950970290e57f43f401dd367ad94dc,
			fnPluralsCardinal:     fnPluralsCardinal_85b19cac1fab9f2c2cfb9eb41539aa0e,
			fnPluralsOrdinal:      fnPluralsOrdinal_16a60aa09da9778fa82fe463e83076de,
			fnPluralsRange:        fnPluralsRange_332465bda13eb808b3664fa0500f54ce,
			fnRangePluralRule:     fnRangePluralRule_f6915080a9290ab0c1dd0a3b010cbce8,
			fnWeekdayAbbreviated:  fnWeekdayAbbreviated_4ffbdfbd2be10e6bd8fb5a542a14664a,
			fnWeekdayNarrow:       fnWeekdayNarrow_e86921b3446df5ea9afe9504cfa20d1a,
			fnWeekdayShort:        fnWeekdayShort_82b231d4f504c6d71c7e495aa35cd3c2,
			fnWeekdayWide:         fnWeekdayWide_ab7e026d8685cefd89c5aeb5df512a9a,
			fnWeekdaysAbbreviated: fnWeekdaysAbbreviated_454a3d7d23c662520a64ae5245d404be,
			fnWeekdaysNarrow:      fnWeekdaysNarrow_d23eb0b7a498c40ce19d1bf231cad524,
			fnWeekdaysShort:       fnWeekdaysShort_eb6ee64d01e314991432b4469790d38b,
			fnWeekdaysWide:        fnWeekdaysWide_5e2bbf75a31e730429c100e8a0bd3ebd,
		}
	}
	translatorFuncs["bn_in"] = func() locales.Translator {
		return &localen{

			locale:             "bn_IN",
			pluralsCardinal:    []locales.PluralRule{2, 6},
			pluralsOrdinal:     []locales.PluralRule{2, 3, 4, 5, 6},
			pluralsRange:       []locales.PluralRule{2, 6},
			decimal:            ".",
			group:              ",",
			minus:              "-",
			percent:            "%",
			perMille:           "‰",
			timeSeparator:      ":",
			inifinity:          "∞",
			currencies:         []string{"ADP", "AED", "AFA", "AFN", "ALK", "ALL", "AMD", "ANG", "AOA", "AOK", "AON", "AOR", "ARA", "ARL", "ARM", "ARP", "ARS", "ATS", "AUD", "AWG", "AZM", "AZN", "BAD", "BAM", "BAN", "BBD", "BDT", "BEC", "BEF", "BEL", "BGL", "BGM", "BGN", "BGO", "BHD", "BIF", "BMD", "BND", "BOB", "BOL", "BOP", "BOV", "BRB", "BRC", "BRE", "BRL", "BRN", "BRR", "BRZ", "BSD", "BTN", "BUK", "BWP", "BYB", "BYN", "BYR", "BZD", "CAD", "CDF", "CHE", "CHF", "CHW", "CLE", "CLF", "CLP", "CNH", "CNX", "CNY", "COP", "COU", "CRC", "CSD", "CSK", "CUC", "CUP", "CVE", "CYP", "CZK", "DDM", "DEM", "DJF", "DKK", "DOP", "DZD", "ECS", "ECV", "EEK", "EGP", "ERN", "ESA", "ESB", "ESP", "ETB", "EUR", "FIM", "FJD", "FKP", "FRF", "GBP", "GEK", "GEL", "GHC", "GHS", "GIP", "GMD", "GNF", "GNS", "GQE", "GRD", "GTQ", "GWE", "GWP", "GYD", "HKD", "HNL", "HRD", "HRK", "HTG", "HUF", "IDR", "IEP", "ILP", "ILR", "ILS", "INR", "IQD", "IRR", "ISJ", "ISK", "ITL", "JMD", "JOD", "JPY", "KES", "KGS", "KHR", "KMF", "KPW", "KRH", "KRO", "KRW", "KWD", "KYD", "KZT", "LAK", "LBP", "LKR", "LRD", "LSL", "LTL", "LTT", "LUC", "LUF", "LUL", "LVL", "LVR", "LYD", "MAD", "MAF", "MCF", "MDC", "MDL", "MGA", "MGF", "MKD", "MKN", "MLF", "MMK", "MNT", "MOP", "MRO", "MRU", "MTL", "MTP", "MUR", "MVP", "MVR", "MWK", "MXN", "MXP", "MXV", "MYR", "MZE", "MZM", "MZN", "NAD", "NGN", "NIC", "NIO", "NLG", "NOK", "NPR", "NZD", "OMR", "PAB", "PEI", "PEN", "PES", "PGK", "PHP", "PKR", "PLN", "PLZ", "PTE", "PYG", "QAR", "RHD", "ROL", "RON", "RSD", "RUB", "RUR", "RWF", "SAR", "SBD", "SCR", "SDD", "SDG", "SDP", "SEK", "SGD", "SHP", "SIT", "SKK", "SLL", "SOS", "SRD", "SRG", "SSP", "STD", "STN", "SUR", "SVC", "SYP", "SZL", "THB", "TJR", "TJS", "TMM", "TMT", "TND", "TOP", "TPE", "TRL", "TRY", "TTD", "TWD", "TZS", "UAH", "UAK", "UGS", "UGX", "USD", "USN", "USS", "UYI", "UYP", "UYU", "UYW", "UZS", "VEB", "VEF", "VES", "VND", "VNN", "VUV", "WST", "XAF", "XAG", "XAU", "XBA", "XBB", "XBC", "XBD", "XCD", "XDR", "XEU", "XFO", "XFU", "XOF", "XPD", "XPF", "XPT", "XRE", "XSU", "XTS", "XUA", "XXX", "YDD", "YER", "YUD", "YUM", "YUN", "YUR", "ZAL", "ZAR", "ZMK", "ZMW", "ZRN", "ZRZ", "ZWD", "ZWL", "ZWR"},
			monthsAbbreviated:  []string{"", "জানু", "ফেব", "মার্চ", "এপ্রিল", "মে", "জুন", "জুলাই", "আগস্ট", "সেপ্টেম্বর", "অক্টোবর", "নভেম্বর", "ডিসেম্বর"},
			monthsNarrow:       []string{"", "জা", "ফে", "মা", "এ", "মে", "জুন", "জু", "আ", "সে", "অ", "ন", "ডি"},
			monthsWide:         []string{"", "জানুয়ারী", "ফেব্রুয়ারী", "মার্চ", "এপ্রিল", "মে", "জুন", "জুলাই", "আগস্ট", "সেপ্টেম্বর", "অক্টোবর", "নভেম্বর", "ডিসেম্বর"},
			daysAbbreviated:    []string{"রবি", "সোম", "মঙ্গল", "বুধ", "বৃহস্পতি", "শুক্র", "শনি"},
			daysNarrow:         []string{"র", "সো", "ম", "বু", "বৃ", "শু", "শ"},
			daysShort:          []string{"রঃ", "সোঃ", "মঃ", "বুঃ", "বৃঃ", "শুঃ", "শনি"},
			daysWide:           []string{"রবিবার", "সোমবার", "মঙ্গলবার", "বুধবার", "বৃহস্পতিবার", "শুক্রবার", "শনিবার"},
			periodsAbbreviated: []string{"AM", "PM"},
			periodsNarrow:      []string{"AM", "PM"},
			periodsWide:        []string{"AM", "PM"},
			erasAbbreviated:    []string{"খ্রিস্টপূর্ব", "খৃষ্টাব্দ"},
			erasNarrow:         []string{"", ""},
			erasWide:           []string{"খ্রিস্টপূর্ব", "খ্রীষ্টাব্দ"},
			timezones:          map[string]string{"ACDT": "অস্ট্রেলীয় কেন্দ্রীয় দিবালোক সময়", "ACST": "অস্ট্রেলীয় কেন্দ্রীয় মানক সময়", "ACWDT": "অস্ট্রেলীয় কেন্দ্রীয় পশ্চিমি দিবালোক সময়", "ACWST": "অস্ট্রেলীয় কেন্দ্রীয় পশ্চিমি মানক সময়", "ADT": "অতলান্তিক দিবালোক সময়", "AEDT": "অস্ট্রেলীয় পূর্ব দিবালোক সময়", "AEST": "অস্ট্রেলীয় পূর্ব মানক সময়", "AKDT": "আলাস্কা দিবালোক সময়", "AKST": "আলাস্কা মানক সময়", "ARST": "আর্জেন্টিনা গ্রীষ্মকালীন সময়", "ART": "আর্জেন্টিনা মানক সময়", "AST": "অতলান্তিক মানক সময়", "AWDT": "অস্ট্রেলীয় পশ্চিমি দিবালোক সময়", "AWST": "অস্ট্রেলীয় পশ্চিমি মানক সময়", "BOT": "বোলিভিয়া সময়", "BT": "ভুটান সময়", "CAT": "মধ্য আফ্রিকা সময়", "CDT": "কেন্দ্রীয় দিবালোক সময়", "CHADT": "চ্যাথাম দিবালোক সময়", "CHAST": "চ্যাথাম মানক সময়", "CLST": "চিলি গ্রীষ্মকালীন সময়", "CLT": "চিলি মানক সময়", "COST": "কোলোম্বিয়া গ্রীষ্মকালীন সময়", "COT": "কোলোম্বিয়া মানক সময়", "CST": "কেন্দ্রীয় মানক সময়", "ChST": "চামেরো মানক সময়", "EAT": "পূর্ব আফ্রিকা সময়", "ECT": "ইকুয়েডর সময়", "EDT": "পূর্বাঞ্চলের দিবালোক সময়", "EST": "পূর্বাঞ্চলের প্রমাণ সময়", "GFT": "ফরাসি গায়ানা সময়", "GMT": "গ্রীনিচ মিন টাইম", "GST": "উপসাগরীয় মানক সময়", "GYT": "গুয়ানা সময়", "HADT": "হাওয়াই-আলেউত দিবালোক সময়", "HAST": "হাওয়াই-আলেউত মানক সময়", "HAT": "নিউফাউন্ডল্যান্ড দিবালোক সময়", "HECU": "কিউবা দিবালোক সময়", "HEEG": "পূর্ব গ্রীনল্যান্ড গ্রীষ্মকালীন সময়", "HENOMX": "উত্তরপশ্চিম মেক্সিকোর দিনের সময়", "HEOG": "পশ্চিম গ্রীনল্যান্ড গ্রীষ্মকালীন সময়", "HEPM": "সেন্ট পিয়ের ও মিকেলন দিবালোক সময়", "HEPMX": "মেক্সিকান প্রশান্ত মহাসাগরীয় দিবালোক সময়", "HKST": "হং কং গ্রীষ্মকালীন সময়", "HKT": "হং কং মানক সময়", "HNCU": "কিউবা মানক সময়", "HNEG": "পূর্ব গ্রীনল্যান্ড মানক সময়", "HNNOMX": "উত্তরপশ্চিম মেক্সিকোর মানক সময়", "HNOG": "পশ্চিম গ্রীনল্যান্ড মানক সময়", "HNPM": "সেন্ট পিয়ের ও মিকেলন মানক সময়", "HNPMX": "মেক্সিকান প্রশান্ত মহসাগরীয় মানক সময়", "HNT": "নিউফাউন্ডল্যান্ড মানক সময়", "IST": "ভারতীয় মানক সময়", "JDT": "জাপান দিবালোক সময়", "JST": "জাপান মানক সময়", "LHDT": "লর্ড হাওয়ে দিবালোক মসয়", "LHST": "লর্ড হাওয়ে মানক মসয়", "MDT": "পার্বত্য অঞ্চলের দিনের সময়", "MESZ": "মধ্য ইউরোপীয় গ্রীষ্মকালীন সময়", "MEZ": "মধ্য ইউরোপীয় মানক সময়", "MST": "পার্বত্য অঞ্চলের প্রমাণ সময়", "MYT": "মালয়েশিয়া সময়", "NZDT": "নিউজিল্যান্ড দিবালোক সময়", "NZST": "নিউজিল্যান্ড মানক সময়", "OESZ": "পূর্ব ইউরোপীয় গ্রীষ্মকালীন সময়", "OEZ": "পূর্ব ইউরোপীয় মানক সময়", "PDT": "প্রশান্ত মহাসাগরীয় অঞ্চলের দিনের সময়", "PST": "প্রশান্ত মহাসাগরীয় অঞ্চলের মানক সময়", "SAST": "দক্ষিণ আফ্রিকা মানক সময়", "SGT": "সিঙ্গাপুর মানক সময়", "SRT": "সুরিনাম সময়", "TMST": "তুর্কমেনিস্তান গ্রীষ্মকালীন সময়", "TMT": "তুর্কমেনিস্তান মানক সময়", "UYST": "উরুগুয়ে গ্রীষ্মকালীন সময়", "UYT": "উরুগুয়ে মানক সময়", "VET": "ভেনেজুয়েলা সময়", "WARST": "পশ্চিমি আর্জেনটিনা গ্রীষ্মকালীন সময়", "WART": "পশ্চিমি আর্জেনটিনার প্রমাণ সময়", "WAST": "পশ্চিম আফ্রিকা গ্রীষ্মকালীন সময়", "WAT": "পশ্চিম আফ্রিকা মানক সময়", "WESZ": "পশ্চিম ইউরোপীয় গ্রীষ্মকালীন সময়", "WEZ": "পশ্চিম ইউরোপীয় মানক সময়", "WIB": "পশ্চিমী ইন্দোনেশিয়া সময়", "WIT": "পূর্ব ইন্দোনেশিয়া সময়", "WITA": "কেন্দ্রীয় ইন্দোনেশিয়া সময়", "∅∅∅": "অ্যামাজন গ্রীষ্মকালীন সময়"},

			fnCardinalPluralRule:  fnCardinalPluralRule_75ab0b9c6a421f5e6ca85392796c18cc,
			fnDecimal:             fnDecimal_a78485e7dd32c95f41af4e18420793bf,
			fnFmtAccounting:       fnFmtAccounting_1df869b66b1bebb824de5401f039b55a,
			fnFmtCurrency:         fnFmtCurrency_ac4758b65e3186b6295da12d015494cf,
			fnFmtDateFull:         fnFmtDateFull_bd1b45bc043b6b4e8c3b831b9263891b,
			fnFmtDateLong:         fnFmtDateLong_a234d460b585eebc392634bc08485ebd,
			fnFmtDateMedium:       fnFmtDateMedium_5e450105cccbc820e4514899ef73128f,
			fnFmtDateShort:        fnFmtDateShort_f44877b6023a2d0fb0de41f9e2966ad0,
			fnFmtNumber:           fnFmtNumber_d7ae7636100e1f19a61ae0ac52b51e8c,
			fnFmtPercent:          fnFmtPercent_1c35b3868bf10d0e69b22b2e80c40671,
			fnFmtTimeFull:         fnFmtTimeFull_37fe4deeee789852cc196a6a1a2f0ccc,
			fnFmtTimeLong:         fnFmtTimeLong_4429ef4fb58a2a9c4d7d5132fd16ecbf,
			fnFmtTimeMedium:       fnFmtTimeMedium_8ef07f6477b7a4944577d4e5392ff21b,
			fnFmtTimeShort:        fnFmtTimeShort_8288b817c5c0216c9815524c71c9e0b4,
			fnGroup:               fnGroup_5c4b80a5ccdee81467241784ab8fcd56,
			fnLocale:              fnLocale_5a217059c67094defae82f249f55f4c5,
			fnMinus:               fnMinus_8b8229905258388dc16a5e0c270b0488,
			fnMonthAbbreviated:    fnMonthAbbreviated_aa9a9957cd9d056ba078b36a08b17478,
			fnMonthNarrow:         fnMonthNarrow_45916040ecf6fc350894d9e3e6c46dc7,
			fnMonthWide:           fnMonthWide_4c946a7e7581c665e7407df1841810b5,
			fnMonthsAbbreviated:   fnMonthsAbbreviated_181f77804b62232997fae36bd57d6cf7,
			fnMonthsNarrow:        fnMonthsNarrow_75daa2ba82ae9577292175c3f52370cc,
			fnMonthsWide:          fnMonthsWide_0ecf36a8b72255e2fee9467af362e989,
			fnOrdinalPluralRule:   fnOrdinalPluralRule_2d950970290e57f43f401dd367ad94dc,
			fnPluralsCardinal:     fnPluralsCardinal_85b19cac1fab9f2c2cfb9eb41539aa0e,
			fnPluralsOrdinal:      fnPluralsOrdinal_16a60aa09da9778fa82fe463e83076de,
			fnPluralsRange:        fnPluralsRange_332465bda13eb808b3664fa0500f54ce,
			fnRangePluralRule:     fnRangePluralRule_f6915080a9290ab0c1dd0a3b010cbce8,
			fnWeekdayAbbreviated:  fnWeekdayAbbreviated_4ffbdfbd2be10e6bd8fb5a542a14664a,
			fnWeekdayNarrow:       fnWeekdayNarrow_e86921b3446df5ea9afe9504cfa20d1a,
			fnWeekdayShort:        fnWeekdayShort_82b231d4f504c6d71c7e495aa35cd3c2,
			fnWeekdayWide:         fnWeekdayWide_ab7e026d8685cefd89c5aeb5df512a9a,
			fnWeekdaysAbbreviated: fnWeekdaysAbbreviated_454a3d7d23c662520a64ae5245d404be,
			fnWeekdaysNarrow:      fnWeekdaysNarrow_d23eb0b7a498c40ce19d1bf231cad524,
			fnWeekdaysShort:       fnWeekdaysShort_eb6ee64d01e314991432b4469790d38b,
			fnWeekdaysWide:        fnWeekdaysWide_5e2bbf75a31e730429c100e8a0bd3ebd,
		}
	}
	translatorFuncs["bo"] = func() locales.Translator {
		return &localen{

			locale:                 "bo",
			pluralsCardinal:        []locales.PluralRule{6},
			pluralsOrdinal:         nil,
			pluralsRange:           nil,
			decimal:                ".",
			group:                  ",",
			timeSeparator:          ":",
			currencies:             []string{"ADP", "AED", "AFA", "AFN", "ALK", "ALL", "AMD", "ANG", "AOA", "AOK", "AON", "AOR", "ARA", "ARL", "ARM", "ARP", "ARS", "ATS", "AUD", "AWG", "AZM", "AZN", "BAD", "BAM", "BAN", "BBD", "BDT", "BEC", "BEF", "BEL", "BGL", "BGM", "BGN", "BGO", "BHD", "BIF", "BMD", "BND", "BOB", "BOL", "BOP", "BOV", "BRB", "BRC", "BRE", "BRL", "BRN", "BRR", "BRZ", "BSD", "BTN", "BUK", "BWP", "BYB", "BYN", "BYR", "BZD", "CAD", "CDF", "CHE", "CHF", "CHW", "CLE", "CLF", "CLP", "CNH", "CNX", "¥", "COP", "COU", "CRC", "CSD", "CSK", "CUC", "CUP", "CVE", "CYP", "CZK", "DDM", "DEM", "DJF", "DKK", "DOP", "DZD", "ECS", "ECV", "EEK", "EGP", "ERN", "ESA", "ESB", "ESP", "ETB", "EUR", "FIM", "FJD", "FKP", "FRF", "GBP", "GEK", "GEL", "GHC", "GHS", "GIP", "GMD", "GNF", "GNS", "GQE", "GRD", "GTQ", "GWE", "GWP", "GYD", "HKD", "HNL", "HRD", "HRK", "HTG", "HUF", "IDR", "IEP", "ILP", "ILR", "ILS", "INR", "IQD", "IRR", "ISJ", "ISK", "ITL", "JMD", "JOD", "JPY", "KES", "KGS", "KHR", "KMF", "KPW", "KRH", "KRO", "KRW", "KWD", "KYD", "KZT", "LAK", "LBP", "LKR", "LRD", "LSL", "LTL", "LTT", "LUC", "LUF", "LUL", "LVL", "LVR", "LYD", "MAD", "MAF", "MCF", "MDC", "MDL", "MGA", "MGF", "MKD", "MKN", "MLF", "MMK", "MNT", "MOP", "MRO", "MRU", "MTL", "MTP", "MUR", "MVP", "MVR", "MWK", "MXN", "MXP", "MXV", "MYR", "MZE", "MZM", "MZN", "NAD", "NGN", "NIC", "NIO", "NLG", "NOK", "NPR", "NZD", "OMR", "PAB", "PEI", "PEN", "PES", "PGK", "PHP", "PKR", "PLN", "PLZ", "PTE", "PYG", "QAR", "RHD", "ROL", "RON", "RSD", "RUB", "RUR", "RWF", "SAR", "SBD", "SCR", "SDD", "SDG", "SDP", "SEK", "SGD", "SHP", "SIT", "SKK", "SLL", "SOS", "SRD", "SRG", "SSP", "STD", "STN", "SUR", "SVC", "SYP", "SZL", "THB", "TJR", "TJS", "TMM", "TMT", "TND", "TOP", "TPE", "TRL", "TRY", "TTD", "TWD", "TZS", "UAH", "UAK", "UGS", "UGX", "USD", "USN", "USS", "UYI", "UYP", "UYU", "UYW", "UZS", "VEB", "VEF", "VES", "VND", "VNN", "VUV", "WST", "XAF", "XAG", "XAU", "XBA", "XBB", "XBC", "XBD", "XCD", "XDR", "XEU", "XFO", "XFU", "XOF", "XPD", "XPF", "XPT", "XRE", "XSU", "XTS", "XUA", "XXX", "YDD", "YER", "YUD", "YUM", "YUN", "YUR", "ZAL", "ZAR", "ZMK", "ZMW", "ZRN", "ZRZ", "ZWD", "ZWL", "ZWR"},
			currencyPositivePrefix: " ",
			currencyNegativePrefix: " ",
			monthsAbbreviated:      []string{"", "ཟླ་༡", "ཟླ་༢", "ཟླ་༣", "ཟླ་༤", "ཟླ་༥", "ཟླ་༦", "ཟླ་༧", "ཟླ་༨", "ཟླ་༩", "ཟླ་༡༠", "ཟླ་༡༡", "ཟླ་༡༢"},
			monthsWide:             []string{"", "ཟླ་བ་དང་པོ", "ཟླ་བ་གཉིས་པ", "ཟླ་བ་གསུམ་པ", "ཟླ་བ་བཞི་པ", "ཟླ་བ་ལྔ་པ", "ཟླ་བ་དྲུག་པ", "ཟླ་བ་བདུན་པ", "ཟླ་བ་བརྒྱད་པ", "ཟླ་བ་དགུ་པ", "ཟླ་བ་བཅུ་པ", "ཟླ་བ་བཅུ་གཅིག་པ", "ཟླ་བ་བཅུ་གཉིས་པ"},
			daysAbbreviated:        []string{"ཉི་མ་", "ཟླ་བ་", "མིག་དམར་", "ལྷག་པ་", "ཕུར་བུ་", "པ་སངས་", "སྤེན་པ་"},
			daysNarrow:             []string{"ཉི", "ཟླ", "མིག", "ལྷག", "ཕུར", "སངས", "སྤེན"},
			daysWide:               []string{"གཟའ་ཉི་མ་", "གཟའ་ཟླ་བ་", "གཟའ་མིག་དམར་", "གཟའ་ལྷག་པ་", "གཟའ་ཕུར་བུ་", "གཟའ་པ་སངས་", "གཟའ་སྤེན་པ་"},
			periodsAbbreviated:     []string{"སྔ་དྲོ་", "ཕྱི་དྲོ་"},
			periodsWide:            []string{"སྔ་དྲོ་", "ཕྱི་དྲོ་"},
			erasAbbreviated:        []string{"སྤྱི་ལོ་སྔོན་", "སྤྱི་ལོ་"},
			erasNarrow:             []string{"", ""},
			erasWide:               []string{"", ""},
			timezones:              map[string]string{"ACDT": "ACDT", "ACST": "ACST", "ACWDT": "ACWDT", "ACWST": "ACWST", "ADT": "ADT", "AEDT": "AEDT", "AEST": "AEST", "AKDT": "AKDT", "AKST": "AKST", "ARST": "ARST", "ART": "ART", "AST": "AST", "AWDT": "AWDT", "AWST": "AWST", "BOT": "BOT", "BT": "BT", "CAT": "CAT", "CDT": "CDT", "CHADT": "CHADT", "CHAST": "CHAST", "CLST": "CLST", "CLT": "CLT", "COST": "COST", "COT": "COT", "CST": "CST", "ChST": "ChST", "EAT": "EAT", "ECT": "ECT", "EDT": "EDT", "EST": "EST", "GFT": "GFT", "GMT": "GMT", "GST": "GST", "GYT": "GYT", "HADT": "HADT", "HAST": "HAST", "HAT": "HAT", "HECU": "HECU", "HEEG": "HEEG", "HENOMX": "HENOMX", "HEOG": "HEOG", "HEPM": "HEPM", "HEPMX": "HEPMX", "HKST": "HKST", "HKT": "HKT", "HNCU": "HNCU", "HNEG": "HNEG", "HNNOMX": "HNNOMX", "HNOG": "HNOG", "HNPM": "HNPM", "HNPMX": "HNPMX", "HNT": "HNT", "IST": "IST", "JDT": "JDT", "JST": "JST", "LHDT": "LHDT", "LHST": "LHST", "MDT": "MDT", "MESZ": "MESZ", "MEZ": "MEZ", "MST": "MST", "MYT": "MYT", "NZDT": "NZDT", "NZST": "NZST", "OESZ": "OESZ", "OEZ": "OEZ", "PDT": "PDT", "PST": "PST", "SAST": "SAST", "SGT": "SGT", "SRT": "SRT", "TMST": "TMST", "TMT": "TMT", "UYST": "UYST", "UYT": "UYT", "VET": "VET", "WARST": "WARST", "WART": "WART", "WAST": "WAST", "WAT": "WAT", "WESZ": "WESZ", "WEZ": "WEZ", "WIB": "WIB", "WIT": "WIT", "WITA": "WITA", "∅∅∅": "∅∅∅"},

			fnCardinalPluralRule:  fnCardinalPluralRule_18b4522c3f6126d1e01414d5e423288b,
			fnDecimal:             fnDecimal_a78485e7dd32c95f41af4e18420793bf,
			fnFmtAccounting:       fnFmtAccounting_44f743dae0936af6184f1cad1624e543,
			fnFmtCurrency:         fnFmtCurrency_53723702774dedd2122c38a68dcef3da,
			fnFmtDateFull:         fnFmtDateFull_753ec22cf63aa959d868252cf9690e9d,
			fnFmtDateLong:         fnFmtDateLong_7a6cbc22eb124572fde0cc182fbd1d3d,
			fnFmtDateMedium:       fnFmtDateMedium_6eb6d3d989d88a86345ec9bd5152286a,
			fnFmtDateShort:        fnFmtDateShort_93e0dc80e7e3deca3036cf894d743e0e,
			fnFmtNumber:           fnFmtNumber_74395470c4c29cb378d864498139a946,
			fnFmtPercent:          fnFmtPercent_a2e6b1aef5e145e790a5623d4a4e442c,
			fnFmtTimeFull:         fnFmtTimeFull_37fe4deeee789852cc196a6a1a2f0ccc,
			fnFmtTimeLong:         fnFmtTimeLong_4429ef4fb58a2a9c4d7d5132fd16ecbf,
			fnFmtTimeMedium:       fnFmtTimeMedium_8ef07f6477b7a4944577d4e5392ff21b,
			fnFmtTimeShort:        fnFmtTimeShort_8288b817c5c0216c9815524c71c9e0b4,
			fnGroup:               fnGroup_5c4b80a5ccdee81467241784ab8fcd56,
			fnLocale:              fnLocale_5a217059c67094defae82f249f55f4c5,
			fnMinus:               fnMinus_8b8229905258388dc16a5e0c270b0488,
			fnMonthAbbreviated:    fnMonthAbbreviated_aa9a9957cd9d056ba078b36a08b17478,
			fnMonthNarrow:         fnMonthNarrow_45916040ecf6fc350894d9e3e6c46dc7,
			fnMonthWide:           fnMonthWide_4c946a7e7581c665e7407df1841810b5,
			fnMonthsAbbreviated:   fnMonthsAbbreviated_181f77804b62232997fae36bd57d6cf7,
			fnMonthsNarrow:        fnMonthsNarrow_1edc513af8c7151dc8fe1f42c7d497ba,
			fnMonthsWide:          fnMonthsWide_0ecf36a8b72255e2fee9467af362e989,
			fnOrdinalPluralRule:   fnOrdinalPluralRule_a0e5467912a746c396065750c68e4318,
			fnPluralsCardinal:     fnPluralsCardinal_85b19cac1fab9f2c2cfb9eb41539aa0e,
			fnPluralsOrdinal:      fnPluralsOrdinal_16a60aa09da9778fa82fe463e83076de,
			fnPluralsRange:        fnPluralsRange_332465bda13eb808b3664fa0500f54ce,
			fnRangePluralRule:     fnRangePluralRule_e0f62e2cf3ae7407fb4b54d084341c0b,
			fnWeekdayAbbreviated:  fnWeekdayAbbreviated_4ffbdfbd2be10e6bd8fb5a542a14664a,
			fnWeekdayNarrow:       fnWeekdayNarrow_e86921b3446df5ea9afe9504cfa20d1a,
			fnWeekdayShort:        fnWeekdayShort_82b231d4f504c6d71c7e495aa35cd3c2,
			fnWeekdayWide:         fnWeekdayWide_ab7e026d8685cefd89c5aeb5df512a9a,
			fnWeekdaysAbbreviated: fnWeekdaysAbbreviated_454a3d7d23c662520a64ae5245d404be,
			fnWeekdaysNarrow:      fnWeekdaysNarrow_d23eb0b7a498c40ce19d1bf231cad524,
			fnWeekdaysShort:       fnWeekdaysShort_eb6ee64d01e314991432b4469790d38b,
			fnWeekdaysWide:        fnWeekdaysWide_5e2bbf75a31e730429c100e8a0bd3ebd,
		}
	}
	translatorFuncs["bo_cn"] = func() locales.Translator {
		return &localen{

			locale:                 "bo_CN",
			pluralsCardinal:        []locales.PluralRule{6},
			pluralsOrdinal:         nil,
			pluralsRange:           nil,
			decimal:                ".",
			group:                  ",",
			timeSeparator:          ":",
			currencies:             []string{"ADP", "AED", "AFA", "AFN", "ALK", "ALL", "AMD", "ANG", "AOA", "AOK", "AON", "AOR", "ARA", "ARL", "ARM", "ARP", "ARS", "ATS", "AUD", "AWG", "AZM", "AZN", "BAD", "BAM", "BAN", "BBD", "BDT", "BEC", "BEF", "BEL", "BGL", "BGM", "BGN", "BGO", "BHD", "BIF", "BMD", "BND", "BOB", "BOL", "BOP", "BOV", "BRB", "BRC", "BRE", "BRL", "BRN", "BRR", "BRZ", "BSD", "BTN", "BUK", "BWP", "BYB", "BYN", "BYR", "BZD", "CAD", "CDF", "CHE", "CHF", "CHW", "CLE", "CLF", "CLP", "CNH", "CNX", "CNY", "COP", "COU", "CRC", "CSD", "CSK", "CUC", "CUP", "CVE", "CYP", "CZK", "DDM", "DEM", "DJF", "DKK", "DOP", "DZD", "ECS", "ECV", "EEK", "EGP", "ERN", "ESA", "ESB", "ESP", "ETB", "EUR", "FIM", "FJD", "FKP", "FRF", "GBP", "GEK", "GEL", "GHC", "GHS", "GIP", "GMD", "GNF", "GNS", "GQE", "GRD", "GTQ", "GWE", "GWP", "GYD", "HKD", "HNL", "HRD", "HRK", "HTG", "HUF", "IDR", "IEP", "ILP", "ILR", "ILS", "INR", "IQD", "IRR", "ISJ", "ISK", "ITL", "JMD", "JOD", "JPY", "KES", "KGS", "KHR", "KMF", "KPW", "KRH", "KRO", "KRW", "KWD", "KYD", "KZT", "LAK", "LBP", "LKR", "LRD", "LSL", "LTL", "LTT", "LUC", "LUF", "LUL", "LVL", "LVR", "LYD", "MAD", "MAF", "MCF", "MDC", "MDL", "MGA", "MGF", "MKD", "MKN", "MLF", "MMK", "MNT", "MOP", "MRO", "MRU", "MTL", "MTP", "MUR", "MVP", "MVR", "MWK", "MXN", "MXP", "MXV", "MYR", "MZE", "MZM", "MZN", "NAD", "NGN", "NIC", "NIO", "NLG", "NOK", "NPR", "NZD", "OMR", "PAB", "PEI", "PEN", "PES", "PGK", "PHP", "PKR", "PLN", "PLZ", "PTE", "PYG", "QAR", "RHD", "ROL", "RON", "RSD", "RUB", "RUR", "RWF", "SAR", "SBD", "SCR", "SDD", "SDG", "SDP", "SEK", "SGD", "SHP", "SIT", "SKK", "SLL", "SOS", "SRD", "SRG", "SSP", "STD", "STN", "SUR", "SVC", "SYP", "SZL", "THB", "TJR", "TJS", "TMM", "TMT", "TND", "TOP", "TPE", "TRL", "TRY", "TTD", "TWD", "TZS", "UAH", "UAK", "UGS", "UGX", "USD", "USN", "USS", "UYI", "UYP", "UYU", "UYW", "UZS", "VEB", "VEF", "VES", "VND", "VNN", "VUV", "WST", "XAF", "XAG", "XAU", "XBA", "XBB", "XBC", "XBD", "XCD", "XDR", "XEU", "XFO", "XFU", "XOF", "XPD", "XPF", "XPT", "XRE", "XSU", "XTS", "XUA", "XXX", "YDD", "YER", "YUD", "YUM", "YUN", "YUR", "ZAL", "ZAR", "ZMK", "ZMW", "ZRN", "ZRZ", "ZWD", "ZWL", "ZWR"},
			currencyPositivePrefix: " ",
			currencyNegativePrefix: " ",
			monthsAbbreviated:      []string{"", "ཟླ་༡", "ཟླ་༢", "ཟླ་༣", "ཟླ་༤", "ཟླ་༥", "ཟླ་༦", "ཟླ་༧", "ཟླ་༨", "ཟླ་༩", "ཟླ་༡༠", "ཟླ་༡༡", "ཟླ་༡༢"},
			monthsWide:             []string{"", "ཟླ་བ་དང་པོ", "ཟླ་བ་གཉིས་པ", "ཟླ་བ་གསུམ་པ", "ཟླ་བ་བཞི་པ", "ཟླ་བ་ལྔ་པ", "ཟླ་བ་དྲུག་པ", "ཟླ་བ་བདུན་པ", "ཟླ་བ་བརྒྱད་པ", "ཟླ་བ་དགུ་པ", "ཟླ་བ་བཅུ་པ", "ཟླ་བ་བཅུ་གཅིག་པ", "ཟླ་བ་བཅུ་གཉིས་པ"},
			daysAbbreviated:        []string{"ཉི་མ་", "ཟླ་བ་", "མིག་དམར་", "ལྷག་པ་", "ཕུར་བུ་", "པ་སངས་", "སྤེན་པ་"},
			daysNarrow:             []string{"ཉི", "ཟླ", "མིག", "ལྷག", "ཕུར", "སངས", "སྤེན"},
			daysWide:               []string{"གཟའ་ཉི་མ་", "གཟའ་ཟླ་བ་", "གཟའ་མིག་དམར་", "གཟའ་ལྷག་པ་", "གཟའ་ཕུར་བུ་", "གཟའ་པ་སངས་", "གཟའ་སྤེན་པ་"},
			periodsAbbreviated:     []string{"སྔ་དྲོ་", "ཕྱི་དྲོ་"},
			periodsWide:            []string{"སྔ་དྲོ་", "ཕྱི་དྲོ་"},
			erasAbbreviated:        []string{"སྤྱི་ལོ་སྔོན་", "སྤྱི་ལོ་"},
			erasNarrow:             []string{"", ""},
			erasWide:               []string{"", ""},
			timezones:              map[string]string{"ACDT": "ACDT", "ACST": "ACST", "ACWDT": "ACWDT", "ACWST": "ACWST", "ADT": "ADT", "AEDT": "AEDT", "AEST": "AEST", "AKDT": "AKDT", "AKST": "AKST", "ARST": "ARST", "ART": "ART", "AST": "AST", "AWDT": "AWDT", "AWST": "AWST", "BOT": "BOT", "BT": "BT", "CAT": "CAT", "CDT": "CDT", "CHADT": "CHADT", "CHAST": "CHAST", "CLST": "CLST", "CLT": "CLT", "COST": "COST", "COT": "COT", "CST": "CST", "ChST": "ChST", "EAT": "EAT", "ECT": "ECT", "EDT": "EDT", "EST": "EST", "GFT": "GFT", "GMT": "GMT", "GST": "GST", "GYT": "GYT", "HADT": "HADT", "HAST": "HAST", "HAT": "HAT", "HECU": "HECU", "HEEG": "HEEG", "HENOMX": "HENOMX", "HEOG": "HEOG", "HEPM": "HEPM", "HEPMX": "HEPMX", "HKST": "HKST", "HKT": "HKT", "HNCU": "HNCU", "HNEG": "HNEG", "HNNOMX": "HNNOMX", "HNOG": "HNOG", "HNPM": "HNPM", "HNPMX": "HNPMX", "HNT": "HNT", "IST": "IST", "JDT": "JDT", "JST": "JST", "LHDT": "LHDT", "LHST": "LHST", "MDT": "MDT", "MESZ": "MESZ", "MEZ": "MEZ", "MST": "MST", "MYT": "MYT", "NZDT": "NZDT", "NZST": "NZST", "OESZ": "OESZ", "OEZ": "OEZ", "PDT": "PDT", "PST": "PST", "SAST": "SAST", "SGT": "SGT", "SRT": "SRT", "TMST": "TMST", "TMT": "TMT", "UYST": "UYST", "UYT": "UYT", "VET": "VET", "WARST": "WARST", "WART": "WART", "WAST": "WAST", "WAT": "WAT", "WESZ": "WESZ", "WEZ": "WEZ", "WIB": "WIB", "WIT": "WIT", "WITA": "WITA", "∅∅∅": "∅∅∅"},

			fnCardinalPluralRule:  fnCardinalPluralRule_18b4522c3f6126d1e01414d5e423288b,
			fnDecimal:             fnDecimal_a78485e7dd32c95f41af4e18420793bf,
			fnFmtAccounting:       fnFmtAccounting_44f743dae0936af6184f1cad1624e543,
			fnFmtCurrency:         fnFmtCurrency_53723702774dedd2122c38a68dcef3da,
			fnFmtDateFull:         fnFmtDateFull_753ec22cf63aa959d868252cf9690e9d,
			fnFmtDateLong:         fnFmtDateLong_7a6cbc22eb124572fde0cc182fbd1d3d,
			fnFmtDateMedium:       fnFmtDateMedium_6eb6d3d989d88a86345ec9bd5152286a,
			fnFmtDateShort:        fnFmtDateShort_93e0dc80e7e3deca3036cf894d743e0e,
			fnFmtNumber:           fnFmtNumber_74395470c4c29cb378d864498139a946,
			fnFmtPercent:          fnFmtPercent_a2e6b1aef5e145e790a5623d4a4e442c,
			fnFmtTimeFull:         fnFmtTimeFull_37fe4deeee789852cc196a6a1a2f0ccc,
			fnFmtTimeLong:         fnFmtTimeLong_4429ef4fb58a2a9c4d7d5132fd16ecbf,
			fnFmtTimeMedium:       fnFmtTimeMedium_8ef07f6477b7a4944577d4e5392ff21b,
			fnFmtTimeShort:        fnFmtTimeShort_8288b817c5c0216c9815524c71c9e0b4,
			fnGroup:               fnGroup_5c4b80a5ccdee81467241784ab8fcd56,
			fnLocale:              fnLocale_5a217059c67094defae82f249f55f4c5,
			fnMinus:               fnMinus_8b8229905258388dc16a5e0c270b0488,
			fnMonthAbbreviated:    fnMonthAbbreviated_aa9a9957cd9d056ba078b36a08b17478,
			fnMonthNarrow:         fnMonthNarrow_45916040ecf6fc350894d9e3e6c46dc7,
			fnMonthWide:           fnMonthWide_4c946a7e7581c665e7407df1841810b5,
			fnMonthsAbbreviated:   fnMonthsAbbreviated_181f77804b62232997fae36bd57d6cf7,
			fnMonthsNarrow:        fnMonthsNarrow_1edc513af8c7151dc8fe1f42c7d497ba,
			fnMonthsWide:          fnMonthsWide_0ecf36a8b72255e2fee9467af362e989,
			fnOrdinalPluralRule:   fnOrdinalPluralRule_a0e5467912a746c396065750c68e4318,
			fnPluralsCardinal:     fnPluralsCardinal_85b19cac1fab9f2c2cfb9eb41539aa0e,
			fnPluralsOrdinal:      fnPluralsOrdinal_16a60aa09da9778fa82fe463e83076de,
			fnPluralsRange:        fnPluralsRange_332465bda13eb808b3664fa0500f54ce,
			fnRangePluralRule:     fnRangePluralRule_e0f62e2cf3ae7407fb4b54d084341c0b,
			fnWeekdayAbbreviated:  fnWeekdayAbbreviated_4ffbdfbd2be10e6bd8fb5a542a14664a,
			fnWeekdayNarrow:       fnWeekdayNarrow_e86921b3446df5ea9afe9504cfa20d1a,
			fnWeekdayShort:        fnWeekdayShort_82b231d4f504c6d71c7e495aa35cd3c2,
			fnWeekdayWide:         fnWeekdayWide_ab7e026d8685cefd89c5aeb5df512a9a,
			fnWeekdaysAbbreviated: fnWeekdaysAbbreviated_454a3d7d23c662520a64ae5245d404be,
			fnWeekdaysNarrow:      fnWeekdaysNarrow_d23eb0b7a498c40ce19d1bf231cad524,
			fnWeekdaysShort:       fnWeekdaysShort_eb6ee64d01e314991432b4469790d38b,
			fnWeekdaysWide:        fnWeekdaysWide_5e2bbf75a31e730429c100e8a0bd3ebd,
		}
	}
	translatorFuncs["bo_in"] = func() locales.Translator {
		return &localen{

			locale:                 "bo_IN",
			pluralsCardinal:        []locales.PluralRule{6},
			pluralsOrdinal:         nil,
			pluralsRange:           nil,
			decimal:                ".",
			group:                  ",",
			timeSeparator:          ":",
			currencies:             []string{"ADP", "AED", "AFA", "AFN", "ALK", "ALL", "AMD", "ANG", "AOA", "AOK", "AON", "AOR", "ARA", "ARL", "ARM", "ARP", "ARS", "ATS", "AUD", "AWG", "AZM", "AZN", "BAD", "BAM", "BAN", "BBD", "BDT", "BEC", "BEF", "BEL", "BGL", "BGM", "BGN", "BGO", "BHD", "BIF", "BMD", "BND", "BOB", "BOL", "BOP", "BOV", "BRB", "BRC", "BRE", "BRL", "BRN", "BRR", "BRZ", "BSD", "BTN", "BUK", "BWP", "BYB", "BYN", "BYR", "BZD", "CAD", "CDF", "CHE", "CHF", "CHW", "CLE", "CLF", "CLP", "CNH", "CNX", "CN¥", "COP", "COU", "CRC", "CSD", "CSK", "CUC", "CUP", "CVE", "CYP", "CZK", "DDM", "DEM", "DJF", "DKK", "DOP", "DZD", "ECS", "ECV", "EEK", "EGP", "ERN", "ESA", "ESB", "ESP", "ETB", "EUR", "FIM", "FJD", "FKP", "FRF", "GBP", "GEK", "GEL", "GHC", "GHS", "GIP", "GMD", "GNF", "GNS", "GQE", "GRD", "GTQ", "GWE", "GWP", "GYD", "HKD", "HNL", "HRD", "HRK", "HTG", "HUF", "IDR", "IEP", "ILP", "ILR", "ILS", "INR", "IQD", "IRR", "ISJ", "ISK", "ITL", "JMD", "JOD", "JPY", "KES", "KGS", "KHR", "KMF", "KPW", "KRH", "KRO", "KRW", "KWD", "KYD", "KZT", "LAK", "LBP", "LKR", "LRD", "LSL", "LTL", "LTT", "LUC", "LUF", "LUL", "LVL", "LVR", "LYD", "MAD", "MAF", "MCF", "MDC", "MDL", "MGA", "MGF", "MKD", "MKN", "MLF", "MMK", "MNT", "MOP", "MRO", "MRU", "MTL", "MTP", "MUR", "MVP", "MVR", "MWK", "MXN", "MXP", "MXV", "MYR", "MZE", "MZM", "MZN", "NAD", "NGN", "NIC", "NIO", "NLG", "NOK", "NPR", "NZD", "OMR", "PAB", "PEI", "PEN", "PES", "PGK", "PHP", "PKR", "PLN", "PLZ", "PTE", "PYG", "QAR", "RHD", "ROL", "RON", "RSD", "RUB", "RUR", "RWF", "SAR", "SBD", "SCR", "SDD", "SDG", "SDP", "SEK", "SGD", "SHP", "SIT", "SKK", "SLL", "SOS", "SRD", "SRG", "SSP", "STD", "STN", "SUR", "SVC", "SYP", "SZL", "THB", "TJR", "TJS", "TMM", "TMT", "TND", "TOP", "TPE", "TRL", "TRY", "TTD", "TWD", "TZS", "UAH", "UAK", "UGS", "UGX", "USD", "USN", "USS", "UYI", "UYP", "UYU", "UYW", "UZS", "VEB", "VEF", "VES", "VND", "VNN", "VUV", "WST", "XAF", "XAG", "XAU", "XBA", "XBB", "XBC", "XBD", "XCD", "XDR", "XEU", "XFO", "XFU", "XOF", "XPD", "XPF", "XPT", "XRE", "XSU", "XTS", "XUA", "XXX", "YDD", "YER", "YUD", "YUM", "YUN", "YUR", "ZAL", "ZAR", "ZMK", "ZMW", "ZRN", "ZRZ", "ZWD", "ZWL", "ZWR"},
			currencyPositivePrefix: " ",
			currencyNegativePrefix: " ",
			monthsAbbreviated:      []string{"", "ཟླ་༡", "ཟླ་༢", "ཟླ་༣", "ཟླ་༤", "ཟླ་༥", "ཟླ་༦", "ཟླ་༧", "ཟླ་༨", "ཟླ་༩", "ཟླ་༡༠", "ཟླ་༡༡", "ཟླ་༡༢"},
			monthsWide:             []string{"", "ཟླ་བ་དང་པོ", "ཟླ་བ་གཉིས་པ", "ཟླ་བ་གསུམ་པ", "ཟླ་བ་བཞི་པ", "ཟླ་བ་ལྔ་པ", "ཟླ་བ་དྲུག་པ", "ཟླ་བ་བདུན་པ", "ཟླ་བ་བརྒྱད་པ", "ཟླ་བ་དགུ་པ", "ཟླ་བ་བཅུ་པ", "ཟླ་བ་བཅུ་གཅིག་པ", "ཟླ་བ་བཅུ་གཉིས་པ"},
			daysAbbreviated:        []string{"ཉི་མ་", "ཟླ་བ་", "མིག་དམར་", "ལྷག་པ་", "ཕུར་བུ་", "པ་སངས་", "སྤེན་པ་"},
			daysNarrow:             []string{"ཉི", "ཟླ", "མིག", "ལྷག", "ཕུར", "སངས", "སྤེན"},
			daysWide:               []string{"གཟའ་ཉི་མ་", "གཟའ་ཟླ་བ་", "གཟའ་མིག་དམར་", "གཟའ་ལྷག་པ་", "གཟའ་ཕུར་བུ་", "གཟའ་པ་སངས་", "གཟའ་སྤེན་པ་"},
			periodsAbbreviated:     []string{"སྔ་དྲོ་", "ཕྱི་དྲོ་"},
			periodsWide:            []string{"སྔ་དྲོ་", "ཕྱི་དྲོ་"},
			erasAbbreviated:        []string{"སྤྱི་ལོ་སྔོན་", "སྤྱི་ལོ་"},
			erasNarrow:             []string{"", ""},
			erasWide:               []string{"", ""},
			timezones:              map[string]string{"ACDT": "ACDT", "ACST": "ACST", "ACWDT": "ACWDT", "ACWST": "ACWST", "ADT": "ADT", "AEDT": "AEDT", "AEST": "AEST", "AKDT": "AKDT", "AKST": "AKST", "ARST": "ARST", "ART": "ART", "AST": "AST", "AWDT": "AWDT", "AWST": "AWST", "BOT": "BOT", "BT": "BT", "CAT": "CAT", "CDT": "CDT", "CHADT": "CHADT", "CHAST": "CHAST", "CLST": "CLST", "CLT": "CLT", "COST": "COST", "COT": "COT", "CST": "CST", "ChST": "ChST", "EAT": "EAT", "ECT": "ECT", "EDT": "EDT", "EST": "EST", "GFT": "GFT", "GMT": "GMT", "GST": "GST", "GYT": "GYT", "HADT": "HADT", "HAST": "HAST", "HAT": "HAT", "HECU": "HECU", "HEEG": "HEEG", "HENOMX": "HENOMX", "HEOG": "HEOG", "HEPM": "HEPM", "HEPMX": "HEPMX", "HKST": "HKST", "HKT": "HKT", "HNCU": "HNCU", "HNEG": "HNEG", "HNNOMX": "HNNOMX", "HNOG": "HNOG", "HNPM": "HNPM", "HNPMX": "HNPMX", "HNT": "HNT", "IST": "IST", "JDT": "JDT", "JST": "JST", "LHDT": "LHDT", "LHST": "LHST", "MDT": "MDT", "MESZ": "MESZ", "MEZ": "MEZ", "MST": "MST", "MYT": "MYT", "NZDT": "NZDT", "NZST": "NZST", "OESZ": "OESZ", "OEZ": "OEZ", "PDT": "PDT", "PST": "PST", "SAST": "SAST", "SGT": "SGT", "SRT": "SRT", "TMST": "TMST", "TMT": "TMT", "UYST": "UYST", "UYT": "UYT", "VET": "VET", "WARST": "WARST", "WART": "WART", "WAST": "WAST", "WAT": "WAT", "WESZ": "WESZ", "WEZ": "WEZ", "WIB": "WIB", "WIT": "WIT", "WITA": "WITA", "∅∅∅": "∅∅∅"},

			fnCardinalPluralRule:  fnCardinalPluralRule_18b4522c3f6126d1e01414d5e423288b,
			fnDecimal:             fnDecimal_a78485e7dd32c95f41af4e18420793bf,
			fnFmtAccounting:       fnFmtAccounting_44f743dae0936af6184f1cad1624e543,
			fnFmtCurrency:         fnFmtCurrency_53723702774dedd2122c38a68dcef3da,
			fnFmtDateFull:         fnFmtDateFull_753ec22cf63aa959d868252cf9690e9d,
			fnFmtDateLong:         fnFmtDateLong_7a6cbc22eb124572fde0cc182fbd1d3d,
			fnFmtDateMedium:       fnFmtDateMedium_6eb6d3d989d88a86345ec9bd5152286a,
			fnFmtDateShort:        fnFmtDateShort_93e0dc80e7e3deca3036cf894d743e0e,
			fnFmtNumber:           fnFmtNumber_74395470c4c29cb378d864498139a946,
			fnFmtPercent:          fnFmtPercent_a2e6b1aef5e145e790a5623d4a4e442c,
			fnFmtTimeFull:         fnFmtTimeFull_37fe4deeee789852cc196a6a1a2f0ccc,
			fnFmtTimeLong:         fnFmtTimeLong_4429ef4fb58a2a9c4d7d5132fd16ecbf,
			fnFmtTimeMedium:       fnFmtTimeMedium_8ef07f6477b7a4944577d4e5392ff21b,
			fnFmtTimeShort:        fnFmtTimeShort_8288b817c5c0216c9815524c71c9e0b4,
			fnGroup:               fnGroup_5c4b80a5ccdee81467241784ab8fcd56,
			fnLocale:              fnLocale_5a217059c67094defae82f249f55f4c5,
			fnMinus:               fnMinus_8b8229905258388dc16a5e0c270b0488,
			fnMonthAbbreviated:    fnMonthAbbreviated_aa9a9957cd9d056ba078b36a08b17478,
			fnMonthNarrow:         fnMonthNarrow_45916040ecf6fc350894d9e3e6c46dc7,
			fnMonthWide:           fnMonthWide_4c946a7e7581c665e7407df1841810b5,
			fnMonthsAbbreviated:   fnMonthsAbbreviated_181f77804b62232997fae36bd57d6cf7,
			fnMonthsNarrow:        fnMonthsNarrow_1edc513af8c7151dc8fe1f42c7d497ba,
			fnMonthsWide:          fnMonthsWide_0ecf36a8b72255e2fee9467af362e989,
			fnOrdinalPluralRule:   fnOrdinalPluralRule_a0e5467912a746c396065750c68e4318,
			fnPluralsCardinal:     fnPluralsCardinal_85b19cac1fab9f2c2cfb9eb41539aa0e,
			fnPluralsOrdinal:      fnPluralsOrdinal_16a60aa09da9778fa82fe463e83076de,
			fnPluralsRange:        fnPluralsRange_332465bda13eb808b3664fa0500f54ce,
			fnRangePluralRule:     fnRangePluralRule_e0f62e2cf3ae7407fb4b54d084341c0b,
			fnWeekdayAbbreviated:  fnWeekdayAbbreviated_4ffbdfbd2be10e6bd8fb5a542a14664a,
			fnWeekdayNarrow:       fnWeekdayNarrow_e86921b3446df5ea9afe9504cfa20d1a,
			fnWeekdayShort:        fnWeekdayShort_82b231d4f504c6d71c7e495aa35cd3c2,
			fnWeekdayWide:         fnWeekdayWide_ab7e026d8685cefd89c5aeb5df512a9a,
			fnWeekdaysAbbreviated: fnWeekdaysAbbreviated_454a3d7d23c662520a64ae5245d404be,
			fnWeekdaysNarrow:      fnWeekdaysNarrow_d23eb0b7a498c40ce19d1bf231cad524,
			fnWeekdaysShort:       fnWeekdaysShort_eb6ee64d01e314991432b4469790d38b,
			fnWeekdaysWide:        fnWeekdaysWide_5e2bbf75a31e730429c100e8a0bd3ebd,
		}
	}
	translatorFuncs["br"] = func() locales.Translator {
		return &localen{

			locale:                 "br",
			pluralsCardinal:        []locales.PluralRule{2, 3, 4, 5, 6},
			pluralsOrdinal:         nil,
			pluralsRange:           nil,
			decimal:                ",",
			group:                  " ",
			minus:                  "-",
			percent:                "%",
			perMille:               "‰",
			timeSeparator:          ":",
			inifinity:              "∞",
			currencies:             []string{"ADP", "AED", "AFA", "AFN", "ALK", "ALL", "AMD", "ANG", "AOA", "AOK", "AON", "AOR", "ARA", "ARL", "ARM", "ARP", "ARS", "ATS", "$A", "AWG", "AZM", "AZN", "BAD", "BAM", "BAN", "BBD", "BDT", "BEC", "BEF", "BEL", "BGL", "BGM", "BGN", "BGO", "BHD", "BIF", "BMD", "BND", "BOB", "BOL", "BOP", "BOV", "BRB", "BRC", "BRE", "BRL", "BRN", "BRR", "BRZ", "BSD", "BTN", "BUK", "BWP", "BYB", "BYN", "BYR", "BZD", "$CA", "CDF", "CHE", "CHF", "CHW", "CLE", "CLF", "CLP", "CNH", "CNX", "CNY", "COP", "COU", "CRC", "CSD", "CSK", "CUC", "CUP", "CVE", "CYP", "CZK", "DDM", "DEM", "DJF", "DKK", "DOP", "DZD", "ECS", "ECV", "EEK", "EGP", "ERN", "ESA", "ESB", "ESP", "ETB", "€", "FIM", "FJD", "FKP", "FRF", "£ RU", "GEK", "GEL", "GHC", "GHS", "GIP", "GMD", "GNF", "GNS", "GQE", "GRD", "GTQ", "GWE", "GWP", "GYD", "$ HK", "HNL", "HRD", "HRK", "HTG", "HUF", "IDR", "IEP", "ILP", "ILR", "ILS", "₹", "IQD", "IRR", "ISJ", "ISK", "ITL", "JMD", "JOD", "JPY", "KES", "KGS", "KHR", "KMF", "KPW", "KRH", "KRO", "KRW", "KWD", "KYD", "KZT", "LAK", "LBP", "LKR", "LRD", "LSL", "LTL", "LTT", "LUC", "LUF", "LUL", "LVL", "LVR", "LYD", "MAD", "MAF", "MCF", "MDC", "MDL", "MGA", "MGF", "MKD", "MKN", "MLF", "MMK", "MNT", "MOP", "MRO", "MRU", "MTL", "MTP", "MUR", "MVP", "MVR", "MWK", "MX$", "MXP", "MXV", "MYR", "MZE", "MZM", "MZN", "NAD", "NGN", "NIC", "NIO", "NLG", "NOK", "NPR", "$ ZN", "OMR", "PAB", "PEI", "PEN", "PES", "PGK", "PHP", "PKR", "PLN", "PLZ", "PTE", "PYG", "QAR", "RHD", "ROL", "RON", "RSD", "RUB", "RUR", "RWF", "SAR", "SBD", "SCR", "SDD", "SDG", "SDP", "SEK", "SGD", "SHP", "SIT", "SKK", "SLL", "SOS", "SRD", "SRG", "SSP", "STD", "Db", "SUR", "SVC", "SYP", "SZL", "THB", "TJR", "TJS", "TMM", "TMT", "TND", "TOP", "TPE", "TRL", "TRY", "TTD", "TWD", "TZS", "UAH", "UAK", "UGS", "UGX", "$ SU", "USN", "USS", "UYI", "UYP", "UYU", "UYW", "UZS", "VEB", "VEF", "VES", "VND", "VNN", "VUV", "WST", "FCFA", "XAG", "XAU", "XBA", "XBB", "XBC", "XBD", "XCD", "XDR", "XEU", "XFO", "XFU", "CFA", "XPD", "CFPF", "XPT", "XRE", "XSU", "XTS", "XUA", "XXX", "YDD", "YER", "YUD", "YUM", "YUN", "YUR", "ZAL", "ZAR", "ZMK", "ZMW", "ZRN", "ZRZ", "ZWD", "ZWL", "ZWR"},
			percentSuffix:          " ",
			currencyPositiveSuffix: " ",
			currencyNegativeSuffix: " ",
			monthsAbbreviated:      []string{"", "Gen.", "Cʼhwe.", "Meur.", "Ebr.", "Mae", "Mezh.", "Goue.", "Eost", "Gwen.", "Here", "Du", "Kzu."},
			monthsNarrow:           []string{"", "01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12"},
			monthsWide:             []string{"", "Genver", "Cʼhwevrer", "Meurzh", "Ebrel", "Mae", "Mezheven", "Gouere", "Eost", "Gwengolo", "Here", "Du", "Kerzu"},
			daysAbbreviated:        []string{"Sul", "Lun", "Meu.", "Mer.", "Yaou", "Gwe.", "Sad."},
			daysNarrow:             []string{"Su", "L", "Mz", "Mc", "Y", "G", "Sa"},
			daysShort:              []string{"Sul", "Lun", "Meu.", "Mer.", "Yaou", "Gwe.", "Sad."},
			daysWide:               []string{"Sul", "Lun", "Meurzh", "Mercʼher", "Yaou", "Gwener", "Sadorn"},
			periodsAbbreviated:     []string{"A.M.", "G.M."},
			periodsNarrow:          []string{"am", "gm"},
			periodsWide:            []string{"A.M.", "G.M."},
			erasAbbreviated:        []string{"a-raok J.K.", "goude J.K."},
			erasNarrow:             []string{"a-raok J.K.", "goude J.K."},
			erasWide:               []string{"a-raok Jezuz-Krist", "goude Jezuz-Krist"},
			timezones:              map[string]string{"ACDT": "eur hañv Kreizaostralia", "ACST": "eur cʼhoañv Kreizaostralia", "ACWDT": "eur hañv Kreizaostralia ar Cʼhornôg", "ACWST": "eur cʼhoañv Kreizaostralia ar Cʼhornôg", "ADT": "eur hañv an Atlantel", "AEDT": "eur hañv Aostralia ar Reter", "AEST": "eur cʼhoañv Aostralia ar Reter", "AKDT": "eur hañv Alaska", "AKST": "eur cʼhoañv Alaska", "ARST": "eur hañv Arcʼhantina", "ART": "eur cʼhoañv Arcʼhantina", "AST": "eur cʼhoañv an Atlantel", "AWDT": "eur hañv Aostralia ar Cʼhornôg", "AWST": "eur cʼhoañv Aostralia ar Cʼhornôg", "BOT": "eur Bolivia", "BT": "eur Bhoutan", "CAT": "eur Kreizafrika", "CDT": "eur hañv ar Cʼhreiz", "CHADT": "eur hañv Chatham", "CHAST": "eur cʼhoañv Chatham", "CLST": "eur hañv Chile", "CLT": "eur cʼhoañv Chile", "COST": "eur hañv Kolombia", "COT": "eur cʼhoañv Kolombia", "CST": "eur cʼhoañv ar Cʼhreiz", "ChST": "eur Chamorro", "EAT": "eur Afrika ar Reter", "ECT": "eur Ecuador", "EDT": "eur hañv ar Reter", "EST": "eur cʼhoañv ar Reter", "GFT": "eur Gwiana cʼhall", "GMT": "Amzer keitat Greenwich (AKG)", "GST": "eur cʼhoañv ar Pleg-mor Arab-ha-Pers", "GYT": "eur Guyana", "HADT": "HADT", "HAST": "HAST", "HAT": "eur hañv Newfoundland", "HECU": "eur hañv Kuba", "HEEG": "eur hañv Greunland ar Reter", "HENOMX": "eur hañv Gwalarn Mecʼhiko", "HEOG": "eur hañv Greunland ar Cʼhornôg", "HEPM": "eur hañv Sant-Pêr-ha-Mikelon", "HEPMX": "HEPMX", "HKST": "eur hañv Hong Kong", "HKT": "eur cʼhoañv Hong Kong", "HNCU": "eur cʼhoañv Kuba", "HNEG": "eur cʼhoañv Greunland ar Reter", "HNNOMX": "eur cʼhoañv Gwalarn Mecʼhiko", "HNOG": "eur cʼhoañv Greunland ar Cʼhornôg", "HNPM": "eur cʼhoañv Sant-Pêr-ha-Mikelon", "HNPMX": "HNPMX", "HNT": "eur cʼhoañv Newfoundland", "IST": "eur cʼhoañv India", "JDT": "eur hañv Japan", "JST": "eur cʼhoañv Japan", "LHDT": "LHDT", "LHST": "LHST", "MDT": "eur hañv ar Menezioù", "MESZ": "eur hañv Kreizeuropa", "MEZ": "eur cʼhoañv Kreizeuropa", "MST": "eur cʼhoañv ar Menezioù", "MYT": "eur Malaysia", "NZDT": "eur hañv Zeland-Nevez", "NZST": "eur cʼhoañv Zeland-Nevez", "OESZ": "eur hañv Europa ar Reter", "OEZ": "eur cʼhoañv Europa ar Reter", "PDT": "eur hañv an Habask", "PST": "eur cʼhoañv an Habask", "SAST": "eur cʼhoañv Suafrika", "SGT": "eur cʼhoañv Singapour", "SRT": "eur Surinam", "TMST": "eur hañv Turkmenistan", "TMT": "eur cʼhoañv Turkmenistan", "UYST": "eur hañv Uruguay", "UYT": "eur cʼhoañv Uruguay", "VET": "eur Venezuela", "WARST": "eur hañv Arcʼhantina ar Cʼhornôg", "WART": "eur cʼhoañv Arcʼhantina ar Cʼhornôg", "WAST": "eur hañv Afrika ar Cʼhornôg", "WAT": "eur cʼhoañv Afrika ar Cʼhornôg", "WESZ": "eur hañv Europa ar Cʼhornôg", "WEZ": "eur cʼhoañv Europa ar Cʼhornôg", "WIB": "eur Indonezia ar Cʼhornôg", "WIT": "eur Indonezia ar Reter", "WITA": "eur Kreiz Indonezia", "∅∅∅": "eur hañv Perou"},

			fnCardinalPluralRule:  fnCardinalPluralRule_3fb30797479a030a43141dadf528c83c,
			fnDecimal:             fnDecimal_a78485e7dd32c95f41af4e18420793bf,
			fnFmtAccounting:       fnFmtAccounting_a62648328d65f4275e2e521198233607,
			fnFmtCurrency:         fnFmtCurrency_04d2836e8ee5922750958599d99ccc13,
			fnFmtDateFull:         fnFmtDateFull_e5aac3b796a648ed7f4aaa501e4e3844,
			fnFmtDateLong:         fnFmtDateLong_506f643cda0514f66d873a9ea99bf639,
			fnFmtDateMedium:       fnFmtDateMedium_cb43e8c32d5cd0a27ac6db293a7981fd,
			fnFmtDateShort:        fnFmtDateShort_529ba7a02bedd437d0833b1afdb768c8,
			fnFmtNumber:           fnFmtNumber_0866206624669dc4f03297eb76a545b2,
			fnFmtPercent:          fnFmtPercent_fcc1fa1bb5725d058e89da9d97be1c70,
			fnFmtTimeFull:         fnFmtTimeFull_ebdf96de1e47f9043145564c500ef7dc,
			fnFmtTimeLong:         fnFmtTimeLong_987bec4676d3a5de4218e415e123649d,
			fnFmtTimeMedium:       fnFmtTimeMedium_b6f697552cd4965cd1195fe56dc87003,
			fnFmtTimeShort:        fnFmtTimeShort_8ffba4d1a2f04a0a6486853d76cf434b,
			fnGroup:               fnGroup_5c4b80a5ccdee81467241784ab8fcd56,
			fnLocale:              fnLocale_5a217059c67094defae82f249f55f4c5,
			fnMinus:               fnMinus_8b8229905258388dc16a5e0c270b0488,
			fnMonthAbbreviated:    fnMonthAbbreviated_aa9a9957cd9d056ba078b36a08b17478,
			fnMonthNarrow:         fnMonthNarrow_45916040ecf6fc350894d9e3e6c46dc7,
			fnMonthWide:           fnMonthWide_4c946a7e7581c665e7407df1841810b5,
			fnMonthsAbbreviated:   fnMonthsAbbreviated_181f77804b62232997fae36bd57d6cf7,
			fnMonthsNarrow:        fnMonthsNarrow_75daa2ba82ae9577292175c3f52370cc,
			fnMonthsWide:          fnMonthsWide_0ecf36a8b72255e2fee9467af362e989,
			fnOrdinalPluralRule:   fnOrdinalPluralRule_a0e5467912a746c396065750c68e4318,
			fnPluralsCardinal:     fnPluralsCardinal_85b19cac1fab9f2c2cfb9eb41539aa0e,
			fnPluralsOrdinal:      fnPluralsOrdinal_16a60aa09da9778fa82fe463e83076de,
			fnPluralsRange:        fnPluralsRange_332465bda13eb808b3664fa0500f54ce,
			fnRangePluralRule:     fnRangePluralRule_e0f62e2cf3ae7407fb4b54d084341c0b,
			fnWeekdayAbbreviated:  fnWeekdayAbbreviated_4ffbdfbd2be10e6bd8fb5a542a14664a,
			fnWeekdayNarrow:       fnWeekdayNarrow_e86921b3446df5ea9afe9504cfa20d1a,
			fnWeekdayShort:        fnWeekdayShort_82b231d4f504c6d71c7e495aa35cd3c2,
			fnWeekdayWide:         fnWeekdayWide_ab7e026d8685cefd89c5aeb5df512a9a,
			fnWeekdaysAbbreviated: fnWeekdaysAbbreviated_454a3d7d23c662520a64ae5245d404be,
			fnWeekdaysNarrow:      fnWeekdaysNarrow_d23eb0b7a498c40ce19d1bf231cad524,
			fnWeekdaysShort:       fnWeekdaysShort_eb6ee64d01e314991432b4469790d38b,
			fnWeekdaysWide:        fnWeekdaysWide_5e2bbf75a31e730429c100e8a0bd3ebd,
		}
	}
	translatorFuncs["br_fr"] = func() locales.Translator {
		return &localen{

			locale:                 "br_FR",
			pluralsCardinal:        []locales.PluralRule{2, 3, 4, 5, 6},
			pluralsOrdinal:         nil,
			pluralsRange:           nil,
			decimal:                ",",
			group:                  " ",
			minus:                  "-",
			percent:                "%",
			perMille:               "‰",
			timeSeparator:          ":",
			inifinity:              "∞",
			currencies:             []string{"ADP", "AED", "AFA", "AFN", "ALK", "ALL", "AMD", "ANG", "AOA", "AOK", "AON", "AOR", "ARA", "ARL", "ARM", "ARP", "ARS", "ATS", "AUD", "AWG", "AZM", "AZN", "BAD", "BAM", "BAN", "BBD", "BDT", "BEC", "BEF", "BEL", "BGL", "BGM", "BGN", "BGO", "BHD", "BIF", "BMD", "BND", "BOB", "BOL", "BOP", "BOV", "BRB", "BRC", "BRE", "BRL", "BRN", "BRR", "BRZ", "BSD", "BTN", "BUK", "BWP", "BYB", "BYN", "BYR", "BZD", "CAD", "CDF", "CHE", "CHF", "CHW", "CLE", "CLF", "CLP", "CNH", "CNX", "CNY", "COP", "COU", "CRC", "CSD", "CSK", "CUC", "CUP", "CVE", "CYP", "CZK", "DDM", "DEM", "DJF", "DKK", "DOP", "DZD", "ECS", "ECV", "EEK", "EGP", "ERN", "ESA", "ESB", "ESP", "ETB", "EUR", "FIM", "FJD", "FKP", "FRF", "GBP", "GEK", "GEL", "GHC", "GHS", "GIP", "GMD", "GNF", "GNS", "GQE", "GRD", "GTQ", "GWE", "GWP", "GYD", "HKD", "HNL", "HRD", "HRK", "HTG", "HUF", "IDR", "IEP", "ILP", "ILR", "ILS", "INR", "IQD", "IRR", "ISJ", "ISK", "ITL", "JMD", "JOD", "JPY", "KES", "KGS", "KHR", "KMF", "KPW", "KRH", "KRO", "KRW", "KWD", "KYD", "KZT", "LAK", "LBP", "LKR", "LRD", "LSL", "LTL", "LTT", "LUC", "LUF", "LUL", "LVL", "LVR", "LYD", "MAD", "MAF", "MCF", "MDC", "MDL", "MGA", "MGF", "MKD", "MKN", "MLF", "MMK", "MNT", "MOP", "MRO", "MRU", "MTL", "MTP", "MUR", "MVP", "MVR", "MWK", "MXN", "MXP", "MXV", "MYR", "MZE", "MZM", "MZN", "NAD", "NGN", "NIC", "NIO", "NLG", "NOK", "NPR", "NZD", "OMR", "PAB", "PEI", "PEN", "PES", "PGK", "PHP", "PKR", "PLN", "PLZ", "PTE", "PYG", "QAR", "RHD", "ROL", "RON", "RSD", "RUB", "RUR", "RWF", "SAR", "SBD", "SCR", "SDD", "SDG", "SDP", "SEK", "SGD", "SHP", "SIT", "SKK", "SLL", "SOS", "SRD", "SRG", "SSP", "STD", "STN", "SUR", "SVC", "SYP", "SZL", "THB", "TJR", "TJS", "TMM", "TMT", "TND", "TOP", "TPE", "TRL", "TRY", "TTD", "TWD", "TZS", "UAH", "UAK", "UGS", "UGX", "USD", "USN", "USS", "UYI", "UYP", "UYU", "UYW", "UZS", "VEB", "VEF", "VES", "VND", "VNN", "VUV", "WST", "XAF", "XAG", "XAU", "XBA", "XBB", "XBC", "XBD", "XCD", "XDR", "XEU", "XFO", "XFU", "XOF", "XPD", "XPF", "XPT", "XRE", "XSU", "XTS", "XUA", "XXX", "YDD", "YER", "YUD", "YUM", "YUN", "YUR", "ZAL", "ZAR", "ZMK", "ZMW", "ZRN", "ZRZ", "ZWD", "ZWL", "ZWR"},
			percentSuffix:          " ",
			currencyPositiveSuffix: " ",
			currencyNegativeSuffix: " ",
			monthsAbbreviated:      []string{"", "Gen.", "Cʼhwe.", "Meur.", "Ebr.", "Mae", "Mezh.", "Goue.", "Eost", "Gwen.", "Here", "Du", "Kzu."},
			monthsNarrow:           []string{"", "01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12"},
			monthsWide:             []string{"", "Genver", "Cʼhwevrer", "Meurzh", "Ebrel", "Mae", "Mezheven", "Gouere", "Eost", "Gwengolo", "Here", "Du", "Kerzu"},
			daysAbbreviated:        []string{"Sul", "Lun", "Meu.", "Mer.", "Yaou", "Gwe.", "Sad."},
			daysNarrow:             []string{"Su", "L", "Mz", "Mc", "Y", "G", "Sa"},
			daysShort:              []string{"Sul", "Lun", "Meu.", "Mer.", "Yaou", "Gwe.", "Sad."},
			daysWide:               []string{"Sul", "Lun", "Meurzh", "Mercʼher", "Yaou", "Gwener", "Sadorn"},
			periodsAbbreviated:     []string{"A.M.", "G.M."},
			periodsNarrow:          []string{"am", "gm"},
			periodsWide:            []string{"A.M.", "G.M."},
			erasAbbreviated:        []string{"a-raok J.K.", "goude J.K."},
			erasNarrow:             []string{"a-raok J.K.", "goude J.K."},
			erasWide:               []string{"a-raok Jezuz-Krist", "goude Jezuz-Krist"},
			timezones:              map[string]string{"ACDT": "eur hañv Kreizaostralia", "ACST": "eur cʼhoañv Kreizaostralia", "ACWDT": "eur hañv Kreizaostralia ar Cʼhornôg", "ACWST": "eur cʼhoañv Kreizaostralia ar Cʼhornôg", "ADT": "eur hañv an Atlantel", "AEDT": "eur hañv Aostralia ar Reter", "AEST": "eur cʼhoañv Aostralia ar Reter", "AKDT": "eur hañv Alaska", "AKST": "eur cʼhoañv Alaska", "ARST": "eur hañv Arcʼhantina", "ART": "eur cʼhoañv Arcʼhantina", "AST": "eur cʼhoañv an Atlantel", "AWDT": "eur hañv Aostralia ar Cʼhornôg", "AWST": "eur cʼhoañv Aostralia ar Cʼhornôg", "BOT": "eur Bolivia", "BT": "eur Bhoutan", "CAT": "eur Kreizafrika", "CDT": "eur hañv ar Cʼhreiz", "CHADT": "eur hañv Chatham", "CHAST": "eur cʼhoañv Chatham", "CLST": "eur hañv Chile", "CLT": "eur cʼhoañv Chile", "COST": "eur hañv Kolombia", "COT": "eur cʼhoañv Kolombia", "CST": "eur cʼhoañv ar Cʼhreiz", "ChST": "eur Chamorro", "EAT": "eur Afrika ar Reter", "ECT": "eur Ecuador", "EDT": "eur hañv ar Reter", "EST": "eur cʼhoañv ar Reter", "GFT": "eur Gwiana cʼhall", "GMT": "Amzer keitat Greenwich (AKG)", "GST": "eur cʼhoañv ar Pleg-mor Arab-ha-Pers", "GYT": "eur Guyana", "HADT": "HADT", "HAST": "HAST", "HAT": "eur hañv Newfoundland", "HECU": "eur hañv Kuba", "HEEG": "eur hañv Greunland ar Reter", "HENOMX": "eur hañv Gwalarn Mecʼhiko", "HEOG": "eur hañv Greunland ar Cʼhornôg", "HEPM": "eur hañv Sant-Pêr-ha-Mikelon", "HEPMX": "HEPMX", "HKST": "eur hañv Hong Kong", "HKT": "eur cʼhoañv Hong Kong", "HNCU": "eur cʼhoañv Kuba", "HNEG": "eur cʼhoañv Greunland ar Reter", "HNNOMX": "eur cʼhoañv Gwalarn Mecʼhiko", "HNOG": "eur cʼhoañv Greunland ar Cʼhornôg", "HNPM": "eur cʼhoañv Sant-Pêr-ha-Mikelon", "HNPMX": "HNPMX", "HNT": "eur cʼhoañv Newfoundland", "IST": "eur cʼhoañv India", "JDT": "eur hañv Japan", "JST": "eur cʼhoañv Japan", "LHDT": "LHDT", "LHST": "LHST", "MDT": "eur hañv ar Menezioù", "MESZ": "eur hañv Kreizeuropa", "MEZ": "eur cʼhoañv Kreizeuropa", "MST": "eur cʼhoañv ar Menezioù", "MYT": "eur Malaysia", "NZDT": "eur hañv Zeland-Nevez", "NZST": "eur cʼhoañv Zeland-Nevez", "OESZ": "eur hañv Europa ar Reter", "OEZ": "eur cʼhoañv Europa ar Reter", "PDT": "eur hañv an Habask", "PST": "eur cʼhoañv an Habask", "SAST": "eur cʼhoañv Suafrika", "SGT": "eur cʼhoañv Singapour", "SRT": "eur Surinam", "TMST": "eur hañv Turkmenistan", "TMT": "eur cʼhoañv Turkmenistan", "UYST": "eur hañv Uruguay", "UYT": "eur cʼhoañv Uruguay", "VET": "eur Venezuela", "WARST": "eur hañv Arcʼhantina ar Cʼhornôg", "WART": "eur cʼhoañv Arcʼhantina ar Cʼhornôg", "WAST": "eur hañv Afrika ar Cʼhornôg", "WAT": "eur cʼhoañv Afrika ar Cʼhornôg", "WESZ": "eur hañv Europa ar Cʼhornôg", "WEZ": "eur cʼhoañv Europa ar Cʼhornôg", "WIB": "eur Indonezia ar Cʼhornôg", "WIT": "eur Indonezia ar Reter", "WITA": "eur Kreiz Indonezia", "∅∅∅": "eur hañv Brasília"},

			fnCardinalPluralRule:  fnCardinalPluralRule_3fb30797479a030a43141dadf528c83c,
			fnDecimal:             fnDecimal_a78485e7dd32c95f41af4e18420793bf,
			fnFmtAccounting:       fnFmtAccounting_a62648328d65f4275e2e521198233607,
			fnFmtCurrency:         fnFmtCurrency_04d2836e8ee5922750958599d99ccc13,
			fnFmtDateFull:         fnFmtDateFull_e5aac3b796a648ed7f4aaa501e4e3844,
			fnFmtDateLong:         fnFmtDateLong_506f643cda0514f66d873a9ea99bf639,
			fnFmtDateMedium:       fnFmtDateMedium_cb43e8c32d5cd0a27ac6db293a7981fd,
			fnFmtDateShort:        fnFmtDateShort_529ba7a02bedd437d0833b1afdb768c8,
			fnFmtNumber:           fnFmtNumber_0866206624669dc4f03297eb76a545b2,
			fnFmtPercent:          fnFmtPercent_fcc1fa1bb5725d058e89da9d97be1c70,
			fnFmtTimeFull:         fnFmtTimeFull_ebdf96de1e47f9043145564c500ef7dc,
			fnFmtTimeLong:         fnFmtTimeLong_987bec4676d3a5de4218e415e123649d,
			fnFmtTimeMedium:       fnFmtTimeMedium_b6f697552cd4965cd1195fe56dc87003,
			fnFmtTimeShort:        fnFmtTimeShort_8ffba4d1a2f04a0a6486853d76cf434b,
			fnGroup:               fnGroup_5c4b80a5ccdee81467241784ab8fcd56,
			fnLocale:              fnLocale_5a217059c67094defae82f249f55f4c5,
			fnMinus:               fnMinus_8b8229905258388dc16a5e0c270b0488,
			fnMonthAbbreviated:    fnMonthAbbreviated_aa9a9957cd9d056ba078b36a08b17478,
			fnMonthNarrow:         fnMonthNarrow_45916040ecf6fc350894d9e3e6c46dc7,
			fnMonthWide:           fnMonthWide_4c946a7e7581c665e7407df1841810b5,
			fnMonthsAbbreviated:   fnMonthsAbbreviated_181f77804b62232997fae36bd57d6cf7,
			fnMonthsNarrow:        fnMonthsNarrow_75daa2ba82ae9577292175c3f52370cc,
			fnMonthsWide:          fnMonthsWide_0ecf36a8b72255e2fee9467af362e989,
			fnOrdinalPluralRule:   fnOrdinalPluralRule_a0e5467912a746c396065750c68e4318,
			fnPluralsCardinal:     fnPluralsCardinal_85b19cac1fab9f2c2cfb9eb41539aa0e,
			fnPluralsOrdinal:      fnPluralsOrdinal_16a60aa09da9778fa82fe463e83076de,
			fnPluralsRange:        fnPluralsRange_332465bda13eb808b3664fa0500f54ce,
			fnRangePluralRule:     fnRangePluralRule_e0f62e2cf3ae7407fb4b54d084341c0b,
			fnWeekdayAbbreviated:  fnWeekdayAbbreviated_4ffbdfbd2be10e6bd8fb5a542a14664a,
			fnWeekdayNarrow:       fnWeekdayNarrow_e86921b3446df5ea9afe9504cfa20d1a,
			fnWeekdayShort:        fnWeekdayShort_82b231d4f504c6d71c7e495aa35cd3c2,
			fnWeekdayWide:         fnWeekdayWide_ab7e026d8685cefd89c5aeb5df512a9a,
			fnWeekdaysAbbreviated: fnWeekdaysAbbreviated_454a3d7d23c662520a64ae5245d404be,
			fnWeekdaysNarrow:      fnWeekdaysNarrow_d23eb0b7a498c40ce19d1bf231cad524,
			fnWeekdaysShort:       fnWeekdaysShort_eb6ee64d01e314991432b4469790d38b,
			fnWeekdaysWide:        fnWeekdaysWide_5e2bbf75a31e730429c100e8a0bd3ebd,
		}
	}
	translatorFuncs["brx"] = func() locales.Translator {
		return &localen{

			locale:                 "brx",
			pluralsCardinal:        []locales.PluralRule{2, 6},
			pluralsOrdinal:         nil,
			pluralsRange:           nil,
			decimal:                ".",
			group:                  ",",
			minus:                  "-",
			percent:                "%",
			perMille:               "‰",
			timeSeparator:          ":",
			inifinity:              "∞",
			currencies:             []string{"ADP", "AED", "AFA", "AFN", "ALK", "ALL", "AMD", "ANG", "AOA", "AOK", "AON", "AOR", "ARA", "ARL", "ARM", "ARP", "ARS", "ATS", "AUD", "AWG", "AZM", "AZN", "BAD", "BAM", "BAN", "BBD", "BDT", "BEC", "BEF", "BEL", "BGL", "BGM", "BGN", "BGO", "BHD", "BIF", "BMD", "BND", "BOB", "BOL", "BOP", "BOV", "BRB", "BRC", "BRE", "BRL", "BRN", "BRR", "BRZ", "BSD", "BTN", "BUK", "BWP", "BYB", "BYN", "BYR", "BZD", "CAD", "CDF", "CHE", "CHF", "CHW", "CLE", "CLF", "CLP", "CNH", "CNX", "CNY", "COP", "COU", "CRC", "CSD", "CSK", "CUC", "CUP", "CVE", "CYP", "CZK", "DDM", "DEM", "DJF", "DKK", "DOP", "DZD", "ECS", "ECV", "EEK", "EGP", "ERN", "ESA", "ESB", "ESP", "ETB", "EUR", "FIM", "FJD", "FKP", "FRF", "GBP", "GEK", "GEL", "GHC", "GHS", "GIP", "GMD", "GNF", "GNS", "GQE", "GRD", "GTQ", "GWE", "GWP", "GYD", "HKD", "HNL", "HRD", "HRK", "HTG", "HUF", "IDR", "IEP", "ILP", "ILR", "ILS", "INR", "IQD", "IRR", "ISJ", "ISK", "ITL", "JMD", "JOD", "JPY", "KES", "KGS", "KHR", "KMF", "KPW", "KRH", "KRO", "KRW", "KWD", "KYD", "KZT", "LAK", "LBP", "LKR", "LRD", "LSL", "LTL", "LTT", "LUC", "LUF", "LUL", "LVL", "LVR", "LYD", "MAD", "MAF", "MCF", "MDC", "MDL", "MGA", "MGF", "MKD", "MKN", "MLF", "MMK", "MNT", "MOP", "MRO", "MRU", "MTL", "MTP", "MUR", "MVP", "MVR", "MWK", "MXN", "MXP", "MXV", "MYR", "MZE", "MZM", "MZN", "NAD", "NGN", "NIC", "NIO", "NLG", "NOK", "NPR", "NZD", "OMR", "PAB", "PEI", "PEN", "PES", "PGK", "PHP", "PKR", "PLN", "PLZ", "PTE", "PYG", "QAR", "RHD", "ROL", "RON", "RSD", "RUB", "RUR", "RWF", "SAR", "SBD", "SCR", "SDD", "SDG", "SDP", "SEK", "SGD", "SHP", "SIT", "SKK", "SLL", "SOS", "SRD", "SRG", "SSP", "STD", "STN", "SUR", "SVC", "SYP", "SZL", "THB", "TJR", "TJS", "TMM", "TMT", "TND", "TOP", "TPE", "TRL", "TRY", "TTD", "TWD", "TZS", "UAH", "UAK", "UGS", "UGX", "USD", "USN", "USS", "UYI", "UYP", "UYU", "UYW", "UZS", "VEB", "VEF", "VES", "VND", "VNN", "VUV", "WST", "XAF", "XAG", "XAU", "XBA", "XBB", "XBC", "XBD", "XCD", "XDR", "XEU", "XFO", "XFU", "XOF", "XPD", "XPF", "XPT", "XRE", "XSU", "XTS", "XUA", "XXX", "YDD", "YER", "YUD", "YUM", "YUN", "YUR", "ZAL", "ZAR", "ZMK", "ZMW", "ZRN", "ZRZ", "ZWD", "ZWL", "ZWR"},
			currencyPositivePrefix: " ",
			currencyNegativePrefix: " ",
			monthsNarrow:           []string{"", "ज", "फे", "मा", "ए", "मे", "जु", "जु", "आ", "से", "अ", "न", "दि"},
			monthsWide:             []string{"", "जानुवारी", "फेब्रुवारी", "मार्स", "एफ्रिल", "मे", "जुन", "जुलाइ", "आगस्थ", "सेबथेज्ब़र", "अखथबर", "नबेज्ब़र", "दिसेज्ब़र"},
			daysAbbreviated:        []string{"रबि", "सम", "मंगल", "बुद", "बिसथि", "सुखुर", "सुनि"},
			daysNarrow:             []string{"र", "स", "मं", "बु", "बि", "सु", "सु"},
			daysWide:               []string{"रबिबार", "समबार", "मंगलबार", "बुदबार", "बिसथिबार", "सुखुरबार", "सुनिबार"},
			periodsAbbreviated:     []string{"फुं", "बेलासे"},
			periodsWide:            []string{"फुं", "बेलासे"},
			erasAbbreviated:        []string{"ईसा.पूर्व", "सन"},
			erasNarrow:             []string{"", ""},
			erasWide:               []string{"", ""},
			timezones:              map[string]string{"ACDT": "मध्य ओस्ट्रेलिया डेलाईट टाईम", "ACST": "मध्य ओस्ट्रेलिया स्टैंडर्ड टाईम", "ACWDT": "मध्य-पश्चीम ओस्ट्रेलिया डेलाईट टाईम", "ACWST": "मध्य-पश्चीम ओस्ट्रेलिया स्टैंडर्ड टाईम", "ADT": "अटलांटीक डेलाईट टाईम", "AEDT": "पूर्वी ओस्ट्रेलिया डेलाईट टाईम", "AEST": "पूर्वी ओस्ट्रेलिया स्टैंडर्ड टाईम", "AKDT": "अलास्का डेलाईट टाईम", "AKST": "अलास्का स्टैंडर्ड टाईम", "ARST": "अर्जण्टिना समर टाईम", "ART": "अर्जनटिना स्टैंडर्ड टाईम", "AST": "अटलांटीक स्टैंडर्ड टाईम", "AWDT": "दक्षिण ओस्ट्रेलिया डेलाईट टाईम", "AWST": "दक्षिण ओस्ट्रेलिया स्टैंडर्ड टाईम", "BOT": "बोलिविया स्टैंडर्ड टाईम", "BT": "भुटान स्टैंडर्ड टाईम", "CAT": "मध्य अफ्रीका स्टैंडर्ड टाईम", "CDT": "सैंट्रल अमरिका डेलाईट टाईम", "CHADT": "चैथम डेलाईट टाईम", "CHAST": "चैथम स्टैंडर्ड टाईम", "CLST": "चीली समर टाईम", "CLT": "चीली स्टैंडर्ड टाईम", "COST": "कोलंबिया समर टाईम", "COT": "कोलंबिया स्टैंडर्ड टाईम", "CST": "सैंट्रल अमरिका स्टैंडर्ड टाईम", "ChST": "चामरो स्टैंडर्ड टाईम", "EAT": "पूर्वी अफ्रीका स्टैंडर्ड टाईम", "ECT": "एक्वाडौर स्टैंडर्ड टाईम", "EDT": "ईस्टर्न अमरिका डेलाईट टाईम", "EST": "ईस्टर्न अमरिका स्टैंडर्ड टाईम", "GFT": "फ्रान्सीसी गुयाना स्टैंडर्ड टाईम", "GMT": "ग्रीनीच स्टैंडर्ड टाईम", "GST": "गल्फ़ स्टैंडर्ड टाईम", "GYT": "गुयाना स्टैंडर्ड टाईम", "HADT": "हवाई आलटन डेलाईट टाईम", "HAST": "हवाई आलटन स्टैंडर्ड टाईम", "HAT": "न्युफाऊंडलैण्ड डेलाईट टाईम", "HECU": "क्युबा डेलाईट टाईम", "HEEG": "ग्रीनलैण्ड ईस्टर्न समर टाईम", "HENOMX": "HENOMX", "HEOG": "ग्रीनलैण्ड वेस्टर्न समर टाईम", "HEPM": "सेँ पीयॅर एवं मीकलों डेलाईट टाईम", "HEPMX": "HEPMX", "HKST":